/* Ergo, version 3.3, a program for linear scaling electronic structure
 * calculations.
 * Copyright (C) 2013 Elias Rudberg, Emanuel H. Rubensson, and Pawel Salek.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Primary academic reference:
 * Kohn−Sham Density Functional Theory Electronic Structure Calculations 
 * with Linearly Scaling Computational Time and Memory Usage,
 * Elias Rudberg, Emanuel H. Rubensson, and Pawel Salek,
 * J. Chem. Theory Comput. 7, 340 (2011),
 * <http://dx.doi.org/10.1021/ct100611z>
 * 
 * For further information about Ergo, see <http://www.ergoscf.org>.
 */

/*-*-mode: C; c-indentation-style: "bsd"; c-basic-offset: 4; -*-*/
/** @file fun-pw92c.c  PW92C functional implementation.

   Automatically generated code implementing PW92C functional and
   its derivatives. It is generated by func-codegen.pl being a part of
   a "Automatic code generation framework for analytical functional
   derivative evaluation", Pawel Salek, 2005

    This functional is connected by making following changes:
    1. add "extern Functional pw92cFunctional;" to 'functionals.h'
    2. add "&pw92cFunctional," to 'functionals.c'
    3. add "fun-pw92c.c" to 'Makefile.am', 'Makefile.in' or 'Makefile'.

    This functional has been generated from following input:
    ------ cut here -------
rho:  rhoa + rhob;
grad: sqrt(grada*grada + gradb*gradb + 2*gradab);
zeta: (rhoa-rhob)/(rhoa+rhob);


kf : (3*%PI*%PI*rho)^(1/3);
g: ((1+zeta)^(2/3) + (1-zeta)^(2/3))/2;
ks: (4*kf/%PI)^(1/2);
t: grad/(2*g*ks*rho);

nu:(16/%PI)*(3*%PI^2)^(1/3);
_a:23.266;
_b:7.389e-3;
_c:8.723;
_d:0.472;
rs: (3/(4*%PI*rho))^(1/3);
Cxc:0.001*(2.568+_a*rs+_b*rs^2)/(1+_c*rs+_d*rs^2+10*_b*rs^3);
Cx:-0.001667;
Cc0:0.004235;
Ccr:Cxc-Cx;

alpha:0.09;
beta:nu*Cc0;

p: 1.00;
A_0 : 0.031091;
a1_0: 0.21370;
b1_0: 7.5957;
b2_0: 3.5876;
b3_0: 1.6382;
b4_0: 0.49294;

A_1 : 0.015545;
a1_1: 0.20548;
b1_1: 14.1189;
b2_1: 6.1977;
b3_1: 3.3662;
b4_1: 0.62517;

A_a : 0.016887;
a1_a: 0.11125;
b1_a: 10.357;
b2_a: 3.6231;
b3_a: 0.88026;
b4_a: 0.49671;

G_0: -2*A_0*(1+a1_0*rs)*log(1+(1/(2*A_0*(b1_0*rs^(1/2)+b2_0*rs+b3_0*rs^(3/2)+b4_0*rs^(p+1)))));
G_1: -2*A_1*(1+a1_1*rs)*log(1+(1/(2*A_1*(b1_1*rs^(1/2)+b2_1*rs+b3_1*rs^(3/2)+b4_1*rs^(p+1)))));
G_a: -2*A_a*(1+a1_a*rs)*log(1+(1/(2*A_a*(b1_a*rs^(1/2)+b2_a*rs+b3_a*rs^(3/2)+b4_a*rs^(p+1)))));

fz: ((1+zeta)^(4/3)+(1-zeta)^(4/3)-2)/(2^(4/3)-2);
f20:1.709921;
ec:G_0 - G_a*(fz/f20)*(1-zeta^4) + (G_1-G_0)*fz*zeta^4;

A:(2*alpha/beta)/(exp(-2*alpha*ec/(g^3*beta^2))-1);
H0: g^3*beta^2/(2*alpha)*log(1+(2*alpha/beta)*( (t^2+A*t^4)/(1+A*t^2+A^2*t^4) ));
H1: nu*(Ccr-Cc0-3*Cx/7)*g^3*t^2*exp(-100*g^4*(ks^2/kf^2)*t^2);

K(rhoa,grada,rhob,gradb,gradab):=rho*(H0+H1);


    ------ cut here -------
*/

 
/* strictly conform to XOPEN ANSI C standard */
#if !defined(SYS_DEC)
/* XOPEN compliance is missing on old Tru64 4.0E Alphas and pow() prototype
 * is not specified. */
#define _XOPEN_SOURCE          600
#define _XOPEN_SOURCE_EXTENDED 1
#endif
#include <math.h>
#include <stddef.h>
 
#define __CVERSION__
 
#include "functionals.h"
 
/* INTERFACE PART */
static int pw92c_isgga(void) { return 1; } /* FIXME: detect! */
static int pw92c_read(const char *conf_line);
static real pw92c_energy(const FunDensProp* dp);
static void pw92c_first(FunFirstFuncDrv *ds,   real factor,
                         const FunDensProp* dp);
static void pw92c_second(FunSecondFuncDrv *ds, real factor,
                          const FunDensProp* dp);
static void pw92c_third(FunThirdFuncDrv *ds,   real factor,
                         const FunDensProp* dp);
#ifdef FOURTH_ORDER_DERIVATIVES
static void pw92c_fourth(FunFourthFuncDrv *ds,   real factor,
                          const FunDensProp* dp);
#endif
 
Functional PW92cFunctional = {
  "PW92c",       /* name */
  pw92c_isgga,   /* gga-corrected */
  pw92c_read,
  NULL,
  pw92c_energy,
  pw92c_first,
  pw92c_second,
  pw92c_third
#ifdef FOURTH_ORDER_DERIVATIVES
  ,pw92c_fourth
#endif
};
 
/* IMPLEMENTATION PART */
static int
pw92c_read(const char *conf_line)
{
    fun_set_hf_weight(0);
    return 1;
}

static real
pw92c_energy(const FunDensProp *dp)
{
    real res;
    real rhoa = dp->rhoa, rhob = dp->rhob;
    real grada = dp->grada, gradb = dp->gradb, gradab = dp->gradab;

    real t1, t2, t3, t4, t5, t6, t7, t8, t9, t10;
    real t11, t12, t13, t14, t15, t16, t17, t18;
    real t19, t20, t21, t22, t23, t24, t25, t26;
    real t27, t28, t29, t30, t31, t32, t33, t34;
    real t35, t36, t37, t38, t39, t40, t41, t42;
    real t43, t44;

    t1 = rhob+rhoa;
    t2 = POW(gradb,2.0)+2.0*gradab+POW(grada,2.0);
    t3 = 1/POW(t1,2.333333333333333);
    t4 = rhoa-1.0*rhob;
    t5 = 1/t1;
    t6 = 1.0-1.0*t4*t5;
    t7 = t4*t5+1.0;
    t8 = POW(t7,0.666666666666667)+POW(t6,0.666666666666667);
    t9 = POW(3.0,
        0.666666666666667);
    t10 = 1/POW(4.0,0.666666666666667);
    t11 = POW(3.141592653589793,0.666666666666667);
    t12 = 1/t11;
    t13 = 1/POW(t1,0.666666666666667);
    t14 = POW(3.0,0.333333333333333);
    t15 = 1/POW(4.0,0.333333333333333);
    t16 = POW(3.141592653589793,0.333333333333333);
    t17 = 1/t16;
    t18 = 1/POW(t1,0.333333333333333);
    t19 = 1/t9;
    t20 = POW(3.141592653589793,1.333333333333333);
    t21 = POW(t8,2.0);
    t22 = POW(t8,3.0);
    t23 = 1/t14;
    t24 = 1/t21;
    t25 = POW(t2,2.0);
    t26 = 1/POW(t1,4.666666666666667);
    t27 = 1/POW(t8,4.0);
    t28 = 0.2137*t14*t15*t17*t18+1.0;
    t29 = 1/POW(t1,0.666666666666667);
    t30 = 1.732050807568877;
    t31 = 0.564189583547756;
    t32 = 1/SQRT(t1);
    t33 = POW(2.0,0.333333333333333);
    t34 = 1/t33;
    t35 = POW(3.0,0.166666666666667);
    t36 = 1/POW(3.141592653589793,0.166666666666667);
    t37 = 1/POW(t1,0.166666666666667);
    t38 = LOG(16.0818243221511/(7.5957*t34*t35*t36*t37+3.5876*
        t14*t15*t17*t18+0.8191*t30*t31*t32+0.189700432574756*t29)+
        1.0);
    t39 = 1/(2.0*t33-2.0);
    t40 = POW(t4,4.0);
    t41 = 1/POW(t1,4.0);
    t42 = POW(t7,1.333333333333333)+POW(t6,1.333333333333333)-
        2.0;
    t43 = 1/POW(2.718281828459045,313.6286274635529*t11*t19*
        (0.019751789702565*(0.11125*t14*t15*t17*t18+1.0)*LOG(29.60857464321668/
        (10.357*t34*t35*t36*t37+3.6231*t14*t15*t17*t18+0.44013*t30*
        t31*t32+0.191151259512734*t29)+1.0)*t39*(1.0-1.0*t40*t41)*
        t42+(0.062182*t28*t38-0.03109*(0.20548*t14*t15*t17*t18+1.0)*
        LOG(32.1646831778707/(14.1189*t34*t35*t36*t37+6.1977*t14*t15*
        t17*t18+1.6831*t30*t31*t32+0.240587129128819*t29)+1.0))*t39*
        t40*t41*t42-0.062182*t28*t38)/t22)-1.0;
    t44 = 1/t43;

   /* code */
    res = t1*(0.003188484444444*t12*t22*LOG(2.656434474616293*
        t16*t23*(0.173863229795775*t25*t26*t27*t44+0.25*t16*t2*t23*
        t24*t3)/(0.664108618654073*t19*t11*t2*t3*t24*t44+0.14701341912354*
        t20*t23*t25*t26*t27/POW(t43,2.0)+1.0)+1.0)*t9+0.5*t2*t3*(0.001*
        (23.266*t14*t15*t17*t18+0.007389*t9*t10*t12*t13+2.568)/(0.01763993811759*
        t5+8.723*t14*t15*t17*t18+0.472*t9*t10*t12*t13+1.0)-0.001853571428571)*
        t8/POW(2.718281828459045,6.25*t19*t2*t21/(POW(t1,2.666666666666667)*
        t20)));

    return res;
}

static void
pw92c_first(FunFirstFuncDrv *ds, real factor, const FunDensProp *dp)
{
    real dfdra, dfdrb, dfdga, dfdgb, dfdgab;
    real rhoa = dp->rhoa, rhob = dp->rhob;
    real grada = dp->grada, gradb = dp->gradb, gradab = dp->gradab;

    real t1, t2, t3, t4, t5, t6, t7, t8, t9, t10;
    real t11, t12, t13, t14, t15, t16, t17, t18;
    real t19, t20, t21, t22, t23, t24, t25, t26;
    real t27, t28, t29, t30, t31, t32, t33, t34;
    real t35, t36, t37, t38, t39, t40, t41, t42;
    real t43, t44, t45, t46, t47, t48, t49, t50;
    real t51, t52, t53, t54, t55, t56, t57, t58;
    real t59, t60, t61, t62, t63, t64, t65, t66;
    real t67, t68, t69, t70, t71, t72, t73, t74;
    real t75, t76, t77, t78, t79, t80, t81, t82;
    real t83, t84, t85, t86, t87, t88, t89, t90;
    real t91, t92, t93, t94, t95, t96, t97, t98;
    real t99, t100, t101, t102, t103, t104, t105;
    real t106, t107, t108, t109, t110, t111, t112;
    real t113, t114, t115, t116, t117, t118, t119;
    real t120, t121, t122, t123, t124;

    t1 = POW(gradb,2.0)+2.0*gradab+POW(grada,2.0);
    t2 = rhob+rhoa;
    t3 = 1/POW(t2,2.333333333333333);
    t4 = rhoa-1.0*rhob;
    t5 = 1/t2;
    t6 = 1.0-1.0*t4*t5;
    t7 = t4*t5+1.0;
    t8 = POW(t7,0.666666666666667)+POW(t6,0.666666666666667);
    t9 = 0.318309886183791;
    t10 = POW(3.0,
        0.666666666666667);
    t11 = 1/POW(4.0,0.666666666666667);
    t12 = POW(3.141592653589793,0.666666666666667);
    t13 = 1/t12;
    t14 = 1/POW(t2,0.666666666666667);
    t15 = POW(3.0,0.333333333333333);
    t16 = 1/POW(4.0,0.333333333333333);
    t17 = POW(3.141592653589793,0.333333333333333);
    t18 = 1/t17;
    t19 = 1/POW(t2,0.333333333333333);
    t20 = 0.0554175*t9*t5+8.723*t15*t16*t18*t19+0.472*t10*
        t11*t13*t14+1.0;
    t21 = 1/t20;
    t22 = 23.266*t15*t16*t18*t19+0.007389*t10*t11*t13*t14+
        2.568;
    t23 = 0.001*t21*t22-0.001853571428571;
    t24 = 1/t10;
    t25 = POW(3.141592653589793,1.333333333333333);
    t26 = 1/t25;
    t27 = 1/POW(t2,2.666666666666667);
    t28 = POW(t8,2.0);
    t29 = 1/POW(2.718281828459045,6.25*t1*t24*t26*t27*t28);
    t30 = 0.5*
        t1*t23*t29*t3*t8;
    t31 = POW(t8,3.0);
    t32 = 1/t15;
    t33 = 1/t28;
    t34 = POW(t1,2.0);
    t35 = 1/POW(t2,4.666666666666667);
    t36 = 1/POW(t8,4.0);
    t37 = 1/t31;
    t38 = 0.2137*t15*t16*t18*t19+1.0;
    t39 = 1/POW(t2,0.666666666666667);
    t40 = 1.732050807568877;
    t41 = 0.564189583547756;
    t42 = SQRT(t2);
    t43 = 1/t42;
    t44 = POW(2.0,0.333333333333333);
    t45 = 1/t44;
    t46 = POW(3.0,0.166666666666667);
    t47 = 1/POW(3.141592653589793,0.166666666666667);
    t48 = 1/POW(t2,0.166666666666667);
    t49 = 7.5957*t45*t46*t47*t48+3.5876*t15*t16*t18*t19+0.8191*
        t40*t41*t43+0.189700432574756*t39;
    t50 = 16.0818243221511/t49+1.0;
    t51 = LOG(t50);
    t52 = 1/(2.0*t44-2.0);
    t53 = POW(t4,4.0);
    t54 = 1/POW(t2,4.0);
    t55 = 1.0-1.0*t53*t54;
    t56 = 0.11125*t15*t16*t18*t19+1.0;
    t57 = POW(t7,1.333333333333333)+POW(t6,1.333333333333333)-
        2.0;
    t58 = 10.357*t45*t46*t47*t48+3.6231*t15*t16*t18*t19+0.44013*
        t40*t41*t43+0.191151259512734*t39;
    t59 = 29.60857464321668/t58+1.0;
    t60 = LOG(t59);
    t61 = 0.20548*t15*t16*t18*t19+1.0;
    t62 = 14.1189*t45*t46*t47*t48+6.1977*t15*t16*t18*t19+
        1.6831*t40*t41*t43+0.240587129128819*t39;
    t63 = 32.1646831778707/t62+1.0;
    t64 = LOG(t63);
    t65 = 0.062182*t38*t51-0.03109*t61*t64;
    t66 = t52*t53*t54*t57*t65+0.019751789702565*t52*t55*t56*
        t57*t60-0.062182*t38*t51;
    t67 = 1/POW(2.718281828459045,313.6286274635529*t24*t12*
        t37*t66);
    t68 = t67-1.0;
    t69 = 1/t68;
    t70 = 0.173863229795775*t34*t35*t36*t69+0.25*t1*t17*t3*
        t32*t33;
    t71 = 1/POW(t68,2.0);
    t72 = 0.14701341912354*t32*t25*t34*t35*t36*t71+0.664108618654073*
        t24*t12*t1*t3*t33*t69+1.0;
    t73 = 1/t72;
    t74 = 2.656434474616293*t32*t17*t70*t73+1.0;
    t75 = LOG(t74);
    t76 = 0.003188484444444*t10*t13*t31*t75;
    t77 = 1/POW(t2,1.666666666666667);
    t78 = 1/POW(t2,1.333333333333333);
    t79 = 1/POW(t2,2.0);
    t80 = 0.5*t1*t29*t3*(0.001*(-7.755333333333333*t15*t16*
        t18*t78-0.004926*t10*t11*t13*t77)*t21-0.001*t22*(-2.907666666666667*
        t15*t16*t18*t78-0.314666666666667*t10*t11*t13*t77-0.0554175*
        t9*t79)/POW(t20,2.0))*t8;
    t81 = t4*t79;
    t82 = -1.0*t5;
    t83 = t82+t81;
    t84 = POW(t6,0.333333333333333);
    t85 = 1/t84;
    t86 = -1.0*t4*t79;
    t87 = t5+t86;
    t88 = POW(t7,0.333333333333333);
    t89 = 1/t88;
    t90 = 0.666666666666667*t87*t89+0.666666666666667*t83*
        t85;
    t91 = 1/POW(t2,3.333333333333333);
    t92 = -1.166666666666667*t1*t23*t29*t8*t91;
    t93 = 16.66666666666667*t1*t24*t26*t28/POW(t2,3.666666666666667);
    t94 = 1/
        t74;
    t95 = -0.583333333333333*t1*t17*t32*t33*t91;
    t96 = 1/POW(t8,5.0);
    t97 = 1/POW(t2,5.666666666666667);
    t98 = -0.811361739046951*t34*t36*t69*t97;
    t99 = 1/POW(t2,1.666666666666667);
    t100 = 1/POW(t42,3.0);
    t101 = 1/POW(t2,1.166666666666667);
    t102 = -1.26595*t45*t46*t47*t101-1.195866666666667*t15*
        t16*t18*t78-0.40955*t40*t41*t100-0.126466955049837*t99;
    t103 = 1/POW(t49,2.0);
    t104 = 1/t50;
    t105 = 1.0*t102*t38*t103*t104;
    t106 = -0.58482233974552*(-1.726166666666666*t45*t46*
        t47*t101-1.2077*t15*t16*t18*t78-0.220065*t40*t41*t100-0.127434173008489*
        t99)*t52*t55*t56*t57/(POW(t58,2.0)*t59);
    t107 = 0.004429431133333*t15*t16*t18*t78*t51;
    t108 = 1.333333333333333*t87*t88+1.333333333333333*t83*
        t84;
    t109 = -7.324622014701263E-4*t52*t15*t16*t18*t78*t55*
        t57*t60;
    t110 = 1/POW(t2,5.0);
    t111 = 4.0*t110*t53;
    t112 = POW(t4,3.0);
    t113 = t52*t53*t54*t57*(0.002129457733333*t15*t16*t18*
        t78*t64+(-2.35315*t45*t46*t47*t101-2.0659*t15*t16*t18*t78-
        0.84155*t40*t41*t100-0.160391419419213*t99)*t61/(POW(t62,2.0)*
        t63)-0.004429431133333*t15*t16*t18*t78*t51-1.0*t102*t38*t103*
        t104);
    t114 = -4.0*t110*t52*t53*t57*t65;
    t115 = 940.8858823906587*t24*t12*t90*t36*t66-313.6286274635529*
        t12*t24*t37*(4.0*t112*t52*t54*t57*t65+t52*t53*t54*t108*t65+
        0.019751789702565*t52*(t111-4.0*t112*t54)*t56*t57*t60+0.019751789702565*
        t52*t55*t56*t108*t60+t114+t113+t109+t107+t106+t105);
    t116 = 1/POW(t72,2.0);
    t117 = -0.686062622576522*t32*t25*t34*t97*t36*t71;
    t118 = -1.549586776859504*t24*t12*t1*t91*t33*t69;
    t119 = 1/POW(t68,3.0);
    t120 = t5+t81;
    t121 = t82+t86;
    t122 = 0.666666666666667*t121*t89+0.666666666666667*t120*
        t85;
    t123 = 1.333333333333333*t121*t88+1.333333333333333*t120*
        t84;
    t124 = 940.8858823906587*t24*t12*t122*t36*t66-313.6286274635529*
        t12*t24*t37*(-4.0*t112*t52*t54*t57*t65+t52*t53*t54*t123*t65+
        0.019751789702565*t52*(4.0*t112*t54+t111)*t56*t57*t60+0.019751789702565*
        t52*t55*t56*t123*t60+t114+t113+t109+t107+t106+t105);

   /* code */
    dfdra = t2*(0.003188484444444*t10*t13*t31*t94*(2.656434474616293*
        t17*t32*t73*(t98-0.695452919183101*t34*t35*t69*t90*t96+t95-
        0.5*t1*t17*t3*t32*t37*t90-0.173863229795775*t115*t34*t35*t36*
        t67*t71)-2.656434474616293*t32*t17*t70*t116*(-0.664108618654073*
        t24*t12*t1*t3*t33*t115*t71*t67-0.294026838247081*t32*t25*t34*
        t35*t36*t115*t119*t67+t118-1.328217237308146*t24*t12*t1*t3*
        t90*t37*t69+t117-0.588053676494162*t32*t25*t34*t35*t90*t96*
        t71))+0.5*t1*t23*t29*t3*t8*(t93-12.5*t1*t24*t26*t27*t8*t90)+
        t92+0.5*t1*t23*t29*t3*t90+t80+0.009565453333333*t10*t13*t90*
        t28*t75)+t76+t30;
    dfdrb = t2*(0.003188484444444*t10*t13*t31*t94*(2.656434474616293*
        t17*t32*t73*(t98-0.695452919183101*t122*t34*t35*t69*t96+t95-
        0.173863229795775*t124*t34*t35*t36*t67*t71-0.5*t1*t122*t17*
        t3*t32*t37)-2.656434474616293*t32*t17*t70*t116*(-0.664108618654073*
        t24*t12*t1*t3*t33*t124*t71*t67-0.294026838247081*t32*t25*t34*
        t35*t36*t124*t119*t67+t118-1.328217237308146*t24*t12*t1*t3*
        t122*t37*t69+t117-0.588053676494162*t32*t25*t34*t35*t122*t96*
        t71))+0.5*t1*t23*t29*t3*t8*(t93-12.5*t1*t122*t24*t26*t27*t8)+
        t92+t80+0.009565453333333*t10*t13*t122*t28*t75+0.5*t1*t122*
        t23*t29*t3)+t76+t30;
    dfdga = t2*(0.003188484444444*t10*t13*t31*t94*(2.656434474616293*
        t17*t32*t73*(0.695452919183101*t1*t35*t36*t69*grada+0.5*t17*
        t3*t32*t33*grada)-2.656434474616293*t32*t17*t70*(1.328217237308146*
        t24*t12*grada*t3*t33*t69+0.588053676494162*t32*t25*grada*t1*
        t35*t36*t71)*t116)-6.25*t1*t110*t23*t24*t26*t29*t31*grada+
        grada*t3*t8*t23*t29);
    dfdgb = t2*(0.003188484444444*t10*t13*t31*t94*(2.656434474616293*
        t17*t32*t73*(0.695452919183101*t1*t35*t36*t69*gradb+0.5*t17*
        t3*t32*t33*gradb)-2.656434474616293*t32*t17*t70*(1.328217237308146*
        t24*t12*gradb*t3*t33*t69+0.588053676494162*t32*t25*gradb*t1*
        t35*t36*t71)*t116)-6.25*t1*t110*t23*t24*t26*t29*t31*gradb+
        gradb*t3*t8*t23*t29);
    dfdgab = t2*(0.003188484444444*t10*t13*t31*(2.656434474616293*
        t17*t32*(0.695452919183101*t1*t35*t36*t69+0.5*t17*t3*t32*t33)*
        t73-2.656434474616293*t32*t17*t70*(1.328217237308146*t24*t12*
        t3*t33*t69+0.588053676494162*t32*t25*t1*t35*t36*t71)*t116)*
        t94-6.25*t1*t110*t23*t24*t26*t29*t31+t3*t8*t23*t29);


    ds->df1000 += factor*dfdra;
    ds->df0100 += factor*dfdrb;
    ds->df0010 += factor*dfdga;
    ds->df0001 += factor*dfdgb;
    ds->df00001+= factor*dfdgab;
   
}

static void
pw92c_second(FunSecondFuncDrv *ds, real factor, const FunDensProp* dp)
{
    real dfdra, dfdrb, dfdga, dfdgb, dfdgab;
    real d2fdrara, d2fdrarb, d2fdraga, d2fdragb, d2fdraab, d2fdrbrb,
        d2fdrbga, d2fdrbgb, d2fdrbgab, d2fdgaga, d2fdgagb, d2fdgagab,
        d2fdgbgb, d2fdgbgab, d2fdgabgab;
    real rhoa = dp->rhoa, rhob = dp->rhob;
    real grada = dp->grada, gradb = dp->gradb, gradab = dp->gradab;

    real t1, t2, t3, t4, t5, t6, t7, t8, t9, t10;
    real t11, t12, t13, t14, t15, t16, t17, t18;
    real t19, t20, t21, t22, t23, t24, t25, t26;
    real t27, t28, t29, t30, t31, t32, t33, t34;
    real t35, t36, t37, t38, t39, t40, t41, t42;
    real t43, t44, t45, t46, t47, t48, t49, t50;
    real t51, t52, t53, t54, t55, t56, t57, t58;
    real t59, t60, t61, t62, t63, t64, t65, t66;
    real t67, t68, t69, t70, t71, t72, t73, t74;
    real t75, t76, t77, t78, t79, t80, t81, t82;
    real t83, t84, t85, t86, t87, t88, t89, t90;
    real t91, t92, t93, t94, t95, t96, t97, t98;
    real t99, t100, t101, t102, t103, t104, t105;
    real t106, t107, t108, t109, t110, t111, t112;
    real t113, t114, t115, t116, t117, t118, t119;
    real t120, t121, t122, t123, t124, t125, t126;
    real t127, t128, t129, t130, t131, t132, t133;
    real t134, t135, t136, t137, t138, t139, t140;
    real t141, t142, t143, t144, t145, t146, t147;
    real t148, t149, t150, t151, t152, t153, t154;
    real t155, t156, t157, t158, t159, t160, t161;
    real t162, t163, t164, t165, t166, t167, t168;
    real t169, t170, t171, t172, t173, t174, t175;
    real t176, t177, t178, t179, t180, t181, t182;
    real t183, t184, t185, t186, t187, t188, t189;
    real t190, t191, t192, t193, t194, t195, t196;
    real t197, t198, t199, t200, t201, t202, t203;
    real t204, t205, t206, t207, t208, t209, t210;
    real t211, t212, t213, t214, t215, t216, t217;
    real t218, t219, t220, t221, t222, t223, t224;
    real t225, t226, t227, t228, t229, t230, t231;
    real t232, t233, t234, t235, t236, t237, t238;
    real t239, t240, t241, t242, t243, t244, t245;
    real t246, t247, t248, t249, t250, t251, t252;
    real t253, t254, t255, t256, t257, t258, t259;
    real t260, t261, t262, t263, t264, t265, t266;
    real t267, t268, t269, t270, t271, t272, t273;
    real t274, t275, t276, t277, t278, t279, t280;
    real t281, t282, t283, t284, t285, t286, t287;
    real t288, t289, t290;

    t1 = POW(grada,2.0);
    t2 = POW(gradb,2.0);
    t3 = 2.0*gradab+t2+t1;
    t4 = rhob+rhoa;
    t5 = 1/POW(t4,2.333333333333333);
    t6 = rhoa-1.0*rhob;
    t7 = 1/t4;
    t8 = 1.0-1.0*t6*t7;
    t9 = POW(t8,0.666666666666667);
    t10 = t6*t7+1.0;
    t11 = POW(t10,0.666666666666667);
    t12 = t11+t9;
    t13 = 0.318309886183791;
    t14 = POW(3.0,0.666666666666667);
    t15 = 1/POW(4.0,0.666666666666667);
    t16 = POW(3.141592653589793,0.666666666666667);
    t17 = 1/t16;
    t18 = 1/POW(t4,0.666666666666667);
    t19 = POW(3.0,0.333333333333333);
    t20 = 1/POW(4.0,0.333333333333333);
    t21 = POW(3.141592653589793,0.333333333333333);
    t22 = 1/t21;
    t23 = 1/POW(t4,0.333333333333333);
    t24 = 0.0554175*t13*t7+8.723*t19*t20*t22*t23+0.472*t14*
        t15*t17*t18+1.0;
    t25 = 1/t24;
    t26 = 23.266*t19*t20*t22*t23+0.007389*t14*t15*t17*t18+
        2.568;
    t27 = 0.001*t25*t26-0.001853571428571;
    t28 = 1/t14;
    t29 = POW(3.141592653589793,1.333333333333333);
    t30 = 1/t29;
    t31 = 1/POW(t4,2.666666666666667);
    t32 = POW(t12,2.0);
    t33 = 1/POW(2.718281828459045,6.25*t28*t3*t30*t31*t32);
    t34 = 0.5*
        t12*t27*t3*t33*t5;
    t35 = POW(t12,3.0);
    t36 = 1/t19;
    t37 = 1/t32;
    t38 = POW(t3,2.0);
    t39 = 1/POW(t4,4.666666666666667);
    t40 = 1/POW(t12,4.0);
    t41 = 1/t35;
    t42 = 0.2137*t19*t20*t22*t23+1.0;
    t43 = 1/POW(t4,0.666666666666667);
    t44 = 1.732050807568877;
    t45 = 0.564189583547756;
    t46 = SQRT(t4);
    t47 = 1/t46;
    t48 = POW(2.0,0.333333333333333);
    t49 = 1/t48;
    t50 = POW(3.0,0.166666666666667);
    t51 = 1/POW(3.141592653589793,0.166666666666667);
    t52 = 1/POW(t4,0.166666666666667);
    t53 = 7.5957*t49*t50*t51*t52+3.5876*t19*t20*t22*t23+0.8191*
        t44*t45*t47+0.189700432574756*t43;
    t54 = 16.0818243221511/t53+1.0;
    t55 = LOG(t54);
    t56 = 1/(2.0*t48-2.0);
    t57 = POW(t6,4.0);
    t58 = 1/POW(t4,4.0);
    t59 = 1.0-1.0*t57*t58;
    t60 = 0.11125*t19*t20*t22*t23+1.0;
    t61 = POW(t8,1.333333333333333);
    t62 = POW(t10,1.333333333333333);
    t63 = t62+t61-2.0;
    t64 = 10.357*t49*t50*t51*t52+3.6231*t19*t20*t22*t23+0.44013*
        t44*t45*t47+0.191151259512734*t43;
    t65 = 29.60857464321668/t64+1.0;
    t66 = LOG(t65);
    t67 = 0.20548*t19*t20*t22*t23+1.0;
    t68 = 14.1189*t49*t50*t51*t52+6.1977*t19*t20*t22*t23+
        1.6831*t44*t45*t47+0.240587129128819*t43;
    t69 = 32.1646831778707/t68+1.0;
    t70 = LOG(t69);
    t71 = 0.062182*t42*t55-0.03109*t67*t70;
    t72 = t56*t57*t58*t63*t71+0.019751789702565*t56*t59*t60*
        t63*t66-0.062182*t42*t55;
    t73 = 1/POW(2.718281828459045,313.6286274635529*t28*t16*
        t41*t72);
    t74 = t73-1.0;
    t75 = 1/t74;
    t76 = 0.173863229795775*t38*t39*t40*t75+0.25*t21*t3*t36*
        t37*t5;
    t77 = 1/POW(t74,2.0);
    t78 = 0.14701341912354*t36*t29*t38*t39*t40*t77+0.664108618654073*
        t28*t16*t3*t5*t37*t75+1.0;
    t79 = 1/t78;
    t80 = 2.656434474616293*t36*t21*t76*t79+1.0;
    t81 = LOG(t80);
    t82 = 0.003188484444444*t14*t17*t35*t81;
    t83 = 1/POW(t4,1.666666666666667);
    t84 = 1/POW(t4,1.333333333333333);
    t85 = -7.755333333333333*t19*t20*t22*t84-0.004926*t14*
        t15*t17*t83;
    t86 = 1/POW(t4,2.0);
    t87 = -2.907666666666667*t19*t20*t22*t84-0.314666666666667*
        t14*t15*t17*t83-0.0554175*t13*t86;
    t88 = 1/POW(t24,2.0);
    t89 = 0.001*t85*t25-0.001*t87*t88*t26;
    t90 = 0.5*t12*t3*t33*t5*t89;
    t91 = t6*t86;
    t92 = -1.0*t7;
    t93 = t92+t91;
    t94 = POW(t8,0.333333333333333);
    t95 = 1/t94;
    t96 = -1.0*t6*t86;
    t97 = t7+t96;
    t98 = POW(t10,0.333333333333333);
    t99 = 1/t98;
    t100 = 0.666666666666667*t97*t99+0.666666666666667*t93*
        t95;
    t101 = 0.5*t100*t27*t3*t33*t5;
    t102 = 1/POW(t4,3.333333333333333);
    t103 = -1.166666666666667*t102*t12*t27*t3*t33;
    t104 = 1/POW(t4,3.666666666666667);
    t105 = 16.66666666666667*t104*t28*t3*t30*t32;
    t106 = t105-12.5*t100*t12*t28*t3*t30*t31;
    t107 = 0.5*t106*t12*t27*t3*t33*t5;
    t108 = 1/t80;
    t109 = -0.583333333333333*t102*t21*t3*t36*t37;
    t110 = POW(t12,5.0);
    t111 = 1/t110;
    t112 = 1/POW(t4,5.666666666666667);
    t113 = -0.811361739046951*t112*t38*t40*t75;
    t114 = 1/POW(t4,1.666666666666667);
    t115 = 1/POW(t46,3.0);
    t116 = 1/POW(t4,1.166666666666667);
    t117 = -1.26595*t49*t50*t51*t116-1.195866666666667*t19*
        t20*t22*t84-0.40955*t44*t45*t115-0.126466955049837*t114;
    t118 = 1/
        POW(t53,2.0);
    t119 = 1/t54;
    t120 = 1.0*t117*t42*t118*t119;
    t121 = -1.726166666666666*t49*t50*t51*t116-1.2077*t19*
        t20*t22*t84-0.220065*t44*t45*t115-0.127434173008489*t114;
    t122 = 1/
        POW(t64,2.0);
    t123 = 1/t65;
    t124 = -0.58482233974552*t56*t59*t121*t60*t122*t63*t123;
    t125 = 0.004429431133333*
        t19*t20*t22*t84*t55;
    t126 = 1.333333333333333*t97*t98+1.333333333333333*t93*
        t94;
    t127 = -7.324622014701263E-4*t56*t19*t20*t22*t84*t59*
        t63*t66;
    t128 = 1/POW(t4,5.0);
    t129 = 4.0*t128*t57;
    t130 = POW(t6,3.0);
    t131 = t129-4.0*t130*t58;
    t132 = -2.35315*t49*t50*t51*t116-2.0659*t19*t20*t22*t84-
        0.84155*t44*t45*t115-0.160391419419213*t114;
    t133 = 1/POW(t68,2.0);
    t134 = 1/t69;
    t135 = 0.002129457733333*t19*t20*t22*t84*t70-0.004429431133333*
        t19*t20*t22*t84*t55+t132*t67*t133*t134-1.0*t117*t42*t118*t119;
    t136 = t56*
        t57*t58*t63*t135;
    t137 = -4.0*t128*t56*t57*t63*t71;
    t138 = 4.0*t130*t56*t58*t63*t71+t56*t57*t58*t126*t71+
        0.019751789702565*t56*t131*t60*t63*t66+0.019751789702565*t56*
        t59*t60*t126*t66+t137+t136+t127+t125+t124+t120;
    t139 = 940.8858823906587*t28*t16*t100*t40*t72-313.6286274635529*
        t28*t16*t41*t138;
    t140 = -0.173863229795775*t139*t38*t39*t40*t73*t77-0.695452919183101*
        t100*t111*t38*t39*t75-0.5*t100*t21*t3*t36*t41*t5+t113+t109;
    t141 = 1/
        POW(t78,2.0);
    t142 = -0.686062622576522*t36*t29*t38*t112*t40*t77;
    t143 = -
        1.549586776859504*t28*t16*t3*t102*t37*t75;
    t144 = 1/POW(t74,3.0);
    t145 = -0.664108618654073*t28*t16*t3*t5*t37*t139*t77*
        t73-0.294026838247081*t36*t29*t38*t39*t40*t139*t144*t73+t143-
        1.328217237308146*t28*t16*t3*t5*t100*t41*t75+t142-0.588053676494162*
        t36*t29*t38*t39*t100*t111*t77;
    t146 = 2.656434474616293*t36*t21*t79*t140-2.656434474616293*
        t36*t21*t76*t141*t145;
    t147 = 0.003188484444444*t14*t17*t35*t108*t146;
    t148 = 0.009565453333333*t14*t17*t100*t32*t81;
    t149 = t7+t91;
    t150 = t92+t96;
    t151 = 0.666666666666667*t150*t99+0.666666666666667*t149*
        t95;
    t152 = 0.5*t151*t27*t3*t33*t5;
    t153 = t105-12.5*t12*t151*t28*t3*t30*t31;
    t154 = 0.5*t12*t153*t27*t3*t33*t5;
    t155 = 1.333333333333333*t150*t98+1.333333333333333*t149*
        t94;
    t156 = 4.0*t130*t58+t129;
    t157 = -4.0*t130*t56*t58*t63*t71+t56*t57*t58*t155*t71+
        0.019751789702565*t56*t156*t60*t63*t66+0.019751789702565*t56*
        t59*t60*t155*t66+t137+t136+t127+t125+t124+t120;
    t158 = 940.8858823906587*t28*t16*t151*t40*t72-313.6286274635529*
        t28*t16*t41*t157;
    t159 = -0.173863229795775*t158*t38*t39*t40*t73*t77-0.695452919183101*
        t111*t151*t38*t39*t75-0.5*t151*t21*t3*t36*t41*t5+t113+t109;
    t160 = -
        0.664108618654073*t28*t16*t3*t5*t37*t158*t77*t73-0.294026838247081*
        t36*t29*t38*t39*t40*t158*t144*t73+t143-1.328217237308146*t28*
        t16*t3*t5*t151*t41*t75+t142-0.588053676494162*t36*t29*t38*
        t39*t151*t111*t77;
    t161 = 2.656434474616293*t36*t21*t79*t159-2.656434474616293*
        t36*t21*t76*t141*t160;
    t162 = 0.003188484444444*t14*t17*t35*t108*t161;
    t163 = 0.009565453333333*t14*t17*t151*t32*t81;
    t164 = grada*t5*t12*t27*t33;
    t165 = -6.25*t128*t27*t28*t3*t30*t33*t35*grada;
    t166 = 1.328217237308146*t28*t16*grada*t5*t37*t75+0.588053676494162*
        t36*t29*grada*t3*t39*t40*t77;
    t167 = 0.695452919183101*t3*t39*t40*t75*grada+0.5*t21*
        t36*t37*t5*grada;
    t168 = 2.656434474616293*t36*t21*t167*t79-2.656434474616293*
        t36*t21*t76*t166*t141;
    t169 = 0.003188484444444*t14*t17*t35*t168*t108;
    t170 = gradb*t5*t12*t27*t33;
    t171 = -6.25*t128*t27*t28*t3*t30*t33*t35*gradb;
    t172 = 1.328217237308146*t28*t16*gradb*t5*t37*t75+0.588053676494162*
        t36*t29*gradb*t3*t39*t40*t77;
    t173 = 0.695452919183101*t3*t39*t40*t75*gradb+0.5*t21*
        t36*t37*t5*gradb;
    t174 = 2.656434474616293*t36*t21*t173*t79-2.656434474616293*
        t36*t21*t76*t172*t141;
    t175 = 0.003188484444444*t14*t17*t35*t174*t108;
    t176 = t5*t12*t27*t33;
    t177 = -6.25*t128*t27*t28*t3*t30*t33*t35;
    t178 = 0.588053676494162*t36*t29*t3*t39*t40*t77;
    t179 = 1.328217237308146*t28*t16*t5*t37*t75;
    t180 = t179+t178;
    t181 = 0.5*t21*t36*t37*t5;
    t182 = 0.695452919183101*t3*t39*t40*t75;
    t183 = t182+t181;
    t184 = 2.656434474616293*t36*t21*t183*t79-2.656434474616293*
        t36*t21*t76*t180*t141;
    t185 = 0.003188484444444*t14*t17*t35*t184*t108;
    t186 = t3*t5*t12*t89*t33;
    t187 = -2.333333333333333*t102*t12*t27*t3*t33;
    t188 = 1/POW(t4,3.0);
    t189 = 0.5*t12*t3*t33*t5*(-0.002*t85*t87*t88+0.002*t26*
        POW(t87,2.0)/POW(t24,3.0)-0.001*(3.876888888888889*t19*t20*
        t22*t5+0.524444444444444*t14*t15*t17*t31+0.110835*t13*t188)*
        t88*t26+0.001*(10.34044444444444*t19*t20*t22*t5+0.00821*t14*
        t15*t17*t31)*t25);
    t190 = -2.333333333333333*t102*t12*t3*t33*t89;
    t191 = POW(t93,2.0);
    t192 = 1/t61;
    t193 = -2.0*t188*t6;
    t194 = 2.0*t86;
    t195 = t194+t193;
    t196 = POW(t97,2.0);
    t197 = 1/t62;
    t198 = 2.0*t188*t6;
    t199 = -2.0*t86;
    t200 = t199+t198;
    t201 = 0.666666666666667*t200*t99+0.666666666666667*t195*
        t95-0.222222222222222*t196*t197-0.222222222222222*t191*t192;
    t202 = 1/
        POW(t4,4.333333333333333);
    t203 = 3.888888888888889*t12*t202*t27*t3*t33;
    t204 = POW(t100,2.0);
    t205 = -61.11111111111111*t28*t3*t30*t32*t39;
    t206 = 1/POW(t80,2.0);
    t207 = 1/POW(t78,3.0);
    t208 = 1.944444444444444*t202*t21*t3*t36*t37;
    t209 = POW(t139,2.0);
    t210 = 1/POW(2.718281828459045,627.2572549271058*t28*
        t16*t41*t72);
    t211 = 1/POW(t12,6.0);
    t212 = 1/POW(t4,6.666666666666667);
    t213 = 4.597716521266054*t212*t38*t40*t75;
    t214 = POW(t117,2.0);
    t215 = 1/POW(t53,4.0);
    t216 = 1/POW(t54,2.0);
    t217 = 16.0818243221511*t214*t42*t215*t216;
    t218 = 1/POW(t53,3.0);
    t219 = -2.0*t214*t42*t218*t119;
    t220 = -0.142466666666667*t19*t20*t22*t84*t117*t118*t119;
    t221 = 1/
        POW(t4,2.666666666666667);
    t222 = 1/POW(t46,5.0);
    t223 = 1/POW(t4,2.166666666666667);
    t224 = 1.476941666666667*t49*t50*t51*t223+1.594488888888889*
        t19*t20*t22*t5+0.614325*t44*t45*t222+0.210778258416395*t221;
    t225 = 1.0*
        t224*t42*t118*t119;
    t226 = POW(t121,2.0);
    t227 = -17.31575589937587*t226*t56*t59*t60*t63/(POW(t64,
        4.0)*POW(t65,2.0));
    t228 = 1.169644679491041*t123*t226*t56*t59*t60*t63/POW(t64,
        3.0);
    t229 = 0.043374323531126*t56*t19*t20*t22*t84*t59*t121*
        t122*t63*t123;
    t230 = -0.58482233974552*t56*t59*(2.013861111111111*t49*
        t50*t51*t223+1.610266666666667*t19*t20*t22*t5+0.3300975*t44*
        t45*t222+0.212390288347482*t221)*t60*t122*t63*t123;
    t231 = -0.005905908177778*t19*t20*t22*t5*t55;
    t232 = 1/t9;
    t233 = 1/t11;
    t234 = 1.333333333333333*t200*t98+1.333333333333333*t195*
        t94+0.444444444444444*t196*t233+0.444444444444444*t191*t232;
    t235 = 9.76616268626835E-4*t56*t19*t20*t22*t5*t59*t63*
        t66;
    t236 = 1/POW(t4,6.0);
    t237 = -20.0*t236*t57;
    t238 = POW(t6,2.0);
    t239 = -12.0*t238*t58;
    t240 = POW(t132,2.0);
    t241 = t56*t57*t58*t63*(-0.002839276977778*t19*t20*t22*
        t5*t70+32.1646831778707*t240*t67/(POW(t68,4.0)*POW(t69,2.0))-
        2.0*t134*t240*t67/POW(t68,3.0)+0.005905908177778*t19*t20*t22*
        t5*t55-16.0818243221511*t214*t42*t215*t216+(2.745341666666667*
        t49*t50*t51*t223+2.754533333333333*t19*t20*t22*t5+1.262325*
        t44*t45*t222+0.267319032365355*t221)*t67*t133*t134-0.136986666666667*
        t19*t20*t22*t84*t132*t133*t134+2.0*t214*t42*t218*t119-1.0*
        t224*t42*t118*t119+0.142466666666667*t19*t20*t22*t84*t117*
        t118*t119);
    t242 = -8.0*t128*t135*t56*t57*t63;
    t243 = 20.0*t236*t56*t57*t63*t71;
    t244 = 12.0*t238*t56*t58*t63*t71;
    t245 = 940.8858823906587*t28*t16*t201*t40*t72-3763.543529562635*
        t28*t16*t204*t111*t72-313.6286274635529*t16*t28*t41*(-32.0*
        t128*t130*t56*t63*t71+8.0*t126*t130*t56*t58*t71-8.0*t126*t128*
        t56*t57*t71+t56*t57*t58*t234*t71+0.019751789702565*(t239+t237+
        32.0*t128*t130)*t56*t60*t63*t66-0.00146492440294*t56*t19*t20*
        t22*t84*t131*t63*t66+0.019751789702565*t56*t59*t60*t234*t66+
        0.03950357940513*t56*t131*t60*t126*t66-0.00146492440294*t56*
        t19*t20*t22*t84*t59*t126*t66+8.0*t130*t135*t56*t58*t63+2.0*
        t126*t135*t56*t57*t58+t244+t243+t242+t241+t235+t231+t230+t229+
        t228+t227+t225+t220+t219+t217-1.169644679491041*t56*t131*t121*
        t60*t122*t63*t123-1.169644679491041*t56*t59*t121*t60*t122*
        t126*t123)+1881.771764781317*t28*t16*t100*t40*t138;
    t246 = 1/POW(t74,4.0);
    t247 = 3.887688194600291*t36*t29*t38*t212*t40*t77;
    t248 = 5.165289256198347*t28*t16*t3*t202*t37*t75;
    t249 = 1.333333333333333*t188*t6*t99-0.222222222222222*
        t150*t197*t97-1.333333333333333*t188*t6*t95-0.222222222222222*
        t149*t192*t93;
    t250 = 2.666666666666667*t188*t6*t98+0.444444444444444*
        t150*t233*t97-2.666666666666667*t188*t6*t94+0.444444444444444*
        t149*t232*t93;
    t251 = 940.8858823906587*t28*t16*t249*t40*t72-3763.543529562635*
        t28*t16*t151*t100*t111*t72-313.6286274635529*t16*t28*t41*(-
        12.0*t238*t56*t58*t63*t71+4.0*t130*t155*t56*t58*t71-4.0*t126*
        t130*t56*t58*t71-4.0*t128*t155*t56*t57*t71-4.0*t126*t128*t56*
        t57*t71+t56*t57*t58*t250*t71+0.019751789702565*t56*(12.0*t238*
        t58+t237)*t60*t63*t66-7.324622014701263E-4*t56*t19*t20*t22*
        t84*t156*t63*t66-7.324622014701263E-4*t56*t19*t20*t22*t84*
        t131*t63*t66+0.019751789702565*t56*t59*t60*t250*t66+0.019751789702565*
        t56*t131*t60*t155*t66-7.324622014701263E-4*t56*t19*t20*t22*
        t84*t59*t155*t66+0.019751789702565*t56*t156*t60*t126*t66-7.324622014701263E-4*
        t56*t19*t20*t22*t84*t59*t126*t66+t243+t242+t241+t235+t231+
        t230+t229+t228+t227+t225+t220+t219+t217+t56*t57*t58*t155*t135+
        t56*t57*t58*t126*t135-0.58482233974552*t56*t156*t121*t60*t122*
        t63*t123-0.58482233974552*t56*t131*t121*t60*t122*t63*t123-
        0.58482233974552*t56*t59*t121*t60*t122*t155*t123-0.58482233974552*
        t56*t59*t121*t60*t122*t126*t123)+940.8858823906587*t28*t16*
        t100*t40*t157+940.8858823906587*t28*t16*t151*t40*t138;
    t252 = grada*t5*t12*t89*t33;
    t253 = -6.25*t128*t28*t3*t30*t33*t35*t89*grada;
    t254 = -2.333333333333333*t102*t12*t27*t33*grada;
    t255 = 14.58333333333333*t236*t27*t28*t3*t30*t33*t35*
        grada;
    t256 = 33.33333333333334*t104*t28*t30*t32*grada;
    t257 = -1.166666666666667*t102*t21*t36*t37*grada;
    t258 = -3.245446956187803*t112*t3*t40*t75*grada;
    t259 = -2.744250490306088*t36*t29*grada*t3*t112*t40*t77;
    t260 = -
        3.099173553719008*t28*t16*grada*t102*t37*t75;
    t261 = gradb*t5*t12*t89*t33;
    t262 = -6.25*t128*t28*t3*t30*t33*t35*t89*gradb;
    t263 = -2.333333333333333*t102*t12*t27*t33*gradb;
    t264 = 14.58333333333333*t236*t27*t28*t3*t30*t33*t35*
        gradb;
    t265 = 33.33333333333334*t104*t28*t30*t32*gradb;
    t266 = -1.166666666666667*t102*t21*t36*t37*gradb;
    t267 = -3.245446956187803*t112*t3*t40*t75*gradb;
    t268 = -2.744250490306088*t36*t29*gradb*t3*t112*t40*t77;
    t269 = -
        3.099173553719008*t28*t16*gradb*t102*t37*t75;
    t270 = t5*t12*t89*t33;
    t271 = -6.25*t128*t28*t3*t30*t33*t35*t89;
    t272 = -2.333333333333333*t102*t12*t27*t33;
    t273 = 14.58333333333333*t236*t27*t28*t3*t30*t33*t35;
    t274 = 33.33333333333334*
        t104*t28*t30*t32;
    t275 = -1.166666666666667*t102*t21*t36*t37;
    t276 = -3.245446956187803*t112*t3*t40*t75;
    t277 = -2.744250490306088*t36*t29*t3*t112*t40*t77;
    t278 = -3.099173553719008*t28*t16*t102*t37*t75;
    t279 = POW(t149,2.0);
    t280 = t199+t193;
    t281 = POW(t150,2.0);
    t282 = t194+t198;
    t283 = 0.666666666666667*t282*t99+0.666666666666667*t280*
        t95-0.222222222222222*t197*t281-0.222222222222222*t192*t279;
    t284 = POW(t151,
        2.0);
    t285 = POW(t158,2.0);
    t286 = 1.333333333333333*t282*t98+1.333333333333333*t280*
        t94+0.444444444444444*t233*t281+0.444444444444444*t232*t279;
    t287 = 940.8858823906587*
        t28*t16*t283*t40*t72-3763.543529562635*t28*t16*t284*t111*t72-
        313.6286274635529*t16*t28*t41*(32.0*t128*t130*t56*t63*t71-
        8.0*t130*t155*t56*t58*t71-8.0*t128*t155*t56*t57*t71+t56*t57*
        t58*t286*t71+0.019751789702565*(t239+t237-32.0*t128*t130)*
        t56*t60*t63*t66-0.00146492440294*t56*t19*t20*t22*t84*t156*
        t63*t66+0.019751789702565*t56*t59*t60*t286*t66+0.03950357940513*
        t56*t156*t60*t155*t66-0.00146492440294*t56*t19*t20*t22*t84*
        t59*t155*t66-8.0*t130*t135*t56*t58*t63+2.0*t135*t155*t56*t57*
        t58+t244+t243+t242+t241+t235+t231+t230+t229+t228+t227+t225+
        t220+t219+t217-1.169644679491041*t56*t156*t121*t60*t122*t63*
        t123-1.169644679491041*t56*t59*t121*t60*t122*t155*t123)+1881.771764781317*
        t28*t16*t151*t40*t157;
    t288 = 1/POW(3.141592653589793,2.666666666666667);
    t289 = 1/POW(t4,7.666666666666667);
    t290 = POW(3.141592653589793,1.666666666666667);

   /* code */
    dfdra = t4*(t148+t147+t107+t103+t101+t90)+t82+t34;
    dfdrb = t4*(t163+t162+t154+t103+t152+t90)+t82+t34;
    dfdga = t4*(t169+t165+t164);
    dfdgb = t4*(t175+t171+t170);
    dfdgab = t4*(t185+t177+t176);
    d2fdrara = t4*(0.009565453333333*t14*t17*t201*t32*t81+
        0.019130906666667*t14*t17*t204*t12*t81+0.003188484444444*t108*
        t14*t17*t35*(2.656434474616293*t21*t36*(-0.173863229795775*
        t245*t38*t39*t40*t73*t77-0.173863229795775*t209*t38*t39*t40*
        t73*t77+1.622723478093901*t112*t139*t38*t40*t73*t77+1.390905838366201*
        t100*t111*t139*t38*t39*t73*t77+3.477264595915503*t204*t211*
        t38*t39*t75-0.695452919183101*t111*t201*t38*t39*t75+6.490893912375606*
        t100*t111*t112*t38*t75-0.5*t201*t21*t3*t36*t41*t5+1.5*t204*
        t21*t3*t36*t40*t5+2.333333333333333*t100*t102*t21*t3*t36*t41+
        0.34772645959155*t144*t209*t210*t38*t39*t40+t213+t208)*t79+
        5.312868949232586*POW(t145,2.0)*t207*t21*t36*t76-2.656434474616293*
        t36*t21*t76*t141*(-0.664108618654073*t28*t16*t3*t5*t37*t209*
        t77*t73+3.099173553719008*t28*t16*t3*t102*t37*t139*t77*t73+
        2.656434474616293*t28*t16*t3*t5*t100*t41*t139*t77*t73-0.664108618654073*
        t28*t16*t3*t5*t37*t245*t77*t73-0.294026838247081*t36*t29*t38*
        t39*t40*t209*t144*t73+2.744250490306088*t36*t29*t38*t112*t40*
        t139*t144*t73+2.352214705976647*t36*t29*t38*t39*t100*t111*
        t139*t144*t73-0.294026838247081*t36*t29*t38*t39*t40*t245*t144*
        t73+t248+6.198347107438017*t28*t16*t3*t102*t100*t41*t75-1.328217237308146*
        t28*t16*t3*t5*t201*t41*t75+3.98465171192444*t28*t16*t3*t5*
        t204*t40*t75+t247+5.488500980612176*t36*t29*t38*t112*t100*
        t111*t77-0.588053676494162*t36*t29*t38*t39*t201*t111*t77+2.940268382470808*
        t36*t29*t38*t39*t204*t211*t77+1.328217237308146*t28*t16*t3*
        t5*t37*t209*t210*t144+0.882080514741242*t36*t29*t38*t39*t40*
        t209*t210*t246)-5.312868949232586*t36*t21*t141*t140*t145)+
        0.5*t12*t27*t3*(-12.5*t204*t28*t3*t30*t31-12.5*t12*t201*t28*
        t3*t30*t31+66.66666666666667*t100*t104*t12*t28*t3*t30+t205)*
        t33*t5+0.5*t201*t27*t3*t33*t5+0.5*POW(t106,2.0)*t12*t27*t3*
        t33*t5-0.003188484444444*t14*POW(t146,2.0)*t17*t206*t35+t3*
        t5*t100*t89*t33-2.333333333333333*t102*t106*t12*t27*t3*t33-
        2.333333333333333*t100*t102*t27*t3*t33+t3*t5*t12*t89*t106*
        t33+t3*t5*t100*t27*t106*t33+t203+t190+t189+0.019130906666667*
        t14*t17*t100*t32*t108*t146)+0.019130906666667*t14*t17*t100*
        t32*t81+t3*t5*t100*t27*t33+t3*t5*t12*t27*t106*t33+t187+t186+
        0.006376968888889*t14*t17*t35*t108*t146;
    d2fdrarb = t4*(0.5*t12*t153*t3*t33*t5*t89+0.5*t151*t3*
        t33*t5*t89+0.5*t106*t12*t3*t33*t5*t89+0.5*t100*t3*t33*t5*t89+
        0.009565453333333*t14*t17*t249*t32*t81+0.019130906666667*t14*
        t17*t151*t100*t12*t81+0.003188484444444*t108*t14*t17*t35*(2.656434474616293*
        t21*t36*(-0.173863229795775*t251*t38*t39*t40*t73*t77-0.173863229795775*
        t139*t158*t38*t39*t40*t73*t77+0.811361739046951*t112*t158*
        t38*t40*t73*t77+0.811361739046951*t112*t139*t38*t40*t73*t77+
        0.695452919183101*t100*t111*t158*t38*t39*t73*t77+0.695452919183101*
        t111*t139*t151*t38*t39*t73*t77-0.695452919183101*t111*t249*
        t38*t39*t75+3.477264595915503*t100*t151*t211*t38*t39*t75+3.245446956187803*
        t111*t112*t151*t38*t75+3.245446956187803*t100*t111*t112*t38*
        t75-0.5*t21*t249*t3*t36*t41*t5+1.5*t100*t151*t21*t3*t36*t40*
        t5+1.166666666666667*t102*t151*t21*t3*t36*t41+1.166666666666667*
        t100*t102*t21*t3*t36*t41+0.34772645959155*t139*t144*t158*t210*
        t38*t39*t40+t213+t208)*t79-2.656434474616293*t36*t21*t76*t141*
        (-0.664108618654073*t28*t16*t3*t5*t37*t158*t139*t77*t73+1.549586776859504*
        t28*t16*t3*t102*t37*t139*t77*t73+1.328217237308146*t28*t16*
        t3*t5*t151*t41*t139*t77*t73+1.549586776859504*t28*t16*t3*t102*
        t37*t158*t77*t73+1.328217237308146*t28*t16*t3*t5*t100*t41*
        t158*t77*t73-0.664108618654073*t28*t16*t3*t5*t37*t251*t77*
        t73-0.294026838247081*t36*t29*t38*t39*t40*t158*t139*t144*t73+
        1.372125245153044*t36*t29*t38*t112*t40*t139*t144*t73+1.176107352988323*
        t36*t29*t38*t39*t151*t111*t139*t144*t73+1.372125245153044*
        t36*t29*t38*t112*t40*t158*t144*t73+1.176107352988323*t36*t29*
        t38*t39*t100*t111*t158*t144*t73-0.294026838247081*t36*t29*
        t38*t39*t40*t251*t144*t73+t248+3.099173553719008*t28*t16*t3*
        t102*t100*t41*t75+3.099173553719008*t28*t16*t3*t102*t151*t41*
        t75-1.328217237308146*t28*t16*t3*t5*t249*t41*t75+3.98465171192444*
        t28*t16*t3*t5*t151*t100*t40*t75+t247+2.744250490306088*t36*
        t29*t38*t112*t100*t111*t77+2.744250490306088*t36*t29*t38*t112*
        t151*t111*t77-0.588053676494162*t36*t29*t38*t39*t249*t111*
        t77+2.940268382470808*t36*t29*t38*t39*t151*t100*t211*t77+1.328217237308146*
        t28*t16*t3*t5*t37*t158*t139*t210*t144+0.882080514741242*t36*
        t29*t38*t39*t40*t158*t139*t210*t246)+5.312868949232586*t36*
        t21*t76*t207*t160*t145-2.656434474616293*t36*t21*t141*t159*
        t145-2.656434474616293*t36*t21*t141*t160*t140)+0.5*t12*t27*
        t3*(-12.5*t12*t249*t28*t3*t30*t31-12.5*t100*t151*t28*t3*t30*
        t31+33.33333333333334*t104*t12*t151*t28*t3*t30+33.33333333333334*
        t100*t104*t12*t28*t3*t30+t205)*t33*t5+0.5*t249*t27*t3*t33*
        t5+0.5*t106*t12*t153*t27*t3*t33*t5+0.5*t100*t153*t27*t3*t33*
        t5+0.5*t106*t151*t27*t3*t33*t5-1.166666666666667*t102*t12*
        t153*t27*t3*t33-1.166666666666667*t102*t151*t27*t3*t33-1.166666666666667*
        t102*t106*t12*t27*t3*t33-1.166666666666667*t100*t102*t27*t3*
        t33+t203+t190+t189+0.009565453333333*t14*t17*t100*t32*t108*
        t161-0.003188484444444*t14*t17*t35*t206*t161*t146+0.009565453333333*
        t14*t17*t151*t32*t108*t146)+t187+t186+t163+t162+t154+t152+
        t148+t147+t107+t101;
    d2fdraga = t4*(0.003188484444444*t108*t14*t17*t35*(2.656434474616293*
        t21*t36*t79*(-0.695452919183101*t139*t3*t39*t40*t73*t77*grada-
        2.781811676732402*t100*t111*t3*t39*t75*grada-1.0*t100*t21*
        t36*t41*t5*grada+t258+t257)-2.656434474616293*t36*t21*t76*
        t141*(-1.328217237308146*t28*t16*grada*t5*t37*t139*t77*t73-
        1.176107352988323*t36*t29*grada*t3*t39*t40*t139*t144*t73+t260-
        2.656434474616293*t28*t16*grada*t5*t100*t41*t75+t259-2.352214705976647*
        t36*t29*grada*t3*t39*t100*t111*t77)+5.312868949232586*t36*
        t21*t76*t166*t207*t145-2.656434474616293*t36*t21*t167*t141*
        t145-2.656434474616293*t36*t21*t166*t141*t140)+0.5*t12*t27*
        t3*t33*t5*(t256-25.0*t100*t12*t28*t30*t31*grada)-6.25*t106*
        t128*t27*t28*t3*t30*t33*t35*grada-6.25*t100*t128*t27*t28*t3*
        t30*t32*t33*grada+grada*t5*t100*t27*t33+grada*t5*t12*t27*t106*
        t33+t255+t254+t253+t252-0.003188484444444*t14*t17*t35*t168*
        t206*t146+0.009565453333333*t14*t17*t100*t32*t168*t108)+t169+
        t165+t164;
    d2fdragb = t4*(0.003188484444444*t108*t14*t17*t35*(2.656434474616293*
        t21*t36*t79*(-0.695452919183101*t139*t3*t39*t40*t73*t77*gradb-
        2.781811676732402*t100*t111*t3*t39*t75*gradb-1.0*t100*t21*
        t36*t41*t5*gradb+t267+t266)-2.656434474616293*t36*t21*t76*
        t141*(-1.328217237308146*t28*t16*gradb*t5*t37*t139*t77*t73-
        1.176107352988323*t36*t29*gradb*t3*t39*t40*t139*t144*t73+t269-
        2.656434474616293*t28*t16*gradb*t5*t100*t41*t75+t268-2.352214705976647*
        t36*t29*gradb*t3*t39*t100*t111*t77)+5.312868949232586*t36*
        t21*t76*t172*t207*t145-2.656434474616293*t36*t21*t173*t141*
        t145-2.656434474616293*t36*t21*t172*t141*t140)+0.5*t12*t27*
        t3*t33*t5*(t265-25.0*t100*t12*t28*t30*t31*gradb)-6.25*t106*
        t128*t27*t28*t3*t30*t33*t35*gradb-6.25*t100*t128*t27*t28*t3*
        t30*t32*t33*gradb+gradb*t5*t100*t27*t33+gradb*t5*t12*t27*t106*
        t33+t264+t263+t262+t261-0.003188484444444*t14*t17*t35*t174*
        t206*t146+0.009565453333333*t14*t17*t100*t32*t174*t108)+t175+
        t171+t170;
    d2fdraab = t4*(0.003188484444444*t108*t14*t17*t35*(2.656434474616293*
        t21*t36*(-0.695452919183101*t139*t3*t39*t40*t73*t77-2.781811676732402*
        t100*t111*t3*t39*t75-1.0*t100*t21*t36*t41*t5+t276+t275)*t79-
        2.656434474616293*t36*t21*t76*t141*(-1.328217237308146*t28*
        t16*t5*t37*t139*t77*t73-1.176107352988323*t36*t29*t3*t39*t40*
        t139*t144*t73+t278-2.656434474616293*t28*t16*t5*t100*t41*t75+
        t277-2.352214705976647*t36*t29*t3*t39*t100*t111*t77)+5.312868949232586*
        t36*t21*t76*t180*t207*t145-2.656434474616293*t36*t21*t183*
        t141*t145-2.656434474616293*t36*t21*t180*t141*t140)+0.5*t12*
        t27*t3*(t274-25.0*t100*t12*t28*t30*t31)*t33*t5-6.25*t106*t128*
        t27*t28*t3*t30*t33*t35-6.25*t100*t128*t27*t28*t3*t30*t32*t33+
        t5*t100*t27*t33+t5*t12*t27*t106*t33+t273+t272+t271+t270-0.003188484444444*
        t14*t17*t35*t184*t206*t146+0.009565453333333*t14*t17*t100*
        t32*t184*t108)+t185+t177+t176;
    d2fdrbrb = t4*(0.009565453333333*t14*t17*t283*t32*t81+
        0.019130906666667*t14*t17*t284*t12*t81+0.003188484444444*t108*
        t14*t17*t35*(2.656434474616293*t21*t36*(-0.173863229795775*
        t287*t38*t39*t40*t73*t77-0.173863229795775*t285*t38*t39*t40*
        t73*t77+1.622723478093901*t112*t158*t38*t40*t73*t77+1.390905838366201*
        t111*t151*t158*t38*t39*t73*t77+3.477264595915503*t211*t284*
        t38*t39*t75-0.695452919183101*t111*t283*t38*t39*t75+6.490893912375606*
        t111*t112*t151*t38*t75-0.5*t21*t283*t3*t36*t41*t5+1.5*t21*
        t284*t3*t36*t40*t5+2.333333333333333*t102*t151*t21*t3*t36*
        t41+0.34772645959155*t144*t210*t285*t38*t39*t40+t213+t208)*
        t79+5.312868949232586*POW(t160,2.0)*t207*t21*t36*t76-2.656434474616293*
        t36*t21*t76*t141*(-0.664108618654073*t28*t16*t3*t5*t37*t285*
        t77*t73+3.099173553719008*t28*t16*t3*t102*t37*t158*t77*t73+
        2.656434474616293*t28*t16*t3*t5*t151*t41*t158*t77*t73-0.664108618654073*
        t28*t16*t3*t5*t37*t287*t77*t73-0.294026838247081*t36*t29*t38*
        t39*t40*t285*t144*t73+2.744250490306088*t36*t29*t38*t112*t40*
        t158*t144*t73+2.352214705976647*t36*t29*t38*t39*t151*t111*
        t158*t144*t73-0.294026838247081*t36*t29*t38*t39*t40*t287*t144*
        t73+t248+6.198347107438017*t28*t16*t3*t102*t151*t41*t75-1.328217237308146*
        t28*t16*t3*t5*t283*t41*t75+3.98465171192444*t28*t16*t3*t5*
        t284*t40*t75+t247+5.488500980612176*t36*t29*t38*t112*t151*
        t111*t77-0.588053676494162*t36*t29*t38*t39*t283*t111*t77+2.940268382470808*
        t36*t29*t38*t39*t284*t211*t77+1.328217237308146*t28*t16*t3*
        t5*t37*t285*t210*t144+0.882080514741242*t36*t29*t38*t39*t40*
        t285*t210*t246)-5.312868949232586*t36*t21*t141*t159*t160)+
        0.5*t12*t27*t3*(-12.5*t28*t284*t3*t30*t31-12.5*t12*t28*t283*
        t3*t30*t31+66.66666666666667*t104*t12*t151*t28*t3*t30+t205)*
        t33*t5+0.5*t27*t283*t3*t33*t5+0.5*t12*POW(t153,2.0)*t27*t3*
        t33*t5-0.003188484444444*t14*POW(t161,2.0)*t17*t206*t35+t3*
        t5*t151*t89*t33-2.333333333333333*t102*t12*t153*t27*t3*t33-
        2.333333333333333*t102*t151*t27*t3*t33+t3*t5*t12*t89*t153*
        t33+t3*t5*t151*t27*t153*t33+t203+t190+t189+0.019130906666667*
        t14*t17*t151*t32*t108*t161)+0.019130906666667*t14*t17*t151*
        t32*t81+t3*t5*t151*t27*t33+t3*t5*t12*t27*t153*t33+t187+t186+
        0.006376968888889*t14*t17*t35*t108*t161;
    d2fdrbga = t4*(0.003188484444444*t108*t14*t17*t35*(2.656434474616293*
        t21*t36*t79*(-0.695452919183101*t158*t3*t39*t40*t73*t77*grada-
        2.781811676732402*t111*t151*t3*t39*t75*grada-1.0*t151*t21*
        t36*t41*t5*grada+t258+t257)-2.656434474616293*t36*t21*t76*
        t141*(-1.328217237308146*t28*t16*grada*t5*t37*t158*t77*t73-
        1.176107352988323*t36*t29*grada*t3*t39*t40*t158*t144*t73+t260-
        2.656434474616293*t28*t16*grada*t5*t151*t41*t75+t259-2.352214705976647*
        t36*t29*grada*t3*t39*t151*t111*t77)+5.312868949232586*t36*
        t21*t76*t166*t207*t160-2.656434474616293*t36*t21*t167*t141*
        t160-2.656434474616293*t36*t21*t166*t141*t159)+0.5*t12*t27*
        t3*t33*t5*(t256-25.0*t12*t151*t28*t30*t31*grada)-6.25*t128*
        t153*t27*t28*t3*t30*t33*t35*grada-6.25*t128*t151*t27*t28*t3*
        t30*t32*t33*grada+grada*t5*t151*t27*t33+grada*t5*t12*t27*t153*
        t33+t255+t254+t253+t252-0.003188484444444*t14*t17*t35*t168*
        t206*t161+0.009565453333333*t14*t17*t151*t32*t168*t108)+t169+
        t165+t164;
    d2fdrbgb = t4*(0.003188484444444*t108*t14*t17*t35*(2.656434474616293*
        t21*t36*t79*(-0.695452919183101*t158*t3*t39*t40*t73*t77*gradb-
        2.781811676732402*t111*t151*t3*t39*t75*gradb-1.0*t151*t21*
        t36*t41*t5*gradb+t267+t266)-2.656434474616293*t36*t21*t76*
        t141*(-1.328217237308146*t28*t16*gradb*t5*t37*t158*t77*t73-
        1.176107352988323*t36*t29*gradb*t3*t39*t40*t158*t144*t73+t269-
        2.656434474616293*t28*t16*gradb*t5*t151*t41*t75+t268-2.352214705976647*
        t36*t29*gradb*t3*t39*t151*t111*t77)+5.312868949232586*t36*
        t21*t76*t172*t207*t160-2.656434474616293*t36*t21*t173*t141*
        t160-2.656434474616293*t36*t21*t172*t141*t159)+0.5*t12*t27*
        t3*t33*t5*(t265-25.0*t12*t151*t28*t30*t31*gradb)-6.25*t128*
        t153*t27*t28*t3*t30*t33*t35*gradb-6.25*t128*t151*t27*t28*t3*
        t30*t32*t33*gradb+gradb*t5*t151*t27*t33+gradb*t5*t12*t27*t153*
        t33+t264+t263+t262+t261-0.003188484444444*t14*t17*t35*t174*
        t206*t161+0.009565453333333*t14*t17*t151*t32*t174*t108)+t175+
        t171+t170;
    d2fdrbgab = t4*(0.003188484444444*t108*t14*t17*t35*(2.656434474616293*
        t21*t36*(-0.695452919183101*t158*t3*t39*t40*t73*t77-2.781811676732402*
        t111*t151*t3*t39*t75-1.0*t151*t21*t36*t41*t5+t276+t275)*t79-
        2.656434474616293*t36*t21*t76*t141*(-1.328217237308146*t28*
        t16*t5*t37*t158*t77*t73-1.176107352988323*t36*t29*t3*t39*t40*
        t158*t144*t73+t278-2.656434474616293*t28*t16*t5*t151*t41*t75+
        t277-2.352214705976647*t36*t29*t3*t39*t151*t111*t77)+5.312868949232586*
        t36*t21*t76*t180*t207*t160-2.656434474616293*t36*t21*t183*
        t141*t160-2.656434474616293*t36*t21*t180*t141*t159)+0.5*t12*
        t27*t3*(t274-25.0*t12*t151*t28*t30*t31)*t33*t5-6.25*t128*t153*
        t27*t28*t3*t30*t33*t35-6.25*t128*t151*t27*t28*t3*t30*t32*t33+
        t5*t151*t27*t33+t5*t12*t27*t153*t33+t273+t272+t271+t270-0.003188484444444*
        t14*t17*t35*t184*t206*t161+0.009565453333333*t14*t17*t151*
        t32*t184*t108)+t185+t177+t176;
    d2fdgaga = t4*(0.003188484444444*t108*t14*t17*t35*(2.656434474616293*
        t21*t36*(1.390905838366201*t1*t39*t40*t75+t182+t181)*t79+5.312868949232586*
        POW(t166,2.0)*t207*t21*t36*t76-2.656434474616293*t36*t21*t76*
        (t179+t178+1.176107352988323*t36*t29*t1*t39*t40*t77)*t141-
        5.312868949232586*t36*t21*t167*t166*t141)+26.04166666666667*
        t1*t110*t27*t288*t289*t3*t33*t36-25.0*t1*t128*t27*t28*t30*
        t33*t35-0.003188484444444*t14*POW(t168,2.0)*t17*t206*t35+t177+
        t176);
    d2fdgagb = t4*(26.04166666666667*t110*t27*t288*t289*t3*
        t33*t36*grada*gradb-25.0*t128*t27*t28*t30*t33*t35*grada*gradb+
        0.003188484444444*t14*t17*t35*t108*(1.176107352988323*t36*
        t29*grada*gradb*t39*t40*t79*t75-3.124252118327895*t28*t290*
        grada*gradb*t39*t40*t76*t141*t77-2.656434474616293*t36*t21*
        t167*t172*t141-2.656434474616293*t36*t21*t173*t166*t141+5.312868949232586*
        t36*t21*t76*t166*t172*t207)-0.003188484444444*t14*t17*t35*
        t168*t174*t206);
    d2fdgagab = t4*(26.04166666666667*t110*t27*t288*t289*
        t3*t33*t36*grada-25.0*t128*t27*t28*t30*t33*t35*grada+0.003188484444444*
        t14*t17*t35*t108*(1.176107352988323*t36*t29*grada*t39*t40*
        t79*t75-3.124252118327895*t28*t290*grada*t39*t40*t76*t141*
        t77-2.656434474616293*t36*t21*t183*t166*t141-2.656434474616293*
        t36*t21*t167*t180*t141+5.312868949232586*t36*t21*t76*t180*
        t166*t207)-0.003188484444444*t14*t17*t35*t184*t168*t206);
    d2fdgbgb = t4*
        (0.003188484444444*t108*t14*t17*t35*(2.656434474616293*t21*
        t36*(1.390905838366201*t2*t39*t40*t75+t182+t181)*t79+5.312868949232586*
        POW(t172,2.0)*t207*t21*t36*t76-2.656434474616293*t36*t21*t76*
        (t179+t178+1.176107352988323*t36*t29*t2*t39*t40*t77)*t141-
        5.312868949232586*t36*t21*t173*t172*t141)+26.04166666666667*
        t110*t2*t27*t288*t289*t3*t33*t36-25.0*t128*t2*t27*t28*t30*
        t33*t35-0.003188484444444*t14*t17*POW(t174,2.0)*t206*t35+t177+
        t176);
    d2fdgbgab = t4*(26.04166666666667*t110*t27*t288*t289*
        t3*t33*t36*gradb-25.0*t128*t27*t28*t30*t33*t35*gradb+0.003188484444444*
        t14*t17*t35*t108*(1.176107352988323*t36*t29*gradb*t39*t40*
        t79*t75-3.124252118327895*t28*t290*gradb*t39*t40*t76*t141*
        t77-2.656434474616293*t36*t21*t183*t172*t141-2.656434474616293*
        t36*t21*t173*t180*t141+5.312868949232586*t36*t21*t76*t180*
        t172*t207)-0.003188484444444*t14*t17*t35*t184*t174*t206);
    d2fdgabgab = t4*
        (0.003188484444444*t108*t14*t17*t35*(-3.124252118327895*t28*
        t290*t39*t40*t76*t141*t77+5.312868949232586*POW(t180,2.0)*
        t207*t21*t36*t76+1.176107352988323*t36*t29*t39*t40*t79*t75-
        5.312868949232586*t36*t21*t183*t180*t141)+26.04166666666667*
        t110*t27*t288*t289*t3*t33*t36-25.0*t128*t27*t28*t30*t33*t35-
        0.003188484444444*t14*t17*POW(t184,2.0)*t206*t35);


    ds->df1000 += factor*dfdra;
    ds->df0100 += factor*dfdrb;
    ds->df0010 += factor*dfdga;
    ds->df0001 += factor*dfdgb;
    ds->df00001+= factor*dfdgab;

    ds->df2000 += factor*d2fdrara;
    ds->df1100 += factor*d2fdrarb;
    ds->df1010 += factor*d2fdraga;
    ds->df1001 += factor*d2fdragb;
    ds->df10001+= factor*d2fdraab;
    ds->df0200 += factor*d2fdrbrb;
    ds->df0110 += factor*d2fdrbga;
    ds->df0101 += factor*d2fdrbgb;
    ds->df01001+= factor*d2fdrbgab;
    ds->df0020 += factor*d2fdgaga;
    ds->df0011 += factor*d2fdgagb;
    ds->df00101+= factor*d2fdgagab;
    ds->df0002 += factor*d2fdgbgb;
    ds->df00011+= factor*d2fdgbgab;
    ds->df00002+= factor*d2fdgabgab;

}

static void
pw92c_third(FunThirdFuncDrv *ds, real factor, const FunDensProp* dp)
{
    real dfdra, dfdrb, dfdga, dfdgb, dfdgab;
    real d2fdrara, d2fdrarb, d2fdraga, d2fdragb, d2fdraab, d2fdrbrb,
        d2fdrbga, d2fdrbgb, d2fdrbgab, d2fdgaga, d2fdgagb, d2fdgagab,
        d2fdgbgb, d2fdgbgab, d2fdgabgab;
    real d3fdrarara, d3fdrararb, d3fdraraga, d3fdraragb, d3fdraraab,
         d3fdrarbrb, d3fdrarbga, d3fdrarbgb, d3fdrarbab, d3fdragaga,
         d3fdragagb, d3fdragaab, d3fdragbgb, d3fdragbab, d3fdraabab,
         d3fdrbrbrb, d3fdrbrbga, d3fdrbrbgb, d3fdrbrbab, d3fdrbgaga,
         d3fdrbgagb, d3fdrbgaab, d3fdrbgbgb, d3fdrbgbab, d3fdrbabab,
         d3fdgagaga, d3fdgagagb, d3fdgagaab, d3fdgagbgb, d3fdgagbab,
         d3fdgaabab, d3fdgbgbgb, d3fdgbgbab, d3fdgbabab, d3fdababab;
    real rhoa = dp->rhoa, rhob = dp->rhob;
    real grada = dp->grada, gradb = dp->gradb, gradab = dp->gradab;

    real t1, t2, t3, t4, t5, t6, t7, t8, t9, t10;
    real t11, t12, t13, t14, t15, t16, t17, t18;
    real t19, t20, t21, t22, t23, t24, t25, t26;
    real t27, t28, t29, t30, t31, t32, t33, t34;
    real t35, t36, t37, t38, t39, t40, t41, t42;
    real t43, t44, t45, t46, t47, t48, t49, t50;
    real t51, t52, t53, t54, t55, t56, t57, t58;
    real t59, t60, t61, t62, t63, t64, t65, t66;
    real t67, t68, t69, t70, t71, t72, t73, t74;
    real t75, t76, t77, t78, t79, t80, t81, t82;
    real t83, t84, t85, t86, t87, t88, t89, t90;
    real t91, t92, t93, t94, t95, t96, t97, t98;
    real t99, t100, t101, t102, t103, t104, t105;
    real t106, t107, t108, t109, t110, t111, t112;
    real t113, t114, t115, t116, t117, t118, t119;
    real t120, t121, t122, t123, t124, t125, t126;
    real t127, t128, t129, t130, t131, t132, t133;
    real t134, t135, t136, t137, t138, t139, t140;
    real t141, t142, t143, t144, t145, t146, t147;
    real t148, t149, t150, t151, t152, t153, t154;
    real t155, t156, t157, t158, t159, t160, t161;
    real t162, t163, t164, t165, t166, t167, t168;
    real t169, t170, t171, t172, t173, t174, t175;
    real t176, t177, t178, t179, t180, t181, t182;
    real t183, t184, t185, t186, t187, t188, t189;
    real t190, t191, t192, t193, t194, t195, t196;
    real t197, t198, t199, t200, t201, t202, t203;
    real t204, t205, t206, t207, t208, t209, t210;
    real t211, t212, t213, t214, t215, t216, t217;
    real t218, t219, t220, t221, t222, t223, t224;
    real t225, t226, t227, t228, t229, t230, t231;
    real t232, t233, t234, t235, t236, t237, t238;
    real t239, t240, t241, t242, t243, t244, t245;
    real t246, t247, t248, t249, t250, t251, t252;
    real t253, t254, t255, t256, t257, t258, t259;
    real t260, t261, t262, t263, t264, t265, t266;
    real t267, t268, t269, t270, t271, t272, t273;
    real t274, t275, t276, t277, t278, t279, t280;
    real t281, t282, t283, t284, t285, t286, t287;
    real t288, t289, t290, t291, t292, t293, t294;
    real t295, t296, t297, t298, t299, t300, t301;
    real t302, t303, t304, t305, t306, t307, t308;
    real t309, t310, t311, t312, t313, t314, t315;
    real t316, t317, t318, t319, t320, t321, t322;
    real t323, t324, t325, t326, t327, t328, t329;
    real t330, t331, t332, t333, t334, t335, t336;
    real t337, t338, t339, t340, t341, t342, t343;
    real t344, t345, t346, t347, t348, t349, t350;
    real t351, t352, t353, t354, t355, t356, t357;
    real t358, t359, t360, t361, t362, t363, t364;
    real t365, t366, t367, t368, t369, t370, t371;
    real t372, t373, t374, t375, t376, t377, t378;
    real t379, t380, t381, t382, t383, t384, t385;
    real t386, t387, t388, t389, t390, t391, t392;
    real t393, t394, t395, t396, t397, t398, t399;
    real t400, t401, t402, t403, t404, t405, t406;
    real t407, t408, t409, t410, t411, t412, t413;
    real t414, t415, t416, t417, t418, t419, t420;
    real t421, t422, t423, t424, t425, t426, t427;
    real t428, t429, t430, t431, t432, t433, t434;
    real t435, t436, t437, t438, t439, t440, t441;
    real t442, t443, t444, t445, t446, t447, t448;
    real t449, t450, t451, t452, t453, t454, t455;
    real t456, t457, t458, t459, t460, t461, t462;
    real t463, t464, t465, t466, t467, t468, t469;
    real t470, t471, t472, t473, t474, t475, t476;
    real t477, t478, t479, t480, t481, t482, t483;
    real t484, t485, t486, t487, t488, t489, t490;
    real t491, t492, t493, t494, t495, t496, t497;
    real t498, t499, t500, t501, t502, t503, t504;
    real t505, t506, t507, t508, t509, t510, t511;
    real t512, t513, t514, t515, t516, t517, t518;
    real t519, t520, t521, t522, t523, t524, t525;
    real t526, t527, t528, t529, t530, t531, t532;
    real t533, t534, t535, t536, t537, t538, t539;
    real t540, t541, t542, t543, t544, t545, t546;
    real t547, t548, t549, t550, t551, t552, t553;
    real t554, t555, t556, t557, t558, t559, t560;
    real t561, t562, t563, t564, t565, t566, t567;
    real t568, t569, t570, t571, t572, t573, t574;
    real t575, t576, t577, t578, t579, t580, t581;
    real t582, t583, t584, t585, t586, t587, t588;
    real t589, t590, t591, t592, t593, t594, t595;
    real t596, t597, t598, t599, t600, t601, t602;
    real t603, t604, t605, t606, t607, t608, t609;
    real t610, t611, t612, t613, t614, t615, t616;
    real t617, t618, t619, t620, t621, t622, t623;
    real t624, t625, t626, t627, t628, t629, t630;
    real t631, t632, t633, t634, t635, t636, t637;
    real t638, t639, t640, t641, t642, t643, t644;
    real t645, t646, t647, t648, t649, t650, t651;
    real t652, t653, t654, t655, t656, t657, t658;
    real t659, t660, t661, t662, t663, t664, t665;
    real t666, t667, t668, t669, t670, t671, t672;
    real t673, t674, t675, t676, t677, t678, t679;
    real t680, t681, t682, t683, t684, t685, t686;
    real t687, t688, t689, t690, t691, t692, t693;
    real t694, t695, t696, t697, t698, t699, t700;
    real t701, t702, t703, t704, t705, t706, t707;
    real t708, t709, t710, t711, t712, t713, t714;
    real t715, t716, t717, t718, t719, t720, t721;
    real t722, t723, t724, t725, t726, t727, t728;
    real t729, t730, t731;

    t1 = POW(grada,2.0);
    t2 = POW(gradb,2.0);
    t3 = 2.0*gradab+t2+t1;
    t4 = rhob+rhoa;
    t5 = 1/POW(t4,2.333333333333333);
    t6 = rhoa-1.0*rhob;
    t7 = 1/t4;
    t8 = 1.0-1.0*t6*t7;
    t9 = POW(t8,0.666666666666667);
    t10 = t6*t7+1.0;
    t11 = POW(t10,0.666666666666667);
    t12 = t11+t9;
    t13 = 0.318309886183791;
    t14 = POW(3.0,0.666666666666667);
    t15 = 1/POW(4.0,0.666666666666667);
    t16 = POW(3.141592653589793,0.666666666666667);
    t17 = 1/t16;
    t18 = 1/POW(t4,0.666666666666667);
    t19 = POW(3.0,0.333333333333333);
    t20 = 1/POW(4.0,0.333333333333333);
    t21 = POW(3.141592653589793,0.333333333333333);
    t22 = 1/t21;
    t23 = 1/POW(t4,0.333333333333333);
    t24 = 0.0554175*t13*t7+8.723*t19*t20*t22*t23+0.472*t14*
        t15*t17*t18+1.0;
    t25 = 1/t24;
    t26 = 23.266*t19*t20*t22*t23+0.007389*t14*t15*t17*t18+
        2.568;
    t27 = 0.001*t25*t26-0.001853571428571;
    t28 = 1/t14;
    t29 = POW(3.141592653589793,1.333333333333333);
    t30 = 1/t29;
    t31 = 1/POW(t4,2.666666666666667);
    t32 = POW(t12,2.0);
    t33 = 1/POW(2.718281828459045,6.25*t28*t3*t30*t31*t32);
    t34 = 0.5*
        t12*t27*t3*t33*t5;
    t35 = POW(t12,3.0);
    t36 = 1/t19;
    t37 = 1/t32;
    t38 = POW(t3,2.0);
    t39 = 1/POW(t4,4.666666666666667);
    t40 = POW(t12,4.0);
    t41 = 1/t40;
    t42 = 1/t35;
    t43 = 0.2137*t19*t20*t22*t23+1.0;
    t44 = 1/POW(t4,0.666666666666667);
    t45 = 1.732050807568877;
    t46 = 0.564189583547756;
    t47 = SQRT(t4);
    t48 = 1/t47;
    t49 = POW(2.0,0.333333333333333);
    t50 = 1/t49;
    t51 = POW(3.0,0.166666666666667);
    t52 = 1/POW(3.141592653589793,0.166666666666667);
    t53 = 1/POW(t4,0.166666666666667);
    t54 = 7.5957*t50*t51*t52*t53+3.5876*t19*t20*t22*t23+0.8191*
        t45*t46*t48+0.189700432574756*t44;
    t55 = 16.0818243221511/t54+1.0;
    t56 = LOG(t55);
    t57 = 1/(2.0*t49-2.0);
    t58 = POW(t6,4.0);
    t59 = 1/POW(t4,4.0);
    t60 = 1.0-1.0*t58*t59;
    t61 = 0.11125*t19*t20*t22*t23+1.0;
    t62 = POW(t8,1.333333333333333);
    t63 = POW(t10,1.333333333333333);
    t64 = t63+t62-2.0;
    t65 = 10.357*t50*t51*t52*t53+3.6231*t19*t20*t22*t23+0.44013*
        t45*t46*t48+0.191151259512734*t44;
    t66 = 29.60857464321668/t65+1.0;
    t67 = LOG(t66);
    t68 = 0.20548*t19*t20*t22*t23+1.0;
    t69 = 14.1189*t50*t51*t52*t53+6.1977*t19*t20*t22*t23+
        1.6831*t45*t46*t48+0.240587129128819*t44;
    t70 = 32.1646831778707/t69+1.0;
    t71 = LOG(t70);
    t72 = 0.062182*t43*t56-0.03109*t68*t71;
    t73 = t57*t58*t59*t64*t72+0.019751789702565*t57*t60*t61*
        t64*t67-0.062182*t43*t56;
    t74 = 1/POW(2.718281828459045,313.6286274635529*t28*t16*
        t42*t73);
    t75 = t74-1.0;
    t76 = 1/t75;
    t77 = 0.173863229795775*t38*t39*t41*t76+0.25*t21*t3*t36*
        t37*t5;
    t78 = 1/POW(t75,2.0);
    t79 = 0.14701341912354*t36*t29*t38*t39*t41*t78+0.664108618654073*
        t28*t16*t3*t5*t37*t76+1.0;
    t80 = 1/t79;
    t81 = 2.656434474616293*t36*t21*t77*t80+1.0;
    t82 = LOG(t81);
    t83 = 0.003188484444444*t14*t17*t35*t82;
    t84 = 1/POW(t4,1.666666666666667);
    t85 = 1/POW(t4,1.333333333333333);
    t86 = -7.755333333333333*t19*t20*t22*t85-0.004926*t14*
        t15*t17*t84;
    t87 = 1/POW(t4,2.0);
    t88 = -2.907666666666667*t19*t20*t22*t85-0.314666666666667*
        t14*t15*t17*t84-0.0554175*t13*t87;
    t89 = 1/POW(t24,2.0);
    t90 = 0.001*t86*t25-0.001*t88*t89*t26;
    t91 = 0.5*t12*t3*t33*t5*t90;
    t92 = t6*t87;
    t93 = -1.0*t7;
    t94 = t93+t92;
    t95 = POW(t8,0.333333333333333);
    t96 = 1/t95;
    t97 = -1.0*t6*t87;
    t98 = t7+t97;
    t99 = POW(t10,0.333333333333333);
    t100 = 1/t99;
    t101 = 0.666666666666667*t100*t98+0.666666666666667*t94*
        t96;
    t102 = 0.5*t101*t27*t3*t33*t5;
    t103 = 1/POW(t4,3.333333333333333);
    t104 = -1.166666666666667*t103*t12*t27*t3*t33;
    t105 = 1/POW(t4,3.666666666666667);
    t106 = 16.66666666666667*t105*t28*t3*t30*t32;
    t107 = t106-12.5*t101*t12*t28*t3*t30*t31;
    t108 = 0.5*t107*t12*t27*t3*t33*t5;
    t109 = 1/t81;
    t110 = -0.583333333333333*t103*t21*t3*t36*t37;
    t111 = POW(t12,5.0);
    t112 = 1/t111;
    t113 = 1/POW(t4,5.666666666666667);
    t114 = -0.811361739046951*t113*t38*t41*t76;
    t115 = 1/POW(t4,1.666666666666667);
    t116 = 1/POW(t47,3.0);
    t117 = 1/POW(t4,1.166666666666667);
    t118 = -1.26595*t50*t51*t52*t117-1.195866666666667*t19*
        t20*t22*t85-0.40955*t45*t46*t116-0.126466955049837*t115;
    t119 = 1/
        POW(t54,2.0);
    t120 = 1/t55;
    t121 = 1.0*t118*t43*t119*t120;
    t122 = -1.726166666666666*t50*t51*t52*t117-1.2077*t19*
        t20*t22*t85-0.220065*t45*t46*t116-0.127434173008489*t115;
    t123 = 1/
        POW(t65,2.0);
    t124 = 1/t66;
    t125 = -0.58482233974552*t57*t60*t122*t61*t123*t64*t124;
    t126 = 0.004429431133333*
        t19*t20*t22*t85*t56;
    t127 = 1.333333333333333*t98*t99+1.333333333333333*t94*
        t95;
    t128 = -7.324622014701263E-4*t57*t19*t20*t22*t85*t60*
        t64*t67;
    t129 = 1/POW(t4,5.0);
    t130 = 4.0*t129*t58;
    t131 = POW(t6,3.0);
    t132 = t130-4.0*t131*t59;
    t133 = -2.35315*t50*t51*t52*t117-2.0659*t19*t20*t22*t85-
        0.84155*t45*t46*t116-0.160391419419213*t115;
    t134 = 1/POW(t69,2.0);
    t135 = 1/t70;
    t136 = 0.002129457733333*t19*t20*t22*t85*t71-0.004429431133333*
        t19*t20*t22*t85*t56+t133*t68*t134*t135-1.0*t118*t43*t119*t120;
    t137 = t57*
        t58*t59*t64*t136;
    t138 = -4.0*t129*t57*t58*t64*t72;
    t139 = 4.0*t131*t57*t59*t64*t72+t57*t58*t59*t127*t72+
        0.019751789702565*t57*t132*t61*t64*t67+0.019751789702565*t57*
        t60*t61*t127*t67+t138+t137+t128+t126+t125+t121;
    t140 = 940.8858823906587*t28*t16*t101*t41*t73-313.6286274635529*
        t28*t16*t42*t139;
    t141 = -0.173863229795775*t140*t38*t39*t41*t74*t78-0.695452919183101*
        t101*t112*t38*t39*t76-0.5*t101*t21*t3*t36*t42*t5+t114+t110;
    t142 = 1/
        POW(t79,2.0);
    t143 = -0.686062622576522*t36*t29*t38*t113*t41*t78;
    t144 = -
        1.549586776859504*t28*t16*t3*t103*t37*t76;
    t145 = 1/POW(t75,3.0);
    t146 = -0.664108618654073*t28*t16*t3*t5*t37*t140*t78*
        t74-0.294026838247081*t36*t29*t38*t39*t41*t140*t145*t74+t144-
        1.328217237308146*t28*t16*t3*t5*t101*t42*t76+t143-0.588053676494162*
        t36*t29*t38*t39*t101*t112*t78;
    t147 = 2.656434474616293*t36*t21*t80*t141-2.656434474616293*
        t36*t21*t77*t142*t146;
    t148 = 0.003188484444444*t14*t17*t35*t109*t147;
    t149 = 0.009565453333333*t14*t17*t101*t32*t82;
    t150 = t7+t92;
    t151 = t93+t97;
    t152 = 0.666666666666667*t150*t96+0.666666666666667*t100*
        t151;
    t153 = 0.5*t152*t27*t3*t33*t5;
    t154 = t106-12.5*t12*t152*t28*t3*t30*t31;
    t155 = 0.5*t12*t154*t27*t3*t33*t5;
    t156 = 1.333333333333333*t151*t99+1.333333333333333*t150*
        t95;
    t157 = 4.0*t131*t59+t130;
    t158 = -4.0*t131*t57*t59*t64*t72+t57*t58*t59*t156*t72+
        0.019751789702565*t57*t157*t61*t64*t67+0.019751789702565*t57*
        t60*t61*t156*t67+t138+t137+t128+t126+t125+t121;
    t159 = 940.8858823906587*t28*t16*t152*t41*t73-313.6286274635529*
        t28*t16*t42*t158;
    t160 = -0.173863229795775*t159*t38*t39*t41*t74*t78-0.695452919183101*
        t112*t152*t38*t39*t76-0.5*t152*t21*t3*t36*t42*t5+t114+t110;
    t161 = -
        0.664108618654073*t28*t16*t3*t5*t37*t159*t78*t74-0.294026838247081*
        t36*t29*t38*t39*t41*t159*t145*t74+t144-1.328217237308146*t28*
        t16*t3*t5*t152*t42*t76+t143-0.588053676494162*t36*t29*t38*
        t39*t152*t112*t78;
    t162 = 2.656434474616293*t36*t21*t80*t160-2.656434474616293*
        t36*t21*t77*t142*t161;
    t163 = 0.003188484444444*t14*t17*t35*t109*t162;
    t164 = 0.009565453333333*t14*t17*t152*t32*t82;
    t165 = grada*t5*t12*t27*t33;
    t166 = -6.25*t129*t27*t28*t3*t30*t33*t35*grada;
    t167 = 1.328217237308146*t28*t16*grada*t5*t37*t76+0.588053676494162*
        t36*t29*grada*t3*t39*t41*t78;
    t168 = 0.695452919183101*t3*t39*t41*t76*grada+0.5*t21*
        t36*t37*t5*grada;
    t169 = 2.656434474616293*t36*t21*t168*t80-2.656434474616293*
        t36*t21*t77*t167*t142;
    t170 = 0.003188484444444*t14*t17*t35*t169*t109;
    t171 = gradb*t5*t12*t27*t33;
    t172 = -6.25*t129*t27*t28*t3*t30*t33*t35*gradb;
    t173 = 1.328217237308146*t28*t16*gradb*t5*t37*t76+0.588053676494162*
        t36*t29*gradb*t3*t39*t41*t78;
    t174 = 0.695452919183101*t3*t39*t41*t76*gradb+0.5*t21*
        t36*t37*t5*gradb;
    t175 = 2.656434474616293*t36*t21*t174*t80-2.656434474616293*
        t36*t21*t77*t173*t142;
    t176 = 0.003188484444444*t14*t17*t35*t175*t109;
    t177 = t5*t12*t27*t33;
    t178 = -6.25*t129*t27*t28*t3*t30*t33*t35;
    t179 = 0.588053676494162*t36*t29*t3*t39*t41*t78;
    t180 = 1.328217237308146*t28*t16*t5*t37*t76;
    t181 = t180+t179;
    t182 = 0.5*t21*t36*t37*t5;
    t183 = 0.695452919183101*t3*t39*t41*t76;
    t184 = t183+t182;
    t185 = 2.656434474616293*t36*t21*t184*t80-2.656434474616293*
        t36*t21*t77*t181*t142;
    t186 = 0.003188484444444*t14*t17*t35*t185*t109;
    t187 = t3*t5*t12*t90*t33;
    t188 = -2.333333333333333*t103*t12*t27*t3*t33;
    t189 = 10.34044444444444*t19*t20*t22*t5+0.00821*t14*t15*
        t17*t31;
    t190 = POW(t88,2.0);
    t191 = 1/POW(t24,3.0);
    t192 = 1/POW(t4,3.0);
    t193 = 3.876888888888889*t19*t20*t22*t5+0.524444444444444*
        t14*t15*t17*t31+0.110835*t13*t192;
    t194 = -0.001*t193*t89*t26+0.002*t190*t191*t26+0.001*
        t189*t25-0.002*t86*t88*t89;
    t195 = 0.5*t12*t194*t3*t33*t5;
    t196 = t3*t5*t101*t90*t33;
    t197 = -2.333333333333333*t103*t12*t3*t33*t90;
    t198 = POW(t94,2.0);
    t199 = 1/t62;
    t200 = -2.0*t192*t6;
    t201 = 2.0*t87;
    t202 = t201+t200;
    t203 = POW(t98,2.0);
    t204 = 1/t63;
    t205 = 2.0*t192*t6;
    t206 = -2.0*t87;
    t207 = t206+t205;
    t208 = 0.666666666666667*t202*t96+0.666666666666667*t100*
        t207-0.222222222222222*t203*t204-0.222222222222222*t198*t199;
    t209 = 0.5*
        t208*t27*t3*t33*t5;
    t210 = -2.333333333333333*t101*t103*t27*t3*t33;
    t211 = 1/POW(t4,4.333333333333333);
    t212 = 3.888888888888889*t12*t211*t27*t3*t33;
    t213 = POW(t101,2.0);
    t214 = -61.11111111111111*t28*t3*t30*t32*t39;
    t215 = -12.5*t213*t28*t3*t30*t31-12.5*t12*t208*t28*t3*
        t30*t31+66.66666666666667*t101*t105*t12*t28*t3*t30+t214;
    t216 = 0.5*
        t12*t215*t27*t3*t33*t5;
    t217 = t3*t5*t12*t90*t107*t33;
    t218 = t3*t5*t101*t27*t107*t33;
    t219 = -2.333333333333333*t103*t107*t12*t27*t3*t33;
    t220 = POW(t107,
        2.0);
    t221 = 0.5*t12*t220*t27*t3*t33*t5;
    t222 = 0.019130906666667*t14*t17*t101*t32*t109*t147;
    t223 = 1/
        POW(t81,2.0);
    t224 = POW(t147,2.0);
    t225 = -0.003188484444444*t14*t17*t35*t223*t224;
    t226 = 1/POW(t79,3.0);
    t227 = POW(t146,2.0);
    t228 = 1.944444444444444*t21*t211*t3*t36*t37;
    t229 = POW(t140,2.0);
    t230 = 1/POW(2.718281828459045,627.2572549271058*t28*
        t16*t42*t73);
    t231 = 1/POW(t12,6.0);
    t232 = 1/POW(t4,6.666666666666667);
    t233 = 4.597716521266054*t232*t38*t41*t76;
    t234 = POW(t118,2.0);
    t235 = 1/POW(t54,4.0);
    t236 = 1/POW(t55,2.0);
    t237 = 16.0818243221511*t234*t43*t235*t236;
    t238 = 1/POW(t54,3.0);
    t239 = -2.0*t234*t43*t238*t120;
    t240 = -0.142466666666667*t19*t20*t22*t85*t118*t119*t120;
    t241 = 1/
        POW(t4,2.666666666666667);
    t242 = 1/POW(t47,5.0);
    t243 = 1/POW(t4,2.166666666666667);
    t244 = 1.476941666666667*t50*t51*t52*t243+1.594488888888889*
        t19*t20*t22*t5+0.614325*t45*t46*t242+0.210778258416395*t241;
    t245 = 1.0*
        t244*t43*t119*t120;
    t246 = POW(t122,2.0);
    t247 = 1/POW(t65,4.0);
    t248 = 1/POW(t66,2.0);
    t249 = -17.31575589937587*t57*t60*t246*t61*t247*t64*t248;
    t250 = 1/
        POW(t65,3.0);
    t251 = 1.169644679491041*t57*t60*t246*t61*t250*t64*t124;
    t252 = 0.043374323531126*
        t57*t19*t20*t22*t85*t60*t122*t123*t64*t124;
    t253 = 2.013861111111111*t50*t51*t52*t243+1.610266666666667*
        t19*t20*t22*t5+0.3300975*t45*t46*t242+0.212390288347482*t241;
    t254 = -
        0.58482233974552*t57*t60*t253*t61*t123*t64*t124;
    t255 = -0.005905908177778*t19*t20*t22*t5*t56;
    t256 = 1/t9;
    t257 = 1/t11;
    t258 = 1.333333333333333*t207*t99+1.333333333333333*t202*
        t95+0.444444444444444*t203*t257+0.444444444444444*t198*t256;
    t259 = 9.76616268626835E-4*t57*t19*t20*t22*t5*t60*t64*
        t67;
    t260 = 1/POW(t4,6.0);
    t261 = -20.0*t260*t58;
    t262 = POW(t6,2.0);
    t263 = -12.0*t262*t59;
    t264 = t263+t261+32.0*t129*t131;
    t265 = POW(t133,2.0);
    t266 = 1/POW(t69,4.0);
    t267 = 1/POW(t70,2.0);
    t268 = 1/POW(t69,3.0);
    t269 = 2.745341666666667*t50*t51*t52*t243+2.754533333333333*
        t19*t20*t22*t5+1.262325*t45*t46*t242+0.267319032365355*t241;
    t270 = -
        0.002839276977778*t19*t20*t22*t5*t71-2.0*t135*t265*t268*t68+
        0.005905908177778*t19*t20*t22*t5*t56+32.1646831778707*t265*
        t68*t266*t267-16.0818243221511*t234*t43*t235*t236+t269*t68*
        t134*t135-0.136986666666667*t19*t20*t22*t85*t133*t134*t135+
        2.0*t234*t43*t238*t120-1.0*t244*t43*t119*t120+0.142466666666667*
        t19*t20*t22*t85*t118*t119*t120;
    t271 = t57*t58*t59*t64*t270;
    t272 = -8.0*t129*t136*t57*t58*t64;
    t273 = 20.0*t260*t57*t58*t64*t72;
    t274 = 12.0*t262*t57*t59*t64*t72;
    t275 = -32.0*t129*t131*t57*t64*t72+8.0*t127*t131*t57*
        t59*t72-8.0*t127*t129*t57*t58*t72+t57*t58*t59*t258*t72+0.019751789702565*
        t57*t264*t61*t64*t67-0.00146492440294*t57*t19*t20*t22*t85*
        t132*t64*t67+0.019751789702565*t57*t60*t61*t258*t67+0.03950357940513*
        t57*t132*t61*t127*t67-0.00146492440294*t57*t19*t20*t22*t85*
        t60*t127*t67+8.0*t131*t136*t57*t59*t64+2.0*t127*t136*t57*t58*
        t59+t274+t273+t272+t271+t259+t255+t254+t252+t251+t249+t245+
        t240+t239+t237-1.169644679491041*t57*t132*t122*t61*t123*t64*
        t124-1.169644679491041*t57*t60*t122*t61*t123*t127*t124;
    t276 = 940.8858823906587*t28*t16*t208*t41*t73-3763.543529562635*
        t28*t16*t213*t112*t73+1881.771764781317*t28*t16*t101*t41*t139-
        313.6286274635529*t28*t16*t42*t275;
    t277 = -0.173863229795775*t276*t38*t39*t41*t74*t78-0.173863229795775*
        t229*t38*t39*t41*t74*t78+1.622723478093901*t113*t140*t38*t41*
        t74*t78+1.390905838366201*t101*t112*t140*t38*t39*t74*t78+3.477264595915503*
        t213*t231*t38*t39*t76-0.695452919183101*t112*t208*t38*t39*
        t76+6.490893912375606*t101*t112*t113*t38*t76-0.5*t208*t21*
        t3*t36*t42*t5+1.5*t21*t213*t3*t36*t41*t5+2.333333333333333*
        t101*t103*t21*t3*t36*t42+0.34772645959155*t145*t229*t230*t38*
        t39*t41+t233+t228;
    t278 = 1/POW(t75,4.0);
    t279 = 3.887688194600291*t36*t29*t38*t232*t41*t78;
    t280 = 5.165289256198347*t28*t16*t3*t211*t37*t76;
    t281 = -0.664108618654073*t28*t16*t3*t5*t37*t229*t78*
        t74+3.099173553719008*t28*t16*t3*t103*t37*t140*t78*t74+2.656434474616293*
        t28*t16*t3*t5*t101*t42*t140*t78*t74-0.664108618654073*t28*
        t16*t3*t5*t37*t276*t78*t74-0.294026838247081*t36*t29*t38*t39*
        t41*t229*t145*t74+2.744250490306088*t36*t29*t38*t113*t41*t140*
        t145*t74+2.352214705976647*t36*t29*t38*t39*t101*t112*t140*
        t145*t74-0.294026838247081*t36*t29*t38*t39*t41*t276*t145*t74+
        t280+6.198347107438017*t28*t16*t3*t103*t101*t42*t76-1.328217237308146*
        t28*t16*t3*t5*t208*t42*t76+3.98465171192444*t28*t16*t3*t5*
        t213*t41*t76+t279+5.488500980612176*t36*t29*t38*t113*t101*
        t112*t78-0.588053676494162*t36*t29*t38*t39*t208*t112*t78+2.940268382470808*
        t36*t29*t38*t39*t213*t231*t78+1.328217237308146*t28*t16*t3*
        t5*t37*t229*t230*t145+0.882080514741242*t36*t29*t38*t39*t41*
        t229*t230*t278;
    t282 = -2.656434474616293*t36*t21*t77*t142*t281+2.656434474616293*
        t36*t21*t80*t277+5.312868949232586*t36*t21*t77*t226*t227-5.312868949232586*
        t36*t21*t142*t141*t146;
    t283 = 0.003188484444444*t14*t17*t35*t109*t282;
    t284 = 0.019130906666667*t14*t17*t213*t12*t82;
    t285 = 0.009565453333333*t14*t17*t208*t32*t82;
    t286 = -0.222222222222222*t151*t204*t98-1.333333333333333*
        t192*t6*t96-0.222222222222222*t150*t199*t94+1.333333333333333*
        t100*t192*t6;
    t287 = -12.5*t12*t28*t286*t3*t30*t31-12.5*t101*t152*t28*
        t3*t30*t31+33.33333333333334*t105*t12*t152*t28*t3*t30+33.33333333333334*
        t101*t105*t12*t28*t3*t30+t214;
    t288 = 2.666666666666667*t192*t6*t99+0.444444444444444*
        t151*t257*t98-2.666666666666667*t192*t6*t95+0.444444444444444*
        t150*t256*t94;
    t289 = 12.0*t262*t59+t261;
    t290 = -12.0*t262*t57*t59*t64*t72+4.0*t131*t156*t57*t59*
        t72-4.0*t127*t131*t57*t59*t72-4.0*t129*t156*t57*t58*t72-4.0*
        t127*t129*t57*t58*t72+t57*t58*t59*t288*t72+0.019751789702565*
        t57*t289*t61*t64*t67-7.324622014701263E-4*t57*t19*t20*t22*
        t85*t157*t64*t67-7.324622014701263E-4*t57*t19*t20*t22*t85*
        t132*t64*t67+0.019751789702565*t57*t60*t61*t288*t67+0.019751789702565*
        t57*t132*t61*t156*t67-7.324622014701263E-4*t57*t19*t20*t22*
        t85*t60*t156*t67+0.019751789702565*t57*t157*t61*t127*t67-7.324622014701263E-4*
        t57*t19*t20*t22*t85*t60*t127*t67+t273+t272+t271+t259+t255+
        t254+t252+t251+t249+t245+t240+t239+t237+t57*t58*t59*t156*t136+
        t57*t58*t59*t127*t136-0.58482233974552*t57*t157*t122*t61*t123*
        t64*t124-0.58482233974552*t57*t132*t122*t61*t123*t64*t124-
        0.58482233974552*t57*t60*t122*t61*t123*t156*t124-0.58482233974552*
        t57*t60*t122*t61*t123*t127*t124;
    t291 = 940.8858823906587*t28*t16*t286*t41*t73-3763.543529562635*
        t28*t16*t152*t101*t112*t73+940.8858823906587*t28*t16*t152*
        t41*t139+940.8858823906587*t28*t16*t101*t41*t158-313.6286274635529*
        t28*t16*t42*t290;
    t292 = -0.173863229795775*t291*t38*t39*t41*t74*t78-0.173863229795775*
        t140*t159*t38*t39*t41*t74*t78+0.811361739046951*t113*t159*
        t38*t41*t74*t78+0.811361739046951*t113*t140*t38*t41*t74*t78+
        0.695452919183101*t101*t112*t159*t38*t39*t74*t78+0.695452919183101*
        t112*t140*t152*t38*t39*t74*t78-0.695452919183101*t112*t286*
        t38*t39*t76+3.477264595915503*t101*t152*t231*t38*t39*t76+3.245446956187803*
        t112*t113*t152*t38*t76+3.245446956187803*t101*t112*t113*t38*
        t76-0.5*t21*t286*t3*t36*t42*t5+1.5*t101*t152*t21*t3*t36*t41*
        t5+1.166666666666667*t103*t152*t21*t3*t36*t42+1.166666666666667*
        t101*t103*t21*t3*t36*t42+0.34772645959155*t140*t145*t159*t230*
        t38*t39*t41+t233+t228;
    t293 = -0.664108618654073*t28*t16*t3*t5*t37*t159*t140*
        t78*t74+1.549586776859504*t28*t16*t3*t103*t37*t140*t78*t74+
        1.328217237308146*t28*t16*t3*t5*t152*t42*t140*t78*t74+1.549586776859504*
        t28*t16*t3*t103*t37*t159*t78*t74+1.328217237308146*t28*t16*
        t3*t5*t101*t42*t159*t78*t74-0.664108618654073*t28*t16*t3*t5*
        t37*t291*t78*t74-0.294026838247081*t36*t29*t38*t39*t41*t159*
        t140*t145*t74+1.372125245153044*t36*t29*t38*t113*t41*t140*
        t145*t74+1.176107352988323*t36*t29*t38*t39*t152*t112*t140*
        t145*t74+1.372125245153044*t36*t29*t38*t113*t41*t159*t145*
        t74+1.176107352988323*t36*t29*t38*t39*t101*t112*t159*t145*
        t74-0.294026838247081*t36*t29*t38*t39*t41*t291*t145*t74+t280+
        3.099173553719008*t28*t16*t3*t103*t101*t42*t76+3.099173553719008*
        t28*t16*t3*t103*t152*t42*t76-1.328217237308146*t28*t16*t3*
        t5*t286*t42*t76+3.98465171192444*t28*t16*t3*t5*t152*t101*t41*
        t76+t279+2.744250490306088*t36*t29*t38*t113*t101*t112*t78+
        2.744250490306088*t36*t29*t38*t113*t152*t112*t78-0.588053676494162*
        t36*t29*t38*t39*t286*t112*t78+2.940268382470808*t36*t29*t38*
        t39*t152*t101*t231*t78+1.328217237308146*t28*t16*t3*t5*t37*
        t159*t140*t230*t145+0.882080514741242*t36*t29*t38*t39*t41*
        t159*t140*t230*t278;
    t294 = -2.656434474616293*t36*t21*t77*t142*t293+2.656434474616293*
        t36*t21*t80*t292+5.312868949232586*t36*t21*t77*t226*t161*t146-
        2.656434474616293*t36*t21*t142*t160*t146-2.656434474616293*
        t36*t21*t142*t161*t141;
    t295 = grada*t5*t12*t90*t33;
    t296 = -6.25*t129*t28*t3*t30*t33*t35*t90*grada;
    t297 = grada*t5*t101*t27*t33;
    t298 = -2.333333333333333*t103*t12*t27*t33*grada;
    t299 = -6.25*t101*t129*t27*t28*t3*t30*t32*t33*grada;
    t300 = 14.58333333333333*
        t260*t27*t28*t3*t30*t33*t35*grada;
    t301 = 33.33333333333334*t105*t28*t30*t32*grada;
    t302 = t301-25.0*t101*t12*t28*t30*t31*grada;
    t303 = 0.5*t12*t27*t3*t302*t33*t5;
    t304 = grada*t5*t12*t27*t107*t33;
    t305 = -6.25*t107*t129*t27*t28*t3*t30*t33*t35*grada;
    t306 = 0.009565453333333*
        t14*t17*t101*t32*t169*t109;
    t307 = -1.166666666666667*t103*t21*t36*t37*grada;
    t308 = -3.245446956187803*t113*t3*t41*t76*grada;
    t309 = -0.695452919183101*t140*t3*t39*t41*t74*t78*grada-
        2.781811676732402*t101*t112*t3*t39*t76*grada-1.0*t101*t21*
        t36*t42*t5*grada+t308+t307;
    t310 = -2.744250490306088*t36*t29*grada*t3*t113*t41*t78;
    t311 = -
        3.099173553719008*t28*t16*grada*t103*t37*t76;
    t312 = -1.328217237308146*t28*t16*grada*t5*t37*t140*t78*
        t74-1.176107352988323*t36*t29*grada*t3*t39*t41*t140*t145*t74+
        t311-2.656434474616293*t28*t16*grada*t5*t101*t42*t76+t310-
        2.352214705976647*t36*t29*grada*t3*t39*t101*t112*t78;
    t313 = -2.656434474616293*t36*t21*t168*t142*t146+5.312868949232586*
        t36*t21*t77*t167*t226*t146-2.656434474616293*t36*t21*t77*t142*
        t312-2.656434474616293*t36*t21*t167*t142*t141+2.656434474616293*
        t36*t21*t80*t309;
    t314 = 0.003188484444444*t14*t17*t35*t109*t313;
    t315 = -0.003188484444444*t14*t17*t35*t169*t223*t147;
    t316 = gradb*
        t5*t12*t90*t33;
    t317 = -6.25*t129*t28*t3*t30*t33*t35*t90*gradb;
    t318 = gradb*t5*t101*t27*t33;
    t319 = -2.333333333333333*t103*t12*t27*t33*gradb;
    t320 = -6.25*t101*t129*t27*t28*t3*t30*t32*t33*gradb;
    t321 = 14.58333333333333*
        t260*t27*t28*t3*t30*t33*t35*gradb;
    t322 = 33.33333333333334*t105*t28*t30*t32*gradb;
    t323 = t322-25.0*t101*t12*t28*t30*t31*gradb;
    t324 = 0.5*t12*t27*t3*t323*t33*t5;
    t325 = gradb*t5*t12*t27*t107*t33;
    t326 = -6.25*t107*t129*t27*t28*t3*t30*t33*t35*gradb;
    t327 = 0.009565453333333*
        t14*t17*t101*t32*t175*t109;
    t328 = -1.166666666666667*t103*t21*t36*t37*gradb;
    t329 = -3.245446956187803*t113*t3*t41*t76*gradb;
    t330 = -0.695452919183101*t140*t3*t39*t41*t74*t78*gradb-
        2.781811676732402*t101*t112*t3*t39*t76*gradb-1.0*t101*t21*
        t36*t42*t5*gradb+t329+t328;
    t331 = -2.744250490306088*t36*t29*gradb*t3*t113*t41*t78;
    t332 = -
        3.099173553719008*t28*t16*gradb*t103*t37*t76;
    t333 = -1.328217237308146*t28*t16*gradb*t5*t37*t140*t78*
        t74-1.176107352988323*t36*t29*gradb*t3*t39*t41*t140*t145*t74+
        t332-2.656434474616293*t28*t16*gradb*t5*t101*t42*t76+t331-
        2.352214705976647*t36*t29*gradb*t3*t39*t101*t112*t78;
    t334 = -2.656434474616293*t36*t21*t174*t142*t146+5.312868949232586*
        t36*t21*t77*t173*t226*t146-2.656434474616293*t36*t21*t77*t142*
        t333-2.656434474616293*t36*t21*t173*t142*t141+2.656434474616293*
        t36*t21*t80*t330;
    t335 = 0.003188484444444*t14*t17*t35*t109*t334;
    t336 = -0.003188484444444*t14*t17*t35*t175*t223*t147;
    t337 = t5*
        t12*t90*t33;
    t338 = -6.25*t129*t28*t3*t30*t33*t35*t90;
    t339 = t5*t101*t27*t33;
    t340 = -2.333333333333333*t103*t12*t27*t33;
    t341 = -6.25*t101*t129*t27*t28*t3*t30*t32*t33;
    t342 = 14.58333333333333*t260*t27*t28*t3*t30*t33*t35;
    t343 = 33.33333333333334*
        t105*t28*t30*t32;
    t344 = t343-25.0*t101*t12*t28*t30*t31;
    t345 = 0.5*t12*t27*t3*t33*t344*t5;
    t346 = t5*t12*t27*t107*t33;
    t347 = -6.25*t107*t129*t27*t28*t3*t30*t33*t35;
    t348 = 0.009565453333333*t14*t17*t101*t32*t185*t109;
    t349 = -
        1.0*t101*t21*t36*t42*t5;
    t350 = -1.166666666666667*t103*t21*t36*t37;
    t351 = -2.781811676732402*t101*t112*t3*t39*t76;
    t352 = -3.245446956187803*t113*t3*t41*t76;
    t353 = -0.695452919183101*t140*t3*t39*t41*t74*t78;
    t354 = t353+t352+t351+t350+t349;
    t355 = -2.352214705976647*t36*t29*t3*t39*t101*t112*t78;
    t356 = -
        2.744250490306088*t36*t29*t3*t113*t41*t78;
    t357 = -2.656434474616293*t28*t16*t5*t101*t42*t76;
    t358 = -3.099173553719008*t28*t16*t103*t37*t76;
    t359 = -1.176107352988323*t36*t29*t3*t39*t41*t140*t145*
        t74;
    t360 = -1.328217237308146*t28*t16*t5*t37*t140*t78*t74;
    t361 = t360+
        t359+t358+t357+t356+t355;
    t362 = -2.656434474616293*t36*t21*t184*t142*t146+5.312868949232586*
        t36*t21*t77*t181*t226*t146-2.656434474616293*t36*t21*t77*t142*
        t361-2.656434474616293*t36*t21*t181*t142*t141+2.656434474616293*
        t36*t21*t80*t354;
    t363 = 0.003188484444444*t14*t17*t35*t109*t362;
    t364 = -0.003188484444444*t14*t17*t35*t185*t223*t147;
    t365 = t3*
        t5*t152*t90*t33;
    t366 = POW(t150,2.0);
    t367 = t206+t200;
    t368 = POW(t151,2.0);
    t369 = t201+t205;
    t370 = 0.666666666666667*t367*t96+0.666666666666667*t100*
        t369-0.222222222222222*t204*t368-0.222222222222222*t199*t366;
    t371 = 0.5*
        t27*t3*t33*t370*t5;
    t372 = -2.333333333333333*t103*t152*t27*t3*t33;
    t373 = POW(t152,2.0);
    t374 = -12.5*t28*t3*t30*t31*t373-12.5*t12*t28*t3*t30*
        t31*t370+66.66666666666667*t105*t12*t152*t28*t3*t30+t214;
    t375 = 0.5*
        t12*t27*t3*t33*t374*t5;
    t376 = t3*t5*t12*t90*t154*t33;
    t377 = t3*t5*t152*t27*t154*t33;
    t378 = -2.333333333333333*t103*t12*t154*t27*t3*t33;
    t379 = POW(t154,
        2.0);
    t380 = 0.5*t12*t27*t3*t33*t379*t5;
    t381 = 0.019130906666667*t14*t17*t152*t32*t109*t162;
    t382 = POW(t162,
        2.0);
    t383 = -0.003188484444444*t14*t17*t35*t223*t382;
    t384 = POW(t161,2.0);
    t385 = POW(t159,2.0);
    t386 = 1.333333333333333*t369*t99+1.333333333333333*t367*
        t95+0.444444444444444*t257*t368+0.444444444444444*t256*t366;
    t387 = t263+
        t261-32.0*t129*t131;
    t388 = 32.0*t129*t131*t57*t64*t72-8.0*t131*t156*t57*t59*
        t72-8.0*t129*t156*t57*t58*t72+t57*t58*t59*t386*t72+0.019751789702565*
        t57*t387*t61*t64*t67-0.00146492440294*t57*t19*t20*t22*t85*
        t157*t64*t67+0.019751789702565*t57*t60*t61*t386*t67+0.03950357940513*
        t57*t157*t61*t156*t67-0.00146492440294*t57*t19*t20*t22*t85*
        t60*t156*t67-8.0*t131*t136*t57*t59*t64+2.0*t136*t156*t57*t58*
        t59+t274+t273+t272+t271+t259+t255+t254+t252+t251+t249+t245+
        t240+t239+t237-1.169644679491041*t57*t157*t122*t61*t123*t64*
        t124-1.169644679491041*t57*t60*t122*t61*t123*t156*t124;
    t389 = 940.8858823906587*t28*t16*t370*t41*t73-3763.543529562635*
        t28*t16*t373*t112*t73+1881.771764781317*t28*t16*t152*t41*t158-
        313.6286274635529*t28*t16*t42*t388;
    t390 = -0.173863229795775*t38*t389*t39*t41*t74*t78-0.173863229795775*
        t38*t385*t39*t41*t74*t78+1.622723478093901*t113*t159*t38*t41*
        t74*t78+1.390905838366201*t112*t152*t159*t38*t39*t74*t78+3.477264595915503*
        t231*t373*t38*t39*t76-0.695452919183101*t112*t370*t38*t39*
        t76+6.490893912375606*t112*t113*t152*t38*t76-0.5*t21*t3*t36*
        t370*t42*t5+1.5*t21*t3*t36*t373*t41*t5+2.333333333333333*t103*
        t152*t21*t3*t36*t42+0.34772645959155*t145*t230*t38*t385*t39*
        t41+t233+t228;
    t391 = -0.664108618654073*t28*t16*t3*t5*t37*t385*t78*
        t74+3.099173553719008*t28*t16*t3*t103*t37*t159*t78*t74+2.656434474616293*
        t28*t16*t3*t5*t152*t42*t159*t78*t74-0.664108618654073*t28*
        t16*t3*t5*t37*t389*t78*t74-0.294026838247081*t36*t29*t38*t39*
        t41*t385*t145*t74+2.744250490306088*t36*t29*t38*t113*t41*t159*
        t145*t74+2.352214705976647*t36*t29*t38*t39*t152*t112*t159*
        t145*t74-0.294026838247081*t36*t29*t38*t39*t41*t389*t145*t74+
        t280+6.198347107438017*t28*t16*t3*t103*t152*t42*t76-1.328217237308146*
        t28*t16*t3*t5*t370*t42*t76+3.98465171192444*t28*t16*t3*t5*
        t373*t41*t76+t279+5.488500980612176*t36*t29*t38*t113*t152*
        t112*t78-0.588053676494162*t36*t29*t38*t39*t370*t112*t78+2.940268382470808*
        t36*t29*t38*t39*t373*t231*t78+1.328217237308146*t28*t16*t3*
        t5*t37*t385*t230*t145+0.882080514741242*t36*t29*t38*t39*t41*
        t385*t230*t278;
    t392 = -2.656434474616293*t36*t21*t77*t142*t391+2.656434474616293*
        t36*t21*t80*t390+5.312868949232586*t36*t21*t77*t226*t384-5.312868949232586*
        t36*t21*t142*t160*t161;
    t393 = 0.003188484444444*t14*t17*t35*t109*t392;
    t394 = 0.019130906666667*t14*t17*t373*t12*t82;
    t395 = 0.009565453333333*t14*t17*t370*t32*t82;
    t396 = grada*t5*t152*t27*t33;
    t397 = -6.25*t129*t152*t27*t28*t3*t30*t32*t33*grada;
    t398 = t301-
        25.0*t12*t152*t28*t30*t31*grada;
    t399 = 0.5*t12*t27*t3*t33*t398*t5;
    t400 = grada*t5*t12*t27*t154*t33;
    t401 = -6.25*t129*t154*t27*t28*t3*t30*t33*t35*grada;
    t402 = 0.009565453333333*
        t14*t17*t152*t32*t169*t109;
    t403 = -0.695452919183101*t159*t3*t39*t41*t74*t78*grada-
        2.781811676732402*t112*t152*t3*t39*t76*grada-1.0*t152*t21*
        t36*t42*t5*grada+t308+t307;
    t404 = -1.328217237308146*t28*t16*grada*t5*t37*t159*t78*
        t74-1.176107352988323*t36*t29*grada*t3*t39*t41*t159*t145*t74+
        t311-2.656434474616293*t28*t16*grada*t5*t152*t42*t76+t310-
        2.352214705976647*t36*t29*grada*t3*t39*t152*t112*t78;
    t405 = -2.656434474616293*t36*t21*t168*t142*t161+5.312868949232586*
        t36*t21*t77*t167*t226*t161-2.656434474616293*t36*t21*t77*t142*
        t404-2.656434474616293*t36*t21*t167*t142*t160+2.656434474616293*
        t36*t21*t80*t403;
    t406 = 0.003188484444444*t14*t17*t35*t109*t405;
    t407 = -0.003188484444444*t14*t17*t35*t169*t223*t162;
    t408 = gradb*
        t5*t152*t27*t33;
    t409 = -6.25*t129*t152*t27*t28*t3*t30*t32*t33*gradb;
    t410 = t322-
        25.0*t12*t152*t28*t30*t31*gradb;
    t411 = 0.5*t12*t27*t3*t33*t410*t5;
    t412 = gradb*t5*t12*t27*t154*t33;
    t413 = -6.25*t129*t154*t27*t28*t3*t30*t33*t35*gradb;
    t414 = 0.009565453333333*
        t14*t17*t152*t32*t175*t109;
    t415 = -0.695452919183101*t159*t3*t39*t41*t74*t78*gradb-
        2.781811676732402*t112*t152*t3*t39*t76*gradb-1.0*t152*t21*
        t36*t42*t5*gradb+t329+t328;
    t416 = -1.328217237308146*t28*t16*gradb*t5*t37*t159*t78*
        t74-1.176107352988323*t36*t29*gradb*t3*t39*t41*t159*t145*t74+
        t332-2.656434474616293*t28*t16*gradb*t5*t152*t42*t76+t331-
        2.352214705976647*t36*t29*gradb*t3*t39*t152*t112*t78;
    t417 = -2.656434474616293*t36*t21*t174*t142*t161+5.312868949232586*
        t36*t21*t77*t173*t226*t161-2.656434474616293*t36*t21*t77*t142*
        t416-2.656434474616293*t36*t21*t173*t142*t160+2.656434474616293*
        t36*t21*t80*t415;
    t418 = 0.003188484444444*t14*t17*t35*t109*t417;
    t419 = -0.003188484444444*t14*t17*t35*t175*t223*t162;
    t420 = t5*
        t152*t27*t33;
    t421 = -6.25*t129*t152*t27*t28*t3*t30*t32*t33;
    t422 = t343-25.0*t12*t152*t28*t30*t31;
    t423 = 0.5*t12*t27*t3*t33*t422*t5;
    t424 = t5*t12*t27*t154*t33;
    t425 = -6.25*t129*t154*t27*t28*t3*t30*t33*t35;
    t426 = 0.009565453333333*t14*t17*t152*t32*t185*t109;
    t427 = -
        1.0*t152*t21*t36*t42*t5;
    t428 = -2.781811676732402*t112*t152*t3*t39*t76;
    t429 = -0.695452919183101*t159*t3*t39*t41*t74*t78;
    t430 = t429+t352+t428+t350+t427;
    t431 = -2.352214705976647*t36*t29*t3*t39*t152*t112*t78;
    t432 = -
        2.656434474616293*t28*t16*t5*t152*t42*t76;
    t433 = -1.176107352988323*t36*t29*t3*t39*t41*t159*t145*
        t74;
    t434 = -1.328217237308146*t28*t16*t5*t37*t159*t78*t74;
    t435 = t434+
        t433+t358+t432+t356+t431;
    t436 = -2.656434474616293*t36*t21*t184*t142*t161+5.312868949232586*
        t36*t21*t77*t181*t226*t161-2.656434474616293*t36*t21*t77*t142*
        t435-2.656434474616293*t36*t21*t181*t142*t160+2.656434474616293*
        t36*t21*t80*t430;
    t437 = 0.003188484444444*t14*t17*t35*t109*t436;
    t438 = -0.003188484444444*t14*t17*t35*t185*t223*t162;
    t439 = -
        25.0*t1*t129*t27*t28*t30*t33*t35;
    t440 = 1/POW(3.141592653589793,2.666666666666667);
    t441 = 1/POW(t4,7.666666666666667);
    t442 = 26.04166666666667*t1*t111*t27*t3*t33*t36*t440*
        t441;
    t443 = POW(t169,2.0);
    t444 = -0.003188484444444*t14*t17*t35*t443*t223;
    t445 = POW(t167,2.0);
    t446 = t180+t179+1.176107352988323*t36*t29*t1*t39*t41*
        t78;
    t447 = 1.390905838366201*t1*t39*t41*t76+t183+t182;
    t448 = 2.656434474616293*t36*t21*t447*t80-5.312868949232586*
        t36*t21*t168*t167*t142-2.656434474616293*t36*t21*t77*t446*
        t142+5.312868949232586*t36*t21*t77*t445*t226;
    t449 = 0.003188484444444*t14*t17*t35*t448*t109;
    t450 = -25.0*t129*t27*t28*t30*t33*t35*grada*gradb;
    t451 = 26.04166666666667*t111*t27*t3*t33*t36*t440*t441*
        grada*gradb;
    t452 = -0.003188484444444*t14*t17*t35*t169*t175*t223;
    t453 = POW(3.141592653589793,
        1.666666666666667);
    t454 = 1.176107352988323*t36*t29*grada*gradb*t39*t41*
        t80*t76-3.124252118327895*t28*t453*grada*gradb*t39*t41*t77*
        t142*t78-2.656434474616293*t36*t21*t168*t173*t142-2.656434474616293*
        t36*t21*t174*t167*t142+5.312868949232586*t36*t21*t77*t167*
        t173*t226;
    t455 = 0.003188484444444*t14*t17*t35*t109*t454;
    t456 = -25.0*t129*t27*t28*t30*t33*t35*grada;
    t457 = 26.04166666666667*t111*t27*t3*t33*t36*t440*t441*
        grada;
    t458 = -0.003188484444444*t14*t17*t35*t185*t169*t223;
    t459 = -
        3.124252118327895*t28*t453*grada*t39*t41*t77*t142*t78;
    t460 = 1.176107352988323*t36*t29*grada*t39*t41*t80*t76;
    t461 = t460+
        t459-2.656434474616293*t36*t21*t184*t167*t142-2.656434474616293*
        t36*t21*t168*t181*t142+5.312868949232586*t36*t21*t77*t181*
        t167*t226;
    t462 = 0.003188484444444*t14*t17*t35*t109*t461;
    t463 = -25.0*t129*t2*t27*t28*t30*t33*t35;
    t464 = 26.04166666666667*t111*t2*t27*t3*t33*t36*t440*
        t441;
    t465 = POW(t175,2.0);
    t466 = -0.003188484444444*t14*t17*t35*t465*t223;
    t467 = POW(t173,2.0);
    t468 = t180+t179+1.176107352988323*t36*t29*t2*t39*t41*
        t78;
    t469 = 1.390905838366201*t2*t39*t41*t76+t183+t182;
    t470 = 2.656434474616293*t36*t21*t469*t80-5.312868949232586*
        t36*t21*t174*t173*t142-2.656434474616293*t36*t21*t77*t468*
        t142+5.312868949232586*t36*t21*t77*t467*t226;
    t471 = 0.003188484444444*t14*t17*t35*t470*t109;
    t472 = -25.0*t129*t27*t28*t30*t33*t35*gradb;
    t473 = 26.04166666666667*t111*t27*t3*t33*t36*t440*t441*
        gradb;
    t474 = -0.003188484444444*t14*t17*t35*t185*t175*t223;
    t475 = -
        3.124252118327895*t28*t453*gradb*t39*t41*t77*t142*t78;
    t476 = 1.176107352988323*t36*t29*gradb*t39*t41*t80*t76;
    t477 = t476+
        t475-2.656434474616293*t36*t21*t184*t173*t142-2.656434474616293*
        t36*t21*t174*t181*t142+5.312868949232586*t36*t21*t77*t181*
        t173*t226;
    t478 = 0.003188484444444*t14*t17*t35*t109*t477;
    t479 = -25.0*t129*t27*t28*t30*t33*t35;
    t480 = 26.04166666666667*t111*t27*t3*t33*t36*t440*t441;
    t481 = POW(t185,
        2.0);
    t482 = -0.003188484444444*t14*t17*t35*t481*t223;
    t483 = POW(t181,2.0);
    t484 = -3.124252118327895*t28*t453*t39*t41*t77*t142*t78;
    t485 = 1.176107352988323*
        t36*t29*t39*t41*t80*t76;
    t486 = t485+t484-5.312868949232586*t36*t21*t184*t181*
        t142+5.312868949232586*t36*t21*t77*t483*t226;
    t487 = 0.003188484444444*t14*t17*t35*t109*t486;
    t488 = 1.5*t12*t194*t3*t33*t5;
    t489 = -7.0*t103*t12*t3*t33*t90;
    t490 = 11.66666666666667*t12*t211*t27*t3*t33;
    t491 = 0.5*t12*t3*t33*t5*(-0.003*t189*t88*t89-0.003*t193*
        t86*t89-0.006*t26*POW(t88,3.0)/POW(t24,4.0)-0.001*(-9.046074074074074*
        t19*t20*t22*t103-1.398518518518518*t14*t15*t17*t105-0.332505*
        t13*t59)*t89*t26+0.006*t193*t88*t191*t26+0.001*(-24.1277037037037*
        t19*t20*t22*t103-0.021893333333333*t14*t15*t17*t105)*t25+0.006*
        t86*t190*t191);
    t492 = -3.5*t103*t12*t194*t3*t33;
    t493 = 11.66666666666667*t12*t211*t3*t33*t90;
    t494 = POW(t94,3.0);
    t495 = 1/POW(t8,2.333333333333333);
    t496 = 6.0*t59*t6;
    t497 = -6.0*t192;
    t498 = t497+t496;
    t499 = POW(t98,3.0);
    t500 = 1/POW(t10,2.333333333333333);
    t501 = -6.0*t59*t6;
    t502 = 6.0*t192;
    t503 = t502+t501;
    t504 = -0.666666666666667*t204*t207*t98+0.666666666666667*
        t498*t96-0.666666666666667*t199*t202*t94+0.666666666666667*
        t100*t503+0.296296296296296*t499*t500+0.296296296296296*t494*
        t495;
    t505 = 1/POW(t4,5.333333333333333);
    t506 = -16.85185185185185*t12*t27*t3*t33*t505;
    t507 = 285.1851851851852*t113*t28*t3*t30*t32;
    t508 = 1/POW(t81,3.0);
    t509 = 1/POW(t79,4.0);
    t510 = POW(t101,3.0);
    t511 = -8.425925925925926*t21*t3*t36*t37*t505;
    t512 = POW(t140,3.0);
    t513 = 1/POW(2.718281828459045,940.8858823906587*t28*
        t16*t42*t73);
    t514 = 1881.771764781317*t28*t16*t101*t41*t73-627.2572549271058*
        t28*t16*t42*t139;
    t515 = POW(t12,7.0);
    t516 = 1/t515;
    t517 = -30.65144347510703*t38*t41*t441*t76;
    t518 = POW(t118,3.0);
    t519 = 1/POW(t54,6.0);
    t520 = 1/POW(t55,3.0);
    t521 = 517.2501470570614*t518*t43*t519*t520;
    t522 = 1/POW(t54,5.0);
    t523 = -96.4909459329066*t518*t43*t522*t236;
    t524 = -3.43668585764369*t19*t20*t22*t85*t234*t235*t236;
    t525 = 48.2454729664533*
        t244*t118*t43*t235*t236;
    t526 = 6.0*t518*t43*t235*t120;
    t527 = 0.4274*t19*t20*t22*t85*t234*t238*t120;
    t528 = -6.0*t244*t118*t43*t238*t120;
    t529 = -0.2137*t19*t20*t22*t85*t244*t119*t120;
    t530 = 0.284933333333333*t19*t20*t22*t5*t118*t119*t120;
    t531 = 1/
        POW(t4,3.666666666666667);
    t532 = 1/POW(t47,7.0);
    t533 = 1/POW(t4,3.166666666666667);
    t534 = -3.200040277777777*t50*t51*t52*t533-3.720474074074074*
        t19*t20*t22*t103-1.5358125*t45*t46*t532-0.562075355777054*
        t531;
    t535 = 1.0*t534*t43*t119*t120;
    t536 = POW(t122,3.0);
    t537 = -1025.38970210078*t536*t57*t60*t61*t64/(POW(t65,
        6.0)*POW(t66,3.0));
    t538 = 103.8945353962552*t248*t536*t57*t60*t61*t64/POW(t65,
        5.0);
    t539 = 1.926377843805565*t57*t19*t20*t22*t85*t60*t246*
        t247*t64*t248;
    t540 = -51.9472676981276*t57*t60*t253*t122*t61*t247*t64*
        t248;
    t541 = -3.508934038473122*t57*t60*t536*t61*t247*t64*t124;
    t542 = -
        0.130122970593378*t57*t19*t20*t22*t85*t60*t246*t250*t64*t124;
    t543 = 3.508934038473122*
        t57*t60*t253*t122*t61*t250*t64*t124;
    t544 = 0.065061485296689*t57*t19*t20*t22*t85*t60*t253*
        t123*t64*t124;
    t545 = -0.086748647062252*t57*t19*t20*t22*t5*t60*t122*
        t123*t64*t124;
    t546 = -0.58482233974552*t57*t60*(-4.36336574074074*t50*
        t51*t52*t533-3.757288888888889*t19*t20*t22*t103-0.82524375*
        t45*t46*t532-0.566374102259952*t531)*t61*t123*t64*t124;
    t547 = 0.013780452414815*t19*t20*t22*t103*t56;
    t548 = 1/POW(t8,1.666666666666667);
    t549 = 1/POW(t10,1.666666666666667);
    t550 = 1.333333333333333*t503*t99+1.333333333333333*t207*
        t257*t98+1.333333333333333*t498*t95+1.333333333333333*t202*
        t256*t94-0.296296296296296*t499*t549-0.296296296296296*t494*
        t548;
    t551 = -0.002278771293463*t57*t19*t20*t22*t103*t60*t64*
        t67;
    t552 = 1/POW(t4,7.0);
    t553 = 120.0*t552*t58;
    t554 = 144.0*t129*t262;
    t555 = -24.0*t59*t6;
    t556 = POW(t133,3.0);
    t557 = t57*t58*t59*t64*(0.006624979614815*t19*t20*t22*
        t103*t71+2069.133687865597*t556*t68/(POW(t69,6.0)*POW(t70,
        3.0))-192.9880990672242*t267*t556*t68/POW(t69,5.0)+6.0*t135*
        t266*t556*t68-6.0*t133*t135*t268*t269*t68-0.013780452414815*
        t19*t20*t22*t103*t56-517.2501470570614*t518*t43*t519*t520+
        96.4940495336121*t269*t133*t68*t266*t267-6.60919909938887*
        t19*t20*t22*t85*t265*t266*t267+96.4909459329066*t518*t43*t522*
        t236-48.2454729664533*t244*t118*t43*t235*t236+3.43668585764369*
        t19*t20*t22*t85*t234*t235*t236+0.41096*t19*t20*t22*t85*t265*
        t268*t135+(-5.948240277777777*t50*t51*t52*t533-6.427244444444445*
        t19*t20*t22*t103-3.1558125*t45*t46*t532-0.712850752974279*
        t531)*t68*t134*t135-0.20548*t19*t20*t22*t85*t269*t134*t135+
        0.273973333333333*t19*t20*t22*t5*t133*t134*t135+6.0*t244*t118*
        t43*t238*t120-0.4274*t19*t20*t22*t85*t234*t238*t120-6.0*t518*
        t43*t235*t120-1.0*t534*t43*t119*t120+0.2137*t19*t20*t22*t85*
        t244*t119*t120-0.284933333333333*t19*t20*t22*t5*t118*t119*
        t120);
    t558 = -12.0*t129*t270*t57*t58*t64;
    t559 = 60.0*t136*t260*t57*t58*t64;
    t560 = 36.0*t136*t262*t57*t59*t64;
    t561 = -120.0*t552*t57*t58*t64*t72;
    t562 = -144.0*t129*t262*t57*t64*t72;
    t563 = 24.0*t57*t59*t6*t64*t72;
    t564 = 940.8858823906587*t28*t16*t504*t41*t73+18817.71764781317*
        t28*t16*t510*t231*t73-11290.6305886879*t28*t16*t208*t101*t112*
        t73-313.6286274635529*t16*t28*t42*(240.0*t131*t260*t57*t64*
        t72+36.0*t127*t262*t57*t59*t72+12.0*t131*t258*t57*t59*t72+
        60.0*t127*t260*t57*t58*t72-12.0*t129*t258*t57*t58*t72-96.0*
        t127*t129*t131*t57*t72+t57*t58*t59*t550*t72+0.019751789702565*
        (t555+t554+t553-240.0*t131*t260)*t57*t61*t64*t67-0.00219738660441*
        t57*t19*t20*t22*t85*t264*t64*t67+0.002929848805881*t57*t19*
        t20*t22*t5*t132*t64*t67+0.019751789702565*t57*t60*t61*t550*
        t67+0.059255369107696*t57*t132*t61*t258*t67-0.00219738660441*
        t57*t19*t20*t22*t85*t60*t258*t67+0.059255369107696*t57*t264*
        t61*t127*t67+0.002929848805881*t57*t19*t20*t22*t5*t60*t127*
        t67-0.004394773208821*t57*t19*t20*t22*t85*t132*t127*t67+12.0*
        t131*t270*t57*t59*t64-96.0*t129*t131*t136*t57*t64+3.0*t127*
        t270*t57*t58*t59+3.0*t136*t258*t57*t58*t59+24.0*t127*t131*
        t136*t57*t59-24.0*t127*t129*t136*t57*t58+t563+t562+t561+t560+
        t559+t558+t557+t551+t547+t546+t545+t544+t543+t542+t541+t540+
        t539+t538+t537+t535+t530+t529+t528+t527+t526+t525+t524+t523+
        t521-51.9472676981276*t57*t132*t246*t61*t247*t64*t248-51.9472676981276*
        t57*t60*t246*t61*t247*t127*t248+3.508934038473122*t57*t132*
        t246*t61*t250*t64*t124-1.754467019236561*t57*t132*t253*t61*
        t123*t64*t124-1.754467019236561*t57*t264*t122*t61*t123*t64*
        t124+0.130122970593378*t57*t19*t20*t22*t85*t132*t122*t123*
        t64*t124-1.754467019236561*t57*t60*t122*t61*t123*t258*t124+
        3.508934038473122*t57*t60*t246*t61*t250*t127*t124-1.754467019236561*
        t57*t60*t253*t61*t123*t127*t124-3.508934038473122*t57*t132*
        t122*t61*t123*t127*t124+0.130122970593378*t57*t19*t20*t22*
        t85*t60*t122*t123*t127*t124)+2822.657647171976*t28*t16*t101*
        t41*t275+2822.657647171976*t28*t16*t208*t41*t139-11290.6305886879*
        t28*t16*t213*t112*t139;
    t565 = 1/POW(t75,5.0);
    t566 = -25.91792129733528*t36*t29*t38*t441*t41*t78;
    t567 = -
        22.38292011019284*t28*t16*t3*t505*t37*t76;
    t568 = t3*t5*t286*t27*t33;
    t569 = t3*t5*t12*t27*t287*t33;
    t570 = t3*t5*t101*t27*t154*t33;
    t571 = t3*t5*t152*t27*t107*t33;
    t572 = t3*t5*t12*t27*t154*t107*t33;
    t573 = 0.019130906666667*t14*t17*t101*t32*t109*t162;
    t574 = 0.019130906666667*
        t14*t17*t152*t32*t109*t147;
    t575 = -0.006376968888889*t14*t17*t35*t223*t162*t147;
    t576 = 0.006376968888889*
        t14*t17*t35*t109*t294;
    t577 = 0.038261813333333*t14*t17*t152*t101*t12*t82;
    t578 = 0.019130906666667*
        t14*t17*t286*t32*t82;
    t579 = t3*t5*t286*t90*t33;
    t580 = -2.333333333333333*t103*t27*t286*t3*t33;
    t581 = t496-2.0*t192;
    t582 = t501+2.0*t192;
    t583 = -0.888888888888889*t192*t204*t6*t98+0.666666666666667*
        t581*t96+0.888888888888889*t192*t199*t6*t94+0.666666666666667*
        t100*t582+0.296296296296296*t151*t203*t500+0.296296296296296*
        t150*t198*t495-0.222222222222222*t151*t204*t207-0.222222222222222*
        t150*t199*t202;
    t584 = 66.66666666666667*t101*t105*t152*t28*t3*t30;
    t585 = 66.66666666666667*
        t105*t12*t28*t286*t3*t30;
    t586 = t3*t5*t12*t90*t287*t33;
    t587 = -2.333333333333333*t103*t12*t27*t287*t3*t33;
    t588 = t3*
        t5*t101*t90*t154*t33;
    t589 = -2.333333333333333*t101*t103*t154*t27*t3*t33;
    t590 = t3*
        t5*t152*t90*t107*t33;
    t591 = -2.333333333333333*t103*t107*t152*t27*t3*t33;
    t592 = t3*
        t5*t12*t90*t154*t107*t33;
    t593 = -2.333333333333333*t103*t107*t12*t154*t27*t3*t33;
    t594 = -
        7.0*t101*t103*t152*t21*t3*t36*t41;
    t595 = 2.333333333333333*t103*t21*t286*t3*t36*t42;
    t596 = -3.245446956187803*t113*t140*t145*t159*t230*t38*
        t41;
    t597 = 1881.771764781317*t28*t16*t152*t41*t73-627.2572549271058*
        t28*t16*t42*t158;
    t598 = -32.45446956187803*t101*t113*t152*t231*t38*t76;
    t599 = 6.490893912375606*
        t112*t113*t286*t38*t76;
    t600 = 1.622723478093901*t113*t291*t38*t41*t74*t78;
    t601 = -
        1.169644679491041*t57*t60*t122*t61*t123*t288*t124;
    t602 = -1.169644679491041*t57*t132*t122*t61*t123*t156*
        t124;
    t603 = -1.169644679491041*t57*t157*t122*t61*t123*t127*
        t124;
    t604 = -1.169644679491041*t57*t289*t122*t61*t123*t64*
        t124;
    t605 = -0.00146492440294*t57*t19*t20*t22*t85*t60*t288*
        t67;
    t606 = 1.333333333333333*t582*t99+1.777777777777778*t192*
        t257*t6*t98+1.333333333333333*t581*t95-1.777777777777778*t192*
        t256*t6*t94-0.296296296296296*t151*t203*t549-0.296296296296296*
        t150*t198*t548+0.444444444444444*t151*t207*t257+0.444444444444444*
        t150*t202*t256;
    t607 = -0.00146492440294*t57*t19*t20*t22*t85*t132*t156*
        t67;
    t608 = -0.00146492440294*t57*t19*t20*t22*t85*t157*t127*
        t67;
    t609 = -0.00146492440294*t57*t19*t20*t22*t85*t289*t64*
        t67;
    t610 = -48.0*t129*t262;
    t611 = 24.0*t59*t6;
    t612 = 2.0*t136*t288*t57*t58*t59;
    t613 = -12.0*t136*t262*t57*t59*t64;
    t614 = -8.0*t129*t288*t57*t58*t72;
    t615 = 48.0*t129*t262*t57*t64*t72;
    t616 = -24.0*t57*t59*t6*t64*t72;
    t617 = 940.8858823906587*t28*t16*t583*t41*t73+18817.71764781317*
        t28*t16*t152*t213*t231*t73-3763.543529562635*t28*t16*t208*
        t152*t112*t73-7527.08705912527*t28*t16*t286*t101*t112*t73-
        313.6286274635529*t16*t28*t42*(80.0*t131*t260*t57*t64*t72+
        t57*t58*t59*t606*t72+8.0*t131*t288*t57*t59*t72+12.0*t156*t262*
        t57*t59*t72-24.0*t127*t262*t57*t59*t72-4.0*t131*t258*t57*t59*
        t72+20.0*t156*t260*t57*t58*t72+40.0*t127*t260*t57*t58*t72-
        4.0*t129*t258*t57*t58*t72-32.0*t129*t131*t156*t57*t72+0.019751789702565*
        t57*t61*(t611+t610+t553-80.0*t131*t260)*t64*t67-7.324622014701263E-4*
        t57*t19*t20*t22*t85*t264*t64*t67+9.76616268626835E-4*t57*t19*
        t20*t22*t5*t157*t64*t67+0.001953232537254*t57*t19*t20*t22*
        t5*t132*t64*t67+0.019751789702565*t57*t60*t61*t606*t67+0.03950357940513*
        t57*t132*t61*t288*t67+0.019751789702565*t57*t157*t61*t258*
        t67-7.324622014701263E-4*t57*t19*t20*t22*t85*t60*t258*t67+
        0.019751789702565*t57*t264*t61*t156*t67+9.76616268626835E-4*
        t57*t19*t20*t22*t5*t60*t156*t67+0.03950357940513*t57*t289*
        t61*t127*t67+0.001953232537254*t57*t19*t20*t22*t5*t60*t127*
        t67-0.00146492440294*t57*t19*t20*t22*t85*t132*t127*t67+4.0*
        t131*t270*t57*t59*t64-32.0*t129*t131*t136*t57*t64+t616+t615+
        t614+t613+t612+t609+t608+t607+t605+t604+t603+t602+t601+2.0*
        t127*t270*t57*t58*t59+8.0*t131*t136*t156*t57*t59-8.0*t129*
        t136*t156*t57*t58-16.0*t127*t129*t136*t57*t58+t561+t559+t558+
        t557+t551+t547+t546+t545+t544+t543+t542+t541+t540+t539+t538+
        t537+t535+t530+t529+t528+t527+t526+t525+t524+t523+t521+t57*
        t58*t59*t156*t270-17.31575589937587*t57*t157*t246*t61*t247*
        t64*t248-34.63151179875173*t57*t132*t246*t61*t247*t64*t248-
        17.31575589937587*t57*t60*t246*t61*t247*t156*t248-34.63151179875173*
        t57*t60*t246*t61*t247*t127*t248+t57*t58*t59*t258*t136+1.169644679491041*
        t57*t157*t246*t61*t250*t64*t124+2.339289358982082*t57*t132*
        t246*t61*t250*t64*t124-0.58482233974552*t57*t157*t253*t61*
        t123*t64*t124-1.169644679491041*t57*t132*t253*t61*t123*t64*
        t124-0.58482233974552*t57*t264*t122*t61*t123*t64*t124+0.043374323531126*
        t57*t19*t20*t22*t85*t157*t122*t123*t64*t124+0.086748647062252*
        t57*t19*t20*t22*t85*t132*t122*t123*t64*t124-0.58482233974552*
        t57*t60*t122*t61*t123*t258*t124+1.169644679491041*t57*t60*
        t246*t61*t250*t156*t124-0.58482233974552*t57*t60*t253*t61*
        t123*t156*t124+0.043374323531126*t57*t19*t20*t22*t85*t60*t122*
        t123*t156*t124+2.339289358982082*t57*t60*t246*t61*t250*t127*
        t124-1.169644679491041*t57*t60*t253*t61*t123*t127*t124-1.169644679491041*
        t57*t132*t122*t61*t123*t127*t124+0.086748647062252*t57*t19*
        t20*t22*t85*t60*t122*t123*t127*t124)+1881.771764781317*t28*
        t16*t101*t41*t290+940.8858823906587*t28*t16*t152*t41*t275+
        940.8858823906587*t28*t16*t208*t41*t158-3763.543529562635*
        t28*t16*t213*t112*t158+1881.771764781317*t28*t16*t286*t41*
        t139-7527.08705912527*t28*t16*t152*t101*t112*t139;
    t618 = -6.490893912375606*t101*t112*t113*t159*t38*t74*
        t78;
    t619 = -6.490893912375606*t112*t113*t140*t152*t38*t74*
        t78;
    t620 = 1.622723478093901*t113*t140*t159*t38*t41*t74*t78;
    t621 = -
        8.232751470918263*t36*t29*t38*t113*t41*t159*t140*t230*t278;
    t622 = -
        6.198347107438017*t28*t16*t3*t103*t37*t159*t140*t230*t145;
    t623 = -
        27.44250490306088*t36*t29*t38*t113*t152*t101*t231*t78;
    t624 = 5.488500980612176*t36*t29*t38*t113*t286*t112*t78;
    t625 = 6.198347107438017*
        t28*t16*t3*t103*t286*t42*t76;
    t626 = 2.744250490306088*t36*t29*t38*t113*t41*t291*t145*
        t74;
    t627 = -10.97700196122435*t36*t29*t38*t113*t101*t112*
        t159*t145*t74;
    t628 = -10.97700196122435*t36*t29*t38*t113*t152*t112*
        t140*t145*t74;
    t629 = 2.744250490306088*t36*t29*t38*t113*t41*t159*t140*
        t145*t74;
    t630 = 3.099173553719008*t28*t16*t3*t103*t37*t291*t78*
        t74;
    t631 = -6.198347107438017*t28*t16*t3*t103*t101*t42*t159*
        t78*t74;
    t632 = -6.198347107438017*t28*t16*t3*t103*t152*t42*t140*
        t78*t74;
    t633 = 3.099173553719008*t28*t16*t3*t103*t37*t159*t140*
        t78*t74;
    t634 = 2.0*t12*t33*t5*t90*grada;
    t635 = -12.5*t129*t28*t3*t30*t33*t35*t90*grada;
    t636 = -4.666666666666667*t103*t12*t27*t33*grada;
    t637 = 29.16666666666667*t260*t27*t28*t3*t30*t33*t35*
        grada;
    t638 = grada*t5*t12*t194*t33;
    t639 = -6.25*t129*t194*t28*t3*t30*t33*t35*grada;
    t640 = -4.666666666666667*t103*t12*t33*t90*grada;
    t641 = 29.16666666666667*t260*t28*t3*t30*t33*t35*t90*
        grada;
    t642 = 7.777777777777778*t12*t211*t27*t33*grada;
    t643 = -48.61111111111111*t27*t28*t3*t30*t33*t35*t552*
        grada;
    t644 = -122.2222222222222*t28*t30*t32*t39*grada;
    t645 = 3.888888888888889*t21*t211*t36*t37*grada;
    t646 = 18.39086608506422*t232*t3*t41*t76*grada;
    t647 = 15.55075277840116*t36*t29*grada*t3*t232*t41*t78;
    t648 = 10.3305785123967*
        t28*t16*grada*t211*t37*t76;
    t649 = 2.0*t12*t33*t5*t90*gradb;
    t650 = -12.5*t129*t28*t3*t30*t33*t35*t90*gradb;
    t651 = -4.666666666666667*t103*t12*t27*t33*gradb;
    t652 = 29.16666666666667*t260*t27*t28*t3*t30*t33*t35*
        gradb;
    t653 = gradb*t5*t12*t194*t33;
    t654 = -6.25*t129*t194*t28*t3*t30*t33*t35*gradb;
    t655 = -4.666666666666667*t103*t12*t33*t90*gradb;
    t656 = 29.16666666666667*t260*t28*t3*t30*t33*t35*t90*
        gradb;
    t657 = 7.777777777777778*t12*t211*t27*t33*gradb;
    t658 = -48.61111111111111*t27*t28*t3*t30*t33*t35*t552*
        gradb;
    t659 = -122.2222222222222*t28*t30*t32*t39*gradb;
    t660 = 3.888888888888889*t21*t211*t36*t37*gradb;
    t661 = 18.39086608506422*t232*t3*t41*t76*gradb;
    t662 = 15.55075277840116*t36*t29*gradb*t3*t232*t41*t78;
    t663 = 10.3305785123967*
        t28*t16*gradb*t211*t37*t76;
    t664 = 2.0*t12*t33*t5*t90;
    t665 = -12.5*t129*t28*t3*t30*t33*t35*t90;
    t666 = -4.666666666666667*t103*t12*t27*t33;
    t667 = 29.16666666666667*t260*t27*t28*t3*t30*t33*t35;
    t668 = t5*
        t12*t194*t33;
    t669 = -6.25*t129*t194*t28*t3*t30*t33*t35;
    t670 = -4.666666666666667*t103*t12*t33*t90;
    t671 = 29.16666666666667*t260*t28*t3*t30*t33*t35*t90;
    t672 = 7.777777777777778*
        t12*t211*t27*t33;
    t673 = -48.61111111111111*t27*t28*t3*t30*t33*t35*t552;
    t674 = -
        122.2222222222222*t28*t30*t32*t39;
    t675 = 3.888888888888889*t21*t211*t36*t37;
    t676 = 18.39086608506422*t232*t3*t41*t76;
    t677 = 15.55075277840116*t36*t29*t3*t232*t41*t78;
    t678 = 10.3305785123967*t28*t16*t211*t37*t76;
    t679 = 0.296296296296296*t368*t500*t98-0.222222222222222*
        t204*t369*t98+4.0*t59*t6*t96+1.333333333333333*t192*t96+0.296296296296296*
        t366*t495*t94-0.222222222222222*t199*t367*t94-4.0*t100*t59*
        t6-0.888888888888889*t151*t192*t204*t6+0.888888888888889*t150*
        t192*t199*t6-1.333333333333333*t100*t192;
    t680 = -8.0*t59*t6*t99-2.666666666666667*t192*t99-0.296296296296296*
        t368*t549*t98+0.444444444444444*t257*t369*t98+8.0*t59*t6*t95+
        2.666666666666667*t192*t95-0.296296296296296*t366*t548*t94+
        0.444444444444444*t256*t367*t94+1.777777777777778*t151*t192*
        t257*t6-1.777777777777778*t150*t192*t256*t6;
    t681 = 940.8858823906587*t28*t16*t679*t41*t73+18817.71764781317*
        t28*t16*t373*t101*t231*t73-7527.08705912527*t28*t16*t286*t152*
        t112*t73-3763.543529562635*t28*t16*t370*t101*t112*t73-313.6286274635529*
        t16*t28*t42*(t57*t58*t59*t680*t72-80.0*t131*t260*t57*t64*t72+
        4.0*t131*t386*t57*t59*t72-8.0*t131*t288*t57*t59*t72-24.0*t156*
        t262*t57*t59*t72+12.0*t127*t262*t57*t59*t72-4.0*t129*t386*
        t57*t58*t72+40.0*t156*t260*t57*t58*t72+20.0*t127*t260*t57*
        t58*t72+32.0*t127*t129*t131*t57*t72+0.019751789702565*t57*
        t60*t61*t680*t67+0.019751789702565*t57*t61*(t610+t555+t553+
        80.0*t131*t260)*t64*t67-7.324622014701263E-4*t57*t19*t20*t22*
        t85*t387*t64*t67+0.001953232537254*t57*t19*t20*t22*t5*t157*
        t64*t67+9.76616268626835E-4*t57*t19*t20*t22*t5*t132*t64*t67+
        0.019751789702565*t57*t132*t61*t386*t67-7.324622014701263E-4*
        t57*t19*t20*t22*t85*t60*t386*t67+0.03950357940513*t57*t157*
        t61*t288*t67+0.03950357940513*t57*t289*t61*t156*t67+0.001953232537254*
        t57*t19*t20*t22*t5*t60*t156*t67-0.00146492440294*t57*t19*t20*
        t22*t85*t157*t156*t67+0.019751789702565*t57*t387*t61*t127*
        t67+9.76616268626835E-4*t57*t19*t20*t22*t5*t60*t127*t67-4.0*
        t131*t270*t57*t59*t64+32.0*t129*t131*t136*t57*t64+t615+t614+
        t613+t612+t609+t608+t607+t605+t604+t603+t602+t601+2.0*t156*
        t270*t57*t58*t59-8.0*t127*t131*t136*t57*t59-16.0*t129*t136*
        t156*t57*t58-8.0*t127*t129*t136*t57*t58+t563+t561+t559+t558+
        t557+t551+t547+t546+t545+t544+t543+t542+t541+t540+t539+t538+
        t537+t535+t530+t529+t528+t527+t526+t525+t524+t523+t521+t57*
        t58*t59*t127*t270-34.63151179875173*t57*t157*t246*t61*t247*
        t64*t248-17.31575589937587*t57*t132*t246*t61*t247*t64*t248-
        34.63151179875173*t57*t60*t246*t61*t247*t156*t248-17.31575589937587*
        t57*t60*t246*t61*t247*t127*t248+t57*t58*t59*t386*t136+2.339289358982082*
        t57*t157*t246*t61*t250*t64*t124+1.169644679491041*t57*t132*
        t246*t61*t250*t64*t124-1.169644679491041*t57*t157*t253*t61*
        t123*t64*t124-0.58482233974552*t57*t132*t253*t61*t123*t64*
        t124-0.58482233974552*t57*t387*t122*t61*t123*t64*t124+0.086748647062252*
        t57*t19*t20*t22*t85*t157*t122*t123*t64*t124+0.043374323531126*
        t57*t19*t20*t22*t85*t132*t122*t123*t64*t124-0.58482233974552*
        t57*t60*t122*t61*t123*t386*t124+2.339289358982082*t57*t60*
        t246*t61*t250*t156*t124-1.169644679491041*t57*t60*t253*t61*
        t123*t156*t124-1.169644679491041*t57*t157*t122*t61*t123*t156*
        t124+0.086748647062252*t57*t19*t20*t22*t85*t60*t122*t123*t156*
        t124+1.169644679491041*t57*t60*t246*t61*t250*t127*t124-0.58482233974552*
        t57*t60*t253*t61*t123*t127*t124+0.043374323531126*t57*t19*
        t20*t22*t85*t60*t122*t123*t127*t124)+940.8858823906587*t28*
        t16*t101*t41*t388+1881.771764781317*t28*t16*t152*t41*t290+
        1881.771764781317*t28*t16*t286*t41*t158-7527.08705912527*t28*
        t16*t152*t101*t112*t158+940.8858823906587*t28*t16*t370*t41*
        t139-3763.543529562635*t28*t16*t373*t112*t139;
    t682 = -25.0*t1*t129*t28*t30*t33*t35*t90;
    t683 = 26.04166666666667*t1*t111*t3*t33*t36*t440*t441*
        t90;
    t684 = 58.33333333333334*t1*t260*t27*t28*t30*t33*t35;
    t685 = 1/
        POW(t4,8.666666666666666);
    t686 = -60.76388888888889*t1*t111*t27*t3*t33*t36*t440*
        t685;
    t687 = -6.490893912375606*t1*t113*t41*t76;
    t688 = -5.488500980612176*t36*t29*t1*t113*t41*t78;
    t689 = -25.0*t129*t28*t30*t33*t35*t90*grada*gradb;
    t690 = 26.04166666666667*t111*t3*t33*t36*t440*t441*t90*
        grada*gradb;
    t691 = 58.33333333333334*t260*t27*t28*t30*t33*t35*grada*
        gradb;
    t692 = -60.76388888888889*t111*t27*t3*t33*t36*t440*t685*
        grada*gradb;
    t693 = -5.488500980612176*t36*t29*grada*gradb*t113*t41*
        t78;
    t694 = -6.490893912375606*t113*t41*t76*grada*gradb;
    t695 = -
        25.0*t129*t28*t30*t33*t35*t90*grada;
    t696 = 26.04166666666667*t111*t3*t33*t36*t440*t441*t90*
        grada;
    t697 = 58.33333333333334*t260*t27*t28*t30*t33*t35*grada;
    t698 = -
        60.76388888888889*t111*t27*t3*t33*t36*t440*t685*grada;
    t699 = -5.488500980612176*t36*t29*grada*t113*t41*t78;
    t700 = -
        6.490893912375606*t113*t41*t76*grada;
    t701 = -25.0*t129*t2*t28*t30*t33*t35*t90;
    t702 = 26.04166666666667*t111*t2*t3*t33*t36*t440*t441*
        t90;
    t703 = 58.33333333333334*t2*t260*t27*t28*t30*t33*t35;
    t704 = -
        60.76388888888889*t111*t2*t27*t3*t33*t36*t440*t685;
    t705 = -6.490893912375606*t113*t2*t41*t76;
    t706 = -5.488500980612176*t36*t29*t2*t113*t41*t78;
    t707 = -25.0*t129*t28*t30*t33*t35*t90*gradb;
    t708 = 26.04166666666667*t111*t3*t33*t36*t440*t441*t90*
        gradb;
    t709 = 58.33333333333334*t260*t27*t28*t30*t33*t35*gradb;
    t710 = -
        60.76388888888889*t111*t27*t3*t33*t36*t440*t685*gradb;
    t711 = -5.488500980612176*t36*t29*gradb*t113*t41*t78;
    t712 = -
        6.490893912375606*t113*t41*t76*gradb;
    t713 = -25.0*t129*t28*t30*t33*t35*t90;
    t714 = 26.04166666666667*t111*t3*t33*t36*t440*t441*t90;
    t715 = 58.33333333333334*
        t260*t27*t28*t30*t33*t35;
    t716 = -60.76388888888889*t111*t27*t3*t33*t36*t440*t685;
    t717 = -
        5.488500980612176*t36*t29*t113*t41*t78;
    t718 = -6.490893912375606*t113*t41*t76;
    t719 = POW(t150,3.0);
    t720 = t502+t496;
    t721 = POW(t151,3.0);
    t722 = t497+t501;
    t723 = 0.666666666666667*t720*t96+0.666666666666667*t100*
        t722+0.296296296296296*t500*t721+0.296296296296296*t495*t719-
        0.666666666666667*t151*t204*t369-0.666666666666667*t150*t199*
        t367;
    t724 = POW(t152,3.0);
    t725 = POW(t159,3.0);
    t726 = 1.333333333333333*t722*t99+1.333333333333333*t720*
        t95-0.296296296296296*t549*t721-0.296296296296296*t548*t719+
        1.333333333333333*t151*t257*t369+1.333333333333333*t150*t256*
        t367;
    t727 = 940.8858823906587*t28*t16*t723*t41*t73+18817.71764781317*
        t28*t16*t724*t231*t73-11290.6305886879*t28*t16*t370*t152*t112*
        t73-313.6286274635529*t16*t28*t42*(t57*t58*t59*t726*t72-240.0*
        t131*t260*t57*t64*t72-12.0*t131*t386*t57*t59*t72+36.0*t156*
        t262*t57*t59*t72-12.0*t129*t386*t57*t58*t72+60.0*t156*t260*
        t57*t58*t72+96.0*t129*t131*t156*t57*t72+0.019751789702565*
        t57*t60*t61*t726*t67+0.019751789702565*t57*t61*(t611+t554+
        t553+240.0*t131*t260)*t64*t67-0.00219738660441*t57*t19*t20*
        t22*t85*t387*t64*t67+0.002929848805881*t57*t19*t20*t22*t5*
        t157*t64*t67+0.059255369107696*t57*t157*t61*t386*t67-0.00219738660441*
        t57*t19*t20*t22*t85*t60*t386*t67+0.059255369107696*t57*t387*
        t61*t156*t67+0.002929848805881*t57*t19*t20*t22*t5*t60*t156*
        t67-0.004394773208821*t57*t19*t20*t22*t85*t157*t156*t67-12.0*
        t131*t270*t57*t59*t64+96.0*t129*t131*t136*t57*t64+t616+3.0*
        t136*t386*t57*t58*t59+3.0*t156*t270*t57*t58*t59-24.0*t131*
        t136*t156*t57*t59-24.0*t129*t136*t156*t57*t58+t562+t561+t560+
        t559+t558+t557+t551+t547+t546+t545+t544+t543+t542+t541+t540+
        t539+t538+t537+t535+t530+t529+t528+t527+t526+t525+t524+t523+
        t521-51.9472676981276*t57*t157*t246*t61*t247*t64*t248-51.9472676981276*
        t57*t60*t246*t61*t247*t156*t248+3.508934038473122*t57*t157*
        t246*t61*t250*t64*t124-1.754467019236561*t57*t157*t253*t61*
        t123*t64*t124-1.754467019236561*t57*t387*t122*t61*t123*t64*
        t124+0.130122970593378*t57*t19*t20*t22*t85*t157*t122*t123*
        t64*t124-1.754467019236561*t57*t60*t122*t61*t123*t386*t124+
        3.508934038473122*t57*t60*t246*t61*t250*t156*t124-1.754467019236561*
        t57*t60*t253*t61*t123*t156*t124-3.508934038473122*t57*t157*
        t122*t61*t123*t156*t124+0.130122970593378*t57*t19*t20*t22*
        t85*t60*t122*t123*t156*t124)+2822.657647171976*t28*t16*t152*
        t41*t388+2822.657647171976*t28*t16*t370*t41*t158-11290.6305886879*
        t28*t16*t373*t112*t158;
    t728 = POW(grada,3.0);
    t729 = 1/POW(3.141592653589793,4.0);
    t730 = 1/POW(t4,10.33333333333333);
    t731 = POW(gradb,3.0);

   /* code */
    dfdra = t4*(t149+t148+t108+t104+t102+t91)+t83+t34;
    dfdrb = t4*(t164+t163+t155+t104+t153+t91)+t83+t34;
    dfdga = t4*(t170+t166+t165);
    dfdgb = t4*(t176+t172+t171);
    dfdgab = t4*(t186+t178+t177);
    d2fdrara = t4*(t285+t284+t283+t225+t222+t221+t219+t218+
        t217+t216+t212+t210+t209+t197+t196+t195)+0.019130906666667*
        t14*t17*t101*t32*t82+0.006376968888889*t14*t17*t35*t109*t147+
        t3*t5*t12*t27*t107*t33+t188+t3*t5*t101*t27*t33+t187;
    d2fdrarb = t4*(0.5*t12*t154*t3*t33*t5*t90+0.5*t152*t3*
        t33*t5*t90+0.5*t107*t12*t3*t33*t5*t90+0.5*t101*t3*t33*t5*t90+
        0.009565453333333*t14*t17*t286*t32*t82+0.019130906666667*t14*
        t17*t152*t101*t12*t82+0.5*t12*t27*t287*t3*t33*t5+0.5*t27*t286*
        t3*t33*t5+0.5*t107*t12*t154*t27*t3*t33*t5+0.5*t101*t154*t27*
        t3*t33*t5+0.5*t107*t152*t27*t3*t33*t5-1.166666666666667*t103*
        t12*t154*t27*t3*t33-1.166666666666667*t103*t152*t27*t3*t33-
        1.166666666666667*t103*t107*t12*t27*t3*t33-1.166666666666667*
        t101*t103*t27*t3*t33+0.003188484444444*t14*t17*t35*t109*t294+
        t212+t197+t195+0.009565453333333*t14*t17*t101*t32*t109*t162-
        0.003188484444444*t14*t17*t35*t223*t162*t147+0.009565453333333*
        t14*t17*t152*t32*t109*t147)+t188+t187+t164+t163+t155+t153+
        t149+t148+t108+t102;
    d2fdraga = t4*(t315+t314+t306+t305+t304+t303+t300+t299+
        t298+t297+t296+t295)+t170+t166+t165;
    d2fdragb = t4*(t336+t335+t327+t326+t325+t324+t321+t320+
        t319+t318+t317+t316)+t176+t172+t171;
    d2fdraab = t4*(t364+t363+t348+t347+t346+t345+t342+t341+
        t340+t339+t338+t337)+t186+t178+t177;
    d2fdrbrb = t4*(t395+t394+t393+t383+t381+t380+t378+t377+
        t376+t375+t212+t372+t371+t197+t365+t195)+0.019130906666667*
        t14*t17*t152*t32*t82+0.006376968888889*t14*t17*t35*t109*t162+
        t3*t5*t12*t27*t154*t33+t188+t3*t5*t152*t27*t33+t187;
    d2fdrbga = t4*(t407+t406+t402+t401+t400+t399+t300+t397+
        t298+t396+t296+t295)+t170+t166+t165;
    d2fdrbgb = t4*(t419+t418+t414+t413+t412+t411+t321+t409+
        t319+t408+t317+t316)+t176+t172+t171;
    d2fdrbgab = t4*(t438+t437+t426+t425+t424+t423+t342+t421+
        t340+t420+t338+t337)+t186+t178+t177;
    d2fdgaga = t4*(t449+t444+t442+t178+t439+t177);
    d2fdgagb = t4*(t455+t452+t451+t450);
    d2fdgagab = t4*(t462+t458+t457+t456);
    d2fdgbgb = t4*(t471+t466+t464+t178+t463+t177);
    d2fdgbgab = t4*(t478+t474+t473+t472);
    d2fdgabgab = t4*(t487+t482+t480+t479);
    d3fdrarara = t4*(1.5*t12*t220*t3*t33*t5*t90+1.5*t12*t215*
        t3*t33*t5*t90+1.5*t208*t3*t33*t5*t90+3.0*t101*t107*t3*t33*
        t5*t90-7.0*t103*t107*t12*t3*t33*t90-7.0*t101*t103*t3*t33*t90+
        0.019130906666667*t14*t17*t510*t82+0.009565453333333*t14*t17*
        t504*t32*t82+0.05739272*t14*t17*t208*t101*t12*t82+0.003188484444444*
        t109*t14*t17*t35*(2.656434474616293*t21*t36*(-0.173863229795775*
        t38*t39*t41*t564*t74*t78-0.173863229795775*t38*t39*t41*t512*
        t74*t78-0.521589689387325*t140*t276*t38*t39*t41*t74*t78+2.434085217140852*
        t113*t276*t38*t41*t74*t78-13.79314956379817*t140*t232*t38*
        t41*t74*t78+2.434085217140852*t113*t229*t38*t41*t74*t78+2.086358757549302*
        t101*t112*t276*t38*t39*t74*t78-10.43179378774651*t140*t213*
        t231*t38*t39*t74*t78+2.086358757549302*t101*t112*t229*t38*
        t39*t74*t78+2.086358757549302*t112*t140*t208*t38*t39*t74*t78-
        19.47268173712682*t101*t112*t113*t140*t38*t74*t78-20.86358757549302*
        t38*t39*t510*t516*t76-0.695452919183101*t112*t38*t39*t504*
        t76+10.43179378774651*t101*t208*t231*t38*t39*t76-55.17259825519266*
        t101*t112*t232*t38*t76-48.68170434281704*t113*t213*t231*t38*
        t76+9.73634086856341*t112*t113*t208*t38*t76+t517+0.34772645959155*
        t145*t229*t230*t38*t39*t41*t514-1.043179378774651*t278*t38*
        t39*t41*t512*t513+0.34772645959155*t145*t230*t38*t39*t41*t512+
        t511-6.0*t112*t21*t3*t36*t5*t510-0.5*t21*t3*t36*t42*t5*t504+
        4.5*t101*t208*t21*t3*t36*t41*t5-11.66666666666667*t101*t21*
        t211*t3*t36*t42+3.5*t103*t208*t21*t3*t36*t42+1.043179378774651*
        t140*t145*t230*t276*t38*t39*t41-4.868170434281705*t113*t145*
        t229*t230*t38*t41-10.5*t103*t21*t213*t3*t36*t41-4.172717515098603*
        t101*t112*t145*t229*t230*t38*t39)*t80-15.93860684769776*POW(t146,
        3.0)*t21*t36*t509*t77-2.656434474616293*t36*t21*t77*t142*(-
        0.664108618654073*t28*t16*t3*t5*t37*t512*t78*t74+4.648760330578512*
        t28*t16*t3*t103*t37*t229*t78*t74+3.98465171192444*t28*t16*
        t3*t5*t101*t42*t229*t78*t74-1.99232585596222*t28*t16*t3*t5*
        t37*t276*t140*t78*t74-15.49586776859504*t28*t16*t3*t211*t37*
        t140*t78*t74-18.59504132231405*t28*t16*t3*t103*t101*t42*t140*
        t78*t74+3.98465171192444*t28*t16*t3*t5*t208*t42*t140*t78*t74-
        11.95395513577332*t28*t16*t3*t5*t213*t41*t140*t78*t74+4.648760330578512*
        t28*t16*t3*t103*t37*t276*t78*t74+3.98465171192444*t28*t16*
        t3*t5*t101*t42*t276*t78*t74-0.664108618654073*t28*t16*t3*t5*
        t37*t564*t78*t74-0.294026838247081*t36*t29*t38*t39*t41*t512*
        t145*t74+4.116375735459131*t36*t29*t38*t113*t41*t229*t145*
        t74+3.52832205896497*t36*t29*t38*t39*t101*t112*t229*t145*t74-
        0.882080514741242*t36*t29*t38*t39*t41*t276*t140*t145*t74-23.32612916760175*
        t36*t29*t38*t232*t41*t140*t145*t74-32.93100588367305*t36*t29*
        t38*t113*t101*t112*t140*t145*t74+3.52832205896497*t36*t29*
        t38*t39*t208*t112*t140*t145*t74-17.64161029482485*t36*t29*
        t38*t39*t213*t231*t140*t145*t74+4.116375735459131*t36*t29*
        t38*t113*t41*t276*t145*t74+3.52832205896497*t36*t29*t38*t39*
        t101*t112*t276*t145*t74-0.294026838247081*t36*t29*t38*t39*
        t41*t564*t145*t74+t567-30.99173553719008*t28*t16*t3*t211*t101*
        t42*t76+9.297520661157025*t28*t16*t3*t103*t208*t42*t76-1.328217237308146*
        t28*t16*t3*t5*t504*t42*t76-27.89256198347108*t28*t16*t3*t103*
        t213*t41*t76+11.95395513577332*t28*t16*t3*t5*t208*t101*t41*
        t76-15.93860684769776*t28*t16*t3*t5*t510*t112*t76+t566-46.6522583352035*
        t36*t29*t38*t232*t101*t112*t78+8.232751470918263*t36*t29*t38*
        t113*t208*t112*t78-0.588053676494162*t36*t29*t38*t39*t504*
        t112*t78-41.16375735459132*t36*t29*t38*t113*t213*t231*t78+
        8.820805147412424*t36*t29*t38*t39*t208*t101*t231*t78-17.64161029482485*
        t36*t29*t38*t39*t510*t516*t78+1.328217237308146*t28*t16*t3*
        t5*t37*t229*t514*t230*t145+1.328217237308146*t28*t16*t3*t5*
        t37*t512*t230*t145-9.297520661157025*t28*t16*t3*t103*t37*t229*
        t230*t145-7.969303423848879*t28*t16*t3*t5*t101*t42*t229*t230*
        t145+3.98465171192444*t28*t16*t3*t5*t37*t276*t140*t230*t145+
        0.882080514741242*t36*t29*t38*t39*t41*t229*t514*t230*t278+
        0.882080514741242*t36*t29*t38*t39*t41*t512*t230*t278-12.34912720637739*
        t36*t29*t38*t113*t41*t229*t230*t278-10.58496617689491*t36*
        t29*t38*t39*t101*t112*t229*t230*t278+2.646241544223727*t36*
        t29*t38*t39*t41*t276*t140*t230*t278-3.98465171192444*t28*t16*
        t3*t5*t37*t512*t513*t278-3.52832205896497*t36*t29*t38*t39*
        t41*t512*t513*t565)+15.93860684769776*t36*t21*t77*t226*t146*
        t281-7.969303423848879*t36*t21*t142*t141*t281-7.969303423848879*
        t36*t21*t142*t146*t277+15.93860684769776*t36*t21*t226*t141*
        t227)+0.006376968888889*t14*POW(t147,3.0)*t17*t35*t508+0.5*
        t12*t27*t3*t33*t5*(t507-12.5*t12*t28*t3*t30*t31*t504-366.6666666666667*
        t101*t12*t28*t3*t30*t39-37.5*t101*t208*t28*t3*t30*t31+100.0*
        t105*t213*t28*t3*t30+100.0*t105*t12*t208*t28*t3*t30)+t506+
        0.5*t27*t3*t33*t5*t504+1.5*t101*t220*t27*t3*t33*t5+1.5*t107*
        t12*t215*t27*t3*t33*t5+1.5*t101*t215*t27*t3*t33*t5+1.5*t107*
        t208*t27*t3*t33*t5+0.5*POW(t107,3.0)*t12*t27*t3*t33*t5+1.5*
        t107*t12*t194*t3*t33*t5+1.5*t101*t194*t3*t33*t5+t493+t492+
        t491-3.5*t103*t12*t220*t27*t3*t33-3.5*t103*t12*t215*t27*t3*
        t33+11.66666666666667*t107*t12*t211*t27*t3*t33+11.66666666666667*
        t101*t211*t27*t3*t33-3.5*t103*t208*t27*t3*t33-7.0*t101*t103*
        t107*t27*t3*t33-0.009565453333333*t14*t17*t35*t223*t147*t282+
        0.02869636*t14*t17*t101*t32*t109*t282-0.02869636*t14*t17*t101*
        t32*t223*t224+0.02869636*t14*t17*t208*t32*t109*t147+0.05739272*
        t14*t17*t213*t12*t109*t147)+3.0*t107*t12*t3*t33*t5*t90+3.0*
        t101*t3*t33*t5*t90+0.02869636*t14*t17*t208*t32*t82+0.05739272*
        t14*t17*t213*t12*t82+1.5*t12*t220*t27*t3*t33*t5+1.5*t12*t215*
        t27*t3*t33*t5+1.5*t208*t27*t3*t33*t5+3.0*t101*t107*t27*t3*
        t33*t5+t490+t489+t488-7.0*t103*t107*t12*t27*t3*t33-7.0*t101*
        t103*t27*t3*t33+0.009565453333333*t14*t17*t35*t109*t282-0.009565453333333*
        t14*t17*t35*t223*t224+0.05739272*t14*t17*t101*t32*t109*t147;
    d3fdrararb = t4*
        (0.5*t12*t220*t3*t33*t5*t90+0.5*t12*t215*t3*t33*t5*t90+0.5*
        t208*t3*t33*t5*t90-2.333333333333333*t103*t12*t154*t3*t33*
        t90-2.333333333333333*t103*t152*t3*t33*t90-4.666666666666667*
        t103*t107*t12*t3*t33*t90-4.666666666666667*t101*t103*t3*t33*
        t90+0.009565453333333*t14*t17*t583*t32*t82+0.019130906666667*
        t14*t17*t152*t213*t82+0.019130906666667*t14*t17*t208*t152*
        t12*t82+0.038261813333333*t14*t17*t286*t101*t12*t82+0.003188484444444*
        t109*t14*t17*t35*(2.656434474616293*t21*t36*(-0.173863229795775*
        t38*t39*t41*t617*t74*t78-0.34772645959155*t140*t291*t38*t39*
        t41*t74*t78-0.173863229795775*t159*t276*t38*t39*t41*t74*t78-
        0.173863229795775*t159*t229*t38*t39*t41*t74*t78+0.811361739046951*
        t113*t276*t38*t41*t74*t78-4.597716521266054*t159*t232*t38*
        t41*t74*t78-9.195433042532109*t140*t232*t38*t41*t74*t78+0.811361739046951*
        t113*t229*t38*t41*t74*t78+1.390905838366201*t101*t112*t291*
        t38*t39*t74*t78+1.390905838366201*t112*t140*t286*t38*t39*t74*
        t78+0.695452919183101*t112*t152*t276*t38*t39*t74*t78-3.477264595915503*
        t159*t213*t231*t38*t39*t74*t78-6.954529191831006*t101*t140*
        t152*t231*t38*t39*t74*t78+0.695452919183101*t112*t152*t229*
        t38*t39*t74*t78+0.695452919183101*t112*t159*t208*t38*t39*t74*
        t78+1.390905838366201*t101*t112*t140*t159*t38*t39*t74*t78-
        6.490893912375606*t101*t112*t113*t140*t38*t74*t78-0.695452919183101*
        t112*t38*t39*t583*t76-20.86358757549302*t152*t213*t38*t39*
        t516*t76+6.954529191831006*t101*t231*t286*t38*t39*t76+3.477264595915503*
        t152*t208*t231*t38*t39*t76-18.39086608506422*t112*t152*t232*
        t38*t76-36.78173217012844*t101*t112*t232*t38*t76-16.22723478093901*
        t113*t213*t231*t38*t76+3.245446956187803*t112*t113*t208*t38*
        t76+t620+t619+t618+t600+t599+t598+0.34772645959155*t145*t229*
        t230*t38*t39*t41*t597+t596+t595+t594-0.5*t21*t3*t36*t42*t5*
        t583+t517-1.043179378774651*t159*t229*t278*t38*t39*t41*t513+
        t511+3.0*t101*t21*t286*t3*t36*t41*t5+1.5*t152*t208*t21*t3*
        t36*t41*t5-6.0*t112*t152*t21*t213*t3*t36*t5-3.888888888888889*
        t152*t21*t211*t3*t36*t42-7.777777777777778*t101*t21*t211*t3*
        t36*t42+1.166666666666667*t103*t208*t21*t3*t36*t42+0.695452919183101*
        t140*t145*t230*t291*t38*t39*t41+0.34772645959155*t145*t159*
        t230*t276*t38*t39*t41+0.34772645959155*t145*t159*t229*t230*
        t38*t39*t41-1.622723478093901*t113*t145*t229*t230*t38*t41-
        3.5*t103*t21*t213*t3*t36*t41-1.390905838366201*t112*t145*t152*
        t229*t230*t38*t39-2.781811676732402*t101*t112*t140*t145*t159*
        t230*t38*t39)*t80-2.656434474616293*t36*t21*t77*t142*(-0.664108618654073*
        t28*t16*t3*t5*t37*t159*t229*t78*t74+1.549586776859504*t28*
        t16*t3*t103*t37*t229*t78*t74+1.328217237308146*t28*t16*t3*
        t5*t152*t42*t229*t78*t74+t633+2.656434474616293*t28*t16*t3*
        t5*t101*t42*t159*t140*t78*t74-1.328217237308146*t28*t16*t3*
        t5*t37*t291*t140*t78*t74-10.3305785123967*t28*t16*t3*t211*
        t37*t140*t78*t74-6.198347107438017*t28*t16*t3*t103*t101*t42*
        t140*t78*t74+t632+2.656434474616293*t28*t16*t3*t5*t286*t42*
        t140*t78*t74-7.969303423848879*t28*t16*t3*t5*t152*t101*t41*
        t140*t78*t74-0.664108618654073*t28*t16*t3*t5*t37*t276*t159*
        t78*t74-5.165289256198347*t28*t16*t3*t211*t37*t159*t78*t74+
        t631+1.328217237308146*t28*t16*t3*t5*t208*t42*t159*t78*t74-
        3.98465171192444*t28*t16*t3*t5*t213*t41*t159*t78*t74+1.549586776859504*
        t28*t16*t3*t103*t37*t276*t78*t74+1.328217237308146*t28*t16*
        t3*t5*t152*t42*t276*t78*t74-0.664108618654073*t28*t16*t3*t5*
        t37*t617*t78*t74+t630+2.656434474616293*t28*t16*t3*t5*t101*
        t42*t291*t78*t74-0.294026838247081*t36*t29*t38*t39*t41*t159*
        t229*t145*t74+1.372125245153044*t36*t29*t38*t113*t41*t229*
        t145*t74+1.176107352988323*t36*t29*t38*t39*t152*t112*t229*
        t145*t74+t629+2.352214705976647*t36*t29*t38*t39*t101*t112*
        t159*t140*t145*t74-0.588053676494162*t36*t29*t38*t39*t41*t291*
        t140*t145*t74-15.55075277840116*t36*t29*t38*t232*t41*t140*
        t145*t74-10.97700196122435*t36*t29*t38*t113*t101*t112*t140*
        t145*t74+t628+2.352214705976647*t36*t29*t38*t39*t286*t112*
        t140*t145*t74-11.76107352988323*t36*t29*t38*t39*t152*t101*
        t231*t140*t145*t74-0.294026838247081*t36*t29*t38*t39*t41*t276*
        t159*t145*t74-7.775376389200582*t36*t29*t38*t232*t41*t159*
        t145*t74+t627+1.176107352988323*t36*t29*t38*t39*t208*t112*
        t159*t145*t74-5.880536764941616*t36*t29*t38*t39*t213*t231*
        t159*t145*t74+1.372125245153044*t36*t29*t38*t113*t41*t276*
        t145*t74+1.176107352988323*t36*t29*t38*t39*t152*t112*t276*
        t145*t74-0.294026838247081*t36*t29*t38*t39*t41*t617*t145*t74+
        t626+2.352214705976647*t36*t29*t38*t39*t101*t112*t291*t145*
        t74+t567-20.66115702479339*t28*t16*t3*t211*t101*t42*t76-10.3305785123967*
        t28*t16*t3*t211*t152*t42*t76+3.099173553719008*t28*t16*t3*
        t103*t208*t42*t76-1.328217237308146*t28*t16*t3*t5*t583*t42*
        t76+t625-9.297520661157026*t28*t16*t3*t103*t213*t41*t76-18.59504132231405*
        t28*t16*t3*t103*t152*t101*t41*t76+7.969303423848879*t28*t16*
        t3*t5*t286*t101*t41*t76+3.98465171192444*t28*t16*t3*t5*t208*
        t152*t41*t76-15.93860684769776*t28*t16*t3*t5*t152*t213*t112*
        t76+t566-31.10150555680233*t36*t29*t38*t232*t101*t112*t78-
        15.55075277840116*t36*t29*t38*t232*t152*t112*t78+2.744250490306088*
        t36*t29*t38*t113*t208*t112*t78-0.588053676494162*t36*t29*t38*
        t39*t583*t112*t78+t624-13.72125245153044*t36*t29*t38*t113*
        t213*t231*t78+t623+5.880536764941616*t36*t29*t38*t39*t286*
        t101*t231*t78+2.940268382470808*t36*t29*t38*t39*t208*t152*
        t231*t78-17.64161029482485*t36*t29*t38*t39*t152*t213*t516*
        t78+1.328217237308146*t28*t16*t3*t5*t37*t597*t229*t230*t145+
        1.328217237308146*t28*t16*t3*t5*t37*t159*t229*t230*t145-3.099173553719008*
        t28*t16*t3*t103*t37*t229*t230*t145-2.656434474616293*t28*t16*
        t3*t5*t152*t42*t229*t230*t145+t622-5.312868949232586*t28*t16*
        t3*t5*t101*t42*t159*t140*t230*t145+2.656434474616293*t28*t16*
        t3*t5*t37*t291*t140*t230*t145+1.328217237308146*t28*t16*t3*
        t5*t37*t276*t159*t230*t145+0.882080514741242*t36*t29*t38*t39*
        t41*t597*t229*t230*t278+0.882080514741242*t36*t29*t38*t39*
        t41*t159*t229*t230*t278-4.116375735459131*t36*t29*t38*t113*
        t41*t229*t230*t278-3.52832205896497*t36*t29*t38*t39*t152*t112*
        t229*t230*t278+t621-7.05664411792994*t36*t29*t38*t39*t101*
        t112*t159*t140*t230*t278+1.764161029482485*t36*t29*t38*t39*
        t41*t291*t140*t230*t278+0.882080514741242*t36*t29*t38*t39*
        t41*t276*t159*t230*t278-3.98465171192444*t28*t16*t3*t5*t37*
        t159*t229*t513*t278-3.52832205896497*t36*t29*t38*t39*t41*t159*
        t229*t513*t565)+10.62573789846517*t36*t21*t77*t226*t146*t293-
        5.312868949232586*t36*t21*t142*t141*t293-5.312868949232586*
        t36*t21*t142*t146*t292+5.312868949232586*t36*t21*t77*t226*
        t161*t281-2.656434474616293*t36*t21*t142*t160*t281-2.656434474616293*
        t36*t21*t142*t161*t277-15.93860684769776*t36*t21*t77*t509*
        t161*t227+5.312868949232586*t36*t21*t226*t160*t227+10.62573789846517*
        t36*t21*t226*t161*t141*t146)+t593+t592+t591+t590+t589+t588+
        t587+t586+0.5*t12*t27*t3*t33*t5*(t585+t584-12.5*t12*t28*t3*
        t30*t31*t583+t507-122.2222222222222*t12*t152*t28*t3*t30*t39-
        244.4444444444445*t101*t12*t28*t3*t30*t39-25.0*t101*t28*t286*
        t3*t30*t31-12.5*t152*t208*t28*t3*t30*t31+33.33333333333334*
        t105*t213*t28*t3*t30+33.33333333333334*t105*t12*t208*t28*t3*
        t30)+0.5*t27*t3*t33*t5*t583+t580+t579+t506+0.5*t12*t154*t220*
        t27*t3*t33*t5+0.5*t152*t220*t27*t3*t33*t5+0.5*t12*t154*t215*
        t27*t3*t33*t5+0.5*t152*t215*t27*t3*t33*t5+0.5*t154*t208*t27*
        t3*t33*t5+0.5*t12*t154*t194*t3*t33*t5+0.5*t152*t194*t3*t33*
        t5+t493+t492+t491-1.166666666666667*t103*t12*t220*t27*t3*t33-
        1.166666666666667*t103*t12*t215*t27*t3*t33+3.888888888888889*
        t12*t154*t211*t27*t3*t33+3.888888888888889*t152*t211*t27*t3*
        t33+7.777777777777778*t107*t12*t211*t27*t3*t33+7.777777777777778*
        t101*t211*t27*t3*t33-1.166666666666667*t103*t208*t27*t3*t33-
        2.333333333333333*t101*t103*t107*t27*t3*t33+t3*t5*t101*t27*
        t287*t33+t3*t5*t101*t194*t33+t3*t5*t101*t90*t107*t33+t3*t5*
        t12*t27*t287*t107*t33+t3*t5*t286*t27*t107*t33+t3*t5*t12*t194*
        t107*t33+t3*t5*t101*t27*t154*t107*t33-0.006376968888889*t14*
        t17*t35*t223*t147*t294+0.019130906666667*t14*t17*t101*t32*
        t109*t294-0.003188484444444*t14*t17*t35*t223*t162*t282+0.009565453333333*
        t14*t17*t152*t32*t109*t282-0.009565453333333*t14*t17*t152*
        t32*t223*t224+0.006376968888889*t14*t17*t35*t508*t162*t224+
        0.009565453333333*t14*t17*t208*t32*t109*t162+0.019130906666667*
        t14*t17*t213*t12*t109*t162-0.019130906666667*t14*t17*t101*
        t32*t223*t162*t147+0.019130906666667*t14*t17*t286*t32*t109*
        t147+0.038261813333333*t14*t17*t152*t101*t12*t109*t147)+2.0*
        t107*t12*t3*t33*t5*t90+2.0*t101*t3*t33*t5*t90+t578+t577+t576+
        t575+t574+t573+t572+t571+t570+t569+t568+t490+t489+t488+t378+
        t376+t372+t365-4.666666666666667*t103*t107*t12*t27*t3*t33-
        4.666666666666667*t101*t103*t27*t3*t33+t285+t284+t283+t225+
        t222+t221+t218+t216+t209;
    d3fdraraga = t4*(0.003188484444444*t109*t14*t17*t35*(2.656434474616293*
        t21*t36*t80*(-0.695452919183101*t276*t3*t39*t41*t74*t78*grada-
        0.695452919183101*t229*t3*t39*t41*t74*t78*grada+6.490893912375606*
        t113*t140*t3*t41*t74*t78*grada+5.563623353464805*t101*t112*
        t140*t3*t39*t74*t78*grada+13.90905838366201*t213*t231*t3*t39*
        t76*grada-2.781811676732402*t112*t208*t3*t39*t76*grada+25.96357564950242*
        t101*t112*t113*t3*t76*grada-1.0*t208*t21*t36*t42*t5*grada+
        3.0*t21*t213*t36*t41*t5*grada+4.666666666666667*t101*t103*
        t21*t36*t42*grada+1.390905838366201*t145*t229*t230*t3*t39*
        t41*grada+t646+t645)-2.656434474616293*t36*t21*t77*t142*(-
        1.328217237308146*t28*t16*grada*t5*t37*t229*t78*t74+6.198347107438017*
        t28*t16*grada*t103*t37*t140*t78*t74+5.312868949232586*t28*
        t16*grada*t5*t101*t42*t140*t78*t74-1.328217237308146*t28*t16*
        grada*t5*t37*t276*t78*t74-1.176107352988323*t36*t29*grada*
        t3*t39*t41*t229*t145*t74+10.97700196122435*t36*t29*grada*t3*
        t113*t41*t140*t145*t74+9.408858823906586*t36*t29*grada*t3*
        t39*t101*t112*t140*t145*t74-1.176107352988323*t36*t29*grada*
        t3*t39*t41*t276*t145*t74+t648+12.39669421487603*t28*t16*grada*
        t103*t101*t42*t76-2.656434474616293*t28*t16*grada*t5*t208*
        t42*t76+7.969303423848879*t28*t16*grada*t5*t213*t41*t76+t647+
        21.9540039224487*t36*t29*grada*t3*t113*t101*t112*t78-2.352214705976647*
        t36*t29*grada*t3*t39*t208*t112*t78+11.76107352988323*t36*t29*
        grada*t3*t39*t213*t231*t78+2.656434474616293*t28*t16*grada*
        t5*t37*t229*t230*t145+3.52832205896497*t36*t29*grada*t3*t39*
        t41*t229*t230*t278)-5.312868949232586*t36*t21*t142*t141*t312+
        5.312868949232586*t36*t21*t77*t167*t226*t281-2.656434474616293*
        t36*t21*t168*t142*t281-2.656434474616293*t36*t21*t167*t142*
        t277-15.93860684769776*t36*t21*t77*t167*t509*t227+5.312868949232586*
        t36*t21*t168*t226*t227+10.62573789846517*t36*t21*t77*t226*
        t312*t146-5.312868949232586*t36*t21*t142*t309*t146+10.62573789846517*
        t36*t21*t167*t226*t141*t146)+0.5*t12*t27*t3*t33*t5*(-25.0*
        t213*t28*t30*t31*grada-25.0*t12*t208*t28*t30*t31*grada+133.3333333333333*
        t101*t105*t12*t28*t30*grada+t644)+2.0*t107*t12*t33*t5*t90*
        grada+2.0*t101*t33*t5*t90*grada-12.5*t107*t129*t28*t3*t30*
        t33*t35*t90*grada-12.5*t101*t129*t28*t3*t30*t32*t33*t90*grada+
        2.0*t101*t107*t27*t33*t5*grada+29.16666666666667*t107*t260*
        t27*t28*t3*t30*t33*t35*grada-6.25*t129*t220*t27*t28*t3*t30*
        t33*t35*grada-6.25*t129*t215*t27*t28*t3*t30*t33*t35*grada+
        29.16666666666667*t101*t260*t27*t28*t3*t30*t32*t33*grada-6.25*
        t129*t208*t27*t28*t3*t30*t32*t33*grada-12.5*t101*t107*t129*
        t27*t28*t3*t30*t32*t33*grada-4.666666666666667*t103*t107*t12*
        t27*t33*grada-4.666666666666667*t101*t103*t27*t33*grada+t643+
        t642+t641+t640+t639+t638+t3*t5*t12*t90*t302*t33-2.333333333333333*
        t103*t12*t27*t3*t302*t33+t3*t5*t101*t27*t302*t33+grada*t5*
        t208*t27*t33+grada*t5*t12*t27*t220*t33+grada*t5*t12*t27*t215*
        t33+t3*t5*t12*t27*t302*t107*t33+0.019130906666667*t14*t17*
        t101*t32*t109*t313-0.003188484444444*t14*t17*t35*t169*t223*
        t282+0.006376968888889*t14*t17*t35*t169*t508*t224-0.006376968888889*
        t14*t17*t35*t223*t313*t147-0.019130906666667*t14*t17*t101*
        t32*t169*t223*t147+0.009565453333333*t14*t17*t208*t32*t169*
        t109+0.019130906666667*t14*t17*t213*t12*t169*t109)+2.0*t107*
        t12*t27*t33*t5*grada+2.0*t101*t27*t33*t5*grada-12.5*t107*t129*
        t27*t28*t3*t30*t33*t35*grada-12.5*t101*t129*t27*t28*t3*t30*
        t32*t33*grada+t637+t636+t635+t634+t3*t5*t12*t27*t302*t33+0.006376968888889*
        t14*t17*t35*t109*t313-0.006376968888889*t14*t17*t35*t169*t223*
        t147+0.019130906666667*t14*t17*t101*t32*t169*t109;
    d3fdraragb = t4*(0.003188484444444*t109*t14*t17*t35*(2.656434474616293*
        t21*t36*t80*(-0.695452919183101*t276*t3*t39*t41*t74*t78*gradb-
        0.695452919183101*t229*t3*t39*t41*t74*t78*gradb+6.490893912375606*
        t113*t140*t3*t41*t74*t78*gradb+5.563623353464805*t101*t112*
        t140*t3*t39*t74*t78*gradb+13.90905838366201*t213*t231*t3*t39*
        t76*gradb-2.781811676732402*t112*t208*t3*t39*t76*gradb+25.96357564950242*
        t101*t112*t113*t3*t76*gradb-1.0*t208*t21*t36*t42*t5*gradb+
        3.0*t21*t213*t36*t41*t5*gradb+4.666666666666667*t101*t103*
        t21*t36*t42*gradb+1.390905838366201*t145*t229*t230*t3*t39*
        t41*gradb+t661+t660)-2.656434474616293*t36*t21*t77*t142*(-
        1.328217237308146*t28*t16*gradb*t5*t37*t229*t78*t74+6.198347107438017*
        t28*t16*gradb*t103*t37*t140*t78*t74+5.312868949232586*t28*
        t16*gradb*t5*t101*t42*t140*t78*t74-1.328217237308146*t28*t16*
        gradb*t5*t37*t276*t78*t74-1.176107352988323*t36*t29*gradb*
        t3*t39*t41*t229*t145*t74+10.97700196122435*t36*t29*gradb*t3*
        t113*t41*t140*t145*t74+9.408858823906586*t36*t29*gradb*t3*
        t39*t101*t112*t140*t145*t74-1.176107352988323*t36*t29*gradb*
        t3*t39*t41*t276*t145*t74+t663+12.39669421487603*t28*t16*gradb*
        t103*t101*t42*t76-2.656434474616293*t28*t16*gradb*t5*t208*
        t42*t76+7.969303423848879*t28*t16*gradb*t5*t213*t41*t76+t662+
        21.9540039224487*t36*t29*gradb*t3*t113*t101*t112*t78-2.352214705976647*
        t36*t29*gradb*t3*t39*t208*t112*t78+11.76107352988323*t36*t29*
        gradb*t3*t39*t213*t231*t78+2.656434474616293*t28*t16*gradb*
        t5*t37*t229*t230*t145+3.52832205896497*t36*t29*gradb*t3*t39*
        t41*t229*t230*t278)-5.312868949232586*t36*t21*t142*t141*t333+
        5.312868949232586*t36*t21*t77*t173*t226*t281-2.656434474616293*
        t36*t21*t174*t142*t281-2.656434474616293*t36*t21*t173*t142*
        t277-15.93860684769776*t36*t21*t77*t173*t509*t227+5.312868949232586*
        t36*t21*t174*t226*t227+10.62573789846517*t36*t21*t77*t226*
        t333*t146-5.312868949232586*t36*t21*t142*t330*t146+10.62573789846517*
        t36*t21*t173*t226*t141*t146)+0.5*t12*t27*t3*t33*t5*(-25.0*
        t213*t28*t30*t31*gradb-25.0*t12*t208*t28*t30*t31*gradb+133.3333333333333*
        t101*t105*t12*t28*t30*gradb+t659)+2.0*t107*t12*t33*t5*t90*
        gradb+2.0*t101*t33*t5*t90*gradb-12.5*t107*t129*t28*t3*t30*
        t33*t35*t90*gradb-12.5*t101*t129*t28*t3*t30*t32*t33*t90*gradb+
        2.0*t101*t107*t27*t33*t5*gradb+29.16666666666667*t107*t260*
        t27*t28*t3*t30*t33*t35*gradb-6.25*t129*t220*t27*t28*t3*t30*
        t33*t35*gradb-6.25*t129*t215*t27*t28*t3*t30*t33*t35*gradb+
        29.16666666666667*t101*t260*t27*t28*t3*t30*t32*t33*gradb-6.25*
        t129*t208*t27*t28*t3*t30*t32*t33*gradb-12.5*t101*t107*t129*
        t27*t28*t3*t30*t32*t33*gradb-4.666666666666667*t103*t107*t12*
        t27*t33*gradb-4.666666666666667*t101*t103*t27*t33*gradb+t658+
        t657+t656+t655+t654+t653+0.019130906666667*t14*t17*t101*t32*
        t109*t334+t3*t5*t12*t90*t323*t33-2.333333333333333*t103*t12*
        t27*t3*t323*t33+t3*t5*t101*t27*t323*t33+gradb*t5*t208*t27*
        t33+gradb*t5*t12*t27*t220*t33+gradb*t5*t12*t27*t215*t33+t3*
        t5*t12*t27*t323*t107*t33-0.003188484444444*t14*t17*t35*t175*
        t223*t282+0.006376968888889*t14*t17*t35*t175*t508*t224-0.006376968888889*
        t14*t17*t35*t223*t334*t147-0.019130906666667*t14*t17*t101*
        t32*t175*t223*t147+0.009565453333333*t14*t17*t208*t32*t175*
        t109+0.019130906666667*t14*t17*t213*t12*t175*t109)+2.0*t107*
        t12*t27*t33*t5*gradb+2.0*t101*t27*t33*t5*gradb-12.5*t107*t129*
        t27*t28*t3*t30*t33*t35*gradb-12.5*t101*t129*t27*t28*t3*t30*
        t32*t33*gradb+t652+t651+t650+t649+0.006376968888889*t14*t17*
        t35*t109*t334+t3*t5*t12*t27*t323*t33-0.006376968888889*t14*
        t17*t35*t175*t223*t147+0.019130906666667*t14*t17*t101*t32*
        t175*t109;
    d3fdraraab = t4*(2.0*t107*t12*t33*t5*t90+2.0*t101*t33*
        t5*t90-12.5*t107*t129*t28*t3*t30*t33*t35*t90-12.5*t101*t129*
        t28*t3*t30*t32*t33*t90+0.003188484444444*t109*t14*t17*t35*
        (2.656434474616293*t21*t36*(-0.695452919183101*t276*t3*t39*
        t41*t74*t78-0.695452919183101*t229*t3*t39*t41*t74*t78+6.490893912375606*
        t113*t140*t3*t41*t74*t78+5.563623353464805*t101*t112*t140*
        t3*t39*t74*t78+13.90905838366201*t213*t231*t3*t39*t76-2.781811676732402*
        t112*t208*t3*t39*t76+25.96357564950242*t101*t112*t113*t3*t76+
        t676+t675-1.0*t208*t21*t36*t42*t5+3.0*t21*t213*t36*t41*t5+
        4.666666666666667*t101*t103*t21*t36*t42+1.390905838366201*
        t145*t229*t230*t3*t39*t41)*t80-2.656434474616293*t36*t21*t77*
        t142*(-1.328217237308146*t28*t16*t5*t37*t229*t78*t74+6.198347107438017*
        t28*t16*t103*t37*t140*t78*t74+5.312868949232586*t28*t16*t5*
        t101*t42*t140*t78*t74-1.328217237308146*t28*t16*t5*t37*t276*
        t78*t74-1.176107352988323*t36*t29*t3*t39*t41*t229*t145*t74+
        10.97700196122435*t36*t29*t3*t113*t41*t140*t145*t74+9.408858823906586*
        t36*t29*t3*t39*t101*t112*t140*t145*t74-1.176107352988323*t36*
        t29*t3*t39*t41*t276*t145*t74+t678+12.39669421487603*t28*t16*
        t103*t101*t42*t76-2.656434474616293*t28*t16*t5*t208*t42*t76+
        7.969303423848879*t28*t16*t5*t213*t41*t76+t677+21.9540039224487*
        t36*t29*t3*t113*t101*t112*t78-2.352214705976647*t36*t29*t3*
        t39*t208*t112*t78+11.76107352988323*t36*t29*t3*t39*t213*t231*
        t78+2.656434474616293*t28*t16*t5*t37*t229*t230*t145+3.52832205896497*
        t36*t29*t3*t39*t41*t229*t230*t278)-5.312868949232586*t36*t21*
        t142*t141*t361+5.312868949232586*t36*t21*t77*t181*t226*t281-
        2.656434474616293*t36*t21*t184*t142*t281-2.656434474616293*
        t36*t21*t181*t142*t277-15.93860684769776*t36*t21*t77*t181*
        t509*t227+5.312868949232586*t36*t21*t184*t226*t227+10.62573789846517*
        t36*t21*t77*t226*t361*t146-5.312868949232586*t36*t21*t142*
        t354*t146+10.62573789846517*t36*t21*t181*t226*t141*t146)+0.5*
        t12*t27*t3*t33*t5*(t674-25.0*t213*t28*t30*t31-25.0*t12*t208*
        t28*t30*t31+133.3333333333333*t101*t105*t12*t28*t30)+t673+
        t672+t671+t670+t669+t668+2.0*t101*t107*t27*t33*t5+0.019130906666667*
        t14*t17*t101*t32*t109*t362+29.16666666666667*t107*t260*t27*
        t28*t3*t30*t33*t35-6.25*t129*t220*t27*t28*t3*t30*t33*t35-6.25*
        t129*t215*t27*t28*t3*t30*t33*t35-2.333333333333333*t103*t12*
        t27*t3*t33*t344+t3*t5*t12*t90*t344*t33+t3*t5*t101*t27*t344*
        t33+29.16666666666667*t101*t260*t27*t28*t3*t30*t32*t33-6.25*
        t129*t208*t27*t28*t3*t30*t32*t33-12.5*t101*t107*t129*t27*t28*
        t3*t30*t32*t33+t5*t208*t27*t33-4.666666666666667*t103*t107*
        t12*t27*t33-4.666666666666667*t101*t103*t27*t33+t5*t12*t27*
        t220*t33+t5*t12*t27*t215*t33+t3*t5*t12*t27*t344*t107*t33-0.003188484444444*
        t14*t17*t35*t185*t223*t282+0.006376968888889*t14*t17*t35*t185*
        t508*t224-0.006376968888889*t14*t17*t35*t223*t362*t147-0.019130906666667*
        t14*t17*t101*t32*t185*t223*t147+0.009565453333333*t14*t17*
        t208*t32*t185*t109+0.019130906666667*t14*t17*t213*t12*t185*
        t109)+t667+t666+t665+t664+2.0*t107*t12*t27*t33*t5+2.0*t101*
        t27*t33*t5+0.006376968888889*t14*t17*t35*t109*t362-12.5*t107*
        t129*t27*t28*t3*t30*t33*t35+t3*t5*t12*t27*t344*t33-12.5*t101*
        t129*t27*t28*t3*t30*t32*t33-0.006376968888889*t14*t17*t35*
        t185*t223*t147+0.019130906666667*t14*t17*t101*t32*t185*t109;
    d3fdrarbrb = t4*
        (0.5*t12*t3*t33*t379*t5*t90+0.5*t12*t3*t33*t374*t5*t90+0.5*
        t3*t33*t370*t5*t90-4.666666666666667*t103*t12*t154*t3*t33*
        t90-4.666666666666667*t103*t152*t3*t33*t90-2.333333333333333*
        t103*t107*t12*t3*t33*t90-2.333333333333333*t101*t103*t3*t33*
        t90+0.009565453333333*t14*t17*t679*t32*t82+0.038261813333333*
        t14*t17*t286*t152*t12*t82+0.019130906666667*t14*t17*t370*t101*
        t12*t82+0.019130906666667*t14*t17*t373*t101*t82+0.003188484444444*
        t109*t14*t17*t35*(2.656434474616293*t21*t36*(-0.173863229795775*
        t38*t39*t41*t681*t74*t78-0.173863229795775*t140*t38*t389*t39*
        t41*t74*t78-0.173863229795775*t140*t38*t385*t39*t41*t74*t78-
        0.34772645959155*t159*t291*t38*t39*t41*t74*t78+0.811361739046951*
        t113*t38*t389*t41*t74*t78+0.811361739046951*t113*t38*t385*
        t41*t74*t78-9.195433042532109*t159*t232*t38*t41*t74*t78-4.597716521266054*
        t140*t232*t38*t41*t74*t78+0.695452919183101*t101*t112*t38*
        t389*t39*t74*t78+0.695452919183101*t101*t112*t38*t385*t39*
        t74*t78-3.477264595915503*t140*t231*t373*t38*t39*t74*t78+0.695452919183101*
        t112*t140*t370*t38*t39*t74*t78+1.390905838366201*t112*t152*
        t291*t38*t39*t74*t78+1.390905838366201*t112*t159*t286*t38*
        t39*t74*t78-6.954529191831006*t101*t152*t159*t231*t38*t39*
        t74*t78+1.390905838366201*t112*t140*t152*t159*t38*t39*t74*
        t78-6.490893912375606*t112*t113*t152*t159*t38*t74*t78-0.695452919183101*
        t112*t38*t39*t679*t76-20.86358757549302*t101*t373*t38*t39*
        t516*t76+3.477264595915503*t101*t231*t370*t38*t39*t76+6.954529191831006*
        t152*t231*t286*t38*t39*t76-16.22723478093901*t113*t231*t373*
        t38*t76+3.245446956187803*t112*t113*t370*t38*t76-36.78173217012844*
        t112*t152*t232*t38*t76-18.39086608506422*t101*t112*t232*t38*
        t76-0.5*t21*t3*t36*t42*t5*t679+t620+t619+t618+t600+t599+t598+
        0.34772645959155*t140*t145*t159*t230*t38*t39*t41*t597+t596+
        t595+t594+t517-1.043179378774651*t140*t278*t38*t385*t39*t41*
        t513+t511+1.5*t101*t21*t3*t36*t370*t41*t5+3.0*t152*t21*t286*
        t3*t36*t41*t5-6.0*t101*t112*t21*t3*t36*t373*t5+1.166666666666667*
        t103*t21*t3*t36*t370*t42-7.777777777777778*t152*t21*t211*t3*
        t36*t42-3.888888888888889*t101*t21*t211*t3*t36*t42+0.34772645959155*
        t140*t145*t230*t38*t389*t39*t41+0.34772645959155*t140*t145*
        t230*t38*t385*t39*t41+0.695452919183101*t145*t159*t230*t291*
        t38*t39*t41-1.622723478093901*t113*t145*t230*t38*t385*t41-
        3.5*t103*t21*t3*t36*t373*t41-1.390905838366201*t101*t112*t145*
        t230*t38*t385*t39-2.781811676732402*t112*t140*t145*t152*t159*
        t230*t38*t39)*t80-2.656434474616293*t36*t21*t77*t142*(-0.664108618654073*
        t28*t16*t3*t5*t37*t385*t140*t78*t74+t633+2.656434474616293*
        t28*t16*t3*t5*t152*t42*t159*t140*t78*t74-0.664108618654073*
        t28*t16*t3*t5*t37*t389*t140*t78*t74-5.165289256198347*t28*
        t16*t3*t211*t37*t140*t78*t74+t632+1.328217237308146*t28*t16*
        t3*t5*t370*t42*t140*t78*t74-3.98465171192444*t28*t16*t3*t5*
        t373*t41*t140*t78*t74+1.549586776859504*t28*t16*t3*t103*t37*
        t385*t78*t74+1.328217237308146*t28*t16*t3*t5*t101*t42*t385*
        t78*t74-1.328217237308146*t28*t16*t3*t5*t37*t291*t159*t78*
        t74-10.3305785123967*t28*t16*t3*t211*t37*t159*t78*t74+t631-
        6.198347107438017*t28*t16*t3*t103*t152*t42*t159*t78*t74+2.656434474616293*
        t28*t16*t3*t5*t286*t42*t159*t78*t74-7.969303423848879*t28*
        t16*t3*t5*t152*t101*t41*t159*t78*t74+1.549586776859504*t28*
        t16*t3*t103*t37*t389*t78*t74+1.328217237308146*t28*t16*t3*
        t5*t101*t42*t389*t78*t74+t630+2.656434474616293*t28*t16*t3*
        t5*t152*t42*t291*t78*t74-0.664108618654073*t28*t16*t3*t5*t37*
        t681*t78*t74-0.294026838247081*t36*t29*t38*t39*t41*t385*t140*
        t145*t74+t629+2.352214705976647*t36*t29*t38*t39*t152*t112*
        t159*t140*t145*t74-0.294026838247081*t36*t29*t38*t39*t41*t389*
        t140*t145*t74-7.775376389200582*t36*t29*t38*t232*t41*t140*
        t145*t74+t628+1.176107352988323*t36*t29*t38*t39*t370*t112*
        t140*t145*t74-5.880536764941616*t36*t29*t38*t39*t373*t231*
        t140*t145*t74+1.372125245153044*t36*t29*t38*t113*t41*t385*
        t145*t74+1.176107352988323*t36*t29*t38*t39*t101*t112*t385*
        t145*t74-0.588053676494162*t36*t29*t38*t39*t41*t291*t159*t145*
        t74-15.55075277840116*t36*t29*t38*t232*t41*t159*t145*t74+t627-
        10.97700196122435*t36*t29*t38*t113*t152*t112*t159*t145*t74+
        2.352214705976647*t36*t29*t38*t39*t286*t112*t159*t145*t74-
        11.76107352988323*t36*t29*t38*t39*t152*t101*t231*t159*t145*
        t74+1.372125245153044*t36*t29*t38*t113*t41*t389*t145*t74+1.176107352988323*
        t36*t29*t38*t39*t101*t112*t389*t145*t74+t626+2.352214705976647*
        t36*t29*t38*t39*t152*t112*t291*t145*t74-0.294026838247081*
        t36*t29*t38*t39*t41*t681*t145*t74+t567-10.3305785123967*t28*
        t16*t3*t211*t101*t42*t76-20.66115702479339*t28*t16*t3*t211*
        t152*t42*t76+3.099173553719008*t28*t16*t3*t103*t370*t42*t76+
        t625-1.328217237308146*t28*t16*t3*t5*t679*t42*t76-18.59504132231405*
        t28*t16*t3*t103*t152*t101*t41*t76+3.98465171192444*t28*t16*
        t3*t5*t370*t101*t41*t76-9.297520661157025*t28*t16*t3*t103*
        t373*t41*t76+7.969303423848879*t28*t16*t3*t5*t286*t152*t41*
        t76-15.93860684769776*t28*t16*t3*t5*t373*t101*t112*t76+t566-
        15.55075277840116*t36*t29*t38*t232*t101*t112*t78-31.10150555680233*
        t36*t29*t38*t232*t152*t112*t78+2.744250490306088*t36*t29*t38*
        t113*t370*t112*t78+t624-0.588053676494162*t36*t29*t38*t39*
        t679*t112*t78+t623+2.940268382470808*t36*t29*t38*t39*t370*
        t101*t231*t78-13.72125245153044*t36*t29*t38*t113*t373*t231*
        t78+5.880536764941616*t36*t29*t38*t39*t286*t152*t231*t78-17.64161029482485*
        t36*t29*t38*t39*t373*t101*t516*t78+1.328217237308146*t28*t16*
        t3*t5*t37*t159*t597*t140*t230*t145+1.328217237308146*t28*t16*
        t3*t5*t37*t385*t140*t230*t145+t622-5.312868949232586*t28*t16*
        t3*t5*t152*t42*t159*t140*t230*t145+1.328217237308146*t28*t16*
        t3*t5*t37*t389*t140*t230*t145-3.099173553719008*t28*t16*t3*
        t103*t37*t385*t230*t145-2.656434474616293*t28*t16*t3*t5*t101*
        t42*t385*t230*t145+2.656434474616293*t28*t16*t3*t5*t37*t291*
        t159*t230*t145+0.882080514741242*t36*t29*t38*t39*t41*t159*
        t597*t140*t230*t278+0.882080514741242*t36*t29*t38*t39*t41*
        t385*t140*t230*t278+t621-7.05664411792994*t36*t29*t38*t39*
        t152*t112*t159*t140*t230*t278+0.882080514741242*t36*t29*t38*
        t39*t41*t389*t140*t230*t278-4.116375735459131*t36*t29*t38*
        t113*t41*t385*t230*t278-3.52832205896497*t36*t29*t38*t39*t101*
        t112*t385*t230*t278+1.764161029482485*t36*t29*t38*t39*t41*
        t291*t159*t230*t278-3.98465171192444*t28*t16*t3*t5*t37*t385*
        t140*t513*t278-3.52832205896497*t36*t29*t38*t39*t41*t385*t140*
        t513*t565)+10.62573789846517*t36*t21*t77*t226*t161*t293-5.312868949232586*
        t36*t21*t142*t160*t293-5.312868949232586*t36*t21*t142*t161*
        t292+5.312868949232586*t36*t21*t77*t226*t391*t146-2.656434474616293*
        t36*t21*t142*t390*t146-15.93860684769776*t36*t21*t77*t509*
        t384*t146+10.62573789846517*t36*t21*t226*t160*t161*t146-2.656434474616293*
        t36*t21*t142*t391*t141+5.312868949232586*t36*t21*t226*t384*
        t141)+0.5*t12*t27*t3*t33*t5*(-12.5*t12*t28*t3*t30*t31*t679+
        t585+t584+t507-244.4444444444445*t12*t152*t28*t3*t30*t39-122.2222222222222*
        t101*t12*t28*t3*t30*t39+33.33333333333334*t105*t28*t3*t30*
        t373-12.5*t101*t28*t3*t30*t31*t370+33.33333333333334*t105*
        t12*t28*t3*t30*t370-25.0*t152*t28*t286*t3*t30*t31)+0.5*t27*
        t3*t33*t5*t679+t593+t592+t591+t590+t589+t588+t587+t586+t580+
        t579+t506+0.5*t107*t12*t27*t3*t33*t379*t5+0.5*t101*t27*t3*
        t33*t379*t5+0.5*t107*t12*t27*t3*t33*t374*t5+0.5*t101*t27*t3*
        t33*t374*t5+0.5*t107*t27*t3*t33*t370*t5+0.5*t107*t12*t194*
        t3*t33*t5+0.5*t101*t194*t3*t33*t5+t493+t492+t491+0.009565453333333*
        t14*t17*t101*t32*t109*t392-0.009565453333333*t14*t17*t101*
        t32*t223*t382-1.166666666666667*t103*t12*t27*t3*t33*t379-1.166666666666667*
        t103*t12*t27*t3*t33*t374-1.166666666666667*t103*t27*t3*t33*
        t370+7.777777777777778*t12*t154*t211*t27*t3*t33+7.777777777777778*
        t152*t211*t27*t3*t33+3.888888888888889*t107*t12*t211*t27*t3*
        t33+3.888888888888889*t101*t211*t27*t3*t33-2.333333333333333*
        t103*t152*t154*t27*t3*t33+t3*t5*t152*t27*t287*t33+t3*t5*t152*
        t194*t33+t3*t5*t152*t90*t154*t33+t3*t5*t12*t27*t287*t154*t33+
        t3*t5*t286*t27*t154*t33+t3*t5*t12*t194*t154*t33+t3*t5*t152*
        t27*t154*t107*t33-0.006376968888889*t14*t17*t35*t223*t162*
        t294+0.019130906666667*t14*t17*t152*t32*t109*t294+0.019130906666667*
        t14*t17*t286*t32*t109*t162+0.038261813333333*t14*t17*t152*
        t101*t12*t109*t162-0.003188484444444*t14*t17*t35*t223*t392*
        t147+0.006376968888889*t14*t17*t35*t508*t382*t147-0.019130906666667*
        t14*t17*t152*t32*t223*t162*t147+0.009565453333333*t14*t17*
        t370*t32*t109*t147+0.019130906666667*t14*t17*t373*t12*t109*
        t147)+2.0*t12*t154*t3*t33*t5*t90+2.0*t152*t3*t33*t5*t90+t578+
        t577+t576+t575+t574+t573+t572+t571+t570+t569+t568+t490+t489+
        t488+t395+t394+t393+t383+t381+t380+t377+t375+t371-4.666666666666667*
        t103*t12*t154*t27*t3*t33-4.666666666666667*t103*t152*t27*t3*
        t33+t219+t217+t210+t196;
    d3fdrarbga = t4*(0.003188484444444*t109*t14*t17*t35*(2.656434474616293*
        t21*t36*t80*(-0.695452919183101*t291*t3*t39*t41*t74*t78*grada-
        0.695452919183101*t140*t159*t3*t39*t41*t74*t78*grada+3.245446956187803*
        t113*t159*t3*t41*t74*t78*grada+3.245446956187803*t113*t140*
        t3*t41*t74*t78*grada+2.781811676732402*t101*t112*t159*t3*t39*
        t74*t78*grada+2.781811676732402*t112*t140*t152*t3*t39*t74*
        t78*grada-2.781811676732402*t112*t286*t3*t39*t76*grada+13.90905838366201*
        t101*t152*t231*t3*t39*t76*grada+12.98178782475121*t112*t113*
        t152*t3*t76*grada+12.98178782475121*t101*t112*t113*t3*t76*
        grada-1.0*t21*t286*t36*t42*t5*grada+3.0*t101*t152*t21*t36*
        t41*t5*grada+2.333333333333333*t103*t152*t21*t36*t42*grada+
        2.333333333333333*t101*t103*t21*t36*t42*grada+1.390905838366201*
        t140*t145*t159*t230*t3*t39*t41*grada+t646+t645)-2.656434474616293*
        t36*t21*t77*t142*(-1.328217237308146*t28*t16*grada*t5*t37*
        t159*t140*t78*t74+3.099173553719008*t28*t16*grada*t103*t37*
        t140*t78*t74+2.656434474616293*t28*t16*grada*t5*t152*t42*t140*
        t78*t74+3.099173553719008*t28*t16*grada*t103*t37*t159*t78*
        t74+2.656434474616293*t28*t16*grada*t5*t101*t42*t159*t78*t74-
        1.328217237308146*t28*t16*grada*t5*t37*t291*t78*t74-1.176107352988323*
        t36*t29*grada*t3*t39*t41*t159*t140*t145*t74+5.488500980612176*
        t36*t29*grada*t3*t113*t41*t140*t145*t74+4.704429411953293*
        t36*t29*grada*t3*t39*t152*t112*t140*t145*t74+5.488500980612176*
        t36*t29*grada*t3*t113*t41*t159*t145*t74+4.704429411953293*
        t36*t29*grada*t3*t39*t101*t112*t159*t145*t74-1.176107352988323*
        t36*t29*grada*t3*t39*t41*t291*t145*t74+t648+6.198347107438017*
        t28*t16*grada*t103*t101*t42*t76+6.198347107438017*t28*t16*
        grada*t103*t152*t42*t76-2.656434474616293*t28*t16*grada*t5*
        t286*t42*t76+7.969303423848879*t28*t16*grada*t5*t152*t101*
        t41*t76+t647+10.97700196122435*t36*t29*grada*t3*t113*t101*
        t112*t78+10.97700196122435*t36*t29*grada*t3*t113*t152*t112*
        t78-2.352214705976647*t36*t29*grada*t3*t39*t286*t112*t78+11.76107352988323*
        t36*t29*grada*t3*t39*t152*t101*t231*t78+2.656434474616293*
        t28*t16*grada*t5*t37*t159*t140*t230*t145+3.52832205896497*
        t36*t29*grada*t3*t39*t41*t159*t140*t230*t278)+5.312868949232586*
        t36*t21*t77*t226*t161*t312-2.656434474616293*t36*t21*t142*
        t160*t312-2.656434474616293*t36*t21*t142*t161*t309+5.312868949232586*
        t36*t21*t77*t167*t226*t293-2.656434474616293*t36*t21*t168*
        t142*t293-2.656434474616293*t36*t21*t167*t142*t292+5.312868949232586*
        t36*t21*t77*t226*t404*t146-2.656434474616293*t36*t21*t142*
        t403*t146-15.93860684769776*t36*t21*t77*t167*t509*t161*t146+
        5.312868949232586*t36*t21*t168*t226*t161*t146+5.312868949232586*
        t36*t21*t167*t226*t160*t146-2.656434474616293*t36*t21*t142*
        t404*t141+5.312868949232586*t36*t21*t167*t226*t161*t141)+0.5*
        t12*t27*t3*t33*t5*(-25.0*t12*t28*t286*t30*t31*grada-25.0*t101*
        t152*t28*t30*t31*grada+66.66666666666667*t105*t12*t152*t28*
        t30*grada+66.66666666666667*t101*t105*t12*t28*t30*grada+t644)-
        6.25*t129*t154*t28*t3*t30*t33*t35*t90*grada-6.25*t107*t129*
        t28*t3*t30*t33*t35*t90*grada-6.25*t129*t152*t28*t3*t30*t32*
        t33*t90*grada-6.25*t101*t129*t28*t3*t30*t32*t33*t90*grada-
        6.25*t129*t27*t28*t287*t3*t30*t33*t35*grada+14.58333333333333*
        t154*t260*t27*t28*t3*t30*t33*t35*grada+14.58333333333333*t107*
        t260*t27*t28*t3*t30*t33*t35*grada-6.25*t107*t129*t154*t27*
        t28*t3*t30*t33*t35*grada-6.25*t129*t27*t28*t286*t3*t30*t32*
        t33*grada+14.58333333333333*t152*t260*t27*t28*t3*t30*t32*t33*
        grada+14.58333333333333*t101*t260*t27*t28*t3*t30*t32*t33*grada-
        6.25*t101*t129*t154*t27*t28*t3*t30*t32*t33*grada-6.25*t107*
        t129*t152*t27*t28*t3*t30*t32*t33*grada-2.333333333333333*t103*
        t12*t154*t27*t33*grada-2.333333333333333*t103*t152*t27*t33*
        grada-2.333333333333333*t103*t107*t12*t27*t33*grada-2.333333333333333*
        t101*t103*t27*t33*grada+0.5*t12*t3*t33*t398*t5*t90+0.5*t12*
        t3*t302*t33*t5*t90+t643+t642+t641+t640+t639+t638+0.5*t107*
        t12*t27*t3*t33*t398*t5+0.5*t101*t27*t3*t33*t398*t5+0.5*t12*
        t154*t27*t3*t302*t33*t5+0.5*t152*t27*t3*t302*t33*t5+0.009565453333333*
        t14*t17*t101*t32*t109*t405-1.166666666666667*t103*t12*t27*
        t3*t33*t398+grada*t5*t152*t90*t33+grada*t5*t101*t90*t33-1.166666666666667*
        t103*t12*t27*t3*t302*t33+grada*t5*t12*t27*t287*t33+grada*t5*
        t286*t27*t33+grada*t5*t12*t90*t154*t33+grada*t5*t101*t27*t154*
        t33+grada*t5*t12*t90*t107*t33+grada*t5*t152*t27*t107*t33+grada*
        t5*t12*t27*t154*t107*t33-0.003188484444444*t14*t17*t35*t223*
        t162*t313+0.009565453333333*t14*t17*t152*t32*t109*t313-0.003188484444444*
        t14*t17*t35*t169*t223*t294-0.009565453333333*t14*t17*t101*
        t32*t169*t223*t162-0.003188484444444*t14*t17*t35*t223*t405*
        t147-0.009565453333333*t14*t17*t152*t32*t169*t223*t147+0.006376968888889*
        t14*t17*t35*t169*t508*t162*t147+0.009565453333333*t14*t17*
        t286*t32*t169*t109+0.019130906666667*t14*t17*t152*t101*t12*
        t169*t109)+t637+t636+t635+t634+t407+t406+t402+t401+t400+t399+
        t397+t396+t315+t314+t306+t305+t304+t303+t299+t297;
    d3fdrarbgb = t4*(0.003188484444444*t109*t14*t17*t35*(2.656434474616293*
        t21*t36*t80*(-0.695452919183101*t291*t3*t39*t41*t74*t78*gradb-
        0.695452919183101*t140*t159*t3*t39*t41*t74*t78*gradb+3.245446956187803*
        t113*t159*t3*t41*t74*t78*gradb+3.245446956187803*t113*t140*
        t3*t41*t74*t78*gradb+2.781811676732402*t101*t112*t159*t3*t39*
        t74*t78*gradb+2.781811676732402*t112*t140*t152*t3*t39*t74*
        t78*gradb-2.781811676732402*t112*t286*t3*t39*t76*gradb+13.90905838366201*
        t101*t152*t231*t3*t39*t76*gradb+12.98178782475121*t112*t113*
        t152*t3*t76*gradb+12.98178782475121*t101*t112*t113*t3*t76*
        gradb-1.0*t21*t286*t36*t42*t5*gradb+3.0*t101*t152*t21*t36*
        t41*t5*gradb+2.333333333333333*t103*t152*t21*t36*t42*gradb+
        2.333333333333333*t101*t103*t21*t36*t42*gradb+1.390905838366201*
        t140*t145*t159*t230*t3*t39*t41*gradb+t661+t660)-2.656434474616293*
        t36*t21*t77*t142*(-1.328217237308146*t28*t16*gradb*t5*t37*
        t159*t140*t78*t74+3.099173553719008*t28*t16*gradb*t103*t37*
        t140*t78*t74+2.656434474616293*t28*t16*gradb*t5*t152*t42*t140*
        t78*t74+3.099173553719008*t28*t16*gradb*t103*t37*t159*t78*
        t74+2.656434474616293*t28*t16*gradb*t5*t101*t42*t159*t78*t74-
        1.328217237308146*t28*t16*gradb*t5*t37*t291*t78*t74-1.176107352988323*
        t36*t29*gradb*t3*t39*t41*t159*t140*t145*t74+5.488500980612176*
        t36*t29*gradb*t3*t113*t41*t140*t145*t74+4.704429411953293*
        t36*t29*gradb*t3*t39*t152*t112*t140*t145*t74+5.488500980612176*
        t36*t29*gradb*t3*t113*t41*t159*t145*t74+4.704429411953293*
        t36*t29*gradb*t3*t39*t101*t112*t159*t145*t74-1.176107352988323*
        t36*t29*gradb*t3*t39*t41*t291*t145*t74+t663+6.198347107438017*
        t28*t16*gradb*t103*t101*t42*t76+6.198347107438017*t28*t16*
        gradb*t103*t152*t42*t76-2.656434474616293*t28*t16*gradb*t5*
        t286*t42*t76+7.969303423848879*t28*t16*gradb*t5*t152*t101*
        t41*t76+t662+10.97700196122435*t36*t29*gradb*t3*t113*t101*
        t112*t78+10.97700196122435*t36*t29*gradb*t3*t113*t152*t112*
        t78-2.352214705976647*t36*t29*gradb*t3*t39*t286*t112*t78+11.76107352988323*
        t36*t29*gradb*t3*t39*t152*t101*t231*t78+2.656434474616293*
        t28*t16*gradb*t5*t37*t159*t140*t230*t145+3.52832205896497*
        t36*t29*gradb*t3*t39*t41*t159*t140*t230*t278)+5.312868949232586*
        t36*t21*t77*t226*t161*t333-2.656434474616293*t36*t21*t142*
        t160*t333-2.656434474616293*t36*t21*t142*t161*t330+5.312868949232586*
        t36*t21*t77*t173*t226*t293-2.656434474616293*t36*t21*t174*
        t142*t293-2.656434474616293*t36*t21*t173*t142*t292+5.312868949232586*
        t36*t21*t77*t226*t416*t146-2.656434474616293*t36*t21*t142*
        t415*t146-15.93860684769776*t36*t21*t77*t173*t509*t161*t146+
        5.312868949232586*t36*t21*t174*t226*t161*t146+5.312868949232586*
        t36*t21*t173*t226*t160*t146-2.656434474616293*t36*t21*t142*
        t416*t141+5.312868949232586*t36*t21*t173*t226*t161*t141)+0.5*
        t12*t27*t3*t33*t5*(-25.0*t12*t28*t286*t30*t31*gradb-25.0*t101*
        t152*t28*t30*t31*gradb+66.66666666666667*t105*t12*t152*t28*
        t30*gradb+66.66666666666667*t101*t105*t12*t28*t30*gradb+t659)-
        6.25*t129*t154*t28*t3*t30*t33*t35*t90*gradb-6.25*t107*t129*
        t28*t3*t30*t33*t35*t90*gradb-6.25*t129*t152*t28*t3*t30*t32*
        t33*t90*gradb-6.25*t101*t129*t28*t3*t30*t32*t33*t90*gradb-
        6.25*t129*t27*t28*t287*t3*t30*t33*t35*gradb+14.58333333333333*
        t154*t260*t27*t28*t3*t30*t33*t35*gradb+14.58333333333333*t107*
        t260*t27*t28*t3*t30*t33*t35*gradb-6.25*t107*t129*t154*t27*
        t28*t3*t30*t33*t35*gradb-6.25*t129*t27*t28*t286*t3*t30*t32*
        t33*gradb+14.58333333333333*t152*t260*t27*t28*t3*t30*t32*t33*
        gradb+14.58333333333333*t101*t260*t27*t28*t3*t30*t32*t33*gradb-
        6.25*t101*t129*t154*t27*t28*t3*t30*t32*t33*gradb-6.25*t107*
        t129*t152*t27*t28*t3*t30*t32*t33*gradb-2.333333333333333*t103*
        t12*t154*t27*t33*gradb-2.333333333333333*t103*t152*t27*t33*
        gradb-2.333333333333333*t103*t107*t12*t27*t33*gradb-2.333333333333333*
        t101*t103*t27*t33*gradb+0.5*t12*t3*t33*t410*t5*t90+0.5*t12*
        t3*t323*t33*t5*t90+t658+t657+t656+t655+t654+t653+0.5*t107*
        t12*t27*t3*t33*t410*t5+0.5*t101*t27*t3*t33*t410*t5+0.5*t12*
        t154*t27*t3*t323*t33*t5+0.5*t152*t27*t3*t323*t33*t5+0.009565453333333*
        t14*t17*t101*t32*t109*t417-1.166666666666667*t103*t12*t27*
        t3*t33*t410-0.003188484444444*t14*t17*t35*t223*t162*t334+0.009565453333333*
        t14*t17*t152*t32*t109*t334+gradb*t5*t152*t90*t33+gradb*t5*
        t101*t90*t33-1.166666666666667*t103*t12*t27*t3*t323*t33+gradb*
        t5*t12*t27*t287*t33+gradb*t5*t286*t27*t33+gradb*t5*t12*t90*
        t154*t33+gradb*t5*t101*t27*t154*t33+gradb*t5*t12*t90*t107*
        t33+gradb*t5*t152*t27*t107*t33+gradb*t5*t12*t27*t154*t107*
        t33-0.003188484444444*t14*t17*t35*t175*t223*t294-0.009565453333333*
        t14*t17*t101*t32*t175*t223*t162-0.003188484444444*t14*t17*
        t35*t223*t417*t147-0.009565453333333*t14*t17*t152*t32*t175*
        t223*t147+0.006376968888889*t14*t17*t35*t175*t508*t162*t147+
        0.009565453333333*t14*t17*t286*t32*t175*t109+0.019130906666667*
        t14*t17*t152*t101*t12*t175*t109)+t652+t651+t650+t649+t419+
        t418+t414+t413+t412+t411+t409+t408+t336+t335+t327+t326+t325+
        t324+t320+t318;
    d3fdrarbab = t4*(0.5*t12*t3*t33*t422*t5*t90+0.5*t12*t3*
        t33*t344*t5*t90-6.25*t129*t154*t28*t3*t30*t33*t35*t90-6.25*
        t107*t129*t28*t3*t30*t33*t35*t90-6.25*t129*t152*t28*t3*t30*
        t32*t33*t90-6.25*t101*t129*t28*t3*t30*t32*t33*t90+0.003188484444444*
        t109*t14*t17*t35*(2.656434474616293*t21*t36*(-0.695452919183101*
        t291*t3*t39*t41*t74*t78-0.695452919183101*t140*t159*t3*t39*
        t41*t74*t78+3.245446956187803*t113*t159*t3*t41*t74*t78+3.245446956187803*
        t113*t140*t3*t41*t74*t78+2.781811676732402*t101*t112*t159*
        t3*t39*t74*t78+2.781811676732402*t112*t140*t152*t3*t39*t74*
        t78-2.781811676732402*t112*t286*t3*t39*t76+13.90905838366201*
        t101*t152*t231*t3*t39*t76+12.98178782475121*t112*t113*t152*
        t3*t76+12.98178782475121*t101*t112*t113*t3*t76+t676+t675-1.0*
        t21*t286*t36*t42*t5+3.0*t101*t152*t21*t36*t41*t5+2.333333333333333*
        t103*t152*t21*t36*t42+2.333333333333333*t101*t103*t21*t36*
        t42+1.390905838366201*t140*t145*t159*t230*t3*t39*t41)*t80-
        2.656434474616293*t36*t21*t77*t142*(-1.328217237308146*t28*
        t16*t5*t37*t159*t140*t78*t74+3.099173553719008*t28*t16*t103*
        t37*t140*t78*t74+2.656434474616293*t28*t16*t5*t152*t42*t140*
        t78*t74+3.099173553719008*t28*t16*t103*t37*t159*t78*t74+2.656434474616293*
        t28*t16*t5*t101*t42*t159*t78*t74-1.328217237308146*t28*t16*
        t5*t37*t291*t78*t74-1.176107352988323*t36*t29*t3*t39*t41*t159*
        t140*t145*t74+5.488500980612176*t36*t29*t3*t113*t41*t140*t145*
        t74+4.704429411953293*t36*t29*t3*t39*t152*t112*t140*t145*t74+
        5.488500980612176*t36*t29*t3*t113*t41*t159*t145*t74+4.704429411953293*
        t36*t29*t3*t39*t101*t112*t159*t145*t74-1.176107352988323*t36*
        t29*t3*t39*t41*t291*t145*t74+t678+6.198347107438017*t28*t16*
        t103*t101*t42*t76+6.198347107438017*t28*t16*t103*t152*t42*
        t76-2.656434474616293*t28*t16*t5*t286*t42*t76+7.969303423848879*
        t28*t16*t5*t152*t101*t41*t76+t677+10.97700196122435*t36*t29*
        t3*t113*t101*t112*t78+10.97700196122435*t36*t29*t3*t113*t152*
        t112*t78-2.352214705976647*t36*t29*t3*t39*t286*t112*t78+11.76107352988323*
        t36*t29*t3*t39*t152*t101*t231*t78+2.656434474616293*t28*t16*
        t5*t37*t159*t140*t230*t145+3.52832205896497*t36*t29*t3*t39*
        t41*t159*t140*t230*t278)+5.312868949232586*t36*t21*t77*t226*
        t161*t361-2.656434474616293*t36*t21*t142*t160*t361-2.656434474616293*
        t36*t21*t142*t161*t354+5.312868949232586*t36*t21*t77*t181*
        t226*t293-2.656434474616293*t36*t21*t184*t142*t293-2.656434474616293*
        t36*t21*t181*t142*t292+5.312868949232586*t36*t21*t77*t226*
        t435*t146-2.656434474616293*t36*t21*t142*t430*t146-15.93860684769776*
        t36*t21*t77*t181*t509*t161*t146+5.312868949232586*t36*t21*
        t184*t226*t161*t146+5.312868949232586*t36*t21*t181*t226*t160*
        t146-2.656434474616293*t36*t21*t142*t435*t141+5.312868949232586*
        t36*t21*t181*t226*t161*t141)+0.5*t12*t27*t3*t33*t5*(t674-25.0*
        t12*t28*t286*t30*t31-25.0*t101*t152*t28*t30*t31+66.66666666666667*
        t105*t12*t152*t28*t30+66.66666666666667*t101*t105*t12*t28*
        t30)+t673+t672+t671+t670+t669+t668+0.5*t107*t12*t27*t3*t33*
        t422*t5+0.5*t101*t27*t3*t33*t422*t5+0.5*t12*t154*t27*t3*t33*
        t344*t5+0.5*t152*t27*t3*t33*t344*t5+0.009565453333333*t14*
        t17*t101*t32*t109*t436-1.166666666666667*t103*t12*t27*t3*t33*
        t422-0.003188484444444*t14*t17*t35*t223*t162*t362+0.009565453333333*
        t14*t17*t152*t32*t109*t362-6.25*t129*t27*t28*t287*t3*t30*t33*
        t35+14.58333333333333*t154*t260*t27*t28*t3*t30*t33*t35+14.58333333333333*
        t107*t260*t27*t28*t3*t30*t33*t35-6.25*t107*t129*t154*t27*t28*
        t3*t30*t33*t35-1.166666666666667*t103*t12*t27*t3*t33*t344+
        t5*t152*t90*t33+t5*t101*t90*t33-6.25*t129*t27*t28*t286*t3*
        t30*t32*t33+14.58333333333333*t152*t260*t27*t28*t3*t30*t32*
        t33+14.58333333333333*t101*t260*t27*t28*t3*t30*t32*t33-6.25*
        t101*t129*t154*t27*t28*t3*t30*t32*t33-6.25*t107*t129*t152*
        t27*t28*t3*t30*t32*t33+t5*t12*t27*t287*t33+t5*t286*t27*t33-
        2.333333333333333*t103*t12*t154*t27*t33-2.333333333333333*
        t103*t152*t27*t33-2.333333333333333*t103*t107*t12*t27*t33-
        2.333333333333333*t101*t103*t27*t33+t5*t12*t90*t154*t33+t5*
        t101*t27*t154*t33+t5*t12*t90*t107*t33+t5*t152*t27*t107*t33+
        t5*t12*t27*t154*t107*t33-0.003188484444444*t14*t17*t35*t185*
        t223*t294-0.009565453333333*t14*t17*t101*t32*t185*t223*t162-
        0.003188484444444*t14*t17*t35*t223*t436*t147-0.009565453333333*
        t14*t17*t152*t32*t185*t223*t147+0.006376968888889*t14*t17*
        t35*t185*t508*t162*t147+0.009565453333333*t14*t17*t286*t32*
        t185*t109+0.019130906666667*t14*t17*t152*t101*t12*t185*t109)+
        t667+t666+t665+t664+t438+t437+t426+t425+t424+t423+t421+t420+
        t364+t363+t348+t347+t346+t345+t341+t339;
    d3fdragaga = t4*(2.0*t12*t27*t302*t33*t5*grada-12.5*t129*
        t27*t28*t3*t30*t302*t33*t35*grada+0.003188484444444*t109*t14*
        t17*t35*(2.656434474616293*t21*t36*(-1.390905838366201*t1*
        t140*t39*t41*t74*t78-5.563623353464805*t1*t101*t112*t39*t76+
        t687+t353+t352+t351+t350+t349)*t80-2.656434474616293*t36*t21*
        t77*t142*(t360+t359-2.352214705976647*t36*t29*t1*t39*t41*t140*
        t145*t74+t358+t357+t356+t688+t355-4.704429411953293*t36*t29*
        t1*t39*t101*t112*t78)+10.62573789846517*t36*t21*t77*t167*t226*
        t312-5.312868949232586*t36*t21*t168*t142*t312-5.312868949232586*
        t36*t21*t167*t142*t309-15.93860684769776*t36*t21*t77*t445*
        t509*t146+5.312868949232586*t36*t21*t77*t446*t226*t146+10.62573789846517*
        t36*t21*t168*t167*t226*t146-2.656434474616293*t36*t21*t447*
        t142*t146+5.312868949232586*t36*t21*t445*t226*t141-2.656434474616293*
        t36*t21*t446*t142*t141)+t686+t684+t683+t682+26.04166666666667*
        t1*t101*t27*t3*t33*t36*t40*t440*t441+26.04166666666667*t1*
        t107*t111*t27*t3*t33*t36*t440*t441-25.0*t1*t107*t129*t27*t28*
        t30*t33*t35+t347+t346+t345+t342+t341+t340+t339+t338+t337-25.0*
        t1*t101*t129*t27*t28*t30*t32*t33-0.006376968888889*t14*t17*
        t35*t169*t223*t313-0.009565453333333*t14*t17*t101*t32*t443*
        t223+0.006376968888889*t14*t17*t35*t443*t508*t147-0.003188484444444*
        t14*t17*t35*t448*t223*t147+0.009565453333333*t14*t17*t101*
        t32*t448*t109)+t449+t444+t442+t439+t178+t177;
    d3fdragagb = t4*(0.003188484444444*t109*t14*t17*t35*(2.656434474616293*
        t21*t36*t80*(-1.390905838366201*t140*t39*t41*t74*t78*grada*
        gradb-5.563623353464805*t101*t112*t39*t76*grada*gradb+t694)-
        2.656434474616293*t36*t21*t77*t142*(-2.352214705976647*t36*
        t29*grada*gradb*t39*t41*t140*t145*t74+t693-4.704429411953293*
        t36*t29*grada*gradb*t39*t101*t112*t78)+5.312868949232586*t36*
        t21*t77*t167*t226*t333-2.656434474616293*t36*t21*t168*t142*
        t333-2.656434474616293*t36*t21*t167*t142*t330+5.312868949232586*
        t36*t21*t77*t173*t226*t312-2.656434474616293*t36*t21*t174*
        t142*t312-2.656434474616293*t36*t21*t173*t142*t309+6.24850423665579*
        t28*t453*grada*gradb*t39*t41*t77*t226*t78*t146-1.176107352988323*
        t36*t29*grada*gradb*t39*t41*t142*t76*t146-15.93860684769776*
        t36*t21*t77*t167*t173*t509*t146+5.312868949232586*t36*t21*
        t168*t173*t226*t146+5.312868949232586*t36*t21*t174*t167*t226*
        t146-3.124252118327895*t28*t453*grada*gradb*t39*t41*t142*t78*
        t141+5.312868949232586*t36*t21*t167*t173*t226*t141)+26.04166666666667*
        t101*t27*t3*t33*t36*t40*t440*t441*grada*gradb+26.04166666666667*
        t107*t111*t27*t3*t33*t36*t440*t441*grada*gradb-25.0*t107*t129*
        t27*t28*t30*t33*t35*grada*gradb-25.0*t101*t129*t27*t28*t30*
        t32*t33*grada*gradb-6.25*t129*t27*t28*t3*t30*t302*t33*t35*
        gradb-6.25*t129*t27*t28*t3*t30*t323*t33*t35*grada+t692+t691+
        t690+t689+0.009565453333333*t14*t17*t101*t32*t109*t454-0.003188484444444*
        t14*t17*t35*t169*t223*t334+grada*t5*t12*t27*t323*t33+gradb*
        t5*t12*t27*t302*t33-0.003188484444444*t14*t17*t35*t175*t223*
        t313-0.009565453333333*t14*t17*t101*t32*t169*t175*t223+0.006376968888889*
        t14*t17*t35*t169*t175*t508*t147-0.003188484444444*t14*t17*
        t35*t223*t454*t147)+t455+t452+t451+t450;
    d3fdragaab = t4*(0.003188484444444*t109*t14*t17*t35*(2.656434474616293*
        t21*t36*t80*(-1.390905838366201*t140*t39*t41*t74*t78*grada-
        5.563623353464805*t101*t112*t39*t76*grada+t700)-2.656434474616293*
        t36*t21*t77*t142*(-2.352214705976647*t36*t29*grada*t39*t41*
        t140*t145*t74+t699-4.704429411953293*t36*t29*grada*t39*t101*
        t112*t78)+5.312868949232586*t36*t21*t77*t167*t226*t361-2.656434474616293*
        t36*t21*t168*t142*t361-2.656434474616293*t36*t21*t167*t142*
        t354+5.312868949232586*t36*t21*t77*t181*t226*t312-2.656434474616293*
        t36*t21*t184*t142*t312-2.656434474616293*t36*t21*t181*t142*
        t309+6.24850423665579*t28*t453*grada*t39*t41*t77*t226*t78*
        t146-1.176107352988323*t36*t29*grada*t39*t41*t142*t76*t146-
        15.93860684769776*t36*t21*t77*t181*t167*t509*t146+5.312868949232586*
        t36*t21*t168*t181*t226*t146+5.312868949232586*t36*t21*t184*
        t167*t226*t146-3.124252118327895*t28*t453*grada*t39*t41*t142*
        t78*t141+5.312868949232586*t36*t21*t181*t167*t226*t141)+26.04166666666667*
        t101*t27*t3*t33*t36*t40*t440*t441*grada+26.04166666666667*
        t107*t111*t27*t3*t33*t36*t440*t441*grada-6.25*t129*t27*t28*
        t3*t30*t33*t344*t35*grada-25.0*t107*t129*t27*t28*t30*t33*t35*
        grada-25.0*t101*t129*t27*t28*t30*t32*t33*grada+t698+t697+t696+
        t695+0.009565453333333*t14*t17*t101*t32*t109*t461-0.003188484444444*
        t14*t17*t35*t169*t223*t362-6.25*t129*t27*t28*t3*t30*t302*t33*
        t35+grada*t5*t12*t27*t344*t33+t5*t12*t27*t302*t33-0.003188484444444*
        t14*t17*t35*t185*t223*t313-0.009565453333333*t14*t17*t101*
        t32*t185*t169*t223+0.006376968888889*t14*t17*t35*t185*t169*
        t508*t147-0.003188484444444*t14*t17*t35*t223*t461*t147)+t462+
        t458+t457+t456;
    d3fdragbgb = t4*(2.0*t12*t27*t323*t33*t5*gradb-12.5*t129*
        t27*t28*t3*t30*t323*t33*t35*gradb+0.003188484444444*t109*t14*
        t17*t35*(2.656434474616293*t21*t36*(-1.390905838366201*t140*
        t2*t39*t41*t74*t78-5.563623353464805*t101*t112*t2*t39*t76+
        t705+t353+t352+t351+t350+t349)*t80-2.656434474616293*t36*t21*
        t77*t142*(t360+t359-2.352214705976647*t36*t29*t2*t39*t41*t140*
        t145*t74+t358+t357+t356+t706+t355-4.704429411953293*t36*t29*
        t2*t39*t101*t112*t78)+10.62573789846517*t36*t21*t77*t173*t226*
        t333-5.312868949232586*t36*t21*t174*t142*t333-5.312868949232586*
        t36*t21*t173*t142*t330-15.93860684769776*t36*t21*t77*t467*
        t509*t146+5.312868949232586*t36*t21*t77*t468*t226*t146+10.62573789846517*
        t36*t21*t174*t173*t226*t146-2.656434474616293*t36*t21*t469*
        t142*t146+5.312868949232586*t36*t21*t467*t226*t141-2.656434474616293*
        t36*t21*t468*t142*t141)+t704+t703+t702+t701+26.04166666666667*
        t101*t2*t27*t3*t33*t36*t40*t440*t441+26.04166666666667*t107*
        t111*t2*t27*t3*t33*t36*t440*t441-25.0*t107*t129*t2*t27*t28*
        t30*t33*t35+t347+t346+t345+t342+t341+t340+t339+t338+t337-0.006376968888889*
        t14*t17*t35*t175*t223*t334-25.0*t101*t129*t2*t27*t28*t30*t32*
        t33-0.009565453333333*t14*t17*t101*t32*t465*t223+0.006376968888889*
        t14*t17*t35*t465*t508*t147-0.003188484444444*t14*t17*t35*t470*
        t223*t147+0.009565453333333*t14*t17*t101*t32*t470*t109)+t471+
        t466+t464+t463+t178+t177;
    d3fdragbab = t4*(0.003188484444444*t109*t14*t17*t35*(2.656434474616293*
        t21*t36*t80*(-1.390905838366201*t140*t39*t41*t74*t78*gradb-
        5.563623353464805*t101*t112*t39*t76*gradb+t712)-2.656434474616293*
        t36*t21*t77*t142*(-2.352214705976647*t36*t29*gradb*t39*t41*
        t140*t145*t74+t711-4.704429411953293*t36*t29*gradb*t39*t101*
        t112*t78)+5.312868949232586*t36*t21*t77*t173*t226*t361-2.656434474616293*
        t36*t21*t174*t142*t361-2.656434474616293*t36*t21*t173*t142*
        t354+5.312868949232586*t36*t21*t77*t181*t226*t333-2.656434474616293*
        t36*t21*t184*t142*t333-2.656434474616293*t36*t21*t181*t142*
        t330+6.24850423665579*t28*t453*gradb*t39*t41*t77*t226*t78*
        t146-1.176107352988323*t36*t29*gradb*t39*t41*t142*t76*t146-
        15.93860684769776*t36*t21*t77*t181*t173*t509*t146+5.312868949232586*
        t36*t21*t174*t181*t226*t146+5.312868949232586*t36*t21*t184*
        t173*t226*t146-3.124252118327895*t28*t453*gradb*t39*t41*t142*
        t78*t141+5.312868949232586*t36*t21*t181*t173*t226*t141)+26.04166666666667*
        t101*t27*t3*t33*t36*t40*t440*t441*gradb+26.04166666666667*
        t107*t111*t27*t3*t33*t36*t440*t441*gradb-6.25*t129*t27*t28*
        t3*t30*t33*t344*t35*gradb-25.0*t107*t129*t27*t28*t30*t33*t35*
        gradb-25.0*t101*t129*t27*t28*t30*t32*t33*gradb+t710+t709+t708+
        t707+0.009565453333333*t14*t17*t101*t32*t109*t477-0.003188484444444*
        t14*t17*t35*t175*t223*t362-6.25*t129*t27*t28*t3*t30*t323*t33*
        t35-0.003188484444444*t14*t17*t35*t185*t223*t334+gradb*t5*
        t12*t27*t344*t33+t5*t12*t27*t323*t33-0.009565453333333*t14*
        t17*t101*t32*t185*t175*t223+0.006376968888889*t14*t17*t35*
        t185*t175*t508*t147-0.003188484444444*t14*t17*t35*t223*t477*
        t147)+t478+t474+t473+t472;
    d3fdraabab = t4*(0.003188484444444*t109*t14*t17*t35*(2.656434474616293*
        t21*t36*(-1.390905838366201*t140*t39*t41*t74*t78-5.563623353464805*
        t101*t112*t39*t76+t718)*t80-2.656434474616293*t36*t21*t77*
        t142*(-2.352214705976647*t36*t29*t39*t41*t140*t145*t74+t717-
        4.704429411953293*t36*t29*t39*t101*t112*t78)+10.62573789846517*
        t36*t21*t77*t181*t226*t361-5.312868949232586*t36*t21*t184*
        t142*t361-5.312868949232586*t36*t21*t181*t142*t354+6.24850423665579*
        t28*t453*t39*t41*t77*t226*t78*t146-1.176107352988323*t36*t29*
        t39*t41*t142*t76*t146-15.93860684769776*t36*t21*t77*t483*t509*
        t146+10.62573789846517*t36*t21*t184*t181*t226*t146-3.124252118327895*
        t28*t453*t39*t41*t142*t78*t141+5.312868949232586*t36*t21*t483*
        t226*t141)+t716+t715+t714+t713+2.0*t12*t27*t33*t344*t5+0.009565453333333*
        t14*t17*t101*t32*t109*t486+26.04166666666667*t101*t27*t3*t33*
        t36*t40*t440*t441+26.04166666666667*t107*t111*t27*t3*t33*t36*
        t440*t441-0.006376968888889*t14*t17*t35*t185*t223*t362-12.5*
        t129*t27*t28*t3*t30*t33*t344*t35-25.0*t107*t129*t27*t28*t30*
        t33*t35-25.0*t101*t129*t27*t28*t30*t32*t33-0.009565453333333*
        t14*t17*t101*t32*t481*t223+0.006376968888889*t14*t17*t35*t481*
        t508*t147-0.003188484444444*t14*t17*t35*t223*t486*t147)+t487+
        t482+t480+t479;
    d3fdrbrbrb = t4*(1.5*t12*t3*t33*t379*t5*t90+1.5*t12*t3*
        t33*t374*t5*t90+1.5*t3*t33*t370*t5*t90+3.0*t152*t154*t3*t33*
        t5*t90-7.0*t103*t12*t154*t3*t33*t90-7.0*t103*t152*t3*t33*t90+
        0.019130906666667*t14*t17*t724*t82+0.009565453333333*t14*t17*
        t723*t32*t82+0.05739272*t14*t17*t370*t152*t12*t82+0.003188484444444*
        t109*t14*t17*t35*(2.656434474616293*t21*t36*(-0.173863229795775*
        t38*t39*t41*t727*t74*t78-0.173863229795775*t38*t39*t41*t725*
        t74*t78-0.521589689387325*t159*t38*t389*t39*t41*t74*t78+2.434085217140852*
        t113*t38*t389*t41*t74*t78+2.434085217140852*t113*t38*t385*
        t41*t74*t78-13.79314956379817*t159*t232*t38*t41*t74*t78+2.086358757549302*
        t112*t152*t38*t389*t39*t74*t78+2.086358757549302*t112*t152*
        t38*t385*t39*t74*t78-10.43179378774651*t159*t231*t373*t38*
        t39*t74*t78+2.086358757549302*t112*t159*t370*t38*t39*t74*t78-
        19.47268173712682*t112*t113*t152*t159*t38*t74*t78-20.86358757549302*
        t38*t39*t516*t724*t76-0.695452919183101*t112*t38*t39*t723*
        t76+10.43179378774651*t152*t231*t370*t38*t39*t76-48.68170434281704*
        t113*t231*t373*t38*t76+9.73634086856341*t112*t113*t370*t38*
        t76-55.17259825519266*t112*t152*t232*t38*t76-1.043179378774651*
        t278*t38*t39*t41*t513*t725+0.34772645959155*t145*t230*t38*
        t39*t41*t725-6.0*t112*t21*t3*t36*t5*t724-0.5*t21*t3*t36*t42*
        t5*t723+0.34772645959155*t145*t230*t38*t385*t39*t41*t597+t517+
        t511+4.5*t152*t21*t3*t36*t370*t41*t5+3.5*t103*t21*t3*t36*t370*
        t42-11.66666666666667*t152*t21*t211*t3*t36*t42+1.043179378774651*
        t145*t159*t230*t38*t389*t39*t41-4.868170434281705*t113*t145*
        t230*t38*t385*t41-10.5*t103*t21*t3*t36*t373*t41-4.172717515098603*
        t112*t145*t152*t230*t38*t385*t39)*t80-15.93860684769776*POW(t161,
        3.0)*t21*t36*t509*t77-2.656434474616293*t36*t21*t77*t142*(-
        0.664108618654073*t28*t16*t3*t5*t37*t725*t78*t74+4.648760330578512*
        t28*t16*t3*t103*t37*t385*t78*t74+3.98465171192444*t28*t16*
        t3*t5*t152*t42*t385*t78*t74-1.99232585596222*t28*t16*t3*t5*
        t37*t389*t159*t78*t74-15.49586776859504*t28*t16*t3*t211*t37*
        t159*t78*t74-18.59504132231405*t28*t16*t3*t103*t152*t42*t159*
        t78*t74+3.98465171192444*t28*t16*t3*t5*t370*t42*t159*t78*t74-
        11.95395513577332*t28*t16*t3*t5*t373*t41*t159*t78*t74+4.648760330578512*
        t28*t16*t3*t103*t37*t389*t78*t74+3.98465171192444*t28*t16*
        t3*t5*t152*t42*t389*t78*t74-0.664108618654073*t28*t16*t3*t5*
        t37*t727*t78*t74-0.294026838247081*t36*t29*t38*t39*t41*t725*
        t145*t74+4.116375735459131*t36*t29*t38*t113*t41*t385*t145*
        t74+3.52832205896497*t36*t29*t38*t39*t152*t112*t385*t145*t74-
        0.882080514741242*t36*t29*t38*t39*t41*t389*t159*t145*t74-23.32612916760175*
        t36*t29*t38*t232*t41*t159*t145*t74-32.93100588367305*t36*t29*
        t38*t113*t152*t112*t159*t145*t74+3.52832205896497*t36*t29*
        t38*t39*t370*t112*t159*t145*t74-17.64161029482485*t36*t29*
        t38*t39*t373*t231*t159*t145*t74+4.116375735459131*t36*t29*
        t38*t113*t41*t389*t145*t74+3.52832205896497*t36*t29*t38*t39*
        t152*t112*t389*t145*t74-0.294026838247081*t36*t29*t38*t39*
        t41*t727*t145*t74+t567-30.99173553719008*t28*t16*t3*t211*t152*
        t42*t76+9.297520661157025*t28*t16*t3*t103*t370*t42*t76-1.328217237308146*
        t28*t16*t3*t5*t723*t42*t76-27.89256198347108*t28*t16*t3*t103*
        t373*t41*t76+11.95395513577332*t28*t16*t3*t5*t370*t152*t41*
        t76-15.93860684769776*t28*t16*t3*t5*t724*t112*t76+t566-46.6522583352035*
        t36*t29*t38*t232*t152*t112*t78+8.232751470918263*t36*t29*t38*
        t113*t370*t112*t78-0.588053676494162*t36*t29*t38*t39*t723*
        t112*t78-41.16375735459132*t36*t29*t38*t113*t373*t231*t78+
        8.820805147412424*t36*t29*t38*t39*t370*t152*t231*t78-17.64161029482485*
        t36*t29*t38*t39*t724*t516*t78+1.328217237308146*t28*t16*t3*
        t5*t37*t385*t597*t230*t145+1.328217237308146*t28*t16*t3*t5*
        t37*t725*t230*t145-9.297520661157025*t28*t16*t3*t103*t37*t385*
        t230*t145-7.969303423848879*t28*t16*t3*t5*t152*t42*t385*t230*
        t145+3.98465171192444*t28*t16*t3*t5*t37*t389*t159*t230*t145+
        0.882080514741242*t36*t29*t38*t39*t41*t385*t597*t230*t278+
        0.882080514741242*t36*t29*t38*t39*t41*t725*t230*t278-12.34912720637739*
        t36*t29*t38*t113*t41*t385*t230*t278-10.58496617689491*t36*
        t29*t38*t39*t152*t112*t385*t230*t278+2.646241544223727*t36*
        t29*t38*t39*t41*t389*t159*t230*t278-3.98465171192444*t28*t16*
        t3*t5*t37*t725*t513*t278-3.52832205896497*t36*t29*t38*t39*
        t41*t725*t513*t565)+15.93860684769776*t36*t21*t77*t226*t161*
        t391-7.969303423848879*t36*t21*t142*t160*t391-7.969303423848879*
        t36*t21*t142*t161*t390+15.93860684769776*t36*t21*t226*t160*
        t384)+0.5*t12*t27*t3*t33*t5*(-12.5*t12*t28*t3*t30*t31*t723+
        t507-366.6666666666667*t12*t152*t28*t3*t30*t39+100.0*t105*
        t28*t3*t30*t373-37.5*t152*t28*t3*t30*t31*t370+100.0*t105*t12*
        t28*t3*t30*t370)+0.5*t27*t3*t33*t5*t723+0.006376968888889*
        t14*POW(t162,3.0)*t17*t35*t508+t506+1.5*t152*t27*t3*t33*t379*
        t5+1.5*t12*t154*t27*t3*t33*t374*t5+1.5*t152*t27*t3*t33*t374*
        t5+1.5*t154*t27*t3*t33*t370*t5+0.5*t12*POW(t154,3.0)*t27*t3*
        t33*t5+1.5*t12*t154*t194*t3*t33*t5+1.5*t152*t194*t3*t33*t5+
        t493+t492+t491-0.009565453333333*t14*t17*t35*t223*t162*t392+
        0.02869636*t14*t17*t152*t32*t109*t392-0.02869636*t14*t17*t152*
        t32*t223*t382-3.5*t103*t12*t27*t3*t33*t379-3.5*t103*t12*t27*
        t3*t33*t374-3.5*t103*t27*t3*t33*t370+11.66666666666667*t12*
        t154*t211*t27*t3*t33+11.66666666666667*t152*t211*t27*t3*t33-
        7.0*t103*t152*t154*t27*t3*t33+0.02869636*t14*t17*t370*t32*
        t109*t162+0.05739272*t14*t17*t373*t12*t109*t162)+3.0*t12*t154*
        t3*t33*t5*t90+3.0*t152*t3*t33*t5*t90+0.02869636*t14*t17*t370*
        t32*t82+0.05739272*t14*t17*t373*t12*t82+1.5*t12*t27*t3*t33*
        t379*t5+1.5*t12*t27*t3*t33*t374*t5+1.5*t27*t3*t33*t370*t5+
        3.0*t152*t154*t27*t3*t33*t5+t490+t489+t488+0.009565453333333*
        t14*t17*t35*t109*t392-0.009565453333333*t14*t17*t35*t223*t382-
        7.0*t103*t12*t154*t27*t3*t33-7.0*t103*t152*t27*t3*t33+0.05739272*
        t14*t17*t152*t32*t109*t162;
    d3fdrbrbga = t4*(0.003188484444444*t109*t14*t17*t35*(2.656434474616293*
        t21*t36*t80*(-0.695452919183101*t3*t389*t39*t41*t74*t78*grada-
        0.695452919183101*t3*t385*t39*t41*t74*t78*grada+6.490893912375606*
        t113*t159*t3*t41*t74*t78*grada+5.563623353464805*t112*t152*
        t159*t3*t39*t74*t78*grada+13.90905838366201*t231*t3*t373*t39*
        t76*grada-2.781811676732402*t112*t3*t370*t39*t76*grada+25.96357564950242*
        t112*t113*t152*t3*t76*grada-1.0*t21*t36*t370*t42*t5*grada+
        3.0*t21*t36*t373*t41*t5*grada+4.666666666666667*t103*t152*
        t21*t36*t42*grada+1.390905838366201*t145*t230*t3*t385*t39*
        t41*grada+t646+t645)-2.656434474616293*t36*t21*t77*t142*(-
        1.328217237308146*t28*t16*grada*t5*t37*t385*t78*t74+6.198347107438017*
        t28*t16*grada*t103*t37*t159*t78*t74+5.312868949232586*t28*
        t16*grada*t5*t152*t42*t159*t78*t74-1.328217237308146*t28*t16*
        grada*t5*t37*t389*t78*t74-1.176107352988323*t36*t29*grada*
        t3*t39*t41*t385*t145*t74+10.97700196122435*t36*t29*grada*t3*
        t113*t41*t159*t145*t74+9.408858823906586*t36*t29*grada*t3*
        t39*t152*t112*t159*t145*t74-1.176107352988323*t36*t29*grada*
        t3*t39*t41*t389*t145*t74+t648+12.39669421487603*t28*t16*grada*
        t103*t152*t42*t76-2.656434474616293*t28*t16*grada*t5*t370*
        t42*t76+7.969303423848879*t28*t16*grada*t5*t373*t41*t76+t647+
        21.9540039224487*t36*t29*grada*t3*t113*t152*t112*t78-2.352214705976647*
        t36*t29*grada*t3*t39*t370*t112*t78+11.76107352988323*t36*t29*
        grada*t3*t39*t373*t231*t78+2.656434474616293*t28*t16*grada*
        t5*t37*t385*t230*t145+3.52832205896497*t36*t29*grada*t3*t39*
        t41*t385*t230*t278)-5.312868949232586*t36*t21*t142*t160*t404+
        5.312868949232586*t36*t21*t77*t167*t226*t391-2.656434474616293*
        t36*t21*t168*t142*t391-2.656434474616293*t36*t21*t167*t142*
        t390-15.93860684769776*t36*t21*t77*t167*t509*t384+5.312868949232586*
        t36*t21*t168*t226*t384+10.62573789846517*t36*t21*t77*t226*
        t404*t161-5.312868949232586*t36*t21*t142*t403*t161+10.62573789846517*
        t36*t21*t167*t226*t160*t161)+0.5*t12*t27*t3*t33*t5*(-25.0*
        t28*t30*t31*t373*grada-25.0*t12*t28*t30*t31*t370*grada+133.3333333333333*
        t105*t12*t152*t28*t30*grada+t644)+2.0*t12*t154*t33*t5*t90*
        grada+2.0*t152*t33*t5*t90*grada-12.5*t129*t154*t28*t3*t30*
        t33*t35*t90*grada-12.5*t129*t152*t28*t3*t30*t32*t33*t90*grada+
        2.0*t152*t154*t27*t33*t5*grada-6.25*t129*t27*t28*t3*t30*t33*
        t35*t379*grada-6.25*t129*t27*t28*t3*t30*t33*t35*t374*grada-
        6.25*t129*t27*t28*t3*t30*t32*t33*t370*grada+29.16666666666667*
        t154*t260*t27*t28*t3*t30*t33*t35*grada+29.16666666666667*t152*
        t260*t27*t28*t3*t30*t32*t33*grada-12.5*t129*t152*t154*t27*
        t28*t3*t30*t32*t33*grada-4.666666666666667*t103*t12*t154*t27*
        t33*grada-4.666666666666667*t103*t152*t27*t33*grada+t643+t642+
        t641+t640+t639+t638+0.019130906666667*t14*t17*t152*t32*t109*
        t405-2.333333333333333*t103*t12*t27*t3*t33*t398-0.003188484444444*
        t14*t17*t35*t169*t223*t392+0.006376968888889*t14*t17*t35*t169*
        t508*t382+t3*t5*t12*t90*t398*t33+t3*t5*t152*t27*t398*t33+grada*
        t5*t12*t27*t379*t33+grada*t5*t12*t27*t374*t33+grada*t5*t370*
        t27*t33+t3*t5*t12*t27*t398*t154*t33-0.006376968888889*t14*
        t17*t35*t223*t405*t162-0.019130906666667*t14*t17*t152*t32*
        t169*t223*t162+0.009565453333333*t14*t17*t370*t32*t169*t109+
        0.019130906666667*t14*t17*t373*t12*t169*t109)+2.0*t12*t154*
        t27*t33*t5*grada+2.0*t152*t27*t33*t5*grada-12.5*t129*t154*
        t27*t28*t3*t30*t33*t35*grada-12.5*t129*t152*t27*t28*t3*t30*
        t32*t33*grada+t637+t636+t635+t634+0.006376968888889*t14*t17*
        t35*t109*t405+t3*t5*t12*t27*t398*t33-0.006376968888889*t14*
        t17*t35*t169*t223*t162+0.019130906666667*t14*t17*t152*t32*
        t169*t109;
    d3fdrbrbgb = t4*(0.003188484444444*t109*t14*t17*t35*(2.656434474616293*
        t21*t36*t80*(-0.695452919183101*t3*t389*t39*t41*t74*t78*gradb-
        0.695452919183101*t3*t385*t39*t41*t74*t78*gradb+6.490893912375606*
        t113*t159*t3*t41*t74*t78*gradb+5.563623353464805*t112*t152*
        t159*t3*t39*t74*t78*gradb+13.90905838366201*t231*t3*t373*t39*
        t76*gradb-2.781811676732402*t112*t3*t370*t39*t76*gradb+25.96357564950242*
        t112*t113*t152*t3*t76*gradb-1.0*t21*t36*t370*t42*t5*gradb+
        3.0*t21*t36*t373*t41*t5*gradb+4.666666666666667*t103*t152*
        t21*t36*t42*gradb+1.390905838366201*t145*t230*t3*t385*t39*
        t41*gradb+t661+t660)-2.656434474616293*t36*t21*t77*t142*(-
        1.328217237308146*t28*t16*gradb*t5*t37*t385*t78*t74+6.198347107438017*
        t28*t16*gradb*t103*t37*t159*t78*t74+5.312868949232586*t28*
        t16*gradb*t5*t152*t42*t159*t78*t74-1.328217237308146*t28*t16*
        gradb*t5*t37*t389*t78*t74-1.176107352988323*t36*t29*gradb*
        t3*t39*t41*t385*t145*t74+10.97700196122435*t36*t29*gradb*t3*
        t113*t41*t159*t145*t74+9.408858823906586*t36*t29*gradb*t3*
        t39*t152*t112*t159*t145*t74-1.176107352988323*t36*t29*gradb*
        t3*t39*t41*t389*t145*t74+t663+12.39669421487603*t28*t16*gradb*
        t103*t152*t42*t76-2.656434474616293*t28*t16*gradb*t5*t370*
        t42*t76+7.969303423848879*t28*t16*gradb*t5*t373*t41*t76+t662+
        21.9540039224487*t36*t29*gradb*t3*t113*t152*t112*t78-2.352214705976647*
        t36*t29*gradb*t3*t39*t370*t112*t78+11.76107352988323*t36*t29*
        gradb*t3*t39*t373*t231*t78+2.656434474616293*t28*t16*gradb*
        t5*t37*t385*t230*t145+3.52832205896497*t36*t29*gradb*t3*t39*
        t41*t385*t230*t278)-5.312868949232586*t36*t21*t142*t160*t416+
        5.312868949232586*t36*t21*t77*t173*t226*t391-2.656434474616293*
        t36*t21*t174*t142*t391-2.656434474616293*t36*t21*t173*t142*
        t390-15.93860684769776*t36*t21*t77*t173*t509*t384+5.312868949232586*
        t36*t21*t174*t226*t384+10.62573789846517*t36*t21*t77*t226*
        t416*t161-5.312868949232586*t36*t21*t142*t415*t161+10.62573789846517*
        t36*t21*t173*t226*t160*t161)+0.5*t12*t27*t3*t33*t5*(-25.0*
        t28*t30*t31*t373*gradb-25.0*t12*t28*t30*t31*t370*gradb+133.3333333333333*
        t105*t12*t152*t28*t30*gradb+t659)+2.0*t12*t154*t33*t5*t90*
        gradb+2.0*t152*t33*t5*t90*gradb-12.5*t129*t154*t28*t3*t30*
        t33*t35*t90*gradb-12.5*t129*t152*t28*t3*t30*t32*t33*t90*gradb+
        2.0*t152*t154*t27*t33*t5*gradb-6.25*t129*t27*t28*t3*t30*t33*
        t35*t379*gradb-6.25*t129*t27*t28*t3*t30*t33*t35*t374*gradb-
        6.25*t129*t27*t28*t3*t30*t32*t33*t370*gradb+29.16666666666667*
        t154*t260*t27*t28*t3*t30*t33*t35*gradb+29.16666666666667*t152*
        t260*t27*t28*t3*t30*t32*t33*gradb-12.5*t129*t152*t154*t27*
        t28*t3*t30*t32*t33*gradb-4.666666666666667*t103*t12*t154*t27*
        t33*gradb-4.666666666666667*t103*t152*t27*t33*gradb+t658+t657+
        t656+t655+t654+t653+0.019130906666667*t14*t17*t152*t32*t109*
        t417-2.333333333333333*t103*t12*t27*t3*t33*t410-0.003188484444444*
        t14*t17*t35*t175*t223*t392+0.006376968888889*t14*t17*t35*t175*
        t508*t382+t3*t5*t12*t90*t410*t33+t3*t5*t152*t27*t410*t33+gradb*
        t5*t12*t27*t379*t33+gradb*t5*t12*t27*t374*t33+gradb*t5*t370*
        t27*t33+t3*t5*t12*t27*t410*t154*t33-0.006376968888889*t14*
        t17*t35*t223*t417*t162-0.019130906666667*t14*t17*t152*t32*
        t175*t223*t162+0.009565453333333*t14*t17*t370*t32*t175*t109+
        0.019130906666667*t14*t17*t373*t12*t175*t109)+2.0*t12*t154*
        t27*t33*t5*gradb+2.0*t152*t27*t33*t5*gradb-12.5*t129*t154*
        t27*t28*t3*t30*t33*t35*gradb-12.5*t129*t152*t27*t28*t3*t30*
        t32*t33*gradb+t652+t651+t650+t649+0.006376968888889*t14*t17*
        t35*t109*t417+t3*t5*t12*t27*t410*t33-0.006376968888889*t14*
        t17*t35*t175*t223*t162+0.019130906666667*t14*t17*t152*t32*
        t175*t109;
    d3fdrbrbab = t4*(2.0*t12*t154*t33*t5*t90+2.0*t152*t33*
        t5*t90-12.5*t129*t154*t28*t3*t30*t33*t35*t90-12.5*t129*t152*
        t28*t3*t30*t32*t33*t90+0.003188484444444*t109*t14*t17*t35*
        (2.656434474616293*t21*t36*(-0.695452919183101*t3*t389*t39*
        t41*t74*t78-0.695452919183101*t3*t385*t39*t41*t74*t78+6.490893912375606*
        t113*t159*t3*t41*t74*t78+5.563623353464805*t112*t152*t159*
        t3*t39*t74*t78+13.90905838366201*t231*t3*t373*t39*t76-2.781811676732402*
        t112*t3*t370*t39*t76+25.96357564950242*t112*t113*t152*t3*t76+
        t676+t675-1.0*t21*t36*t370*t42*t5+3.0*t21*t36*t373*t41*t5+
        4.666666666666667*t103*t152*t21*t36*t42+1.390905838366201*
        t145*t230*t3*t385*t39*t41)*t80-2.656434474616293*t36*t21*t77*
        t142*(-1.328217237308146*t28*t16*t5*t37*t385*t78*t74+6.198347107438017*
        t28*t16*t103*t37*t159*t78*t74+5.312868949232586*t28*t16*t5*
        t152*t42*t159*t78*t74-1.328217237308146*t28*t16*t5*t37*t389*
        t78*t74-1.176107352988323*t36*t29*t3*t39*t41*t385*t145*t74+
        10.97700196122435*t36*t29*t3*t113*t41*t159*t145*t74+9.408858823906586*
        t36*t29*t3*t39*t152*t112*t159*t145*t74-1.176107352988323*t36*
        t29*t3*t39*t41*t389*t145*t74+t678+12.39669421487603*t28*t16*
        t103*t152*t42*t76-2.656434474616293*t28*t16*t5*t370*t42*t76+
        7.969303423848879*t28*t16*t5*t373*t41*t76+t677+21.9540039224487*
        t36*t29*t3*t113*t152*t112*t78-2.352214705976647*t36*t29*t3*
        t39*t370*t112*t78+11.76107352988323*t36*t29*t3*t39*t373*t231*
        t78+2.656434474616293*t28*t16*t5*t37*t385*t230*t145+3.52832205896497*
        t36*t29*t3*t39*t41*t385*t230*t278)-5.312868949232586*t36*t21*
        t142*t160*t435+5.312868949232586*t36*t21*t77*t181*t226*t391-
        2.656434474616293*t36*t21*t184*t142*t391-2.656434474616293*
        t36*t21*t181*t142*t390-15.93860684769776*t36*t21*t77*t181*
        t509*t384+5.312868949232586*t36*t21*t184*t226*t384+10.62573789846517*
        t36*t21*t77*t226*t435*t161-5.312868949232586*t36*t21*t142*
        t430*t161+10.62573789846517*t36*t21*t181*t226*t160*t161)+0.5*
        t12*t27*t3*t33*t5*(t674-25.0*t28*t30*t31*t373-25.0*t12*t28*
        t30*t31*t370+133.3333333333333*t105*t12*t152*t28*t30)+t673+
        t672+t671+t670+t669+t668+2.0*t152*t154*t27*t33*t5+0.019130906666667*
        t14*t17*t152*t32*t109*t436-2.333333333333333*t103*t12*t27*
        t3*t33*t422-0.003188484444444*t14*t17*t35*t185*t223*t392+0.006376968888889*
        t14*t17*t35*t185*t508*t382-6.25*t129*t27*t28*t3*t30*t33*t35*
        t379-6.25*t129*t27*t28*t3*t30*t33*t35*t374-6.25*t129*t27*t28*
        t3*t30*t32*t33*t370+29.16666666666667*t154*t260*t27*t28*t3*
        t30*t33*t35+t3*t5*t12*t90*t422*t33+t3*t5*t152*t27*t422*t33+
        t5*t12*t27*t379*t33+t5*t12*t27*t374*t33+29.16666666666667*
        t152*t260*t27*t28*t3*t30*t32*t33-12.5*t129*t152*t154*t27*t28*
        t3*t30*t32*t33+t5*t370*t27*t33-4.666666666666667*t103*t12*
        t154*t27*t33-4.666666666666667*t103*t152*t27*t33+t3*t5*t12*
        t27*t422*t154*t33-0.006376968888889*t14*t17*t35*t223*t436*
        t162-0.019130906666667*t14*t17*t152*t32*t185*t223*t162+0.009565453333333*
        t14*t17*t370*t32*t185*t109+0.019130906666667*t14*t17*t373*
        t12*t185*t109)+t667+t666+t665+t664+2.0*t12*t154*t27*t33*t5+
        2.0*t152*t27*t33*t5+0.006376968888889*t14*t17*t35*t109*t436-
        12.5*t129*t154*t27*t28*t3*t30*t33*t35+t3*t5*t12*t27*t422*t33-
        12.5*t129*t152*t27*t28*t3*t30*t32*t33-0.006376968888889*t14*
        t17*t35*t185*t223*t162+0.019130906666667*t14*t17*t152*t32*
        t185*t109;
    d3fdrbgaga = t4*(2.0*t12*t27*t33*t398*t5*grada-12.5*t129*
        t27*t28*t3*t30*t33*t35*t398*grada+0.003188484444444*t109*t14*
        t17*t35*(2.656434474616293*t21*t36*(-1.390905838366201*t1*
        t159*t39*t41*t74*t78-5.563623353464805*t1*t112*t152*t39*t76+
        t687+t429+t428+t427+t352+t350)*t80-2.656434474616293*t36*t21*
        t77*t142*(t434+t433-2.352214705976647*t36*t29*t1*t39*t41*t159*
        t145*t74+t358+t432+t356+t688+t431-4.704429411953293*t36*t29*
        t1*t39*t152*t112*t78)+10.62573789846517*t36*t21*t77*t167*t226*
        t404-5.312868949232586*t36*t21*t168*t142*t404-5.312868949232586*
        t36*t21*t167*t142*t403-15.93860684769776*t36*t21*t77*t445*
        t509*t161+5.312868949232586*t36*t21*t77*t446*t226*t161+10.62573789846517*
        t36*t21*t168*t167*t226*t161-2.656434474616293*t36*t21*t447*
        t142*t161+5.312868949232586*t36*t21*t445*t226*t160-2.656434474616293*
        t36*t21*t446*t142*t160)+t686+t684+t683+t682+26.04166666666667*
        t1*t152*t27*t3*t33*t36*t40*t440*t441+26.04166666666667*t1*
        t111*t154*t27*t3*t33*t36*t440*t441+t425+t424+t423+t421+t420-
        0.006376968888889*t14*t17*t35*t169*t223*t405-25.0*t1*t129*
        t154*t27*t28*t30*t33*t35+t342+t340+t338+t337-25.0*t1*t129*
        t152*t27*t28*t30*t32*t33-0.009565453333333*t14*t17*t152*t32*
        t443*t223+0.006376968888889*t14*t17*t35*t443*t508*t162-0.003188484444444*
        t14*t17*t35*t448*t223*t162+0.009565453333333*t14*t17*t152*
        t32*t448*t109)+t449+t444+t442+t439+t178+t177;
    d3fdrbgagb = t4*(0.003188484444444*t109*t14*t17*t35*(2.656434474616293*
        t21*t36*t80*(-1.390905838366201*t159*t39*t41*t74*t78*grada*
        gradb-5.563623353464805*t112*t152*t39*t76*grada*gradb+t694)-
        2.656434474616293*t36*t21*t77*t142*(-2.352214705976647*t36*
        t29*grada*gradb*t39*t41*t159*t145*t74+t693-4.704429411953293*
        t36*t29*grada*gradb*t39*t152*t112*t78)+5.312868949232586*t36*
        t21*t77*t167*t226*t416-2.656434474616293*t36*t21*t168*t142*
        t416-2.656434474616293*t36*t21*t167*t142*t415+5.312868949232586*
        t36*t21*t77*t173*t226*t404-2.656434474616293*t36*t21*t174*
        t142*t404-2.656434474616293*t36*t21*t173*t142*t403+6.24850423665579*
        t28*t453*grada*gradb*t39*t41*t77*t226*t78*t161-1.176107352988323*
        t36*t29*grada*gradb*t39*t41*t142*t76*t161-15.93860684769776*
        t36*t21*t77*t167*t173*t509*t161+5.312868949232586*t36*t21*
        t168*t173*t226*t161+5.312868949232586*t36*t21*t174*t167*t226*
        t161-3.124252118327895*t28*t453*grada*gradb*t39*t41*t142*t78*
        t160+5.312868949232586*t36*t21*t167*t173*t226*t160)+26.04166666666667*
        t152*t27*t3*t33*t36*t40*t440*t441*grada*gradb+26.04166666666667*
        t111*t154*t27*t3*t33*t36*t440*t441*grada*gradb-25.0*t129*t154*
        t27*t28*t30*t33*t35*grada*gradb-25.0*t129*t152*t27*t28*t30*
        t32*t33*grada*gradb-6.25*t129*t27*t28*t3*t30*t33*t35*t398*
        gradb-6.25*t129*t27*t28*t3*t30*t33*t35*t410*grada+t692+t691+
        t690+t689+0.009565453333333*t14*t17*t152*t32*t109*t454-0.003188484444444*
        t14*t17*t35*t169*t223*t417-0.003188484444444*t14*t17*t35*t175*
        t223*t405+grada*t5*t12*t27*t410*t33+gradb*t5*t12*t27*t398*
        t33-0.009565453333333*t14*t17*t152*t32*t169*t175*t223+0.006376968888889*
        t14*t17*t35*t169*t175*t508*t162-0.003188484444444*t14*t17*
        t35*t223*t454*t162)+t455+t452+t451+t450;
    d3fdrbgaab = t4*(0.003188484444444*t109*t14*t17*t35*(2.656434474616293*
        t21*t36*t80*(-1.390905838366201*t159*t39*t41*t74*t78*grada-
        5.563623353464805*t112*t152*t39*t76*grada+t700)-2.656434474616293*
        t36*t21*t77*t142*(-2.352214705976647*t36*t29*grada*t39*t41*
        t159*t145*t74+t699-4.704429411953293*t36*t29*grada*t39*t152*
        t112*t78)+5.312868949232586*t36*t21*t77*t167*t226*t435-2.656434474616293*
        t36*t21*t168*t142*t435-2.656434474616293*t36*t21*t167*t142*
        t430+5.312868949232586*t36*t21*t77*t181*t226*t404-2.656434474616293*
        t36*t21*t184*t142*t404-2.656434474616293*t36*t21*t181*t142*
        t403+6.24850423665579*t28*t453*grada*t39*t41*t77*t226*t78*
        t161-1.176107352988323*t36*t29*grada*t39*t41*t142*t76*t161-
        15.93860684769776*t36*t21*t77*t181*t167*t509*t161+5.312868949232586*
        t36*t21*t168*t181*t226*t161+5.312868949232586*t36*t21*t184*
        t167*t226*t161-3.124252118327895*t28*t453*grada*t39*t41*t142*
        t78*t160+5.312868949232586*t36*t21*t181*t167*t226*t160)+26.04166666666667*
        t152*t27*t3*t33*t36*t40*t440*t441*grada+26.04166666666667*
        t111*t154*t27*t3*t33*t36*t440*t441*grada-6.25*t129*t27*t28*
        t3*t30*t33*t35*t422*grada-25.0*t129*t154*t27*t28*t30*t33*t35*
        grada-25.0*t129*t152*t27*t28*t30*t32*t33*grada+t698+t697+t696+
        t695+0.009565453333333*t14*t17*t152*t32*t109*t461-0.003188484444444*
        t14*t17*t35*t169*t223*t436-0.003188484444444*t14*t17*t35*t185*
        t223*t405-6.25*t129*t27*t28*t3*t30*t33*t35*t398+grada*t5*t12*
        t27*t422*t33+t5*t12*t27*t398*t33-0.009565453333333*t14*t17*
        t152*t32*t185*t169*t223+0.006376968888889*t14*t17*t35*t185*
        t169*t508*t162-0.003188484444444*t14*t17*t35*t223*t461*t162)+
        t462+t458+t457+t456;
    d3fdrbgbgb = t4*(2.0*t12*t27*t33*t410*t5*gradb-12.5*t129*
        t27*t28*t3*t30*t33*t35*t410*gradb+0.003188484444444*t109*t14*
        t17*t35*(2.656434474616293*t21*t36*(-1.390905838366201*t159*
        t2*t39*t41*t74*t78-5.563623353464805*t112*t152*t2*t39*t76+
        t705+t429+t428+t427+t352+t350)*t80-2.656434474616293*t36*t21*
        t77*t142*(t434+t433-2.352214705976647*t36*t29*t2*t39*t41*t159*
        t145*t74+t358+t432+t356+t706+t431-4.704429411953293*t36*t29*
        t2*t39*t152*t112*t78)+10.62573789846517*t36*t21*t77*t173*t226*
        t416-5.312868949232586*t36*t21*t174*t142*t416-5.312868949232586*
        t36*t21*t173*t142*t415-15.93860684769776*t36*t21*t77*t467*
        t509*t161+5.312868949232586*t36*t21*t77*t468*t226*t161+10.62573789846517*
        t36*t21*t174*t173*t226*t161-2.656434474616293*t36*t21*t469*
        t142*t161+5.312868949232586*t36*t21*t467*t226*t160-2.656434474616293*
        t36*t21*t468*t142*t160)+t704+t703+t702+t701+26.04166666666667*
        t152*t2*t27*t3*t33*t36*t40*t440*t441+26.04166666666667*t111*
        t154*t2*t27*t3*t33*t36*t440*t441+t425+t424+t423+t421+t420-
        0.006376968888889*t14*t17*t35*t175*t223*t417-25.0*t129*t154*
        t2*t27*t28*t30*t33*t35+t342+t340+t338+t337-25.0*t129*t152*
        t2*t27*t28*t30*t32*t33-0.009565453333333*t14*t17*t152*t32*
        t465*t223+0.006376968888889*t14*t17*t35*t465*t508*t162-0.003188484444444*
        t14*t17*t35*t470*t223*t162+0.009565453333333*t14*t17*t152*
        t32*t470*t109)+t471+t466+t464+t463+t178+t177;
    d3fdrbgbab = t4*(0.003188484444444*t109*t14*t17*t35*(2.656434474616293*
        t21*t36*t80*(-1.390905838366201*t159*t39*t41*t74*t78*gradb-
        5.563623353464805*t112*t152*t39*t76*gradb+t712)-2.656434474616293*
        t36*t21*t77*t142*(-2.352214705976647*t36*t29*gradb*t39*t41*
        t159*t145*t74+t711-4.704429411953293*t36*t29*gradb*t39*t152*
        t112*t78)+5.312868949232586*t36*t21*t77*t173*t226*t435-2.656434474616293*
        t36*t21*t174*t142*t435-2.656434474616293*t36*t21*t173*t142*
        t430+5.312868949232586*t36*t21*t77*t181*t226*t416-2.656434474616293*
        t36*t21*t184*t142*t416-2.656434474616293*t36*t21*t181*t142*
        t415+6.24850423665579*t28*t453*gradb*t39*t41*t77*t226*t78*
        t161-1.176107352988323*t36*t29*gradb*t39*t41*t142*t76*t161-
        15.93860684769776*t36*t21*t77*t181*t173*t509*t161+5.312868949232586*
        t36*t21*t174*t181*t226*t161+5.312868949232586*t36*t21*t184*
        t173*t226*t161-3.124252118327895*t28*t453*gradb*t39*t41*t142*
        t78*t160+5.312868949232586*t36*t21*t181*t173*t226*t160)+26.04166666666667*
        t152*t27*t3*t33*t36*t40*t440*t441*gradb+26.04166666666667*
        t111*t154*t27*t3*t33*t36*t440*t441*gradb-6.25*t129*t27*t28*
        t3*t30*t33*t35*t422*gradb-25.0*t129*t154*t27*t28*t30*t33*t35*
        gradb-25.0*t129*t152*t27*t28*t30*t32*t33*gradb+t710+t709+t708+
        t707+0.009565453333333*t14*t17*t152*t32*t109*t477-0.003188484444444*
        t14*t17*t35*t175*t223*t436-0.003188484444444*t14*t17*t35*t185*
        t223*t417-6.25*t129*t27*t28*t3*t30*t33*t35*t410+gradb*t5*t12*
        t27*t422*t33+t5*t12*t27*t410*t33-0.009565453333333*t14*t17*
        t152*t32*t185*t175*t223+0.006376968888889*t14*t17*t35*t185*
        t175*t508*t162-0.003188484444444*t14*t17*t35*t223*t477*t162)+
        t478+t474+t473+t472;
    d3fdrbabab = t4*(0.003188484444444*t109*t14*t17*t35*(2.656434474616293*
        t21*t36*(-1.390905838366201*t159*t39*t41*t74*t78-5.563623353464805*
        t112*t152*t39*t76+t718)*t80-2.656434474616293*t36*t21*t77*
        t142*(-2.352214705976647*t36*t29*t39*t41*t159*t145*t74+t717-
        4.704429411953293*t36*t29*t39*t152*t112*t78)+10.62573789846517*
        t36*t21*t77*t181*t226*t435-5.312868949232586*t36*t21*t184*
        t142*t435-5.312868949232586*t36*t21*t181*t142*t430+6.24850423665579*
        t28*t453*t39*t41*t77*t226*t78*t161-1.176107352988323*t36*t29*
        t39*t41*t142*t76*t161-15.93860684769776*t36*t21*t77*t483*t509*
        t161+10.62573789846517*t36*t21*t184*t181*t226*t161-3.124252118327895*
        t28*t453*t39*t41*t142*t78*t160+5.312868949232586*t36*t21*t483*
        t226*t160)+t716+t715+t714+t713+2.0*t12*t27*t33*t422*t5+0.009565453333333*
        t14*t17*t152*t32*t109*t486+26.04166666666667*t152*t27*t3*t33*
        t36*t40*t440*t441+26.04166666666667*t111*t154*t27*t3*t33*t36*
        t440*t441-0.006376968888889*t14*t17*t35*t185*t223*t436-12.5*
        t129*t27*t28*t3*t30*t33*t35*t422-25.0*t129*t154*t27*t28*t30*
        t33*t35-25.0*t129*t152*t27*t28*t30*t32*t33-0.009565453333333*
        t14*t17*t152*t32*t481*t223+0.006376968888889*t14*t17*t35*t481*
        t508*t162-0.003188484444444*t14*t17*t35*t223*t486*t162)+t487+
        t482+t480+t479;
    d3fdgagaga = t4*(78.125*t111*t27*t3*t33*t36*t440*t441*
        grada-75.0*t129*t27*t28*t30*t33*t35*grada+0.003188484444444*
        t109*t14*t17*t35*(-9.372756354983688*t28*t453*grada*t39*t41*
        t77*t142*t78-15.93860684769776*POW(t167,3.0)*t21*t36*t509*
        t77+3.52832205896497*t36*t29*grada*t39*t41*t80*t76+15.93860684769776*
        t36*t21*t168*t445*t226+15.93860684769776*t36*t21*t77*t446*
        t167*t226-7.969303423848879*t36*t21*t168*t446*t142-7.969303423848879*
        t36*t21*t447*t167*t142)-108.5069444444444*t27*t3*t33*t515*
        t728*t729*t730+156.25*t111*t27*t33*t36*t440*t441*t728+0.006376968888889*
        t14*POW(t169,3.0)*t17*t35*t508-0.009565453333333*t14*t17*t35*
        t448*t169*t223);
    d3fdgagagb = t4*(-108.5069444444444*t1*t27*t3*t33*t515*
        t729*t730*gradb+156.25*t1*t111*t27*t33*t36*t440*t441*gradb+
        0.006376968888889*t14*t17*t35*t443*t175*t508+0.003188484444444*
        t14*t17*t35*t109*(t476-2.352214705976647*t36*t29*grada*gradb*
        t39*t41*t167*t142*t76+t475-6.24850423665579*t28*t453*grada*
        gradb*t39*t41*t168*t142*t78+12.49700847331158*t28*t453*grada*
        gradb*t39*t41*t77*t167*t226*t78-2.656434474616293*t36*t21*
        t447*t173*t142-2.656434474616293*t36*t21*t174*t446*t142+10.62573789846517*
        t36*t21*t168*t167*t173*t226+5.312868949232586*t36*t21*t77*
        t446*t173*t226+5.312868949232586*t36*t21*t174*t445*t226-15.93860684769776*
        t36*t21*t77*t445*t173*t509)+t473+t472-0.006376968888889*t14*
        t17*t35*t169*t223*t454-0.003188484444444*t14*t17*t35*t448*
        t175*t223);
    d3fdgagaab = t4*(-108.5069444444444*t1*t27*t3*t33*t515*
        t729*t730+0.006376968888889*t14*t17*t35*t185*t443*t508+0.003188484444444*
        t14*t17*t35*t109*(t485-2.352214705976647*t36*t29*grada*t39*
        t41*t167*t142*t76+t484-6.24850423665579*t28*t453*grada*t39*
        t41*t168*t142*t78+12.49700847331158*t28*t453*grada*t39*t41*
        t77*t167*t226*t78-2.656434474616293*t36*t21*t184*t446*t142-
        2.656434474616293*t36*t21*t447*t181*t142+5.312868949232586*
        t36*t21*t184*t445*t226+10.62573789846517*t36*t21*t168*t181*
        t167*t226+5.312868949232586*t36*t21*t77*t181*t446*t226-15.93860684769776*
        t36*t21*t77*t181*t445*t509)+t480+t479-0.006376968888889*t14*
        t17*t35*t169*t223*t461+156.25*t1*t111*t27*t33*t36*t440*t441-
        0.003188484444444*t14*t17*t35*t185*t448*t223);
    d3fdgagbgb = t4*(-108.5069444444444*t2*t27*t3*t33*t515*
        t729*t730*grada+156.25*t111*t2*t27*t33*t36*t440*t441*grada+
        0.006376968888889*t14*t17*t35*t169*t465*t508+0.003188484444444*
        t14*t17*t35*t109*(t460-2.352214705976647*t36*t29*grada*gradb*
        t39*t41*t173*t142*t76+t459-6.24850423665579*t28*t453*grada*
        gradb*t39*t41*t174*t142*t78+12.49700847331158*t28*t453*grada*
        gradb*t39*t41*t77*t173*t226*t78-2.656434474616293*t36*t21*
        t469*t167*t142-2.656434474616293*t36*t21*t168*t468*t142+5.312868949232586*
        t36*t21*t168*t467*t226+10.62573789846517*t36*t21*t174*t167*
        t173*t226+5.312868949232586*t36*t21*t77*t468*t167*t226-15.93860684769776*
        t36*t21*t77*t167*t467*t509)+t457+t456-0.006376968888889*t14*
        t17*t35*t175*t223*t454-0.003188484444444*t14*t17*t35*t470*
        t169*t223);
    d3fdgagbab = t4*(-108.5069444444444*t27*t3*t33*t515*t729*
        t730*grada*gradb+156.25*t111*t27*t33*t36*t440*t441*grada*gradb+
        0.003188484444444*t14*t17*t35*t109*(-1.176107352988323*t36*
        t29*grada*t39*t41*t173*t142*t76-1.176107352988323*t36*t29*
        gradb*t39*t41*t167*t142*t76-1.176107352988323*t36*t29*grada*
        gradb*t39*t41*t181*t142*t76-3.124252118327895*t28*t453*grada*
        t39*t41*t174*t142*t78-3.124252118327895*t28*t453*gradb*t39*
        t41*t168*t142*t78-3.124252118327895*t28*t453*grada*gradb*t39*
        t41*t184*t142*t78+6.24850423665579*t28*t453*grada*t39*t41*
        t77*t173*t226*t78+6.24850423665579*t28*t453*gradb*t39*t41*
        t77*t167*t226*t78+6.24850423665579*t28*t453*grada*gradb*t39*
        t41*t77*t181*t226*t78+5.312868949232586*t36*t21*t184*t167*
        t173*t226+5.312868949232586*t36*t21*t168*t181*t173*t226+5.312868949232586*
        t36*t21*t174*t181*t167*t226-15.93860684769776*t36*t21*t77*
        t181*t167*t173*t509)+0.006376968888889*t14*t17*t35*t185*t169*
        t175*t508-0.003188484444444*t14*t17*t35*t169*t223*t477-0.003188484444444*
        t14*t17*t35*t175*t223*t461-0.003188484444444*t14*t17*t35*t185*
        t223*t454);
    d3fdgaabab = t4*(-108.5069444444444*t27*t3*t33*t515*t729*
        t730*grada+156.25*t111*t27*t33*t36*t440*t441*grada+0.003188484444444*
        t14*t17*t35*t109*(-1.176107352988323*t36*t29*t39*t41*t167*
        t142*t76-2.352214705976647*t36*t29*grada*t39*t41*t181*t142*
        t76-3.124252118327895*t28*t453*t39*t41*t168*t142*t78-6.24850423665579*
        t28*t453*grada*t39*t41*t184*t142*t78+6.24850423665579*t28*
        t453*t39*t41*t77*t167*t226*t78+12.49700847331158*t28*t453*
        grada*t39*t41*t77*t181*t226*t78+10.62573789846517*t36*t21*
        t184*t181*t167*t226+5.312868949232586*t36*t21*t168*t483*t226-
        15.93860684769776*t36*t21*t77*t483*t167*t509)+0.006376968888889*
        t14*t17*t35*t481*t169*t508-0.003188484444444*t14*t17*t35*t169*
        t223*t486-0.006376968888889*t14*t17*t35*t185*t223*t461);
    d3fdgbgbgb = t4*
        (78.125*t111*t27*t3*t33*t36*t440*t441*gradb-75.0*t129*t27*
        t28*t30*t33*t35*gradb+0.003188484444444*t109*t14*t17*t35*(-
        9.372756354983688*t28*t453*gradb*t39*t41*t77*t142*t78-15.93860684769776*
        POW(t173,3.0)*t21*t36*t509*t77+3.52832205896497*t36*t29*gradb*
        t39*t41*t80*t76+15.93860684769776*t36*t21*t174*t467*t226+15.93860684769776*
        t36*t21*t77*t468*t173*t226-7.969303423848879*t36*t21*t174*
        t468*t142-7.969303423848879*t36*t21*t469*t173*t142)-108.5069444444444*
        t27*t3*t33*t515*t729*t730*t731+156.25*t111*t27*t33*t36*t440*
        t441*t731+0.006376968888889*t14*t17*POW(t175,3.0)*t35*t508-
        0.009565453333333*t14*t17*t35*t470*t175*t223);
    d3fdgbgbab = t4*(-108.5069444444444*t2*t27*t3*t33*t515*
        t729*t730+0.006376968888889*t14*t17*t35*t185*t465*t508+0.003188484444444*
        t14*t17*t35*t109*(t485-2.352214705976647*t36*t29*gradb*t39*
        t41*t173*t142*t76+t484-6.24850423665579*t28*t453*gradb*t39*
        t41*t174*t142*t78+12.49700847331158*t28*t453*gradb*t39*t41*
        t77*t173*t226*t78-2.656434474616293*t36*t21*t184*t468*t142-
        2.656434474616293*t36*t21*t469*t181*t142+5.312868949232586*
        t36*t21*t184*t467*t226+10.62573789846517*t36*t21*t174*t181*
        t173*t226+5.312868949232586*t36*t21*t77*t181*t468*t226-15.93860684769776*
        t36*t21*t77*t181*t467*t509)+t480+t479-0.006376968888889*t14*
        t17*t35*t175*t223*t477+156.25*t111*t2*t27*t33*t36*t440*t441-
        0.003188484444444*t14*t17*t35*t185*t470*t223);
    d3fdgbabab = t4*(-108.5069444444444*t27*t3*t33*t515*t729*
        t730*gradb+156.25*t111*t27*t33*t36*t440*t441*gradb+0.003188484444444*
        t14*t17*t35*t109*(-1.176107352988323*t36*t29*t39*t41*t173*
        t142*t76-2.352214705976647*t36*t29*gradb*t39*t41*t181*t142*
        t76-3.124252118327895*t28*t453*t39*t41*t174*t142*t78-6.24850423665579*
        t28*t453*gradb*t39*t41*t184*t142*t78+6.24850423665579*t28*
        t453*t39*t41*t77*t173*t226*t78+12.49700847331158*t28*t453*
        gradb*t39*t41*t77*t181*t226*t78+10.62573789846517*t36*t21*
        t184*t181*t173*t226+5.312868949232586*t36*t21*t174*t483*t226-
        15.93860684769776*t36*t21*t77*t483*t173*t509)+0.006376968888889*
        t14*t17*t35*t481*t175*t508-0.003188484444444*t14*t17*t35*t175*
        t223*t486-0.006376968888889*t14*t17*t35*t185*t223*t477);
    d3fdababab = t4*
        (0.003188484444444*t109*t14*t17*t35*(18.74551270996737*t28*
        t453*t39*t41*t77*t181*t226*t78-9.372756354983686*t28*t453*
        t39*t41*t184*t142*t78-15.93860684769776*POW(t181,3.0)*t21*
        t36*t509*t77-3.52832205896497*t36*t29*t39*t41*t181*t142*t76+
        15.93860684769776*t36*t21*t184*t483*t226)-108.5069444444444*
        t27*t3*t33*t515*t729*t730+0.006376968888889*t14*t17*POW(t185,
        3.0)*t35*t508-0.009565453333333*t14*t17*t35*t185*t223*t486+
        156.25*t111*t27*t33*t36*t440*t441);


    ds->df1000 += factor*dfdra;
    ds->df0100 += factor*dfdrb;
    ds->df0010 += factor*dfdga;
    ds->df0001 += factor*dfdgb;
    ds->df00001+= factor*dfdgab;

    ds->df2000 += factor*d2fdrara;
    ds->df1100 += factor*d2fdrarb;
    ds->df1010 += factor*d2fdraga;
    ds->df1001 += factor*d2fdragb;
    ds->df10001+= factor*d2fdraab;
    ds->df0200 += factor*d2fdrbrb;
    ds->df0110 += factor*d2fdrbga;
    ds->df0101 += factor*d2fdrbgb;
    ds->df01001+= factor*d2fdrbgab;
    ds->df0020 += factor*d2fdgaga;
    ds->df0011 += factor*d2fdgagb;
    ds->df00101+= factor*d2fdgagab;
    ds->df0002 += factor*d2fdgbgb;
    ds->df00011+= factor*d2fdgbgab;
    ds->df00002+= factor*d2fdgabgab;

    ds->df3000 += factor*d3fdrarara;
    ds->df2100  += factor*d3fdrararb;
    ds->df2010  += factor*d3fdraraga;
    ds->df2001  += factor*d3fdraragb;
    ds->df20001 += factor*d3fdraraab;
    ds->df1200  += factor*d3fdrarbrb;
    ds->df1110  += factor*d3fdrarbga;
    ds->df1101  += factor*d3fdrarbgb;
    ds->df11001 += factor*d3fdrarbab;
    ds->df1020  += factor*d3fdragaga;
    ds->df1011  += factor*d3fdragagb;
    ds->df10101 += factor*d3fdragaab;
    ds->df1002  += factor*d3fdragbgb;
    ds->df10011 += factor*d3fdragbab;
    ds->df10002 += factor*d3fdraabab;
    ds->df0300  += factor*d3fdrbrbrb;
    ds->df0210  += factor*d3fdrbrbga;
    ds->df0201  += factor*d3fdrbrbgb;
    ds->df02001 += factor*d3fdrbrbab;
    ds->df0120  += factor*d3fdrbgaga;
    ds->df0111  += factor*d3fdrbgagb;
    ds->df01101 += factor*d3fdrbgaab;
    ds->df0102  += factor*d3fdrbgbgb;
    ds->df01011 += factor*d3fdrbgbab;
    ds->df01002 += factor*d3fdrbabab;
    ds->df0030  += factor*d3fdgagaga;
    ds->df0021  += factor*d3fdgagagb;
    ds->df00201 += factor*d3fdgagaab;
    ds->df0012  += factor*d3fdgagbgb;
    ds->df00111 += factor*d3fdgagbab;
    ds->df00102 += factor*d3fdgaabab;
    ds->df0003  += factor*d3fdgbgbgb;
    ds->df00021 += factor*d3fdgbgbab;
    ds->df00012 += factor*d3fdgbabab;
    ds->df00003 += factor*d3fdababab;

}
