/*
 * $Id: sig_shugart_bus.h,v 1.13 2012-03-06 14:46:50 siflkres Exp $
 *
 * Copyright (C) 2005-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_SHUGART_BUS_H_INCLUDED
#define __SIG_SHUGART_BUS_H_INCLUDED

#include "sig_boolean_or.h"
#include "sig_gen.h"

struct sig_shugart_bus_funcs {
	/*
	 * Controller -> Drive
	 */
	void (*motor_set)(void *s, unsigned int val);
	void (*select_set)(void *s, unsigned int val);
	void (*hds_set)(void *s, unsigned int val);
	void (*step_in)(void *s);
	void (*step_out)(void *s);
	void (*writeid)(void *s, unsigned char cyl, unsigned char sec);
	void (*writedata)(void *s, unsigned char *buf, unsigned int bufsize);
	void (*read_start)(void *s);

	/*
	 * Drive -> Controller
	 */
	void (*index_set)(void *s, unsigned int val);
	void (*wp_set)(void *s, unsigned int val);
	void (*diskchanged_set)(void *s, unsigned int val);
	void (*readid)(void *s, unsigned char cyl, unsigned char sec);
	void (*readdata)(void *s, unsigned char *buf, unsigned int bufsize);
};

struct sig_shugart_bus {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_shugart_bus_funcs *f;
	} controller;
	unsigned int ncontrollers;
	struct {
		void *s;
		const struct sig_shugart_bus_funcs *f;
	} drive[4];
	unsigned int ndrives;
	struct sig_boolean_or *trk0;
	struct sig_boolean_or *dskchg;
};

/* Controller -> Drive */
extern void
sig_shugart_bus_motor_set(struct sig_shugart_bus *b, void *s,
		unsigned int nr, unsigned int val);
extern void
sig_shugart_bus_select_set(struct sig_shugart_bus *b, void *s,
		unsigned int nr, unsigned int val);
extern void
sig_shugart_bus_hds_set(struct sig_shugart_bus *b, void *s,
		unsigned int val);

extern void
sig_shugart_bus_step_in(struct sig_shugart_bus *b, void *s);
extern void
sig_shugart_bus_step_out(struct sig_shugart_bus *b, void *s);

extern void
sig_shugart_bus_writeid(struct sig_shugart_bus *b, void *s,
		unsigned char cyl, unsigned char sec);
extern void
sig_shugart_bus_writedata(struct sig_shugart_bus *b, void *s,
		unsigned char *data, unsigned int bufsize);

extern void
sig_shugart_bus_read_start(struct sig_shugart_bus *b, void *s);

/* Drive -> Controller */
extern void
sig_shugart_bus_index_set(struct sig_shugart_bus *b, void *s,
		unsigned int val);
extern void
sig_shugart_bus_wp_set(struct sig_shugart_bus *b, void *s,
		unsigned int val);
extern void
sig_shugart_bus_diskchanged_set(struct sig_shugart_bus *b, void *s,
		unsigned int val);

extern void
sig_shugart_bus_readid(struct sig_shugart_bus *b, void *s,
		unsigned char cyl, unsigned char sec);
extern void
sig_shugart_bus_readdata(struct sig_shugart_bus *b, void *s,
		unsigned char *buf, unsigned int bufsize);

extern void
sig_shugart_bus_connect_controller(struct sig_shugart_bus *b, void *s,
		const struct sig_shugart_bus_funcs *f);
extern void
sig_shugart_bus_connect_drive(struct sig_shugart_bus *b, void *s,
		unsigned int nr, const struct sig_shugart_bus_funcs *f);

extern struct sig_shugart_bus *
sig_shugart_bus_create(const char *name);
extern void
sig_shugart_bus_destroy(struct sig_shugart_bus *sig);

extern void
sig_shugart_bus_suspend(struct sig_shugart_bus *b, FILE *fSig);
extern void
sig_shugart_bus_resume(struct sig_shugart_bus *b, FILE *fSig);

#endif /* __SIG_SHUGART_BUS_H_INCLUDED */
