/*
 * Decompiled with CFR 0.152.
 */
package visad.data.gis;

import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.Unit;
import visad.VisADException;
import visad.data.units.Parser;

public class ArcAsciiGridAdapter {
    private static final String XLLCORNER = "XLLCORNER";
    private static final String YLLCORNER = "YLLCORNER";
    private static final String XLLCENTER = "XLLCENTER";
    private static final String YLLCENTER = "YLLCENTER";
    private static final String NCOLS = "NCOLS";
    private static final String NROWS = "NROWS";
    private static final String CELLSIZE = "CELLSIZE";
    private static final String NODATA = "NODATA";
    private static final String NODATA_VALUE = "NODATA_VALUE";
    private static final String[] KNOWN_KEYS = new String[]{"XLLCORNER", "YLLCORNER", "XLLCENTER", "YLLCENTER", "NCOLS", "NROWS", "CELLSIZE", "NODATA", "NODATA_VALUE"};
    public static final RealTupleType DEFAULT_SPATIAL_TYPE = RealTupleType.SpatialCartesian2DTuple;
    public static final RealType DEFAULT_DATA_TYPE = RealType.Altitude;
    private RealTupleType spatialType = DEFAULT_SPATIAL_TYPE;
    private RealType dataType = DEFAULT_DATA_TYPE;
    private Unit dataUnit = CommonUnit.meter;
    private BufferedReader in;
    private int pos;
    private int numRows;
    private int numColumns;
    private float minimumValue = Float.MAX_VALUE;
    private float maximumValue = Float.MIN_VALUE;
    private float cellSize;
    private float xllCorner;
    private float yllCorner;
    private float missingData = -9999.0f;
    private Hashtable headerTable;
    private String filename;
    private DecimalFormat formatter = new DecimalFormat();
    private int numHeaderLines = 0;
    private float[][] rangeVals;
    private boolean readHeader = false;

    public ArcAsciiGridAdapter(String filename) throws VisADException {
        this(filename, DEFAULT_DATA_TYPE);
    }

    public ArcAsciiGridAdapter(String filename, RealType dataType) throws VisADException {
        this(filename, DEFAULT_SPATIAL_TYPE, dataType);
    }

    public ArcAsciiGridAdapter(String filename, RealTupleType spatialType) throws VisADException {
        this(filename, spatialType, DEFAULT_DATA_TYPE);
    }

    public ArcAsciiGridAdapter(String filename, RealTupleType spatialType, RealType dataType) throws VisADException {
        this(filename, spatialType, dataType, dataType.getDefaultUnit());
    }

    public ArcAsciiGridAdapter(String filename, Unit dataUnit) throws VisADException {
        this(filename, DEFAULT_SPATIAL_TYPE, DEFAULT_DATA_TYPE, dataUnit);
    }

    public ArcAsciiGridAdapter(String filename, String dataName) throws VisADException {
        this(filename, RealType.getRealType(dataName));
    }

    public ArcAsciiGridAdapter(String filename, String dataName, String unitSpec) throws VisADException {
        this(filename, RealType.getRealType(dataName, ArcAsciiGridAdapter.makeUnit(unitSpec)), ArcAsciiGridAdapter.makeUnit(unitSpec));
    }

    public ArcAsciiGridAdapter(String filename, RealType dataType, Unit dataUnit) throws VisADException {
        this(filename, DEFAULT_SPATIAL_TYPE, dataType, dataUnit);
    }

    public ArcAsciiGridAdapter(String filename, RealTupleType spatialType, RealType dataType, Unit dataUnit) throws VisADException {
        if (!Unit.canConvert(dataType.getDefaultUnit(), dataUnit)) {
            throw new VisADException("dataUnit incompatible with dataType");
        }
        this.filename = filename;
        this.spatialType = spatialType;
        this.dataType = dataType;
        this.dataUnit = dataUnit;
        this.readHeader();
    }

    private void makeStream() throws VisADException {
        try {
            this.in = this.filename.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(this.filename)))) : new BufferedReader(new FileReader(this.filename));
        }
        catch (IOException e) {
            throw new VisADException("Couldn't open file: " + this.filename);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readHeader() throws VisADException {
        if (this.readHeader) {
            return;
        }
        this.makeStream();
        this.headerTable = new Hashtable();
        boolean inHeader = true;
        this.numHeaderLines = 0;
        try {
            while (inHeader) {
                String line = this.in.readLine();
                if (line != null) {
                    StringTokenizer tok = new StringTokenizer(line);
                    if (tok.countTokens() == 2) {
                        String key = tok.nextToken().trim().toUpperCase();
                        if (!this.isKnownKey(key)) {
                            throw new VisADException("Unknown header key " + key);
                        }
                        String s = tok.nextToken().trim().toUpperCase();
                        try {
                            this.headerTable.put(key, new Float(this.parseValue(s)));
                            ++this.numHeaderLines;
                            continue;
                        }
                        catch (ParseException E) {
                            throw new VisADException("Unable to parse value for key " + key + " " + s);
                        }
                    }
                    inHeader = false;
                    continue;
                }
                inHeader = false;
            }
            this.in.close();
        }
        catch (IOException ioe) {
            throw new VisADException("Problem reading in header line" + ioe);
        }
        if (!this.checkHeader()) {
            throw new VisADException("Unable to find enough metadata " + this.headerTable);
        }
        this.readHeader = true;
    }

    private void readData(Gridded2DSet spatialSet) throws VisADException {
        if (this.rangeVals != null) {
            return;
        }
        if (!this.readHeader) {
            this.readHeader();
        }
        this.rangeVals = new float[1][spatialSet.getLength()];
        this.makeStream();
        try {
            long t1 = System.currentTimeMillis();
            for (int i = 0; i < this.numHeaderLines; ++i) {
                String line = this.in.readLine();
            }
            int index = 0;
            float[] tmpArray = this.rangeVals[0];
            StreamTokenizer tok = new StreamTokenizer(this.in);
            for (int row = 0; row < this.numRows; ++row) {
                int colsRead = 0;
                for (int col = 0; col < this.numColumns; ++col) {
                    ++colsRead;
                    int nextTok = tok.nextToken();
                    if (nextTok == -1) break;
                    if (nextTok != -2) {
                        throw new VisADException("Unknown value:" + tok.sval);
                    }
                    float value = (float)tok.nval;
                    tmpArray[index++] = value != this.missingData ? value : Float.NaN;
                }
                if (this.numColumns == colsRead) continue;
                throw new VisADException("Number of values (" + colsRead + ") < number of columns (" + this.numColumns + ")");
            }
            if (index != this.numColumns * this.numRows) {
                throw new VisADException("Number of values read (" + index + ") != expected (" + this.numColumns * this.numRows);
            }
            long t2 = System.currentTimeMillis();
            this.in.close();
        }
        catch (IOException ioe) {
            throw new VisADException("Error reading data: " + ioe);
        }
    }

    private float parseValue(String value) throws ParseException {
        return this.formatter.parse(value).floatValue();
    }

    private boolean isKnownKey(String key) {
        for (int i = 0; i < KNOWN_KEYS.length; ++i) {
            if (!KNOWN_KEYS[i].equals(key)) continue;
            return true;
        }
        return false;
    }

    private static Unit makeUnit(String unitSpec) throws VisADException {
        try {
            return Parser.parse(unitSpec);
        }
        catch (Exception e) {
            throw new VisADException("Invalid unit specification " + unitSpec);
        }
    }

    private boolean checkHeader() {
        if (!(this.headerTable.containsKey(NCOLS) && this.headerTable.containsKey(NROWS) && this.headerTable.containsKey(CELLSIZE))) {
            return false;
        }
        this.numRows = ((Float)this.headerTable.get(NROWS)).intValue();
        this.numColumns = ((Float)this.headerTable.get(NCOLS)).intValue();
        this.cellSize = ((Float)this.headerTable.get(CELLSIZE)).floatValue();
        this.missingData = this.headerTable.containsKey(NODATA) ? ((Float)this.headerTable.get(NODATA)).floatValue() : (this.headerTable.containsKey(NODATA_VALUE) ? ((Float)this.headerTable.get(NODATA_VALUE)).floatValue() : Float.NaN);
        if (this.headerTable.containsKey(XLLCORNER) && this.headerTable.containsKey(YLLCORNER)) {
            this.xllCorner = ((Float)this.headerTable.get(XLLCORNER)).floatValue();
            this.yllCorner = ((Float)this.headerTable.get(YLLCORNER)).floatValue();
        } else if (this.headerTable.containsKey(XLLCENTER) && this.headerTable.containsKey(YLLCENTER)) {
            this.xllCorner = ((Float)this.headerTable.get(XLLCENTER)).floatValue() - this.cellSize / 2.0f;
            this.yllCorner = ((Float)this.headerTable.get(YLLCENTER)).floatValue() - this.cellSize / 2.0f;
        } else {
            return false;
        }
        return true;
    }

    private Linear2DSet makeSpatialSet() throws VisADException {
        return this.makeSpatialSet(this.getSpatialType());
    }

    private Linear2DSet makeSpatialSet(RealTupleType spatialType) throws VisADException {
        if (!this.readHeader) {
            this.readHeader();
        }
        Linear2DSet spatialSet = new Linear2DSet(spatialType, this.xllCorner, this.xllCorner + this.cellSize * (float)(this.numColumns - 1), this.numColumns, this.yllCorner + this.cellSize * (float)(this.numRows - 1), this.yllCorner, this.numRows, null, null, null, true);
        return spatialSet;
    }

    private FlatField makeFlatField() throws VisADException {
        return this.makeFlatField(this.getSpatialType(), this.getDataType());
    }

    private FlatField makeFlatField(MathType mathType) throws VisADException {
        if (mathType instanceof FunctionType) {
            FunctionType ft = (FunctionType)mathType;
            return this.makeFlatField(ft.getDomain(), (RealType)ft.getRange());
        }
        if (mathType instanceof RealTupleType) {
            return this.makeFlatField((RealTupleType)mathType, this.getDataType());
        }
        if (mathType instanceof RealType) {
            return this.makeFlatField(this.getSpatialType(), (RealType)mathType);
        }
        throw new VisADException("Unable to return data with type " + mathType);
    }

    private FlatField makeFlatField(RealTupleType spatialType, RealType rangeType) throws VisADException {
        Linear2DSet spatialSet = this.makeSpatialSet(spatialType);
        this.readData(spatialSet);
        FunctionType ft = new FunctionType(spatialType, rangeType);
        FlatField ff = new FlatField(ft, (Set)spatialSet, (CoordinateSystem)null, (Set[])null, new Unit[]{this.dataUnit});
        try {
            ff.setSamples(this.rangeVals, false);
        }
        catch (RemoteException re) {
            // empty catch block
        }
        return ff;
    }

    public FieldImpl getData() throws VisADException {
        return this.makeFlatField(this.getSpatialType(), this.getDataType());
    }

    public FieldImpl getData(RealTupleType spatialType, RealType dataType) throws VisADException {
        return this.makeFlatField(spatialType, dataType);
    }

    public FieldImpl getData(MathType mathType) throws VisADException {
        return this.makeFlatField(mathType);
    }

    public Gridded2DSet getSpatialSet() throws VisADException {
        return this.getSpatialSet(this.getSpatialType());
    }

    public Gridded2DSet getSpatialSet(RealTupleType spatialType) throws VisADException {
        return this.getSpatialSet(spatialType);
    }

    public float getXLLCorner() {
        return this.xllCorner;
    }

    public float getYLLCorner() {
        return this.yllCorner;
    }

    public float getCellSize() {
        return this.cellSize;
    }

    public float getNoDataValue() {
        return this.missingData;
    }

    public int getRows() {
        return this.numRows;
    }

    public int getColumns() {
        return this.numColumns;
    }

    public RealTupleType getSpatialType() {
        return this.spatialType;
    }

    public void setSpatialType(RealTupleType newSpatialType) {
        this.spatialType = newSpatialType;
    }

    public void setDataType(RealType newType) {
        this.dataType = newType;
        if (!Unit.canConvert(this.getDataUnit(), this.dataType.getDefaultUnit())) {
            this.dataUnit = this.dataType.getDefaultUnit();
        }
    }

    public RealType getDataType() {
        return this.dataType;
    }

    public void setDataUnit(Unit newUnit) {
        this.dataUnit = newUnit;
    }

    public Unit getDataUnit() {
        return this.dataUnit;
    }

    public Rectangle2D getBounds() {
        return new Rectangle2D.Float(this.xllCorner, this.yllCorner, this.cellSize * (float)this.numColumns, this.cellSize * (float)this.numRows);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("File: ");
        buf.append(this.filename);
        buf.append("\n");
        buf.append("Cell size ");
        buf.append(this.getCellSize());
        buf.append("\n");
        buf.append("Missing value: ");
        buf.append(this.getNoDataValue());
        buf.append("\n");
        buf.append("Bounds: x=");
        buf.append(this.getXLLCorner());
        buf.append(" y=");
        buf.append(this.getYLLCorner());
        buf.append(" width=");
        buf.append(this.getCellSize() * (float)this.getColumns());
        buf.append(" height=");
        buf.append(this.getCellSize() * (float)this.getRows());
        buf.append("\nData type: ");
        try {
            buf.append(new FunctionType(this.getSpatialType(), this.getDataType()));
        }
        catch (Exception excp) {
            buf.append(this.getSpatialType());
            buf.append(" -> ");
            buf.append(this.getDataType());
        }
        return buf.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("must supply Arc ASCIIGRID file name");
            System.exit(1);
        }
        ArcAsciiGridAdapter aga = args.length == 1 ? new ArcAsciiGridAdapter(args[0]) : (args.length == 2 ? new ArcAsciiGridAdapter(args[0], args[1]) : new ArcAsciiGridAdapter(args[0], args[1], args[2]));
        System.out.println(aga);
        aga.makeFlatField();
    }
}

