//
// The Fontaine Font Analysis Project 
// 
// Copyright (c) 2009, 2011 by Edward H. Trager
// All Rights Reserved
// 
// Released under the GNU GPL version 2.0 or later.
//

//
// SouthKoreanHanja.h
//

#ifndef ORTHOGRAPHY_DATA
#include "../OrthographyData.h"
#endif

#ifndef SOUTHKOREANHANJA
#define SOUTHKOREANHANJA

// 
// List of "1800" Korean Hanja taught in South Korean middle and high schools
// 한문교육용기초한자
// 漢文敎育用基礎漢字
// I don't know why, but this source actually contains 1809 unique 漢字:
//
// Source: http://ko.wiktionary.org/wiki/부록:한문_교육용_기초_한자_1800
//
// so our list here actually has 1809 entries ... 
//

namespace SouthKoreanHanja{

//
// Unicode values 
//
UINT32 values[]={
	0x4e00, // 一
	0x4e01, // 丁
	0x4e03, // 七
	0x4e08, // 丈
	0x4e09, // 三
	0x4e0a, // 上
	0x4e0b, // 下
	0x4e0d, // 不
	0x4e11, // 丑
	0x4e14, // 且
	0x4e16, // 世
	0x4e18, // 丘
	0x4e19, // 丙
	0x4e2d, // 中
	0x4e38, // 丸
	0x4e39, // 丹
	0x4e3b, // 主
	0x4e43, // 乃
	0x4e45, // 久
	0x4e4b, // 之
	0x4e4e, // 乎
	0x4e58, // 乘
	0x4e59, // 乙
	0x4e5d, // 九
	0x4e5e, // 乞
	0x4e5f, // 也
	0x4e73, // 乳
	0x4e7e, // 乾
	0x4e82, // 亂
	0x4e86, // 了
	0x4e88, // 予
	0x4e8b, // 事
	0x4e8c, // 二
	0x4e8e, // 于
	0x4e91, // 云
	0x4e92, // 互
	0x4e94, // 五
	0x4e95, // 井
	0x4e9e, // 亞
	0x4ea1, // 亡
	0x4ea4, // 交
	0x4ea5, // 亥
	0x4ea6, // 亦
	0x4ea8, // 亨
	0x4eab, // 享
	0x4eac, // 京
	0x4ead, // 亭
	0x4eba, // 人
	0x4ec1, // 仁
	0x4eca, // 今
	0x4ecb, // 介
	0x4ed5, // 仕
	0x4ed6, // 他
	0x4ed8, // 付
	0x4ed9, // 仙
	0x4ee3, // 代
	0x4ee4, // 令
	0x4ee5, // 以
	0x4ef0, // 仰
	0x4ef2, // 仲
	0x4ef6, // 件
	0x4efb, // 任
	0x4f01, // 企
	0x4f0f, // 伏
	0x4f10, // 伐
	0x4f11, // 休
	0x4f2f, // 伯
	0x4f34, // 伴
	0x4f38, // 伸
	0x4f3c, // 似
	0x4f46, // 但
	0x4f4d, // 位
	0x4f4e, // 低
	0x4f4f, // 住
	0x4f50, // 佐
	0x4f55, // 何
	0x4f59, // 余
	0x4f5b, // 佛
	0x4f5c, // 作
	0x4f73, // 佳
	0x4f7f, // 使
	0x4f86, // 來
	0x4f8b, // 例
	0x4f8d, // 侍
	0x4f9b, // 供
	0x4f9d, // 依
	0x4fae, // 侮
	0x4faf, // 侯
	0x4fb5, // 侵
	0x4fbf, // 便
	0x4fc2, // 係
	0x4fc3, // 促
	0x4fca, // 俊
	0x4fd7, // 俗
	0x4fdd, // 保
	0x4fe1, // 信
	0x4fee, // 修
	0x4ff1, // 俱
	0x5009, // 倉
	0x500b, // 個
	0x500d, // 倍
	0x5012, // 倒
	0x5019, // 候
	0x501f, // 借
	0x5023, // 倣
	0x5024, // 値
	0x502b, // 倫
	0x5047, // 假
	0x5049, // 偉
	0x504f, // 偏
	0x505c, // 停
	0x5065, // 健
	0x5074, // 側
	0x5076, // 偶
	0x508d, // 傍
	0x5091, // 傑
	0x5099, // 備
	0x50ac, // 催
	0x50b2, // 傲
	0x50b3, // 傳
	0x50b5, // 債
	0x50b7, // 傷
	0x50be, // 傾
	0x50c5, // 僅
	0x50cf, // 像
	0x50da, // 僚
	0x50de, // 僞
	0x50e7, // 僧
	0x50f9, // 價
	0x5100, // 儀
	0x5104, // 億
	0x5109, // 儉
	0x5112, // 儒
	0x511f, // 償
	0x512a, // 優
	0x5143, // 元
	0x5144, // 兄
	0x5145, // 充
	0x5146, // 兆
	0x5148, // 先
	0x5149, // 光
	0x514b, // 克
	0x514d, // 免
	0x5152, // 兒
	0x5165, // 入
	0x5167, // 內
	0x5168, // 全
	0x5169, // 兩
	0x516b, // 八
	0x516c, // 公
	0x516d, // 六
	0x516e, // 兮
	0x5171, // 共
	0x5175, // 兵
	0x5176, // 其
	0x5177, // 具
	0x5178, // 典
	0x517c, // 兼
	0x518a, // 冊
	0x518d, // 再
	0x5192, // 冒
	0x51a0, // 冠
	0x51a5, // 冥
	0x51ac, // 冬
	0x51b7, // 冷
	0x51c9, // 凉
	0x51cd, // 凍
	0x51dd, // 凝
	0x51e1, // 凡
	0x51f6, // 凶
	0x51fa, // 出
	0x5200, // 刀
	0x5206, // 分
	0x5207, // 切
	0x520a, // 刊
	0x5211, // 刑
	0x5217, // 列
	0x521d, // 初
	0x5224, // 判
	0x5225, // 別
	0x5229, // 利
	0x5230, // 到
	0x5236, // 制
	0x5237, // 刷
	0x523a, // 刺
	0x523b, // 刻
	0x5247, // 則
	0x524a, // 削
	0x524d, // 前
	0x525b, // 剛
	0x526f, // 副
	0x5272, // 割
	0x5275, // 創
	0x5283, // 劃
	0x5287, // 劇
	0x528d, // 劍
	0x5292, // 劒
	0x529b, // 力
	0x529f, // 功
	0x52a0, // 加
	0x52a3, // 劣
	0x52a9, // 助
	0x52aa, // 努
	0x52c7, // 勇
	0x52c9, // 勉
	0x52d5, // 動
	0x52d9, // 務
	0x52dd, // 勝
	0x52de, // 勞
	0x52df, // 募
	0x52e2, // 勢
	0x52e4, // 勤
	0x52f5, // 勵
	0x52f8, // 勸
	0x52ff, // 勿
	0x5305, // 包
	0x5316, // 化
	0x5317, // 北
	0x5339, // 匹
	0x5340, // 區
	0x5341, // 十
	0x5343, // 千
	0x5348, // 午
	0x534a, // 半
	0x5351, // 卑
	0x5352, // 卒
	0x5353, // 卓
	0x5354, // 協
	0x5357, // 南
	0x535a, // 博
	0x535c, // 卜
	0x5360, // 占
	0x536f, // 卯
	0x5370, // 印
	0x5371, // 危
	0x5374, // 却
	0x5375, // 卵
	0x5377, // 卷
	0x537d, // 卽
	0x537f, // 卿
	0x5384, // 厄
	0x539a, // 厚
	0x539f, // 原
	0x53a5, // 厥
	0x53bb, // 去
	0x53c3, // 參
	0x53c8, // 又
	0x53ca, // 及
	0x53cb, // 友
	0x53cd, // 反
	0x53d4, // 叔
	0x53d6, // 取
	0x53d7, // 受
	0x53db, // 叛
	0x53e3, // 口
	0x53e4, // 古
	0x53e5, // 句
	0x53ea, // 只
	0x53eb, // 叫
	0x53ec, // 召
	0x53ef, // 可
	0x53f2, // 史
	0x53f3, // 右
	0x53f8, // 司
	0x5404, // 各
	0x5408, // 合
	0x5409, // 吉
	0x540c, // 同
	0x540d, // 名
	0x540f, // 吏
	0x5410, // 吐
	0x5411, // 向
	0x541b, // 君
	0x541f, // 吟
	0x5426, // 否
	0x542b, // 含
	0x5438, // 吸
	0x5439, // 吹
	0x543e, // 吾
	0x544a, // 告
	0x5468, // 周
	0x5473, // 味
	0x547c, // 呼
	0x547d, // 命
	0x548c, // 和
	0x54b8, // 咸
	0x54c0, // 哀
	0x54c1, // 品
	0x54c9, // 哉
	0x54e1, // 員
	0x54ed, // 哭
	0x54f2, // 哲
	0x5510, // 唐
	0x552f, // 唯
	0x5531, // 唱
	0x5546, // 商
	0x554f, // 問
	0x5553, // 啓
	0x5584, // 善
	0x559c, // 喜
	0x55aa, // 喪
	0x55ae, // 單
	0x55da, // 嗚
	0x5617, // 嘗
	0x5668, // 器
	0x56b4, // 嚴
	0x56da, // 囚
	0x56db, // 四
	0x56de, // 回
	0x56e0, // 因
	0x56f0, // 困
	0x56fa, // 固
	0x570b, // 國
	0x570d, // 圍
	0x5712, // 園
	0x5713, // 圓
	0x5716, // 圖
	0x5718, // 團
	0x571f, // 土
	0x5728, // 在
	0x5730, // 地
	0x5747, // 均
	0x5750, // 坐
	0x5764, // 坤
	0x5782, // 垂
	0x57cb, // 埋
	0x57ce, // 城
	0x57df, // 域
	0x57f7, // 執
	0x57f9, // 培
	0x57fa, // 基
	0x5802, // 堂
	0x5805, // 堅
	0x5824, // 堤
	0x5831, // 報
	0x5834, // 場
	0x584a, // 塊
	0x5854, // 塔
	0x5857, // 塗
	0x585e, // 塞
	0x5883, // 境
	0x5893, // 墓
	0x589e, // 增
	0x58a8, // 墨
	0x58ae, // 墮
	0x58b3, // 墳
	0x58bb, // 墻
	0x58c1, // 壁
	0x58c7, // 壇
	0x58d3, // 壓
	0x58de, // 壞
	0x58e4, // 壤
	0x58eb, // 士
	0x58ec, // 壬
	0x58ef, // 壯
	0x58fd, // 壽
	0x590f, // 夏
	0x5915, // 夕
	0x5916, // 外
	0x591a, // 多
	0x591c, // 夜
	0x5922, // 夢
	0x5927, // 大
	0x5929, // 天
	0x592a, // 太
	0x592b, // 夫
	0x592e, // 央
	0x5931, // 失
	0x5937, // 夷
	0x5947, // 奇
	0x5948, // 奈
	0x5949, // 奉
	0x594f, // 奏
	0x5951, // 契
	0x5954, // 奔
	0x595a, // 奚
	0x596a, // 奪
	0x596c, // 奬
	0x596e, // 奮
	0x5973, // 女
	0x5974, // 奴
	0x597d, // 好
	0x5982, // 如
	0x5983, // 妃
	0x5984, // 妄
	0x5999, // 妙
	0x59a5, // 妥
	0x59a8, // 妨
	0x59b9, // 妹
	0x59bb, // 妻
	0x59be, // 妾
	0x59c9, // 姉
	0x59cb, // 始
	0x59d1, // 姑
	0x59d3, // 姓
	0x59d4, // 委
	0x59e6, // 姦
	0x59ea, // 姪
	0x59fb, // 姻
	0x59ff, // 姿
	0x5a01, // 威
	0x5a18, // 娘
	0x5a1b, // 娛
	0x5a5a, // 婚
	0x5a62, // 婢
	0x5a66, // 婦
	0x5a92, // 媒
	0x5b50, // 子
	0x5b54, // 孔
	0x5b57, // 字
	0x5b58, // 存
	0x5b5d, // 孝
	0x5b5f, // 孟
	0x5b63, // 季
	0x5b64, // 孤
	0x5b6b, // 孫
	0x5b70, // 孰
	0x5b78, // 學
	0x5b85, // 宅
	0x5b87, // 宇
	0x5b88, // 守
	0x5b89, // 安
	0x5b8c, // 完
	0x5b97, // 宗
	0x5b98, // 官
	0x5b99, // 宙
	0x5b9a, // 定
	0x5b9c, // 宜
	0x5ba2, // 客
	0x5ba3, // 宣
	0x5ba4, // 室
	0x5bae, // 宮
	0x5bb0, // 宰
	0x5bb3, // 害
	0x5bb4, // 宴
	0x5bb6, // 家
	0x5bb9, // 容
	0x5bbf, // 宿
	0x5bc2, // 寂
	0x5bc4, // 寄
	0x5bc5, // 寅
	0x5bc6, // 密
	0x5bcc, // 富
	0x5bd2, // 寒
	0x5bdf, // 察
	0x5be1, // 寡
	0x5be2, // 寢
	0x5be6, // 實
	0x5be7, // 寧
	0x5be9, // 審
	0x5beb, // 寫
	0x5bec, // 寬
	0x5bf6, // 寶
	0x5bf8, // 寸
	0x5bfa, // 寺
	0x5c01, // 封
	0x5c04, // 射
	0x5c07, // 將
	0x5c08, // 專
	0x5c0a, // 尊
	0x5c0b, // 尋
	0x5c0d, // 對
	0x5c0e, // 導
	0x5c0f, // 小
	0x5c11, // 少
	0x5c16, // 尖
	0x5c19, // 尙
	0x5c24, // 尤
	0x5c31, // 就
	0x5c3a, // 尺
	0x5c3e, // 尾
	0x5c40, // 局
	0x5c45, // 居
	0x5c48, // 屈
	0x5c4b, // 屋
	0x5c55, // 展
	0x5c5b, // 屛
	0x5c62, // 屢
	0x5c64, // 層
	0x5c65, // 履
	0x5c6c, // 屬
	0x5c6f, // 屯
	0x5c71, // 山
	0x5ca9, // 岩
	0x5cb3, // 岳
	0x5cb8, // 岸
	0x5cef, // 峯
	0x5cf0, // 峰
	0x5cf6, // 島
	0x5d07, // 崇
	0x5d29, // 崩
	0x5dba, // 嶺
	0x5dd6, // 巖
	0x5ddd, // 川
	0x5dde, // 州
	0x5de1, // 巡
	0x5de5, // 工
	0x5de6, // 左
	0x5de7, // 巧
	0x5de8, // 巨
	0x5dee, // 差
	0x5df1, // 己
	0x5df2, // 已
	0x5df3, // 巳
	0x5df7, // 巷
	0x5e02, // 市
	0x5e03, // 布
	0x5e0c, // 希
	0x5e1d, // 帝
	0x5e25, // 帥
	0x5e2b, // 師
	0x5e2d, // 席
	0x5e33, // 帳
	0x5e36, // 帶
	0x5e38, // 常
	0x5e45, // 幅
	0x5e55, // 幕
	0x5e63, // 幣
	0x5e72, // 干
	0x5e73, // 平
	0x5e74, // 年
	0x5e78, // 幸
	0x5e79, // 幹
	0x5e7c, // 幼
	0x5e7d, // 幽
	0x5e7e, // 幾
	0x5e8a, // 床
	0x5e8f, // 序
	0x5e95, // 底
	0x5e97, // 店
	0x5e9a, // 庚
	0x5e9c, // 府
	0x5ea6, // 度
	0x5ea7, // 座
	0x5eab, // 庫
	0x5ead, // 庭
	0x5eb6, // 庶
	0x5eb7, // 康
	0x5eb8, // 庸
	0x5ec9, // 廉
	0x5eca, // 廊
	0x5edf, // 廟
	0x5ee2, // 廢
	0x5ee3, // 廣
	0x5ef3, // 廳
	0x5ef6, // 延
	0x5ef7, // 廷
	0x5efa, // 建
	0x5f04, // 弄
	0x5f0a, // 弊
	0x5f0f, // 式
	0x5f13, // 弓
	0x5f14, // 弔
	0x5f15, // 引
	0x5f18, // 弘
	0x5f1f, // 弟
	0x5f31, // 弱
	0x5f35, // 張
	0x5f3a, // 强
	0x5f48, // 彈
	0x5f62, // 形
	0x5f69, // 彩
	0x5f71, // 影
	0x5f79, // 役
	0x5f7c, // 彼
	0x5f80, // 往
	0x5f81, // 征
	0x5f85, // 待
	0x5f8b, // 律
	0x5f8c, // 後
	0x5f90, // 徐
	0x5f91, // 徑
	0x5f92, // 徒
	0x5f97, // 得
	0x5f9e, // 從
	0x5fa1, // 御
	0x5fa9, // 復
	0x5faa, // 循
	0x5fae, // 微
	0x5fb5, // 徵
	0x5fb7, // 德
	0x5fb9, // 徹
	0x5fc3, // 心
	0x5fc5, // 必
	0x5fcc, // 忌
	0x5fcd, // 忍
	0x5fd7, // 志
	0x5fd8, // 忘
	0x5fd9, // 忙
	0x5fe0, // 忠
	0x5feb, // 快
	0x5ff5, // 念
	0x5ffd, // 忽
	0x6012, // 怒
	0x601d, // 思
	0x6020, // 怠
	0x6025, // 急
	0x6027, // 性
	0x6028, // 怨
	0x602a, // 怪
	0x6050, // 恐
	0x6052, // 恒
	0x6055, // 恕
	0x6063, // 恣
	0x6065, // 恥
	0x6068, // 恨
	0x6069, // 恩
	0x606d, // 恭
	0x606f, // 息
	0x6085, // 悅
	0x6094, // 悔
	0x609f, // 悟
	0x60a0, // 悠
	0x60a3, // 患
	0x60b2, // 悲
	0x60c5, // 情
	0x60d1, // 惑
	0x60dc, // 惜
	0x60df, // 惟
	0x60e0, // 惠
	0x60e1, // 惡
	0x60f1, // 惱
	0x60f3, // 想
	0x6101, // 愁
	0x6108, // 愈
	0x610f, // 意
	0x611a, // 愚
	0x611b, // 愛
	0x611f, // 感
	0x6127, // 愧
	0x613c, // 愼
	0x6148, // 慈
	0x614b, // 態
	0x6155, // 慕
	0x6158, // 慘
	0x6159, // 慙
	0x6162, // 慢
	0x6163, // 慣
	0x6167, // 慧
	0x6168, // 慨
	0x616e, // 慮
	0x6170, // 慰
	0x6176, // 慶
	0x617e, // 慾
	0x6182, // 憂
	0x618e, // 憎
	0x6190, // 憐
	0x61a4, // 憤
	0x61ab, // 憫
	0x61b2, // 憲
	0x61b6, // 憶
	0x61c7, // 懇
	0x61c9, // 應
	0x61f2, // 懲
	0x61f7, // 懷
	0x61f8, // 懸
	0x61fc, // 懼
	0x6200, // 戀
	0x620a, // 戊
	0x620c, // 戌
	0x6210, // 成
	0x6211, // 我
	0x6212, // 戒
	0x6216, // 或
	0x621a, // 戚
	0x6230, // 戰
	0x6236, // 戶
	0x623f, // 房
	0x6240, // 所
	0x624b, // 手
	0x624d, // 才
	0x6253, // 打
	0x6258, // 托
	0x6276, // 扶
	0x6279, // 批
	0x627f, // 承
	0x6280, // 技
	0x6284, // 抄
	0x628a, // 把
	0x6291, // 抑
	0x6295, // 投
	0x6297, // 抗
	0x6298, // 折
	0x62b1, // 抱
	0x62b5, // 抵
	0x62bc, // 押
	0x62bd, // 抽
	0x62c2, // 拂
	0x62cd, // 拍
	0x62d2, // 拒
	0x62d3, // 拓
	0x62d4, // 拔
	0x62d8, // 拘
	0x62d9, // 拙
	0x62db, // 招
	0x62dc, // 拜
	0x62f3, // 拳
	0x62fe, // 拾
	0x6301, // 持
	0x6307, // 指
	0x6311, // 挑
	0x632f, // 振
	0x6349, // 捉
	0x6355, // 捕
	0x6368, // 捨
	0x6383, // 掃
	0x6388, // 授
	0x638c, // 掌
	0x6392, // 排
	0x639b, // 掛
	0x63a0, // 掠
	0x63a1, // 採
	0x63a2, // 探
	0x63a5, // 接
	0x63a8, // 推
	0x63d0, // 提
	0x63da, // 揚
	0x63db, // 換
	0x63ee, // 揮
	0x63f4, // 援
	0x640d, // 損
	0x6416, // 搖
	0x641c, // 搜
	0x643a, // 携
	0x6458, // 摘
	0x64ad, // 播
	0x64c1, // 擁
	0x64c7, // 擇
	0x64ca, // 擊
	0x64cd, // 操
	0x64d4, // 擔
	0x64da, // 據
	0x64e7, // 擧
	0x64f4, // 擴
	0x651d, // 攝
	0x652f, // 支
	0x6536, // 收
	0x6537, // 攷
	0x6539, // 改
	0x653b, // 攻
	0x653e, // 放
	0x653f, // 政
	0x6545, // 故
	0x6548, // 效
	0x654d, // 敍
	0x654e, // 敎
	0x654f, // 敏
	0x6551, // 救
	0x6557, // 敗
	0x6562, // 敢
	0x6563, // 散
	0x6566, // 敦
	0x656c, // 敬
	0x6574, // 整
	0x6575, // 敵
	0x6578, // 數
	0x6587, // 文
	0x6597, // 斗
	0x6599, // 料
	0x659c, // 斜
	0x65a4, // 斤
	0x65a5, // 斥
	0x65af, // 斯
	0x65b0, // 新
	0x65b7, // 斷
	0x65b9, // 方
	0x65bc, // 於
	0x65bd, // 施
	0x65c5, // 旅
	0x65cb, // 旋
	0x65cf, // 族
	0x65d7, // 旗
	0x65e3, // 旣
	0x65e5, // 日
	0x65e6, // 旦
	0x65e9, // 早
	0x65ec, // 旬
	0x65f1, // 旱
	0x6607, // 昇
	0x660c, // 昌
	0x660e, // 明
	0x660f, // 昏
	0x6613, // 易
	0x6614, // 昔
	0x661f, // 星
	0x6620, // 映
	0x6625, // 春
	0x6628, // 昨
	0x662d, // 昭
	0x662f, // 是
	0x6642, // 時
	0x665d, // 晝
	0x6668, // 晨
	0x6669, // 晩
	0x666e, // 普
	0x666f, // 景
	0x6674, // 晴
	0x667a, // 智
	0x6687, // 暇
	0x6691, // 暑
	0x6696, // 暖
	0x6697, // 暗
	0x66a2, // 暢
	0x66ab, // 暫
	0x66ae, // 暮
	0x66b4, // 暴
	0x66c6, // 曆
	0x66c9, // 曉
	0x66f0, // 曰
	0x66f2, // 曲
	0x66f4, // 更
	0x66f8, // 書
	0x66fe, // 曾
	0x66ff, // 替
	0x6700, // 最
	0x6703, // 會
	0x6708, // 月
	0x6709, // 有
	0x670b, // 朋
	0x670d, // 服
	0x6714, // 朔
	0x671b, // 望
	0x671d, // 朝
	0x671f, // 期
	0x6728, // 木
	0x672a, // 未
	0x672b, // 末
	0x672c, // 本
	0x6731, // 朱
	0x6734, // 朴
	0x674e, // 李
	0x6750, // 材
	0x6751, // 村
	0x675f, // 束
	0x676f, // 杯
	0x6771, // 東
	0x677e, // 松
	0x677f, // 板
	0x6790, // 析
	0x6795, // 枕
	0x6797, // 林
	0x679c, // 果
	0x679d, // 枝
	0x67af, // 枯
	0x67b6, // 架
	0x67d0, // 某
	0x67d3, // 染
	0x67d4, // 柔
	0x67f1, // 柱
	0x67f3, // 柳
	0x67fb, // 査
	0x6817, // 栗
	0x6821, // 校
	0x682a, // 株
	0x6838, // 核
	0x6839, // 根
	0x683c, // 格
	0x683d, // 栽
	0x6842, // 桂
	0x6843, // 桃
	0x6848, // 案
	0x6851, // 桑
	0x6881, // 梁
	0x6885, // 梅
	0x689d, // 條
	0x68a8, // 梨
	0x68b0, // 械
	0x68c4, // 棄
	0x690d, // 植
	0x694a, // 楊
	0x696d, // 業
	0x6975, // 極
	0x69ae, // 榮
	0x69cb, // 構
	0x69ea, // 槪
	0x6a02, // 樂
	0x6a13, // 樓
	0x6a19, // 標
	0x6a21, // 模
	0x6a23, // 樣
	0x6a39, // 樹
	0x6a4b, // 橋
	0x6a5f, // 機
	0x6a6b, // 橫
	0x6a80, // 檀
	0x6aa2, // 檢
	0x6b04, // 欄
	0x6b0a, // 權
	0x6b21, // 次
	0x6b32, // 欲
	0x6b3a, // 欺
	0x6b4c, // 歌
	0x6b4e, // 歎
	0x6b61, // 歡
	0x6b62, // 止
	0x6b63, // 正
	0x6b64, // 此
	0x6b65, // 步
	0x6b66, // 武
	0x6b72, // 歲
	0x6b77, // 歷
	0x6b78, // 歸
	0x6b7b, // 死
	0x6b83, // 殃
	0x6b86, // 殆
	0x6b89, // 殉
	0x6b8a, // 殊
	0x6b98, // 殘
	0x6bb5, // 段
	0x6bba, // 殺
	0x6bbf, // 殿
	0x6bc1, // 毁
	0x6bcd, // 母
	0x6bcf, // 每
	0x6bd2, // 毒
	0x6bd4, // 比
	0x6bdb, // 毛
	0x6beb, // 毫
	0x6c0f, // 氏
	0x6c11, // 民
	0x6c23, // 氣
	0x6c34, // 水
	0x6c37, // 氷
	0x6c38, // 永
	0x6c42, // 求
	0x6c57, // 汗
	0x6c5a, // 汚
	0x6c5d, // 汝
	0x6c5f, // 江
	0x6c60, // 池
	0x6c7a, // 決
	0x6c88, // 沈
	0x6c92, // 沒
	0x6c99, // 沙
	0x6cb3, // 河
	0x6cb9, // 油
	0x6cbb, // 治
	0x6cbf, // 沿
	0x6cc1, // 況
	0x6cc9, // 泉
	0x6cca, // 泊
	0x6cd5, // 法
	0x6ce2, // 波
	0x6ce3, // 泣
	0x6ce5, // 泥
	0x6ce8, // 注
	0x6cf0, // 泰
	0x6cf3, // 泳
	0x6d0b, // 洋
	0x6d17, // 洗
	0x6d1e, // 洞
	0x6d2a, // 洪
	0x6d32, // 洲
	0x6d3b, // 活
	0x6d3e, // 派
	0x6d41, // 流
	0x6d66, // 浦
	0x6d69, // 浩
	0x6d6a, // 浪
	0x6d6e, // 浮
	0x6d74, // 浴
	0x6d77, // 海
	0x6d78, // 浸
	0x6d88, // 消
	0x6d89, // 涉
	0x6daf, // 涯
	0x6dd1, // 淑
	0x6dda, // 淚
	0x6de1, // 淡
	0x6de8, // 淨
	0x6deb, // 淫
	0x6df1, // 深
	0x6df7, // 混
	0x6df8, // 淸
	0x6dfa, // 淺
	0x6dfb, // 添
	0x6e1b, // 減
	0x6e21, // 渡
	0x6e2c, // 測
	0x6e2f, // 港
	0x6e34, // 渴
	0x6e56, // 湖
	0x6e6f, // 湯
	0x6e90, // 源
	0x6e96, // 準
	0x6eaa, // 溪
	0x6eab, // 溫
	0x6ec5, // 滅
	0x6eef, // 滯
	0x6ef4, // 滴
	0x6eff, // 滿
	0x6f01, // 漁
	0x6f02, // 漂
	0x6f06, // 漆
	0x6f0f, // 漏
	0x6f14, // 演
	0x6f20, // 漠
	0x6f22, // 漢
	0x6f2b, // 漫
	0x6f38, // 漸
	0x6f54, // 潔
	0x6f5b, // 潛
	0x6f64, // 潤
	0x6f6e, // 潮
	0x6fa4, // 澤
	0x6fc0, // 激
	0x6fc1, // 濁
	0x6fd5, // 濕
	0x6fdf, // 濟
	0x6feb, // 濫
	0x6fef, // 濯
	0x706b, // 火
	0x707d, // 災
	0x708e, // 炎
	0x70ad, // 炭
	0x70c8, // 烈
	0x70cf, // 烏
	0x7109, // 焉
	0x7121, // 無
	0x7136, // 然
	0x7159, // 煙
	0x7167, // 照
	0x7169, // 煩
	0x719f, // 熟
	0x71b1, // 熱
	0x71c3, // 燃
	0x71c8, // 燈
	0x71d2, // 燒
	0x71d5, // 燕
	0x71df, // 營
	0x71e5, // 燥
	0x71ed, // 燭
	0x7206, // 爆
	0x7210, // 爐
	0x722d, // 爭
	0x7232, // 爲
	0x7235, // 爵
	0x7236, // 父
	0x7246, // 牆
	0x7247, // 片
	0x7248, // 版
	0x7259, // 牙
	0x725b, // 牛
	0x7267, // 牧
	0x7269, // 物
	0x7279, // 特
	0x727d, // 牽
	0x72ac, // 犬
	0x72af, // 犯
	0x72c0, // 狀
	0x72c2, // 狂
	0x72d7, // 狗
	0x731b, // 猛
	0x7336, // 猶
	0x7344, // 獄
	0x7368, // 獨
	0x7372, // 獲
	0x7375, // 獵
	0x7378, // 獸
	0x737b, // 獻
	0x7384, // 玄
	0x7386, // 玆
	0x7387, // 率
	0x7389, // 玉
	0x738b, // 王
	0x73cd, // 珍
	0x73e0, // 珠
	0x73ed, // 班
	0x73fe, // 現
	0x7403, // 球
	0x7406, // 理
	0x7434, // 琴
	0x74b0, // 環
	0x74e6, // 瓦
	0x7518, // 甘
	0x751a, // 甚
	0x751f, // 生
	0x7523, // 産
	0x7528, // 用
	0x7530, // 田
	0x7531, // 由
	0x7532, // 甲
	0x7532, // 甲
	0x7533, // 申
	0x7537, // 男
	0x754c, // 界
	0x754f, // 畏
	0x7553, // 畓
	0x7559, // 留
	0x755c, // 畜
	0x7562, // 畢
	0x7565, // 略
	0x756a, // 番
	0x7570, // 異
	0x7575, // 畵
	0x7576, // 當
	0x757f, // 畿
	0x758e, // 疎
	0x7591, // 疑
	0x75ab, // 疫
	0x75b2, // 疲
	0x75be, // 疾
	0x75c5, // 病
	0x75c7, // 症
	0x75db, // 痛
	0x7678, // 癸
	0x767b, // 登
	0x767c, // 發
	0x767d, // 白
	0x767e, // 百
	0x7684, // 的
	0x7686, // 皆
	0x7687, // 皇
	0x76ae, // 皮
	0x76c3, // 盃
	0x76ca, // 益
	0x76d6, // 盖
	0x76db, // 盛
	0x76dc, // 盜
	0x76df, // 盟
	0x76e1, // 盡
	0x76e3, // 監
	0x76e4, // 盤
	0x76ee, // 目
	0x76f2, // 盲
	0x76f4, // 直
	0x76f8, // 相
	0x7701, // 省
	0x7709, // 眉
	0x770b, // 看
	0x771e, // 眞
	0x7720, // 眠
	0x773c, // 眼
	0x7740, // 着
	0x7761, // 睡
	0x7763, // 督
	0x7766, // 睦
	0x77ac, // 瞬
	0x77e2, // 矢
	0x77e3, // 矣
	0x77e5, // 知
	0x77ed, // 短
	0x77ef, // 矯
	0x77f3, // 石
	0x7834, // 破
	0x784f, // 硏
	0x786c, // 硬
	0x7891, // 碑
	0x78a7, // 碧
	0x78ba, // 確
	0x78bb, // 碻
	0x78e8, // 磨
	0x790e, // 礎
	0x793a, // 示
	0x793e, // 社
	0x7940, // 祀
	0x7948, // 祈
	0x7956, // 祖
	0x795d, // 祝
	0x795e, // 神
	0x7965, // 祥
	0x7968, // 票
	0x796d, // 祭
	0x797f, // 祿
	0x7981, // 禁
	0x798d, // 禍
	0x798f, // 福
	0x79aa, // 禪
	0x79ae, // 禮
	0x79bd, // 禽
	0x79be, // 禾
	0x79c0, // 秀
	0x79c1, // 私
	0x79cb, // 秋
	0x79d1, // 科
	0x79d2, // 秒
	0x79d8, // 秘
	0x79df, // 租
	0x79e9, // 秩
	0x79fb, // 移
	0x7a05, // 稅
	0x7a0b, // 程
	0x7a2e, // 種
	0x7a31, // 稱
	0x7a3b, // 稻
	0x7a3f, // 稿
	0x7a40, // 穀
	0x7a4d, // 積
	0x7a6b, // 穫
	0x7a74, // 穴
	0x7a76, // 究
	0x7a7a, // 空
	0x7a81, // 突
	0x7a93, // 窓
	0x7aae, // 窮
	0x7aca, // 竊
	0x7acb, // 立
	0x7add, // 竝
	0x7adf, // 竟
	0x7ae0, // 章
	0x7ae5, // 童
	0x7aef, // 端
	0x7af6, // 競
	0x7af9, // 竹
	0x7b11, // 笑
	0x7b26, // 符
	0x7b2c, // 第
	0x7b46, // 筆
	0x7b49, // 等
	0x7b54, // 答
	0x7b56, // 策
	0x7b87, // 箇
	0x7b97, // 算
	0x7ba1, // 管
	0x7bc0, // 節
	0x7bc4, // 範
	0x7bc7, // 篇
	0x7bc9, // 築
	0x7be4, // 篤
	0x7c21, // 簡
	0x7c3f, // 簿
	0x7c4d, // 籍
	0x7c73, // 米
	0x7c89, // 粉
	0x7c9f, // 粟
	0x7ca7, // 粧
	0x7cbe, // 精
	0x7cd6, // 糖
	0x7ce7, // 糧
	0x7cfb, // 系
	0x7cfe, // 糾
	0x7d00, // 紀
	0x7d04, // 約
	0x7d05, // 紅
	0x7d0d, // 納
	0x7d14, // 純
	0x7d19, // 紙
	0x7d1a, // 級
	0x7d1b, // 紛
	0x7d20, // 素
	0x7d22, // 索
	0x7d2b, // 紫
	0x7d2f, // 累
	0x7d30, // 細
	0x7d42, // 終
	0x7d43, // 絃
	0x7d44, // 組
	0x7d50, // 結
	0x7d61, // 絡
	0x7d66, // 給
	0x7d71, // 統
	0x7d72, // 絲
	0x7d76, // 絶
	0x7d79, // 絹
	0x7d93, // 經
	0x7da0, // 綠
	0x7dad, // 維
	0x7db1, // 綱
	0x7dbf, // 綿
	0x7dca, // 緊
	0x7dd6, // 緖
	0x7dda, // 線
	0x7de3, // 緣
	0x7de8, // 編
	0x7de9, // 緩
	0x7def, // 緯
	0x7df4, // 練
	0x7e23, // 縣
	0x7e2e, // 縮
	0x7e31, // 縱
	0x7e3d, // 總
	0x7e3e, // 績
	0x7e41, // 繁
	0x7e54, // 織
	0x7e6b, // 繫
	0x7e7c, // 繼
	0x7e8c, // 續
	0x7f3a, // 缺
	0x7f54, // 罔
	0x7f6a, // 罪
	0x7f6e, // 置
	0x7f70, // 罰
	0x7f72, // 署
	0x7f77, // 罷
	0x7f85, // 羅
	0x7f8a, // 羊
	0x7f8e, // 美
	0x7fa4, // 群
	0x7fa9, // 義
	0x7fbd, // 羽
	0x7fc1, // 翁
	0x7fd2, // 習
	0x7ffc, // 翼
	0x8001, // 老
	0x8003, // 考
	0x8005, // 者
	0x800c, // 而
	0x8010, // 耐
	0x8015, // 耕
	0x8033, // 耳
	0x8036, // 耶
	0x8056, // 聖
	0x8058, // 聘
	0x805e, // 聞
	0x806f, // 聯
	0x8070, // 聰
	0x8072, // 聲
	0x8077, // 職
	0x807d, // 聽
	0x8085, // 肅
	0x8089, // 肉
	0x8096, // 肖
	0x809d, // 肝
	0x80a5, // 肥
	0x80a9, // 肩
	0x80af, // 肯
	0x80b2, // 育
	0x80ba, // 肺
	0x80c3, // 胃
	0x80cc, // 背
	0x80de, // 胞
	0x80e1, // 胡
	0x80f8, // 胸
	0x80fd, // 能
	0x8105, // 脅
	0x8108, // 脈
	0x811a, // 脚
	0x8123, // 脣
	0x812b, // 脫
	0x8150, // 腐
	0x8166, // 腦
	0x8170, // 腰
	0x8178, // 腸
	0x8179, // 腹
	0x81df, // 臟
	0x81e3, // 臣
	0x81e5, // 臥
	0x81e8, // 臨
	0x81ea, // 自
	0x81ed, // 臭
	0x81f3, // 至
	0x81f4, // 致
	0x81fa, // 臺
	0x8207, // 與
	0x8208, // 興
	0x820a, // 舊
	0x820c, // 舌
	0x820d, // 舍
	0x821e, // 舞
	0x821f, // 舟
	0x822a, // 航
	0x822c, // 般
	0x8239, // 船
	0x826f, // 良
	0x8272, // 色
	0x82b1, // 花
	0x82b3, // 芳
	0x82bd, // 芽
	0x82d7, // 苗
	0x82df, // 苟
	0x82e5, // 若
	0x82e6, // 苦
	0x82f1, // 英
	0x8302, // 茂
	0x832b, // 茫
	0x8336, // 茶
	0x8349, // 草
	0x8352, // 荒
	0x8377, // 荷
	0x838a, // 莊
	0x83ab, // 莫
	0x83ca, // 菊
	0x83cc, // 菌
	0x83dc, // 菜
	0x83ef, // 華
	0x842c, // 萬
	0x843d, // 落
	0x8449, // 葉
	0x8457, // 著
	0x846c, // 葬
	0x8499, // 蒙
	0x84b8, // 蒸
	0x84bc, // 蒼
	0x84c4, // 蓄
	0x84cb, // 蓋
	0x84ee, // 蓮
	0x852c, // 蔬
	0x853d, // 蔽
	0x8584, // 薄
	0x85a6, // 薦
	0x85cf, // 藏
	0x85dd, // 藝
	0x85e5, // 藥
	0x8607, // 蘇
	0x862d, // 蘭
	0x864e, // 虎
	0x8655, // 處
	0x865b, // 虛
	0x865f, // 號
	0x86c7, // 蛇
	0x8702, // 蜂
	0x871c, // 蜜
	0x8776, // 蝶
	0x87a2, // 螢
	0x87f2, // 蟲
	0x8840, // 血
	0x8846, // 衆
	0x884c, // 行
	0x8853, // 術
	0x8857, // 街
	0x885b, // 衛
	0x885d, // 衝
	0x8861, // 衡
	0x8863, // 衣
	0x8868, // 表
	0x8870, // 衰
	0x88ab, // 被
	0x88c1, // 裁
	0x88c2, // 裂
	0x88cf, // 裏
	0x88d5, // 裕
	0x88dc, // 補
	0x88dd, // 裝
	0x88e1, // 裡
	0x88f3, // 裳
	0x88fd, // 製
	0x8907, // 複
	0x8972, // 襲
	0x897f, // 西
	0x8981, // 要
	0x8986, // 覆
	0x898b, // 見
	0x898f, // 規
	0x8996, // 視
	0x89aa, // 親
	0x89ba, // 覺
	0x89bd, // 覽
	0x89c0, // 觀
	0x89d2, // 角
	0x89e3, // 解
	0x89f8, // 觸
	0x8a00, // 言
	0x8a02, // 訂
	0x8a08, // 計
	0x8a0e, // 討
	0x8a13, // 訓
	0x8a18, // 記
	0x8a1f, // 訟
	0x8a2a, // 訪
	0x8a2d, // 設
	0x8a31, // 許
	0x8a34, // 訴
	0x8a50, // 詐
	0x8a55, // 評
	0x8a5e, // 詞
	0x8a60, // 詠
	0x8a66, // 試
	0x8a69, // 詩
	0x8a71, // 話
	0x8a72, // 該
	0x8a73, // 詳
	0x8a87, // 誇
	0x8a8c, // 誌
	0x8a8d, // 認
	0x8a93, // 誓
	0x8a95, // 誕
	0x8a98, // 誘
	0x8a9e, // 語
	0x8aa0, // 誠
	0x8aa4, // 誤
	0x8aa6, // 誦
	0x8aaa, // 說
	0x8ab0, // 誰
	0x8ab2, // 課
	0x8abf, // 調
	0x8ac7, // 談
	0x8acb, // 請
	0x8ad2, // 諒
	0x8ad6, // 論
	0x8af8, // 諸
	0x8afe, // 諾
	0x8b00, // 謀
	0x8b01, // 謁
	0x8b02, // 謂
	0x8b19, // 謙
	0x8b1b, // 講
	0x8b1d, // 謝
	0x8b20, // 謠
	0x8b39, // 謹
	0x8b49, // 證
	0x8b58, // 識
	0x8b5c, // 譜
	0x8b66, // 警
	0x8b6f, // 譯
	0x8b70, // 議
	0x8b77, // 護
	0x8b7d, // 譽
	0x8b80, // 讀
	0x8b8a, // 變
	0x8b93, // 讓
	0x8b9a, // 讚
	0x8c37, // 谷
	0x8c46, // 豆
	0x8c48, // 豈
	0x8c4a, // 豊
	0x8c5a, // 豚
	0x8c61, // 象
	0x8c6a, // 豪
	0x8c6b, // 豫
	0x8c8c, // 貌
	0x8c9d, // 貝
	0x8c9e, // 貞
	0x8ca0, // 負
	0x8ca1, // 財
	0x8ca2, // 貢
	0x8ca7, // 貧
	0x8ca8, // 貨
	0x8ca9, // 販
	0x8caa, // 貪
	0x8cab, // 貫
	0x8cac, // 責
	0x8caf, // 貯
	0x8cb4, // 貴
	0x8cb7, // 買
	0x8cb8, // 貸
	0x8cbb, // 費
	0x8cbf, // 貿
	0x8cc0, // 賀
	0x8cc3, // 賃
	0x8cc7, // 資
	0x8cca, // 賊
	0x8cd3, // 賓
	0x8cdc, // 賜
	0x8cde, // 賞
	0x8ce2, // 賢
	0x8ce3, // 賣
	0x8ce4, // 賤
	0x8ce6, // 賦
	0x8cea, // 質
	0x8cf4, // 賴
	0x8d08, // 贈
	0x8d0a, // 贊
	0x8d64, // 赤
	0x8d70, // 走
	0x8d74, // 赴
	0x8d77, // 起
	0x8d85, // 超
	0x8d8a, // 越
	0x8da3, // 趣
	0x8db3, // 足
	0x8ddd, // 距
	0x8de1, // 跡
	0x8def, // 路
	0x8df3, // 跳
	0x8e0f, // 踏
	0x8e10, // 踐
	0x8e5f, // 蹟
	0x8e8d, // 躍
	0x8eab, // 身
	0x8eca, // 車
	0x8ecc, // 軌
	0x8ecd, // 軍
	0x8ed2, // 軒
	0x8edf, // 軟
	0x8f03, // 較
	0x8f09, // 載
	0x8f15, // 輕
	0x8f1d, // 輝
	0x8f29, // 輩
	0x8f2a, // 輪
	0x8f38, // 輸
	0x8f3f, // 輿
	0x8f49, // 轉
	0x8f9b, // 辛
	0x8fa8, // 辨
	0x8fad, // 辭
	0x8faf, // 辯
	0x8fb0, // 辰
	0x8fb1, // 辱
	0x8fb2, // 農
	0x8fce, // 迎
	0x8fd1, // 近
	0x8fd4, // 返
	0x8feb, // 迫
	0x8ff0, // 述
	0x8ff7, // 迷
	0x8ffd, // 追
	0x9000, // 退
	0x9001, // 送
	0x9003, // 逃
	0x9006, // 逆
	0x900f, // 透
	0x9010, // 逐
	0x9014, // 途
	0x901a, // 通
	0x901d, // 逝
	0x901f, // 速
	0x9020, // 造
	0x9022, // 逢
	0x9023, // 連
	0x902e, // 逮
	0x9032, // 進
	0x9038, // 逸
	0x9042, // 遂
	0x9047, // 遇
	0x904a, // 遊
	0x904b, // 運
	0x904d, // 遍
	0x904e, // 過
	0x9053, // 道
	0x9054, // 達
	0x9055, // 違
	0x9059, // 遙
	0x905e, // 遞
	0x9060, // 遠
	0x9063, // 遣
	0x9069, // 適
	0x9072, // 遲
	0x9075, // 遵
	0x9077, // 遷
	0x9078, // 選
	0x907a, // 遺
	0x907f, // 避
	0x9084, // 還
	0x908a, // 邊
	0x9091, // 邑
	0x90a3, // 那
	0x90a6, // 邦
	0x90aa, // 邪
	0x90ca, // 郊
	0x90de, // 郞
	0x90e1, // 郡
	0x90e8, // 部
	0x90ed, // 郭
	0x90f5, // 郵
	0x90fd, // 都
	0x9115, // 鄕
	0x9149, // 酉
	0x914c, // 酌
	0x914d, // 配
	0x9152, // 酒
	0x9189, // 醉
	0x919c, // 醜
	0x91ab, // 醫
	0x91cb, // 釋
	0x91cc, // 里
	0x91cd, // 重
	0x91ce, // 野
	0x91cf, // 量
	0x91d1, // 金
	0x91dd, // 針
	0x920d, // 鈍
	0x925b, // 鉛
	0x9280, // 銀
	0x9283, // 銃
	0x9285, // 銅
	0x9298, // 銘
	0x92b3, // 銳
	0x92fc, // 鋼
	0x9304, // 錄
	0x9322, // 錢
	0x9326, // 錦
	0x932f, // 錯
	0x934a, // 鍊
	0x9396, // 鎖
	0x93ad, // 鎭
	0x93e1, // 鏡
	0x9418, // 鐘
	0x9435, // 鐵
	0x9444, // 鑄
	0x9451, // 鑑
	0x9452, // 鑒
	0x945b, // 鑛
	0x9577, // 長
	0x9580, // 門
	0x9589, // 閉
	0x958b, // 開
	0x958f, // 閏
	0x9591, // 閑
	0x9593, // 間
	0x95a3, // 閣
	0x95b1, // 閱
	0x95dc, // 關
	0x9632, // 防
	0x9644, // 附
	0x964d, // 降
	0x9650, // 限
	0x9662, // 院
	0x9663, // 陣
	0x9664, // 除
	0x9670, // 陰
	0x9673, // 陳
	0x9675, // 陵
	0x9676, // 陶
	0x9677, // 陷
	0x9678, // 陸
	0x967d, // 陽
	0x9686, // 隆
	0x968a, // 隊
	0x968e, // 階
	0x9694, // 隔
	0x969b, // 際
	0x969c, // 障
	0x96a3, // 隣
	0x96a8, // 隨
	0x96aa, // 險
	0x96b1, // 隱
	0x96b7, // 隷
	0x96c1, // 雁
	0x96c4, // 雄
	0x96c5, // 雅
	0x96c6, // 集
	0x96d6, // 雖
	0x96d9, // 雙
	0x96dc, // 雜
	0x96e2, // 離
	0x96e3, // 難
	0x96e8, // 雨
	0x96ea, // 雪
	0x96f2, // 雲
	0x96f6, // 零
	0x96f7, // 雷
	0x96fb, // 電
	0x9700, // 需
	0x9707, // 震
	0x971c, // 霜
	0x9727, // 霧
	0x9732, // 露
	0x9748, // 靈
	0x9751, // 靑
	0x975c, // 靜
	0x975e, // 非
	0x9762, // 面
	0x9769, // 革
	0x97d3, // 韓
	0x97f3, // 音
	0x97fb, // 韻
	0x97ff, // 響
	0x9802, // 頂
	0x9803, // 頃
	0x9805, // 項
	0x9806, // 順
	0x9808, // 須
	0x980c, // 頌
	0x9817, // 頗
	0x9818, // 領
	0x982d, // 頭
	0x983b, // 頻
	0x984c, // 題
	0x984d, // 額
	0x9854, // 顔
	0x9858, // 願
	0x985e, // 類
	0x9867, // 顧
	0x986f, // 顯
	0x98a8, // 風
	0x98db, // 飛
	0x98dc, // 飜
	0x98df, // 食
	0x98e2, // 飢
	0x98ee, // 飮
	0x98ef, // 飯
	0x98fd, // 飽
	0x98fe, // 飾
	0x990a, // 養
	0x9913, // 餓
	0x9918, // 餘
	0x9928, // 館
	0x9996, // 首
	0x9999, // 香
	0x99ac, // 馬
	0x9a0e, // 騎
	0x9a30, // 騰
	0x9a37, // 騷
	0x9a45, // 驅
	0x9a57, // 驗
	0x9a5a, // 驚
	0x9a5b, // 驛
	0x9aa8, // 骨
	0x9ad4, // 體
	0x9ad8, // 高
	0x9aee, // 髮
	0x9b2a, // 鬪
	0x9b3c, // 鬼
	0x9b42, // 魂
	0x9b5a, // 魚
	0x9bae, // 鮮
	0x9ce5, // 鳥
	0x9cf3, // 鳳
	0x9cf4, // 鳴
	0x9d3b, // 鴻
	0x9db4, // 鶴
	0x9dc4, // 鷄
	0x9e7d, // 鹽
	0x9e7f, // 鹿
	0x9e97, // 麗
	0x9ea5, // 麥
	0x9ebb, // 麻
	0x9ec3, // 黃
	0x9ed1, // 黑
	0x9ed8, // 默
	0x9ede, // 點
	0x9ee8, // 黨
	0x9f13, // 鼓
	0x9f3b, // 鼻
	0x9f4a, // 齊
	0x9f52, // 齒
	0x9f8d, // 龍
	0x9f9c, // 龜
	END_OF_DATA
};

//
// Sample sentences
// 
const char *sentences[]={
	"畓乭無高城雙龍鬼",
	END_OF_DATA
};


//
// 
//
OrthographyData data={
	"South Korean Hanja", // Common name
	"한문교육용기초한자", // Native name
	0x91D1, // This key, 金, (Kim, gold) is a common Korean family name
	values,
	"畓乭無高城雙龍鬼", // Sample characters
	sentences
};

const OrthographyData *pData = &data;

}; // end of namespace

#endif
