=======================
Installation de Freeciv
=======================

Ce document décrit comment compiler et installer Freeciv. La dernière
fois que nous nous sommes assurés que ce fichier était à jour était le
16 juillet 2006.
La dernière mise à jour mineure était le 25 octobre 2020.
La dernière mise à jour de la traduction était le 06 novembre 2020.

Il peut y avoir une version traduite de ce fichier dans le répertoire
./doc, nommé INSTALL.fr (par exemple, INSTALL.de). Étrangement, c'est
justement le fichier que vous êtes en train de lire...

Ce document contient les sections et sous-sections suivantes :
0. Prérequis
1. Prérequis pour les clients
  1a. Prérequis pour le client Gtk3
  1b. Prérequis pour le client Gtk3.22
  1c. Prérequis pour le client SDL2
  1d. Prérequis pour le client Qt
2. Génération des Makefile
  2a. Génération des Makefile pour les versions git
  2b. Génération des Makefile pour les versions diffusées
3. Compilation de Freeciv
4. Installation
5. Prise en charge des langues étrangères
6. Prise en charge de Readline
7. Notes de Reinier sur l'installation Solaris
8. Notes Max OS X et Darwin
9. Notes Windows


0. Pré-requis :
===============

Freeciv a un certain nombre de prérequis. Cependant, à part le premier
pré-requis, le processus de configuration est suffisamment intelligent
pour déterminer si votre système convient. Dans le doute, essayez.

 - Unix (ou similaire)

   Le système d'exploitation Unix, un équivalent comme Linux ou FreeBSD
   ou un système qui propose un mode s'approchant d'Unix, comme EMX sous
   OS/2 ou la boîte à outils Cygnus Cygwin sous Windows (voir
   http://sourceware.cygnus.com/cygwin/). Le support des sockets TCP/IP
   de style BSD est primordial, ainsi qu'un shell compatible Bourne
   comme GNU "bash" (la plupart des Unices remplissent le contrat...).

 - Un compilateur C ANSI

   Freeciv est écrit en C (presque) ANSI et très portable. Les
   architectures 32 et 64 bits sont supportées. Vous ne pouvez pas
   utiliser un compilateur C "K&R" ou un compilateur C++.

   Le développement de Freeciv se fait avant tout avec "gcc",
   l'excellent compilateur C du projet GNU. Les distributions peuvent
   être compilées avec gcc ou la plupart des autres compilateurs (comme
   le compilateur C de Solaris). 

 - Un programme "make"

   Les développeurs de Freeciv utilisent en général "gmake", le
   programme make de GNU.

   Les versions diffusées officielles de Freeciv sont conçues pour
   avoir des makefiles qui fonctionnent avec la plupart des programmes
   make.

   Vous pouvez vérifier si vous avez GNU make sur votre système en
   tapant :

    % make -v                   [si ça ne marche pas, essayez "gmake -v"]

   "GNU Make" devrait alors s'afficher quelque part.

- libtool version 2.2 ou mieux

- libcurl version 7.15.4 ou mieux

  Libcurl se charge de la communication http avec le metaserveur, et
  du transfert des installateurs de modpacks.

  http://curl.haxx.se/

- libicu

  Libicu facilite la manipulation des textes UTF-8

  http://site.icu-project.org/

 - libsqlite3

  http://www.sqlite.org/

La version git a des prérequis supplémentaires. Une version diffusée
contient les fichiers générés.

- Les programmes de GNU gettext 0.15 ou mieux

  En particulier, le programme xgettext est nécessaire pour créer les
  fichier *.gmo qui ne sont pas inclus dans l'arborescence git.

- GNU autoconf version 2.65 ou mieux

  Autoconf est nécessaire pour créer configure à partir de
  configure.ac.

- GNU automake version 1.11.4 ou mieux

  Automake est nécessaire pour créer les différents Makefile.in à
  partir de Makefile.am.

1. Pré-requis pour les clients :
================================

Le client Freeciv existe sous les formes suivantes :
* bibliothèque de widgets Gtk+ 3.0 ("Gtk+ 3.0")
* bibliothèque de widgets Gtk+ 3.0, version 3.22 ("Gtk+ 3.22")
* SDL2
* Qt

Ces formes ont des prérequis différents, expliqués séparément
ci-dessous.

Votre système devra satisfaire au moins l'un de ces ensembles de
pré-requis.

Notez que la plupart des systèmes Linux ont des paquetages séparés
pour la prise charge de la bibliothèque elle-même et de son
développement (c'est-à-dire pour la compilation de programmes qui
utilisent ces bibliothèques). Pour compiler Freeciv sur de tels
systèmes, vous aurez besoin d'installer les paquetages appropriés de
"développement".

La prise en charge du son est incorporée par défaut si la bibliothèque
de développement "SDL2_mixer" est trouvée sur le système.

 https://www.libsdl.org/projects/SDL_mixer/release/SDL2_mixer-2.0.4.tar.gz


1a. Pré-requis pour le client Gtk+ 3.0 :
========================================

- "pkg-config"

  "pkg-config" est un système de gestion d'options de compilation /
  édition de liens de bibliothèques qui fonctionne avec automake et
  autoconf. Vous pouvez l'obtenir à :

    http://pkgconfig.freedesktop.org/releases/pkg-config-0.28.tar.gz

- La bibliothèque utilitaire "Glib"

  La biblothèque utilitaire "Glib" fournit des fonctions non-graphiques
  utilisées par les bibliothèques "Gdk" et "Gtk+", comme les tables de
  hachage, les listes simplement chaînées, etc.

  Freeciv nécessite une version de "Glib" supérieure ou égale à 2.36.

  Si le processus de configuration de Freeciv vous dit que vous n'avez
  pas la bibliothèque Glib, alors elle peut être obtenue ici :

     http://ftp.gnome.org/pub/gnome/sources/glib/2.36/glib-2.36.1.tar.xz

- La bibliothèque d'accessibilité "Atk"

  La bibliothèque "Atk" fournit un ensemble d'interfaces pour
  l'accessibilité. Elle permet aux personnes avec handicap d'utiliser
  toutes les fonctionnalités fournies par les applications Gtk+. Vous
  pouvez l'obtenir à :

    http://ftp.gnome.org/pub/gnome/sources/atk/2.8/atk-2.8.0.tar.xz

- La bibliothèque de disposition et de rendu de texte "Pango"

  "Pango" est une bibliothèque pour la disposition et le rendu de
  texte, avec un accent sur l'internationalisation. Vous pouvez
  l'obtenir à :

    http://ftp.gnome.org/pub/gnome/sources/pango/1.34/pango-1.34.0.tar.xz

- La bibliothèque de chargement/sauvegarde d'images "Gdk-Pixbuf"

  "Gdk-Pixbuf" était avant incluse directement dans "Gtk+", mais est
  maintenant un projet à part. Elle peut être obtenue depuis :

    http://ftp.gnome.org/pub/gnome/sources/gdk-pixbuf/2.28/gdk-pixbuf-2.28.1.tar.xz

- La bibliothèque de widgets "Gtk+"

   La bibliothèque de widgets "Gtk+" a été conçue pour le logiciel de graphisme
   GIMP. Depuis lors, elle a gagné en popularité comme boîte à outils libre
   et facile à programmer.

  La bibliothèque "Gtk+" est livrée avec une librairie appariée :
 
    "Gdk" :
      Fournit une couche d'abstraction au-dessus de X-Window / LinuxFB
      / Win32 pour implémenter des fonctions de base de dessin, de
      fenêtres, de rognage, etc.

  Freeciv nécessite une version de "Gtk+" supérieure ou égale à 3.10.0.

  Si le processus de configuration de Freeciv vous dit que vous n'avez
  pas la bibliothèque Gtk+ installée, alors vous pouvez l'obtenir
  depuis :

    http://ftp.gnome.org/pub/gnome/sources/gtk+/3.12/gtk+-3.12.2.tar.xz

  "Gtk+" dépend des bibliothèques "Glib", "Atk", "Gdk-Pixbuf" et
  "Pango".

Si vous devez les faire vous-même, construisez-les et installez-les
dans l'ordre suivant : pkg-config, Glib, Atk, Pango, Gdk-Pixbuf, Gtk+.

1b. Pré-requis pour le client Gtk+ 3.22 :
========================================

- "pkg-config"

  "pkg-config" est un système de gestion d'options de compilation /
  édition de liens de bibliothèques qui fonctionne avec automake et
  autoconf. Vous pouvez l'obtenir à :

    http://pkgconfig.freedesktop.org/releases/pkg-config-0.29.1.tar.gz

- La bibliothèque utilitaire "Glib"

  La biblothèque utilitaire "Glib" fournit des fonctions non-graphiques
  utilisées par les bibliothèques "Gdk" et "Gtk+", comme les tables de
  hachage, les listes simplement chaînées, etc.

  Freeciv nécessite une version de "Glib" supérieure ou égale à 2.50.

  Si le processus de configuration de Freeciv vous dit que vous n'avez
  pas la bibliothèque Glib installée, alors elle peut être obtenue ici :

     http://ftp.gnome.org/pub/gnome/sources/glib/2.50/glib-2.50.1.tar.xz

- La bibliothèque d'accessibilité "Atk"

  La bibliothèque "Atk" fournit un ensemble d'interfaces pour
  l'accessibilité. Elle permet aux personnes avec handicap d'utiliser
  toutes les fonctionnalités fournies par les applications Gtk+. Vous
  pouvez l'obtenir à :

    http://ftp.gnome.org/pub/gnome/sources/atk/2.22/atk-2.22.0.tar.xz

- La bibliothèque de disposition et de rendu de texte "Pango"

  "Pango" est une bibliothèque pour la disposition et le rendu de
  texte, avec un accent sur l'internationalisation. Vous pouvez
  l'obtenir à :

    http://ftp.gnome.org/pub/gnome/sources/pango/1.40/pango-1.40.3.tar.xz

- La bibliothèque de chargement/sauvegarde d'images "Gdk-Pixbuf"

  "Gdk-Pixbuf" était avant incluse directement dans "Gtk+", mais est
  maintenant un projet à part. Elle peut être obtenue depuis :

    http://ftp.gnome.org/pub/gnome/sources/gdk-pixbuf/2.36/gdk-pixbuf-2.36.0.tar.xz

- La bibliothèque de widgets "Gtk+"

   La bibliothèque de widgets "Gtk+" a été conçue pour le logiciel de graphisme
   GIMP. Depuis lors, elle a gagné en popularité comme boîte à outils libre
   et facile à programmer.

  "Gtk+ 3.22" est le client par défaut. Si vous ne spécifiez aucun
  client avec "--enable-client" à configure, vous aurez le client
  "Gtk+ 3.22".

  La bibliothèque "Gtk+" est livrée avec une librairie appariée :
 
    "Gdk" :
      Fournit une couche d'abstraction au-dessus de X-Window / LinuxFB
      / Win32 pour implémenter des fonctions de base de dessin, de
      fenêtres, de rognage, etc.

  Freeciv nécessite une version de "Gtk+" supérieure ou égale à 3.22.0.

  Si le processus de configuration de Freeciv vous dit que vous n'avez
  pas la bibliothèque Gtk+ installée, alors vous pouvez l'obtenir
  depuis :

    http://ftp.gnome.org/pub/gnome/sources/gtk+/3.22/gtk+-3.22.12.tar.xz

  "Gtk+" dépend des bibliothèques "Glib", "Atk", "Gdk-Pixbuf" et
  "Pango".

Si vous devez les faire vous-même, construisez-les et installez-les
dans l'ordre suivant : pkg-config, Glib, Atk, Pango, Gdk-Pixbuf, Gtk+.

1c. Prérequis pour le client SDL2 :
===================================

- La bibliothèque "SDL2"

  "Simple DirectMedia Layer est une bibliothèque multimédia
  multi-plateformes conçue pour fournir un accès bas niveau à l'audio,
  au clavier, à la souris, au joystick et au matériel 3D au travers
  d'OpenGL et du framebuffer 2D." (traduit de http://www.libsdl.org).

  Ces fonctionnalités en font un bon choix pour les jeux
  portables. Vous pouvez l'obtenir à :

    http://www.libsdl.org/release/SDL2-2.0.3.tar.gz

  Pour compiler le client en utilisant la librairie "DSL2", ajoutez
  "--enable-client=sdl2" au script de configuration de Freeciv. Voir
  la section ci-dessous pour plus d'information sur le script
  configure.

- La bibliothèque "SDL2_image"

  Cette bibliothèque charge les images PNG (à l'aide de linpng), et
  les convertit en "surfaces SDL" qui peuvent être manipulées par la
  bibliothèque SDL. Vous pouvez l'obtenir à :

    http://www.libsdl.org/projects/SDL_image/release/SDL2_image-2.0.1.tar.gz

- La bibliothèque "SDL2_gfx"

    http://www.ferzkopp.net/Software/SDL2_gfx/SDL2_gfx-1.0.3.tar.gz

- La bibliothèque "SDL2_ttf"

    http://www.libsdl.org/projects/SDL_ttf/release/SDL2_ttf-2.0.14.tar.gz

- La bibliothèque "freetype"

  Cette bibliothèque aide à rendre le texte pour le client SDL2, en
  utilisant une police TrueType fournie de façon externe. Vous pouvez
  l'obtenir à :

    https://download.savannah.gnu.org/releases/freetype/freetype-2.7.1.tar.bz2

1d. Prérequis pour le client Qt :
=================================

- Le compilateur C++

  Qt-client est écrit en C++, vous aurez donc besoin d'un compilateur
  aproprié.
  Dans le développement de Freeciv, g++ a été utilisé.
  Le compilateur doit supporter le standard C++11 ou, dans le cas
  d'une compilation --with-qt5x, le standard C++17.

- Les bibliothèques et en-têtes de Qt5Core, Qt5Gui, et Qt5Widgets

  La version 5.11 au moins est nécessaire.
  Si on compile avec l'option configure --with-qt5x, la version 5.15
  est requise au minimum.


2. Générer les Makefiles :
==========================

Cette section contient deux parties, l'une pour générer les Makefiles
pour les versions issues de git, et l'autre pour générer les Makefiles
pour les versions diffusées.

2a. Génération des Makefiles pour les versions git :
====================================================

Cette étape n'est nécessaire que pour les versions git.

Pour créer le makefile, il suffit de taper

% ./autogen.sh

Cela va créer le script configure et le lancer. Tous les paramètres de
autogen.sh sont passés à configure. Lisez la section suivante pour les
paramètres qui peuvent être passés à configure.

2b. Génération des Makefiles pour les versions diffusées :
==========================================================

Avant de compiler Freeciv, vous devez générer un Makefile. Ce Makefile
est configuré pour correspondre aux fonctionnalités disponibles sur
votre machine.

Cette configuration est effectuée en utilisant le script GNU
"configure".

Pour utiliser "configure", rendez vous dans le répertoire racine
qui contient les fichiers Freeciv, et tapez :

% ./configure

Ce script tentera ensuite de déterminer les fonctionnalités présentes
(et absentes !) sur votre système. Il devrait afficher une
page ou deux de diagnostics sur votre machine, et s'arrêter
grâcieusement. 

Si vous désirez de l'aide sur les diverses options supportées par le
script configure, essayez l'option --help, comme ceci :

% ./configure --help

Par défaut, le script configure choisira le client Gtk+ si les
bibliothèques nécessaires sont trouvées. Si vous préférez outrepasser
ce comportement par défaut, vous pouvez donner à configure l'option
"--enable-client=sdl2".

Si vous voulez changer les options de compilation, positionnez la
variable d'environnement CFLAGS dans votre shell avant de lancer
"configure". Par exemple :

% CFLAGS="-O -g -pipe" ./configure   [avec le Bourne shell ou bash]

ou

% setenv CFLAGS "-O -g -pipe"
% ./configure                        [avec le C shell ou tcsh]

Si vous investiguez un "core dump", nous vous suggérons d'utiliser
l'option "-g" dans CFLAGS.

Quand vous installerez Freeciv (plus tard), les composants du jeu
seront copiés dans des sous-répertoires /usr/local par défaut. Si vous
voulez utiliser un autre préfixe d'installation à la place de
/usr/local, vous devriez le spécifier maintenant :

% ./configure --prefix=/opt/freeciv

Si pour une raison quelconque, l'utilisation de "configure" vous pose
des problèmes, essayez les étapes suivantes :

- Lisez attentivement la section sur les prérequis, pour déterminer si
  votre système satisfait à toutes les exigences.

- Si le problème est avec "gettext", merci de lire la section Prise en
  charge des langues étrangères, ci-dessous, pour des contournements
  possibles.

- Faites le nous savoir, pour que nous puissions le réparer pour les
  prochaines sorties !!

  Envoyez un mail à la liste de diffusion freeciv-dev, en nous disant
  ce que vous avez fait, et quel est le résultat. Il serait utile
  d'inclure la sortie du script configure, et le contenu des fichiers
  "config.status", "config.cache" et "config.log", qui sont générés
  par le script configure.

  Vous pouvez en savoir plus sur la liste de diffusion freeciv-dev sur
  notre site web, à https://www.freeciv.org/


3. Compilation de Freeciv :
===========================


Si tout s'est bien déroulé jusqu'ici, alors la compilation de Freeciv
devrait être aussi facile que de taper "make" (ou, de préférence,
"gmake").

Si vous avez des problèmes, lisez le fichier BUGS et suivez les
conseils scrupuleusement. Si le problème vient de "gettext", veuillez
lire la section "Prise en charge des langues étrangères" ci-dessous
afin de connaître les alternatives.

Après la compilation, les choses suivantes sont importantes :

  - les binaires "client/civclient" et "server/civserver"
  - le répertoire "data/", qui contient les graphismes et les scénarios
  - le répertoire "translations/", qui contient les fichiers de prise
    en charge des langues étrangères
  - les scripts "fcgui" et "fcser".

Il est parfaitement possible de jouer à Freeciv depuis ce répertoire,
sans l'installer. Si vous faites ceci, les scripts "fcgui" et "fcser"
seront utiles, bien qu'ils ne soient pas aussi nécessaires qu'ils
aient pu l'être.

Consultez le fichier README.fr pour plus de renseignements.

(Cependant, vous ne pouvez pas utilisez la prise en charge des
langues étrangères en jouant à Freeciv depuis le répertoire des
sources ; vous devez installer Freeciv pour cela.)


4. Installation :
=================

Pour installer Freeciv, il faut que les composants mentionnés dans la
section "Compiler Freeciv" soient installés. Ils doivent être copiés
dans un répertoire tel que /usr/local (par défaut), /usr/games/,
/usr/games/freeciv, /usr/local/freeciv ou tout autre répertoire
convenable.

Taper "make install" devrait tout installer correctement sur votre
machine. Vous pouvez utiliser l'option --prefix=RÉP de configure (voir
la section "Génération des Makefile") pour vous assurer que les
fichiers sont placés là où vous les voulez.

Lorsque le client et le server Freeciv sont lancés, ils ont besoin de
trouver certains fichiers dans le répertoire "data". Par défaut, Freeciv
cherche, dans l'ordre, dans les répertoires suivants pour trouver les
fichiers de données : le répertoire courant, le sous-répertoire "data"
du répertoire courant, le sous-répertoire ".freeciv" du répertoire
personnel de l'utilisateur et l'endroit où sont placés les fichiers en
lançant "make install". Vous pouvez forcer le chemin de recherche à
l'aide de la variable d'environnement FREECIV_DATA_PATH, qui doit être
positionnée sur un simple répertoire ou une liste de répertoires séparés
par des ":".

Par exemple :

  % setenv FREECIV_DATA_PATH "/usr/games/freeciv/data:./data"
  (pour les utilisateurs de csh, tcsh, etc.)

  % FREECIV_DATA_PATH="/usr/games/freeciv/data:./data"; export FREECIV_DATA_PATH
  (pour les utilisateurs de sh, bash, ksh, zsh, etc.)

Notez que vous devez généralement installer Freeciv si vous voulez
utiliser son support des langues étrangères. Consultez le fichier
README.fr pour plus de renseignements.


5. Support des langues étrangères :
===================================

Freeciv utilise le système "gettext" pour le support des langues
étrangères.

Si vous rencontrez des problèmes avec gettext en configurant ou
compilant Freeciv, il y a un certain nombre de choses que vous pouvez
tenter :

1. Si vous n'avez pas besoin de la localisation, désactivez la en
   utilisant l'option "--disable-nls" de ./configure :

      % ./configure --disable-nls
      % make

2. Vous pouvez essayer d'installer la dernière version de GNU
      gettext. Elle peut être obtenue ici :
      ftp://prep.ai.mit.edu/gnu/gettext/gettext-0.19.2.tar.xz


6. Support de Readline :
========================

Freeciv dispose d'un support optionnel pour la bibliothèque readline.

Le support de readline est ce qui permet à la ligne de commande du
serveur de se comporter raisonnablement, ce qui permet de :
- utiliser la touche d'effacement arrière
- utiliser le curseur pour se déplacer en avant et en arrière sur la
  ligne que vous avez écrite.
- utiliser TAB pour la complétion des commandes et des arguments de
  commandes - c'est-à-dire que quand vous pressez la touche de
  tabulation, le serveur finira le mot pour vous s'il n'y a qu'un seul
  choix possible.
- utiliser le curseur en haut et en bas pour faire défiler les
  commandes entrées auparavant.
- etc.

Le script configure vérifiera si vous avez installé correctement le
bibliothèque readline. Si c'est le cas, il ajustera automatiquement
les makefiles pour que readline soit compilée dans le serveur. Sinon,
il configurera juste silencieusement sans support de readline.
Vous pouvez forcer configure à inclure readline - ou à mourir en
essayant - en lui passant l'option --with-readline :

% ./configure --with-readline

Certaines distributions de Linux (et potentiellement d'autres systèmes
d'exploitation) ont une installation incorrecte de readline version 4,
de sorte que readline n'est pas configuré pour déclarer ses
dépendances dynamiques. Dans ce cas, configure essayera de deviner
à quelles bibliothèques supplémentaires il doit se lier et les
ajoutera. Le script configure émettra un avertissement s'il a dû
ajouter des bibliothèques supplémentaires pour faire fonctionner
readline. Ceci devrait être inoffensif, et est juste conçu comme un
rappel aux gens qui distribuent readline. :)


7. Notes de Reiner sur l'installation sous Solaris
==================================================

Solaris (2.5 et suivants) a sa propre version de X dans /usr/openwin,
sa propre version de make dans /usr/ccs/bin/make et son propre
compilateur (qui doit être acheté séparément) qui, si vous l'avez, est
dans /opt/SUNWspro/bin. De plus, Solaris ne fournit rien de ce qui est
requis pour imlib, gdk et gtk, ce qui est nécessaire pour construire
le client GTK+. Cependant, avec un peu de patience, tout peut être
compilé sans problème.

Vous pouvez régler votre $PATH et ./configure pour n'utiliser que des
outils GNU. De plus, Freeciv compile avec MIT X et avec certaines
combinaisons d'outils GNU et Sun. Les recettes exactes dépendent de
votre installation locale.

8. Notes Max OS X et Darwin :
=============================

La version Apple de GCC utilise des en-têtes précompilées qui ne
supportent pas les macro vararg (une extension GCC). Ceci fait échouer
GCC quand il compile Freeciv, puisque le compilateur est, mis à part
cela (quasi) identique au GCC de base. Donc, à la place de l'habituel

  % ./configure <...>

vous devriez utiliser soit

 Bourne shell:
   $ CC="gcc -no-cpp-precomp" ./configure <...>

ou

 C shell:
   % env CC="gcc -no-cpp-precomp" ./configure <...>

selon si votre shell est une variante Bourne shell ou C shell. (Si
vous aveun doute, essayez simplement les deux pour voir celui qui va
fonctionner.)

Remplacez <...> par tout argument supplémentaire que vous voulez
passer à configure.


9. Notes Windows :
==================

Une version de Freeciv pour Windows peut être construite soit avec
Msys2 ou Cygwin. Les binaires officiels Windows sont faits avec Msys2,
et ce sont des paquetages autonomes. Pour utiliser la version Cygwin,
vous aurez besoin d'un environnement Cygwin installé.

Les instructions de fabrication pour les versions Msys2 sont
documentées dans doc/README.msys2

Les notes d'installation spécifiques à Cygwin se trouvent dans
doc/INSTALL.Cygwin.

** FIN **
