ITK 5.3 Release Candidate 3 Release Notes: Documentation
=========================================================

We are happy to announce the [Insight Toolkit (ITK)](https://itk.org) 5.3 Release Candidate 3 is available for testing! :tada: ITK is an open-source, cross-platform toolkit for N-dimensional scientific image processing, segmentation, and registration.

ITK 5.3 is a feature release that accelerates performance, provides new segmentation and shape analysis algorithms, improves documentation, among many more improvements. For more information about performance improvements, see [the 5.3 RC 1 Release Notes](https://github.com/InsightSoftwareConsortium/ITK/releases/tag/v5.3rc01). For more information about new segmentation and shape analysis algorithms, see [the 5.3 RC 2 Release Notes](https://github.com/InsightSoftwareConsortium/ITK/releases/tag/v5.3rc02).

ITK 5.3 RC 3 highlights documentation improvements. The ITK Software Guide has been updated for ITK's modern C++ improvements. The guide now also includes a helpful primer for debugging native Python extension modules across platforms. The PDF's remain available for free download (links below), and an updated hardcopy can be purchased from Amazon. [ITK's Sphinx Examples](https://examples.itk.org/) were updated to the latest ITK and Sphinx. [Join us for a hackathon](https://discourse.itk.org/t/itk-examples-hackathon-2022/4913) to work on the examples on Friday, May 20th. [Doxygen API documentation](https://itk.org/Doxygen/html/index.html) now uses MathJax and SVG, and Doxygen HTML archives are significantly smaller.

ITK 5.3 RC 3 also includes FFT backend registration through the object factory, Python wrapping for more registration methods, metrics, and registration of point sets, and new remote modules to facilitate rendering of meshes and ITK filtering with CUDA. And, there any many more improvements and fixes detailed in the log below.


![](https://i.imgur.com/vIfAfgo.png)
In addition to the PDF's below, the ITK Software Guide for ITK 5.3 is available in hard copy form on Amazon. [Book 1](https://www.amazon.com/ITK-Software-Guide-Book-Introduction/dp/1930934351/ref=sr_1_1?crid=2QX94Z9HL8ZWH&keywords=itk+software+guide&qid=1652380626&sprefix=%2Caps%2C30&sr=8-1), [Book 2](https://www.amazon.com/ITK-Software-Guide-Book-Functionality/dp/193093436X/ref=sr_1_4?crid=2QX94Z9HL8ZWH&keywords=itk+software+guide&qid=1652380652&sprefix=%2Caps%2C30&sr=8-4).


Download
--------

**Python Packages**

Install [ITK Python packages](https://itkpythonpackage.readthedocs.io/en/latest/Quick_start_guide.html) with:

```
pip install --upgrade --pre itk
```


**Guide and Textbook**

- [InsightSoftwareGuide-Book1-5.3rc03.pdf](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3rc03/InsightSoftwareGuide-Book1-5.3rc03.pdf)
- [InsightSoftwareGuide-Book2-5.3rc03.pdf](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3rc03/InsightSoftwareGuide-Book2-5.3rc03.pdf)

**Library Sources**

- [InsightToolkit-5.3rc03.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3rc03/InsightToolkit-5.3rc03.tar.gz)
- [InsightToolkit-5.3rc03.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3rc03/InsightToolkit-5.3rc03.zip)

**Testing Data**

Unpack optional testing data in the same directory where the Library Source is unpacked.

- [InsightData-5.3rc03.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3rc03/InsightData-5.3rc03.tar.gz)
- [InsightData-5.3rc03.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3rc03/InsightData-5.3rc03.zip)

**Checksums**

- [MD5SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3rc03/MD5SUMS)
- [SHA512SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3rc03/SHA512SUMS)


Features
--------

### Python

- Python packages now include oneTBB support for improved performance.
- Following CPython's deprecation schedule Python 3.6 is no longer supported.
- Python packages added for Python 3.10
- Initial Python wrapping is available for the Video modules.
- `TransformToDisplacementField` is now available in Python.
- Pythonic IO functions `itk.imread` understands `pathlib.Path`'s
- New `repr` for `itk.Matrix`
- `np.asarray` works on `itk.Matrix`
- `DCMTKImageIO` wrapping addressed
- `GradientDifferenceImageToImageMetric` wrapped
- `SynImageRegistrationMethod`, `BSplineSynImageRegistrationMethod` wrapped
- `ConjugateGradientLineSearchOptimizerv4` wrapped
- Wrap `ImageRegistrationMethodv4` for `itk.Mesh`
- Wrap `PointSetToPointSetMetric`, `PointSetToPointSetRegistrationMethod`
- Wrap `ANTSNeighborhoodCorrelationImageToImageMetricv4`


### C++

- C++14 is now required.
- The minimum CMake version required is now 3.16.3.
- New functions: `MakePoint`, `MakeVector`, `MakeIndex`, `MakeSize`.
- Targets in Visual Studio and other IDE's are now organize hierachically by ITK Group and Module
- Most of `itk::mpl` meta-programming functions replaced by C++14 equivalents
- Performance accelerations for b-spline interpolation, Mattes mutual information metric computation
- Improved modern C++ adoption, e.g. additional adoption of `constexpr`, `auto`
- `itk::ReadMesh`, `itk::WriteMesh` simple reader functions available, similar to `itk::ReadImage`, `itk::WriteImage`
- FFT backends are now registered through the object factory mechanism

### New filters

- `itk::TransformGeometryImageFilter`: applies a rigid transform to an `Image`'s metadata.
- 1D FFT classes
    - Interface classes for forward, inverse transformations
    - Vnl implementations
    - FFTW implementations
- `itk::TriangleMeshCurvatureCalculator` - Gaussian curvature calculator for `itk::Mesh`

### Remote module updates

New remote modules:

- [HASI](https://github.com/KitwareMedical/HASI): High-Throughput Applications for Skeletal Imaging
- [ITKGrowCut](https://github.com/InsightSoftwareConsortium/ITKGrowCut): segments a 3D image from user-provided foreground and background seeds
- [ITKMeshToPolyData](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData): Convert an ITK Mesh to a simple data structure compatible with vtkPolyData
- [ITKCudaCommon](https://github.com/SimonRit/ITKCudaCommon): Framework for processing images with CUDA

Updated modules: *AdaptiveDenoising*, *AnisotropicDiffusionLBR*, *BSplineGradient*, *BoneEnhancement*, *BoneMorphometry*, *Cuberille*, *GrowCut*, *HASI*, *HigherOrderAccurateGradient*, *IOFDF*, *IOScanco*, *IsotropicWavelets*, *MinimalPathExtraction*, *Montage*, *MorphologicalContourInterpolation*, *RTK*, *SimpleITKFilters*, *SkullStrip*, *SplitComponents*, *Strain*, *TextureFeatures*, *Thickness3D*, *TotalVariation*, *TubeTK*, and *Ultrasound*.


### Third party library updates

- eigen
- expat
- fftw
- gdcm
- googletest
- hdf5
- kwsys
- kwiml
- minc
- metaio
- niftilib
- vxl
- zlib migrated to zlib-ng

### Congratulations

Congratulations and **thank you** to everyone who contributed to this release.

Of the *59 authors* who contributed since v5.2.0, we would like to specially recognize the new contributors:

*Michael Kuczynski, Tim Evain, Tomoyuki SADAKANE, Mario Emmenlauer, Andreas Gravgaard Andersen, Ebrahim Ebrahim, josempozo, Wenqi Li, Genevieve Buckley, Oleksandr Zavalistyi, Jose Tascon, Pranjal Sahu, ambrozicc1, Vagrant Cascadian, MrTzschr, Philip Cook, Tihomir Heidelberg, Jason Rudy, Kian Weimer, z0gSh1u, Darren Thompson, Darren, and Jose M Pozo.*


What's Next
-----------


We anticipate an additional release candidate following community testing before the 5.3.0 release. The following release candidate will provide an opportunity to test contributions for packaging, distributed computation, and GPU acceleration. Please try out the current release candidate, and discuss your experiences at [discourse.itk.org](https://discourse.itk.org). Contribute with pull requests, code reviews, and issue discussions in our [GitHub Organization](https://github.com/InsightSoftwareConsortium).

**Enjoy ITK!**

ITK Changes Since v5.3rc02
---------------------------------------------


### Bradley Lowekamp (20):

#### Enhancements

- Add valgrind suppression file for Ubuntu 20.04 ([af5dc21f77](https://github.com/InsightSoftwareConsortium/ITK/commit/af5dc21f77))
- Remove LBFGS2's pimpl member ([2f60979bbb](https://github.com/InsightSoftwareConsortium/ITK/commit/2f60979bbb))
- CircleCI use large resource class ([2cded6cf83](https://github.com/InsightSoftwareConsortium/ITK/commit/2cded6cf83))
- Update SimpleITKFilters remote module ([fd67bcc443](https://github.com/InsightSoftwareConsortium/ITK/commit/fd67bcc443))
- Doxygen use svg and mathjax ([a3a87b7b06](https://github.com/InsightSoftwareConsortium/ITK/commit/a3a87b7b06))
- remove rendering datetime with Doxygen into HTML footer ([510392c6ac](https://github.com/InsightSoftwareConsortium/ITK/commit/510392c6ac))
- Move factory registration code to separate file ([ab07c12492](https://github.com/InsightSoftwareConsortium/ITK/commit/ab07c12492))
- Add factory names as optional argument ([52c7d7479f](https://github.com/InsightSoftwareConsortium/ITK/commit/52c7d7479f))
- Use ITK_<factory_name>_FACTORY_REGISTER_MANAGER ([099b5621c8](https://github.com/InsightSoftwareConsortium/ITK/commit/099b5621c8))

#### Platform Fixes

- Update suppress for KWSYS change ([e723f6df36](https://github.com/InsightSoftwareConsortium/ITK/commit/e723f6df36))
- Fix bit shift overflow warning ([0501e417e2](https://github.com/InsightSoftwareConsortium/ITK/commit/0501e417e2))
- Fix sign comparison to unsigned warning ([b6246315ca](https://github.com/InsightSoftwareConsortium/ITK/commit/b6246315ca))
- fix WorkUnitInfo shadow warning ([68c607ed54](https://github.com/InsightSoftwareConsortium/ITK/commit/68c607ed54))

#### Bug Fixes

- fix uninitialized memory warning in PeriodicBoundaryCondition test ([f643a51f9c](https://github.com/InsightSoftwareConsortium/ITK/commit/f643a51f9c))
- Fix linking by making LBFGS2Optimizerv4 a template ([825bb36dc6](https://github.com/InsightSoftwareConsortium/ITK/commit/825bb36dc6))
- warning in TIFFImageIO with component bit depth reduction ([1d68414c4e](https://github.com/InsightSoftwareConsortium/ITK/commit/1d68414c4e))
- Enable using only FFT Factory Register Manager ([42b6023c1e](https://github.com/InsightSoftwareConsortium/ITK/commit/42b6023c1e))
- internal fix for itk_generate_factory_registration ([db89ee5260](https://github.com/InsightSoftwareConsortium/ITK/commit/db89ee5260))
- Include ITKFactoryRegistration in ITK build ([f5e8eed193](https://github.com/InsightSoftwareConsortium/ITK/commit/f5e8eed193))

#### Style Changes

- Use recursive FFT registration for N to 1 ([8350f9c8f9](https://github.com/InsightSoftwareConsortium/ITK/commit/8350f9c8f9))


### Dženan Zukić (31):

#### Enhancements

- add itk::Object::Register to the no-step-into list for VS2015+ ([60d20a29b3](https://github.com/InsightSoftwareConsortium/ITK/commit/60d20a29b3))
- expose STL constant begin/end iterator types ([e3b79dd0ab](https://github.com/InsightSoftwareConsortium/ITK/commit/e3b79dd0ab))
- add filter progress overflow check ([fa8e5c87ac](https://github.com/InsightSoftwareConsortium/ITK/commit/fa8e5c87ac))
- add a new ContinuousIntegration job: LinuxLegacyRemoved ([6853d63728](https://github.com/InsightSoftwareConsortium/ITK/commit/6853d63728))
- Update remote modules using a script ([f5898b9428](https://github.com/InsightSoftwareConsortium/ITK/commit/f5898b9428))
- make BresenhamLine test more sensitive to numerical problems ([ea72435239](https://github.com/InsightSoftwareConsortium/ITK/commit/ea72435239))
- reduce code duplication by reusing code from ImageIOBase ([7a0599ccdb](https://github.com/InsightSoftwareConsortium/ITK/commit/7a0599ccdb))
- itkMGHImageIO moved to InsightSoftwareConsortium ([f84c9ef090](https://github.com/InsightSoftwareConsortium/ITK/commit/f84c9ef090))
- modify rasterizer Test2 to exercise negative indices ([cd8a17cb9c](https://github.com/InsightSoftwareConsortium/ITK/commit/cd8a17cb9c))
- use the new CMake mechanism to specify MSVC's static or DLL CRT ([4b010e724d](https://github.com/InsightSoftwareConsortium/ITK/commit/4b010e724d))
- Update MINC UpdateFromUpstream.sh to use update-third-party.bash ([fc46ec6bce](https://github.com/InsightSoftwareConsortium/ITK/commit/fc46ec6bce))
- Better progress reporting for 3 LabelMap filters ([e3d4021d2a](https://github.com/InsightSoftwareConsortium/ITK/commit/e3d4021d2a))
- Make progress more accurate in case of filter restarts ([6f238108a1](https://github.com/InsightSoftwareConsortium/ITK/commit/6f238108a1))
- Improve progress for GradientMagnitudeRecursiveGaussianImageFilter ([6c32f95d77](https://github.com/InsightSoftwareConsortium/ITK/commit/6c32f95d77))
- Avoid repeating progress in pool multi threader ([ecd025e181](https://github.com/InsightSoftwareConsortium/ITK/commit/ecd025e181))
- Simplify LabelMapToLabelImageFilter slightly ([11eb20b344](https://github.com/InsightSoftwareConsortium/ITK/commit/11eb20b344))
- Add a test for reading float vector image as Image<Vector<double>> ([df6e287ad1](https://github.com/InsightSoftwareConsortium/ITK/commit/df6e287ad1))

#### Documentation Updates

- improve description of BresenhamLine ([bc0d7a7940](https://github.com/InsightSoftwareConsortium/ITK/commit/bc0d7a7940))

#### Platform Fixes

- Turning off EZMINC option in libMINC ([da253550db](https://github.com/InsightSoftwareConsortium/ITK/commit/da253550db))

#### Bug Fixes

- fix a crash in QuadEdgeMeshFilter tests ([759b8ffa17](https://github.com/InsightSoftwareConsortium/ITK/commit/759b8ffa17))
- fix filter progress overflowing due to bad logic in atomic add ([840bae7174](https://github.com/InsightSoftwareConsortium/ITK/commit/840bae7174))
- Enforce strictly positive image spacing values ([17a1266e8f](https://github.com/InsightSoftwareConsortium/ITK/commit/17a1266e8f))
- BresenhamLine was producing more indices than necessary ([5edff15fc9](https://github.com/InsightSoftwareConsortium/ITK/commit/5edff15fc9))
- fix handling of negative and non-zero region indices in rasterizer ([0756bd3ad6](https://github.com/InsightSoftwareConsortium/ITK/commit/0756bd3ad6))
- Filter's progress would sometimes regress ([0eb55f2a91](https://github.com/InsightSoftwareConsortium/ITK/commit/0eb55f2a91))
- BinaryGeneratorImageFilter's progress did not reach 1.0 ([5c6497fad7](https://github.com/InsightSoftwareConsortium/ITK/commit/5c6497fad7))
- properly serialize output in SimpleFilterWatcher ([a3a8a33b28](https://github.com/InsightSoftwareConsortium/ITK/commit/a3a8a33b28))
- Avoid duplicate progress reporting in general case ([f09104d503](https://github.com/InsightSoftwareConsortium/ITK/commit/f09104d503))
- Do not refuse to read images of vectors with many components ([54926893bc](https://github.com/InsightSoftwareConsortium/ITK/commit/54926893bc))

#### Style Changes

- Simplify GradientMagnitudeRecursiveGaussianFilterTest ([83d2379ea2](https://github.com/InsightSoftwareConsortium/ITK/commit/83d2379ea2))
- Standardize parameter names to argc and *argv[], replace ac/av ([103e0a9329](https://github.com/InsightSoftwareConsortium/ITK/commit/103e0a9329))


### Eigen Upstream (1):

#### Miscellaneous Changes

- Eigen3 2022-01-10 (332b838c) ([a2662ce136](https://github.com/InsightSoftwareConsortium/ITK/commit/a2662ce136))


### Genevieve Buckley (1):

#### Enhancements

- pickle serialization for itk images (issue 1091) ([27242f4aa5](https://github.com/InsightSoftwareConsortium/ITK/commit/27242f4aa5))


### HDF5 Maintainers (1):

#### Miscellaneous Changes

- HDF5 2021-07-06 (820695a7) ([43cb3bb988](https://github.com/InsightSoftwareConsortium/ITK/commit/43cb3bb988))


### Hans Johnson (40):

#### Enhancements

- Allow users to have a CMakeUserPresets.json file ([e32e05ac31](https://github.com/InsightSoftwareConsortium/ITK/commit/e32e05ac31))
- Use build tree working directories ([9e41a45038](https://github.com/InsightSoftwareConsortium/ITK/commit/9e41a45038))
- Removing circular header includes ([836210b23e](https://github.com/InsightSoftwareConsortium/ITK/commit/836210b23e))

#### Documentation Updates

- Add project documentation supported by mordern cmake ([0d9fdf455c](https://github.com/InsightSoftwareConsortium/ITK/commit/0d9fdf455c))

#### Platform Fixes

- Use modern macro name for GetModifiableObjectMacro ([7fdb6d6ced](https://github.com/InsightSoftwareConsortium/ITK/commit/7fdb6d6ced))
- Remove processing missing Ruby directories. ([0afe97d0e7](https://github.com/InsightSoftwareConsortium/ITK/commit/0afe97d0e7))
- Conditional build logic for WRAP_PYTHON ([758ad339cb](https://github.com/InsightSoftwareConsortium/ITK/commit/758ad339cb))
- Working directory must pre-exist ([36ffcf9045](https://github.com/InsightSoftwareConsortium/ITK/commit/36ffcf9045))
- Remove implicit conversions ([bf2e67a6ad](https://github.com/InsightSoftwareConsortium/ITK/commit/bf2e67a6ad))
- Allow use of older system vxl ([04012696bc](https://github.com/InsightSoftwareConsortium/ITK/commit/04012696bc))
- Duplicate symbol name with #define ([d75910d150](https://github.com/InsightSoftwareConsortium/ITK/commit/d75910d150))
- Include .h instead of .hxx file ([8976a581fc](https://github.com/InsightSoftwareConsortium/ITK/commit/8976a581fc))
- Place public interface in .h file ([09926f0f5a](https://github.com/InsightSoftwareConsortium/ITK/commit/09926f0f5a))
- Remove inclusion of .hxx files as headers ([aafd1f9631](https://github.com/InsightSoftwareConsortium/ITK/commit/aafd1f9631))
- Modernize searching in list ([b524b12093](https://github.com/InsightSoftwareConsortium/ITK/commit/b524b12093))
- Simplify H5Tinit.c file generation ([568e311d4a](https://github.com/InsightSoftwareConsortium/ITK/commit/568e311d4a))
- Allow ITK to manage cmake_minimum_required version ([452b99c241](https://github.com/InsightSoftwareConsortium/ITK/commit/452b99c241))
- Remove redundant cmake_policy setting ([d51f29c28d](https://github.com/InsightSoftwareConsortium/ITK/commit/d51f29c28d))
- Hard-code HDF5 options to suppress messages ([3780d66798](https://github.com/InsightSoftwareConsortium/ITK/commit/3780d66798))
- Macro redefinition on windows ([7aa5646a8f](https://github.com/InsightSoftwareConsortium/ITK/commit/7aa5646a8f))

#### Bug Fixes

- Fix constexpr linkage issue ([ad86850385](https://github.com/InsightSoftwareConsortium/ITK/commit/ad86850385))
- Ensure that the itk-stub dir exists ([f732f05f24](https://github.com/InsightSoftwareConsortium/ITK/commit/f732f05f24))
- Condition building python stubs on python wrapping ([4f33aab02e](https://github.com/InsightSoftwareConsortium/ITK/commit/4f33aab02e))
- Syntax bug in ruby wrapping code ([9ba7322376](https://github.com/InsightSoftwareConsortium/ITK/commit/9ba7322376))
- Test configured an invalid image spacing ([d80b751c6c](https://github.com/InsightSoftwareConsortium/ITK/commit/d80b751c6c))
- Conditional python 3.8 code optional ([c779d09bc6](https://github.com/InsightSoftwareConsortium/ITK/commit/c779d09bc6))
- setting unused variable named '0' from macro ([0b8a2ec2a3](https://github.com/InsightSoftwareConsortium/ITK/commit/0b8a2ec2a3))

#### Style Changes

- Use correct type for boolean expressions ([b379d1c1c7](https://github.com/InsightSoftwareConsortium/ITK/commit/b379d1c1c7))
- Fix minor spelling error ([e31d336943](https://github.com/InsightSoftwareConsortium/ITK/commit/e31d336943))
- Address clang-tidy warnings in itkNumericTraitsTest.cxxv ([89f1bca360](https://github.com/InsightSoftwareConsortium/ITK/commit/89f1bca360))
- Remove IsInteger and replace with std::is_integer ([b3f80bb295](https://github.com/InsightSoftwareConsortium/ITK/commit/b3f80bb295))
- Remove IsSigned and replace with std::is_signed ([da13473cb0](https://github.com/InsightSoftwareConsortium/ITK/commit/da13473cb0))
- Prefer itk::Math::abs over abs or fabs ([d715b098ba](https://github.com/InsightSoftwareConsortium/ITK/commit/d715b098ba))
- Allow use of clang-tidy as part of cmake compilation ([55db25c240](https://github.com/InsightSoftwareConsortium/ITK/commit/55db25c240))
- Do not use double underscore defines ([191e122087](https://github.com/InsightSoftwareConsortium/ITK/commit/191e122087))
- Remove recursive inclusion of .h files ([f84720ee08](https://github.com/InsightSoftwareConsortium/ITK/commit/f84720ee08))
- Include .hxx files inside .h header guards ([70351d1fe4](https://github.com/InsightSoftwareConsortium/ITK/commit/70351d1fe4))
- Use simplified modern cmake directive ([6da612134b](https://github.com/InsightSoftwareConsortium/ITK/commit/6da612134b))
- Disable MSVC settings for non-MSVC ([8cf8bf3632](https://github.com/InsightSoftwareConsortium/ITK/commit/8cf8bf3632))
- Allow hdf5 to specify it's own clang-format ([c73b9f0884](https://github.com/InsightSoftwareConsortium/ITK/commit/c73b9f0884))


### James Butler (1):

#### Documentation Updates

- Fix possessive "its" usage ([b69598e23c](https://github.com/InsightSoftwareConsortium/ITK/commit/b69598e23c))


### Jon Haitz Legarreta Gorroño (52):

#### Enhancements

- Use latest `checkout` release in `clang-format linter` workflow ([091a1ab635](https://github.com/InsightSoftwareConsortium/ITK/commit/091a1ab635))
- Avoid setting a negative spacing to test exception ([5f85a5de85](https://github.com/InsightSoftwareConsortium/ITK/commit/5f85a5de85))
- Increase code coverage ([58f738a8c4](https://github.com/InsightSoftwareConsortium/ITK/commit/58f738a8c4))
- Add wrapping for `itk::GradientDifferenceImageToImageMetric` ([7e60a39968](https://github.com/InsightSoftwareConsortium/ITK/commit/7e60a39968))
- Increase `itk::ImageBase` coverage ([217c0d4084](https://github.com/InsightSoftwareConsortium/ITK/commit/217c0d4084))
- Add RTTI to `itk::InvertDisplacementFieldImageFilter` ([0f2fe8f986](https://github.com/InsightSoftwareConsortium/ITK/commit/0f2fe8f986))
- Increase coverage for `ImageStatistics` module classes ([a0c32bbe61](https://github.com/InsightSoftwareConsortium/ITK/commit/a0c32bbe61))
- Add boolean macros to miscellaneous boolean ivars ([ce00b06dfe](https://github.com/InsightSoftwareConsortium/ITK/commit/ce00b06dfe))
- Use `itkPrintSelfObjectMacro` to print objects that can be null ([5d860e62a9](https://github.com/InsightSoftwareConsortium/ITK/commit/5d860e62a9))
- Add boolean macros to `itk::SpatialObjectWriter` boolean ivars ([ac7272c04c](https://github.com/InsightSoftwareConsortium/ITK/commit/ac7272c04c))
- Add boolean macros for `itk::JPEGImageIO` boolean ivars ([d4c6b33f67](https://github.com/InsightSoftwareConsortium/ITK/commit/d4c6b33f67))
- Exercise basic object methods for `itk::JPEGImageIO` ([7408df465a](https://github.com/InsightSoftwareConsortium/ITK/commit/7408df465a))
- Increase coverage for miscellaneous classes ([748ddf7768](https://github.com/InsightSoftwareConsortium/ITK/commit/748ddf7768))
- Use `itkPrintSelfObjectMacro` to print objects that can be null ([ffe6b2ccc1](https://github.com/InsightSoftwareConsortium/ITK/commit/ffe6b2ccc1))
- Add RTTI to `itk::DisplacementFieldToBSplineImageFilter` ([57ef2ac9f5](https://github.com/InsightSoftwareConsortium/ITK/commit/57ef2ac9f5))
- Increase coverage for miscellaneous classes ([5deb0c39cf](https://github.com/InsightSoftwareConsortium/ITK/commit/5deb0c39cf))
- Add getter macro to ivar ([48eacfe518](https://github.com/InsightSoftwareConsortium/ITK/commit/48eacfe518))
- Add missing getter/boolean macro methods ([4db7880575](https://github.com/InsightSoftwareConsortium/ITK/commit/4db7880575))
- Increase coverage for miscellaneous classes ([e2511e7c0f](https://github.com/InsightSoftwareConsortium/ITK/commit/e2511e7c0f))

#### Documentation Updates

- Fix typos and improve grammar ([b14b95ab5e](https://github.com/InsightSoftwareConsortium/ITK/commit/b14b95ab5e))
- Fix typo in comment ([3687637deb](https://github.com/InsightSoftwareConsortium/ITK/commit/3687637deb))
- Fix `itk::BuildInformation` class documentation typo ([77557e7fd4](https://github.com/InsightSoftwareConsortium/ITK/commit/77557e7fd4))
- Fix Insight Journal reference typos ([291ee7b685](https://github.com/InsightSoftwareConsortium/ITK/commit/291ee7b685))

#### Platform Fixes

- Fix `abs` method not being found ([b655b02ce8](https://github.com/InsightSoftwareConsortium/ITK/commit/b655b02ce8))
- Use and move ITK_DISALLOW_COPY_AND_MOVE calls to public section ([ac1d0aa1ef](https://github.com/InsightSoftwareConsortium/ITK/commit/ac1d0aa1ef))
- Fix testing macro call and array initialization errors ([7e37b19646](https://github.com/InsightSoftwareConsortium/ITK/commit/7e37b19646))
- Fix spline order return type in getter macro ([8683d4254e](https://github.com/InsightSoftwareConsortium/ITK/commit/8683d4254e))
- Fix variable type and syntax errors ([109047a2e9](https://github.com/InsightSoftwareConsortium/ITK/commit/109047a2e9))
- Fix missing initialization braces warning ([98bc61493f](https://github.com/InsightSoftwareConsortium/ITK/commit/98bc61493f))

#### Bug Fixes

- Remove declared but undefined method ([98e030b20d](https://github.com/InsightSoftwareConsortium/ITK/commit/98e030b20d))
- Disallow zero-valued determinant directions ([c4960ee19c](https://github.com/InsightSoftwareConsortium/ITK/commit/c4960ee19c))
- Fix class names in `itkTypeMacro` ([ed0f6d3cf2](https://github.com/InsightSoftwareConsortium/ITK/commit/ed0f6d3cf2))
- Fix superclass name in `itkTypeMacro` ([2d63eb0aa0](https://github.com/InsightSoftwareConsortium/ITK/commit/2d63eb0aa0))
- Do not print non-self member variables in `PrintSelf` ([44e3199900](https://github.com/InsightSoftwareConsortium/ITK/commit/44e3199900))
- Fix superclass name in `itkTypeMacro` ([9175d4ca68](https://github.com/InsightSoftwareConsortium/ITK/commit/9175d4ca68))
- Use the superclass name in `itkTypeMacro` ([8e1220c538](https://github.com/InsightSoftwareConsortium/ITK/commit/8e1220c538))
- Fix superclass name in itkTypeMacro ([007970e369](https://github.com/InsightSoftwareConsortium/ITK/commit/007970e369))
- Guarantee array contains enough elements for access in loop ([90f7396296](https://github.com/InsightSoftwareConsortium/ITK/commit/90f7396296))
- Initialize `itk::ExhaustiveOptimizer` ivars ([bd55ef3f7d](https://github.com/InsightSoftwareConsortium/ITK/commit/bd55ef3f7d))
- Initialize `itk::Array` variable values in test ([06d5ed1d10](https://github.com/InsightSoftwareConsortium/ITK/commit/06d5ed1d10))

#### Style Changes

- Make `ImageLabel` and `ImageNoise` modules test style consistent ([922ff82a1c](https://github.com/InsightSoftwareConsortium/ITK/commit/922ff82a1c))
- Use the `itkNameOfTestExecutableMacro` macro in tests ([7997ef3eaa](https://github.com/InsightSoftwareConsortium/ITK/commit/7997ef3eaa))
- Use `argc` and `argv` to name test argument variables ([03a3af21ef](https://github.com/InsightSoftwareConsortium/ITK/commit/03a3af21ef))
- Use local include syntax to include ITK files ([05d48c66cd](https://github.com/InsightSoftwareConsortium/ITK/commit/05d48c66cd))
- Use exit return codes consistently in tests ([a98f7a898e](https://github.com/InsightSoftwareConsortium/ITK/commit/a98f7a898e))
- Use auto for variables initialized by `New()` in Examples ([2f291f8dc5](https://github.com/InsightSoftwareConsortium/ITK/commit/2f291f8dc5))
- Use the `itkNameOfTestExecutableMacro` macro in tests ([706ff726cc](https://github.com/InsightSoftwareConsortium/ITK/commit/706ff726cc))
- Improve the `JPEG` module tests' style ([bc3ac22332](https://github.com/InsightSoftwareConsortium/ITK/commit/bc3ac22332))
- Use strongly typed enum class ostream overload in `PrintSelf` ([69b4178dc7](https://github.com/InsightSoftwareConsortium/ITK/commit/69b4178dc7))
- Use the `itkNameOfTestExecutableMacro` macro in tests ([82520a8db9](https://github.com/InsightSoftwareConsortium/ITK/commit/82520a8db9))
- Use the superclass name in itkTypeMacro ([6a1575d68c](https://github.com/InsightSoftwareConsortium/ITK/commit/6a1575d68c))
- Prefer returning `int` instead of `bool` in test method ([8fa5a8041e](https://github.com/InsightSoftwareConsortium/ITK/commit/8fa5a8041e))


### Jose M Pozo (3):

#### Enhancements

- Add test for inverse Jacobian of AffineTransform. ([7c7233f0b3](https://github.com/InsightSoftwareConsortium/ITK/commit/7c7233f0b3))

#### Bug Fixes

- ComputeInverseJacobianWithRespectToPosition didn't do inversion ([9111b93afa](https://github.com/InsightSoftwareConsortium/ITK/commit/9111b93afa))

#### Style Changes

- auto declarator when initializing with New() ([dd7d0d6cf0](https://github.com/InsightSoftwareConsortium/ITK/commit/dd7d0d6cf0))


### KWSys Upstream (1):

#### Miscellaneous Changes

- KWSys 2021-11-01 (572f2a65) ([59cf980b33](https://github.com/InsightSoftwareConsortium/ITK/commit/59cf980b33))


### Kian Weimer (5):

#### Enhancements

- Generate stub-files to support type hints ([faa3ab0a7e](https://github.com/InsightSoftwareConsortium/ITK/commit/faa3ab0a7e))

#### Platform Fixes

- Initialized derivs array to zero. ([06b1be939f](https://github.com/InsightSoftwareConsortium/ITK/commit/06b1be939f))

#### Bug Fixes

- Generate itk-stubs file before running igenerator.py. ([8bfd35bb4a](https://github.com/InsightSoftwareConsortium/ITK/commit/8bfd35bb4a))
- Corrected .pyi output file names in custom command. ([d8fa6abc35](https://github.com/InsightSoftwareConsortium/ITK/commit/d8fa6abc35))
- Prevented duplicate pyi definition generation in igenerator.pyi. ([3820b1cb00](https://github.com/InsightSoftwareConsortium/ITK/commit/3820b1cb00))


### Lee Newberg (3):

#### Performance Improvements

- Use binary search for threshold in ThresholdLabelerImageFilter ([340f6f4064](https://github.com/InsightSoftwareConsortium/ITK/commit/340f6f4064))

#### Platform Fixes

- Fix unsigned<0 warning for itkSetClampMacro. ([b11a9981b9](https://github.com/InsightSoftwareConsortium/ITK/commit/b11a9981b9))

#### Style Changes

- Removing extraneous colons from '::itk' and '::std'. ([24e7b452b4](https://github.com/InsightSoftwareConsortium/ITK/commit/24e7b452b4))


### Lucas Gandel (1):

#### Enhancements

- Load and execute modules __init__ file ([3084580381](https://github.com/InsightSoftwareConsortium/ITK/commit/3084580381))


### Mario Emmenlauer (1):

#### Enhancements

- Added template parameter for texture mask type ([9273616e19](https://github.com/InsightSoftwareConsortium/ITK/commit/9273616e19))


### Matt McCormick (13):

#### Enhancements

- Wrap SynImageRegistrationMethod, BSplineSynImageRegistrationMethod ([3e27a46124](https://github.com/InsightSoftwareConsortium/ITK/commit/3e27a46124))
- Add itk::ReadMesh ([eb98045d6d](https://github.com/InsightSoftwareConsortium/ITK/commit/eb98045d6d))
- Add itk::WriteMesh ([bd2a2e484d](https://github.com/InsightSoftwareConsortium/ITK/commit/bd2a2e484d))
- Add checks to itkMeshFileReaderWriterTest ([b00d11bf00](https://github.com/InsightSoftwareConsortium/ITK/commit/b00d11bf00))
- Use literate identifiers in Dask serialization. ([c99232aa06](https://github.com/InsightSoftwareConsortium/ITK/commit/c99232aa06))
- Add MeshToPolyData remote module ([8ecef7b8a0](https://github.com/InsightSoftwareConsortium/ITK/commit/8ecef7b8a0))
- Content link updates for ITK 5.3rc03 ([590dd29f00](https://github.com/InsightSoftwareConsortium/ITK/commit/590dd29f00))

#### Platform Fixes

- Use nifti_clib master ([6105ebd2e7](https://github.com/InsightSoftwareConsortium/ITK/commit/6105ebd2e7))

#### Bug Fixes

- Create CellData when requested in Mesh::GetCellData ([3474342014](https://github.com/InsightSoftwareConsortium/ITK/commit/3474342014))
- Provide consistent shape on Fortran-order np.ndarray views ([a4419d8259](https://github.com/InsightSoftwareConsortium/ITK/commit/a4419d8259))

#### Style Changes

- Use keyword style for HeaderTest target_link_libraries ([1a599f4d2f](https://github.com/InsightSoftwareConsortium/ITK/commit/1a599f4d2f))
- Move type declaration into itkMeshCellDataTest function ([fa2a3a2f3b](https://github.com/InsightSoftwareConsortium/ITK/commit/fa2a3a2f3b))
- Remove old FFT 1D implementation includes ([6eaa4623e1](https://github.com/InsightSoftwareConsortium/ITK/commit/6eaa4623e1))


### Mihail Isakov (14):

#### Enhancements

- JPEG IO: check integer overflow ([de5f8e8513](https://github.com/InsightSoftwareConsortium/ITK/commit/de5f8e8513))
- add a test for verifying a JPEG image is corrupted and throws ([4f770cb6bd](https://github.com/InsightSoftwareConsortium/ITK/commit/4f770cb6bd))

#### Bug Fixes

- fixed undefined behaviour with corrupted JPEG file ([d43311d3e9](https://github.com/InsightSoftwareConsortium/ITK/commit/d43311d3e9))
- GDCM IO: reset internal variables ([d9f4b77b65](https://github.com/InsightSoftwareConsortium/ITK/commit/d9f4b77b65))
- PNG IO fails on corrupt file ([31ce397623](https://github.com/InsightSoftwareConsortium/ITK/commit/31ce397623))
- JPEG IO: only allow 8 bits ([f28dcb1087](https://github.com/InsightSoftwareConsortium/ITK/commit/f28dcb1087))
- JPEG IO: disallow UINT input images ([b4a6a21b14](https://github.com/InsightSoftwareConsortium/ITK/commit/b4a6a21b14))
- JPEG IO: ensure same dimensions in Read and ReadImageInfo ([e45f3edef8](https://github.com/InsightSoftwareConsortium/ITK/commit/e45f3edef8))
- JPEG IO: set correct max dimensions ([07214e8ad5](https://github.com/InsightSoftwareConsortium/ITK/commit/07214e8ad5))
- JPEG IO: handle all possible number of components ([139fa77ce4](https://github.com/InsightSoftwareConsortium/ITK/commit/139fa77ce4))
- JPEG IO: delete pointer on setjmp, other ([a9c38a0fa2](https://github.com/InsightSoftwareConsortium/ITK/commit/a9c38a0fa2))
- JPEG IO: handle CMYK correctly ([ca4babd252](https://github.com/InsightSoftwareConsortium/ITK/commit/ca4babd252))

#### Style Changes

- updated error message, improved size check ([bb759349a2](https://github.com/InsightSoftwareConsortium/ITK/commit/bb759349a2))
- OpenJPEG: removed outdated comment ([9da82ba301](https://github.com/InsightSoftwareConsortium/ITK/commit/9da82ba301))


### NIFTI Upstream (1):

#### Miscellaneous Changes

- nifti 2021-10-26 (53f295cf) ([af75181f29](https://github.com/InsightSoftwareConsortium/ITK/commit/af75181f29))


### Niels Dekker (23):

#### Enhancements

- Make Parameters empty, do not warn in Transform default-constructor ([20249ece00](https://github.com/InsightSoftwareConsortium/ITK/commit/20249ece00))
- Test BuildInformation GetValue, GetDescription for an l-value `key` ([d6778a3d22](https://github.com/InsightSoftwareConsortium/ITK/commit/d6778a3d22))

#### Performance Improvements

- Use the faster `TransformPhysicalPointToIndex` overload in filter ([eb6ac88c82](https://github.com/InsightSoftwareConsortium/ITK/commit/eb6ac88c82))
- Use the faster `TransformPhysicalPointToContinuousIndex` overload ([6a8569ef11](https://github.com/InsightSoftwareConsortium/ITK/commit/6a8569ef11))

#### Platform Fixes

- No longer disable MSVC warning C4503 on "decorated name length" ([1bba12cf10](https://github.com/InsightSoftwareConsortium/ITK/commit/1bba12cf10))
- Fix unreachable code ([af32a779c4](https://github.com/InsightSoftwareConsortium/ITK/commit/af32a779c4))
- No longer delete (`= delete`) PreFillDirection() function template ([a328737726](https://github.com/InsightSoftwareConsortium/ITK/commit/a328737726))
- Fix BuildInformation GetValue, GetDescription `key` parameter type ([7324ffe083](https://github.com/InsightSoftwareConsortium/ITK/commit/7324ffe083))

#### Bug Fixes

- Add missing single argument ImageAdaptor Transform member functions ([2d06a6a583](https://github.com/InsightSoftwareConsortium/ITK/commit/2d06a6a583))

#### Style Changes

- Do not do `return;` directly after throwing an exception ([ad64a79f65](https://github.com/InsightSoftwareConsortium/ITK/commit/ad64a79f65))
- Use the faster `TransformPhysicalPointToIndex` overload in tests ([c1f266aa75](https://github.com/InsightSoftwareConsortium/ITK/commit/c1f266aa75))
- Remove `TimeStamp` default-constructor, assignment (Rule of Zero) ([83f6cab3c4](https://github.com/InsightSoftwareConsortium/ITK/commit/83f6cab3c4))
- Remove dead code (#else...#endif) BSplineInterpolateImageFunction ([0c87e1f9fc](https://github.com/InsightSoftwareConsortium/ITK/commit/0c87e1f9fc))
- Move BSplineInterpolateImageFunction member functions into class ([d832119218](https://github.com/InsightSoftwareConsortium/ITK/commit/d832119218))
- Use unique_ptr for threaded BSplineInterpolateImageFunction data ([3923f261c3](https://github.com/InsightSoftwareConsortium/ITK/commit/3923f261c3))
- Use `unique_ptr` for `ImageToImageMetric` data members ([3c6f2984df](https://github.com/InsightSoftwareConsortium/ITK/commit/3c6f2984df))
- Use `Transform` default-constructor instead of `Transform(0)` ([1d119967ce](https://github.com/InsightSoftwareConsortium/ITK/commit/1d119967ce))
- Remove remaining `void` from empty function parameter lists ([93d3f3b3c0](https://github.com/InsightSoftwareConsortium/ITK/commit/93d3f3b3c0))
- Declare local `ImageRegion` variables `const` ([ac3156140b](https://github.com/InsightSoftwareConsortium/ITK/commit/ac3156140b))
- Clean-up default-constructed local `inputRegion` variables ([55eb65b3c6](https://github.com/InsightSoftwareConsortium/ITK/commit/55eb65b3c6))
- Declare local zero-filled `Index` variables `constexpr` ([c46354736b](https://github.com/InsightSoftwareConsortium/ITK/commit/c46354736b))
- Code clean-up initializing local `ImageRegion` variables ([f9cef65782](https://github.com/InsightSoftwareConsortium/ITK/commit/f9cef65782))
- ConstNeighborhoodIterator in-class default member initializers ([0eac1bdb6b](https://github.com/InsightSoftwareConsortium/ITK/commit/0eac1bdb6b))


### Pablo Hernandez-Cerdan (3):

#### Enhancements

- Update Eigen3 to 3.4 ([2b82b7755c](https://github.com/InsightSoftwareConsortium/ITK/commit/2b82b7755c))

#### Platform Fixes

- Disable Eigen3 warning Wused-but-marked-unused ([9d9b4165c3](https://github.com/InsightSoftwareConsortium/ITK/commit/9d9b4165c3))

#### Miscellaneous Changes

- Revert "ENH: Updated script for Eigen third party update" ([f3d7c99d77](https://github.com/InsightSoftwareConsortium/ITK/commit/f3d7c99d77))


### Pranjal Sahu (23):

#### Enhancements

- Adding python wrapping for ConjugateGradientLineSearchOptimizerv4 ([028c37c6fe](https://github.com/InsightSoftwareConsortium/ITK/commit/028c37c6fe))
- Adding Gaussian Curvature Calculator in ITK Mesh with tests ([5f180c6e41](https://github.com/InsightSoftwareConsortium/ITK/commit/5f180c6e41))
- Removing relative header imports from multiple cxx files ([ebc115e41e](https://github.com/InsightSoftwareConsortium/ITK/commit/ebc115e41e))
- Adding Python Wrapping for itkImageRegistrationMethodv4 with Mesh ([fab7112d91](https://github.com/InsightSoftwareConsortium/ITK/commit/fab7112d91))
- Triangle Cell Casting and Raw Pointer for Wrapping ([f57fe85b06](https://github.com/InsightSoftwareConsortium/ITK/commit/f57fe85b06))
- Adding Tests for Non-Triangle Mesh ([18005c81eb](https://github.com/InsightSoftwareConsortium/ITK/commit/18005c81eb))
- Wrapping only for 3D ([05ae9a5061](https://github.com/InsightSoftwareConsortium/ITK/commit/05ae9a5061))
- Wrap PointSet To PointSet Metric and RegistrationMethod ([b23d73ef96](https://github.com/InsightSoftwareConsortium/ITK/commit/b23d73ef96))
- Python Wrapping for Array PixelType in Mesh ([abb1d19328](https://github.com/InsightSoftwareConsortium/ITK/commit/abb1d19328))
- Adding Test for Array PixelType in Mesh Wrapping ([d85bb67249](https://github.com/InsightSoftwareConsortium/ITK/commit/d85bb67249))
- Adding Python wrapping for CellInterface VectorContainer ([b3fb53f979](https://github.com/InsightSoftwareConsortium/ITK/commit/b3fb53f979))
- Adding Python Wrapping for SyNImageRegistrationMethod ([653ab122ea](https://github.com/InsightSoftwareConsortium/ITK/commit/653ab122ea))
- Adding Mesh in SwigInputGenerator notWrapped list ([63239c68f2](https://github.com/InsightSoftwareConsortium/ITK/commit/63239c68f2))
- Adding test for itkConnectedRegionsMeshFilter ([4bf1434852](https://github.com/InsightSoftwareConsortium/ITK/commit/4bf1434852))
- Renaming ExtractMeshConectedRegionsTest ([232c9c7f26](https://github.com/InsightSoftwareConsortium/ITK/commit/232c9c7f26))
- Adding Module dependency for Python test ([aec78197f5](https://github.com/InsightSoftwareConsortium/ITK/commit/aec78197f5))

#### Platform Fixes

- Read Only access to GaussCurvatureData ([42160f8434](https://github.com/InsightSoftwareConsortium/ITK/commit/42160f8434))
- Delete cell before SetCell to avoid memory leak ([0cf2c13709](https://github.com/InsightSoftwareConsortium/ITK/commit/0cf2c13709))
- Use itk.ULL for windows ([7e59d1bf73](https://github.com/InsightSoftwareConsortium/ITK/commit/7e59d1bf73))

#### Bug Fixes

- Correct Name Mangling for BSplineSmoothing DisplacementFieldTransform ([2b56a143e9](https://github.com/InsightSoftwareConsortium/ITK/commit/2b56a143e9))
- Fix for incorrect number of connected regions ([6746880dea](https://github.com/InsightSoftwareConsortium/ITK/commit/6746880dea))
- Fix for incorrect cell extraction when SpecifiedRegions ([91c27ff30f](https://github.com/InsightSoftwareConsortium/ITK/commit/91c27ff30f))
- Fix for incorrect number of cells in output mesh ([94df2c14d4](https://github.com/InsightSoftwareConsortium/ITK/commit/94df2c14d4))


### Sean McBride (21):

#### Enhancements

- Use std::once_flag for GlobalSingletonIndexInitializer ([bd8adf987b](https://github.com/InsightSoftwareConsortium/ITK/commit/bd8adf987b))
- eliminate last uses of kwiml ([1ac26e7231](https://github.com/InsightSoftwareConsortium/ITK/commit/1ac26e7231))
- delete kwiml now that nothing uses it ([3a4fbd65a7](https://github.com/InsightSoftwareConsortium/ITK/commit/3a4fbd65a7))
- Repoint HDF5 from 1.10.7 tag to hdf5_1_10 branch ([33eaada395](https://github.com/InsightSoftwareConsortium/ITK/commit/33eaada395))
- tag=hdf5-1_12_1 ([95b3437a43](https://github.com/InsightSoftwareConsortium/ITK/commit/95b3437a43))
- Various changes after merging new HDF5 ([4eafe84f63](https://github.com/InsightSoftwareConsortium/ITK/commit/4eafe84f63))
- updated HDF5 symbol mangling ([f21b8f9eaf](https://github.com/InsightSoftwareConsortium/ITK/commit/f21b8f9eaf))

#### Platform Fixes

- fixed more clang -Wreserved-identifier warnings ([2cc4bdb5e3](https://github.com/InsightSoftwareConsortium/ITK/commit/2cc4bdb5e3))
- seems all use of kwiml is no longer actually needed, removed it. ([85072c0afc](https://github.com/InsightSoftwareConsortium/ITK/commit/85072c0afc))
- had to remove these... ([0d6aa661c2](https://github.com/InsightSoftwareConsortium/ITK/commit/0d6aa661c2))
- removed obsolete option for Objective-C++ flags ([ae74e4122a](https://github.com/InsightSoftwareConsortium/ITK/commit/ae74e4122a))
- Added mangling for 3 HDF5 functions that were missed ([4804adc4c1](https://github.com/InsightSoftwareConsortium/ITK/commit/4804adc4c1))
- add C++11 override to various HDF5 methods that indeed override ([1be1b170e6](https://github.com/InsightSoftwareConsortium/ITK/commit/1be1b170e6))
- fixed -Wset-but-unused warning building in Release ([db431226cb](https://github.com/InsightSoftwareConsortium/ITK/commit/db431226cb))

#### Bug Fixes

- Changed a lazy one-time initialization to use call_once. ([c3d108322d](https://github.com/InsightSoftwareConsortium/ITK/commit/c3d108322d))
- fixed various incorrect mutex use, found by TSan ([19330580e0](https://github.com/InsightSoftwareConsortium/ITK/commit/19330580e0))
- fix several threading bugs in itkThreadPool found by TSan ([d63a4f8387](https://github.com/InsightSoftwareConsortium/ITK/commit/d63a4f8387))
- fixed thread safety errors found by Thread Sanitizer ([b66133ab53](https://github.com/InsightSoftwareConsortium/ITK/commit/b66133ab53))
- fixed missing mutex acquisition noted by Thread Sanitizer ([d5a91d150d](https://github.com/InsightSoftwareConsortium/ITK/commit/d5a91d150d))
- fixed concurrant writes to an ivar found by Thread Sanitizer ([ed6d2d1329](https://github.com/InsightSoftwareConsortium/ITK/commit/ed6d2d1329))
- fixed issue #3032: fixed mutation from several threads simultaneously ([379f5e0137](https://github.com/InsightSoftwareConsortium/ITK/commit/379f5e0137))


### Simon Rit (2):

#### Enhancements

- add CudaCommon remote module ([2cd4d82307](https://github.com/InsightSoftwareConsortium/ITK/commit/2cd4d82307))

#### Platform Fixes

- fix warning triggered by setjmp ([b2c2c341cf](https://github.com/InsightSoftwareConsortium/ITK/commit/b2c2c341cf))


### Stephen R. Aylward (3):

#### Enhancements

- Adding test for Index member var of SpatialObjectToImageFilter ([f09f575480](https://github.com/InsightSoftwareConsortium/ITK/commit/f09f575480))

#### Platform Fixes

- Eliminate unnecessary complexity of logic for setting Index. ([4fb006b0fe](https://github.com/InsightSoftwareConsortium/ITK/commit/4fb006b0fe))

#### Bug Fixes

- SpatialObjectToImageFilter didn't use reference image's index ([7c2cd637cc](https://github.com/InsightSoftwareConsortium/ITK/commit/7c2cd637cc))


### Steve Robbins (1):

#### Bug Fixes

- Do not unconditionally assume SSE2 when building on i386. ([1a3c66ee05](https://github.com/InsightSoftwareConsortium/ITK/commit/1a3c66ee05))


### Tihomir Heidelberg (1):

#### Enhancements

- Add UTF-8 support for ImageSeriesReader when reading series of images ([3fb1dec607](https://github.com/InsightSoftwareConsortium/ITK/commit/3fb1dec607))


### Tim Evain (1):

#### Platform Fixes

- Add cmake clause when DCMTK_USE_ICU is OFF overwriting DCMTK config ([209f2056b8](https://github.com/InsightSoftwareConsortium/ITK/commit/209f2056b8))


### Tom Birdsong (25):

#### Enhancements

- Update Windows MKL path and prioritize user path if supplied ([a78269b2ba](https://github.com/InsightSoftwareConsortium/ITK/commit/a78269b2ba))
- Select Forward1DFFTImageFilter backend with object factory ([67762eefa6](https://github.com/InsightSoftwareConsortium/ITK/commit/67762eefa6))
- Hide FFT factory registration manager implementation detail ([6452747dbe](https://github.com/InsightSoftwareConsortium/ITK/commit/6452747dbe))
- Add ANTSNeighborhoodCorrelation metric wrapping ([5b25bfada6](https://github.com/InsightSoftwareConsortium/ITK/commit/5b25bfada6))
- Standardize complextocomplex fft with two-arg template ([ec145cfb13](https://github.com/InsightSoftwareConsortium/ITK/commit/ec145cfb13))
- Add object factory registration for FFT classes ([bb3c27e877](https://github.com/InsightSoftwareConsortium/ITK/commit/bb3c27e877))
- Manually register FFT factories in testing ([a7d1fdfda9](https://github.com/InsightSoftwareConsortium/ITK/commit/a7d1fdfda9))
- Remove TestDriver duplicate macro for Nonunit tests ([896cd89ae8](https://github.com/InsightSoftwareConsortium/ITK/commit/896cd89ae8))
- Query class name rather than subclass in test macro ([441fbd083d](https://github.com/InsightSoftwareConsortium/ITK/commit/441fbd083d))
- Add default FFT object factories to TestKernel initialization ([10f8abbc8d](https://github.com/InsightSoftwareConsortium/ITK/commit/10f8abbc8d))
- Register default FFT factories for 4D images ([87ebb47912](https://github.com/InsightSoftwareConsortium/ITK/commit/87ebb47912))
- Update FrequencyIterators GTest for factory registration setup ([0e642456c1](https://github.com/InsightSoftwareConsortium/ITK/commit/0e642456c1))
- Add Python FFT object factory tests ([955ec5c0c2](https://github.com/InsightSoftwareConsortium/ITK/commit/955ec5c0c2))
- Add macro to selectively catch factory instantiation failures ([32599f1b8e](https://github.com/InsightSoftwareConsortium/ITK/commit/32599f1b8e))
- Add test to verify itkFactoryOnlyNewMacro functionality ([6c841b05ef](https://github.com/InsightSoftwareConsortium/ITK/commit/6c841b05ef))

#### Documentation Updates

- Remove lingering Ultrasound dependency ([4b95bcfc2c](https://github.com/InsightSoftwareConsortium/ITK/commit/4b95bcfc2c))

#### Platform Fixes

- Add ITKImageIntensity as a test dependency for ITKFFT ([d856379505](https://github.com/InsightSoftwareConsortium/ITK/commit/d856379505))

#### Bug Fixes

- Fix ANTS metric type macro ([26f8d0ba9e](https://github.com/InsightSoftwareConsortium/ITK/commit/26f8d0ba9e))
- Fix 1D FFT doxygen groups ([536bb1b9cf](https://github.com/InsightSoftwareConsortium/ITK/commit/536bb1b9cf))
- Remove duplicate required input in BlockMatchingImageFilter ([845e661e87](https://github.com/InsightSoftwareConsortium/ITK/commit/845e661e87))
- Make FFT factories available across Python modules ([35df104b3e](https://github.com/InsightSoftwareConsortium/ITK/commit/35df104b3e))
- Condition FFT wrappings on complex types ([0cea2d0831](https://github.com/InsightSoftwareConsortium/ITK/commit/0cea2d0831))
- Synchronize the object factory across Python modules ([51eae89a74](https://github.com/InsightSoftwareConsortium/ITK/commit/51eae89a74))
- Remove name check in GCC-compiled tests and uncomment FFT checks ([934d2c2bdf](https://github.com/InsightSoftwareConsortium/ITK/commit/934d2c2bdf))

#### Miscellaneous Changes

- Revert "BUG: Make FFT factories available across Python modules" ([263c603e6a](https://github.com/InsightSoftwareConsortium/ITK/commit/263c603e6a))


### VXL Maintainers (3):

#### Miscellaneous Changes

- VXL 2021-12-10 (318538cf) ([af8c2f6093](https://github.com/InsightSoftwareConsortium/ITK/commit/af8c2f6093))
- VXL 2021-12-13 (f1eb4db2) ([186057dc2e](https://github.com/InsightSoftwareConsortium/ITK/commit/186057dc2e))
- VXL 2021-12-25 (fe6889da) ([1f8b1373c4](https://github.com/InsightSoftwareConsortium/ITK/commit/1f8b1373c4))


### Vagrant Cascadian (1):

#### Enhancements

- Use UTC timestamp in CONFIGURE_DATE. ([89b8fd3ce9](https://github.com/InsightSoftwareConsortium/ITK/commit/89b8fd3ce9))


### Vladimir S. FONOV (1):

#### Miscellaneous Changes

- MINC 2022-01-01 (4fa81b33) ([131ff69466](https://github.com/InsightSoftwareConsortium/ITK/commit/131ff69466))


### Wenqi Li (2):

#### Enhancements

- GetMatrixFromArray to accept ArrayLike sequences ([a89145bccd](https://github.com/InsightSoftwareConsortium/ITK/commit/a89145bccd))
- Ignore Distributed import errors ([5f1af152ba](https://github.com/InsightSoftwareConsortium/ITK/commit/5f1af152ba))


### josempozo (5):

#### Enhancements

- Added non-trivial (time-varying) test ([36850a19f8](https://github.com/InsightSoftwareConsortium/ITK/commit/36850a19f8))
- TimeBounds' normalization made optional ([7ae8a4ec19](https://github.com/InsightSoftwareConsortium/ITK/commit/7ae8a4ec19))
- Modified time-varying test switching off time normalization ([b668ce6192](https://github.com/InsightSoftwareConsortium/ITK/commit/b668ce6192))

#### Bug Fixes

- Runge-Kutta wrong TimeBounds implementation ([1d705b4879](https://github.com/InsightSoftwareConsortium/ITK/commit/1d705b4879))

#### Style Changes

- Remove always false if body. ([186fd8d737](https://github.com/InsightSoftwareConsortium/ITK/commit/186fd8d737))


### z0gSh1u (1):

#### Documentation Updates

- Add comment for `SetNumberOfWorkUnits` to correct documentation. ([28763032ee](https://github.com/InsightSoftwareConsortium/ITK/commit/28763032ee))




ITK Sphinx Examples Changes Since v5.3rc02
---------------------------------------------

### Andinet enquobahrie (1):

#### Enhancements

- Turn off Git protocol by default. ([8132a8d2](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/8132a8d2))


### Dženan Zukić (5):

#### Enhancements

- require C++14 for examples ([079d8826](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/079d8826))
- use new version of super linter ([a9e11bd1](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/a9e11bd1))
- use CMake version 3.16.3 as new required minimum ([345b1d0d](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/345b1d0d))

#### Platform Fixes

- fix compile errors by aggressive code cleanup ([4927d96e](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/4927d96e))

#### Style Changes

- fix lint errors by applying clang-format ([1bb21249](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/1bb21249))


### Hans Johnson (9):

#### Platform Fixes

- Remove inclusion of .hxx files as headers ([01ed5763](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/01ed5763))
- Modules need updated version of ITK ([e78bb01e](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/e78bb01e))
- ENABLE_QUICKVIEW code updates ([9ac0bafe](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/9ac0bafe))
- Remove unnecessary shadow definition ([f1651b31](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/f1651b31))
- Resolve deprecation warning for SphinxExamples ([6b9e0fea](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/6b9e0fea))

#### Style Changes

- Prefer itk::Math::abs for consistency. ([28820f48](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/28820f48))
- address unused variable warnings. ([89a73005](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/89a73005))
- Remove outdated pre ITKv4 code ([5b3015a7](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/5b3015a7))
- Remove python style warnings ([e4742994](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/e4742994))


### Jon Haitz Legarreta Gorroño (11):

#### Enhancements

- Add `const` smart pointer type alias ([4aba13d6](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/4aba13d6))

#### Platform Fixes

- Use and move ITK_DISALLOW_COPY_AND_MOVE calls to public section ([fc34c701](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/fc34c701))
- Mark class destructors with `override` ([b9974602](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/b9974602))

#### Bug Fixes

- Include the appropriate implementation file ([bc2ccaf2](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/bc2ccaf2))
- Fix the class name in the `ImageSource` source files ([7c159ea3](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/7c159ea3))
- Inherit `ImageSource` from `ProcessObject` ([be9d4e69](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/be9d4e69))
- Make the include guards match the filenames ([aaa8c25a](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/aaa8c25a))

#### Style Changes

- Do not use double underscore defines ([b260806a](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/b260806a))
- Move default construtor to .h ([4d22d731](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/4d22d731))
- Prefer = default to explicitly trivial implementations ([0ef6f6bd](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/0ef6f6bd))
- Use typename instead of class in template definitions ([84afaf0c](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/84afaf0c))


### Kian J Weimer (1):

#### Bug Fixes

- Switched incorrect 'image_to_vtk_image' function calls to 'vtk_image_from_image'. ([7acdc497](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/7acdc497))


### Matt McCormick (6):

#### Enhancements

- Update Sphinx to 4.4.0 ([7c77f795](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/7c77f795))
- Build documentation in CI with the Superbuild ([74f34732](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/74f34732))
- Migrate from gitstats to sphinx-contributors ([66cbdd66](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/66cbdd66))
- Update ITK to 5.3 RC 3 ([231ac876](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/231ac876))

#### Platform Fixes

- Sphinx warning node class 'meta' is already registered ([550f3b92](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/550f3b92))
- Address unused SPHINX_HTMLHELP_OUTPUT in superbuild ([4255ef27](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/4255ef27))


### Tom Birdsong (19):

#### Enhancements

- Remove redundant ITK build step in docs CI ([74878f04](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/74878f04))
- Deploy docs to Fleek ([3325d7b6](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/3325d7b6))
- Adjust site dir for Fleek container reference ([a6e600a7](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/a6e600a7))
- Bump ITK version ([50d60aa6](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/50d60aa6))

#### Bug Fixes

- Initialize image buffer in Inverse FFT example ([ff614cbb](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/ff614cbb))
- Fixes for HTML documentation ([0f025e3a](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/0f025e3a))
- Fix ITKDoxygenXML by copying instead of renaming directory ([2d080691](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/2d080691))
- Use https protocol for Superbuild CI ([f1103ff8](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/f1103ff8))
- Ignore breathe duplicate C++ warnings in docs CI ([19d77271](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/19d77271))
- Fix site unpack path ([7c084818](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/7c084818))
- Remove comma ([8b0b3526](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/8b0b3526))
- Update paths for Fleek source ([9d8a0780](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/9d8a0780))
- Fix github actions variable ref ([a1f279d4](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/a1f279d4))
- Revert deploy to Netlify ([2d8514bb](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/2d8514bb))
- Disable broken RegisterTwoPointSets tests ([9183236c](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/9183236c))

#### Miscellaneous Changes

- Add .fleek.json ([5d192756](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/5d192756))
- Set Fleek workdir reference ([d07c5936](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/d07c5936))
- Move `.fleek.json` ([f6073eb6](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/f6073eb6))
- Copy `.fleek.json` ([3ac107a7](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/3ac107a7))




ITK Software Guide Changes Since v5.3rc02
---------------------------------------------

### Dženan Zukić (2):

#### Enhancements

- Update minimum CMake version ([f5304f0](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/f5304f0))
- Make HTTP protocol the default in SuperBuild.cmake ([4f827f1](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/4f827f1))


### Jon Haitz Legarreta Gorroño (12):

#### Documentation Updates

- Print backslash mark ([002ea47](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/002ea47))
- Fix Doxygen special command markup and provide example ([aa77a56](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/aa77a56))
- Fix Doxygen link ([7db4436](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/7db4436))
- Remove uses of `itk::ImageTraits` ([67a88b4](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/67a88b4))
- Make test ending messages consistent ([42d950b](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/42d950b))
- Override destructor and prefer = default for trivial bodies ([60e70f5](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/60e70f5))
- Match the current function deletion practice in ITK ([ce05540](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/ce05540))
- Prefer using pre-increment over post-increment ([747ffae](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/747ffae))
- Update the ITK code style to current automatically enforced ([7b34899](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/7b34899))
- Document brace and brace list initialization preference ([f6f73fe](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/f6f73fe))
- Update `itk::N4BiasFieldCorrectionImageFilter::Sharpen` definition ([55ea845](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/55ea845))
- Remove recursive inclusion of .h files ([eb1b24c](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/eb1b24c))


### Julien Jomier (3):

#### Enhancements

- Update new kitware logo ([733dabb](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/733dabb))

#### Style Changes

- Updated the contributors ([1d0a653](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/1d0a653))
- Reverted back some contributions for clarity ([e21d83e](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/e21d83e))


### Lee Newberg (4):

#### Documentation Updates

- clang-format of code samples and other minted changes ([dd10e33](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/dd10e33))

#### Style Changes

- Format Python code with black ([b041051](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/b041051))
- Format c++ code with clang-format ([061225e](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/061225e))
- Use Python f" formatting ([cc3bbfc](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/cc3bbfc))


### Matt McCormick (2):

#### Enhancements

- Bump ITK to v5.3rc03 ([d833447](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/d833447))
- Update ISBN for new publication ([7f6bf89](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/7f6bf89))


### Niels Dekker (2):

#### Enhancements

- Add "Trailing Return Types" section ([c64b23b](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/c64b23b))

#### Style Changes

- Do not use `void` in empty function parameter list ([c4d9284](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/c4d9284))


### Tom Birdsong (2):

#### Documentation Updates

- Add section on debugging Python wrappings ([891fff6](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/891fff6))

#### Bug Fixes

- Use https protocol for superbuild CI ([6cc25d0](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/6cc25d0))




Remote Module Changes Since v5.3rc02
---------------------------------------------

## BoneEnhancement:
### Matt McCormick (1):

#### Enhancements

- Bump itk to 5.2.1.post1 ([aec0745](https://github.com/InsightSoftwareConsortium/ITKBoneEnhancement/commit/aec0745))



## MGHIO:



## MeshToPolyData:



## Montage:
### Dženan Zukić (1):

#### Platform Fixes

- avoiding deprecated itkGetStaticConstMacro ([c5f9214](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/c5f9214))


### Jon Haitz Legarreta Gorroño (1):

#### Platform Fixes

- Fix initializer list lifetime warning ([2fd431a](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/2fd431a))



## PerformanceBenchmarking:
### Dženan Zukić (4):

#### Enhancements

- use C++14 and CMake 3.16.3 for compatibility with ITK 5.3 ([b8c92d0](https://github.com/InsightSoftwareConsortium/ITKPerformanceBenchmarking/commit/b8c92d0))
- use a recent commit of ITK to avoid build errors and warnings ([6a27b32](https://github.com/InsightSoftwareConsortium/ITKPerformanceBenchmarking/commit/6a27b32))

#### Platform Fixes

- use std::is_arithmetic instead of mpl::IsNumber ([768801e](https://github.com/InsightSoftwareConsortium/ITKPerformanceBenchmarking/commit/768801e))
- add missing #include <iostream> ([9914ae9](https://github.com/InsightSoftwareConsortium/ITKPerformanceBenchmarking/commit/9914ae9))


### Jon Haitz Legarreta Gorroño (4):

#### Enhancements

- Bump ITK to latest commit in `master` ([f960087](https://github.com/InsightSoftwareConsortium/ITKPerformanceBenchmarking/commit/f960087))

#### Documentation Updates

- Remove deprecated shell script reference from `README` ([adac509](https://github.com/InsightSoftwareConsortium/ITKPerformanceBenchmarking/commit/adac509))
- Add Python to requirements list in `README` ([5940c80](https://github.com/InsightSoftwareConsortium/ITKPerformanceBenchmarking/commit/5940c80))

#### Style Changes

- Use double backticks for inline literals in `README` ([0b75ca7](https://github.com/InsightSoftwareConsortium/ITKPerformanceBenchmarking/commit/0b75ca7))



## RTK:
### Andreas Gravgaard Andersen (1):

#### Bug Fixes

- Fix varian reader memory bugs ([16e97605](https://github.com/SimonRit/RTK/commit/16e97605))


### MrTzschr (1):

#### Bug Fixes

- Fixed CudaFDKConeBeamReconstructionFilter not using GPU default projection subset size ([7ba9a51c](https://github.com/SimonRit/RTK/commit/7ba9a51c))


### Simon Rit (23):

#### Enhancements

- Update CI for ITK 5.2.1 ([5f0e9560](https://github.com/SimonRit/RTK/commit/5f0e9560))
- Update CI builds systems from Ubuntu 18.04 to 20.04 ([cf925530](https://github.com/SimonRit/RTK/commit/cf925530))
- add simulations of Forbild cones ([8b0197db](https://github.com/SimonRit/RTK/commit/8b0197db))
- wrap geometry readers for all constructors ([5978cef3](https://github.com/SimonRit/RTK/commit/5978cef3))
- add Varian OBI Python application ([569ec779](https://github.com/SimonRit/RTK/commit/569ec779))
- install python application for Varian OBI geometry ([b9ff8dcf](https://github.com/SimonRit/RTK/commit/b9ff8dcf))
- add python application for Ora geometry ([60171528](https://github.com/SimonRit/RTK/commit/60171528))
- wrap rtk::GlobalResourceProbe for timing Python ([bbf5461e](https://github.com/SimonRit/RTK/commit/bbf5461e))

#### Documentation Updates

- merge double entry for Module_RTK_GIT_TAG in INSTALLATION.md ([1ccea89b](https://github.com/SimonRit/RTK/commit/1ccea89b))

#### Platform Fixes

- Replace itkGetStaticConstMacro(name) with Self::name ([62b8c0a2](https://github.com/SimonRit/RTK/commit/62b8c0a2))
- provide nvcc location to CMake package CUDAToolkit ([2a05f389](https://github.com/SimonRit/RTK/commit/2a05f389))
- add Linux x64 self-hosted CI for CUDA ([d3b52188](https://github.com/SimonRit/RTK/commit/d3b52188))
- use 5.2 as the default Cuda architecture ([baffa738](https://github.com/SimonRit/RTK/commit/baffa738))

#### Bug Fixes

- Update Python Git tag to v5.2.1.post1 ([2111bdf3](https://github.com/SimonRit/RTK/commit/2111bdf3))
- fix orientation of Forbild ellipsoids ([4c2621cf](https://github.com/SimonRit/RTK/commit/4c2621cf))
- let ITK initialize C++ standard and build type ([a21ff588](https://github.com/SimonRit/RTK/commit/a21ff588))
- fix computation of rotation matrix for axis in Forbild ([0191861f](https://github.com/SimonRit/RTK/commit/0191861f))
- correctly handle the union of three objects ([eba1d8fc](https://github.com/SimonRit/RTK/commit/eba1d8fc))
- deal with (half-)lines when intersecting quadric with a rays ([009ef926](https://github.com/SimonRit/RTK/commit/009ef926))
- fix ray quadric intersection for tangent rays ([25567c62](https://github.com/SimonRit/RTK/commit/25567c62))

#### Style Changes

- remove backward compatibility with ITK v5.1 ([a025c810](https://github.com/SimonRit/RTK/commit/a025c810))
- Replace itkStaticConstMacro with static constexpr ([b54a188c](https://github.com/SimonRit/RTK/commit/b54a188c))

#### Miscellaneous Changes

- Release of RTK v2.3.0 ([461c1693](https://github.com/SimonRit/RTK/commit/461c1693))



## SimpleITKFilters:
### Bradley Lowekamp (2):

#### Miscellaneous Changes

- Update to ITK 5.3rc2 ([c1ab584](https://github.com/InsightSoftwareConsortium/ITKSimpleITKFilters/commit/c1ab584))
- Change testing data to sha512 uploaded to data.kitware ([ad91905](https://github.com/InsightSoftwareConsortium/ITKSimpleITKFilters/commit/ad91905))



## Strain:
### Tom Birdsong (5):

#### Enhancements

- Update ITK CI version to 5.2.1 ([4597dd5](https://github.com/KitwareMedical/ITKStrain/commit/4597dd5))
- Add float type to StrainImageFilter wrappings ([ac8b58a](https://github.com/KitwareMedical/ITKStrain/commit/ac8b58a))
- Wrap TransformToStrainFilter ([e0b751d](https://github.com/KitwareMedical/ITKStrain/commit/e0b751d))
- Update Python package version ([17a7a05](https://github.com/KitwareMedical/ITKStrain/commit/17a7a05))
- Add script and notebook strain examples ([701a5ef](https://github.com/KitwareMedical/ITKStrain/commit/701a5ef))


## Ultrasound:
### Matt McCormick (2):

#### Enhancements

- Bump version to 0.5.0 ([645b861](https://github.com/KitwareMedical/ITKUltrasound/commit/645b861))
- Build Python packages against ITK 5.2.1 ([6d56255](https://github.com/KitwareMedical/ITKUltrasound/commit/6d56255))


### Tom Birdsong (7):

#### Enhancements

- Wrap itkSpeckleReducingAnisotropicDiffusionImageFilter for Python ([dfd8047](https://github.com/KitwareMedical/ITKUltrasound/commit/dfd8047))
- Add example to demonstrate NRRD ultrasound sequence -> VideoStream ([9ed1961](https://github.com/KitwareMedical/ITKUltrasound/commit/9ed1961))
- Bump ITK cxx CI git tag ([172bd04](https://github.com/KitwareMedical/ITKUltrasound/commit/172bd04))
- Add common data paths to .gitignore ([1abec41](https://github.com/KitwareMedical/ITKUltrasound/commit/1abec41))
- Wrap normalized cross correlation class hierarchy ([d6ae9d6](https://github.com/KitwareMedical/ITKUltrasound/commit/d6ae9d6))

#### Bug Fixes

- Use Python 3.9 for nbmake ([385abb2](https://github.com/KitwareMedical/ITKUltrasound/commit/385abb2))
- Fix linux python CI runner cleanup step ([39b95e1](https://github.com/KitwareMedical/ITKUltrasound/commit/39b95e1))
