'\"
'\" Copyright (c) 1995-1999 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) collapsablewidget.n 1.21 94/12/17 16:04:44
'\" 
.so man.macros
.HS collapsablewidget iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
iwidgets::collapsablewidget \- Create and manipulate a labeled widget
.SH SYNOPSIS
\fBcollapsablewidget\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Widget <- iwidgets::collapsablewidget
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBcursor\fR	\fBforeground\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBcollapsed\fR
Class:	\fBCollapsed\fR
Command-Line Switch:	\fB-collapsed\fR
.fi
.IP
Specifies whether to hide or display the childsite.  Takes a boolean value.
If true, the childsite is hidden from view, if false it is displayed.
The default is to display the childsite.
.LP
.nf
Name:	\fBforeground\fR
Class:	\fBForeground\fR
Command-Line Switch:	\fB-foreground\fR
.fi
.IP
Specifies the foreground to be used in the label.
.LP
.nf
Name:	\fBlabelBitmap\fR
Class:	\fBBitmap\fR
Command-Line Switch:	\fB-labelbitmap\fR
.fi
.IP
Specifies a bitmap to display in the widget, in any of the forms 
acceptable to \fBTk_GetBitmap\fR.  This option overrides the \fIlabeltext\fR
option.
.LP
.nf
Name:	\fBlabelFont\fR
Class:	\fBFont\fR
Command-Line Switch:	\fB-labelfont\fR
.fi
.IP
Specifies the font to be used for the label.
.LP
.nf
Name:	\fBlabelImage\fR
Class:	\fBImage\fR
Command-Line Switch:	\fB-labelimage\fR
.fi
.IP
Specifies a image to be used as the label. The image may be any of the
values created by the \fBimage create\fR command.  This option overrides
both the \fIlabelbitmap\fR and \fIlabeletext\fR options.
.LP
.nf
Name:	\fBlabelMargin\fR
Class:	\fBMargin\fR
Command-Line Switch:	\fB-labelmargin\fR
.fi
.IP
Specifies the distance between the childsite and label in any of the forms
acceptable to \fBTk_GetPixels\fR.  The default is 2 pixel.
.LP
.nf
Name:	\fBlabelText\fR
Class:	\fBText\fR
Command-Line Switch:	\fB-labeltext\fR
.fi
.IP
Specifies the text of the label around the childsite.
.LP
.nf
Name:	\fBlabelVariable\fR
Class:	\fBVariable\fR
Command-Line Switch:	\fB-labelvariable\fR
.fi
.IP
Specifies the text variable of the label around the childsite.
.LP
.BE

.SH DESCRIPTION
.PP
The \fBcollapsablewidget\fR command creates a labeled widget which contains 
a button, a label and child site.  The child site is a frame 
which can filled with any widget via a derived class or though the use 
of the childsite method.  This class
was designed to be a general purpose base class for supporting the 
combination of label widget and a childsite, in which the button
(which displays a suitable image) controls whether to display the
childsite or not.  The options include the ability to modify the
font and margin, and control the display of the labels.

.SH "METHODS"
.PP
The \fBcollapsablewidget\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for collapsablewidget widgets:
.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBchildsite\fR
Return the path name of the child site.
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBcollapsablewidget\fR
command.
.TP
\fIpathName \fBcollapse\fR
Hides the childsite from view, updating the image in the button to
reflect the new state.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBcollapsablewidget\fR
command.
.TP
\fIpathName \fBreveal\fR
Bring the childsite into view, updating the image in the button to
reflect the new state.
.TP
\fIpathName \fBtoggle\fR
If the childsite is in view, hide it, and if it is hidden display it.
Updates the image in the button to reflect the new state.

.SH "STATIC METHODS"
.TP
\fBCollapsablewidget::alignlabels\fR \fIwidget\fR ?\fIwidget ...\fR?
The alignlabels procedure takes a list of widgets derived from
the Collapsablewidget class and uses the label margin to make each widget
have the same total space for the combination of label and margin.  The
net effect is to left align the labels.  

.SH "COMPONENTS"
.LP
.nf
Name:	\fBlabel\fR
Class:	\fBlabel\fR
.fi
.IP
The label component provides the label for the labeled widget.  See the 
"label" widget manual entry for details on the label component item.
.LP
.nf
Name:	\fBlwchildsite\fR
Class:	\fBframe\fR
.fi
.IP
The lwchildsite component is the user child site for the labeled widget.  See 
the "frame" widget manual entry for details on the lwchildsite component item.
.fi

.SH EXAMPLE
.IP
The collapsablewidget is useful when you wish to display a large
amount of information in a single window, only some of which the 
user is likely to want to see at any one time.  By placing a number
of collapsable widgets in the window, each of which contains some
of the available information (presumably categorised appropriately),
you can make very effective use of a small amount of screen
real-estate.  The following is an example of how to create a widget
which has its childsite hidden, and then reveal the childsite later.
.LP
.DS
 iwidgets::collapsablewidget .cw -labeltext "Canvas Widget" -collapsed 1
 pack .cw -fill both -expand yes -padx 10 -pady 10

 set cw [canvas [.cw childsite].c -relief raised -width 200 -height 200]
 pack $cw -padx 10 -pady 10
 after 2000 {.cw reveal}
.DE
.SH AUTHOR
Vince Darley
.SH KEYWORDS
collapsablewidget, widget
