/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.server.RemoteCommand;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;

public class DefaultRemoteCommand
implements RemoteCommand {
    private final String command;
    private final String field;
    private final String value;
    private final String piggybackedJavaScript;
    private final Pattern JSON_ESCAPABLES = Pattern.compile("([\\\\\"'\b\f\n\r\t])");

    public DefaultRemoteCommand(String command, String field, String value) {
        this.command = command;
        this.field = field;
        this.value = value;
        this.piggybackedJavaScript = null;
    }

    public DefaultRemoteCommand(String command, String field, String value, String piggybackedJavaScript) {
        this.command = command;
        this.field = field;
        this.value = value;
        this.piggybackedJavaScript = piggybackedJavaScript != null && !"".equals(piggybackedJavaScript) ? piggybackedJavaScript : null;
    }

    public String getCommandURLString() {
        return "cmd=" + LauncherUtils.urlEncode(this.command) + "&1=" + LauncherUtils.urlEncode(this.field) + "&2=" + LauncherUtils.urlEncode(this.value);
    }

    public String getJSONString() {
        String rest = "";
        if (this.piggybackedJavaScript != null) {
            rest = ",rest:\"" + this.escapeJSON(this.piggybackedJavaScript) + "\"";
        }
        return "json={command:\"" + this.escapeJSON(this.command) + "\",target:\"" + this.escapeJSON(this.field) + "\",value:\"" + this.escapeJSON(this.value) + "\"" + rest + "}";
    }

    private String escapeJSON(String s) {
        Matcher m = this.JSON_ESCAPABLES.matcher(s);
        boolean result = m.find();
        if (result) {
            StringBuffer sb = new StringBuffer();
            do {
                String value;
                if ((value = m.group(1)).length() != 1) {
                    throw new RuntimeException("Bug! matcher matched >1 char: <" + value + ">: " + s);
                }
                char c = value.charAt(0);
                switch (c) {
                    case '\\': {
                        m.appendReplacement(sb, "\\\\\\\\");
                        break;
                    }
                    case '\"': {
                        m.appendReplacement(sb, "\\\\\"");
                        break;
                    }
                    case '\'': {
                        m.appendReplacement(sb, "\\\\'");
                        break;
                    }
                    case '\b': {
                        m.appendReplacement(sb, "\\\\b");
                        break;
                    }
                    case '\f': {
                        m.appendReplacement(sb, "\\\\f");
                        break;
                    }
                    case '\n': {
                        m.appendReplacement(sb, "\\\\n");
                        break;
                    }
                    case '\r': {
                        m.appendReplacement(sb, "\\\\r");
                        break;
                    }
                    case '\t': {
                        m.appendReplacement(sb, "\\\\t");
                        break;
                    }
                    default: {
                        throw new RuntimeException("Bug! matcher matched unexpected char: <" + c + "> " + s);
                    }
                }
            } while (result = m.find());
            m.appendTail(sb);
            return sb.toString();
        }
        return s;
    }

    public String getCommand() {
        return this.command;
    }

    public String getField() {
        return this.field;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getJSONString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RemoteCommand)) {
            return false;
        }
        if (obj == null) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public static RemoteCommand parse(String inputLine) {
        if (inputLine == null) {
            throw new NullPointerException("inputLine must not be null");
        }
        inputLine = inputLine.trim();
        String prefix = "json={command:\"";
        if (!inputLine.startsWith("json={command:\"")) {
            throw new IllegalArgumentException("invalid command string, missing 'json={command:\"'=" + inputLine);
        }
        int index = "json={command:\"".length();
        int[] hackToPassByReference = new int[]{index};
        String command = DefaultRemoteCommand.parseJSONString(inputLine, hackToPassByReference);
        index = hackToPassByReference[0] + 1;
        String targetDelim = ",target:\"";
        if (inputLine.length() <= index + ",target:\"".length()) {
            throw new IllegalArgumentException("invalid command string, missing ',target:\"'=" + inputLine);
        }
        if (!inputLine.substring(index, index + ",target:\"".length()).equals(",target:\"")) {
            throw new IllegalArgumentException("invalid command string, missing ',target:\"'=" + inputLine);
        }
        hackToPassByReference[0] = index += ",target:\"".length();
        String target = DefaultRemoteCommand.parseJSONString(inputLine, hackToPassByReference);
        index = hackToPassByReference[0] + 1;
        String valueDelim = ",value:\"";
        if (inputLine.length() <= index + ",value:\"".length()) {
            throw new IllegalArgumentException("invalid command string, missing ',value:\"'=" + inputLine);
        }
        if (!inputLine.substring(index, index + ",value:\"".length()).equals(",value:\"")) {
            throw new IllegalArgumentException("invalid command string, missing ',value:\"'=" + inputLine);
        }
        hackToPassByReference[0] = index += ",value:\"".length();
        String value = DefaultRemoteCommand.parseJSONString(inputLine, hackToPassByReference);
        index = hackToPassByReference[0] + 1;
        String restDelim = ",rest:\"";
        if (inputLine.length() <= index + ",rest:\"".length()) {
            return new DefaultRemoteCommand(command, target, value);
        }
        if (!inputLine.substring(index, index + ",rest:\"".length()).equals(",rest:\"")) {
            throw new IllegalArgumentException("invalid command string, missing ',rest:\"'=" + inputLine);
        }
        hackToPassByReference[0] = index += ",rest:\"".length();
        String rest = DefaultRemoteCommand.parseJSONString(inputLine, hackToPassByReference);
        return new DefaultRemoteCommand(command, target, value, rest);
    }

    private static String parseJSONString(String inputLine, int[] hackToPassByReference) {
        int index;
        StringBuffer sb = new StringBuffer();
        boolean finished = false;
        for (index = hackToPassByReference[0]; index < inputLine.length(); ++index) {
            char c = inputLine.charAt(index);
            if ('\"' == c) {
                finished = true;
                break;
            }
            if ('\\' == c) {
                c = inputLine.charAt(++index);
                switch (c) {
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'u': {
                        String fourHexDigits = inputLine.substring(index + 1, index + 5);
                        c = (char)Integer.parseInt(fourHexDigits, 16);
                        sb.append(c);
                        index += 4;
                        break;
                    }
                    default: {
                        sb.append(c);
                        break;
                    }
                }
                continue;
            }
            sb.append(c);
        }
        if (!finished) {
            throw new IllegalArgumentException("Invalid JSON string, quote never terminated: " + inputLine);
        }
        hackToPassByReference[0] = index;
        return sb.toString();
    }

    public String getPiggybackedJavaScript() {
        return this.piggybackedJavaScript;
    }
}

