package latexDraw.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

import latexDraw.lang.LaTeXDrawLang;
import latexDraw.ui.CodePanel;
import latexDraw.ui.LaTeXDrawFrame;
import latexDraw.ui.components.CopyPasteMenu;
import latexDraw.util.LaTeXDrawResources;


/**
 * This frame allows the user to add comments to his current drawing<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE.  See the GNU General Public License for more details.<br>
 *<br>
 * 06/03/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class AddCommentsFrame extends JFrame implements ActionListener
{
	private static final long serialVersionUID = 1L;

	/** The label of the button "ok" of the frame addCommentsFrame */
	public static final String LABEL_FRAME_ADDCOMMENTS_OK = "ADDCOMMENTS_OK";//$NON-NLS-1$
	
	/** The label of the button "Cancel" of the frame addCommentsFrame */
	public static final String LABEL_FRAME_ADDCOMMENTS_CANCEL = "ADDCOMMENTS_CANCEL";//$NON-NLS-1$

	/** The title of the frame */
	public static final String TITLE = LaTeXDrawLang.getOthersString("CodePanel.updateCode"); //$NON-NLS-1$
	
	/** The main frame of the program */
	protected LaTeXDrawFrame mainFrame;
	
	/** This editor allows to write comments */
	protected JEditorPane editorAddComments;
	
	protected CopyPasteMenu copyMenu;
	
	
	public AddCommentsFrame(LaTeXDrawFrame frame)
	{
		try
		{
	  		setIconImage(LaTeXDrawResources.commentIcon.getImage());
			
			mainFrame = frame;
			Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
	  		setTitle(TITLE);
	  		setLocation(dim.width*1/3, dim.height*1/4);
	  		
	  		// Creation of the panel which contains the editor
	  		// and creation of the panel which contains the buttons
	  		JPanel  pGeneral = new JPanel(new BorderLayout()), 
	  				pButton = new JPanel(new BorderLayout());
	  		JButton buttonOk = new JButton(AbstractParametersFrame.LABEL_OK), 
	  				buttonCancel = new JButton(AbstractParametersFrame.LABEL_CANCEL);
	  		editorAddComments 	= new JEditorPane();
	  		copyMenu			= new CopyPasteMenu(editorAddComments);
	  		
	  		buttonOk.setActionCommand(LABEL_FRAME_ADDCOMMENTS_OK);
	  		buttonCancel.setActionCommand(LABEL_FRAME_ADDCOMMENTS_CANCEL);
			buttonOk.addActionListener(this);
			buttonCancel.addActionListener(this);

	  		// The scroller of the editor
			JScrollPane scrollPane = new JScrollPane(editorAddComments);
	 		scrollPane.setVerticalScrollBarPolicy(
	 									ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS); 
			GridLayout  gridButton = new GridLayout(1, 2);

			editorAddComments.setText("");//$NON-NLS-1$
			pButton.setLayout(gridButton);
			pButton.add(buttonOk);
			pButton.add(buttonCancel);
			pGeneral.add(scrollPane, BorderLayout.CENTER);
			pGeneral.add(pButton, BorderLayout.SOUTH);
			
			// Creation of the frame
			getContentPane().add(pGeneral);
			setSize(340, 250);
			setVisible(false);
			
			editorAddComments.addMouseListener(copyMenu);
		}catch(Exception e)
		{
			e.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(e);
		}
	}
	
	
	
	@Override
	public void setVisible(boolean visible)
	{
		super.setVisible(visible);
		
		if(visible)
		{
			CodePanel codePanel = mainFrame.getCodePanel();
			editorAddComments.setText(codePanel.getCommentsWithoutTag());
		}
		else
			mainFrame.requestFocus();
	}
	
	

	public void actionPerformed(ActionEvent e) 
	{
		Object o = e.getSource();
		
		if(o instanceof JButton)
		{
			String label = ((JButton)o).getActionCommand();
			
			if(label == LABEL_FRAME_ADDCOMMENTS_CANCEL)
			{
				setVisible(false);
				return ;
			}
			
			if(label == LABEL_FRAME_ADDCOMMENTS_OK)
			{
				CodePanel codePanel;
				try
				{
					codePanel = mainFrame.getCodePanel();
					codePanel.setComments(editorAddComments.getText());
					codePanel.updateText();
					mainFrame.setIsModified(true);
					
				}catch(Exception ex) 
				{
					ex.printStackTrace(); 
					ExceptionFrameDialog.showExceptionDialog(ex);
				}

				setVisible(false);

				return;
			}
		} // if JButton
	}
}
