package tests::ConfigDlfStreamsSpecTest;

use strict;

use tests::ConfigSpecTest;

use base qw/tests::ConfigListSpecTest/;

use Lire::Config::DlfStreamsSpec;
use Lire::Config::ConfigSpec;
use Lire::DlfSchema;

sub new {
    my $self = shift->SUPER::new( @_ );

    return $self;
}

sub set_up {
    my $self = $_[0];

    $self->SUPER::set_up();

    $self->{'cfg'}{'lr_schemas_path'} = [];
    $Lire::DlfSchema::SCHEMA_CACHE{'test1'} = {};
    $Lire::DlfSchema::SCHEMA_CACHE{'test2'} = {};

    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    delete $Lire::DlfSchema::SCHEMA_CACHE{'test1'};
    delete $Lire::DlfSchema::SCHEMA_CACHE{'test2'};

    return;
}

sub type {
    return 'Lire::Config::DlfStreamsSpec';
}

sub test_has_component {
    my $self = $_[0];

    $self->assert( $self->{'spec'}->has_component( 'test1' ), 'test1' );
    $self->assert( $self->{'spec'}->has_component( 'test1' ), 'test2' );
    $self->assert( ! $self->{'spec'}->has_component( 'test3' ), '! test3' );
}

sub test_get {
    my $self = $_[0];

    my $spec = $self->{'spec'}->get( 'test1' );
    $self->assert_isa( 'Lire::Config::DlfStreamSpec', $spec );
    $self->assert_str_equals( 'test1', $spec->name() );
    $self->assert_str_equals( $spec, $self->{'spec'}->get( 'test1' ) );

    $self->assert_dies( qr/no component named 'test3'/,
                        sub { $self->{'spec'}->get( 'test3' ) } );
}

1;

