#include <fstream>
#include <sstream>
#include <cassert>
#include <iostream>
#include <cstdlib>

#include "keymap.h"
#include "logger.h"

using namespace std;

void GetLine(istream& is, istringstream& iss){
    char buf[200];
    do {
	is.getline(buf,200);
    } while (is.good() && buf[0]=='#');
    string sbuf(buf);
    iss.str(sbuf);
}

int Keymap::GetFunId(string f){
    int fun_id = -1;
    for (int i = 0; i<functions.size(); ++i)
	if (functions[i] == f){
	    fun_id = i;
	    break;
	}
    if (fun_id == -1){
	fun_id = functions.size();
	functions.push_back(f);
	keys.push_back(vector<Key>());
    }
    return fun_id;
}

Keymap::Keymap():function(0), is_alt(false), is_ctrl(false), keep_fun(true){
}

void Keymap::ReadMap(const string& filename){
    keys.clear();
    functions.clear();
    function = 0;
    is_alt = false;
    is_ctrl = false;
    ifstream is;
    is.open(filename.c_str());
    GetFunId("normal");
    string first;
    int minx=10000, miny=10000, maxx=-10000, maxy=-10000;
    bool eatlast = false;
    while (is.good()){
	if (!eatlast)
	    is >> first;
	else 
	    eatlast = false;

	if (first == "key"){
	    int px, py, w, h;
	    is >> px >> py >> w >> h;
	    minx = min(minx, px);
	    miny = min(miny, py);
	    maxx = max(maxx, px+w);
	    maxy = max(maxy, py+h);
	    Key k(px, py, w, h);
	    do {
		is >> first;
		if (!is.good())
		    break;
		//cout << "in key "<< first<<endl;
		if (first == "key"){
		    eatlast = true;
		    break;
		}
		string look, action;
		is >> look >> action;
		int function = GetFunId(first);
		k.look = look;
		k.action = action;
		keys[function].push_back(k);
		if (first == "shift" && action!="capslock")
		    keys[GetFunId("capslock")].push_back(k);
	    } while (1);
	}
    }
    for (int i=0; i<keys.size(); ++i)
	for (int j=0; j<keys[i].size(); ++j){
	    keys[i][j].px-=minx;
	    keys[i][j].py-=miny;
	}
    width=maxx-minx+1;
    height=maxy-miny+1;

}

void Keymap::SetFunction(string f){
    if (f == "ctrl"){
	is_ctrl = !is_ctrl;
	return;
    }
    if (f == "alt"){
	is_alt = !is_alt;
	return;
    }


    keep_fun = true;
    if (f == "shift")
	keep_fun = false;

    int new_fun_id = GetFunId(f);
    if (new_fun_id == function) // we are currently on that function so set back to normal
	function = GetFunId("normal"); 
    else 
	function = new_fun_id;
}

string Keymap::GetAction(int x, int y){
    string ret;
    vector<Key>& fkeys = keys[function];
    for (int i=0; i<fkeys.size(); ++i)
	if (x>=fkeys[i].px && y>=fkeys[i].py && x<fkeys[i].px+fkeys[i].w && y<fkeys[i].py+fkeys[i].h){
	    ret = fkeys[i].action;
	    break;
	}
    if (is_alt && ret[0] != '$'){
	ret = string("alt:")+ret;
	is_alt = false;
    }
    if (is_ctrl && ret[0] != '$'){
	ret = string("ctrl:")+ret;
	is_ctrl = false;
    }

    if (!keep_fun){
	ret = string("refresh:")+ret;
	function = GetFunId("normal");
	keep_fun = true;
    }


    return ret;
}
bool Keymap::GetKey(int x, int y, Key* key) const {
    const vector<Key>& fkeys = keys[function];
    for (int i=0; i<fkeys.size(); ++i)
	if (x>=fkeys[i].px && y>=fkeys[i].py && x<fkeys[i].px+fkeys[i].w && y<fkeys[i].py+fkeys[i].h){
	    *key = fkeys[i];
	    return true;
	}
    return false;
}
const vector<Keymap::Key>& Keymap::GetCurrentKeys() const {
    return keys[function];
}

int Keymap::Height() const {
    return height;
}
int Keymap::Width() const {
    return width;
}

int Keymap::CurrentFunction() const {
    return function;
}

