; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -target-abi=ilp32d -mattr=+v,+zfh,+experimental-zvfh,+f,+d -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX2
; RUN: llc -mtriple=riscv64 -target-abi=lp64d -mattr=+v,+zfh,+experimental-zvfh,+f,+d -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX2
; RUN: llc -mtriple=riscv32 -target-abi=ilp32d -mattr=+v,+zfh,+experimental-zvfh,+f,+d -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX1,LMULMAX1-RV32
; RUN: llc -mtriple=riscv64 -target-abi=lp64d -mattr=+v,+zfh,+experimental-zvfh,+f,+d -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX1,LMULMAX1-RV64

define void @fadd_v8f16(<8 x half>* %x, <8 x half>* %y) {
; CHECK-LABEL: fadd_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vle16.v v9, (a1)
; CHECK-NEXT:    vfadd.vv v8, v8, v9
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = load <8 x half>, <8 x half>* %y
  %c = fadd <8 x half> %a, %b
  store <8 x half> %c, <8 x half>* %x
  ret void
}

define void @fadd_v4f32(<4 x float>* %x, <4 x float>* %y) {
; CHECK-LABEL: fadd_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vfadd.vv v8, v8, v9
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = load <4 x float>, <4 x float>* %y
  %c = fadd <4 x float> %a, %b
  store <4 x float> %c, <4 x float>* %x
  ret void
}

define void @fadd_v2f64(<2 x double>* %x, <2 x double>* %y) {
; CHECK-LABEL: fadd_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vfadd.vv v8, v8, v9
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = load <2 x double>, <2 x double>* %y
  %c = fadd <2 x double> %a, %b
  store <2 x double> %c, <2 x double>* %x
  ret void
}

define void @fsub_v8f16(<8 x half>* %x, <8 x half>* %y) {
; CHECK-LABEL: fsub_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vle16.v v9, (a1)
; CHECK-NEXT:    vfsub.vv v8, v8, v9
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = load <8 x half>, <8 x half>* %y
  %c = fsub <8 x half> %a, %b
  store <8 x half> %c, <8 x half>* %x
  ret void
}

define void @fsub_v4f32(<4 x float>* %x, <4 x float>* %y) {
; CHECK-LABEL: fsub_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vfsub.vv v8, v8, v9
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = load <4 x float>, <4 x float>* %y
  %c = fsub <4 x float> %a, %b
  store <4 x float> %c, <4 x float>* %x
  ret void
}

define void @fsub_v2f64(<2 x double>* %x, <2 x double>* %y) {
; CHECK-LABEL: fsub_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vfsub.vv v8, v8, v9
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = load <2 x double>, <2 x double>* %y
  %c = fsub <2 x double> %a, %b
  store <2 x double> %c, <2 x double>* %x
  ret void
}

define void @fmul_v8f16(<8 x half>* %x, <8 x half>* %y) {
; CHECK-LABEL: fmul_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vle16.v v9, (a1)
; CHECK-NEXT:    vfmul.vv v8, v8, v9
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = load <8 x half>, <8 x half>* %y
  %c = fmul <8 x half> %a, %b
  store <8 x half> %c, <8 x half>* %x
  ret void
}

define void @fmul_v4f32(<4 x float>* %x, <4 x float>* %y) {
; CHECK-LABEL: fmul_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vfmul.vv v8, v8, v9
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = load <4 x float>, <4 x float>* %y
  %c = fmul <4 x float> %a, %b
  store <4 x float> %c, <4 x float>* %x
  ret void
}

define void @fmul_v2f64(<2 x double>* %x, <2 x double>* %y) {
; CHECK-LABEL: fmul_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vfmul.vv v8, v8, v9
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = load <2 x double>, <2 x double>* %y
  %c = fmul <2 x double> %a, %b
  store <2 x double> %c, <2 x double>* %x
  ret void
}

define void @fdiv_v8f16(<8 x half>* %x, <8 x half>* %y) {
; CHECK-LABEL: fdiv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vle16.v v9, (a1)
; CHECK-NEXT:    vfdiv.vv v8, v8, v9
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = load <8 x half>, <8 x half>* %y
  %c = fdiv <8 x half> %a, %b
  store <8 x half> %c, <8 x half>* %x
  ret void
}

define void @fdiv_v4f32(<4 x float>* %x, <4 x float>* %y) {
; CHECK-LABEL: fdiv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vfdiv.vv v8, v8, v9
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = load <4 x float>, <4 x float>* %y
  %c = fdiv <4 x float> %a, %b
  store <4 x float> %c, <4 x float>* %x
  ret void
}

define void @fdiv_v2f64(<2 x double>* %x, <2 x double>* %y) {
; CHECK-LABEL: fdiv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vfdiv.vv v8, v8, v9
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = load <2 x double>, <2 x double>* %y
  %c = fdiv <2 x double> %a, %b
  store <2 x double> %c, <2 x double>* %x
  ret void
}

define void @fneg_v8f16(<8 x half>* %x) {
; CHECK-LABEL: fneg_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfneg.v v8, v8
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = fneg <8 x half> %a
  store <8 x half> %b, <8 x half>* %x
  ret void
}

define void @fneg_v4f32(<4 x float>* %x) {
; CHECK-LABEL: fneg_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfneg.v v8, v8
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = fneg <4 x float> %a
  store <4 x float> %b, <4 x float>* %x
  ret void
}

define void @fneg_v2f64(<2 x double>* %x) {
; CHECK-LABEL: fneg_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfneg.v v8, v8
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = fneg <2 x double> %a
  store <2 x double> %b, <2 x double>* %x
  ret void
}

define void @fabs_v8f16(<8 x half>* %x) {
; CHECK-LABEL: fabs_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfabs.v v8, v8
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = call <8 x half> @llvm.fabs.v8f16(<8 x half> %a)
  store <8 x half> %b, <8 x half>* %x
  ret void
}
declare <8 x half> @llvm.fabs.v8f16(<8 x half>)

define void @fabs_v4f32(<4 x float>* %x) {
; CHECK-LABEL: fabs_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfabs.v v8, v8
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = call <4 x float> @llvm.fabs.v4f32(<4 x float> %a)
  store <4 x float> %b, <4 x float>* %x
  ret void
}
declare <4 x float> @llvm.fabs.v4f32(<4 x float>)

define void @fabs_v2f64(<2 x double>* %x) {
; CHECK-LABEL: fabs_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfabs.v v8, v8
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = call <2 x double> @llvm.fabs.v2f64(<2 x double> %a)
  store <2 x double> %b, <2 x double>* %x
  ret void
}
declare <2 x double> @llvm.fabs.v2f64(<2 x double>)

define void @copysign_v8f16(<8 x half>* %x, <8 x half>* %y) {
; CHECK-LABEL: copysign_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vle16.v v9, (a1)
; CHECK-NEXT:    vfsgnj.vv v8, v8, v9
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = load <8 x half>, <8 x half>* %y
  %c = call <8 x half> @llvm.copysign.v8f16(<8 x half> %a, <8 x half> %b)
  store <8 x half> %c, <8 x half>* %x
  ret void
}
declare <8 x half> @llvm.copysign.v8f16(<8 x half>, <8 x half>)

define void @copysign_v4f32(<4 x float>* %x, <4 x float>* %y) {
; CHECK-LABEL: copysign_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vfsgnj.vv v8, v8, v9
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = load <4 x float>, <4 x float>* %y
  %c = call <4 x float> @llvm.copysign.v4f32(<4 x float> %a, <4 x float> %b)
  store <4 x float> %c, <4 x float>* %x
  ret void
}
declare <4 x float> @llvm.copysign.v4f32(<4 x float>, <4 x float>)

define void @copysign_v2f64(<2 x double>* %x, <2 x double>* %y) {
; CHECK-LABEL: copysign_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vfsgnj.vv v8, v8, v9
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = load <2 x double>, <2 x double>* %y
  %c = call <2 x double> @llvm.copysign.v2f64(<2 x double> %a, <2 x double> %b)
  store <2 x double> %c, <2 x double>* %x
  ret void
}
declare <2 x double> @llvm.copysign.v2f64(<2 x double>, <2 x double>)

define void @copysign_vf_v8f16(<8 x half>* %x, half %y) {
; CHECK-LABEL: copysign_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = insertelement <8 x half> poison, half %y, i32 0
  %c = shufflevector <8 x half> %b, <8 x half> poison, <8 x i32> zeroinitializer
  %d = call <8 x half> @llvm.copysign.v8f16(<8 x half> %a, <8 x half> %c)
  store <8 x half> %d, <8 x half>* %x
  ret void
}

define void @copysign_vf_v4f32(<4 x float>* %x, float %y) {
; CHECK-LABEL: copysign_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = insertelement <4 x float> poison, float %y, i32 0
  %c = shufflevector <4 x float> %b, <4 x float> poison, <4 x i32> zeroinitializer
  %d = call <4 x float> @llvm.copysign.v4f32(<4 x float> %a, <4 x float> %c)
  store <4 x float> %d, <4 x float>* %x
  ret void
}

define void @copysign_vf_v2f64(<2 x double>* %x, double %y) {
; CHECK-LABEL: copysign_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = insertelement <2 x double> poison, double %y, i32 0
  %c = shufflevector <2 x double> %b, <2 x double> poison, <2 x i32> zeroinitializer
  %d = call <2 x double> @llvm.copysign.v2f64(<2 x double> %a, <2 x double> %c)
  store <2 x double> %d, <2 x double>* %x
  ret void
}

define void @copysign_neg_v8f16(<8 x half>* %x, <8 x half>* %y) {
; CHECK-LABEL: copysign_neg_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vle16.v v9, (a1)
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v9
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = load <8 x half>, <8 x half>* %y
  %c = fneg <8 x half> %b
  %d = call <8 x half> @llvm.copysign.v8f16(<8 x half> %a, <8 x half> %c)
  store <8 x half> %d, <8 x half>* %x
  ret void
}

define void @copysign_neg_v4f32(<4 x float>* %x, <4 x float>* %y) {
; CHECK-LABEL: copysign_neg_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v9
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = load <4 x float>, <4 x float>* %y
  %c = fneg <4 x float> %b
  %d = call <4 x float> @llvm.copysign.v4f32(<4 x float> %a, <4 x float> %c)
  store <4 x float> %d, <4 x float>* %x
  ret void
}

define void @copysign_neg_v2f64(<2 x double>* %x, <2 x double>* %y) {
; CHECK-LABEL: copysign_neg_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v9
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = load <2 x double>, <2 x double>* %y
  %c = fneg <2 x double> %b
  %d = call <2 x double> @llvm.copysign.v2f64(<2 x double> %a, <2 x double> %c)
  store <2 x double> %d, <2 x double>* %x
  ret void
}

define void @copysign_neg_trunc_v4f16_v4f32(<4 x half>* %x, <4 x float>* %y) {
; CHECK-LABEL: copysign_neg_trunc_v4f16_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vle32.v v8, (a1)
; CHECK-NEXT:    vle16.v v9, (a0)
; CHECK-NEXT:    vfncvt.f.f.w v10, v8
; CHECK-NEXT:    vfsgnjn.vv v8, v9, v10
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x half>, <4 x half>* %x
  %b = load <4 x float>, <4 x float>* %y
  %c = fneg <4 x float> %b
  %d = fptrunc <4 x float> %c to <4 x half>
  %e = call <4 x half> @llvm.copysign.v4f16(<4 x half> %a, <4 x half> %d)
  store <4 x half> %e, <4 x half>* %x
  ret void
}
declare <4 x half> @llvm.copysign.v4f16(<4 x half>, <4 x half>)

define void @copysign_neg_ext_v2f64_v2f32(<2 x double>* %x, <2 x float>* %y) {
; CHECK-LABEL: copysign_neg_ext_v2f64_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vle32.v v8, (a1)
; CHECK-NEXT:    vle64.v v9, (a0)
; CHECK-NEXT:    vfwcvt.f.f.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfsgnjn.vv v8, v9, v10
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = load <2 x float>, <2 x float>* %y
  %c = fneg <2 x float> %b
  %d = fpext <2 x float> %c to <2 x double>
  %e = call <2 x double> @llvm.copysign.v2f64(<2 x double> %a, <2 x double> %d)
  store <2 x double> %e, <2 x double>* %x
  ret void
}

define void @sqrt_v8f16(<8 x half>* %x) {
; CHECK-LABEL: sqrt_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfsqrt.v v8, v8
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = call <8 x half> @llvm.sqrt.v8f16(<8 x half> %a)
  store <8 x half> %b, <8 x half>* %x
  ret void
}
declare <8 x half> @llvm.sqrt.v8f16(<8 x half>)

define void @sqrt_v4f32(<4 x float>* %x) {
; CHECK-LABEL: sqrt_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfsqrt.v v8, v8
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = call <4 x float> @llvm.sqrt.v4f32(<4 x float> %a)
  store <4 x float> %b, <4 x float>* %x
  ret void
}
declare <4 x float> @llvm.sqrt.v4f32(<4 x float>)

define void @sqrt_v2f64(<2 x double>* %x) {
; CHECK-LABEL: sqrt_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfsqrt.v v8, v8
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = call <2 x double> @llvm.sqrt.v2f64(<2 x double> %a)
  store <2 x double> %b, <2 x double>* %x
  ret void
}
declare <2 x double> @llvm.sqrt.v2f64(<2 x double>)

define void @fma_v8f16(<8 x half>* %x, <8 x half>* %y, <8 x half>* %z) {
; CHECK-LABEL: fma_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vle16.v v9, (a1)
; CHECK-NEXT:    vle16.v v10, (a2)
; CHECK-NEXT:    vfmacc.vv v10, v8, v9
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = load <8 x half>, <8 x half>* %y
  %c = load <8 x half>, <8 x half>* %z
  %d = call <8 x half> @llvm.fma.v8f16(<8 x half> %a, <8 x half> %b, <8 x half> %c)
  store <8 x half> %d, <8 x half>* %x
  ret void
}
declare <8 x half> @llvm.fma.v8f16(<8 x half>, <8 x half>, <8 x half>)

define void @fma_v4f32(<4 x float>* %x, <4 x float>* %y, <4 x float>* %z) {
; CHECK-LABEL: fma_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vle32.v v10, (a2)
; CHECK-NEXT:    vfmacc.vv v10, v8, v9
; CHECK-NEXT:    vse32.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = load <4 x float>, <4 x float>* %y
  %c = load <4 x float>, <4 x float>* %z
  %d = call <4 x float> @llvm.fma.v4f32(<4 x float> %a, <4 x float> %b, <4 x float> %c)
  store <4 x float> %d, <4 x float>* %x
  ret void
}
declare <4 x float> @llvm.fma.v4f32(<4 x float>, <4 x float>, <4 x float>)

define void @fma_v2f64(<2 x double>* %x, <2 x double>* %y, <2 x double>* %z) {
; CHECK-LABEL: fma_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vle64.v v10, (a2)
; CHECK-NEXT:    vfmacc.vv v10, v8, v9
; CHECK-NEXT:    vse64.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = load <2 x double>, <2 x double>* %y
  %c = load <2 x double>, <2 x double>* %z
  %d = call <2 x double> @llvm.fma.v2f64(<2 x double> %a, <2 x double> %b, <2 x double> %c)
  store <2 x double> %d, <2 x double>* %x
  ret void
}
declare <2 x double> @llvm.fma.v2f64(<2 x double>, <2 x double>, <2 x double>)

define void @fmsub_v8f16(<8 x half>* %x, <8 x half>* %y, <8 x half>* %z) {
; CHECK-LABEL: fmsub_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vle16.v v9, (a1)
; CHECK-NEXT:    vle16.v v10, (a2)
; CHECK-NEXT:    vfmsac.vv v10, v8, v9
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = load <8 x half>, <8 x half>* %y
  %c = load <8 x half>, <8 x half>* %z
  %neg = fneg <8 x half> %c
  %d = call <8 x half> @llvm.fma.v8f16(<8 x half> %a, <8 x half> %b, <8 x half> %neg)
  store <8 x half> %d, <8 x half>* %x
  ret void
}

define void @fnmsub_v4f32(<4 x float>* %x, <4 x float>* %y, <4 x float>* %z) {
; CHECK-LABEL: fnmsub_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vle32.v v10, (a2)
; CHECK-NEXT:    vfnmsac.vv v10, v8, v9
; CHECK-NEXT:    vse32.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = load <4 x float>, <4 x float>* %y
  %c = load <4 x float>, <4 x float>* %z
  %neg = fneg <4 x float> %a
  %d = call <4 x float> @llvm.fma.v4f32(<4 x float> %neg, <4 x float> %b, <4 x float> %c)
  store <4 x float> %d, <4 x float>* %x
  ret void
}

define void @fnmadd_v2f64(<2 x double>* %x, <2 x double>* %y, <2 x double>* %z) {
; CHECK-LABEL: fnmadd_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vle64.v v10, (a2)
; CHECK-NEXT:    vfnmacc.vv v10, v8, v9
; CHECK-NEXT:    vse64.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = load <2 x double>, <2 x double>* %y
  %c = load <2 x double>, <2 x double>* %z
  %neg = fneg <2 x double> %b
  %neg2 = fneg <2 x double> %c
  %d = call <2 x double> @llvm.fma.v2f64(<2 x double> %a, <2 x double> %neg, <2 x double> %neg2)
  store <2 x double> %d, <2 x double>* %x
  ret void
}

define void @fadd_v16f16(<16 x half>* %x, <16 x half>* %y) {
; LMULMAX2-LABEL: fadd_v16f16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; LMULMAX2-NEXT:    vle16.v v8, (a0)
; LMULMAX2-NEXT:    vle16.v v10, (a1)
; LMULMAX2-NEXT:    vfadd.vv v8, v8, v10
; LMULMAX2-NEXT:    vse16.v v8, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: fadd_v16f16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vle16.v v8, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v9, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v10, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v11, (a1)
; LMULMAX1-RV32-NEXT:    vfadd.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vfadd.vv v8, v8, v11
; LMULMAX1-RV32-NEXT:    vse16.v v8, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v9, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: fadd_v16f16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vle16.v v8, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v9, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v10, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v11, (a1)
; LMULMAX1-RV64-NEXT:    vfadd.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vfadd.vv v8, v8, v11
; LMULMAX1-RV64-NEXT:    vse16.v v8, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v9, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x half>, <16 x half>* %x
  %b = load <16 x half>, <16 x half>* %y
  %c = fadd <16 x half> %a, %b
  store <16 x half> %c, <16 x half>* %x
  ret void
}

define void @fadd_v8f32(<8 x float>* %x, <8 x float>* %y) {
; LMULMAX2-LABEL: fadd_v8f32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; LMULMAX2-NEXT:    vle32.v v8, (a0)
; LMULMAX2-NEXT:    vle32.v v10, (a1)
; LMULMAX2-NEXT:    vfadd.vv v8, v8, v10
; LMULMAX2-NEXT:    vse32.v v8, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: fadd_v8f32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vle32.v v8, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v9, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v10, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v11, (a1)
; LMULMAX1-RV32-NEXT:    vfadd.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vfadd.vv v8, v8, v11
; LMULMAX1-RV32-NEXT:    vse32.v v8, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v9, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: fadd_v8f32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vle32.v v8, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v9, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v10, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v11, (a1)
; LMULMAX1-RV64-NEXT:    vfadd.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vfadd.vv v8, v8, v11
; LMULMAX1-RV64-NEXT:    vse32.v v8, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v9, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x float>, <8 x float>* %x
  %b = load <8 x float>, <8 x float>* %y
  %c = fadd <8 x float> %a, %b
  store <8 x float> %c, <8 x float>* %x
  ret void
}

define void @fadd_v4f64(<4 x double>* %x, <4 x double>* %y) {
; LMULMAX2-LABEL: fadd_v4f64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; LMULMAX2-NEXT:    vle64.v v8, (a0)
; LMULMAX2-NEXT:    vle64.v v10, (a1)
; LMULMAX2-NEXT:    vfadd.vv v8, v8, v10
; LMULMAX2-NEXT:    vse64.v v8, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: fadd_v4f64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vle64.v v8, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v9, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v10, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v11, (a1)
; LMULMAX1-RV32-NEXT:    vfadd.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vfadd.vv v8, v8, v11
; LMULMAX1-RV32-NEXT:    vse64.v v8, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v9, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: fadd_v4f64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vle64.v v8, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v9, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v10, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v11, (a1)
; LMULMAX1-RV64-NEXT:    vfadd.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vfadd.vv v8, v8, v11
; LMULMAX1-RV64-NEXT:    vse64.v v8, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v9, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x double>, <4 x double>* %x
  %b = load <4 x double>, <4 x double>* %y
  %c = fadd <4 x double> %a, %b
  store <4 x double> %c, <4 x double>* %x
  ret void
}

define void @fsub_v16f16(<16 x half>* %x, <16 x half>* %y) {
; LMULMAX2-LABEL: fsub_v16f16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; LMULMAX2-NEXT:    vle16.v v8, (a0)
; LMULMAX2-NEXT:    vle16.v v10, (a1)
; LMULMAX2-NEXT:    vfsub.vv v8, v8, v10
; LMULMAX2-NEXT:    vse16.v v8, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: fsub_v16f16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vle16.v v8, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v9, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v10, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v11, (a1)
; LMULMAX1-RV32-NEXT:    vfsub.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vfsub.vv v8, v8, v11
; LMULMAX1-RV32-NEXT:    vse16.v v8, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v9, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: fsub_v16f16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vle16.v v8, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v9, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v10, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v11, (a1)
; LMULMAX1-RV64-NEXT:    vfsub.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vfsub.vv v8, v8, v11
; LMULMAX1-RV64-NEXT:    vse16.v v8, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v9, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x half>, <16 x half>* %x
  %b = load <16 x half>, <16 x half>* %y
  %c = fsub <16 x half> %a, %b
  store <16 x half> %c, <16 x half>* %x
  ret void
}

define void @fsub_v8f32(<8 x float>* %x, <8 x float>* %y) {
; LMULMAX2-LABEL: fsub_v8f32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; LMULMAX2-NEXT:    vle32.v v8, (a0)
; LMULMAX2-NEXT:    vle32.v v10, (a1)
; LMULMAX2-NEXT:    vfsub.vv v8, v8, v10
; LMULMAX2-NEXT:    vse32.v v8, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: fsub_v8f32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vle32.v v8, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v9, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v10, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v11, (a1)
; LMULMAX1-RV32-NEXT:    vfsub.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vfsub.vv v8, v8, v11
; LMULMAX1-RV32-NEXT:    vse32.v v8, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v9, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: fsub_v8f32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vle32.v v8, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v9, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v10, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v11, (a1)
; LMULMAX1-RV64-NEXT:    vfsub.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vfsub.vv v8, v8, v11
; LMULMAX1-RV64-NEXT:    vse32.v v8, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v9, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x float>, <8 x float>* %x
  %b = load <8 x float>, <8 x float>* %y
  %c = fsub <8 x float> %a, %b
  store <8 x float> %c, <8 x float>* %x
  ret void
}

define void @fsub_v4f64(<4 x double>* %x, <4 x double>* %y) {
; LMULMAX2-LABEL: fsub_v4f64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; LMULMAX2-NEXT:    vle64.v v8, (a0)
; LMULMAX2-NEXT:    vle64.v v10, (a1)
; LMULMAX2-NEXT:    vfsub.vv v8, v8, v10
; LMULMAX2-NEXT:    vse64.v v8, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: fsub_v4f64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vle64.v v8, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v9, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v10, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v11, (a1)
; LMULMAX1-RV32-NEXT:    vfsub.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vfsub.vv v8, v8, v11
; LMULMAX1-RV32-NEXT:    vse64.v v8, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v9, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: fsub_v4f64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vle64.v v8, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v9, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v10, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v11, (a1)
; LMULMAX1-RV64-NEXT:    vfsub.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vfsub.vv v8, v8, v11
; LMULMAX1-RV64-NEXT:    vse64.v v8, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v9, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x double>, <4 x double>* %x
  %b = load <4 x double>, <4 x double>* %y
  %c = fsub <4 x double> %a, %b
  store <4 x double> %c, <4 x double>* %x
  ret void
}

define void @fmul_v16f16(<16 x half>* %x, <16 x half>* %y) {
; LMULMAX2-LABEL: fmul_v16f16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; LMULMAX2-NEXT:    vle16.v v8, (a0)
; LMULMAX2-NEXT:    vle16.v v10, (a1)
; LMULMAX2-NEXT:    vfmul.vv v8, v8, v10
; LMULMAX2-NEXT:    vse16.v v8, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: fmul_v16f16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vle16.v v8, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v9, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v10, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v11, (a1)
; LMULMAX1-RV32-NEXT:    vfmul.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vfmul.vv v8, v8, v11
; LMULMAX1-RV32-NEXT:    vse16.v v8, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v9, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: fmul_v16f16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vle16.v v8, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v9, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v10, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v11, (a1)
; LMULMAX1-RV64-NEXT:    vfmul.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vfmul.vv v8, v8, v11
; LMULMAX1-RV64-NEXT:    vse16.v v8, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v9, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x half>, <16 x half>* %x
  %b = load <16 x half>, <16 x half>* %y
  %c = fmul <16 x half> %a, %b
  store <16 x half> %c, <16 x half>* %x
  ret void
}

define void @fmul_v8f32(<8 x float>* %x, <8 x float>* %y) {
; LMULMAX2-LABEL: fmul_v8f32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; LMULMAX2-NEXT:    vle32.v v8, (a0)
; LMULMAX2-NEXT:    vle32.v v10, (a1)
; LMULMAX2-NEXT:    vfmul.vv v8, v8, v10
; LMULMAX2-NEXT:    vse32.v v8, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: fmul_v8f32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vle32.v v8, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v9, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v10, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v11, (a1)
; LMULMAX1-RV32-NEXT:    vfmul.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vfmul.vv v8, v8, v11
; LMULMAX1-RV32-NEXT:    vse32.v v8, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v9, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: fmul_v8f32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vle32.v v8, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v9, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v10, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v11, (a1)
; LMULMAX1-RV64-NEXT:    vfmul.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vfmul.vv v8, v8, v11
; LMULMAX1-RV64-NEXT:    vse32.v v8, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v9, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x float>, <8 x float>* %x
  %b = load <8 x float>, <8 x float>* %y
  %c = fmul <8 x float> %a, %b
  store <8 x float> %c, <8 x float>* %x
  ret void
}

define void @fmul_v4f64(<4 x double>* %x, <4 x double>* %y) {
; LMULMAX2-LABEL: fmul_v4f64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; LMULMAX2-NEXT:    vle64.v v8, (a0)
; LMULMAX2-NEXT:    vle64.v v10, (a1)
; LMULMAX2-NEXT:    vfmul.vv v8, v8, v10
; LMULMAX2-NEXT:    vse64.v v8, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: fmul_v4f64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vle64.v v8, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v9, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v10, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v11, (a1)
; LMULMAX1-RV32-NEXT:    vfmul.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vfmul.vv v8, v8, v11
; LMULMAX1-RV32-NEXT:    vse64.v v8, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v9, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: fmul_v4f64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vle64.v v8, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v9, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v10, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v11, (a1)
; LMULMAX1-RV64-NEXT:    vfmul.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vfmul.vv v8, v8, v11
; LMULMAX1-RV64-NEXT:    vse64.v v8, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v9, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x double>, <4 x double>* %x
  %b = load <4 x double>, <4 x double>* %y
  %c = fmul <4 x double> %a, %b
  store <4 x double> %c, <4 x double>* %x
  ret void
}

define void @fdiv_v16f16(<16 x half>* %x, <16 x half>* %y) {
; LMULMAX2-LABEL: fdiv_v16f16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; LMULMAX2-NEXT:    vle16.v v8, (a0)
; LMULMAX2-NEXT:    vle16.v v10, (a1)
; LMULMAX2-NEXT:    vfdiv.vv v8, v8, v10
; LMULMAX2-NEXT:    vse16.v v8, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: fdiv_v16f16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vle16.v v8, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v9, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v10, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v11, (a1)
; LMULMAX1-RV32-NEXT:    vfdiv.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vfdiv.vv v8, v8, v11
; LMULMAX1-RV32-NEXT:    vse16.v v8, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v9, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: fdiv_v16f16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vle16.v v8, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v9, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v10, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v11, (a1)
; LMULMAX1-RV64-NEXT:    vfdiv.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vfdiv.vv v8, v8, v11
; LMULMAX1-RV64-NEXT:    vse16.v v8, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v9, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x half>, <16 x half>* %x
  %b = load <16 x half>, <16 x half>* %y
  %c = fdiv <16 x half> %a, %b
  store <16 x half> %c, <16 x half>* %x
  ret void
}

define void @fdiv_v8f32(<8 x float>* %x, <8 x float>* %y) {
; LMULMAX2-LABEL: fdiv_v8f32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; LMULMAX2-NEXT:    vle32.v v8, (a0)
; LMULMAX2-NEXT:    vle32.v v10, (a1)
; LMULMAX2-NEXT:    vfdiv.vv v8, v8, v10
; LMULMAX2-NEXT:    vse32.v v8, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: fdiv_v8f32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vle32.v v8, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v9, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v10, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v11, (a1)
; LMULMAX1-RV32-NEXT:    vfdiv.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vfdiv.vv v8, v8, v11
; LMULMAX1-RV32-NEXT:    vse32.v v8, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v9, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: fdiv_v8f32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vle32.v v8, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v9, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v10, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v11, (a1)
; LMULMAX1-RV64-NEXT:    vfdiv.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vfdiv.vv v8, v8, v11
; LMULMAX1-RV64-NEXT:    vse32.v v8, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v9, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x float>, <8 x float>* %x
  %b = load <8 x float>, <8 x float>* %y
  %c = fdiv <8 x float> %a, %b
  store <8 x float> %c, <8 x float>* %x
  ret void
}

define void @fdiv_v4f64(<4 x double>* %x, <4 x double>* %y) {
; LMULMAX2-LABEL: fdiv_v4f64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; LMULMAX2-NEXT:    vle64.v v8, (a0)
; LMULMAX2-NEXT:    vle64.v v10, (a1)
; LMULMAX2-NEXT:    vfdiv.vv v8, v8, v10
; LMULMAX2-NEXT:    vse64.v v8, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: fdiv_v4f64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vle64.v v8, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v9, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v10, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v11, (a1)
; LMULMAX1-RV32-NEXT:    vfdiv.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vfdiv.vv v8, v8, v11
; LMULMAX1-RV32-NEXT:    vse64.v v8, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v9, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: fdiv_v4f64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vle64.v v8, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v9, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v10, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v11, (a1)
; LMULMAX1-RV64-NEXT:    vfdiv.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vfdiv.vv v8, v8, v11
; LMULMAX1-RV64-NEXT:    vse64.v v8, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v9, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x double>, <4 x double>* %x
  %b = load <4 x double>, <4 x double>* %y
  %c = fdiv <4 x double> %a, %b
  store <4 x double> %c, <4 x double>* %x
  ret void
}

define void @fneg_v16f16(<16 x half>* %x) {
; LMULMAX2-LABEL: fneg_v16f16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; LMULMAX2-NEXT:    vle16.v v8, (a0)
; LMULMAX2-NEXT:    vfneg.v v8, v8
; LMULMAX2-NEXT:    vse16.v v8, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-LABEL: fneg_v16f16:
; LMULMAX1:       # %bb.0:
; LMULMAX1-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; LMULMAX1-NEXT:    addi a1, a0, 16
; LMULMAX1-NEXT:    vle16.v v8, (a1)
; LMULMAX1-NEXT:    vle16.v v9, (a0)
; LMULMAX1-NEXT:    vfneg.v v8, v8
; LMULMAX1-NEXT:    vfneg.v v9, v9
; LMULMAX1-NEXT:    vse16.v v9, (a0)
; LMULMAX1-NEXT:    vse16.v v8, (a1)
; LMULMAX1-NEXT:    ret
  %a = load <16 x half>, <16 x half>* %x
  %b = fneg <16 x half> %a
  store <16 x half> %b, <16 x half>* %x
  ret void
}

define void @fneg_v8f32(<8 x float>* %x) {
; LMULMAX2-LABEL: fneg_v8f32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; LMULMAX2-NEXT:    vle32.v v8, (a0)
; LMULMAX2-NEXT:    vfneg.v v8, v8
; LMULMAX2-NEXT:    vse32.v v8, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-LABEL: fneg_v8f32:
; LMULMAX1:       # %bb.0:
; LMULMAX1-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-NEXT:    addi a1, a0, 16
; LMULMAX1-NEXT:    vle32.v v8, (a1)
; LMULMAX1-NEXT:    vle32.v v9, (a0)
; LMULMAX1-NEXT:    vfneg.v v8, v8
; LMULMAX1-NEXT:    vfneg.v v9, v9
; LMULMAX1-NEXT:    vse32.v v9, (a0)
; LMULMAX1-NEXT:    vse32.v v8, (a1)
; LMULMAX1-NEXT:    ret
  %a = load <8 x float>, <8 x float>* %x
  %b = fneg <8 x float> %a
  store <8 x float> %b, <8 x float>* %x
  ret void
}

define void @fneg_v4f64(<4 x double>* %x) {
; LMULMAX2-LABEL: fneg_v4f64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; LMULMAX2-NEXT:    vle64.v v8, (a0)
; LMULMAX2-NEXT:    vfneg.v v8, v8
; LMULMAX2-NEXT:    vse64.v v8, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-LABEL: fneg_v4f64:
; LMULMAX1:       # %bb.0:
; LMULMAX1-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-NEXT:    addi a1, a0, 16
; LMULMAX1-NEXT:    vle64.v v8, (a1)
; LMULMAX1-NEXT:    vle64.v v9, (a0)
; LMULMAX1-NEXT:    vfneg.v v8, v8
; LMULMAX1-NEXT:    vfneg.v v9, v9
; LMULMAX1-NEXT:    vse64.v v9, (a0)
; LMULMAX1-NEXT:    vse64.v v8, (a1)
; LMULMAX1-NEXT:    ret
  %a = load <4 x double>, <4 x double>* %x
  %b = fneg <4 x double> %a
  store <4 x double> %b, <4 x double>* %x
  ret void
}

define void @fma_v16f16(<16 x half>* %x, <16 x half>* %y, <16 x half>* %z) {
; LMULMAX2-LABEL: fma_v16f16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; LMULMAX2-NEXT:    vle16.v v8, (a0)
; LMULMAX2-NEXT:    vle16.v v10, (a1)
; LMULMAX2-NEXT:    vle16.v v12, (a2)
; LMULMAX2-NEXT:    vfmacc.vv v12, v8, v10
; LMULMAX2-NEXT:    vse16.v v12, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-LABEL: fma_v16f16:
; LMULMAX1:       # %bb.0:
; LMULMAX1-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; LMULMAX1-NEXT:    vle16.v v8, (a0)
; LMULMAX1-NEXT:    addi a3, a0, 16
; LMULMAX1-NEXT:    vle16.v v9, (a3)
; LMULMAX1-NEXT:    vle16.v v10, (a1)
; LMULMAX1-NEXT:    addi a1, a1, 16
; LMULMAX1-NEXT:    vle16.v v11, (a1)
; LMULMAX1-NEXT:    addi a1, a2, 16
; LMULMAX1-NEXT:    vle16.v v12, (a1)
; LMULMAX1-NEXT:    vle16.v v13, (a2)
; LMULMAX1-NEXT:    vfmacc.vv v12, v9, v11
; LMULMAX1-NEXT:    vfmacc.vv v13, v8, v10
; LMULMAX1-NEXT:    vse16.v v13, (a0)
; LMULMAX1-NEXT:    vse16.v v12, (a3)
; LMULMAX1-NEXT:    ret
  %a = load <16 x half>, <16 x half>* %x
  %b = load <16 x half>, <16 x half>* %y
  %c = load <16 x half>, <16 x half>* %z
  %d = call <16 x half> @llvm.fma.v16f16(<16 x half> %a, <16 x half> %b, <16 x half> %c)
  store <16 x half> %d, <16 x half>* %x
  ret void
}
declare <16 x half> @llvm.fma.v16f16(<16 x half>, <16 x half>, <16 x half>)

define void @fma_v8f32(<8 x float>* %x, <8 x float>* %y, <8 x float>* %z) {
; LMULMAX2-LABEL: fma_v8f32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; LMULMAX2-NEXT:    vle32.v v8, (a0)
; LMULMAX2-NEXT:    vle32.v v10, (a1)
; LMULMAX2-NEXT:    vle32.v v12, (a2)
; LMULMAX2-NEXT:    vfmacc.vv v12, v8, v10
; LMULMAX2-NEXT:    vse32.v v12, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-LABEL: fma_v8f32:
; LMULMAX1:       # %bb.0:
; LMULMAX1-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-NEXT:    vle32.v v8, (a0)
; LMULMAX1-NEXT:    addi a3, a0, 16
; LMULMAX1-NEXT:    vle32.v v9, (a3)
; LMULMAX1-NEXT:    vle32.v v10, (a1)
; LMULMAX1-NEXT:    addi a1, a1, 16
; LMULMAX1-NEXT:    vle32.v v11, (a1)
; LMULMAX1-NEXT:    addi a1, a2, 16
; LMULMAX1-NEXT:    vle32.v v12, (a1)
; LMULMAX1-NEXT:    vle32.v v13, (a2)
; LMULMAX1-NEXT:    vfmacc.vv v12, v9, v11
; LMULMAX1-NEXT:    vfmacc.vv v13, v8, v10
; LMULMAX1-NEXT:    vse32.v v13, (a0)
; LMULMAX1-NEXT:    vse32.v v12, (a3)
; LMULMAX1-NEXT:    ret
  %a = load <8 x float>, <8 x float>* %x
  %b = load <8 x float>, <8 x float>* %y
  %c = load <8 x float>, <8 x float>* %z
  %d = call <8 x float> @llvm.fma.v8f32(<8 x float> %a, <8 x float> %b, <8 x float> %c)
  store <8 x float> %d, <8 x float>* %x
  ret void
}
declare <8 x float> @llvm.fma.v8f32(<8 x float>, <8 x float>, <8 x float>)

define void @fma_v4f64(<4 x double>* %x, <4 x double>* %y, <4 x double>* %z) {
; LMULMAX2-LABEL: fma_v4f64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; LMULMAX2-NEXT:    vle64.v v8, (a0)
; LMULMAX2-NEXT:    vle64.v v10, (a1)
; LMULMAX2-NEXT:    vle64.v v12, (a2)
; LMULMAX2-NEXT:    vfmacc.vv v12, v8, v10
; LMULMAX2-NEXT:    vse64.v v12, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-LABEL: fma_v4f64:
; LMULMAX1:       # %bb.0:
; LMULMAX1-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-NEXT:    vle64.v v8, (a0)
; LMULMAX1-NEXT:    addi a3, a0, 16
; LMULMAX1-NEXT:    vle64.v v9, (a3)
; LMULMAX1-NEXT:    vle64.v v10, (a1)
; LMULMAX1-NEXT:    addi a1, a1, 16
; LMULMAX1-NEXT:    vle64.v v11, (a1)
; LMULMAX1-NEXT:    addi a1, a2, 16
; LMULMAX1-NEXT:    vle64.v v12, (a1)
; LMULMAX1-NEXT:    vle64.v v13, (a2)
; LMULMAX1-NEXT:    vfmacc.vv v12, v9, v11
; LMULMAX1-NEXT:    vfmacc.vv v13, v8, v10
; LMULMAX1-NEXT:    vse64.v v13, (a0)
; LMULMAX1-NEXT:    vse64.v v12, (a3)
; LMULMAX1-NEXT:    ret
  %a = load <4 x double>, <4 x double>* %x
  %b = load <4 x double>, <4 x double>* %y
  %c = load <4 x double>, <4 x double>* %z
  %d = call <4 x double> @llvm.fma.v4f64(<4 x double> %a, <4 x double> %b, <4 x double> %c)
  store <4 x double> %d, <4 x double>* %x
  ret void
}
declare <4 x double> @llvm.fma.v4f64(<4 x double>, <4 x double>, <4 x double>)

define void @fadd_vf_v8f16(<8 x half>* %x, half %y) {
; CHECK-LABEL: fadd_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfadd.vf v8, v8, fa0
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = insertelement <8 x half> poison, half %y, i32 0
  %c = shufflevector <8 x half> %b, <8 x half> poison, <8 x i32> zeroinitializer
  %d = fadd <8 x half> %a, %c
  store <8 x half> %d, <8 x half>* %x
  ret void
}

define void @fadd_vf_v4f32(<4 x float>* %x, float %y) {
; CHECK-LABEL: fadd_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfadd.vf v8, v8, fa0
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = insertelement <4 x float> poison, float %y, i32 0
  %c = shufflevector <4 x float> %b, <4 x float> poison, <4 x i32> zeroinitializer
  %d = fadd <4 x float> %a, %c
  store <4 x float> %d, <4 x float>* %x
  ret void
}

define void @fadd_vf_v2f64(<2 x double>* %x, double %y) {
; CHECK-LABEL: fadd_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfadd.vf v8, v8, fa0
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = insertelement <2 x double> poison, double %y, i32 0
  %c = shufflevector <2 x double> %b, <2 x double> poison, <2 x i32> zeroinitializer
  %d = fadd <2 x double> %a, %c
  store <2 x double> %d, <2 x double>* %x
  ret void
}

define void @fadd_fv_v8f16(<8 x half>* %x, half %y) {
; CHECK-LABEL: fadd_fv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfadd.vf v8, v8, fa0
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = insertelement <8 x half> poison, half %y, i32 0
  %c = shufflevector <8 x half> %b, <8 x half> poison, <8 x i32> zeroinitializer
  %d = fadd <8 x half> %c, %a
  store <8 x half> %d, <8 x half>* %x
  ret void
}

define void @fadd_fv_v4f32(<4 x float>* %x, float %y) {
; CHECK-LABEL: fadd_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfadd.vf v8, v8, fa0
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = insertelement <4 x float> poison, float %y, i32 0
  %c = shufflevector <4 x float> %b, <4 x float> poison, <4 x i32> zeroinitializer
  %d = fadd <4 x float> %c, %a
  store <4 x float> %d, <4 x float>* %x
  ret void
}

define void @fadd_fv_v2f64(<2 x double>* %x, double %y) {
; CHECK-LABEL: fadd_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfadd.vf v8, v8, fa0
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = insertelement <2 x double> poison, double %y, i32 0
  %c = shufflevector <2 x double> %b, <2 x double> poison, <2 x i32> zeroinitializer
  %d = fadd <2 x double> %c, %a
  store <2 x double> %d, <2 x double>* %x
  ret void
}

define void @fsub_vf_v8f16(<8 x half>* %x, half %y) {
; CHECK-LABEL: fsub_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfsub.vf v8, v8, fa0
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = insertelement <8 x half> poison, half %y, i32 0
  %c = shufflevector <8 x half> %b, <8 x half> poison, <8 x i32> zeroinitializer
  %d = fsub <8 x half> %a, %c
  store <8 x half> %d, <8 x half>* %x
  ret void
}

define void @fsub_vf_v4f32(<4 x float>* %x, float %y) {
; CHECK-LABEL: fsub_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfsub.vf v8, v8, fa0
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = insertelement <4 x float> poison, float %y, i32 0
  %c = shufflevector <4 x float> %b, <4 x float> poison, <4 x i32> zeroinitializer
  %d = fsub <4 x float> %a, %c
  store <4 x float> %d, <4 x float>* %x
  ret void
}

define void @fsub_vf_v2f64(<2 x double>* %x, double %y) {
; CHECK-LABEL: fsub_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfsub.vf v8, v8, fa0
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = insertelement <2 x double> poison, double %y, i32 0
  %c = shufflevector <2 x double> %b, <2 x double> poison, <2 x i32> zeroinitializer
  %d = fsub <2 x double> %a, %c
  store <2 x double> %d, <2 x double>* %x
  ret void
}

define void @fsub_fv_v8f16(<8 x half>* %x, half %y) {
; CHECK-LABEL: fsub_fv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfrsub.vf v8, v8, fa0
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = insertelement <8 x half> poison, half %y, i32 0
  %c = shufflevector <8 x half> %b, <8 x half> poison, <8 x i32> zeroinitializer
  %d = fsub <8 x half> %c, %a
  store <8 x half> %d, <8 x half>* %x
  ret void
}

define void @fsub_fv_v4f32(<4 x float>* %x, float %y) {
; CHECK-LABEL: fsub_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfrsub.vf v8, v8, fa0
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = insertelement <4 x float> poison, float %y, i32 0
  %c = shufflevector <4 x float> %b, <4 x float> poison, <4 x i32> zeroinitializer
  %d = fsub <4 x float> %c, %a
  store <4 x float> %d, <4 x float>* %x
  ret void
}

define void @fsub_fv_v2f64(<2 x double>* %x, double %y) {
; CHECK-LABEL: fsub_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfrsub.vf v8, v8, fa0
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = insertelement <2 x double> poison, double %y, i32 0
  %c = shufflevector <2 x double> %b, <2 x double> poison, <2 x i32> zeroinitializer
  %d = fsub <2 x double> %c, %a
  store <2 x double> %d, <2 x double>* %x
  ret void
}

define void @fmul_vf_v8f16(<8 x half>* %x, half %y) {
; CHECK-LABEL: fmul_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmul.vf v8, v8, fa0
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = insertelement <8 x half> poison, half %y, i32 0
  %c = shufflevector <8 x half> %b, <8 x half> poison, <8 x i32> zeroinitializer
  %d = fmul <8 x half> %a, %c
  store <8 x half> %d, <8 x half>* %x
  ret void
}

define void @fmul_vf_v4f32(<4 x float>* %x, float %y) {
; CHECK-LABEL: fmul_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmul.vf v8, v8, fa0
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = insertelement <4 x float> poison, float %y, i32 0
  %c = shufflevector <4 x float> %b, <4 x float> poison, <4 x i32> zeroinitializer
  %d = fmul <4 x float> %a, %c
  store <4 x float> %d, <4 x float>* %x
  ret void
}

define void @fmul_vf_v2f64(<2 x double>* %x, double %y) {
; CHECK-LABEL: fmul_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfmul.vf v8, v8, fa0
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = insertelement <2 x double> poison, double %y, i32 0
  %c = shufflevector <2 x double> %b, <2 x double> poison, <2 x i32> zeroinitializer
  %d = fmul <2 x double> %a, %c
  store <2 x double> %d, <2 x double>* %x
  ret void
}

define void @fmul_fv_v8f16(<8 x half>* %x, half %y) {
; CHECK-LABEL: fmul_fv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmul.vf v8, v8, fa0
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = insertelement <8 x half> poison, half %y, i32 0
  %c = shufflevector <8 x half> %b, <8 x half> poison, <8 x i32> zeroinitializer
  %d = fmul <8 x half> %c, %a
  store <8 x half> %d, <8 x half>* %x
  ret void
}

define void @fmul_fv_v4f32(<4 x float>* %x, float %y) {
; CHECK-LABEL: fmul_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmul.vf v8, v8, fa0
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = insertelement <4 x float> poison, float %y, i32 0
  %c = shufflevector <4 x float> %b, <4 x float> poison, <4 x i32> zeroinitializer
  %d = fmul <4 x float> %c, %a
  store <4 x float> %d, <4 x float>* %x
  ret void
}

define void @fmul_fv_v2f64(<2 x double>* %x, double %y) {
; CHECK-LABEL: fmul_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfmul.vf v8, v8, fa0
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = insertelement <2 x double> poison, double %y, i32 0
  %c = shufflevector <2 x double> %b, <2 x double> poison, <2 x i32> zeroinitializer
  %d = fmul <2 x double> %c, %a
  store <2 x double> %d, <2 x double>* %x
  ret void
}

define void @fdiv_vf_v8f16(<8 x half>* %x, half %y) {
; CHECK-LABEL: fdiv_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfdiv.vf v8, v8, fa0
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = insertelement <8 x half> poison, half %y, i32 0
  %c = shufflevector <8 x half> %b, <8 x half> poison, <8 x i32> zeroinitializer
  %d = fdiv <8 x half> %a, %c
  store <8 x half> %d, <8 x half>* %x
  ret void
}

define void @fdiv_vf_v4f32(<4 x float>* %x, float %y) {
; CHECK-LABEL: fdiv_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfdiv.vf v8, v8, fa0
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = insertelement <4 x float> poison, float %y, i32 0
  %c = shufflevector <4 x float> %b, <4 x float> poison, <4 x i32> zeroinitializer
  %d = fdiv <4 x float> %a, %c
  store <4 x float> %d, <4 x float>* %x
  ret void
}

define void @fdiv_vf_v2f64(<2 x double>* %x, double %y) {
; CHECK-LABEL: fdiv_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfdiv.vf v8, v8, fa0
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = insertelement <2 x double> poison, double %y, i32 0
  %c = shufflevector <2 x double> %b, <2 x double> poison, <2 x i32> zeroinitializer
  %d = fdiv <2 x double> %a, %c
  store <2 x double> %d, <2 x double>* %x
  ret void
}

define void @fdiv_fv_v8f16(<8 x half>* %x, half %y) {
; CHECK-LABEL: fdiv_fv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfrdiv.vf v8, v8, fa0
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = insertelement <8 x half> poison, half %y, i32 0
  %c = shufflevector <8 x half> %b, <8 x half> poison, <8 x i32> zeroinitializer
  %d = fdiv <8 x half> %c, %a
  store <8 x half> %d, <8 x half>* %x
  ret void
}

define void @fdiv_fv_v4f32(<4 x float>* %x, float %y) {
; CHECK-LABEL: fdiv_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfrdiv.vf v8, v8, fa0
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = insertelement <4 x float> poison, float %y, i32 0
  %c = shufflevector <4 x float> %b, <4 x float> poison, <4 x i32> zeroinitializer
  %d = fdiv <4 x float> %c, %a
  store <4 x float> %d, <4 x float>* %x
  ret void
}

define void @fdiv_fv_v2f64(<2 x double>* %x, double %y) {
; CHECK-LABEL: fdiv_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfrdiv.vf v8, v8, fa0
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = insertelement <2 x double> poison, double %y, i32 0
  %c = shufflevector <2 x double> %b, <2 x double> poison, <2 x i32> zeroinitializer
  %d = fdiv <2 x double> %c, %a
  store <2 x double> %d, <2 x double>* %x
  ret void
}

define void @fma_vf_v8f16(<8 x half>* %x, <8 x half>* %y, half %z) {
; CHECK-LABEL: fma_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vle16.v v9, (a1)
; CHECK-NEXT:    vfmacc.vf v9, fa0, v8
; CHECK-NEXT:    vse16.v v9, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = load <8 x half>, <8 x half>* %y
  %c = insertelement <8 x half> poison, half %z, i32 0
  %d = shufflevector <8 x half> %c, <8 x half> poison, <8 x i32> zeroinitializer
  %e = call <8 x half> @llvm.fma.v8f16(<8 x half> %a, <8 x half> %d, <8 x half> %b)
  store <8 x half> %e, <8 x half>* %x
  ret void
}

define void @fma_vf_v4f32(<4 x float>* %x, <4 x float>* %y, float %z) {
; CHECK-LABEL: fma_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vfmacc.vf v9, fa0, v8
; CHECK-NEXT:    vse32.v v9, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = load <4 x float>, <4 x float>* %y
  %c = insertelement <4 x float> poison, float %z, i32 0
  %d = shufflevector <4 x float> %c, <4 x float> poison, <4 x i32> zeroinitializer
  %e = call <4 x float> @llvm.fma.v4f32(<4 x float> %a, <4 x float> %d, <4 x float> %b)
  store <4 x float> %e, <4 x float>* %x
  ret void
}

define void @fma_vf_v2f64(<2 x double>* %x, <2 x double>* %y, double %z) {
; CHECK-LABEL: fma_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vfmacc.vf v9, fa0, v8
; CHECK-NEXT:    vse64.v v9, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = load <2 x double>, <2 x double>* %y
  %c = insertelement <2 x double> poison, double %z, i32 0
  %d = shufflevector <2 x double> %c, <2 x double> poison, <2 x i32> zeroinitializer
  %e = call <2 x double> @llvm.fma.v2f64(<2 x double> %a, <2 x double> %d, <2 x double> %b)
  store <2 x double> %e, <2 x double>* %x
  ret void
}

define void @fma_fv_v8f16(<8 x half>* %x, <8 x half>* %y, half %z) {
; CHECK-LABEL: fma_fv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vle16.v v9, (a1)
; CHECK-NEXT:    vfmacc.vf v9, fa0, v8
; CHECK-NEXT:    vse16.v v9, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = load <8 x half>, <8 x half>* %y
  %c = insertelement <8 x half> poison, half %z, i32 0
  %d = shufflevector <8 x half> %c, <8 x half> poison, <8 x i32> zeroinitializer
  %e = call <8 x half> @llvm.fma.v8f16(<8 x half> %d, <8 x half> %a, <8 x half> %b)
  store <8 x half> %e, <8 x half>* %x
  ret void
}

define void @fma_fv_v4f32(<4 x float>* %x, <4 x float>* %y, float %z) {
; CHECK-LABEL: fma_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vfmacc.vf v9, fa0, v8
; CHECK-NEXT:    vse32.v v9, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = load <4 x float>, <4 x float>* %y
  %c = insertelement <4 x float> poison, float %z, i32 0
  %d = shufflevector <4 x float> %c, <4 x float> poison, <4 x i32> zeroinitializer
  %e = call <4 x float> @llvm.fma.v4f32(<4 x float> %d, <4 x float> %a, <4 x float> %b)
  store <4 x float> %e, <4 x float>* %x
  ret void
}

define void @fma_fv_v2f64(<2 x double>* %x, <2 x double>* %y, double %z) {
; CHECK-LABEL: fma_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vfmacc.vf v9, fa0, v8
; CHECK-NEXT:    vse64.v v9, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = load <2 x double>, <2 x double>* %y
  %c = insertelement <2 x double> poison, double %z, i32 0
  %d = shufflevector <2 x double> %c, <2 x double> poison, <2 x i32> zeroinitializer
  %e = call <2 x double> @llvm.fma.v2f64(<2 x double> %d, <2 x double> %a, <2 x double> %b)
  store <2 x double> %e, <2 x double>* %x
  ret void
}

define void @fmsub_vf_v8f16(<8 x half>* %x, <8 x half>* %y, half %z) {
; CHECK-LABEL: fmsub_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vle16.v v9, (a1)
; CHECK-NEXT:    vfmsac.vf v9, fa0, v8
; CHECK-NEXT:    vse16.v v9, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = load <8 x half>, <8 x half>* %y
  %c = insertelement <8 x half> poison, half %z, i32 0
  %d = shufflevector <8 x half> %c, <8 x half> poison, <8 x i32> zeroinitializer
  %neg = fneg <8 x half> %b
  %e = call <8 x half> @llvm.fma.v8f16(<8 x half> %a, <8 x half> %d, <8 x half> %neg)
  store <8 x half> %e, <8 x half>* %x
  ret void
}

define void @fnmsub_vf_v4f32(<4 x float>* %x, <4 x float>* %y, float %z) {
; CHECK-LABEL: fnmsub_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vfnmsac.vf v9, fa0, v8
; CHECK-NEXT:    vse32.v v9, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = load <4 x float>, <4 x float>* %y
  %c = insertelement <4 x float> poison, float %z, i32 0
  %d = shufflevector <4 x float> %c, <4 x float> poison, <4 x i32> zeroinitializer
  %neg = fneg <4 x float> %a
  %e = call <4 x float> @llvm.fma.v4f32(<4 x float> %neg, <4 x float> %d, <4 x float> %b)
  store <4 x float> %e, <4 x float>* %x
  ret void
}

define void @fnmadd_vf_v2f64(<2 x double>* %x, <2 x double>* %y, double %z) {
; CHECK-LABEL: fnmadd_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vfnmacc.vf v9, fa0, v8
; CHECK-NEXT:    vse64.v v9, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = load <2 x double>, <2 x double>* %y
  %c = insertelement <2 x double> poison, double %z, i32 0
  %d = shufflevector <2 x double> %c, <2 x double> poison, <2 x i32> zeroinitializer
  %neg = fneg <2 x double> %a
  %neg2 = fneg <2 x double> %b
  %e = call <2 x double> @llvm.fma.v2f64(<2 x double> %neg, <2 x double> %d, <2 x double> %neg2)
  store <2 x double> %e, <2 x double>* %x
  ret void
}

define void @fnmsub_fv_v4f32(<4 x float>* %x, <4 x float>* %y, float %z) {
; CHECK-LABEL: fnmsub_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vfnmsac.vf v9, fa0, v8
; CHECK-NEXT:    vse32.v v9, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = load <4 x float>, <4 x float>* %y
  %c = insertelement <4 x float> poison, float %z, i32 0
  %d = shufflevector <4 x float> %c, <4 x float> poison, <4 x i32> zeroinitializer
  %neg = fneg <4 x float> %d
  %e = call <4 x float> @llvm.fma.v4f32(<4 x float> %neg, <4 x float> %a, <4 x float> %b)
  store <4 x float> %e, <4 x float>* %x
  ret void
}

define void @fnmadd_fv_v2f64(<2 x double>* %x, <2 x double>* %y, double %z) {
; CHECK-LABEL: fnmadd_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vfnmacc.vf v9, fa0, v8
; CHECK-NEXT:    vse64.v v9, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = load <2 x double>, <2 x double>* %y
  %c = insertelement <2 x double> poison, double %z, i32 0
  %d = shufflevector <2 x double> %c, <2 x double> poison, <2 x i32> zeroinitializer
  %neg = fneg <2 x double> %d
  %neg2 = fneg <2 x double> %b
  %e = call <2 x double> @llvm.fma.v2f64(<2 x double> %neg, <2 x double> %a, <2 x double> %neg2)
  store <2 x double> %e, <2 x double>* %x
  ret void
}

define void @trunc_v8f16(<8 x half>* %x) {
; CHECK-LABEL: trunc_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    lui a1, %hi(.LCPI91_0)
; CHECK-NEXT:    flh ft0, %lo(.LCPI91_0)(a1)
; CHECK-NEXT:    vfabs.v v9, v8
; CHECK-NEXT:    vmflt.vf v0, v9, ft0
; CHECK-NEXT:    vfcvt.rtz.x.f.v v9, v8
; CHECK-NEXT:    vfcvt.f.x.v v9, v9
; CHECK-NEXT:    vfsgnj.vv v9, v9, v8
; CHECK-NEXT:    vmerge.vvm v8, v8, v9, v0
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = call <8 x half> @llvm.trunc.v8f16(<8 x half> %a)
  store <8 x half> %b, <8 x half>* %x
  ret void
}
declare <8 x half> @llvm.trunc.v8f16(<8 x half>)

define void @trunc_v4f32(<4 x float>* %x) {
; CHECK-LABEL: trunc_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    lui a1, %hi(.LCPI92_0)
; CHECK-NEXT:    flw ft0, %lo(.LCPI92_0)(a1)
; CHECK-NEXT:    vfabs.v v9, v8
; CHECK-NEXT:    vmflt.vf v0, v9, ft0
; CHECK-NEXT:    vfcvt.rtz.x.f.v v9, v8
; CHECK-NEXT:    vfcvt.f.x.v v9, v9
; CHECK-NEXT:    vfsgnj.vv v9, v9, v8
; CHECK-NEXT:    vmerge.vvm v8, v8, v9, v0
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = call <4 x float> @llvm.trunc.v4f32(<4 x float> %a)
  store <4 x float> %b, <4 x float>* %x
  ret void
}
declare <4 x float> @llvm.trunc.v4f32(<4 x float>)

define void @trunc_v2f64(<2 x double>* %x) {
; CHECK-LABEL: trunc_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    lui a1, %hi(.LCPI93_0)
; CHECK-NEXT:    fld ft0, %lo(.LCPI93_0)(a1)
; CHECK-NEXT:    vfabs.v v9, v8
; CHECK-NEXT:    vmflt.vf v0, v9, ft0
; CHECK-NEXT:    vfcvt.rtz.x.f.v v9, v8
; CHECK-NEXT:    vfcvt.f.x.v v9, v9
; CHECK-NEXT:    vfsgnj.vv v9, v9, v8
; CHECK-NEXT:    vmerge.vvm v8, v8, v9, v0
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = call <2 x double> @llvm.trunc.v2f64(<2 x double> %a)
  store <2 x double> %b, <2 x double>* %x
  ret void
}
declare <2 x double> @llvm.trunc.v2f64(<2 x double>)

define void @ceil_v8f16(<8 x half>* %x) {
; CHECK-LABEL: ceil_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfcvt.rtz.x.f.v v9, v8
; CHECK-NEXT:    vfcvt.f.x.v v9, v9
; CHECK-NEXT:    lui a1, %hi(.LCPI94_0)
; CHECK-NEXT:    flh ft0, %lo(.LCPI94_0)(a1)
; CHECK-NEXT:    vmflt.vv v0, v9, v8
; CHECK-NEXT:    lui a1, %hi(.LCPI94_1)
; CHECK-NEXT:    flh ft1, %lo(.LCPI94_1)(a1)
; CHECK-NEXT:    vfadd.vf v10, v9, ft0
; CHECK-NEXT:    vmerge.vvm v9, v9, v10, v0
; CHECK-NEXT:    vfabs.v v10, v8
; CHECK-NEXT:    vmflt.vf v0, v10, ft1
; CHECK-NEXT:    vfsgnj.vv v9, v9, v8
; CHECK-NEXT:    vmerge.vvm v8, v8, v9, v0
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = call <8 x half> @llvm.ceil.v8f16(<8 x half> %a)
  store <8 x half> %b, <8 x half>* %x
  ret void
}
declare <8 x half> @llvm.ceil.v8f16(<8 x half>)

define void @ceil_v4f32(<4 x float>* %x) {
; CHECK-LABEL: ceil_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfcvt.rtz.x.f.v v9, v8
; CHECK-NEXT:    vfcvt.f.x.v v9, v9
; CHECK-NEXT:    lui a1, %hi(.LCPI95_0)
; CHECK-NEXT:    flw ft0, %lo(.LCPI95_0)(a1)
; CHECK-NEXT:    vmflt.vv v0, v9, v8
; CHECK-NEXT:    lui a1, %hi(.LCPI95_1)
; CHECK-NEXT:    flw ft1, %lo(.LCPI95_1)(a1)
; CHECK-NEXT:    vfadd.vf v10, v9, ft0
; CHECK-NEXT:    vmerge.vvm v9, v9, v10, v0
; CHECK-NEXT:    vfabs.v v10, v8
; CHECK-NEXT:    vmflt.vf v0, v10, ft1
; CHECK-NEXT:    vfsgnj.vv v9, v9, v8
; CHECK-NEXT:    vmerge.vvm v8, v8, v9, v0
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = call <4 x float> @llvm.ceil.v4f32(<4 x float> %a)
  store <4 x float> %b, <4 x float>* %x
  ret void
}
declare <4 x float> @llvm.ceil.v4f32(<4 x float>)

define void @ceil_v2f64(<2 x double>* %x) {
; CHECK-LABEL: ceil_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfcvt.rtz.x.f.v v9, v8
; CHECK-NEXT:    vfcvt.f.x.v v9, v9
; CHECK-NEXT:    lui a1, %hi(.LCPI96_0)
; CHECK-NEXT:    fld ft0, %lo(.LCPI96_0)(a1)
; CHECK-NEXT:    vmflt.vv v0, v9, v8
; CHECK-NEXT:    lui a1, %hi(.LCPI96_1)
; CHECK-NEXT:    fld ft1, %lo(.LCPI96_1)(a1)
; CHECK-NEXT:    vfadd.vf v10, v9, ft0
; CHECK-NEXT:    vmerge.vvm v9, v9, v10, v0
; CHECK-NEXT:    vfabs.v v10, v8
; CHECK-NEXT:    vmflt.vf v0, v10, ft1
; CHECK-NEXT:    vfsgnj.vv v9, v9, v8
; CHECK-NEXT:    vmerge.vvm v8, v8, v9, v0
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = call <2 x double> @llvm.ceil.v2f64(<2 x double> %a)
  store <2 x double> %b, <2 x double>* %x
  ret void
}
declare <2 x double> @llvm.ceil.v2f64(<2 x double>)

define void @floor_v8f16(<8 x half>* %x) {
; CHECK-LABEL: floor_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfcvt.rtz.x.f.v v9, v8
; CHECK-NEXT:    vfcvt.f.x.v v9, v9
; CHECK-NEXT:    lui a1, %hi(.LCPI97_0)
; CHECK-NEXT:    flh ft0, %lo(.LCPI97_0)(a1)
; CHECK-NEXT:    vmflt.vv v0, v8, v9
; CHECK-NEXT:    lui a1, %hi(.LCPI97_1)
; CHECK-NEXT:    flh ft1, %lo(.LCPI97_1)(a1)
; CHECK-NEXT:    vfsub.vf v10, v9, ft0
; CHECK-NEXT:    vmerge.vvm v9, v9, v10, v0
; CHECK-NEXT:    vfabs.v v10, v8
; CHECK-NEXT:    vmflt.vf v0, v10, ft1
; CHECK-NEXT:    vfsgnj.vv v9, v9, v8
; CHECK-NEXT:    vmerge.vvm v8, v8, v9, v0
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = call <8 x half> @llvm.floor.v8f16(<8 x half> %a)
  store <8 x half> %b, <8 x half>* %x
  ret void
}
declare <8 x half> @llvm.floor.v8f16(<8 x half>)

define void @floor_v4f32(<4 x float>* %x) {
; CHECK-LABEL: floor_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfcvt.rtz.x.f.v v9, v8
; CHECK-NEXT:    vfcvt.f.x.v v9, v9
; CHECK-NEXT:    lui a1, %hi(.LCPI98_0)
; CHECK-NEXT:    flw ft0, %lo(.LCPI98_0)(a1)
; CHECK-NEXT:    vmflt.vv v0, v8, v9
; CHECK-NEXT:    lui a1, %hi(.LCPI98_1)
; CHECK-NEXT:    flw ft1, %lo(.LCPI98_1)(a1)
; CHECK-NEXT:    vfsub.vf v10, v9, ft0
; CHECK-NEXT:    vmerge.vvm v9, v9, v10, v0
; CHECK-NEXT:    vfabs.v v10, v8
; CHECK-NEXT:    vmflt.vf v0, v10, ft1
; CHECK-NEXT:    vfsgnj.vv v9, v9, v8
; CHECK-NEXT:    vmerge.vvm v8, v8, v9, v0
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = call <4 x float> @llvm.floor.v4f32(<4 x float> %a)
  store <4 x float> %b, <4 x float>* %x
  ret void
}
declare <4 x float> @llvm.floor.v4f32(<4 x float>)

define void @floor_v2f64(<2 x double>* %x) {
; CHECK-LABEL: floor_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfcvt.rtz.x.f.v v9, v8
; CHECK-NEXT:    vfcvt.f.x.v v9, v9
; CHECK-NEXT:    lui a1, %hi(.LCPI99_0)
; CHECK-NEXT:    fld ft0, %lo(.LCPI99_0)(a1)
; CHECK-NEXT:    vmflt.vv v0, v8, v9
; CHECK-NEXT:    lui a1, %hi(.LCPI99_1)
; CHECK-NEXT:    fld ft1, %lo(.LCPI99_1)(a1)
; CHECK-NEXT:    vfsub.vf v10, v9, ft0
; CHECK-NEXT:    vmerge.vvm v9, v9, v10, v0
; CHECK-NEXT:    vfabs.v v10, v8
; CHECK-NEXT:    vmflt.vf v0, v10, ft1
; CHECK-NEXT:    vfsgnj.vv v9, v9, v8
; CHECK-NEXT:    vmerge.vvm v8, v8, v9, v0
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = call <2 x double> @llvm.floor.v2f64(<2 x double> %a)
  store <2 x double> %b, <2 x double>* %x
  ret void
}
declare <2 x double> @llvm.floor.v2f64(<2 x double>)

define void @round_v8f16(<8 x half>* %x) {
; CHECK-LABEL: round_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    lui a1, %hi(.LCPI100_0)
; CHECK-NEXT:    flh ft0, %lo(.LCPI100_0)(a1)
; CHECK-NEXT:    lui a1, %hi(.LCPI100_1)
; CHECK-NEXT:    flh ft1, %lo(.LCPI100_1)(a1)
; CHECK-NEXT:    vfabs.v v9, v8
; CHECK-NEXT:    vmflt.vf v0, v9, ft0
; CHECK-NEXT:    vfadd.vf v9, v9, ft1
; CHECK-NEXT:    vfcvt.rtz.x.f.v v9, v9
; CHECK-NEXT:    vfcvt.f.x.v v9, v9
; CHECK-NEXT:    vfsgnj.vv v9, v9, v8
; CHECK-NEXT:    vmerge.vvm v8, v8, v9, v0
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = call <8 x half> @llvm.round.v8f16(<8 x half> %a)
  store <8 x half> %b, <8 x half>* %x
  ret void
}
declare <8 x half> @llvm.round.v8f16(<8 x half>)

define void @round_v4f32(<4 x float>* %x) {
; CHECK-LABEL: round_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    lui a1, %hi(.LCPI101_0)
; CHECK-NEXT:    flw ft0, %lo(.LCPI101_0)(a1)
; CHECK-NEXT:    lui a1, %hi(.LCPI101_1)
; CHECK-NEXT:    flw ft1, %lo(.LCPI101_1)(a1)
; CHECK-NEXT:    vfabs.v v9, v8
; CHECK-NEXT:    vmflt.vf v0, v9, ft0
; CHECK-NEXT:    vfadd.vf v9, v9, ft1
; CHECK-NEXT:    vfcvt.rtz.x.f.v v9, v9
; CHECK-NEXT:    vfcvt.f.x.v v9, v9
; CHECK-NEXT:    vfsgnj.vv v9, v9, v8
; CHECK-NEXT:    vmerge.vvm v8, v8, v9, v0
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = call <4 x float> @llvm.round.v4f32(<4 x float> %a)
  store <4 x float> %b, <4 x float>* %x
  ret void
}
declare <4 x float> @llvm.round.v4f32(<4 x float>)

define void @round_v2f64(<2 x double>* %x) {
; CHECK-LABEL: round_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    lui a1, %hi(.LCPI102_0)
; CHECK-NEXT:    fld ft0, %lo(.LCPI102_0)(a1)
; CHECK-NEXT:    lui a1, %hi(.LCPI102_1)
; CHECK-NEXT:    fld ft1, %lo(.LCPI102_1)(a1)
; CHECK-NEXT:    vfabs.v v9, v8
; CHECK-NEXT:    vmflt.vf v0, v9, ft0
; CHECK-NEXT:    vfadd.vf v9, v9, ft1
; CHECK-NEXT:    vfcvt.rtz.x.f.v v9, v9
; CHECK-NEXT:    vfcvt.f.x.v v9, v9
; CHECK-NEXT:    vfsgnj.vv v9, v9, v8
; CHECK-NEXT:    vmerge.vvm v8, v8, v9, v0
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = call <2 x double> @llvm.round.v2f64(<2 x double> %a)
  store <2 x double> %b, <2 x double>* %x
  ret void
}
declare <2 x double> @llvm.round.v2f64(<2 x double>)

define void @fmuladd_v8f16(<8 x half>* %x, <8 x half>* %y, <8 x half>* %z) {
; CHECK-LABEL: fmuladd_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vle16.v v9, (a1)
; CHECK-NEXT:    vle16.v v10, (a2)
; CHECK-NEXT:    vfmacc.vv v10, v8, v9
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = load <8 x half>, <8 x half>* %y
  %c = load <8 x half>, <8 x half>* %z
  %d = call <8 x half> @llvm.fmuladd.v8f16(<8 x half> %a, <8 x half> %b, <8 x half> %c)
  store <8 x half> %d, <8 x half>* %x
  ret void
}
declare <8 x half> @llvm.fmuladd.v8f16(<8 x half>, <8 x half>, <8 x half>)

define void @fmuladd_v4f32(<4 x float>* %x, <4 x float>* %y, <4 x float>* %z) {
; CHECK-LABEL: fmuladd_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vle32.v v10, (a2)
; CHECK-NEXT:    vfmacc.vv v10, v8, v9
; CHECK-NEXT:    vse32.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = load <4 x float>, <4 x float>* %y
  %c = load <4 x float>, <4 x float>* %z
  %d = call <4 x float> @llvm.fmuladd.v4f32(<4 x float> %a, <4 x float> %b, <4 x float> %c)
  store <4 x float> %d, <4 x float>* %x
  ret void
}
declare <4 x float> @llvm.fmuladd.v4f32(<4 x float>, <4 x float>, <4 x float>)

define void @fmuladd_v2f64(<2 x double>* %x, <2 x double>* %y, <2 x double>* %z) {
; CHECK-LABEL: fmuladd_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vle64.v v10, (a2)
; CHECK-NEXT:    vfmacc.vv v10, v8, v9
; CHECK-NEXT:    vse64.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = load <2 x double>, <2 x double>* %y
  %c = load <2 x double>, <2 x double>* %z
  %d = call <2 x double> @llvm.fmuladd.v2f64(<2 x double> %a, <2 x double> %b, <2 x double> %c)
  store <2 x double> %d, <2 x double>* %x
  ret void
}
declare <2 x double> @llvm.fmuladd.v2f64(<2 x double>, <2 x double>, <2 x double>)

define void @fmsub_fmuladd_v8f16(<8 x half>* %x, <8 x half>* %y, <8 x half>* %z) {
; CHECK-LABEL: fmsub_fmuladd_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vle16.v v9, (a1)
; CHECK-NEXT:    vle16.v v10, (a2)
; CHECK-NEXT:    vfmsac.vv v10, v8, v9
; CHECK-NEXT:    vse16.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = load <8 x half>, <8 x half>* %y
  %c = load <8 x half>, <8 x half>* %z
  %neg = fneg <8 x half> %c
  %d = call <8 x half> @llvm.fmuladd.v8f16(<8 x half> %a, <8 x half> %b, <8 x half> %neg)
  store <8 x half> %d, <8 x half>* %x
  ret void
}

define void @fnmsub_fmuladd_v4f32(<4 x float>* %x, <4 x float>* %y, <4 x float>* %z) {
; CHECK-LABEL: fnmsub_fmuladd_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vle32.v v10, (a2)
; CHECK-NEXT:    vfnmsac.vv v10, v8, v9
; CHECK-NEXT:    vse32.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = load <4 x float>, <4 x float>* %y
  %c = load <4 x float>, <4 x float>* %z
  %neg = fneg <4 x float> %a
  %d = call <4 x float> @llvm.fmuladd.v4f32(<4 x float> %neg, <4 x float> %b, <4 x float> %c)
  store <4 x float> %d, <4 x float>* %x
  ret void
}

define void @fnmadd_fmuladd_v2f64(<2 x double>* %x, <2 x double>* %y, <2 x double>* %z) {
; CHECK-LABEL: fnmadd_fmuladd_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vle64.v v10, (a2)
; CHECK-NEXT:    vfnmacc.vv v10, v8, v9
; CHECK-NEXT:    vse64.v v10, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = load <2 x double>, <2 x double>* %y
  %c = load <2 x double>, <2 x double>* %z
  %neg = fneg <2 x double> %b
  %neg2 = fneg <2 x double> %c
  %d = call <2 x double> @llvm.fmuladd.v2f64(<2 x double> %a, <2 x double> %neg, <2 x double> %neg2)
  store <2 x double> %d, <2 x double>* %x
  ret void
}
