// RUN: %clang_cc1 -std=c++11 -fsyntax-only %s -verify

namespace ExplicitConv {
  struct X { }; // expected-note 2{{candidate constructor}}

  struct Y {
    explicit operator X() const;
  };

  void test(const Y& y) {
    X x(static_cast<X>(y));
    X x2((X)y);
    X x3 = y; // expected-error{{no viable conversion from 'const ExplicitConv::Y' to 'ExplicitConv::X'}}
  }
}

namespace DR899 {
  struct C { }; // expected-note 2 {{candidate constructor}}

  struct A {
    explicit operator int() const;
    explicit operator C() const;
  };

  struct B {
    int i;
    B(const A& a): i(a) { }
  };

  int main() {
    A a;
    int i = a; // expected-error{{no viable conversion}}
    int j(a);
    C c = a; // expected-error{{no viable conversion}}
    C c2(a);
  }
}
