/*
 * Copyright (C) 2020 Linux Studio Plugins Project <https://lsp-plug.in/>
 *           (C) 2020 Vladimir Sadovnikov <sadko4u@gmail.com>
 *
 * This file is part of lsp-dsp-lib
 * Created on: 31 мар. 2020 г.
 *
 * lsp-dsp-lib is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * lsp-dsp-lib is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with lsp-dsp-lib. If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef PRIVATE_DSP_ARCH_GENERIC_RESAMPLING_H_
#define PRIVATE_DSP_ARCH_GENERIC_RESAMPLING_H_

#ifndef PRIVATE_DSP_ARCH_GENERIC_IMPL
    #error "This header should not be included directly"
#endif /* PRIVATE_DSP_ARCH_GENERIC_IMPL */

/*

    #include <stdio.h>
    #include <math.h>

    // Number of lobes
    #define KERNEL_SIZE     4
    // Oversampling times
    #define KERNEL_TIMES    2
    // Number of samples to generate
    #define KERNEL_MAX      64

    double kernel[KERNEL_MAX];

    int main(void)
    {
        ssize_t leaf = KERNEL_SIZE * KERNEL_TIMES;
        ssize_t dots = leaf * 2 + 1;

        for (ssize_t i=0; i<KERNEL_MAX; ++i)
        {
            double xx = double(i - leaf) / double(KERNEL_TIMES);

            if (i >= dots)
                kernel[i] = 0.0;
            else if (i == leaf)
                kernel[i] = 1.0;
            else
            {
                double px = M_PI * xx;
                kernel[i] = (double(KERNEL_SIZE) * sin(px) * sin(px / double(KERNEL_SIZE))) / (px * px);
            }
        }

        printf("leaf=%d, dots=%d, kernel_size=%d, kernel_times=%d\n", int(leaf), int(dots), KERNEL_SIZE, KERNEL_TIMES);
        for (ssize_t i=0; i<KERNEL_MAX; ++i)
            printf("%s%.16ff,\n", (kernel[i] >= 0.0) ? "+" : "", kernel[i]);

        printf("code:\n");
        for (ssize_t i=0; i<KERNEL_MAX; ++i)
        {
            double v = kernel[i];
            if (fabs(v) < 1e-6)
                continue;

            const char *s = (i >= 10) ? "    " : "     ";

            if (v > 0.0)
                printf("dst[%d]%s+= %.16ff * s;\n", int(i), s, v);
            else
                printf("dst[%d]%s-= %.16ff * s;\n", int(i), s, -v);
        }

        return 0;
    }


 */

namespace lsp
{
    namespace generic
    {
        static const float lanczos_2x16bit[] =
        {
            -0.0000000000000000f,
            -0.0017562465551615f,
            +0.0000000000000000f,
            +0.0063666235011747f,
            -0.0000000000000000f,
            -0.0127368704055724f,
            +0.0000000000000000f,
            +0.0213675350683576f,
            -0.0000000000000000f,
            -0.0330822319797804f,
            +0.0000000000000000f,
            +0.0494191366611535f,
            -0.0000000000000000f,
            -0.0736961923786210f,
            +0.0000000000000000f,
            +0.1146318336501513f,
            -0.0000000000000000f,
            -0.2044393546488325f,
            +0.0000000000000000f,
            +0.6340050064132841f,
            +1.0000000000000000f,
            +0.6340050064132841f,
            +0.0000000000000000f,
            -0.2044393546488325f,
            -0.0000000000000000f,
            +0.1146318336501513f,
            +0.0000000000000000f,
            -0.0736961923786210f,
            -0.0000000000000000f,
            +0.0494191366611535f,
            +0.0000000000000000f,
            -0.0330822319797804f,
            -0.0000000000000000f,
            +0.0213675350683576f,
            +0.0000000000000000f,
            -0.0127368704055724f,
            -0.0000000000000000f,
            +0.0063666235011747f,
            +0.0000000000000000f,
            -0.0017562465551615f
        };

        static const float lanczos_2x24bit[] =
        {
            -0.0000000000000000f,
            -0.0000420749334770f,
            +0.0000000000000000f,
            +0.0001303204007046f,
            -0.0000000000000000f,
            -0.0002241785497035f,
            +0.0000000000000000f,
            +0.0003238377357525f,
            +0.0000000000000000f,
            -0.0004294939585451f,
            +0.0000000000000000f,
            +0.0005413516964839f,
            -0.0000000000000000f,
            -0.0006596248424501f,
            -0.0000000000000000f,
            +0.0007845377537817f,
            -0.0000000000000000f,
            -0.0009163264310727f,
            +0.0000000000000000f,
            +0.0010552398426108f,
            +0.0000000000000000f,
            -0.0012015414138581f,
            +0.0000000000000000f,
            +0.0013555107044297f,
            +0.0000000000000000f,
            -0.0015174452986323f,
            +0.0000000000000000f,
            +0.0016876629399007f,
            -0.0000000000000000f,
            -0.0018665039445554f,
            -0.0000000000000000f,
            +0.0020543339363826f,
            -0.0000000000000000f,
            -0.0022515469508069f,
            +0.0000000000000000f,
            +0.0024585689661799f,
            -0.0000000000000001f,
            -0.0026758619302655f,
            +0.0000000000000000f,
            +0.0029039283627990f,
            +0.0000000000000000f,
            -0.0031433166305705f,
            +0.0000000000000001f,
            +0.0033946270105201f,
            -0.0000000000000000f,
            -0.0036585186797036f,
            +0.0000000000000000f,
            +0.0039357177998310f,
            -0.0000000000000000f,
            -0.0042270268998406f,
            +0.0000000000000000f,
            +0.0045333358045560f,
            -0.0000000000000000f,
            -0.0048556344133628f,
            +0.0000000000000000f,
            +0.0051950277033080f,
            +0.0000000000000000f,
            -0.0055527534204337f,
            +0.0000000000000000f,
            +0.0059302030373166f,
            -0.0000000000000000f,
            -0.0063289467015709f,
            +0.0000000000000000f,
            +0.0067507630901733f,
            -0.0000000000000001f,
            -0.0071976753325661f,
            -0.0000000000000000f,
            +0.0076719944919443f,
            -0.0000000000000000f,
            -0.0081763725274213f,
            +0.0000000000000001f,
            +0.0087138672402142f,
            +0.0000000000000000f,
            -0.0092880224923026f,
            -0.0000000000000000f,
            +0.0099029680598097f,
            -0.0000000000000000f,
            -0.0105635449684010f,
            +0.0000000000000001f,
            +0.0112754642370518f,
            -0.0000000000000001f,
            -0.0120455099059071f,
            -0.0000000000000000f,
            +0.0128818014681738f,
            -0.0000000000000000f,
            -0.0137941370290747f,
            +0.0000000000000001f,
            +0.0147944477357047f,
            -0.0000000000000000f,
            -0.0158974079845805f,
            -0.0000000000000000f,
            +0.0171212674927752f,
            -0.0000000000000000f,
            -0.0184890054274438f,
            +0.0000000000000001f,
            +0.0200299620685047f,
            -0.0000000000000000f,
            -0.0217821956125176f,
            -0.0000000000000000f,
            +0.0237959701950330f,
            -0.0000000000000000f,
            -0.0261390636973287f,
            +0.0000000000000001f,
            +0.0289051085252159f,
            -0.0000000000000000f,
            -0.0322272001794569f,
            +0.0000000000000000f,
            +0.0363011117970633f,
            -0.0000000000000000f,
            -0.0414270802341371f,
            +0.0000000000000000f,
            +0.0480901638096349f,
            -0.0000000000000000f,
            -0.0571282629124219f,
            +0.0000000000000000f,
            +0.0701241679229563f,
            -0.0000000000000000f,
            -0.0904696890758395f,
            +0.0000000000000000f,
            +0.1269836976940222f,
            -0.0000000000000000f,
            -0.2120023318573107f,
            +0.0000000000000000f,
            +0.6365516685731774f,
            +1.0000000000000000f,
            +0.6365516685731774f,
            +0.0000000000000000f,
            -0.2120023318573107f,
            -0.0000000000000000f,
            +0.1269836976940222f,
            +0.0000000000000000f,
            -0.0904696890758395f,
            -0.0000000000000000f,
            +0.0701241679229563f,
            +0.0000000000000000f,
            -0.0571282629124219f,
            -0.0000000000000000f,
            +0.0480901638096349f,
            +0.0000000000000000f,
            -0.0414270802341371f,
            -0.0000000000000000f,
            +0.0363011117970633f,
            +0.0000000000000000f,
            -0.0322272001794569f,
            -0.0000000000000000f,
            +0.0289051085252159f,
            +0.0000000000000001f,
            -0.0261390636973287f,
            -0.0000000000000000f,
            +0.0237959701950330f,
            -0.0000000000000000f,
            -0.0217821956125176f,
            -0.0000000000000000f,
            +0.0200299620685047f,
            +0.0000000000000001f,
            -0.0184890054274438f,
            -0.0000000000000000f,
            +0.0171212674927752f,
            -0.0000000000000000f,
            -0.0158974079845805f,
            -0.0000000000000000f,
            +0.0147944477357047f,
            +0.0000000000000001f,
            -0.0137941370290747f,
            -0.0000000000000000f,
            +0.0128818014681738f,
            -0.0000000000000000f,
            -0.0120455099059071f,
            -0.0000000000000001f,
            +0.0112754642370518f,
            +0.0000000000000001f,
            -0.0105635449684010f,
            -0.0000000000000000f,
            +0.0099029680598097f,
            -0.0000000000000000f,
            -0.0092880224923026f,
            +0.0000000000000000f,
            +0.0087138672402142f,
            +0.0000000000000001f,
            -0.0081763725274213f,
            -0.0000000000000000f,
            +0.0076719944919443f,
            -0.0000000000000000f,
            -0.0071976753325661f,
            -0.0000000000000001f,
            +0.0067507630901733f,
            +0.0000000000000000f,
            -0.0063289467015709f,
            -0.0000000000000000f,
            +0.0059302030373166f,
            +0.0000000000000000f,
            -0.0055527534204337f,
            +0.0000000000000000f,
            +0.0051950277033080f,
            +0.0000000000000000f,
            -0.0048556344133628f,
            -0.0000000000000000f,
            +0.0045333358045560f,
            +0.0000000000000000f,
            -0.0042270268998406f,
            -0.0000000000000000f,
            +0.0039357177998310f,
            +0.0000000000000000f,
            -0.0036585186797036f,
            -0.0000000000000000f,
            +0.0033946270105201f,
            +0.0000000000000001f,
            -0.0031433166305705f,
            +0.0000000000000000f,
            +0.0029039283627990f,
            +0.0000000000000000f,
            -0.0026758619302655f,
            -0.0000000000000001f,
            +0.0024585689661799f,
            +0.0000000000000000f,
            -0.0022515469508069f,
            -0.0000000000000000f,
            +0.0020543339363826f,
            -0.0000000000000000f,
            -0.0018665039445554f,
            -0.0000000000000000f,
            +0.0016876629399007f,
            +0.0000000000000000f,
            -0.0015174452986323f,
            +0.0000000000000000f,
            +0.0013555107044297f,
            +0.0000000000000000f,
            -0.0012015414138581f,
            +0.0000000000000000f,
            +0.0010552398426108f,
            +0.0000000000000000f,
            -0.0009163264310727f,
            -0.0000000000000000f,
            +0.0007845377537817f,
            -0.0000000000000000f,
            -0.0006596248424501f,
            -0.0000000000000000f,
            +0.0005413516964839f,
            +0.0000000000000000f,
            -0.0004294939585451f,
            +0.0000000000000000f,
            +0.0003238377357525f,
            +0.0000000000000000f,
            -0.0002241785497035f,
            -0.0000000000000000f,
            +0.0001303204007046f,
            +0.0000000000000000f,
            -0.0000420749334770f,
        };

        static const float lanczos_3x16bit[] =
        {
            -0.0000000000000000f,
            -0.0009815489562645f,
            -0.0020942872238989f,
            +0.0000000000000000f,
            +0.0047516013794984f,
            +0.0063177637662556f,
            -0.0000000000000000f,
            -0.0099891519370195f,
            -0.0121255512693219f,
            +0.0000000000000000f,
            +0.0170979497396445f,
            +0.0199846412434967f,
            -0.0000000000000000f,
            -0.0267288298873959f,
            -0.0306794648208279f,
            +0.0000000000000000f,
            +0.0400711377251631f,
            +0.0457078806950142f,
            -0.0000000000000000f,
            -0.0596235990818374f,
            -0.0683917989585780f,
            +0.0000000000000000f,
            +0.0916994814742472f,
            +0.1078420688710883f,
            -0.0000000000000000f,
            -0.1579440941563912f,
            -0.2007551582838082f,
            +0.0000000000000000f,
            +0.4104802958841833f,
            +0.8254826722184564f,
            +1.0000000000000000f,
            +0.8254826722184564f,
            +0.4104802958841833f,
            +0.0000000000000000f,
            -0.2007551582838082f,
            -0.1579440941563912f,
            -0.0000000000000000f,
            +0.1078420688710883f,
            +0.0916994814742472f,
            +0.0000000000000000f,
            -0.0683917989585780f,
            -0.0596235990818374f,
            -0.0000000000000000f,
            +0.0457078806950142f,
            +0.0400711377251631f,
            +0.0000000000000000f,
            -0.0306794648208279f,
            -0.0267288298873959f,
            -0.0000000000000000f,
            +0.0199846412434967f,
            +0.0170979497396445f,
            +0.0000000000000000f,
            -0.0121255512693219f,
            -0.0099891519370195f,
            -0.0000000000000000f,
            +0.0063177637662556f,
            +0.0047516013794984f,
            +0.0000000000000000f,
            -0.0020942872238989f,
            -0.0009815489562645f,
        };

        static const float lanczos_3x24bit[] =
        {
            -0.0000000000000000f,
            -0.0000241622796987f,
            -0.0000488442856854f,
            +0.0000000000000000f,
            +0.0000997904058213f,
            +0.0001260661561723f,
            -0.0000000000000000f,
            -0.0001802526675327f,
            -0.0002081755069076f,
            +0.0000000000000000f,
            +0.0002657111465349f,
            +0.0002953365149800f,
            +0.0000000000000000f,
            -0.0003563344322158f,
            -0.0003877200924771f,
            +0.0000000000000000f,
            +0.0004522983304941f,
            +0.0004855046229488f,
            -0.0000000000000000f,
            -0.0005537866588479f,
            -0.0005888767874851f,
            -0.0000000000000000f,
            +0.0006609921383055f,
            +0.0006980324916908f,
            -0.0000000000000000f,
            -0.0007741173947661f,
            -0.0008131779065094f,
            +0.0000000000000000f,
            +0.0008933760838732f,
            +0.0009345306378089f,
            +0.0000000000000000f,
            -0.0010189941558477f,
            -0.0010623210419442f,
            +0.0000000000000000f,
            +0.0011512112792538f,
            +0.0011967937072283f,
            +0.0000000000000000f,
            -0.0012902824457130f,
            -0.0013382091244565f,
            +0.0000000000000000f,
            +0.0014364797811740f,
            +0.0014868455734379f,
            -0.0000000000000000f,
            -0.0015900945936304f,
            -0.0016430012570262f,
            -0.0000000000000000f,
            +0.0017514396922808f,
            +0.0018069967195599f,
            -0.0000000000000000f,
            -0.0019208520192378f,
            -0.0019791775931192f,
            +0.0000000000000000f,
            +0.0020986956422391f,
            +0.0021599177228197f,
            -0.0000000000000001f,
            -0.0022853651656731f,
            -0.0023496227318036f,
            +0.0000000000000000f,
            +0.0024812896279599f,
            +0.0025487340980392f,
            +0.0000000000000000f,
            -0.0026869369663787f,
            -0.0027577338289749f,
            +0.0000000000000001f,
            +0.0029028191463709f,
            +0.0029771498371556f,
            -0.0000000000000000f,
            -0.0031294980719012f,
            -0.0032075621408580f,
            +0.0000000000000000f,
            +0.0033675924175698f,
            +0.0034496100396870f,
            -0.0000000000000000f,
            -0.0036177855530381f,
            -0.0037040004471911f,
            +0.0000000000000000f,
            +0.0038808347675323f,
            +0.0039715176026307f,
            -0.0000000000000000f,
            -0.0041575820487861f,
            -0.0042530344343228f,
            +0.0000000000000000f,
            +0.0044489667294701f,
            +0.0045495259104529f,
            +0.0000000000000000f,
            -0.0047560403885408f,
            -0.0048620847938549f,
            +0.0000000000000000f,
            +0.0050799844898190f,
            +0.0051919403203071f,
            -0.0000000000000000f,
            -0.0054221313619506f,
            -0.0055404804525440f,
            +0.0000000000000000f,
            +0.0057839892815074f,
            +0.0059092785341872f,
            -0.0000000000000001f,
            -0.0061672726264071f,
            -0.0063001253925905f,
            -0.0000000000000000f,
            +0.0065739383367428f,
            +0.0067150682357790f,
            -0.0000000000000000f,
            -0.0070062302778336f,
            -0.0071564580823837f,
            +0.0000000000000001f,
            +0.0074667335787580f,
            +0.0076270079917564f,
            +0.0000000000000000f,
            -0.0079584416658553f,
            -0.0081298650774134f,
            -0.0000000000000000f,
            +0.0084848395926892f,
            +0.0086687002677317f,
            -0.0000000000000000f,
            -0.0090500084853921f,
            -0.0092478211369019f,
            +0.0000000000000001f,
            +0.0096587576231200f,
            +0.0098723150359084f,
            -0.0000000000000001f,
            -0.0103167930806617f,
            -0.0105482324644982f,
            -0.0000000000000000f,
            +0.0110309353158997f,
            +0.0112828245363256f,
            -0.0000000000000000f,
            -0.0118094031218828f,
            -0.0120848541214312f,
            +0.0000000000000001f,
            +0.0126621888289166f,
            +0.0129650087960713f,
            -0.0000000000000000f,
            -0.0136015609109855f,
            -0.0139364567130341f,
            -0.0000000000000000f,
            +0.0146427475049337f,
            +0.0150156066426794f,
            -0.0000000000000000f,
            -0.0158048816743398f,
            -0.0162231653916370f,
            +0.0000000000000001f,
            +0.0171123333402252f,
            +0.0175856378286361f,
            -0.0000000000000000f,
            -0.0185966259259565f,
            -0.0191375018846899f,
            -0.0000000000000000f,
            +0.0202992608463264f,
            +0.0209244416196306f,
            -0.0000000000000000f,
            -0.0222759945457239f,
            -0.0230082918649483f,
            +0.0000000000000001f,
            +0.0246035213190903f,
            +0.0254748538961921f,
            -0.0000000000000000f,
            -0.0273903040325239f,
            -0.0284467354053715f,
            +0.0000000000000000f,
            +0.0307949029684039f,
            +0.0321054351835699f,
            -0.0000000000000000f,
            -0.0350586489068662f,
            -0.0367314970079870f,
            +0.0000000000000000f,
            +0.0405677218898500f,
            +0.0427827039573689f,
            -0.0000000000000000f,
            -0.0479809603323249f,
            -0.0510602412159371f,
            +0.0000000000000000f,
            +0.0585219959992017f,
            +0.0631049303064250f,
            -0.0000000000000000f,
            -0.0747494278616736f,
            -0.0823066847506617f,
            +0.0000000000000000f,
            +0.1030598868884597f,
            +0.1178668514370637f,
            -0.0000000000000000f,
            -0.1652021336944537f,
            -0.2065910876515157f,
            +0.0000000000000000f,
            +0.4134180340412702f,
            +0.8269540226875740f,
            +1.0000000000000000f,
            +0.8269540226875740f,
            +0.4134180340412702f,
            +0.0000000000000000f,
            -0.2065910876515157f,
            -0.1652021336944537f,
            -0.0000000000000000f,
            +0.1178668514370637f,
            +0.1030598868884597f,
            +0.0000000000000000f,
            -0.0823066847506617f,
            -0.0747494278616736f,
            -0.0000000000000000f,
            +0.0631049303064250f,
            +0.0585219959992017f,
            +0.0000000000000000f,
            -0.0510602412159371f,
            -0.0479809603323249f,
            -0.0000000000000000f,
            +0.0427827039573689f,
            +0.0405677218898500f,
            +0.0000000000000000f,
            -0.0367314970079870f,
            -0.0350586489068662f,
            -0.0000000000000000f,
            +0.0321054351835699f,
            +0.0307949029684039f,
            +0.0000000000000000f,
            -0.0284467354053715f,
            -0.0273903040325239f,
            -0.0000000000000000f,
            +0.0254748538961921f,
            +0.0246035213190903f,
            +0.0000000000000001f,
            -0.0230082918649483f,
            -0.0222759945457239f,
            -0.0000000000000000f,
            +0.0209244416196306f,
            +0.0202992608463264f,
            -0.0000000000000000f,
            -0.0191375018846899f,
            -0.0185966259259565f,
            -0.0000000000000000f,
            +0.0175856378286361f,
            +0.0171123333402252f,
            +0.0000000000000001f,
            -0.0162231653916370f,
            -0.0158048816743398f,
            -0.0000000000000000f,
            +0.0150156066426794f,
            +0.0146427475049337f,
            -0.0000000000000000f,
            -0.0139364567130341f,
            -0.0136015609109855f,
            -0.0000000000000000f,
            +0.0129650087960713f,
            +0.0126621888289166f,
            +0.0000000000000001f,
            -0.0120848541214312f,
            -0.0118094031218828f,
            -0.0000000000000000f,
            +0.0112828245363256f,
            +0.0110309353158997f,
            -0.0000000000000000f,
            -0.0105482324644982f,
            -0.0103167930806617f,
            -0.0000000000000001f,
            +0.0098723150359084f,
            +0.0096587576231200f,
            +0.0000000000000001f,
            -0.0092478211369019f,
            -0.0090500084853921f,
            -0.0000000000000000f,
            +0.0086687002677317f,
            +0.0084848395926892f,
            -0.0000000000000000f,
            -0.0081298650774134f,
            -0.0079584416658553f,
            +0.0000000000000000f,
            +0.0076270079917564f,
            +0.0074667335787580f,
            +0.0000000000000001f,
            -0.0071564580823837f,
            -0.0070062302778336f,
            -0.0000000000000000f,
            +0.0067150682357790f,
            +0.0065739383367428f,
            -0.0000000000000000f,
            -0.0063001253925905f,
            -0.0061672726264071f,
            -0.0000000000000001f,
            +0.0059092785341872f,
            +0.0057839892815074f,
            +0.0000000000000000f,
            -0.0055404804525440f,
            -0.0054221313619506f,
            -0.0000000000000000f,
            +0.0051919403203071f,
            +0.0050799844898190f,
            +0.0000000000000000f,
            -0.0048620847938549f,
            -0.0047560403885408f,
            +0.0000000000000000f,
            +0.0045495259104529f,
            +0.0044489667294701f,
            +0.0000000000000000f,
            -0.0042530344343228f,
            -0.0041575820487861f,
            -0.0000000000000000f,
            +0.0039715176026307f,
            +0.0038808347675323f,
            +0.0000000000000000f,
            -0.0037040004471911f,
            -0.0036177855530381f,
            -0.0000000000000000f,
            +0.0034496100396870f,
            +0.0033675924175698f,
            +0.0000000000000000f,
            -0.0032075621408580f,
            -0.0031294980719012f,
            -0.0000000000000000f,
            +0.0029771498371556f,
            +0.0029028191463709f,
            +0.0000000000000001f,
            -0.0027577338289749f,
            -0.0026869369663787f,
            +0.0000000000000000f,
            +0.0025487340980392f,
            +0.0024812896279599f,
            +0.0000000000000000f,
            -0.0023496227318036f,
            -0.0022853651656731f,
            -0.0000000000000001f,
            +0.0021599177228197f,
            +0.0020986956422391f,
            +0.0000000000000000f,
            -0.0019791775931192f,
            -0.0019208520192378f,
            -0.0000000000000000f,
            +0.0018069967195599f,
            +0.0017514396922808f,
            -0.0000000000000000f,
            -0.0016430012570262f,
            -0.0015900945936304f,
            -0.0000000000000000f,
            +0.0014868455734379f,
            +0.0014364797811740f,
            +0.0000000000000000f,
            -0.0013382091244565f,
            -0.0012902824457130f,
            +0.0000000000000000f,
            +0.0011967937072283f,
            +0.0011512112792538f,
            +0.0000000000000000f,
            -0.0010623210419442f,
            -0.0010189941558477f,
            +0.0000000000000000f,
            +0.0009345306378089f,
            +0.0008933760838732f,
            +0.0000000000000000f,
            -0.0008131779065094f,
            -0.0007741173947661f,
            -0.0000000000000000f,
            +0.0006980324916908f,
            +0.0006609921383055f,
            -0.0000000000000000f,
            -0.0005888767874851f,
            -0.0005537866588479f,
            -0.0000000000000000f,
            +0.0004855046229488f,
            +0.0004522983304941f,
            +0.0000000000000000f,
            -0.0003877200924771f,
            -0.0003563344322158f,
            +0.0000000000000000f,
            +0.0002953365149800f,
            +0.0002657111465349f,
            +0.0000000000000000f,
            -0.0002081755069076f,
            -0.0001802526675327f,
            -0.0000000000000000f,
            +0.0001260661561723f,
            +0.0000997904058213f,
            +0.0000000000000000f,
            -0.0000488442856854f,
            -0.0000241622796987f
        };

        static const float lanczos_4x16bit[] =
        {
            -0.0000000000000000f,
            -0.0005913155824994f,
            -0.0017562465551615f,
            -0.0019547311991183f,
            +0.0000000000000000f,
            +0.0035810370252689f,
            +0.0063666235011747f,
            +0.0054999971123013f,
            -0.0000000000000000f,
            -0.0077468699938191f,
            -0.0127368704055724f,
            -0.0103646528127521f,
            +0.0000000000000000f,
            +0.0134073670073630f,
            +0.0213675350683576f,
            +0.0169449607813781f,
            -0.0000000000000000f,
            -0.0210708028282491f,
            -0.0330822319797804f,
            -0.0259134834384236f,
            +0.0000000000000000f,
            +0.0316560836463846f,
            +0.0494191366611535f,
            +0.0385690473915008f,
            -0.0000000000000000f,
            -0.0470693355038282f,
            -0.0736961923786210f,
            -0.0578341452566130f,
            +0.0000000000000000f,
            +0.0720386199630128f,
            +0.1146318336501513f,
            +0.0919103958525938f,
            -0.0000000000000000f,
            -0.1222346296999213f,
            -0.2044393546488325f,
            -0.1754708142381755f,
            +0.0000000000000000f,
            +0.2973363346214353f,
            +0.6340050064132841f,
            +0.8993910009815614f,
            +1.0000000000000000f,
            +0.8993910009815614f,
            +0.6340050064132841f,
            +0.2973363346214353f,
            +0.0000000000000000f,
            -0.1754708142381755f,
            -0.2044393546488325f,
            -0.1222346296999213f,
            -0.0000000000000000f,
            +0.0919103958525938f,
            +0.1146318336501513f,
            +0.0720386199630128f,
            +0.0000000000000000f,
            -0.0578341452566130f,
            -0.0736961923786210f,
            -0.0470693355038282f,
            -0.0000000000000000f,
            +0.0385690473915008f,
            +0.0494191366611535f,
            +0.0316560836463846f,
            +0.0000000000000000f,
            -0.0259134834384236f,
            -0.0330822319797804f,
            -0.0210708028282491f,
            -0.0000000000000000f,
            +0.0169449607813781f,
            +0.0213675350683576f,
            +0.0134073670073630f,
            +0.0000000000000000f,
            -0.0103646528127521f,
            -0.0127368704055724f,
            -0.0077468699938191f,
            -0.0000000000000000f,
            +0.0054999971123013f,
            +0.0063666235011747f,
            +0.0035810370252689f,
            +0.0000000000000000f,
            -0.0019547311991183f,
            -0.0017562465551615f,
            -0.0005913155824994f
        };

        static const float lanczos_4x24bit[] =
        {
            -0.0000000000000000f,
            -0.0000147567119155f,
            -0.0000420749334770f,
            -0.0000449862367299f,
            +0.0000000000000000f,
            +0.0000761837168614f,
            +0.0001303204007046f,
            +0.0001083651853141f,
            -0.0000000000000000f,
            -0.0001415469719733f,
            -0.0002241785497035f,
            -0.0001757457190975f,
            +0.0000000000000000f,
            +0.0002109783977240f,
            +0.0003238377357525f,
            +0.0002472623250414f,
            +0.0000000000000000f,
            -0.0002846151827871f,
            -0.0004294939585451f,
            -0.0003230550367297f,
            +0.0000000000000000f,
            +0.0003626003573035f,
            +0.0005413516964839f,
            +0.0004032700414632f,
            -0.0000000000000000f,
            -0.0004450834358354f,
            -0.0006596248424501f,
            -0.0004880603612460f,
            -0.0000000000000000f,
            +0.0005322211387104f,
            +0.0007845377537817f,
            +0.0005775866169788f,
            -0.0000000000000000f,
            -0.0006241782017359f,
            -0.0009163264310727f,
            -0.0006720178865607f,
            +0.0000000000000000f,
            +0.0007211282857631f,
            +0.0010552398426108f,
            +0.0007715326692185f,
            +0.0000000000000000f,
            -0.0008232549993348f,
            -0.0012015414138581f,
            -0.0008763199702937f,
            +0.0000000000000000f,
            +0.0009307530497225f,
            +0.0013555107044297f,
            +0.0009865805229604f,
            +0.0000000000000000f,
            -0.0010438295401025f,
            -0.0015174452986323f,
            -0.0011025281660126f,
            +0.0000000000000000f,
            +0.0011627054335181f,
            +0.0016876629399007f,
            +0.0012243914000129f,
            -0.0000000000000000f,
            -0.0012876172077164f,
            -0.0018665039445554f,
            -0.0013524151478551f,
            -0.0000000000000000f,
            +0.0014188187290585f,
            +0.0020543339363826f,
            +0.0014868627502839f,
            -0.0000000000000000f,
            -0.0015565833786138f,
            -0.0022515469508069f,
            -0.0016280182322995f,
            +0.0000000000000000f,
            +0.0017012064694570f,
            +0.0024585689661799f,
            +0.0017761888828588f,
            -0.0000000000000001f,
            -0.0018530080013064f,
            -0.0026758619302655f,
            -0.0019317081981110f,
            +0.0000000000000000f,
            +0.0020123358072617f,
            +0.0029039283627990f,
            +0.0020949392479124f,
            +0.0000000000000000f,
            -0.0021795691578827f,
            -0.0031433166305705f,
            -0.0022662785369317f,
            +0.0000000000000001f,
            +0.0023551229006416f,
            +0.0033946270105201f,
            +0.0024461604458264f,
            -0.0000000000000000f,
            -0.0025394522284808f,
            -0.0036585186797036f,
            -0.0026350623553773f,
            +0.0000000000000000f,
            +0.0027330581905449f,
            +0.0039357177998310f,
            +0.0028335105779823f,
            -0.0000000000000000f,
            -0.0029364940821093f,
            -0.0042270268998406f,
            -0.0030420872476149f,
            +0.0000000000000000f,
            +0.0031503728805480f,
            +0.0045333358045560f,
            +0.0032614383526936f,
            -0.0000000000000000f,
            -0.0033753759315107f,
            -0.0048556344133628f,
            -0.0034922831381643f,
            +0.0000000000000000f,
            +0.0036122631364762f,
            +0.0051950277033080f,
            +0.0037354251559473f,
            +0.0000000000000000f,
            -0.0038618849523818f,
            -0.0055527534204337f,
            -0.0039917653100630f,
            +0.0000000000000000f,
            +0.0041251965899183f,
            +0.0059302030373166f,
            +0.0042623173286558f,
            -0.0000000000000000f,
            -0.0044032748944894f,
            -0.0063289467015709f,
            -0.0045482262057797f,
            +0.0000000000000000f,
            +0.0046973385197507f,
            +0.0067507630901733f,
            +0.0048507902993798f,
            -0.0000000000000001f,
            -0.0050087721676550f,
            -0.0071976753325661f,
            -0.0051714879596455f,
            -0.0000000000000000f,
            +0.0053391558842877f,
            +0.0076719944919443f,
            +0.0055120098094728f,
            -0.0000000000000000f,
            -0.0056903006859813f,
            -0.0081763725274213f,
            -0.0058742981280916f,
            +0.0000000000000001f,
            +0.0060642921713552f,
            +0.0087138672402142f,
            +0.0062605952311530f,
            +0.0000000000000000f,
            -0.0064635442893188f,
            -0.0092880224923026f,
            -0.0066735033404334f,
            -0.0000000000000000f,
            +0.0068908661345064f,
            +0.0099029680598097f,
            +0.0071160592588131f,
            -0.0000000000000000f,
            -0.0073495456088630f,
            -0.0105635449684010f,
            -0.0075918283070690f,
            +0.0000000000000001f,
            +0.0078434551379900f,
            +0.0112754642370518f,
            +0.0081050235813941f,
            -0.0000000000000001f,
            -0.0083771865393404f,
            -0.0120455099059071f,
            -0.0086606588715772f,
            -0.0000000000000000f,
            +0.0089562248755940f,
            +0.0128818014681738f,
            +0.0092647468745907f,
            -0.0000000000000000f,
            -0.0095871751096981f,
            -0.0137941370290747f,
            -0.0099245591735771f,
            +0.0000000000000001f,
            +0.0102780612731136f,
            +0.0147944477357047f,
            +0.0106489716719846f,
            -0.0000000000000000f,
            -0.0110387267429244f,
            -0.0158974079845805f,
            -0.0114489301591833f,
            -0.0000000000000000f,
            +0.0118813778811240f,
            +0.0171212674927752f,
            +0.0123380877553603f,
            -0.0000000000000000f,
            -0.0128213347514400f,
            -0.0184890054274438f,
            -0.0133336931299240f,
            +0.0000000000000001f,
            +0.0138780871865938f,
            +0.0200299620685047f,
            +0.0144578526791940f,
            -0.0000000000000000f,
            -0.0150768116558942f,
            -0.0217821956125176f,
            -0.0157393642255338f,
            -0.0000000000000000f,
            +0.0164506019203318f,
            +0.0237959701950330f,
            +0.0172164488203245f,
            -0.0000000000000000f,
            -0.0180438387089742f,
            -0.0261390636973287f,
            -0.0189409394696360f,
            +0.0000000000000001f,
            +0.0199174401036205f,
            +0.0289051085252159f,
            +0.0209849217528235f,
            -0.0000000000000000f,
            -0.0221573428824029f,
            -0.0322272001794569f,
            -0.0234516818191808f,
            +0.0000000000000000f,
            +0.0248887995880585f,
            +0.0363011117970633f,
            +0.0264946165061903f,
            -0.0000000000000000f,
            -0.0283017442319639f,
            -0.0414270802341371f,
            -0.0303517931435070f,
            +0.0000000000000000f,
            +0.0326987052175801f,
            +0.0480901638096349f,
            +0.0354136866890553f,
            -0.0000000000000000f,
            -0.0385927142704622f,
            -0.0571282629124219f,
            -0.0423683306382987f,
            +0.0000000000000000f,
            +0.0469288896984498f,
            +0.0701241679229563f,
            +0.0525513867429064f,
            -0.0000000000000000f,
            -0.0596605527296562f,
            -0.0904696890758395f,
            -0.0689424971260680f,
            +0.0000000000000000f,
            +0.0815823247602074f,
            +0.1269836976940222f,
            +0.0998185751368425f,
            -0.0000000000000000f,
            -0.1284481291475161f,
            -0.2120023318573107f,
            -0.1799428918780322f,
            +0.0000000000000000f,
            +0.3000332066346169f,
            +0.6365516685731774f,
            +0.9002922372500939f,
            +1.0000000000000000f,
            +0.9002922372500939f,
            +0.6365516685731774f,
            +0.3000332066346169f,
            +0.0000000000000000f,
            -0.1799428918780322f,
            -0.2120023318573107f,
            -0.1284481291475161f,
            -0.0000000000000000f,
            +0.0998185751368425f,
            +0.1269836976940222f,
            +0.0815823247602074f,
            +0.0000000000000000f,
            -0.0689424971260680f,
            -0.0904696890758395f,
            -0.0596605527296562f,
            -0.0000000000000000f,
            +0.0525513867429064f,
            +0.0701241679229563f,
            +0.0469288896984498f,
            +0.0000000000000000f,
            -0.0423683306382987f,
            -0.0571282629124219f,
            -0.0385927142704622f,
            -0.0000000000000000f,
            +0.0354136866890553f,
            +0.0480901638096349f,
            +0.0326987052175801f,
            +0.0000000000000000f,
            -0.0303517931435070f,
            -0.0414270802341371f,
            -0.0283017442319639f,
            -0.0000000000000000f,
            +0.0264946165061903f,
            +0.0363011117970633f,
            +0.0248887995880585f,
            +0.0000000000000000f,
            -0.0234516818191808f,
            -0.0322272001794569f,
            -0.0221573428824029f,
            -0.0000000000000000f,
            +0.0209849217528235f,
            +0.0289051085252159f,
            +0.0199174401036205f,
            +0.0000000000000001f,
            -0.0189409394696360f,
            -0.0261390636973287f,
            -0.0180438387089742f,
            -0.0000000000000000f,
            +0.0172164488203245f,
            +0.0237959701950330f,
            +0.0164506019203318f,
            -0.0000000000000000f,
            -0.0157393642255338f,
            -0.0217821956125176f,
            -0.0150768116558942f,
            -0.0000000000000000f,
            +0.0144578526791940f,
            +0.0200299620685047f,
            +0.0138780871865938f,
            +0.0000000000000001f,
            -0.0133336931299240f,
            -0.0184890054274438f,
            -0.0128213347514400f,
            -0.0000000000000000f,
            +0.0123380877553603f,
            +0.0171212674927752f,
            +0.0118813778811240f,
            -0.0000000000000000f,
            -0.0114489301591833f,
            -0.0158974079845805f,
            -0.0110387267429244f,
            -0.0000000000000000f,
            +0.0106489716719846f,
            +0.0147944477357047f,
            +0.0102780612731136f,
            +0.0000000000000001f,
            -0.0099245591735771f,
            -0.0137941370290747f,
            -0.0095871751096981f,
            -0.0000000000000000f,
            +0.0092647468745907f,
            +0.0128818014681738f,
            +0.0089562248755940f,
            -0.0000000000000000f,
            -0.0086606588715772f,
            -0.0120455099059071f,
            -0.0083771865393404f,
            -0.0000000000000001f,
            +0.0081050235813941f,
            +0.0112754642370518f,
            +0.0078434551379900f,
            +0.0000000000000001f,
            -0.0075918283070690f,
            -0.0105635449684010f,
            -0.0073495456088630f,
            -0.0000000000000000f,
            +0.0071160592588131f,
            +0.0099029680598097f,
            +0.0068908661345064f,
            -0.0000000000000000f,
            -0.0066735033404334f,
            -0.0092880224923026f,
            -0.0064635442893188f,
            +0.0000000000000000f,
            +0.0062605952311530f,
            +0.0087138672402142f,
            +0.0060642921713552f,
            +0.0000000000000001f,
            -0.0058742981280916f,
            -0.0081763725274213f,
            -0.0056903006859813f,
            -0.0000000000000000f,
            +0.0055120098094728f,
            +0.0076719944919443f,
            +0.0053391558842877f,
            -0.0000000000000000f,
            -0.0051714879596455f,
            -0.0071976753325661f,
            -0.0050087721676550f,
            -0.0000000000000001f,
            +0.0048507902993798f,
            +0.0067507630901733f,
            +0.0046973385197507f,
            +0.0000000000000000f,
            -0.0045482262057797f,
            -0.0063289467015709f,
            -0.0044032748944894f,
            -0.0000000000000000f,
            +0.0042623173286558f,
            +0.0059302030373166f,
            +0.0041251965899183f,
            +0.0000000000000000f,
            -0.0039917653100630f,
            -0.0055527534204337f,
            -0.0038618849523818f,
            +0.0000000000000000f,
            +0.0037354251559473f,
            +0.0051950277033080f,
            +0.0036122631364762f,
            +0.0000000000000000f,
            -0.0034922831381643f,
            -0.0048556344133628f,
            -0.0033753759315107f,
            -0.0000000000000000f,
            +0.0032614383526936f,
            +0.0045333358045560f,
            +0.0031503728805480f,
            +0.0000000000000000f,
            -0.0030420872476149f,
            -0.0042270268998406f,
            -0.0029364940821093f,
            -0.0000000000000000f,
            +0.0028335105779823f,
            +0.0039357177998310f,
            +0.0027330581905449f,
            +0.0000000000000000f,
            -0.0026350623553773f,
            -0.0036585186797036f,
            -0.0025394522284808f,
            -0.0000000000000000f,
            +0.0024461604458264f,
            +0.0033946270105201f,
            +0.0023551229006416f,
            +0.0000000000000001f,
            -0.0022662785369317f,
            -0.0031433166305705f,
            -0.0021795691578827f,
            +0.0000000000000000f,
            +0.0020949392479124f,
            +0.0029039283627990f,
            +0.0020123358072617f,
            +0.0000000000000000f,
            -0.0019317081981110f,
            -0.0026758619302655f,
            -0.0018530080013064f,
            -0.0000000000000001f,
            +0.0017761888828588f,
            +0.0024585689661799f,
            +0.0017012064694570f,
            +0.0000000000000000f,
            -0.0016280182322995f,
            -0.0022515469508069f,
            -0.0015565833786138f,
            -0.0000000000000000f,
            +0.0014868627502839f,
            +0.0020543339363826f,
            +0.0014188187290585f,
            -0.0000000000000000f,
            -0.0013524151478551f,
            -0.0018665039445554f,
            -0.0012876172077164f,
            -0.0000000000000000f,
            +0.0012243914000129f,
            +0.0016876629399007f,
            +0.0011627054335181f,
            +0.0000000000000000f,
            -0.0011025281660126f,
            -0.0015174452986323f,
            -0.0010438295401025f,
            +0.0000000000000000f,
            +0.0009865805229604f,
            +0.0013555107044297f,
            +0.0009307530497225f,
            +0.0000000000000000f,
            -0.0008763199702937f,
            -0.0012015414138581f,
            -0.0008232549993348f,
            +0.0000000000000000f,
            +0.0007715326692185f,
            +0.0010552398426108f,
            +0.0007211282857631f,
            +0.0000000000000000f,
            -0.0006720178865607f,
            -0.0009163264310727f,
            -0.0006241782017359f,
            -0.0000000000000000f,
            +0.0005775866169788f,
            +0.0007845377537817f,
            +0.0005322211387104f,
            -0.0000000000000000f,
            -0.0004880603612460f,
            -0.0006596248424501f,
            -0.0004450834358354f,
            -0.0000000000000000f,
            +0.0004032700414632f,
            +0.0005413516964839f,
            +0.0003626003573035f,
            +0.0000000000000000f,
            -0.0003230550367297f,
            -0.0004294939585451f,
            -0.0002846151827871f,
            +0.0000000000000000f,
            +0.0002472623250414f,
            +0.0003238377357525f,
            +0.0002109783977240f,
            +0.0000000000000000f,
            -0.0001757457190975f,
            -0.0002241785497035f,
            -0.0001415469719733f,
            -0.0000000000000000f,
            +0.0001083651853141f,
            +0.0001303204007046f,
            +0.0000761837168614f,
            +0.0000000000000000f,
            -0.0000449862367299f,
            -0.0000420749334770f,
            -0.0000147567119155f,
        };

        static const float lanczos_6x16bit[] =
        {
            -0.0000000000000000f,
            -0.0002742009152674f,
            -0.0009815489562645f,
            -0.0017562465551615f,
            -0.0020942872238989f,
            -0.0015604275569633f,
            +0.0000000000000000f,
            +0.0023267524631304f,
            +0.0047516013794984f,
            +0.0063666235011747f,
            +0.0063177637662556f,
            +0.0041370366111611f,
            -0.0000000000000000f,
            -0.0051957571951368f,
            -0.0099891519370195f,
            -0.0127368704055724f,
            -0.0121255512693219f,
            -0.0076654639058858f,
            +0.0000000000000000f,
            +0.0090990583185247f,
            +0.0170979497396445f,
            +0.0213675350683576f,
            +0.0199846412434967f,
            +0.0124371550700093f,
            -0.0000000000000000f,
            -0.0143807139962907f,
            -0.0267288298873959f,
            -0.0330822319797804f,
            -0.0306794648208279f,
            -0.0189519446063220f,
            +0.0000000000000000f,
            +0.0216561459770221f,
            +0.0400711377251631f,
            +0.0494191366611535f,
            +0.0457078806950142f,
            +0.0281861994327296f,
            -0.0000000000000000f,
            -0.0321861347652982f,
            -0.0596235990818374f,
            -0.0736961923786210f,
            -0.0683917989585780f,
            -0.0423698532782270f,
            +0.0000000000000000f,
            +0.0490430545397334f,
            +0.0916994814742472f,
            +0.1146318336501513f,
            +0.1078420688710883f,
            +0.0679137730417580f,
            -0.0000000000000000f,
            -0.0820911149041139f,
            -0.1579440941563912f,
            -0.2044393546488325f,
            -0.2007551582838082f,
            -0.1333846463047618f,
            +0.0000000000000000f,
            +0.1888117343925626f,
            +0.4104802958841833f,
            +0.6340050064132841f,
            +0.8254826722184564f,
            +0.9544933860459598f,
            +1.0000000000000000f,
            +0.9544933860459598f,
            +0.8254826722184564f,
            +0.6340050064132841f,
            +0.4104802958841833f,
            +0.1888117343925626f,
            +0.0000000000000000f,
            -0.1333846463047618f,
            -0.2007551582838082f,
            -0.2044393546488325f,
            -0.1579440941563912f,
            -0.0820911149041139f,
            -0.0000000000000000f,
            +0.0679137730417580f,
            +0.1078420688710883f,
            +0.1146318336501513f,
            +0.0916994814742472f,
            +0.0490430545397334f,
            +0.0000000000000000f,
            -0.0423698532782270f,
            -0.0683917989585780f,
            -0.0736961923786210f,
            -0.0596235990818374f,
            -0.0321861347652982f,
            -0.0000000000000000f,
            +0.0281861994327296f,
            +0.0457078806950142f,
            +0.0494191366611535f,
            +0.0400711377251631f,
            +0.0216561459770221f,
            +0.0000000000000000f,
            -0.0189519446063220f,
            -0.0306794648208279f,
            -0.0330822319797804f,
            -0.0267288298873959f,
            -0.0143807139962907f,
            -0.0000000000000000f,
            +0.0124371550700093f,
            +0.0199846412434967f,
            +0.0213675350683576f,
            +0.0170979497396445f,
            +0.0090990583185247f,
            +0.0000000000000000f,
            -0.0076654639058858f,
            -0.0121255512693219f,
            -0.0127368704055724f,
            -0.0099891519370195f,
            -0.0051957571951368f,
            -0.0000000000000000f,
            +0.0041370366111611f,
            +0.0063177637662556f,
            +0.0063666235011747f,
            +0.0047516013794984f,
            +0.0023267524631304f,
            +0.0000000000000000f,
            -0.0015604275569633f,
            -0.0020942872238989f,
            -0.0017562465551615f,
            -0.0009815489562645f,
            -0.0002742009152674f
        };

        static const float lanczos_6x24bit[] =
        {
            -0.0000000000000000f,
            -0.0000069377460756f,
            -0.0000241622796987f,
            -0.0000420749334770f,
            -0.0000488442856854f,
            -0.0000354388966037f,
            +0.0000000000000000f,
            +0.0000501453548377f,
            +0.0000997904058213f,
            +0.0001303204007046f,
            +0.0001260661561723f,
            +0.0000804868331668f,
            -0.0000000000000000f,
            -0.0000961286958223f,
            -0.0001802526675327f,
            -0.0002241785497035f,
            -0.0002081755069076f,
            -0.0001283721023069f,
            +0.0000000000000000f,
            +0.0001449807573448f,
            +0.0002657111465349f,
            +0.0003238377357525f,
            +0.0002953365149800f,
            +0.0001791901122778f,
            +0.0000000000000000f,
            -0.0001967982211715f,
            -0.0003563344322158f,
            -0.0004294939585451f,
            -0.0003877200924771f,
            -0.0002330402273110f,
            +0.0000000000000000f,
            +0.0002516818640264f,
            +0.0004522983304941f,
            +0.0005413516964839f,
            +0.0004855046229488f,
            +0.0002900262010196f,
            -0.0000000000000000f,
            -0.0003097370078989f,
            -0.0005537866588479f,
            -0.0006596248424501f,
            -0.0005888767874851f,
            -0.0003502566625677f,
            -0.0000000000000000f,
            +0.0003710740252356f,
            +0.0006609921383055f,
            +0.0007845377537817f,
            +0.0006980324916908f,
            +0.0004138456622666f,
            -0.0000000000000000f,
            -0.0004358089059932f,
            -0.0007741173947661f,
            -0.0009163264310727f,
            -0.0008131779065094f,
            -0.0004809132842539f,
            +0.0000000000000000f,
            +0.0005040638945748f,
            +0.0008933760838732f,
            +0.0010552398426108f,
            +0.0009345306378089f,
            +0.0005515863350711f,
            +0.0000000000000000f,
            -0.0005759682058959f,
            -0.0010189941558477f,
            -0.0012015414138581f,
            -0.0010623210419442f,
            -0.0006259991183230f,
            +0.0000000000000000f,
            +0.0006516588312719f,
            +0.0011512112792538f,
            +0.0013555107044297f,
            +0.0011967937072283f,
            +0.0007042943072153f,
            +0.0000000000000000f,
            -0.0007312814465212f,
            -0.0012902824457130f,
            -0.0015174452986323f,
            -0.0013382091244565f,
            -0.0007866239286706f,
            +0.0000000000000000f,
            +0.0008149914367013f,
            +0.0014364797811740f,
            +0.0016876629399007f,
            +0.0014868455734379f,
            +0.0008731504749936f,
            -0.0000000000000000f,
            -0.0009029550542891f,
            -0.0015900945936304f,
            -0.0018665039445554f,
            -0.0016430012570262f,
            -0.0009640481617492f,
            -0.0000000000000000f,
            +0.0009953507304848f,
            +0.0017514396922808f,
            +0.0020543339363826f,
            +0.0018069967195599f,
            +0.0010595043537417f,
            -0.0000000000000000f,
            -0.0010923705627366f,
            -0.0019208520192378f,
            -0.0022515469508069f,
            -0.0019791775931192f,
            -0.0011597211848512f,
            +0.0000000000000000f,
            +0.0011942220056977f,
            +0.0020986956422391f,
            +0.0024585689661799f,
            +0.0021599177228197f,
            +0.0012649174021384f,
            -0.0000000000000001f,
            -0.0013011297977853f,
            -0.0022853651656731f,
            -0.0026758619302655f,
            -0.0023496227318036f,
            -0.0013753304702524f,
            +0.0000000000000000f,
            +0.0014133381615058f,
            +0.0024812896279599f,
            +0.0029039283627990f,
            +0.0025487340980392f,
            +0.0014912189790098f,
            +0.0000000000000000f,
            -0.0015311133230026f,
            -0.0026869369663787f,
            -0.0031433166305705f,
            -0.0027577338289749f,
            -0.0016128654053270f,
            +0.0000000000000001f,
            +0.0016547464051823f,
            +0.0029028191463709f,
            +0.0033946270105201f,
            +0.0029771498371556f,
            +0.0017405792908825f,
            -0.0000000000000000f,
            -0.0017845567596771f,
            -0.0031294980719012f,
            -0.0036585186797036f,
            -0.0032075621408580f,
            -0.0018747009094084f,
            +0.0000000000000000f,
            +0.0019208958163458f,
            +0.0033675924175698f,
            +0.0039357177998310f,
            +0.0034496100396870f,
            +0.0020156055129952f,
            -0.0000000000000000f,
            -0.0020641515456445f,
            -0.0036177855530381f,
            -0.0042270268998406f,
            -0.0037040004471911f,
            -0.0021637082660294f,
            +0.0000000000000000f,
            +0.0022147536499022f,
            +0.0038808347675323f,
            +0.0045333358045560f,
            +0.0039715176026307f,
            +0.0023194699994017f,
            -0.0000000000000000f,
            -0.0023731796254328f,
            -0.0041575820487861f,
            -0.0048556344133628f,
            -0.0042530344343228f,
            -0.0024834039477934f,
            +0.0000000000000000f,
            +0.0025399618700113f,
            +0.0044489667294701f,
            +0.0051950277033080f,
            +0.0045495259104529f,
            +0.0026560836709670f,
            +0.0000000000000000f,
            -0.0027156960515040f,
            -0.0047560403885408f,
            -0.0055527534204337f,
            -0.0048620847938549f,
            -0.0028381524084465f,
            +0.0000000000000000f,
            +0.0029010510060173f,
            +0.0050799844898190f,
            +0.0059302030373166f,
            +0.0051919403203071f,
            +0.0030303341789957f,
            -0.0000000000000000f,
            -0.0030967805013731f,
            -0.0054221313619506f,
            -0.0063289467015709f,
            -0.0055404804525440f,
            -0.0032334470162358f,
            +0.0000000000000000f,
            +0.0033037372888459f,
            +0.0057839892815074f,
            +0.0067507630901733f,
            +0.0059092785341872f,
            +0.0034484188355236f,
            -0.0000000000000001f,
            -0.0035228899795080f,
            -0.0061672726264071f,
            -0.0071976753325661f,
            -0.0063001253925905f,
            -0.0036763065630211f,
            -0.0000000000000000f,
            +0.0037553434303483f,
            +0.0065739383367428f,
            +0.0076719944919443f,
            +0.0067150682357790f,
            +0.0039183193370829f,
            -0.0000000000000000f,
            -0.0040023635222630f,
            -0.0070062302778336f,
            -0.0081763725274213f,
            -0.0071564580823837f,
            -0.0041758468306658f,
            +0.0000000000000001f,
            +0.0042654074750092f,
            +0.0074667335787580f,
            +0.0087138672402142f,
            +0.0076270079917564f,
            +0.0044504940640847f,
            +0.0000000000000000f,
            -0.0045461611988275f,
            -0.0079584416658553f,
            -0.0092880224923026f,
            -0.0081298650774134f,
            -0.0047441245127349f,
            -0.0000000000000000f,
            +0.0048465856655727f,
            +0.0084848395926892f,
            +0.0099029680598097f,
            +0.0086687002677317f,
            +0.0050589139117960f,
            -0.0000000000000000f,
            -0.0051689749477717f,
            -0.0090500084853921f,
            -0.0105635449684010f,
            -0.0092478211369019f,
            -0.0053974179894203f,
            +0.0000000000000001f,
            +0.0055160295019491f,
            +0.0096587576231200f,
            +0.0112754642370518f,
            +0.0098723150359084f,
            +0.0057626585261750f,
            -0.0000000000000001f,
            -0.0058909495829935f,
            -0.0103167930806617f,
            -0.0120455099059071f,
            -0.0105482324644982f,
            -0.0061582338006733f,
            -0.0000000000000000f,
            +0.0062975555528702f,
            +0.0110309353158997f,
            +0.0128818014681738f,
            +0.0112828245363256f,
            +0.0065884618852866f,
            -0.0000000000000000f,
            -0.0067404445750613f,
            -0.0118094031218828f,
            -0.0137941370290747f,
            -0.0120848541214312f,
            -0.0070585687886040f,
            +0.0000000000000001f,
            +0.0072251972178721f,
            +0.0126621888289166f,
            +0.0147944477357047f,
            +0.0129650087960713f,
            +0.0075749387242667f,
            -0.0000000000000000f,
            -0.0077586535562204f,
            -0.0136015609109855f,
            -0.0158974079845805f,
            -0.0139364567130341f,
            -0.0081454518384663f,
            -0.0000000000000000f,
            +0.0083492876714696f,
            +0.0146427475049337f,
            +0.0171212674927752f,
            +0.0150156066426794f,
            +0.0087799472639974f,
            -0.0000000000000000f,
            -0.0090077240507754f,
            -0.0158048816743398f,
            -0.0184890054274438f,
            -0.0162231653916370f,
            -0.0094908693430517f,
            +0.0000000000000001f,
            +0.0097474628489253f,
            +0.0171123333402252f,
            +0.0200299620685047f,
            +0.0175856378286361f,
            +0.0102941875248073f,
            -0.0000000000000000f,
            -0.0105859197012545f,
            -0.0185966259259565f,
            -0.0217821956125176f,
            -0.0191375018846899f,
            -0.0112107354349243f,
            -0.0000000000000000f,
            +0.0115459516600702f,
            +0.0202992608463264f,
            +0.0237959701950330f,
            +0.0209244416196306f,
            +0.0122682102834381f,
            -0.0000000000000000f,
            -0.0126581568196817f,
            -0.0222759945457239f,
            -0.0261390636973287f,
            -0.0230082918649483f,
            -0.0135042465535896f,
            +0.0000000000000001f,
            +0.0139644475509658f,
            +0.0246035213190903f,
            +0.0289051085252159f,
            +0.0254748538961921f,
            +0.0149713036394674f,
            -0.0000000000000000f,
            -0.0155238039817806f,
            -0.0273903040325239f,
            -0.0322272001794569f,
            -0.0284467354053715f,
            -0.0167447526287350f,
            +0.0000000000000000f,
            +0.0174219354642107f,
            +0.0307949029684039f,
            +0.0363011117970633f,
            +0.0321054351835699f,
            +0.0189369043537541f,
            -0.0000000000000000f,
            -0.0197883422711256f,
            -0.0350586489068662f,
            -0.0414270802341371f,
            -0.0367314970079870f,
            -0.0217227818093713f,
            +0.0000000000000000f,
            +0.0228283582436528f,
            +0.0405677218898500f,
            +0.0480901638096349f,
            +0.0427827039573689f,
            +0.0253909683794416f,
            -0.0000000000000000f,
            -0.0268881515294631f,
            -0.0479809603323249f,
            -0.0571282629124219f,
            -0.0510602412159371f,
            -0.0304535055471874f,
            +0.0000000000000000f,
            +0.0326004158179651f,
            +0.0585219959992017f,
            +0.0701241679229563f,
            +0.0631049303064250f,
            +0.0379140432208533f,
            -0.0000000000000000f,
            -0.0412580999348852f,
            -0.0747494278616736f,
            -0.0904696890758395f,
            -0.0823066847506617f,
            -0.0500440642437167f,
            +0.0000000000000000f,
            +0.0559795646824366f,
            +0.1030598868884597f,
            +0.1269836976940222f,
            +0.1178668514370637f,
            +0.0733086535282330f,
            -0.0000000000000000f,
            -0.0866869800423798f,
            -0.1652021336944537f,
            -0.2120023318573107f,
            -0.2065910876515157f,
            -0.1363390795560842f,
            +0.0000000000000000f,
            +0.1909291817863155f,
            +0.4134180340412702f,
            +0.6365516685731774f,
            +0.8269540226875740f,
            +0.9549183075951538f,
            +1.0000000000000000f,
            +0.9549183075951538f,
            +0.8269540226875740f,
            +0.6365516685731774f,
            +0.4134180340412702f,
            +0.1909291817863155f,
            +0.0000000000000000f,
            -0.1363390795560842f,
            -0.2065910876515157f,
            -0.2120023318573107f,
            -0.1652021336944537f,
            -0.0866869800423798f,
            -0.0000000000000000f,
            +0.0733086535282330f,
            +0.1178668514370637f,
            +0.1269836976940222f,
            +0.1030598868884597f,
            +0.0559795646824366f,
            +0.0000000000000000f,
            -0.0500440642437167f,
            -0.0823066847506617f,
            -0.0904696890758395f,
            -0.0747494278616736f,
            -0.0412580999348852f,
            -0.0000000000000000f,
            +0.0379140432208533f,
            +0.0631049303064250f,
            +0.0701241679229563f,
            +0.0585219959992017f,
            +0.0326004158179651f,
            +0.0000000000000000f,
            -0.0304535055471874f,
            -0.0510602412159371f,
            -0.0571282629124219f,
            -0.0479809603323249f,
            -0.0268881515294631f,
            -0.0000000000000000f,
            +0.0253909683794416f,
            +0.0427827039573689f,
            +0.0480901638096349f,
            +0.0405677218898500f,
            +0.0228283582436528f,
            +0.0000000000000000f,
            -0.0217227818093713f,
            -0.0367314970079870f,
            -0.0414270802341371f,
            -0.0350586489068662f,
            -0.0197883422711256f,
            -0.0000000000000000f,
            +0.0189369043537541f,
            +0.0321054351835699f,
            +0.0363011117970633f,
            +0.0307949029684039f,
            +0.0174219354642107f,
            +0.0000000000000000f,
            -0.0167447526287350f,
            -0.0284467354053715f,
            -0.0322272001794569f,
            -0.0273903040325239f,
            -0.0155238039817806f,
            -0.0000000000000000f,
            +0.0149713036394674f,
            +0.0254748538961921f,
            +0.0289051085252159f,
            +0.0246035213190903f,
            +0.0139644475509658f,
            +0.0000000000000001f,
            -0.0135042465535896f,
            -0.0230082918649483f,
            -0.0261390636973287f,
            -0.0222759945457239f,
            -0.0126581568196817f,
            -0.0000000000000000f,
            +0.0122682102834381f,
            +0.0209244416196306f,
            +0.0237959701950330f,
            +0.0202992608463264f,
            +0.0115459516600702f,
            -0.0000000000000000f,
            -0.0112107354349243f,
            -0.0191375018846899f,
            -0.0217821956125176f,
            -0.0185966259259565f,
            -0.0105859197012545f,
            -0.0000000000000000f,
            +0.0102941875248073f,
            +0.0175856378286361f,
            +0.0200299620685047f,
            +0.0171123333402252f,
            +0.0097474628489253f,
            +0.0000000000000001f,
            -0.0094908693430517f,
            -0.0162231653916370f,
            -0.0184890054274438f,
            -0.0158048816743398f,
            -0.0090077240507754f,
            -0.0000000000000000f,
            +0.0087799472639974f,
            +0.0150156066426794f,
            +0.0171212674927752f,
            +0.0146427475049337f,
            +0.0083492876714696f,
            -0.0000000000000000f,
            -0.0081454518384663f,
            -0.0139364567130341f,
            -0.0158974079845805f,
            -0.0136015609109855f,
            -0.0077586535562204f,
            -0.0000000000000000f,
            +0.0075749387242667f,
            +0.0129650087960713f,
            +0.0147944477357047f,
            +0.0126621888289166f,
            +0.0072251972178721f,
            +0.0000000000000001f,
            -0.0070585687886040f,
            -0.0120848541214312f,
            -0.0137941370290747f,
            -0.0118094031218828f,
            -0.0067404445750613f,
            -0.0000000000000000f,
            +0.0065884618852866f,
            +0.0112828245363256f,
            +0.0128818014681738f,
            +0.0110309353158997f,
            +0.0062975555528702f,
            -0.0000000000000000f,
            -0.0061582338006733f,
            -0.0105482324644982f,
            -0.0120455099059071f,
            -0.0103167930806617f,
            -0.0058909495829935f,
            -0.0000000000000001f,
            +0.0057626585261750f,
            +0.0098723150359084f,
            +0.0112754642370518f,
            +0.0096587576231200f,
            +0.0055160295019491f,
            +0.0000000000000001f,
            -0.0053974179894203f,
            -0.0092478211369019f,
            -0.0105635449684010f,
            -0.0090500084853921f,
            -0.0051689749477717f,
            -0.0000000000000000f,
            +0.0050589139117960f,
            +0.0086687002677317f,
            +0.0099029680598097f,
            +0.0084848395926892f,
            +0.0048465856655727f,
            -0.0000000000000000f,
            -0.0047441245127349f,
            -0.0081298650774134f,
            -0.0092880224923026f,
            -0.0079584416658553f,
            -0.0045461611988275f,
            +0.0000000000000000f,
            +0.0044504940640847f,
            +0.0076270079917564f,
            +0.0087138672402142f,
            +0.0074667335787580f,
            +0.0042654074750092f,
            +0.0000000000000001f,
            -0.0041758468306658f,
            -0.0071564580823837f,
            -0.0081763725274213f,
            -0.0070062302778336f,
            -0.0040023635222630f,
            -0.0000000000000000f,
            +0.0039183193370829f,
            +0.0067150682357790f,
            +0.0076719944919443f,
            +0.0065739383367428f,
            +0.0037553434303483f,
            -0.0000000000000000f,
            -0.0036763065630211f,
            -0.0063001253925905f,
            -0.0071976753325661f,
            -0.0061672726264071f,
            -0.0035228899795080f,
            -0.0000000000000001f,
            +0.0034484188355236f,
            +0.0059092785341872f,
            +0.0067507630901733f,
            +0.0057839892815074f,
            +0.0033037372888459f,
            +0.0000000000000000f,
            -0.0032334470162358f,
            -0.0055404804525440f,
            -0.0063289467015709f,
            -0.0054221313619506f,
            -0.0030967805013731f,
            -0.0000000000000000f,
            +0.0030303341789957f,
            +0.0051919403203071f,
            +0.0059302030373166f,
            +0.0050799844898190f,
            +0.0029010510060173f,
            +0.0000000000000000f,
            -0.0028381524084465f,
            -0.0048620847938549f,
            -0.0055527534204337f,
            -0.0047560403885408f,
            -0.0027156960515040f,
            +0.0000000000000000f,
            +0.0026560836709670f,
            +0.0045495259104529f,
            +0.0051950277033080f,
            +0.0044489667294701f,
            +0.0025399618700113f,
            +0.0000000000000000f,
            -0.0024834039477934f,
            -0.0042530344343228f,
            -0.0048556344133628f,
            -0.0041575820487861f,
            -0.0023731796254328f,
            -0.0000000000000000f,
            +0.0023194699994017f,
            +0.0039715176026307f,
            +0.0045333358045560f,
            +0.0038808347675323f,
            +0.0022147536499022f,
            +0.0000000000000000f,
            -0.0021637082660294f,
            -0.0037040004471911f,
            -0.0042270268998406f,
            -0.0036177855530381f,
            -0.0020641515456445f,
            -0.0000000000000000f,
            +0.0020156055129952f,
            +0.0034496100396870f,
            +0.0039357177998310f,
            +0.0033675924175698f,
            +0.0019208958163458f,
            +0.0000000000000000f,
            -0.0018747009094084f,
            -0.0032075621408580f,
            -0.0036585186797036f,
            -0.0031294980719012f,
            -0.0017845567596771f,
            -0.0000000000000000f,
            +0.0017405792908825f,
            +0.0029771498371556f,
            +0.0033946270105201f,
            +0.0029028191463709f,
            +0.0016547464051823f,
            +0.0000000000000001f,
            -0.0016128654053270f,
            -0.0027577338289749f,
            -0.0031433166305705f,
            -0.0026869369663787f,
            -0.0015311133230026f,
            +0.0000000000000000f,
            +0.0014912189790098f,
            +0.0025487340980392f,
            +0.0029039283627990f,
            +0.0024812896279599f,
            +0.0014133381615058f,
            +0.0000000000000000f,
            -0.0013753304702524f,
            -0.0023496227318036f,
            -0.0026758619302655f,
            -0.0022853651656731f,
            -0.0013011297977853f,
            -0.0000000000000001f,
            +0.0012649174021384f,
            +0.0021599177228197f,
            +0.0024585689661799f,
            +0.0020986956422391f,
            +0.0011942220056977f,
            +0.0000000000000000f,
            -0.0011597211848512f,
            -0.0019791775931192f,
            -0.0022515469508069f,
            -0.0019208520192378f,
            -0.0010923705627366f,
            -0.0000000000000000f,
            +0.0010595043537417f,
            +0.0018069967195599f,
            +0.0020543339363826f,
            +0.0017514396922808f,
            +0.0009953507304848f,
            -0.0000000000000000f,
            -0.0009640481617492f,
            -0.0016430012570262f,
            -0.0018665039445554f,
            -0.0015900945936304f,
            -0.0009029550542891f,
            -0.0000000000000000f,
            +0.0008731504749936f,
            +0.0014868455734379f,
            +0.0016876629399007f,
            +0.0014364797811740f,
            +0.0008149914367013f,
            +0.0000000000000000f,
            -0.0007866239286706f,
            -0.0013382091244565f,
            -0.0015174452986323f,
            -0.0012902824457130f,
            -0.0007312814465212f,
            +0.0000000000000000f,
            +0.0007042943072153f,
            +0.0011967937072283f,
            +0.0013555107044297f,
            +0.0011512112792538f,
            +0.0006516588312719f,
            +0.0000000000000000f,
            -0.0006259991183230f,
            -0.0010623210419442f,
            -0.0012015414138581f,
            -0.0010189941558477f,
            -0.0005759682058959f,
            +0.0000000000000000f,
            +0.0005515863350711f,
            +0.0009345306378089f,
            +0.0010552398426108f,
            +0.0008933760838732f,
            +0.0005040638945748f,
            +0.0000000000000000f,
            -0.0004809132842539f,
            -0.0008131779065094f,
            -0.0009163264310727f,
            -0.0007741173947661f,
            -0.0004358089059932f,
            -0.0000000000000000f,
            +0.0004138456622666f,
            +0.0006980324916908f,
            +0.0007845377537817f,
            +0.0006609921383055f,
            +0.0003710740252356f,
            -0.0000000000000000f,
            -0.0003502566625677f,
            -0.0005888767874851f,
            -0.0006596248424501f,
            -0.0005537866588479f,
            -0.0003097370078989f,
            -0.0000000000000000f,
            +0.0002900262010196f,
            +0.0004855046229488f,
            +0.0005413516964839f,
            +0.0004522983304941f,
            +0.0002516818640264f,
            +0.0000000000000000f,
            -0.0002330402273110f,
            -0.0003877200924771f,
            -0.0004294939585451f,
            -0.0003563344322158f,
            -0.0001967982211715f,
            +0.0000000000000000f,
            +0.0001791901122778f,
            +0.0002953365149800f,
            +0.0003238377357525f,
            +0.0002657111465349f,
            +0.0001449807573448f,
            +0.0000000000000000f,
            -0.0001283721023069f,
            -0.0002081755069076f,
            -0.0002241785497035f,
            -0.0001802526675327f,
            -0.0000961286958223f,
            -0.0000000000000000f,
            +0.0000804868331668f,
            +0.0001260661561723f,
            +0.0001303204007046f,
            +0.0000997904058213f,
            +0.0000501453548377f,
            +0.0000000000000000f,
            -0.0000354388966037f,
            -0.0000488442856854f,
            -0.0000420749334770f,
            -0.0000241622796987f,
            -0.0000069377460756f
        };

        static const float lanczos_8x16bit[] =
        {
            -0.0000000000000000f,
            -0.0001561039756442f,
            -0.0005913155824994f,
            -0.0011876547072368f,
            -0.0017562465551615f,
            -0.0020778240718027f,
            -0.0019547311991183f,
            -0.0012640048354491f,
            +0.0000000000000000f,
            +0.0017038297385736f,
            +0.0035810370252689f,
            +0.0052681555527679f,
            +0.0063666235011747f,
            +0.0065210617387479f,
            +0.0054999971123013f,
            +0.0032631132329234f,
            -0.0000000000000000f,
            -0.0038707520257185f,
            -0.0077468699938191f,
            -0.0109289443646814f,
            -0.0127368704055724f,
            -0.0126380011986749f,
            -0.0103646528127521f,
            -0.0059981198390733f,
            +0.0000000000000000f,
            +0.0068208875834489f,
            +0.0134073670073630f,
            +0.0186083250382542f,
            +0.0213675350683576f,
            +0.0209174888029406f,
            +0.0169449607813781f,
            +0.0096965925527014f,
            -0.0000000000000000f,
            -0.0108119670384862f,
            -0.0210708028282491f,
            -0.0290164639273983f,
            -0.0330822319797804f,
            -0.0321764295372770f,
            -0.0259134834384236f,
            -0.0147508559291044f,
            +0.0000000000000000f,
            +0.0163025567500491f,
            +0.0316560836463846f,
            +0.0434581579360301f,
            +0.0494191366611535f,
            +0.0479659913901889f,
            +0.0385690473915008f,
            +0.0219317127529990f,
            -0.0000000000000000f,
            -0.0242263462216818f,
            -0.0470693355038282f,
            -0.0646924950968472f,
            -0.0736961923786210f,
            -0.0717020370815582f,
            -0.0578341452566130f,
            -0.0330130959038928f,
            +0.0000000000000000f,
            +0.0368391140966905f,
            +0.0720386199630128f,
            +0.0997571024321705f,
            +0.1146318336501513f,
            +0.1126498669833225f,
            +0.0919103958525938f,
            +0.0531592207269089f,
            -0.0000000000000000f,
            -0.0612740151515620f,
            -0.1222346296999213f,
            -0.1732132908002330f,
            -0.2044393546488325f,
            -0.2072866825349403f,
            -0.1754708142381755f,
            -0.1060371075574007f,
            +0.0000000000000000f,
            +0.1374669748593506f,
            +0.2973363346214353f,
            +0.4675104161556040f,
            +0.6340050064132841f,
            +0.7824005288007850f,
            +0.8993910009815614f,
            +0.9742449119954196f,
            +1.0000000000000000f,
            +0.9742449119954196f,
            +0.8993910009815614f,
            +0.7824005288007850f,
            +0.6340050064132841f,
            +0.4675104161556040f,
            +0.2973363346214353f,
            +0.1374669748593506f,
            +0.0000000000000000f,
            -0.1060371075574007f,
            -0.1754708142381755f,
            -0.2072866825349403f,
            -0.2044393546488325f,
            -0.1732132908002330f,
            -0.1222346296999213f,
            -0.0612740151515620f,
            -0.0000000000000000f,
            +0.0531592207269089f,
            +0.0919103958525938f,
            +0.1126498669833225f,
            +0.1146318336501513f,
            +0.0997571024321705f,
            +0.0720386199630128f,
            +0.0368391140966905f,
            +0.0000000000000000f,
            -0.0330130959038928f,
            -0.0578341452566130f,
            -0.0717020370815582f,
            -0.0736961923786210f,
            -0.0646924950968472f,
            -0.0470693355038282f,
            -0.0242263462216818f,
            -0.0000000000000000f,
            +0.0219317127529990f,
            +0.0385690473915008f,
            +0.0479659913901889f,
            +0.0494191366611535f,
            +0.0434581579360301f,
            +0.0316560836463846f,
            +0.0163025567500491f,
            +0.0000000000000000f,
            -0.0147508559291044f,
            -0.0259134834384236f,
            -0.0321764295372770f,
            -0.0330822319797804f,
            -0.0290164639273983f,
            -0.0210708028282491f,
            -0.0108119670384862f,
            -0.0000000000000000f,
            +0.0096965925527014f,
            +0.0169449607813781f,
            +0.0209174888029406f,
            +0.0213675350683576f,
            +0.0186083250382542f,
            +0.0134073670073630f,
            +0.0068208875834489f,
            +0.0000000000000000f,
            -0.0059981198390733f,
            -0.0103646528127521f,
            -0.0126380011986749f,
            -0.0127368704055724f,
            -0.0109289443646814f,
            -0.0077468699938191f,
            -0.0038707520257185f,
            -0.0000000000000000f,
            +0.0032631132329234f,
            +0.0054999971123013f,
            +0.0065210617387479f,
            +0.0063666235011747f,
            +0.0052681555527679f,
            +0.0035810370252689f,
            +0.0017038297385736f,
            +0.0000000000000000f,
            -0.0012640048354491f,
            -0.0019547311991183f,
            -0.0020778240718027f,
            -0.0017562465551615f,
            -0.0011876547072368f,
            -0.0005913155824994f,
            -0.0001561039756442f
        };

        static const float lanczos_8x24bit[] =
        {
            -0.0000000000000000f,
            -0.0000039770996537f,
            -0.0000147567119155f,
            -0.0000290373341106f,
            -0.0000420749334770f,
            -0.0000487854013733f,
            -0.0000449862367299f,
            -0.0000285179169694f,
            +0.0000000000000000f,
            +0.0000369597586956f,
            +0.0000761837168614f,
            +0.0001099292460259f,
            +0.0001303204007046f,
            +0.0001309524701029f,
            +0.0001083651853141f,
            +0.0000630851769187f,
            -0.0000000000000000f,
            -0.0000720639629717f,
            -0.0001415469719733f,
            -0.0001959853090600f,
            -0.0002241785497035f,
            -0.0002183263708531f,
            -0.0001757457190975f,
            -0.0000998270233215f,
            +0.0000000000000000f,
            +0.0001093607710363f,
            +0.0002109783977240f,
            +0.0002873787079209f,
            +0.0003238377357525f,
            +0.0003110819648176f,
            +0.0002472623250414f,
            +0.0001388165985106f,
            +0.0000000000000000f,
            -0.0001489240562328f,
            -0.0002846151827871f,
            -0.0003842895995516f,
            -0.0004294939585451f,
            -0.0004094012672939f,
            -0.0003230550367297f,
            -0.0001801300856682f,
            +0.0000000000000000f,
            +0.0001908308125301f,
            +0.0003626003573035f,
            +0.0004869058729495f,
            +0.0005413516964839f,
            +0.0005134742296001f,
            +0.0004032700414632f,
            +0.0002238470421285f,
            -0.0000000000000000f,
            -0.0002351614975279f,
            -0.0004450834358354f,
            -0.0005954240013756f,
            -0.0006596248424501f,
            -0.0006234996161254f,
            -0.0004880603612460f,
            -0.0002700507732642f,
            -0.0000000000000000f,
            +0.0002820004172618f,
            +0.0005322211387104f,
            +0.0007100499985178f,
            +0.0007845377537817f,
            +0.0007396859884835f,
            +0.0005775866169788f,
            +0.0003188287520842f,
            -0.0000000000000000f,
            -0.0003314361581177f,
            -0.0006241782017359f,
            -0.0008310004918782f,
            -0.0009163264310727f,
            -0.0008622528105055f,
            -0.0006720178865607f,
            -0.0003702730904370f,
            +0.0000000000000000f,
            +0.0003835620719592f,
            +0.0007211282857631f,
            +0.0009585039286475f,
            +0.0010552398426108f,
            +0.0009914316898865f,
            +0.0007715326692185f,
            +0.0004244810686071f,
            +0.0000000000000000f,
            -0.0004384768215016f,
            -0.0008232549993348f,
            -0.0010928019316727f,
            -0.0012015414138581f,
            -0.0011274677747423f,
            -0.0008763199702937f,
            -0.0004815557311452f,
            +0.0000000000000000f,
            +0.0004962849940677f,
            +0.0009307530497225f,
            +0.0012341508258881f,
            +0.0013555107044297f,
            +0.0012706213262069f,
            +0.0009865805229604f,
            +0.0005416065580172f,
            +0.0000000000000000f,
            -0.0005570977931518f,
            -0.0010438295401025f,
            -0.0013828233588366f,
            -0.0015174452986323f,
            -0.0014211694916081f,
            -0.0011025281660126f,
            -0.0006047502216251f,
            +0.0000000000000000f,
            +0.0006210338187555f,
            +0.0011627054335181f,
            +0.0015391106427800f,
            +0.0016876629399007f,
            +0.0015794083067907f,
            +0.0012243914000129f,
            +0.0006711114420003f,
            -0.0000000000000000f,
            -0.0006882199492817f,
            -0.0012876172077164f,
            -0.0017033243504912f,
            -0.0018665039445554f,
            -0.0017456549609664f,
            -0.0013524151478551f,
            -0.0007408239545491f,
            -0.0000000000000000f,
            +0.0007587923399459f,
            +0.0014188187290585f,
            +0.0018757992023117f,
            +0.0020543339363826f,
            +0.0019202503632015f,
            +0.0014868627502839f,
            +0.0008140316072165f,
            -0.0000000000000000f,
            -0.0008328975552673f,
            -0.0015565833786138f,
            -0.0020568957886255f,
            -0.0022515469508069f,
            -0.0021035620565358f,
            -0.0016280182322995f,
            -0.0008908896069154f,
            +0.0000000000000000f,
            +0.0009106938563208f,
            +0.0017012064694570f,
            +0.0022470037797969f,
            +0.0024585689661799f,
            +0.0022959875339953f,
            +0.0017761888828588f,
            +0.0009715659386609f,
            -0.0000000000000001f,
            -0.0009923526671994f,
            -0.0018530080013064f,
            -0.0024465455851487f,
            -0.0026758619302655f,
            -0.0024979580207526f,
            -0.0019317081981110f,
            -0.0010562429851876f,
            +0.0000000000000000f,
            +0.0010780602496877f,
            +0.0020123358072617f,
            +0.0026559805340943f,
            +0.0029039283627990f,
            +0.0027099427988033f,
            +0.0020949392479124f,
            +0.0011451193801000f,
            +0.0000000000000000f,
            -0.0011680196206821f,
            -0.0021795691578827f,
            -0.0028758096665737f,
            -0.0031433166305705f,
            -0.0029324541652760f,
            -0.0022662785369317f,
            -0.0012384121340250f,
            +0.0000000000000001f,
            +0.0012624527536460f,
            +0.0023551229006416f,
            +0.0031065812370899f,
            +0.0033946270105201f,
            +0.0031660531335322f,
            +0.0024461604458264f,
            +0.0013363590810996f,
            -0.0000000000000000f,
            -0.0013616031136656f,
            -0.0025394522284808f,
            -0.0033488970576844f,
            -0.0036585186797036f,
            -0.0034113560083765f,
            -0.0026350623553773f,
            -0.0014392217028029f,
            +0.0000000000000000f,
            +0.0014657385858665f,
            +0.0027330581905449f,
            +0.0036034198311382f,
            +0.0039357177998310f,
            +0.0036690419940613f,
            +0.0028335105779823f,
            +0.0015472883980918f,
            -0.0000000000000000f,
            -0.0015751548695692f,
            -0.0029364940821093f,
            -0.0038708816578383f,
            -0.0042270268998406f,
            -0.0039398620277247f,
            -0.0030420872476149f,
            -0.0016608782836630f,
            +0.0000000000000000f,
            +0.0016901794262582f,
            +0.0031503728805480f,
            +0.0041520939398092f,
            +0.0045333358045560f,
            +0.0042246490732542f,
            +0.0032614383526936f,
            +0.0017803456267168f,
            -0.0000000000000000f,
            -0.0018111760890766f,
            -0.0033753759315107f,
            -0.0044479589555886f,
            -0.0048556344133628f,
            -0.0045243301637083f,
            -0.0034922831381643f,
            -0.0019060850359130f,
            +0.0000000000000000f,
            +0.0019385504662642f,
            +0.0036122631364762f,
            +0.0047594834428527f,
            +0.0051950277033080f,
            +0.0048399405474726f,
            +0.0037354251559473f,
            +0.0020385375656755f,
            +0.0000000000000000f,
            -0.0020727563022226f,
            -0.0038618849523818f,
            -0.0050877946058421f,
            -0.0055527534204337f,
            -0.0051726403784593f,
            -0.0039917653100630f,
            -0.0021781979264651f,
            +0.0000000000000000f,
            +0.0022143029997257f,
            +0.0041251965899183f,
            +0.0054341590669081f,
            +0.0059302030373166f,
            +0.0055237344994569f,
            +0.0042623173286558f,
            +0.0023256230416137f,
            -0.0000000000000000f,
            -0.0023637645578684f,
            -0.0044032748944894f,
            -0.0058000054128573f,
            -0.0063289467015709f,
            -0.0058946960077472f,
            -0.0045482262057797f,
            -0.0024814422531458f,
            +0.0000000000000000f,
            +0.0025217902463128f,
            +0.0046973385197507f,
            +0.0061869511567527f,
            +0.0067507630901733f,
            +0.0062871944735996f,
            +0.0048507902993798f,
            +0.0026463695593291f,
            -0.0000000000000001f,
            -0.0026891174222361f,
            -0.0050087721676550f,
            -0.0065968351574369f,
            -0.0071976753325661f,
            -0.0067031299193634f,
            -0.0051714879596455f,
            -0.0028212183718253f,
            -0.0000000000000000f,
            +0.0028665870089768f,
            +0.0053391558842877f,
            +0.0070317568303424f,
            +0.0076719944919443f,
            +0.0071446739791833f,
            +0.0055120098094728f,
            +0.0030069194190918f,
            -0.0000000000000000f,
            -0.0030551623043341f,
            -0.0056903006859813f,
            -0.0074941238693437f,
            -0.0081763725274213f,
            -0.0076143200743655f,
            -0.0058742981280916f,
            -0.0032045426074979f,
            +0.0000000000000001f,
            +0.0032559519853052f,
            +0.0060642921713552f,
            +0.0079867107161549f,
            +0.0087138672402142f,
            +0.0081149449960173f,
            +0.0062605952311530f,
            +0.0034153239001203f,
            +0.0000000000000000f,
            -0.0034702384440481f,
            -0.0064635442893188f,
            -0.0085127307120105f,
            -0.0092880224923026f,
            -0.0086498850406143f,
            -0.0066735033404334f,
            -0.0036406986106808f,
            -0.0000000000000000f,
            +0.0036995129548151f,
            +0.0068908661345064f,
            +0.0090759258198000f,
            +0.0099029680598097f,
            +0.0092230308765761f,
            +0.0071160592588131f,
            +0.0038823429735100f,
            -0.0000000000000000f,
            -0.0039455196741451f,
            -0.0073495456088630f,
            -0.0096806791214772f,
            -0.0105635449684010f,
            -0.0098389467498901f,
            -0.0075918283070690f,
            -0.0041422264941880f,
            +0.0000000000000001f,
            +0.0042103111768610f,
            +0.0078434551379900f,
            +0.0103321571359591f,
            +0.0112754642370518f,
            +0.0105030216419477f,
            +0.0081050235813941f,
            +0.0044226784911654f,
            -0.0000000000000001f,
            -0.0044963192187948f,
            -0.0083771865393404f,
            -0.0110364916090844f,
            -0.0120455099059071f,
            -0.0112216628421606f,
            -0.0086606588715772f,
            -0.0047264735301500f,
            -0.0000000000000000f,
            +0.0048064458316540f,
            +0.0089562248755940f,
            +0.0118010141708654f,
            +0.0128818014681738f,
            +0.0120025465059540f,
            +0.0092647468745907f,
            +0.0050569423220959f,
            -0.0000000000000000f,
            -0.0051441819104697f,
            -0.0095871751096981f,
            -0.0126345627157805f,
            -0.0137941370290747f,
            -0.0128549457850164f,
            -0.0099245591735771f,
            -0.0054181174042251f,
            +0.0000000000000001f,
            +0.0055137634889678f,
            +0.0102780612731136f,
            +0.0135478864610063f,
            +0.0147944477357047f,
            +0.0137901660797210f,
            +0.0106489716719846f,
            +0.0058149270369384f,
            -0.0000000000000000f,
            -0.0059203804611763f,
            -0.0110387267429244f,
            -0.0145541888723789f,
            -0.0158974079845805f,
            -0.0148221305693976f,
            -0.0114489301591833f,
            -0.0062534570246940f,
            -0.0000000000000000f,
            +0.0063704595041331f,
            +0.0118813778811240f,
            +0.0156698665061717f,
            +0.0171212674927752f,
            +0.0159681802598703f,
            +0.0123380877553603f,
            +0.0067413099466018f,
            -0.0000000000000000f,
            -0.0068720539196602f,
            -0.0128213347514400f,
            -0.0169155315354508f,
            -0.0184890054274438f,
            -0.0172501862131289f,
            -0.0133336931299240f,
            -0.0072881068782799f,
            +0.0000000000000001f,
            +0.0074353907094207f,
            +0.0138780871865938f,
            +0.0183174537400962f,
            +0.0200299620685047f,
            +0.0186961259766840f,
            +0.0144578526791940f,
            +0.0079062022194515f,
            -0.0000000000000000f,
            -0.0080736542074907f,
            -0.0150768116558942f,
            -0.0199096374631547f,
            -0.0217821956125176f,
            -0.0203423671566172f,
            -0.0157393642255338f,
            -0.0086117252830080f,
            -0.0000000000000000f,
            +0.0088041348835687f,
            +0.0164506019203318f,
            +0.0217368855924073f,
            +0.0237959701950330f,
            +0.0222370581331378f,
            +0.0172164488203245f,
            +0.0094261372906327f,
            -0.0000000000000000f,
            -0.0096499585745955f,
            -0.0180438387089742f,
            -0.0238594449032186f,
            -0.0261390636973287f,
            -0.0244453072353932f,
            -0.0189409394696360f,
            -0.0103786280750320f,
            +0.0000000000000001f,
            +0.0106427697531638f,
            +0.0199174401036205f,
            +0.0263602745989258f,
            +0.0289051085252159f,
            +0.0270573570450684f,
            +0.0209849217528235f,
            +0.0115099330259287f,
            -0.0000000000000000f,
            -0.0118270451112030f,
            -0.0221573428824029f,
            -0.0293568458269806f,
            -0.0322272001794569f,
            -0.0302019901897608f,
            -0.0234516818191808f,
            -0.0128786597811202f,
            +0.0000000000000000f,
            +0.0132673233406443f,
            +0.0248887995880585f,
            +0.0330211494826002f,
            +0.0363011117970633f,
            +0.0340695392126893f,
            +0.0264946165061903f,
            +0.0145722869036940f,
            -0.0000000000000000f,
            -0.0150609432853387f,
            -0.0283017442319639f,
            -0.0376154477750067f,
            -0.0414270802341371f,
            -0.0389536162501979f,
            -0.0303517931435070f,
            -0.0167274245660520f,
            +0.0000000000000000f,
            +0.0173618989868388f,
            +0.0326987052175801f,
            +0.0435604044731212f,
            +0.0480901638096349f,
            +0.0453321175979988f,
            +0.0354136866890553f,
            +0.0195699223904852f,
            -0.0000000000000000f,
            -0.0204290572839039f,
            -0.0385927142704622f,
            -0.0515758872962452f,
            -0.0571282629124219f,
            -0.0540386518561891f,
            -0.0423683306382987f,
            -0.0235019327567229f,
            +0.0000000000000000f,
            +0.0247337200931706f,
            +0.0469288896984498f,
            +0.0630044327207856f,
            +0.0701241679229563f,
            +0.0666690693765764f,
            +0.0525513867429064f,
            +0.0293156115799510f,
            -0.0000000000000000f,
            -0.0312337346648938f,
            -0.0596605527296562f,
            -0.0806701006243709f,
            -0.0904696890758395f,
            -0.0867107105253742f,
            -0.0689424971260680f,
            -0.0388171244919284f,
            +0.0000000000000000f,
            +0.0422196599256981f,
            +0.0815823247602074f,
            +0.1117004249971272f,
            +0.1269836976940222f,
            +0.1235244913715169f,
            +0.0998185751368425f,
            +0.0572125526926876f,
            -0.0000000000000000f,
            -0.0648686649648295f,
            -0.1284481291475161f,
            -0.1807678745434562f,
            -0.2120023318573107f,
            -0.2137033627805775f,
            -0.1799428918780322f,
            -0.1082186297540542f,
            +0.0000000000000000f,
            +0.1391680168090083f,
            +0.3000332066346169f,
            +0.4704493339386021f,
            +0.6365516685731774f,
            +0.7841661131376281f,
            +0.9002922372500939f,
            +0.9744888426599380f,
            +1.0000000000000000f,
            +0.9744888426599380f,
            +0.9002922372500939f,
            +0.7841661131376281f,
            +0.6365516685731774f,
            +0.4704493339386021f,
            +0.3000332066346169f,
            +0.1391680168090083f,
            +0.0000000000000000f,
            -0.1082186297540542f,
            -0.1799428918780322f,
            -0.2137033627805775f,
            -0.2120023318573107f,
            -0.1807678745434562f,
            -0.1284481291475161f,
            -0.0648686649648295f,
            -0.0000000000000000f,
            +0.0572125526926876f,
            +0.0998185751368425f,
            +0.1235244913715169f,
            +0.1269836976940222f,
            +0.1117004249971272f,
            +0.0815823247602074f,
            +0.0422196599256981f,
            +0.0000000000000000f,
            -0.0388171244919284f,
            -0.0689424971260680f,
            -0.0867107105253742f,
            -0.0904696890758395f,
            -0.0806701006243709f,
            -0.0596605527296562f,
            -0.0312337346648938f,
            -0.0000000000000000f,
            +0.0293156115799510f,
            +0.0525513867429064f,
            +0.0666690693765764f,
            +0.0701241679229563f,
            +0.0630044327207856f,
            +0.0469288896984498f,
            +0.0247337200931706f,
            +0.0000000000000000f,
            -0.0235019327567229f,
            -0.0423683306382987f,
            -0.0540386518561891f,
            -0.0571282629124219f,
            -0.0515758872962452f,
            -0.0385927142704622f,
            -0.0204290572839039f,
            -0.0000000000000000f,
            +0.0195699223904852f,
            +0.0354136866890553f,
            +0.0453321175979988f,
            +0.0480901638096349f,
            +0.0435604044731212f,
            +0.0326987052175801f,
            +0.0173618989868388f,
            +0.0000000000000000f,
            -0.0167274245660520f,
            -0.0303517931435070f,
            -0.0389536162501979f,
            -0.0414270802341371f,
            -0.0376154477750067f,
            -0.0283017442319639f,
            -0.0150609432853387f,
            -0.0000000000000000f,
            +0.0145722869036940f,
            +0.0264946165061903f,
            +0.0340695392126893f,
            +0.0363011117970633f,
            +0.0330211494826002f,
            +0.0248887995880585f,
            +0.0132673233406443f,
            +0.0000000000000000f,
            -0.0128786597811202f,
            -0.0234516818191808f,
            -0.0302019901897608f,
            -0.0322272001794569f,
            -0.0293568458269806f,
            -0.0221573428824029f,
            -0.0118270451112030f,
            -0.0000000000000000f,
            +0.0115099330259287f,
            +0.0209849217528235f,
            +0.0270573570450684f,
            +0.0289051085252159f,
            +0.0263602745989258f,
            +0.0199174401036205f,
            +0.0106427697531638f,
            +0.0000000000000001f,
            -0.0103786280750320f,
            -0.0189409394696360f,
            -0.0244453072353932f,
            -0.0261390636973287f,
            -0.0238594449032186f,
            -0.0180438387089742f,
            -0.0096499585745955f,
            -0.0000000000000000f,
            +0.0094261372906327f,
            +0.0172164488203245f,
            +0.0222370581331378f,
            +0.0237959701950330f,
            +0.0217368855924073f,
            +0.0164506019203318f,
            +0.0088041348835687f,
            -0.0000000000000000f,
            -0.0086117252830080f,
            -0.0157393642255338f,
            -0.0203423671566172f,
            -0.0217821956125176f,
            -0.0199096374631547f,
            -0.0150768116558942f,
            -0.0080736542074907f,
            -0.0000000000000000f,
            +0.0079062022194515f,
            +0.0144578526791940f,
            +0.0186961259766840f,
            +0.0200299620685047f,
            +0.0183174537400962f,
            +0.0138780871865938f,
            +0.0074353907094207f,
            +0.0000000000000001f,
            -0.0072881068782799f,
            -0.0133336931299240f,
            -0.0172501862131289f,
            -0.0184890054274438f,
            -0.0169155315354508f,
            -0.0128213347514400f,
            -0.0068720539196602f,
            -0.0000000000000000f,
            +0.0067413099466018f,
            +0.0123380877553603f,
            +0.0159681802598703f,
            +0.0171212674927752f,
            +0.0156698665061717f,
            +0.0118813778811240f,
            +0.0063704595041331f,
            -0.0000000000000000f,
            -0.0062534570246940f,
            -0.0114489301591833f,
            -0.0148221305693976f,
            -0.0158974079845805f,
            -0.0145541888723789f,
            -0.0110387267429244f,
            -0.0059203804611763f,
            -0.0000000000000000f,
            +0.0058149270369384f,
            +0.0106489716719846f,
            +0.0137901660797210f,
            +0.0147944477357047f,
            +0.0135478864610063f,
            +0.0102780612731136f,
            +0.0055137634889678f,
            +0.0000000000000001f,
            -0.0054181174042251f,
            -0.0099245591735771f,
            -0.0128549457850164f,
            -0.0137941370290747f,
            -0.0126345627157805f,
            -0.0095871751096981f,
            -0.0051441819104697f,
            -0.0000000000000000f,
            +0.0050569423220959f,
            +0.0092647468745907f,
            +0.0120025465059540f,
            +0.0128818014681738f,
            +0.0118010141708654f,
            +0.0089562248755940f,
            +0.0048064458316540f,
            -0.0000000000000000f,
            -0.0047264735301500f,
            -0.0086606588715772f,
            -0.0112216628421606f,
            -0.0120455099059071f,
            -0.0110364916090844f,
            -0.0083771865393404f,
            -0.0044963192187948f,
            -0.0000000000000001f,
            +0.0044226784911654f,
            +0.0081050235813941f,
            +0.0105030216419477f,
            +0.0112754642370518f,
            +0.0103321571359591f,
            +0.0078434551379900f,
            +0.0042103111768610f,
            +0.0000000000000001f,
            -0.0041422264941880f,
            -0.0075918283070690f,
            -0.0098389467498901f,
            -0.0105635449684010f,
            -0.0096806791214772f,
            -0.0073495456088630f,
            -0.0039455196741451f,
            -0.0000000000000000f,
            +0.0038823429735100f,
            +0.0071160592588131f,
            +0.0092230308765761f,
            +0.0099029680598097f,
            +0.0090759258198000f,
            +0.0068908661345064f,
            +0.0036995129548151f,
            -0.0000000000000000f,
            -0.0036406986106808f,
            -0.0066735033404334f,
            -0.0086498850406143f,
            -0.0092880224923026f,
            -0.0085127307120105f,
            -0.0064635442893188f,
            -0.0034702384440481f,
            +0.0000000000000000f,
            +0.0034153239001203f,
            +0.0062605952311530f,
            +0.0081149449960173f,
            +0.0087138672402142f,
            +0.0079867107161549f,
            +0.0060642921713552f,
            +0.0032559519853052f,
            +0.0000000000000001f,
            -0.0032045426074979f,
            -0.0058742981280916f,
            -0.0076143200743655f,
            -0.0081763725274213f,
            -0.0074941238693437f,
            -0.0056903006859813f,
            -0.0030551623043341f,
            -0.0000000000000000f,
            +0.0030069194190918f,
            +0.0055120098094728f,
            +0.0071446739791833f,
            +0.0076719944919443f,
            +0.0070317568303424f,
            +0.0053391558842877f,
            +0.0028665870089768f,
            -0.0000000000000000f,
            -0.0028212183718253f,
            -0.0051714879596455f,
            -0.0067031299193634f,
            -0.0071976753325661f,
            -0.0065968351574369f,
            -0.0050087721676550f,
            -0.0026891174222361f,
            -0.0000000000000001f,
            +0.0026463695593291f,
            +0.0048507902993798f,
            +0.0062871944735996f,
            +0.0067507630901733f,
            +0.0061869511567527f,
            +0.0046973385197507f,
            +0.0025217902463128f,
            +0.0000000000000000f,
            -0.0024814422531458f,
            -0.0045482262057797f,
            -0.0058946960077472f,
            -0.0063289467015709f,
            -0.0058000054128573f,
            -0.0044032748944894f,
            -0.0023637645578684f,
            -0.0000000000000000f,
            +0.0023256230416137f,
            +0.0042623173286558f,
            +0.0055237344994569f,
            +0.0059302030373166f,
            +0.0054341590669081f,
            +0.0041251965899183f,
            +0.0022143029997257f,
            +0.0000000000000000f,
            -0.0021781979264651f,
            -0.0039917653100630f,
            -0.0051726403784593f,
            -0.0055527534204337f,
            -0.0050877946058421f,
            -0.0038618849523818f,
            -0.0020727563022226f,
            +0.0000000000000000f,
            +0.0020385375656755f,
            +0.0037354251559473f,
            +0.0048399405474726f,
            +0.0051950277033080f,
            +0.0047594834428527f,
            +0.0036122631364762f,
            +0.0019385504662642f,
            +0.0000000000000000f,
            -0.0019060850359130f,
            -0.0034922831381643f,
            -0.0045243301637083f,
            -0.0048556344133628f,
            -0.0044479589555886f,
            -0.0033753759315107f,
            -0.0018111760890766f,
            -0.0000000000000000f,
            +0.0017803456267168f,
            +0.0032614383526936f,
            +0.0042246490732542f,
            +0.0045333358045560f,
            +0.0041520939398092f,
            +0.0031503728805480f,
            +0.0016901794262582f,
            +0.0000000000000000f,
            -0.0016608782836630f,
            -0.0030420872476149f,
            -0.0039398620277247f,
            -0.0042270268998406f,
            -0.0038708816578383f,
            -0.0029364940821093f,
            -0.0015751548695692f,
            -0.0000000000000000f,
            +0.0015472883980918f,
            +0.0028335105779823f,
            +0.0036690419940613f,
            +0.0039357177998310f,
            +0.0036034198311382f,
            +0.0027330581905449f,
            +0.0014657385858665f,
            +0.0000000000000000f,
            -0.0014392217028029f,
            -0.0026350623553773f,
            -0.0034113560083765f,
            -0.0036585186797036f,
            -0.0033488970576844f,
            -0.0025394522284808f,
            -0.0013616031136656f,
            -0.0000000000000000f,
            +0.0013363590810996f,
            +0.0024461604458264f,
            +0.0031660531335322f,
            +0.0033946270105201f,
            +0.0031065812370899f,
            +0.0023551229006416f,
            +0.0012624527536460f,
            +0.0000000000000001f,
            -0.0012384121340250f,
            -0.0022662785369317f,
            -0.0029324541652760f,
            -0.0031433166305705f,
            -0.0028758096665737f,
            -0.0021795691578827f,
            -0.0011680196206821f,
            +0.0000000000000000f,
            +0.0011451193801000f,
            +0.0020949392479124f,
            +0.0027099427988033f,
            +0.0029039283627990f,
            +0.0026559805340943f,
            +0.0020123358072617f,
            +0.0010780602496877f,
            +0.0000000000000000f,
            -0.0010562429851876f,
            -0.0019317081981110f,
            -0.0024979580207526f,
            -0.0026758619302655f,
            -0.0024465455851487f,
            -0.0018530080013064f,
            -0.0009923526671994f,
            -0.0000000000000001f,
            +0.0009715659386609f,
            +0.0017761888828588f,
            +0.0022959875339953f,
            +0.0024585689661799f,
            +0.0022470037797969f,
            +0.0017012064694570f,
            +0.0009106938563208f,
            +0.0000000000000000f,
            -0.0008908896069154f,
            -0.0016280182322995f,
            -0.0021035620565358f,
            -0.0022515469508069f,
            -0.0020568957886255f,
            -0.0015565833786138f,
            -0.0008328975552673f,
            -0.0000000000000000f,
            +0.0008140316072165f,
            +0.0014868627502839f,
            +0.0019202503632015f,
            +0.0020543339363826f,
            +0.0018757992023117f,
            +0.0014188187290585f,
            +0.0007587923399459f,
            -0.0000000000000000f,
            -0.0007408239545491f,
            -0.0013524151478551f,
            -0.0017456549609664f,
            -0.0018665039445554f,
            -0.0017033243504912f,
            -0.0012876172077164f,
            -0.0006882199492817f,
            -0.0000000000000000f,
            +0.0006711114420003f,
            +0.0012243914000129f,
            +0.0015794083067907f,
            +0.0016876629399007f,
            +0.0015391106427800f,
            +0.0011627054335181f,
            +0.0006210338187555f,
            +0.0000000000000000f,
            -0.0006047502216251f,
            -0.0011025281660126f,
            -0.0014211694916081f,
            -0.0015174452986323f,
            -0.0013828233588366f,
            -0.0010438295401025f,
            -0.0005570977931518f,
            +0.0000000000000000f,
            +0.0005416065580172f,
            +0.0009865805229604f,
            +0.0012706213262069f,
            +0.0013555107044297f,
            +0.0012341508258881f,
            +0.0009307530497225f,
            +0.0004962849940677f,
            +0.0000000000000000f,
            -0.0004815557311452f,
            -0.0008763199702937f,
            -0.0011274677747423f,
            -0.0012015414138581f,
            -0.0010928019316727f,
            -0.0008232549993348f,
            -0.0004384768215016f,
            +0.0000000000000000f,
            +0.0004244810686071f,
            +0.0007715326692185f,
            +0.0009914316898865f,
            +0.0010552398426108f,
            +0.0009585039286475f,
            +0.0007211282857631f,
            +0.0003835620719592f,
            +0.0000000000000000f,
            -0.0003702730904370f,
            -0.0006720178865607f,
            -0.0008622528105055f,
            -0.0009163264310727f,
            -0.0008310004918782f,
            -0.0006241782017359f,
            -0.0003314361581177f,
            -0.0000000000000000f,
            +0.0003188287520842f,
            +0.0005775866169788f,
            +0.0007396859884835f,
            +0.0007845377537817f,
            +0.0007100499985178f,
            +0.0005322211387104f,
            +0.0002820004172618f,
            -0.0000000000000000f,
            -0.0002700507732642f,
            -0.0004880603612460f,
            -0.0006234996161254f,
            -0.0006596248424501f,
            -0.0005954240013756f,
            -0.0004450834358354f,
            -0.0002351614975279f,
            -0.0000000000000000f,
            +0.0002238470421285f,
            +0.0004032700414632f,
            +0.0005134742296001f,
            +0.0005413516964839f,
            +0.0004869058729495f,
            +0.0003626003573035f,
            +0.0001908308125301f,
            +0.0000000000000000f,
            -0.0001801300856682f,
            -0.0003230550367297f,
            -0.0004094012672939f,
            -0.0004294939585451f,
            -0.0003842895995516f,
            -0.0002846151827871f,
            -0.0001489240562328f,
            +0.0000000000000000f,
            +0.0001388165985106f,
            +0.0002472623250414f,
            +0.0003110819648176f,
            +0.0003238377357525f,
            +0.0002873787079209f,
            +0.0002109783977240f,
            +0.0001093607710363f,
            +0.0000000000000000f,
            -0.0000998270233215f,
            -0.0001757457190975f,
            -0.0002183263708531f,
            -0.0002241785497035f,
            -0.0001959853090600f,
            -0.0001415469719733f,
            -0.0000720639629717f,
            -0.0000000000000000f,
            +0.0000630851769187f,
            +0.0001083651853141f,
            +0.0001309524701029f,
            +0.0001303204007046f,
            +0.0001099292460259f,
            +0.0000761837168614f,
            +0.0000369597586956f,
            +0.0000000000000000f,
            -0.0000285179169694f,
            -0.0000449862367299f,
            -0.0000487854013733f,
            -0.0000420749334770f,
            -0.0000290373341106f,
            -0.0000147567119155f,
            -0.0000039770996537f
        };

        void lanczos_resample_2x2(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                float s     = *(src++);

                // Apply Lanczos 2x2 kernel
                dst[1]     -= 0.0636843520278618f * s;
                dst[3]     += 0.5731591682507563f * s;
                dst[4]     += s;
                dst[5]     += 0.5731591682507563f * s;
                dst[7]     -= 0.0636843520278618f * s;

                // Move destination buffer
                dst        += 2;
            }
        }

        void lanczos_resample_2x3(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                float s     = *(src++);

                // Apply Lanczos 2x3 kernel
                dst[1]     += 0.0243170840741611f * s;
                dst[3]     -= 0.1350949115231170f * s;
                dst[5]     += 0.6079271018540265f * s;
                dst[6]     += s;
                dst[7]     += 0.6079271018540265f * s;
                dst[9]     -= 0.1350949115231170f * s;
                dst[11]    += 0.0243170840741611f * s;

                // Move destination buffer
                dst        += 2;
            }
        }

        void lanczos_resample_2x4(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                float s     = *(src++);

                // Apply Lanczos 2x3 kernel
                dst[1]     -= 0.0126608778212387f * s;
                dst[3]     += 0.0599094833772629f * s;
                dst[5]     -= 0.1664152316035080f * s;
                dst[7]     += 0.6203830132406946f * s;
                dst[8]     += 1.0000000000000000f * s;
                dst[9]     += 0.6203830132406946f * s;
                dst[11]    -= 0.1664152316035080f * s;
                dst[13]    += 0.0599094833772629f * s;
                dst[15]    -= 0.0126608778212387f * s;

                // Move destination buffer
                dst        += 2;
            }
        }

        void lanczos_resample_2x16bit(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                dsp::fmadd_k3(dst, lanczos_2x16bit, *(src++), sizeof(lanczos_2x16bit)/sizeof(float));
                dst        += 2;
            }
        }

        void lanczos_resample_2x24bit(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                dsp::fmadd_k3(dst, lanczos_2x24bit, *(src++), sizeof(lanczos_2x24bit)/sizeof(float));
                dst        += 2;
            }
        }

        void lanczos_resample_3x2(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                float s     = *(src++);

                // Apply Lanczos 3x2 kernel
                dst[1]     -= 0.0315888188312782f * s;
                dst[2]     -= 0.0854897486982225f * s;
                dst[4]     += 0.3419589947928900f * s;
                dst[5]     += 0.7897204707819555f * s;
                dst[6]     += s;
                dst[7]     += 0.7897204707819555f * s;
                dst[8]     += 0.3419589947928900f * s;
                dst[10]    -= 0.0854897486982225f * s;
                dst[11]    -= 0.0315888188312782f * s;

                // Move destination buffer
                dst        += 3;
            }
        }

        void lanczos_resample_3x3(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                float s     = *(src++);

                // Apply Lanczos 3x3 kernel
                dst[1]     += 0.0126609519658153f * s;
                dst[2]     += 0.0310789306368038f * s;
                dst[4]     -= 0.0933267410806225f * s;
                dst[5]     -= 0.1458230329384726f * s;
                dst[7]     += 0.3807169003008463f * s;
                dst[8]     += 0.8103009258121772f * s;
                dst[9]     += s;
                dst[10]    += 0.8103009258121772f * s;
                dst[11]    += 0.3807169003008463f * s;
                dst[13]    -= 0.1458230329384726f * s;
                dst[14]    -= 0.0933267410806225f * s;
                dst[16]    += 0.0310789306368038f * s;
                dst[17]    += 0.0126609519658153f * s;

                // Move destination buffer
                dst        += 3;
            }
        }

        void lanczos_resample_3x4(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                float s     = *(src++);

                // Apply Lanczos 3x3 kernel
                dst[1]     -= 0.0067568495254777f * s;
                dst[2]     -= 0.0157944094156391f * s;
                dst[4]     += 0.0427448743491113f * s;
                dst[5]     += 0.0622703182267308f * s;
                dst[7]     -= 0.1220498237243924f * s;
                dst[8]     -= 0.1709794973964449f * s;
                dst[10]    += 0.3948602353909778f * s;
                dst[11]    += 0.8175787925827955f * s;
                dst[12]    += 1.0000000000000000f * s;
                dst[13]    += 0.8175787925827955f * s;
                dst[14]    += 0.3948602353909778f * s;
                dst[16]    -= 0.1709794973964449f * s;
                dst[17]    -= 0.1220498237243924f * s;
                dst[19]    += 0.0622703182267308f * s;
                dst[20]    += 0.0427448743491113f * s;
                dst[22]    -= 0.0157944094156391f * s;
                dst[23]    -= 0.0067568495254777f * s;

                // Move destination buffer
                dst        += 3;
            }
        }

        void lanczos_resample_3x16bit(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                dsp::fmadd_k3(dst, lanczos_3x16bit, *(src++), sizeof(lanczos_3x16bit)/sizeof(float));
                dst        += 3;
            }
        }

        void lanczos_resample_3x24bit(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                dsp::fmadd_k3(dst, lanczos_3x24bit, *(src++), sizeof(lanczos_3x24bit)/sizeof(float));
                dst        += 3;
            }
        }

        void lanczos_resample_4x2(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                float s     = *(src++);

                // Apply Lanczos 4x2 kernel
                dst[1]     -= 0.0179051851263444f * s;
                dst[2]     -= 0.0636843520278618f * s;
                dst[3]     -= 0.0847248039068907f * s;
                dst[5]     += 0.2353466775191407f * s;
                dst[6]     += 0.5731591682507563f * s;
                dst[7]     += 0.8773540711908775f * s;
                dst[8]     += s;
                dst[9]     += 0.8773540711908775f * s;
                dst[10]    += 0.5731591682507563f * s;
                dst[11]    += 0.2353466775191407f * s;
                dst[13]    -= 0.0847248039068907f * s;
                dst[14]    -= 0.0636843520278618f * s;
                dst[15]    -= 0.0179051851263444f * s;

                // Move destination buffer
                dst        += 4;
            }
        }

        void lanczos_resample_4x3(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                float s     = *(src++);

                // Apply Lanczos 4x3 kernel
                dst[1]     += 0.0073559260471942f * s;
                dst[2]     += 0.0243170840741611f * s;
                dst[3]     += 0.0300210914495816f * s;
                dst[5]     -= 0.0677913359005429f * s;
                dst[6]     -= 0.1350949115231170f * s;
                dst[7]     -= 0.1328710183650640f * s;
                dst[9]     += 0.2701898230462341f * s;
                dst[10]    += 0.6079271018540265f * s;
                dst[11]    += 0.8900670517104946f * s;
                dst[12]    += s;
                dst[13]    += 0.8900670517104946f * s;
                dst[14]    += 0.6079271018540265f * s;
                dst[15]    += 0.2701898230462341f * s;
                dst[17]    -= 0.1328710183650640f * s;
                dst[18]    -= 0.1350949115231170f * s;
                dst[19]    -= 0.0677913359005429f * s;
                dst[21]    += 0.0300210914495816f * s;
                dst[22]    += 0.0243170840741611f * s;
                dst[23]    += 0.0073559260471942f * s;

                // Move destination buffer
                dst        += 4;
            }
        }

        void lanczos_resample_4x4(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                float s     = *(src++);

                // Apply Lanczos 4x3 kernel
                dst[1]     -= 0.0039757442382413f * s;
                dst[2]     -= 0.0126608778212387f * s;
                dst[3]     -= 0.0150736176408234f * s;

                dst[5]     += 0.0315083921595442f * s;
                dst[6]     += 0.0599094833772629f * s;
                dst[7]     += 0.0555206000541729f * s;

                dst[9]     -= 0.0917789511099593f * s;
                dst[10]    -= 0.1664152316035080f * s;
                dst[11]    -= 0.1525006180521938f * s;

                dst[13]    += 0.2830490423665725f * s;
                dst[14]    += 0.6203830132406946f * s;
                dst[15]    += 0.8945424536042901f * s;

                dst[16]    += 1.0000000000000000f * s;

                dst[17]    += 0.8945424536042901f * s;
                dst[18]    += 0.6203830132406946f * s;
                dst[19]    += 0.2830490423665725f * s;

                dst[21]    -= 0.1525006180521938f * s;
                dst[22]    -= 0.1664152316035080f * s;
                dst[23]    -= 0.0917789511099593f * s;

                dst[25]    += 0.0555206000541729f * s;
                dst[26]    += 0.0599094833772629f * s;
                dst[27]    += 0.0315083921595442f * s;

                dst[29]    -= 0.0150736176408234f * s;
                dst[30]    -= 0.0126608778212387f * s;
                dst[31]    -= 0.0039757442382413f * s;

                // Move destination buffer
                dst        += 4;
            }
        }

        void lanczos_resample_4x16bit(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                dsp::fmadd_k3(dst, lanczos_4x16bit, *(src++), sizeof(lanczos_4x16bit)/sizeof(float));
                dst        += 4;
            }
        }

        void lanczos_resample_4x24bit(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                dsp::fmadd_k3(dst, lanczos_4x24bit, *(src++), sizeof(lanczos_4x24bit)/sizeof(float));
                dst        += 4;
            }
        }

        void lanczos_resample_6x2(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                float s     = *(src++);

                // Apply Lanczos 6x2 kernel
                dst[1]     -= 0.0078021377848166f * s;
                dst[2]     -= 0.0315888188312782f * s;
                dst[3]     -= 0.0636843520278618f * s;
                dst[4]     -= 0.0854897486982225f * s;
                dst[5]     -= 0.0719035699814534f * s;

                dst[7]     += 0.1409309971636486f * s;
                dst[8]     += 0.3419589947928900f * s;
                dst[9]     += 0.5731591682507563f * s;
                dst[10]    += 0.7897204707819555f * s;
                dst[11]    += 0.9440586719628122f * s;

                dst[12]    += s;

                dst[13]    += 0.9440586719628122f * s;
                dst[14]    += 0.7897204707819555f * s;
                dst[15]    += 0.5731591682507563f * s;
                dst[16]    += 0.3419589947928900f * s;
                dst[17]    += 0.1409309971636486f * s;

                dst[19]    -= 0.0719035699814534f * s;
                dst[20]    -= 0.0854897486982225f * s;
                dst[21]    -= 0.0636843520278618f * s;
                dst[22]    -= 0.0315888188312782f * s;
                dst[23]    -= 0.0078021377848166f * s;

                // Move destination buffer
                dst        += 6;
            }
        }

        void lanczos_resample_6x3(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                float s     = *(src++);

                // Apply Lanczos 6x3 kernel
                dst[1]     += 0.0032875048460955f * s;
                dst[2]     += 0.0126609519658153f * s;
                dst[3]     += 0.0243170840741611f * s;
                dst[4]     += 0.0310789306368038f * s;
                dst[5]     += 0.0248005479513036f * s;

                dst[7]     -= 0.0424907562338176f * s;
                dst[8]     -= 0.0933267410806225f * s;
                dst[9]     -= 0.1350949115231170f * s;
                dst[10]    -= 0.1458230329384726f * s;
                dst[11]    -= 0.1049261531488149f * s;

                dst[13]    += 0.1676517041508127f * s;
                dst[14]    += 0.3807169003008463f * s;
                dst[15]    += 0.6079271018540265f * s;
                dst[16]    += 0.8103009258121772f * s;
                dst[17]    += 0.9500889005216107f * s;

                dst[18]    += s;

                dst[19]    += 0.9500889005216107f * s;
                dst[20]    += 0.8103009258121772f * s;
                dst[21]    += 0.6079271018540265f * s;
                dst[22]    += 0.3807169003008463f * s;
                dst[23]    += 0.1676517041508127f * s;

                dst[25]    -= 0.1049261531488149f * s;
                dst[26]    -= 0.1458230329384726f * s;
                dst[27]    -= 0.1350949115231170f * s;
                dst[28]    -= 0.0933267410806225f * s;
                dst[29]    -= 0.0424907562338176f * s;

                dst[31]    += 0.0248005479513036f * s;
                dst[32]    += 0.0310789306368038f * s;
                dst[33]    += 0.0243170840741611f * s;
                dst[34]    += 0.0126609519658153f * s;
                dst[35]    += 0.0032875048460955f * s;

                // Move destination buffer
                dst        += 6;
            }
        }

        void lanczos_resample_6x4(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                float s     = *(src++);

                // Apply Lanczos 6x3 kernel
                dst[1]     -= 0.0018000092949500f * s;
                dst[2]     -= 0.0067568495254777f * s;
                dst[3]     -= 0.0126608778212387f * s;
                dst[4]     -= 0.0157944094156391f * s;
                dst[5]     -= 0.0123019137260206f * s;

                dst[7]     += 0.0200263389720192f * s;
                dst[8]     += 0.0427448743491113f * s;
                dst[9]     += 0.0599094833772629f * s;
                dst[10]    += 0.0622703182267308f * s;
                dst[11]    += 0.0427971267140625f * s;

                dst[13]    -= 0.0597744992948478f * s;
                dst[14]    -= 0.1220498237243924f * s;
                dst[15]    -= 0.1664152316035080f * s;
                dst[16]    -= 0.1709794973964449f * s;
                dst[17]    -= 0.1181145298553785f * s;

                dst[19]    += 0.1776396342037379f * s;
                dst[20]    += 0.3948602353909778f * s;
                dst[21]    += 0.6203830132406946f * s;
                dst[22]    += 0.8175787925827955f * s;
                dst[23]    += 0.9522049170285306f * s;

                dst[24]    += 1.0000000000000000f * s;

                dst[25]    += 0.9522049170285306f * s;
                dst[26]    += 0.8175787925827955f * s;
                dst[27]    += 0.6203830132406946f * s;
                dst[28]    += 0.3948602353909778f * s;
                dst[29]    += 0.1776396342037379f * s;

                dst[31]    -= 0.1181145298553785f * s;
                dst[32]    -= 0.1709794973964449f * s;
                dst[33]    -= 0.1664152316035080f * s;
                dst[34]    -= 0.1220498237243924f * s;
                dst[35]    -= 0.0597744992948478f * s;

                dst[37]    += 0.0427971267140625f * s;
                dst[38]    += 0.0622703182267308f * s;
                dst[39]    += 0.0599094833772629f * s;
                dst[40]    += 0.0427448743491113f * s;
                dst[41]    += 0.0200263389720192f * s;

                dst[43]    -= 0.0123019137260206f * s;
                dst[44]    -= 0.0157944094156391f * s;
                dst[45]    -= 0.0126608778212387f * s;
                dst[46]    -= 0.0067568495254777f * s;
                dst[47]    -= 0.0018000092949500f * s;

                // Move destination buffer
                dst        += 6;
            }
        }

        void lanczos_resample_6x16bit(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                dsp::fmadd_k3(dst, lanczos_6x16bit, *(src++), sizeof(lanczos_6x16bit)/sizeof(float));
                dst        += 6;
            }
        }

        void lanczos_resample_6x24bit(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                dsp::fmadd_k3(dst, lanczos_6x24bit, *(src++), sizeof(lanczos_6x24bit)/sizeof(float));
                dst        += 6;
            }
        }

        void lanczos_resample_8x2(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                float s     = *(src++);

                // Apply Lanczos 8x2 kernel
                dst[1]     -= 0.0043033145538298f * s;
                dst[2]     -= 0.0179051851263444f * s;
                dst[3]     -= 0.0393892611124141f * s;
                dst[4]     -= 0.0636843520278618f * s;
                dst[5]     -= 0.0823353965569232f * s;
                dst[6]     -= 0.0847248039068907f * s;
                dst[7]     -= 0.0600950644541902f * s;

                dst[9]     += 0.0993408208324369f * s;
                dst[10]    += 0.2353466775191407f * s;
                dst[11]    += 0.3985033193355084f * s;
                dst[12]    += 0.5731591682507563f * s;
                dst[13]    += 0.7396427919997760f * s;
                dst[14]    += 0.8773540711908775f * s;
                dst[15]    += 0.9682457746117045f * s;

                dst[16]    += s;

                dst[17]    += 0.9682457746117045f * s;
                dst[18]    += 0.8773540711908775f * s;
                dst[19]    += 0.7396427919997760f * s;
                dst[20]    += 0.5731591682507563f * s;
                dst[21]    += 0.3985033193355084f * s;
                dst[22]    += 0.2353466775191407f * s;
                dst[23]    += 0.0993408208324369f * s;

                dst[25]    -= 0.0600950644541902f * s;
                dst[26]    -= 0.0847248039068907f * s;
                dst[27]    -= 0.0823353965569232f * s;
                dst[28]    -= 0.0636843520278618f * s;
                dst[29]    -= 0.0393892611124141f * s;
                dst[30]    -= 0.0179051851263444f * s;
                dst[31]    -= 0.0043033145538298f * s;

                // Move destination buffer
                dst        += 8;
            }
        }

        void lanczos_resample_8x3(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                float s     = *(src++);

                // Apply Lanczos 8x3 kernel
                dst[1]     += 0.0018368899607481f * s;
                dst[2]     += 0.0073559260471942f * s;
                dst[3]     += 0.0155961678435580f * s;
                dst[4]     += 0.0243170840741611f * s;
                dst[5]     += 0.0303079634725070f * s;
                dst[6]     += 0.0300210914495816f * s;
                dst[7]     += 0.0204366616947175f * s;

                dst[9]     -= 0.0305684889733737f * s;
                dst[10]    -= 0.0677913359005429f * s;
                dst[11]    -= 0.1054383717904384f * s;
                dst[12]    -= 0.1350949115231170f * s;
                dst[13]    -= 0.1472651639056537f * s;
                dst[14]    -= 0.1328710183650640f * s;
                dst[15]    -= 0.0849124693704824f * s;

                dst[17]    += 0.1205345965259870f * s;
                dst[18]    += 0.2701898230462341f * s;
                dst[19]    += 0.4376469925430009f * s;
                dst[20]    += 0.6079271018540265f * s;
                dst[21]    += 0.7642122243343417f * s;
                dst[22]    += 0.8900670517104946f * s;
                dst[23]    += 0.9717147892357163f * s;

                dst[24]    += s;

                dst[25]    += 0.9717147892357163f * s;
                dst[26]    += 0.8900670517104946f * s;
                dst[27]    += 0.7642122243343417f * s;
                dst[28]    += 0.6079271018540265f * s;
                dst[29]    += 0.4376469925430009f * s;
                dst[30]    += 0.2701898230462341f * s;
                dst[31]    += 0.1205345965259870f * s;

                dst[33]    -= 0.0849124693704824f * s;
                dst[34]    -= 0.1328710183650640f * s;
                dst[35]    -= 0.1472651639056537f * s;
                dst[36]    -= 0.1350949115231170f * s;
                dst[37]    -= 0.1054383717904384f * s;
                dst[38]    -= 0.0677913359005429f * s;
                dst[39]    -= 0.0305684889733737f * s;

                dst[41]    += 0.0204366616947175f * s;
                dst[42]    += 0.0300210914495816f * s;
                dst[43]    += 0.0303079634725070f * s;
                dst[44]    += 0.0243170840741611f * s;
                dst[45]    += 0.0155961678435580f * s;
                dst[46]    += 0.0073559260471942f * s;
                dst[47]    += 0.0018368899607481f * s;

                // Move destination buffer
                dst        += 8;
            }
        }

        void lanczos_resample_8x4(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                float s     = *(src++);

                // Apply Lanczos 8x3 kernel
                dst[1]     -= 0.0010124148822791f * s;
                dst[2]     -= 0.0039757442382413f * s;
                dst[3]     -= 0.0082714887261119f * s;
                dst[4]     -= 0.0126608778212387f * s;
                dst[5]     -= 0.0154958216565010f * s;
                dst[6]     -= 0.0150736176408234f * s;
                dst[7]     -= 0.0100753105205530f * s;

                dst[9]     += 0.0145047275409824f * s;
                dst[10]    += 0.0315083921595442f * s;
                dst[11]    += 0.0479233082326825f * s;
                dst[12]    += 0.0599094833772629f * s;
                dst[13]    += 0.0635233253590927f * s;
                dst[14]    += 0.0555206000541729f * s;
                dst[15]    += 0.0341810767869351f * s;

                dst[17]    -= 0.0439036941841078f * s;
                dst[18]    -= 0.0917789511099593f * s;
                dst[19]    -= 0.1356918370096595f * s;
                dst[20]    -= 0.1664152316035080f * s;
                dst[21]    -= 0.1746626357901899f * s;
                dst[22]    -= 0.1525006180521938f * s;
                dst[23]    -= 0.0947284057923417f * s;

                dst[25]    += 0.1285116137825641f * s;
                dst[26]    += 0.2830490423665725f * s;
                dst[27]    += 0.4518581595035692f * s;
                dst[28]    += 0.6203830132406946f * s;
                dst[29]    += 0.7729246687400148f * s;
                dst[30]    += 0.8945424536042901f * s;
                dst[31]    += 0.9729307018702211f * s;

                dst[32]    += 1.0000000000000000f * s;

                dst[33]    += 0.9729307018702211f * s;
                dst[34]    += 0.8945424536042901f * s;
                dst[35]    += 0.7729246687400148f * s;
                dst[36]    += 0.6203830132406946f * s;
                dst[37]    += 0.4518581595035692f * s;
                dst[38]    += 0.2830490423665725f * s;
                dst[39]    += 0.1285116137825641f * s;

                dst[41]    -= 0.0947284057923417f * s;
                dst[42]    -= 0.1525006180521938f * s;
                dst[43]    -= 0.1746626357901899f * s;
                dst[44]    -= 0.1664152316035080f * s;
                dst[45]    -= 0.1356918370096595f * s;
                dst[46]    -= 0.0917789511099593f * s;
                dst[47]    -= 0.0439036941841078f * s;

                dst[49]    += 0.0341810767869351f * s;
                dst[50]    += 0.0555206000541729f * s;
                dst[51]    += 0.0635233253590927f * s;
                dst[52]    += 0.0599094833772629f * s;
                dst[53]    += 0.0479233082326825f * s;
                dst[54]    += 0.0315083921595442f * s;
                dst[55]    += 0.0145047275409824f * s;

                dst[57]    -= 0.0100753105205530f * s;
                dst[58]    -= 0.0150736176408234f * s;
                dst[59]    -= 0.0154958216565010f * s;
                dst[60]    -= 0.0126608778212387f * s;
                dst[61]    -= 0.0082714887261119f * s;
                dst[62]    -= 0.0039757442382413f * s;
                dst[63]    -= 0.0010124148822791f * s;

                // Move destination buffer
                dst        += 8;
            }
        }

        void lanczos_resample_8x16bit(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                dsp::fmadd_k3(dst, lanczos_8x16bit, *(src++), sizeof(lanczos_8x16bit)/sizeof(float));
                dst        += 8;
            }
        }

        void lanczos_resample_8x24bit(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                dsp::fmadd_k3(dst, lanczos_8x24bit, *(src++), sizeof(lanczos_8x24bit)/sizeof(float));
                dst        += 8;
            }
        }

        void downsample_2x(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                *dst    = *src;
                dst     ++;
                src     += 2;
            }
        }

        void downsample_3x(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                *dst    = *src;
                dst     ++;
                src     += 3;
            }
        }

        void downsample_4x(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                *dst    = *src;
                dst     ++;
                src     += 4;
            }
        }

        void downsample_6x(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                *dst    = *src;
                dst     ++;
                src     += 6;
            }
        }

        void downsample_8x(float *dst, const float *src, size_t count)
        {
            while (count--)
            {
                *dst    = *src;
                dst     ++;
                src     += 8;
            }
        }
    } /* namespace generic */
} /* namespace lsp */

#endif /* PRIVATE_DSP_ARCH_GENERIC_RESAMPLING_H_ */
