/* A recursive-descent parser generated by peg 0.1.15 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define YYRULECOUNT 54

/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/** @brief Hindsight message matcher parser @file */

#include <limits.h>
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "heka_message_matcher_impl.h"
#include "luasandbox/util/heka_message.h"
#include "luasandbox/util/heka_message_matcher.h"

#ifndef _MSC_VER
#pragma GCC diagnostic ignored "-Wunused-parameter"
#pragma GCC diagnostic ignored "-Wunused-function"
#else
#pragma warning( disable : 4267 4244 )
#endif

typedef struct match_node_array {
  match_node  *a;
  int         pos;
  int         size;
} match_node_array;


typedef struct input_string {
  const char *s;
  size_t     pos;
  size_t     size;
} input_string;


typedef struct context {
  match_node_array  out;
  match_node_array  ops;
  match_node        mn;
  struct tm         tms;
  int               cond_cnt;
  input_string      is;
} context;


#define YY_PARSE(T) static T
#define YY_CTX_LOCAL 1
#define YY_CTX_MEMBERS \
   context ctx;

#define YY_INPUT(yy, buf, result, max_size)                                    \
{                                                                              \
  input_string *is = &yy->ctx.is;                                              \
  result = is->size - is->pos;                                                 \
  if (result > 0) {                                                            \
    if (max_size >= result) {                                                  \
      memcpy(buf, &is->s[is->pos], result);                                    \
      is->pos += result;                                                       \
    } else {                                                                   \
      memcpy(buf, &is->s[is->pos], max_size);                                  \
      is->pos += max_size;                                                     \
      result = max_size;                                                       \
    }                                                                          \
  }                                                                            \
}


static void init_match_node(match_node *mn)
{
  memset(mn, 0, sizeof(match_node));
}


static void move_match_node(match_node *dest, match_node *src)
{
  memcpy(dest, src, sizeof(match_node));
  init_match_node(src); // dest now owns the memory, wipe the pointers
}


static void realloc_mna(match_node_array *mna)
{
  size_t bytes = sizeof(match_node) * ++mna->size;
  match_node *tmp = realloc(mna->a, bytes);
  if (tmp) {
    mna->a = tmp;
    init_match_node(&mna->a[mna->size - 1]);
  } else {
    fprintf(stderr, "realloc failed\n");
    exit(1);
  }
}


static void push_output(context *ctx, match_node *mn)
{
  if (!ctx->out.a || ctx->out.pos == ctx->out.size) {
    realloc_mna(&ctx->out);
  }
  move_match_node(&ctx->out.a[ctx->out.pos++], mn);
}


static void push_op(context *ctx, match_operation op)
{
  if (!ctx->ops.a) {
    realloc_mna(&ctx->ops);
    ctx->ops.a[ctx->ops.pos++].op = op;
    return;
  }

  if (op == OP_OPEN || op > ctx->ops.a[ctx->ops.pos - 1].op) {
    if (ctx->ops.pos == ctx->ops.size) {
      realloc_mna(&ctx->ops);
    }
    ctx->ops.a[ctx->ops.pos++].op = op;
  } else {
    push_output(ctx, &ctx->ops.a[ctx->ops.pos - 1]);
    ctx->ops.a[ctx->ops.pos - 1].op = op;
  }
}


static void pop_to_paren(context *ctx)
{
  for (; ctx->ops.pos > 0; --ctx->ops.pos) {
    match_node *op = &ctx->ops.a[ctx->ops.pos - 1];
    if (op->op == OP_OPEN) break;
    push_output(ctx, op);
  }
}


static void pop_all_ops(context *ctx)
{
  for (; ctx->ops.pos > 0; --ctx->ops.pos) {
    match_node *op = &ctx->ops.a[ctx->ops.pos - 1];
    if (op->op == OP_OPEN) continue;
    push_output(ctx, op);
  }
}


static void update_date(context *ctx, int year, int mon, int day)
{
  ctx->tms.tm_isdst = -1;
  ctx->tms.tm_year  = year - 1900;
  ctx->tms.tm_mon   = mon - 1;
  ctx->tms.tm_mday  = day;
}


static void update_time(context *ctx, int hour, int minute, int sec)
{
  ctx->tms.tm_hour  = hour;
  ctx->tms.tm_min   = minute;
  ctx->tms.tm_sec   = sec;
}


static void update_offset(context *ctx, char sign, int hour, int minute)
{
  ctx->mn.value.d += (hour * 3600 + minute * 60) * (sign == '-' ? -1 : 1);
}


static void set_field(context *ctx, char *name)
{
  ctx->mn.id = LSB_PB_FIELDS;
  ctx->mn.variable_len = strlen(name);
  ctx->mn.variable = malloc(ctx->mn.variable_len + 1);
  if (!ctx->mn.variable) {
    fprintf(stderr, "malloc failed\n");
    exit(1);
  }
  memcpy(ctx->mn.variable, name, ctx->mn.variable_len + 1);
}


static void set_timestamp(context *ctx)
{
  ctx->mn.id = LSB_PB_TIMESTAMP;
  ctx->mn.value_type = TYPE_NUMERIC;
  if (ctx->tms.tm_isdst == -1) {
    ctx->mn.value.d += mktime(&ctx->tms);
    ctx->mn.value.d *= 1e9;
  }
  memset(&ctx->tms, 0, sizeof(struct tm));
}


static void set_numeric_value(context *ctx, char *s)
{
  ctx->mn.value_type = TYPE_NUMERIC;
  ctx->mn.value.d = strtod(s, NULL);
}


static void set_string_value(context *ctx, char *s)
{
  ctx->mn.value_type = TYPE_STRING;
  int i, j;
  for (i = 0, j = 0; s[i]; ++i, ++j) {
    if (s[i] == '\\' && (s[i + 1] == '"' || s[i + 1] == '\'')) {
      ++i;
    }
    s[j] = s[i];
  }
  s[j] = 0;

  ctx->mn.value_len = j;
  ctx->mn.value.s = malloc(j + 1);
  if (!ctx->mn.value.s) {
    fprintf(stderr, "malloc failed\n");
    exit(1);
  }
  memcpy(ctx->mn.value.s, s, j + 1);
}


static bool check_string_len(char *s)
{
  int i, j;
  for (i = 0, j = 0; s[i]; ++i, ++j) {
    if (s[i] == '\\' && (s[i + 1] == '"' || s[i + 1] == '\'')) {
      ++i;
    }
  }
  return (j > UCHAR_MAX) ? false : true;
}


static void set_boolean_value(context *ctx, bool b)
{
  ctx->mn.value_type = TYPE_BOOLEAN;
  ctx->mn.value.d = b;
}


static int cond_cnt(context *ctx)
{
  return (++ctx->cond_cnt * 2 + 1 > UCHAR_MAX) ? 0 : 1;
}


#ifndef YY_MALLOC
#define YY_MALLOC(C, N)   malloc(N)
#endif
#ifndef YY_REALLOC
#define YY_REALLOC(C, P, N) realloc(P, N)
#endif
#ifndef YY_FREE
#define YY_FREE(C, P)   free(P)
#endif
#ifndef YY_LOCAL
#define YY_LOCAL(T) static T
#endif
#ifndef YY_ACTION
#define YY_ACTION(T)  static T
#endif
#ifndef YY_RULE
#define YY_RULE(T)  static T
#endif
#ifndef YY_PARSE
#define YY_PARSE(T) T
#endif
#ifndef YYPARSE
#define YYPARSE   yyparse
#endif
#ifndef YYPARSEFROM
#define YYPARSEFROM yyparsefrom
#endif
#ifndef YYRELEASE
#define YYRELEASE yyrelease
#endif
#ifndef YY_BEGIN
#define YY_BEGIN  ( yy->__begin= yy->__pos, 1)
#endif
#ifndef YY_END
#define YY_END    ( yy->__end= yy->__pos, 1)
#endif
#ifdef YY_DEBUG
# define yyprintf(args) fprintf args
#else
# define yyprintf(args)
#endif
#ifndef YYSTYPE
#define YYSTYPE int
#endif
#ifndef YY_STACK_SIZE
#define YY_STACK_SIZE 128
#endif

#ifndef YY_BUFFER_SIZE
#define YY_BUFFER_SIZE 1024
#endif

#ifndef YY_PART

typedef struct _yycontext yycontext;
typedef void (*yyaction)(yycontext *yy, char *yytext, int yyleng);
typedef struct _yythunk { int begin, end;  yyaction  action;  struct _yythunk *next; } yythunk;

struct _yycontext {
  char     *__buf;
  int       __buflen;
  int       __pos;
  int       __limit;
  char     *__text;
  int       __textlen;
  int       __begin;
  int       __end;
  int       __textmax;
  yythunk  *__thunks;
  int       __thunkslen;
  int       __thunkpos;
  YYSTYPE   __;
  YYSTYPE  *__val;
  YYSTYPE  *__vals;
  int       __valslen;
#ifdef YY_CTX_MEMBERS
  YY_CTX_MEMBERS
#endif
};

#ifdef YY_CTX_LOCAL
#define YY_CTX_PARAM_ yycontext *yyctx,
#define YY_CTX_PARAM  yycontext *yyctx
#define YY_CTX_ARG_ yyctx,
#define YY_CTX_ARG  yyctx
#ifndef YY_INPUT
#define YY_INPUT(yy, buf, result, max_size)   \
  {             \
    int yyc= getchar();         \
    result= (EOF == yyc) ? 0 : (*(buf)= yyc, 1);  \
    yyprintf((stderr, "<%c>", yyc));      \
  }
#endif
#else
#define YY_CTX_PARAM_
#define YY_CTX_PARAM
#define YY_CTX_ARG_
#define YY_CTX_ARG
yycontext _yyctx= { 0, 0 };
yycontext *yyctx= &_yyctx;
#ifndef YY_INPUT
#define YY_INPUT(buf, result, max_size)     \
  {             \
    int yyc= getchar();         \
    result= (EOF == yyc) ? 0 : (*(buf)= yyc, 1);  \
    yyprintf((stderr, "<%c>", yyc));      \
  }
#endif
#endif

YY_LOCAL(int) yyrefill(yycontext *yy)
{
  int yyn;
  while (yy->__buflen - yy->__pos < 512)
    {
      yy->__buflen *= 2;
      yy->__buf= (char *)YY_REALLOC(yy, yy->__buf, yy->__buflen);
    }
#ifdef YY_CTX_LOCAL
  YY_INPUT(yy, (yy->__buf + yy->__pos), yyn, (yy->__buflen - yy->__pos));
#else
  YY_INPUT((yy->__buf + yy->__pos), yyn, (yy->__buflen - yy->__pos));
#endif
  if (!yyn) return 0;
  yy->__limit += yyn;
  return 1;
}

YY_LOCAL(int) yymatchDot(yycontext *yy)
{
  if (yy->__pos >= yy->__limit && !yyrefill(yy)) return 0;
  ++yy->__pos;
  return 1;
}

YY_LOCAL(int) yymatchChar(yycontext *yy, int c)
{
  if (yy->__pos >= yy->__limit && !yyrefill(yy)) return 0;
  if ((unsigned char)yy->__buf[yy->__pos] == c)
    {
      ++yy->__pos;
      yyprintf((stderr, "  ok   yymatchChar(yy, %c) @ %s\n", c, yy->__buf+yy->__pos));
      return 1;
    }
  yyprintf((stderr, "  fail yymatchChar(yy, %c) @ %s\n", c, yy->__buf+yy->__pos));
  return 0;
}

YY_LOCAL(int) yymatchString(yycontext *yy, const char *s)
{
  int yysav= yy->__pos;
  while (*s)
    {
      if (yy->__pos >= yy->__limit && !yyrefill(yy)) return 0;
      if (yy->__buf[yy->__pos] != *s)
        {
          yy->__pos= yysav;
          return 0;
        }
      ++s;
      ++yy->__pos;
    }
  return 1;
}

YY_LOCAL(int) yymatchClass(yycontext *yy, unsigned char *bits)
{
  int c;
  if (yy->__pos >= yy->__limit && !yyrefill(yy)) return 0;
  c= (unsigned char)yy->__buf[yy->__pos];
  if (bits[c >> 3] & (1 << (c & 7)))
    {
      ++yy->__pos;
      yyprintf((stderr, "  ok   yymatchClass @ %s\n", yy->__buf+yy->__pos));
      return 1;
    }
  yyprintf((stderr, "  fail yymatchClass @ %s\n", yy->__buf+yy->__pos));
  return 0;
}

YY_LOCAL(void) yyDo(yycontext *yy, yyaction action, int begin, int end)
{
  while (yy->__thunkpos >= yy->__thunkslen)
    {
      yy->__thunkslen *= 2;
      yy->__thunks= (yythunk *)YY_REALLOC(yy, yy->__thunks, sizeof(yythunk) * yy->__thunkslen);
    }
  yy->__thunks[yy->__thunkpos].begin=  begin;
  yy->__thunks[yy->__thunkpos].end=    end;
  yy->__thunks[yy->__thunkpos].action= action;
  ++yy->__thunkpos;
}

YY_LOCAL(int) yyText(yycontext *yy, int begin, int end)
{
  int yyleng= end - begin;
  if (yyleng <= 0)
    yyleng= 0;
  else
    {
      while (yy->__textlen < (yyleng + 1))
  {
    yy->__textlen *= 2;
    yy->__text= (char *)YY_REALLOC(yy, yy->__text, yy->__textlen);
  }
      memcpy(yy->__text, yy->__buf + begin, yyleng);
    }
  yy->__text[yyleng]= '\0';
  return yyleng;
}

YY_LOCAL(void) yyDone(yycontext *yy)
{
  int pos;
  for (pos= 0;  pos < yy->__thunkpos;  ++pos)
    {
      yythunk *thunk= &yy->__thunks[pos];
      int yyleng= thunk->end ? yyText(yy, thunk->begin, thunk->end) : thunk->begin;
      yyprintf((stderr, "DO [%d] %p %s\n", pos, thunk->action, yy->__text));
      thunk->action(yy, yy->__text, yyleng);
    }
  yy->__thunkpos= 0;
}

YY_LOCAL(void) yyCommit(yycontext *yy)
{
  if ((yy->__limit -= yy->__pos))
    {
      memmove(yy->__buf, yy->__buf + yy->__pos, yy->__limit);
    }
  yy->__begin -= yy->__pos;
  yy->__end -= yy->__pos;
  yy->__pos= yy->__thunkpos= 0;
}

YY_LOCAL(int) yyAccept(yycontext *yy, int tp0)
{
  if (tp0)
    {
      fprintf(stderr, "accept denied at %d\n", tp0);
      return 0;
    }
  else
    {
      yyDone(yy);
      yyCommit(yy);
    }
  return 1;
}

YY_LOCAL(void) yyPush(yycontext *yy, char *text, int count)
{
  yy->__val += count;
  while (yy->__valslen <= yy->__val - yy->__vals)
    {
      long offset= yy->__val - yy->__vals;
      int olen = yy->__valslen;
      yy->__valslen *= 2;
      yy->__vals= (YYSTYPE *)YY_REALLOC(yy, yy->__vals, sizeof(YYSTYPE) * yy->__valslen);
      yy->__val= yy->__vals + offset;
      memset(yy->__vals + olen, 0, sizeof(YYSTYPE) * olen);
    }
}
YY_LOCAL(void) yyPop(yycontext *yy, char *text, int count)   { yy->__val -= count; }
YY_LOCAL(void) yySet(yycontext *yy, char *text, int count)   { yy->__val[count]= yy->__; }

#endif /* YY_PART */

#define YYACCEPT  yyAccept(yy, yythunkpos0)

YY_RULE(int) yy_second_frac(yycontext *yy); /* 54 */
YY_RULE(int) yy_second(yycontext *yy); /* 53 */
YY_RULE(int) yy_minute(yycontext *yy); /* 52 */
YY_RULE(int) yy_hour(yycontext *yy); /* 51 */
YY_RULE(int) yy_timeoffset(yycontext *yy); /* 50 */
YY_RULE(int) yy_partialtime(yycontext *yy); /* 49 */
YY_RULE(int) yy_fulltime(yycontext *yy); /* 48 */
YY_RULE(int) yy_day(yycontext *yy); /* 47 */
YY_RULE(int) yy_month(yycontext *yy); /* 46 */
YY_RULE(int) yy_year(yycontext *yy); /* 45 */
YY_RULE(int) yy_fulldate(yycontext *yy); /* 44 */
YY_RULE(int) yy_rfc3339(yycontext *yy); /* 43 */
YY_RULE(int) yy_ts_quoted(yycontext *yy); /* 42 */
YY_RULE(int) yy_zero_to_255(yycontext *yy); /* 41 */
YY_RULE(int) yy_index(yycontext *yy); /* 40 */
YY_RULE(int) yy_nil(yycontext *yy); /* 39 */
YY_RULE(int) yy_fields(yycontext *yy); /* 38 */
YY_RULE(int) yy_exponent(yycontext *yy); /* 37 */
YY_RULE(int) yy_decimal(yycontext *yy); /* 36 */
YY_RULE(int) yy_number(yycontext *yy); /* 35 */
YY_RULE(int) yy_sign(yycontext *yy); /* 34 */
YY_RULE(int) yy_numeric_value(yycontext *yy); /* 33 */
YY_RULE(int) yy_numeric_headers(yycontext *yy); /* 32 */
YY_RULE(int) yy_string_match(yycontext *yy); /* 31 */
YY_RULE(int) yy_string_value(yycontext *yy); /* 30 */
YY_RULE(int) yy_string_headers(yycontext *yy); /* 29 */
YY_RULE(int) yy_boolean(yycontext *yy); /* 28 */
YY_RULE(int) yy_false(yycontext *yy); /* 27 */
YY_RULE(int) yy_true(yycontext *yy); /* 26 */
YY_RULE(int) yy_relational(yycontext *yy); /* 25 */
YY_RULE(int) yy_op_lt(yycontext *yy); /* 24 */
YY_RULE(int) yy_op_lte(yycontext *yy); /* 23 */
YY_RULE(int) yy_op_gt(yycontext *yy); /* 22 */
YY_RULE(int) yy_op_gte(yycontext *yy); /* 21 */
YY_RULE(int) yy_op_sne(yycontext *yy); /* 20 */
YY_RULE(int) yy_op_seq(yycontext *yy); /* 19 */
YY_RULE(int) yy_op_ne(yycontext *yy); /* 18 */
YY_RULE(int) yy_op_eq(yycontext *yy); /* 17 */
YY_RULE(int) yy_boolean_test(yycontext *yy); /* 16 */
YY_RULE(int) yy_ts_test(yycontext *yy); /* 15 */
YY_RULE(int) yy_field_test(yycontext *yy); /* 14 */
YY_RULE(int) yy_numeric_test(yycontext *yy); /* 13 */
YY_RULE(int) yy_string_test(yycontext *yy); /* 12 */
YY_RULE(int) yy_close(yycontext *yy); /* 11 */
YY_RULE(int) yy_open(yycontext *yy); /* 10 */
YY_RULE(int) yy_test(yycontext *yy); /* 9 */
YY_RULE(int) yy_and(yycontext *yy); /* 8 */
YY_RULE(int) yy_expr(yycontext *yy); /* 7 */
YY_RULE(int) yy_or(yycontext *yy); /* 6 */
YY_RULE(int) yy_anded(yycontext *yy); /* 5 */
YY_RULE(int) yy_eol(yycontext *yy); /* 4 */
YY_RULE(int) yy_ored(yycontext *yy); /* 3 */
YY_RULE(int) yy_sp(yycontext *yy); /* 2 */
YY_RULE(int) yy_match(yycontext *yy); /* 1 */

YY_ACTION(void) yy_1_nil(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_nil\n"));
  {
  yy->ctx.mn.value_type = TYPE_NIL;;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_second_frac(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_second_frac\n"));
  {
  yy->ctx.mn.value.d += strtod(yytext, NULL);
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_second(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_second\n"));
  {
  __ = atoi(yytext);
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_minute(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_minute\n"));
  {
  __ = atoi(yytext);
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_hour(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_hour\n"));
  {
  __ = atoi(yytext);
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_2_timeoffset(yycontext *yy, char *yytext, int yyleng)
{
#define m yy->__val[-1]
#define h yy->__val[-2]
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_2_timeoffset\n"));
  {
  update_offset(&yy->ctx, yytext[0], h, m);
  }
#undef yythunkpos
#undef yypos
#undef yy
#undef m
#undef h
}
YY_ACTION(void) yy_1_timeoffset(yycontext *yy, char *yytext, int yyleng)
{
#define m yy->__val[-1]
#define h yy->__val[-2]
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_timeoffset\n"));
  {
  update_offset(&yy->ctx, '+', 0, 0);
  }
#undef yythunkpos
#undef yypos
#undef yy
#undef m
#undef h
}
YY_ACTION(void) yy_1_partialtime(yycontext *yy, char *yytext, int yyleng)
{
#define s yy->__val[-1]
#define m yy->__val[-2]
#define h yy->__val[-3]
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_partialtime\n"));
  {
  update_time(&yy->ctx, h, m, s);
  }
#undef yythunkpos
#undef yypos
#undef yy
#undef s
#undef m
#undef h
}
YY_ACTION(void) yy_1_day(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_day\n"));
  {
  __ = atoi(yytext);
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_month(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_month\n"));
  {
  __ = atoi(yytext);
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_year(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_year\n"));
  {
  __ = atoi(yytext);
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_fulldate(yycontext *yy, char *yytext, int yyleng)
{
#define d yy->__val[-1]
#define m yy->__val[-2]
#define y yy->__val[-3]
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_fulldate\n"));
  {
  update_date(&yy->ctx, y, m, d);
  }
#undef yythunkpos
#undef yypos
#undef yy
#undef d
#undef m
#undef y
}
YY_ACTION(void) yy_1_ts_test(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_ts_test\n"));
  {
  set_timestamp(&yy->ctx);
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_index(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_index\n"));
  {
  __ = atoi(yytext);
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_3_fields(yycontext *yy, char *yytext, int yyleng)
{
#define a yy->__val[-1]
#define f yy->__val[-2]
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_3_fields\n"));
  {
  yy->ctx.mn.ai = a;
  }
#undef yythunkpos
#undef yypos
#undef yy
#undef a
#undef f
}
YY_ACTION(void) yy_2_fields(yycontext *yy, char *yytext, int yyleng)
{
#define a yy->__val[-1]
#define f yy->__val[-2]
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_2_fields\n"));
  {
  yy->ctx.mn.fi = f;
  }
#undef yythunkpos
#undef yypos
#undef yy
#undef a
#undef f
}
YY_ACTION(void) yy_1_fields(yycontext *yy, char *yytext, int yyleng)
{
#define a yy->__val[-1]
#define f yy->__val[-2]
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_fields\n"));
  {
  set_field(&yy->ctx, yytext);
  }
#undef yythunkpos
#undef yypos
#undef yy
#undef a
#undef f
}
YY_ACTION(void) yy_1_numeric_value(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_numeric_value\n"));
  {
  set_numeric_value(&yy->ctx, yytext);
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_2_numeric_headers(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_2_numeric_headers\n"));
  {
  yy->ctx.mn.id = LSB_PB_PID;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_numeric_headers(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_numeric_headers\n"));
  {
  yy->ctx.mn.id = LSB_PB_SEVERITY;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_string_value(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_string_value\n"));
  {
  set_string_value(&yy->ctx, yytext);
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_6_string_headers(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_6_string_headers\n"));
  {
  yy->ctx.mn.id = LSB_PB_UUID;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_5_string_headers(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_5_string_headers\n"));
  {
  yy->ctx.mn.id = LSB_PB_PAYLOAD;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_4_string_headers(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_4_string_headers\n"));
  {
  yy->ctx.mn.id = LSB_PB_ENV_VERSION;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_3_string_headers(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_3_string_headers\n"));
  {
  yy->ctx.mn.id = LSB_PB_HOSTNAME;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_2_string_headers(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_2_string_headers\n"));
  {
  yy->ctx.mn.id = LSB_PB_LOGGER;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_string_headers(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_string_headers\n"));
  {
  yy->ctx.mn.id = LSB_PB_TYPE;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_close(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_close\n"));
  {
  pop_to_paren(&yy->ctx);
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_open(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_open\n"));
  {
  push_op(&yy->ctx, OP_OPEN);
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_or(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_or\n"));
  {
  push_op(&yy->ctx, OP_OR);
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_and(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_and\n"));
  {
  push_op(&yy->ctx, OP_AND);
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_2_boolean(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_2_boolean\n"));
  {
  set_boolean_value(&yy->ctx, 0);
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_boolean(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_boolean\n"));
  {
  set_boolean_value(&yy->ctx, 1);
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_2_boolean_test(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_2_boolean_test\n"));
  {
  yy->ctx.mn.op = OP_FALSE;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_boolean_test(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_boolean_test\n"));
  {
  yy->ctx.mn.op = OP_TRUE;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_op_lt(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_op_lt\n"));
  {
  yy->ctx.mn.op = OP_LT;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_op_lte(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_op_lte\n"));
  {
  yy->ctx.mn.op = OP_LTE;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_op_gt(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_op_gt\n"));
  {
  yy->ctx.mn.op = OP_GT;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_op_gte(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_op_gte\n"));
  {
  yy->ctx.mn.op = OP_GTE;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_op_sne(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_op_sne\n"));
  {
  yy->ctx.mn.op = OP_NRE;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_op_seq(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_op_seq\n"));
  {
  yy->ctx.mn.op = OP_RE;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_op_ne(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_op_ne\n"));
  {
  yy->ctx.mn.op = OP_NE;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_op_eq(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_op_eq\n"));
  {
  yy->ctx.mn.op = OP_EQ;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_test(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_test\n"));
  {
  push_output(&yy->ctx, &yy->ctx.mn);
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_match(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_match\n"));
  {
  pop_all_ops(&yy->ctx);
  }
#undef yythunkpos
#undef yypos
#undef yy
}

YY_RULE(int) yy_second_frac(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "second_frac"));  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_BEGIN)) goto l1;
#undef yytext
#undef yyleng
  }  if (!yy_decimal(yy)) goto l1;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_END)) goto l1;
#undef yytext
#undef yyleng
  }  yyDo(yy, yy_1_second_frac, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "second_frac", yy->__buf+yy->__pos));
  return 1;
  l1:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "second_frac", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_second(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "second"));
  {  int yypos3= yy->__pos, yythunkpos3= yy->__thunkpos;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_BEGIN)) goto l4;
#undef yytext
#undef yyleng
  }  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\077\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l4;  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l4;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_END)) goto l4;
#undef yytext
#undef yyleng
  }  goto l3;
  l4:;	  yy->__pos= yypos3; yy->__thunkpos= yythunkpos3;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_BEGIN)) goto l2;
#undef yytext
#undef yyleng
  }  if (!yymatchString(yy, "60")) goto l2;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_END)) goto l2;
#undef yytext
#undef yyleng
  }
  }
  l3:;	  yyDo(yy, yy_1_second, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "second", yy->__buf+yy->__pos));
  return 1;
  l2:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "second", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_minute(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "minute"));  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_BEGIN)) goto l5;
#undef yytext
#undef yyleng
  }  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\077\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l5;  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l5;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_END)) goto l5;
#undef yytext
#undef yyleng
  }  yyDo(yy, yy_1_minute, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "minute", yy->__buf+yy->__pos));
  return 1;
  l5:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "minute", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_hour(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "hour"));
  {  int yypos7= yy->__pos, yythunkpos7= yy->__thunkpos;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_BEGIN)) goto l8;
#undef yytext
#undef yyleng
  }  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l8;  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l8;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_END)) goto l8;
#undef yytext
#undef yyleng
  }  goto l7;
  l8:;	  yy->__pos= yypos7; yy->__thunkpos= yythunkpos7;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_BEGIN)) goto l6;
#undef yytext
#undef yyleng
  }  if (!yymatchChar(yy, '2')) goto l6;  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\017\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l6;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_END)) goto l6;
#undef yytext
#undef yyleng
  }
  }
  l7:;	  yyDo(yy, yy_1_hour, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "hour", yy->__buf+yy->__pos));
  return 1;
  l6:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "hour", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_timeoffset(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;  yyDo(yy, yyPush, 2, 0);
  yyprintf((stderr, "%s\n", "timeoffset"));
  {  int yypos10= yy->__pos, yythunkpos10= yy->__thunkpos;  if (!yymatchChar(yy, 'Z')) goto l11;  yyDo(yy, yy_1_timeoffset, yy->__begin, yy->__end);  goto l10;
  l11:;	  yy->__pos= yypos10; yy->__thunkpos= yythunkpos10;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_BEGIN)) goto l9;
#undef yytext
#undef yyleng
  }  if (!yy_sign(yy)) goto l9;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_END)) goto l9;
#undef yytext
#undef yyleng
  }  if (!yy_hour(yy)) goto l9;  yyDo(yy, yySet, -2, 0);  if (!yy_minute(yy)) goto l9;  yyDo(yy, yySet, -1, 0);  yyDo(yy, yy_2_timeoffset, yy->__begin, yy->__end);
  }
  l10:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "timeoffset", yy->__buf+yy->__pos));  yyDo(yy, yyPop, 2, 0);
  return 1;
  l9:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "timeoffset", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_partialtime(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;  yyDo(yy, yyPush, 3, 0);
  yyprintf((stderr, "%s\n", "partialtime"));  if (!yy_hour(yy)) goto l12;  yyDo(yy, yySet, -3, 0);  if (!yymatchChar(yy, ':')) goto l12;  if (!yy_minute(yy)) goto l12;  yyDo(yy, yySet, -2, 0);  if (!yymatchChar(yy, ':')) goto l12;  if (!yy_second(yy)) goto l12;  yyDo(yy, yySet, -1, 0);
  {  int yypos13= yy->__pos, yythunkpos13= yy->__thunkpos;  if (!yy_second_frac(yy)) goto l13;  goto l14;
  l13:;	  yy->__pos= yypos13; yy->__thunkpos= yythunkpos13;
  }
  l14:;	  yyDo(yy, yy_1_partialtime, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "partialtime", yy->__buf+yy->__pos));  yyDo(yy, yyPop, 3, 0);
  return 1;
  l12:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "partialtime", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_fulltime(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "fulltime"));  if (!yy_partialtime(yy)) goto l15;  if (!yy_timeoffset(yy)) goto l15;
  yyprintf((stderr, "  ok   %s @ %s\n", "fulltime", yy->__buf+yy->__pos));
  return 1;
  l15:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "fulltime", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_day(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "day"));
  {  int yypos17= yy->__pos, yythunkpos17= yy->__thunkpos;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_BEGIN)) goto l18;
#undef yytext
#undef yyleng
  }  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\006\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l18;  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l18;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_END)) goto l18;
#undef yytext
#undef yyleng
  }  goto l17;
  l18:;	  yy->__pos= yypos17; yy->__thunkpos= yythunkpos17;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_BEGIN)) goto l19;
#undef yytext
#undef yyleng
  }  if (!yymatchChar(yy, '0')) goto l19;  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\376\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l19;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_END)) goto l19;
#undef yytext
#undef yyleng
  }  goto l17;
  l19:;	  yy->__pos= yypos17; yy->__thunkpos= yythunkpos17;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_BEGIN)) goto l16;
#undef yytext
#undef yyleng
  }  if (!yymatchChar(yy, '3')) goto l16;  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l16;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_END)) goto l16;
#undef yytext
#undef yyleng
  }
  }
  l17:;	  yyDo(yy, yy_1_day, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "day", yy->__buf+yy->__pos));
  return 1;
  l16:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "day", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_month(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "month"));
  {  int yypos21= yy->__pos, yythunkpos21= yy->__thunkpos;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_BEGIN)) goto l22;
#undef yytext
#undef yyleng
  }  if (!yymatchChar(yy, '0')) goto l22;  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\376\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l22;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_END)) goto l22;
#undef yytext
#undef yyleng
  }  goto l21;
  l22:;	  yy->__pos= yypos21; yy->__thunkpos= yythunkpos21;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_BEGIN)) goto l20;
#undef yytext
#undef yyleng
  }  if (!yymatchChar(yy, '1')) goto l20;  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\007\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l20;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_END)) goto l20;
#undef yytext
#undef yyleng
  }
  }
  l21:;	  yyDo(yy, yy_1_month, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "month", yy->__buf+yy->__pos));
  return 1;
  l20:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "month", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_year(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "year"));  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_BEGIN)) goto l23;
#undef yytext
#undef yyleng
  }  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l23;  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l23;  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l23;  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l23;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_END)) goto l23;
#undef yytext
#undef yyleng
  }  yyDo(yy, yy_1_year, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "year", yy->__buf+yy->__pos));
  return 1;
  l23:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "year", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_fulldate(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;  yyDo(yy, yyPush, 3, 0);
  yyprintf((stderr, "%s\n", "fulldate"));  if (!yy_year(yy)) goto l24;  yyDo(yy, yySet, -3, 0);  if (!yymatchChar(yy, '-')) goto l24;  if (!yy_month(yy)) goto l24;  yyDo(yy, yySet, -2, 0);  if (!yymatchChar(yy, '-')) goto l24;  if (!yy_day(yy)) goto l24;  yyDo(yy, yySet, -1, 0);  yyDo(yy, yy_1_fulldate, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "fulldate", yy->__buf+yy->__pos));  yyDo(yy, yyPop, 3, 0);
  return 1;
  l24:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "fulldate", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_rfc3339(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "rfc3339"));  if (!yy_fulldate(yy)) goto l25;  if (!yymatchChar(yy, 'T')) goto l25;  if (!yy_fulltime(yy)) goto l25;
  yyprintf((stderr, "  ok   %s @ %s\n", "rfc3339", yy->__buf+yy->__pos));
  return 1;
  l25:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "rfc3339", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_ts_quoted(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "ts_quoted"));
  {  int yypos27= yy->__pos, yythunkpos27= yy->__thunkpos;  if (!yymatchChar(yy, '"')) goto l28;  if (!yy_rfc3339(yy)) goto l28;  if (!yymatchChar(yy, '"')) goto l28;  goto l27;
  l28:;	  yy->__pos= yypos27; yy->__thunkpos= yythunkpos27;  if (!yymatchChar(yy, '\'')) goto l26;  if (!yy_rfc3339(yy)) goto l26;  if (!yymatchChar(yy, '\'')) goto l26;
  }
  l27:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "ts_quoted", yy->__buf+yy->__pos));
  return 1;
  l26:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "ts_quoted", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_zero_to_255(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "zero_to_255"));
  {  int yypos30= yy->__pos, yythunkpos30= yy->__thunkpos;  if (!yymatchChar(yy, '2')) goto l31;  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\077\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l31;  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\077\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l31;  goto l30;
  l31:;	  yy->__pos= yypos30; yy->__thunkpos= yythunkpos30;  if (!yymatchChar(yy, '1')) goto l32;  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l32;  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l32;  goto l30;
  l32:;	  yy->__pos= yypos30; yy->__thunkpos= yythunkpos30;  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\376\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l33;  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l33;  goto l30;
  l33:;	  yy->__pos= yypos30; yy->__thunkpos= yythunkpos30;  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l29;
  }
  l30:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "zero_to_255", yy->__buf+yy->__pos));
  return 1;
  l29:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "zero_to_255", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_index(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "index"));  if (!yymatchChar(yy, '[')) goto l34;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_BEGIN)) goto l34;
#undef yytext
#undef yyleng
  }  if (!yy_zero_to_255(yy)) goto l34;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_END)) goto l34;
#undef yytext
#undef yyleng
  }  if (!yymatchChar(yy, ']')) goto l34;  yyDo(yy, yy_1_index, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "index", yy->__buf+yy->__pos));
  return 1;
  l34:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "index", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_nil(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "nil"));  if (!yymatchString(yy, "NIL")) goto l35;  yyDo(yy, yy_1_nil, yy->__begin, yy->__end);  if (!yy_sp(yy)) goto l35;
  yyprintf((stderr, "  ok   %s @ %s\n", "nil", yy->__buf+yy->__pos));
  return 1;
  l35:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "nil", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_fields(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;  yyDo(yy, yyPush, 2, 0);
  yyprintf((stderr, "%s\n", "fields"));  if (!yymatchString(yy, "Fields[")) goto l36;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_BEGIN)) goto l36;
#undef yytext
#undef yyleng
  }
  l37:;	
  {  int yypos38= yy->__pos, yythunkpos38= yy->__thunkpos;  if (!yymatchClass(yy, (unsigned char *)"\377\377\377\377\377\377\377\377\377\377\377\337\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377")) goto l38;  goto l37;
  l38:;	  yy->__pos= yypos38; yy->__thunkpos= yythunkpos38;
  }  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_END)) goto l36;
#undef yytext
#undef yyleng
  }  if (!yymatchChar(yy, ']')) goto l36;  yyDo(yy, yy_1_fields, yy->__begin, yy->__end);
  {  int yypos39= yy->__pos, yythunkpos39= yy->__thunkpos;  if (!yy_index(yy)) goto l39;  yyDo(yy, yySet, -2, 0);  goto l40;
  l39:;	  yy->__pos= yypos39; yy->__thunkpos= yythunkpos39;
  }
  l40:;	  yyDo(yy, yy_2_fields, yy->__begin, yy->__end);
  {  int yypos41= yy->__pos, yythunkpos41= yy->__thunkpos;  if (!yy_index(yy)) goto l41;  yyDo(yy, yySet, -1, 0);  goto l42;
  l41:;	  yy->__pos= yypos41; yy->__thunkpos= yythunkpos41;
  }
  l42:;	  yyDo(yy, yy_3_fields, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "fields", yy->__buf+yy->__pos));  yyDo(yy, yyPop, 2, 0);
  return 1;
  l36:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "fields", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_exponent(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "exponent"));  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\000\000\040\000\000\000\040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l43;
  {  int yypos44= yy->__pos, yythunkpos44= yy->__thunkpos;  if (!yy_sign(yy)) goto l44;  goto l45;
  l44:;	  yy->__pos= yypos44; yy->__thunkpos= yythunkpos44;
  }
  l45:;	  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l43;
  l46:;	
  {  int yypos47= yy->__pos, yythunkpos47= yy->__thunkpos;  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l47;  goto l46;
  l47:;	  yy->__pos= yypos47; yy->__thunkpos= yythunkpos47;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "exponent", yy->__buf+yy->__pos));
  return 1;
  l43:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "exponent", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_decimal(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "decimal"));  if (!yymatchChar(yy, '.')) goto l48;  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l48;
  l49:;	
  {  int yypos50= yy->__pos, yythunkpos50= yy->__thunkpos;  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l50;  goto l49;
  l50:;	  yy->__pos= yypos50; yy->__thunkpos= yythunkpos50;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "decimal", yy->__buf+yy->__pos));
  return 1;
  l48:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "decimal", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_number(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "number"));
  {  int yypos52= yy->__pos, yythunkpos52= yy->__thunkpos;  if (!yymatchChar(yy, '0')) goto l53;  goto l52;
  l53:;	  yy->__pos= yypos52; yy->__thunkpos= yythunkpos52;  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\376\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l51;
  l54:;	
  {  int yypos55= yy->__pos, yythunkpos55= yy->__thunkpos;  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l55;  goto l54;
  l55:;	  yy->__pos= yypos55; yy->__thunkpos= yythunkpos55;
  }
  }
  l52:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "number", yy->__buf+yy->__pos));
  return 1;
  l51:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "number", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_sign(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "sign"));  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\050\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l56;
  yyprintf((stderr, "  ok   %s @ %s\n", "sign", yy->__buf+yy->__pos));
  return 1;
  l56:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "sign", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_numeric_value(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "numeric_value"));  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_BEGIN)) goto l57;
#undef yytext
#undef yyleng
  }
  {  int yypos58= yy->__pos, yythunkpos58= yy->__thunkpos;  if (!yy_sign(yy)) goto l58;  goto l59;
  l58:;	  yy->__pos= yypos58; yy->__thunkpos= yythunkpos58;
  }
  l59:;	  if (!yy_number(yy)) goto l57;
  {  int yypos60= yy->__pos, yythunkpos60= yy->__thunkpos;  if (!yy_decimal(yy)) goto l60;  goto l61;
  l60:;	  yy->__pos= yypos60; yy->__thunkpos= yythunkpos60;
  }
  l61:;	
  {  int yypos62= yy->__pos, yythunkpos62= yy->__thunkpos;  if (!yy_exponent(yy)) goto l62;  goto l63;
  l62:;	  yy->__pos= yypos62; yy->__thunkpos= yythunkpos62;
  }
  l63:;	  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_END)) goto l57;
#undef yytext
#undef yyleng
  }  yyDo(yy, yy_1_numeric_value, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "numeric_value", yy->__buf+yy->__pos));
  return 1;
  l57:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "numeric_value", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_numeric_headers(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "numeric_headers"));
  {  int yypos65= yy->__pos, yythunkpos65= yy->__thunkpos;  if (!yymatchString(yy, "Severity")) goto l66;  yyDo(yy, yy_1_numeric_headers, yy->__begin, yy->__end);  if (!yy_sp(yy)) goto l66;  goto l65;
  l66:;	  yy->__pos= yypos65; yy->__thunkpos= yythunkpos65;  if (!yymatchString(yy, "Pid")) goto l64;  yyDo(yy, yy_2_numeric_headers, yy->__begin, yy->__end);  if (!yy_sp(yy)) goto l64;
  }
  l65:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "numeric_headers", yy->__buf+yy->__pos));
  return 1;
  l64:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "numeric_headers", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_string_match(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "string_match"));
  {  int yypos68= yy->__pos, yythunkpos68= yy->__thunkpos;  if (!yy_op_seq(yy)) goto l69;  goto l68;
  l69:;	  yy->__pos= yypos68; yy->__thunkpos= yythunkpos68;  if (!yy_op_sne(yy)) goto l67;
  }
  l68:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "string_match", yy->__buf+yy->__pos));
  return 1;
  l67:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "string_match", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_string_value(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "string_value"));
  {  int yypos71= yy->__pos, yythunkpos71= yy->__thunkpos;  if (!yymatchChar(yy, '"')) goto l72;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_BEGIN)) goto l72;
#undef yytext
#undef yyleng
  }
  l73:;	
  {  int yypos74= yy->__pos, yythunkpos74= yy->__thunkpos;
  {  int yypos75= yy->__pos, yythunkpos75= yy->__thunkpos;  if (!yymatchString(yy, "\\\"")) goto l76;  goto l75;
  l76:;	  yy->__pos= yypos75; yy->__thunkpos= yythunkpos75;
  {  int yypos77= yy->__pos, yythunkpos77= yy->__thunkpos;  if (!yymatchChar(yy, '"')) goto l77;  goto l74;
  l77:;	  yy->__pos= yypos77; yy->__thunkpos= yythunkpos77;
  }  if (!yymatchDot(yy)) goto l74;
  }
  l75:;	  goto l73;
  l74:;	  yy->__pos= yypos74; yy->__thunkpos= yythunkpos74;
  }  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_END)) goto l72;
#undef yytext
#undef yyleng
  }  if (!yymatchChar(yy, '"')) goto l72;  goto l71;
  l72:;	  yy->__pos= yypos71; yy->__thunkpos= yythunkpos71;  if (!yymatchChar(yy, '\'')) goto l70;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_BEGIN)) goto l70;
#undef yytext
#undef yyleng
  }
  l78:;	
  {  int yypos79= yy->__pos, yythunkpos79= yy->__thunkpos;
  {  int yypos80= yy->__pos, yythunkpos80= yy->__thunkpos;  if (!yymatchString(yy, "\\\'")) goto l81;  goto l80;
  l81:;	  yy->__pos= yypos80; yy->__thunkpos= yythunkpos80;
  {  int yypos82= yy->__pos, yythunkpos82= yy->__thunkpos;  if (!yymatchChar(yy, '\'')) goto l82;  goto l79;
  l82:;	  yy->__pos= yypos82; yy->__thunkpos= yythunkpos82;
  }  if (!yymatchDot(yy)) goto l79;
  }
  l80:;	  goto l78;
  l79:;	  yy->__pos= yypos79; yy->__thunkpos= yythunkpos79;
  }  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_END)) goto l70;
#undef yytext
#undef yyleng
  }  if (!yymatchChar(yy, '\'')) goto l70;
  }
  l71:;	  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(check_string_len(yytext))) goto l70;
#undef yytext
#undef yyleng
  }  yyDo(yy, yy_1_string_value, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "string_value", yy->__buf+yy->__pos));
  return 1;
  l70:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "string_value", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_string_headers(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "string_headers"));
  {  int yypos84= yy->__pos, yythunkpos84= yy->__thunkpos;  if (!yymatchString(yy, "Type")) goto l85;  yyDo(yy, yy_1_string_headers, yy->__begin, yy->__end);  if (!yy_sp(yy)) goto l85;  goto l84;
  l85:;	  yy->__pos= yypos84; yy->__thunkpos= yythunkpos84;  if (!yymatchString(yy, "Logger")) goto l86;  yyDo(yy, yy_2_string_headers, yy->__begin, yy->__end);  if (!yy_sp(yy)) goto l86;  goto l84;
  l86:;	  yy->__pos= yypos84; yy->__thunkpos= yythunkpos84;  if (!yymatchString(yy, "Hostname")) goto l87;  yyDo(yy, yy_3_string_headers, yy->__begin, yy->__end);  if (!yy_sp(yy)) goto l87;  goto l84;
  l87:;	  yy->__pos= yypos84; yy->__thunkpos= yythunkpos84;  if (!yymatchString(yy, "EnvVersion")) goto l88;  yyDo(yy, yy_4_string_headers, yy->__begin, yy->__end);  if (!yy_sp(yy)) goto l88;  goto l84;
  l88:;	  yy->__pos= yypos84; yy->__thunkpos= yythunkpos84;  if (!yymatchString(yy, "Payload")) goto l89;  yyDo(yy, yy_5_string_headers, yy->__begin, yy->__end);  if (!yy_sp(yy)) goto l89;  goto l84;
  l89:;	  yy->__pos= yypos84; yy->__thunkpos= yythunkpos84;  if (!yymatchString(yy, "Uuid")) goto l83;  yyDo(yy, yy_6_string_headers, yy->__begin, yy->__end);  if (!yy_sp(yy)) goto l83;
  }
  l84:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "string_headers", yy->__buf+yy->__pos));
  return 1;
  l83:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "string_headers", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_boolean(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "boolean"));
  {  int yypos91= yy->__pos, yythunkpos91= yy->__thunkpos;  if (!yy_true(yy)) goto l92;  yyDo(yy, yy_1_boolean, yy->__begin, yy->__end);  goto l91;
  l92:;	  yy->__pos= yypos91; yy->__thunkpos= yythunkpos91;  if (!yy_false(yy)) goto l90;  yyDo(yy, yy_2_boolean, yy->__begin, yy->__end);
  }
  l91:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "boolean", yy->__buf+yy->__pos));
  return 1;
  l90:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "boolean", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_false(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "false"));  if (!yymatchString(yy, "FALSE")) goto l93;  if (!yy_sp(yy)) goto l93;
  yyprintf((stderr, "  ok   %s @ %s\n", "false", yy->__buf+yy->__pos));
  return 1;
  l93:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "false", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_true(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "true"));  if (!yymatchString(yy, "TRUE")) goto l94;  if (!yy_sp(yy)) goto l94;
  yyprintf((stderr, "  ok   %s @ %s\n", "true", yy->__buf+yy->__pos));
  return 1;
  l94:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "true", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_relational(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "relational"));
  {  int yypos96= yy->__pos, yythunkpos96= yy->__thunkpos;  if (!yy_op_eq(yy)) goto l97;  goto l96;
  l97:;	  yy->__pos= yypos96; yy->__thunkpos= yythunkpos96;  if (!yy_op_ne(yy)) goto l98;  goto l96;
  l98:;	  yy->__pos= yypos96; yy->__thunkpos= yythunkpos96;  if (!yy_op_gte(yy)) goto l99;  goto l96;
  l99:;	  yy->__pos= yypos96; yy->__thunkpos= yythunkpos96;  if (!yy_op_gt(yy)) goto l100;  goto l96;
  l100:;	  yy->__pos= yypos96; yy->__thunkpos= yythunkpos96;  if (!yy_op_lte(yy)) goto l101;  goto l96;
  l101:;	  yy->__pos= yypos96; yy->__thunkpos= yythunkpos96;  if (!yy_op_lt(yy)) goto l95;
  }
  l96:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "relational", yy->__buf+yy->__pos));
  return 1;
  l95:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "relational", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_op_lt(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "op_lt"));  if (!yymatchChar(yy, '<')) goto l102;  if (!yy_sp(yy)) goto l102;  yyDo(yy, yy_1_op_lt, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "op_lt", yy->__buf+yy->__pos));
  return 1;
  l102:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "op_lt", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_op_lte(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "op_lte"));  if (!yymatchString(yy, "<=")) goto l103;  if (!yy_sp(yy)) goto l103;  yyDo(yy, yy_1_op_lte, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "op_lte", yy->__buf+yy->__pos));
  return 1;
  l103:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "op_lte", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_op_gt(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "op_gt"));  if (!yymatchChar(yy, '>')) goto l104;  if (!yy_sp(yy)) goto l104;  yyDo(yy, yy_1_op_gt, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "op_gt", yy->__buf+yy->__pos));
  return 1;
  l104:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "op_gt", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_op_gte(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "op_gte"));  if (!yymatchString(yy, ">=")) goto l105;  if (!yy_sp(yy)) goto l105;  yyDo(yy, yy_1_op_gte, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "op_gte", yy->__buf+yy->__pos));
  return 1;
  l105:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "op_gte", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_op_sne(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "op_sne"));  if (!yymatchString(yy, "!~")) goto l106;  if (!yy_sp(yy)) goto l106;  yyDo(yy, yy_1_op_sne, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "op_sne", yy->__buf+yy->__pos));
  return 1;
  l106:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "op_sne", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_op_seq(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "op_seq"));  if (!yymatchString(yy, "=~")) goto l107;  if (!yy_sp(yy)) goto l107;  yyDo(yy, yy_1_op_seq, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "op_seq", yy->__buf+yy->__pos));
  return 1;
  l107:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "op_seq", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_op_ne(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "op_ne"));  if (!yymatchString(yy, "!=")) goto l108;  if (!yy_sp(yy)) goto l108;  yyDo(yy, yy_1_op_ne, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "op_ne", yy->__buf+yy->__pos));
  return 1;
  l108:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "op_ne", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_op_eq(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "op_eq"));  if (!yymatchString(yy, "==")) goto l109;  if (!yy_sp(yy)) goto l109;  yyDo(yy, yy_1_op_eq, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "op_eq", yy->__buf+yy->__pos));
  return 1;
  l109:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "op_eq", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_boolean_test(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "boolean_test"));
  {  int yypos111= yy->__pos, yythunkpos111= yy->__thunkpos;  if (!yy_true(yy)) goto l112;  yyDo(yy, yy_1_boolean_test, yy->__begin, yy->__end);  goto l111;
  l112:;	  yy->__pos= yypos111; yy->__thunkpos= yythunkpos111;  if (!yy_false(yy)) goto l110;  yyDo(yy, yy_2_boolean_test, yy->__begin, yy->__end);
  }
  l111:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "boolean_test", yy->__buf+yy->__pos));
  return 1;
  l110:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "boolean_test", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_ts_test(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "ts_test"));  if (!yymatchString(yy, "Timestamp")) goto l113;  if (!yy_sp(yy)) goto l113;  if (!yy_relational(yy)) goto l113;  if (!yy_sp(yy)) goto l113;
  {  int yypos114= yy->__pos, yythunkpos114= yy->__thunkpos;  if (!yy_numeric_value(yy)) goto l115;  goto l114;
  l115:;	  yy->__pos= yypos114; yy->__thunkpos= yythunkpos114;  if (!yy_ts_quoted(yy)) goto l113;
  }
  l114:;	  yyDo(yy, yy_1_ts_test, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "ts_test", yy->__buf+yy->__pos));
  return 1;
  l113:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "ts_test", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_field_test(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "field_test"));  if (!yy_fields(yy)) goto l116;  if (!yy_sp(yy)) goto l116;
  {  int yypos117= yy->__pos, yythunkpos117= yy->__thunkpos;  if (!yy_relational(yy)) goto l118;  if (!yy_sp(yy)) goto l118;
  {  int yypos119= yy->__pos, yythunkpos119= yy->__thunkpos;  if (!yy_string_value(yy)) goto l120;  goto l119;
  l120:;	  yy->__pos= yypos119; yy->__thunkpos= yythunkpos119;  if (!yy_numeric_value(yy)) goto l118;
  }
  l119:;	  goto l117;
  l118:;	  yy->__pos= yypos117; yy->__thunkpos= yythunkpos117;  if (!yy_string_match(yy)) goto l121;  if (!yy_sp(yy)) goto l121;  if (!yy_string_value(yy)) goto l121;  goto l117;
  l121:;	  yy->__pos= yypos117; yy->__thunkpos= yythunkpos117;
  {  int yypos122= yy->__pos, yythunkpos122= yy->__thunkpos;  if (!yy_op_eq(yy)) goto l123;  goto l122;
  l123:;	  yy->__pos= yypos122; yy->__thunkpos= yythunkpos122;  if (!yy_op_ne(yy)) goto l116;
  }
  l122:;	  if (!yy_sp(yy)) goto l116;
  {  int yypos124= yy->__pos, yythunkpos124= yy->__thunkpos;  if (!yy_boolean(yy)) goto l125;  goto l124;
  l125:;	  yy->__pos= yypos124; yy->__thunkpos= yythunkpos124;  if (!yy_nil(yy)) goto l116;
  }
  l124:;	
  }
  l117:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "field_test", yy->__buf+yy->__pos));
  return 1;
  l116:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "field_test", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_numeric_test(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "numeric_test"));  if (!yy_numeric_headers(yy)) goto l126;  if (!yy_sp(yy)) goto l126;  if (!yy_relational(yy)) goto l126;  if (!yy_sp(yy)) goto l126;  if (!yy_numeric_value(yy)) goto l126;
  yyprintf((stderr, "  ok   %s @ %s\n", "numeric_test", yy->__buf+yy->__pos));
  return 1;
  l126:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "numeric_test", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_string_test(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "string_test"));  if (!yy_string_headers(yy)) goto l127;  if (!yy_sp(yy)) goto l127;
  {  int yypos128= yy->__pos, yythunkpos128= yy->__thunkpos;  if (!yy_relational(yy)) goto l129;  if (!yy_sp(yy)) goto l129;  if (!yy_string_value(yy)) goto l129;  goto l128;
  l129:;	  yy->__pos= yypos128; yy->__thunkpos= yythunkpos128;  if (!yy_string_match(yy)) goto l127;  if (!yy_sp(yy)) goto l127;  if (!yy_string_value(yy)) goto l127;
  }
  l128:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "string_test", yy->__buf+yy->__pos));
  return 1;
  l127:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "string_test", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_close(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "close"));  if (!yymatchChar(yy, ')')) goto l130;  yyDo(yy, yy_1_close, yy->__begin, yy->__end);  if (!yy_sp(yy)) goto l130;
  yyprintf((stderr, "  ok   %s @ %s\n", "close", yy->__buf+yy->__pos));
  return 1;
  l130:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "close", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_open(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "open"));  if (!yymatchChar(yy, '(')) goto l131;  yyDo(yy, yy_1_open, yy->__begin, yy->__end);  if (!yy_sp(yy)) goto l131;
  yyprintf((stderr, "  ok   %s @ %s\n", "open", yy->__buf+yy->__pos));
  return 1;
  l131:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "open", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_test(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "test"));
  {  int yypos133= yy->__pos, yythunkpos133= yy->__thunkpos;  if (!yy_string_test(yy)) goto l134;  goto l133;
  l134:;	  yy->__pos= yypos133; yy->__thunkpos= yythunkpos133;  if (!yy_numeric_test(yy)) goto l135;  goto l133;
  l135:;	  yy->__pos= yypos133; yy->__thunkpos= yythunkpos133;  if (!yy_field_test(yy)) goto l136;  goto l133;
  l136:;	  yy->__pos= yypos133; yy->__thunkpos= yythunkpos133;  if (!yy_ts_test(yy)) goto l137;  goto l133;
  l137:;	  yy->__pos= yypos133; yy->__thunkpos= yythunkpos133;  if (!yy_boolean_test(yy)) goto l132;
  }
  l133:;	  yyDo(yy, yy_1_test, yy->__begin, yy->__end);  if (!yy_sp(yy)) goto l132;
  yyprintf((stderr, "  ok   %s @ %s\n", "test", yy->__buf+yy->__pos));
  return 1;
  l132:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "test", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_and(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "and"));  if (!yymatchString(yy, "&&")) goto l138;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(cond_cnt(&yy->ctx))) goto l138;
#undef yytext
#undef yyleng
  }  yyDo(yy, yy_1_and, yy->__begin, yy->__end);  if (!yy_sp(yy)) goto l138;
  yyprintf((stderr, "  ok   %s @ %s\n", "and", yy->__buf+yy->__pos));
  return 1;
  l138:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "and", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_expr(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "expr"));
  {  int yypos140= yy->__pos, yythunkpos140= yy->__thunkpos;  if (!yy_test(yy)) goto l141;  goto l140;
  l141:;	  yy->__pos= yypos140; yy->__thunkpos= yythunkpos140;  if (!yy_open(yy)) goto l139;  if (!yy_ored(yy)) goto l139;  if (!yy_close(yy)) goto l139;
  }
  l140:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "expr", yy->__buf+yy->__pos));
  return 1;
  l139:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "expr", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_or(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "or"));  if (!yymatchString(yy, "||")) goto l142;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(cond_cnt(&yy->ctx))) goto l142;
#undef yytext
#undef yyleng
  }  yyDo(yy, yy_1_or, yy->__begin, yy->__end);  if (!yy_sp(yy)) goto l142;
  yyprintf((stderr, "  ok   %s @ %s\n", "or", yy->__buf+yy->__pos));
  return 1;
  l142:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "or", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_anded(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "anded"));  if (!yy_expr(yy)) goto l143;
  l144:;	
  {  int yypos145= yy->__pos, yythunkpos145= yy->__thunkpos;  if (!yy_and(yy)) goto l145;  if (!yy_expr(yy)) goto l145;  goto l144;
  l145:;	  yy->__pos= yypos145; yy->__thunkpos= yythunkpos145;
  }  if (!yy_sp(yy)) goto l143;
  yyprintf((stderr, "  ok   %s @ %s\n", "anded", yy->__buf+yy->__pos));
  return 1;
  l143:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "anded", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_eol(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "eol"));
  {  int yypos147= yy->__pos, yythunkpos147= yy->__thunkpos;  if (!yymatchDot(yy)) goto l147;  goto l146;
  l147:;	  yy->__pos= yypos147; yy->__thunkpos= yythunkpos147;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "eol", yy->__buf+yy->__pos));
  return 1;
  l146:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "eol", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_ored(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "ored"));  if (!yy_anded(yy)) goto l148;
  l149:;	
  {  int yypos150= yy->__pos, yythunkpos150= yy->__thunkpos;  if (!yy_or(yy)) goto l150;  if (!yy_anded(yy)) goto l150;  goto l149;
  l150:;	  yy->__pos= yypos150; yy->__thunkpos= yythunkpos150;
  }  if (!yy_sp(yy)) goto l148;
  yyprintf((stderr, "  ok   %s @ %s\n", "ored", yy->__buf+yy->__pos));
  return 1;
  l148:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "ored", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_sp(yycontext *yy)
{
  yyprintf((stderr, "%s\n", "sp"));
  l152:;	
  {  int yypos153= yy->__pos, yythunkpos153= yy->__thunkpos;  if (!yymatchClass(yy, (unsigned char *)"\000\002\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l153;  goto l152;
  l153:;	  yy->__pos= yypos153; yy->__thunkpos= yythunkpos153;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "sp", yy->__buf+yy->__pos));
  return 1;
}
YY_RULE(int) yy_match(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "match"));  if (!yy_sp(yy)) goto l154;  if (!yy_ored(yy)) goto l154;  if (!yy_eol(yy)) goto l154;  yyDo(yy, yy_1_match, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "match", yy->__buf+yy->__pos));
  return 1;
  l154:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "match", yy->__buf+yy->__pos));
  return 0;
}

#ifndef YY_PART

typedef int (*yyrule)(yycontext *yy);

YY_PARSE(int) YYPARSEFROM(YY_CTX_PARAM_ yyrule yystart)
{
  int yyok;
  if (!yyctx->__buflen)
    {
      yyctx->__buflen= YY_BUFFER_SIZE;
      yyctx->__buf= (char *)YY_MALLOC(yyctx, yyctx->__buflen);
      yyctx->__textlen= YY_BUFFER_SIZE;
      yyctx->__text= (char *)YY_MALLOC(yyctx, yyctx->__textlen);
      yyctx->__thunkslen= YY_STACK_SIZE;
      yyctx->__thunks= (yythunk *)YY_MALLOC(yyctx, sizeof(yythunk) * yyctx->__thunkslen);
      yyctx->__valslen= YY_STACK_SIZE;
      yyctx->__vals= (YYSTYPE *)YY_MALLOC(yyctx, sizeof(YYSTYPE) * yyctx->__valslen);
      memset(yyctx->__vals, 0, sizeof(YYSTYPE) * yyctx->__valslen);
      yyctx->__begin= yyctx->__end= yyctx->__pos= yyctx->__limit= yyctx->__thunkpos= 0;
    }
  yyctx->__begin= yyctx->__end= yyctx->__pos;
  yyctx->__thunkpos= 0;
  yyctx->__val= yyctx->__vals;
  yyok= yystart(yyctx);
  if (yyok) yyDone(yyctx);
  yyCommit(yyctx);
  return yyok;
}

YY_PARSE(int) YYPARSE(YY_CTX_PARAM)
{
  return YYPARSEFROM(YY_CTX_ARG_ yy_match);
}

YY_PARSE(yycontext *) YYRELEASE(yycontext *yyctx)
{
  if (yyctx->__buflen)
    {
      yyctx->__buflen= 0;
      YY_FREE(yyctx, yyctx->__buf);
      YY_FREE(yyctx, yyctx->__text);
      YY_FREE(yyctx, yyctx->__thunks);
      YY_FREE(yyctx, yyctx->__vals);
    }
  return yyctx;
}

#endif



lsb_message_matcher* lsb_create_message_matcher(const char *exp)
{
  if (!exp) {
    return NULL;
  }

  lsb_message_matcher *mm = NULL;
  yycontext yy;
  memset(&yy, 0, sizeof(yy));
  yy.ctx.is.s = exp;
  yy.ctx.is.size = strlen(exp);
  int ret = yyparse(&yy);
  if (!ret) {
    free(yy.ctx.out.a);
    goto cleanup;
  }

  // reverse the order so the root node will be first
  match_node *s = yy.ctx.out.a;
  match_node *e = yy.ctx.out.a + yy.ctx.out.pos;
  for (--e; s < e; ++s, --e) {
    move_match_node(&yy.ctx.mn, s);
    move_match_node(s, e);
    move_match_node(e, &yy.ctx.mn);
  }

  mm = malloc(sizeof(lsb_message_matcher));
  if (!mm) {
    goto cleanup;
  }
  mm->nodes = yy.ctx.out.a;
  mm->nodes[0].size = yy.ctx.out.pos;

  // turn the postfix stack into an executable tree
  match_node **stack = calloc(sizeof(match_node *) * mm->nodes[0].size, 1);
  if (!stack) {
    free(mm);
    mm = NULL;
    goto cleanup;
  }

  int top = 0;
  for (int i = mm->nodes[0].size - 1; i >= 0; --i) {
    if (mm->nodes[i].op != OP_AND && mm->nodes[i].op != OP_OR) {
      stack[top++] = &mm->nodes[i];
    } else {
      mm->nodes[i].ai = stack[--top] - mm->nodes;
      mm->nodes[i].fi = stack[--top] - mm->nodes;
      stack[top++] = &mm->nodes[i];
    }
  }
  free(stack);

cleanup:
  free(yy.ctx.ops.a);
  yyrelease(&yy);
  return mm;
}

