// -*- c++ -*-
// Generated by assa-genesis
//------------------------------------------------------------------------------
// $Id: common_utils_test.cpp,v 1.10 2012/05/23 02:52:25 vlg Exp $
//------------------------------------------------------------------------------
//                            CommonUtils_test.cpp
//------------------------------------------------------------------------------
//  Copyright (c) 2002-2003,2005 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version
//  2 of the License, or (at your option) any later version.
//
// Date   : Sat Oct  5 12:53:20 2002
//------------------------------------------------------------------------------
static const char help_msg[]=
"                                                                            \n"
" NAME:                                                                      \n"
"                                                                            \n"
"   common_utils_test                                                        \n"
"                                                                            \n"
" DESCRIPTION:                                                               \n"
"                                                                            \n"
"  Test for class CommonUtils.                                               \n"
"                                                                            \n"
" USAGE:                                                                     \n"
"                                                                            \n"
"   shell>  common_utils_test                                                \n"
"                                                                            \n"
" OPTIONS:                                                                   \n"
"                                                                            \n"
" -D, --log-file NAME     - Log file name                                    \n"
" -d, --log-stdout        - Log messages to standard output (default)        \n"
" -m, --mask              - Log mask                                         \n"
" -h, --help              - Print this messag                                \n"
" -v, --version           - Print version number                            \n";
//------------------------------------------------------------------------------

#ifdef HAVE_CONFIG_H
#    include "config.h"
#endif

#include <stdlib.h>				// setenv(3)
#include <string>
using std::string;

#include <assa/GenServer.h>
#include <assa/Singleton.h>
#include <assa/TimeVal.h>
#include <assa/MemDump.h>
#include <assa/CommonUtils.h>

using namespace ASSA;

enum { TEST = USR1 };
static const int OVERWRITE = 1;


class CommonUtils_test :
    public GenServer,
    public Singleton<CommonUtils_test>
{
public:
    CommonUtils_test ();

    virtual void init_service ();
    virtual void process_events ();
};

/* Useful definitions */

#define COMMONUTILS_TEST CommonUtils_test::get_instance()
#define REACTOR COMMONUTILS_TEST->get_reactor()

// Static declarations mandated by Singleton class
ASSA_DECL_SINGLETON(CommonUtils_test);

CommonUtils_test::
CommonUtils_test ()
{
    // ---Debugging---
    rm_opt ('z', "log-size"     );

    // ---Configuration---
    rm_opt ('f', "config-file"  );
    rm_opt ('n', "instance"     );
    rm_opt ('p', "port"         );

    // ---Process bookkeeping---
    rm_opt ('b', "daemon"       );
    rm_opt ('l', "pidfile"      );
    rm_opt ('L', "ommit-pidfile");

    /*---
     * Disable all debugging
     *---*/
    m_mask = TEST;
	m_log_file = "common_utils.log";
	m_log_stdout = "yes";
}


int
main (int argc, char* argv[])
{
    static const char release[] = "1.1";
    int patch_level = 0;

    COMMONUTILS_TEST->set_version (release, patch_level);
    COMMONUTILS_TEST->set_author  ("Vladislav Grinchenko");

    COMMONUTILS_TEST->init (&argc, argv, help_msg);

    COMMONUTILS_TEST->init_service ();
    COMMONUTILS_TEST->process_events ();

    return COMMONUTILS_TEST->get_exit_value ();
}

void
CommonUtils_test::
init_service ()
{
    Log::disable_timestamp ();
}

void
CommonUtils_test::
process_events ()
{
	//=================================================================
	DL((TEST, "Testing split () ...\n"));

	//	Separator: blank, tab, newline, formfeed, and carriage return.

	std::ostringstream oss;

	oss << "peaches" << ' '
		<< "roses"   << '\t'	// tab
		<< "beer"    << '\n'	// newline
		<< "bread"   << '\f'	// formfeed
		<< "butter"  << '\r'	// carriage return
		<< "friendship"
		<< std::ends;

	MemDump::dump_to_log (TEST, "Test string:",
						  oss.str ().c_str (), oss.str ().size ()-1);
	vector<string> vs;
	ASSA::Utils::split (oss.str ().c_str (), vs);

	if (vs.size () != 6) {
		set_exit_value (1);
		DL((TEST, "split() test failed\n"));
		return;
	}
	vector<string>::const_iterator cit = vs.begin ();
	while (cit != vs.end ()) {
		DL ((TEST,"%s\n", (*cit).c_str ()));
		cit++;
	}
	DL((TEST,"split() test passed\n"));

	//=================================================================
	DL((TEST,"\nTesting split_pair() ...\n"));
	string line ("ignorance=strength");
	string bad_line ("love piece");
	string lhs;
	string rhs;

	if (ASSA::Utils::split_pair (line, '=', lhs, rhs) < 0 ||
		lhs != "ignorance" || rhs != "strength")
	{
		set_exit_value (1);
		DL((TEST, "split_pair() test failed\n"));
		return;
	}

	if (ASSA::Utils::split_pair (bad_line, '=', lhs, rhs) == 0) {
		set_exit_value (1);
		DL((TEST, "split_pair() test failed\n"));
		return;
	}

	DL((TEST,"split_pair() test passed\n"));

	//=================================================================
	DL((TEST,"\nTesting [lr]trim() ...\n"));

	string sect_name ("[Default]");

	if (ASSA::Utils::ltrim (sect_name, "[") < 0 ||
		ASSA::Utils::rtrim (sect_name, "]") < 0 ||
		sect_name != "Default")
	{
		set_exit_value (1);
		DL((TEST, "[lr]trim() test failed\n"));
		DL((TEST, "\"Default\" != \"%s\"\n", sect_name.c_str ()));
		return;
	}

	DL((TEST,"[lr]trim() test passed\n"));

	//=================================================================
	DL((TEST,"\nTesting trim_sides() ...\n"));
	string option ("  mute  = \t true  ");

	if (ASSA::Utils::split_pair (option, '=', lhs, rhs) < 0) {
		set_exit_value (1);
		DL((TEST, "trim_sides() test failed\n"));
		return;
	}

	ASSA::Utils::trim_sides (lhs);
	ASSA::Utils::trim_sides (rhs);

	if (lhs != "mute" || rhs != "true") {
		set_exit_value (1);
		DL((TEST, "trim_sides() test failed\n"));
		DL((TEST, "lhs = \"%s\" (expected: \"mute\")\n", lhs.c_str ()));
		DL((TEST, "rhs = \"%s\" (expected: \"true\")\n", rhs.c_str ()));
		return;
	}


	DL((TEST,"trim_sides() test passed\n"));

	//=================================================================
	DL((TEST,"\nTesting strenv() ...\n"));

	::putenv ((char*) "AUTHOR=Vladislav Grinchenko");
	::putenv ((char*) "PROJECT=ASSA Library");

	string source ("$PROJECT is written by $AUTHOR");

	string expanded = ASSA::Utils::strenv (source.c_str ());

	if (expanded != "ASSA Library is written by Vladislav Grinchenko") {
		set_exit_value (1);
		DL((TEST, "setenv() test failed\n"));
		return;
	}

	m_default_config_file = "$HOME/.gnome/" + this->get_cmdline_name ();
	m_default_config_file = Utils::strenv (m_default_config_file.c_str ());

	string expected = ::getenv ("HOME");
	expected += "/.gnome/common_utils_test";

	if (expected != m_default_config_file) {
		set_exit_value (1);
		DL((TEST, "setenv() test failed\n"));
		DL((TEST,"expected: \"%s\"\n", expected.c_str ()));
		DL((TEST,"actual:   \"%s\"\n", m_default_config_file.c_str ()));
		return;
	}

	DL((TEST,"setenv() test passed\n"));
    m_reactor.stopReactor ();
}

