/***************************************************************************
                           dclib.cpp  -  description
                             -------------------
    begin                : Mon May 5 2003
    copyright            : (C) 2002-2003 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dclib.h"

#include "dclib-ssl-use.h"

#include "core/cxml.h"
#include "core/cssl.h"
#include "core/csocket.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_SOCKS
extern "C" {
#include <socks.h>
}
#endif

static time_t sdclibUptime = time(0);
static int sdclibVerbose = 0;

/** initialise used libraries */
#ifdef HAVE_SOCKS
extern "C" void dclibInitDepLibs( char * argv0 )
#else
extern "C" void dclibInitDepLibs( char * /* argv0 */ )
#endif
{
#ifdef HAVE_SOCKS
	SOCKSinit(argv0);
#endif
	CXml::InitParser();
	CSSL::InitSSLLibrary();
	
	/*
	 * Any error is not checked, if WinSock2 doesn't startup nothing
	 * network related will work, and probably all that can be done
	 * is abort().
	 */
	CSocket::SysInit();
}

/** cleanup used libraries */
extern "C" void dclibDeInitDepLibs()
{
	/* the reverse order to the startup makes sense */
	CSocket::SysDeInit();
	CSSL::DeInitSSLLibrary();
	CXml::CleanupParser();
}

/** get dclib start time */
extern "C" time_t dclibUptime()
{
	return sdclibUptime;
}

/** get dclib version string */
extern "C" const char * dclibVersion()
{
	return DCLIB_VERSION_STRING;
}

/** get dclib build data and if svn, the revision */
extern "C" const char * dclibBuildInfo()
{
	return DCLIB_BUILD_INFO;
}

/** get dclib verbose setting */
extern "C" int dclibVerbose()
{
	return sdclibVerbose;
}

/**  set dclib verbose */
extern "C" void setdclibVerbose( int n )
{
	sdclibVerbose = n;
}

/** get SSL support */
extern "C" bool dclibSupportsSSL()
{
	return (DCLIB_HAS_SSL == 1);
}
