// CONSTRAINT.H : the constraint-related classes.

// Copyright (C) 2006 Donald Curtis, Tommi Hassinen.

// This package is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this package; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

/*################################################################################################*/

#ifndef CONSTRAINT_H
#define CONSTRAINT_H

#include "libghemicaldefine.h"

/*################################################################################################*/

class atom;	// atom.h

#include "typedef.h"

#include <list>
#include <vector>
using namespace std;

/*################################################################################################*/

class constraint_dst
{
	public:		// TODO : not properly divided in public/protected data.
	
	enum type { Disabled = 0, MinOnly = 1, MaxOnly = 2, MinAndMax = 3 };
	
	atom * atmr[2];
	
	private:
	
	constraint_dst::type tp;
	bool skip_MM_nb;
	
	float mindist;
	float minFC;
	
	float maxdist;
	float maxFC;
	
// A temporary variable used when creating molecular mechanics energy terms.
// This variable is not otherwise used or initialized, and it is not saved.
	
	public:
	
	constraint_dst(atom *, atom *);
	~constraint_dst(void);
	
	bool operator==(const constraint_dst &) const;
	
	void SetType(constraint_dst::type);
	void SetSkipMMnb(bool);
	void SetMinDist(float);
	void SetMinFC(float);
	void SetMaxDist(float);
	void SetMaxFC(float);
	
	constraint_dst::type GetType(void) const;
	bool GetSkipMMnb(void) const;
	float GetMinDist(void) const;
	float GetMinFC(void) const;
	float GetMaxDist(void) const;
	float GetMaxFC(void) const;
};

/*################################################################################################*/

typedef list<constraint_dst>::iterator iter_CDl;	// CDl = constraint_dst list

/*################################################################################################*/

#endif	// CONSTRAINT_H

// eof
