#include "osl/container/pieceMask.h"
#include "osl/piece.h"
#include <boost/static_assert.hpp>
#include <iostream>
#include <iomanip>
#include <bitset>

BOOST_STATIC_ASSERT(sizeof(osl::PieceMask) == 8);

#ifndef MINIMAL
std::ostream& osl::container::operator<<(std::ostream& os,const PieceMask& pieceMask){
#if OSL_WORDSIZE == 64
  os << '(' << std::setbase(16) << std::setfill('0') 
	    << std::setw(12) << pieceMask.getMask(0).value()
	    << std::setbase(10) << ')';
#elif OSL_WORDSIZE == 32
  os << '(' << std::setbase(16) << std::setfill('0') 
	    << std::setw(4) << pieceMask.getMask(1).value()
	    << std::setw(8) << pieceMask.getMask(0).value() << std::setbase(10) << ')';
#endif
  os << std::bitset<64>(pieceMask.getMask(0).value());
  return os;
}
#endif
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
