/* pool_allocator.cc
 */
#include "osl/stl/pool_allocator.h"
#include <stdexcept>
#include <iostream>

#ifdef USE_TBB_SCALABLE_ALLOCATOR
const int osl::stl::pool_allocator_type=-1;
#elif defined USE_GPL_POOL_ALLOCATOR
// obsolete but placed here to identify old binary
const int osl::stl::pool_allocator_type=1;
#elif defined USE_BOOST_POOL_ALLOCATOR
const int osl::stl::pool_allocator_type=2;
#else
const int osl::stl::pool_allocator_type=0;
#endif

osl::stl::
ConsistencyCheck::ConsistencyCheck(int value)
{
  if (value != pool_allocator_type)
  {
    const char *error = "compile option error! POOL_ALLOCATOR inconsistency";
    std::cerr << error << "\n";
    std::cerr << value << " != " << pool_allocator_type << "\n";
    throw std::logic_error(error);
  }
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
