/*
 * 
 */
#include "osl/record/csaRecord.h"
#include "osl/state/numEffectState.h"
#include "osl/effect_util/effectUtil.h"

#include <boost/foreach.hpp>
#include <fstream>
#include <iostream>
#include <cstdlib>
#include <cctype>
#include <unistd.h>

using namespace osl;

void usage(const char *prog)
{
  using namespace std;
  cerr << "Usage: " << prog << " csa-filenames "
       << endl;
  // kisenファイル と csaファイル を再生
  exit(1);
}

int main(int argc, char **argv)
{
  try {
    nice(20);
      
    //次に CSAファイルを処理
    for (int i=1; i<argc; ++i) {
      CsaFile file(argv [i]);
      const vector<Move> moves=file.getRecord().getMoves();
      NumEffectState state((SimpleState(HIRATE)));
      BOOST_FOREACH(Move m, moves)
	state.makeMove(m);
      std::string new_name = std::string("tmp/")+argv[i];
      std::ofstream os(new_name.c_str());
      os << state;
    }
  }
  catch (std::exception& e) {
    std::cerr << e.what() << "\n";
    return 1;
  }
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
