#include "osl/search/lRUMoves.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

namespace osl
{
  namespace search
  {
class LRUMovesTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(LRUMovesTest);
  CPPUNIT_TEST(testSetMove);
  CPPUNIT_TEST_SUITE_END();
public:
  void testSetMove();
};
  } // namespace search
} // namespace osl

CPPUNIT_TEST_SUITE_REGISTRATION(osl::search::LRUMovesTest);

void osl::search::LRUMovesTest::testSetMove()
{
  LRUMoves moves;
  CPPUNIT_ASSERT_EQUAL(Move::INVALID(), moves[0]);
  CPPUNIT_ASSERT_EQUAL(Move::INVALID(), moves[1]);

  const Move m24ki(Square(2,4), GOLD, BLACK);
  moves.setMove(m24ki);
  CPPUNIT_ASSERT_EQUAL(m24ki, moves[0]);
  CPPUNIT_ASSERT_EQUAL(Move::INVALID(), moves[1]);

  const Move m24fu(Square(2,4), PAWN, BLACK);
  moves.setMove(m24fu);
  CPPUNIT_ASSERT_EQUAL(m24fu, moves[0]);
  CPPUNIT_ASSERT_EQUAL(m24ki, moves[1]);

  moves.setMove(m24fu);
  CPPUNIT_ASSERT_EQUAL(m24fu, moves[0]);
  CPPUNIT_ASSERT_EQUAL(m24ki, moves[1]);
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
