/******************************************************************************
 * THIS FILE IS GENERATED - ANY EDITS WILL BE OVERWRITTEN
 */

#pragma once

#include "jobs/basejob.h"

#include <QtCore/QVector>
#include "csapi/definitions/wellknown/full.h"
#include "csapi/definitions/user_identifier.h"
#include "converters.h"

namespace QMatrixClient
{
    // Operations

    /// Get the supported login types to authenticate users
    ///
    /// Gets the homeserver's supported login types to authenticate users. Clients
    /// should pick one of these and supply it as the ``type`` when logging in.
    class GetLoginFlowsJob : public BaseJob
    {
        public:
            // Inner data structures

            /// Gets the homeserver's supported login types to authenticate users. Clients
            /// should pick one of these and supply it as the ``type`` when logging in.
            struct LoginFlow
            {
                /// The login type. This is supplied as the ``type`` when
                /// logging in.
                QString type;
            };

            // Construction/destruction

            explicit GetLoginFlowsJob();

            /*! Construct a URL without creating a full-fledged job object
             *
             * This function can be used when a URL for
             * GetLoginFlowsJob is necessary but the job
             * itself isn't.
             */
            static QUrl makeRequestUrl(QUrl baseUrl);

            ~GetLoginFlowsJob() override;

            // Result properties

            /// The homeserver's supported login types
            const QVector<LoginFlow>& flows() const;

        protected:
            Status parseJson(const QJsonDocument& data) override;

        private:
            class Private;
            QScopedPointer<Private> d;
    };

    /// Authenticates the user.
    ///
    /// Authenticates the user, and issues an access token they can
    /// use to authorize themself in subsequent requests.
    /// 
    /// If the client does not supply a ``device_id``, the server must
    /// auto-generate one.
    /// 
    /// The returned access token must be associated with the ``device_id``
    /// supplied by the client or generated by the server. The server may
    /// invalidate any access token previously associated with that device. See
    /// `Relationship between access tokens and devices`_.
    class LoginJob : public BaseJob
    {
        public:
            /*! Authenticates the user.
             * \param type
             *   The login type being used.
             * \param identifier
             *   Identification information for the user.
             * \param password
             *   Required when ``type`` is ``m.login.password``. The user's
             *   password.
             * \param token
             *   Required when ``type`` is ``m.login.token``. Part of `Token-based`_ login.
             * \param deviceId
             *   ID of the client device. If this does not correspond to a
             *   known client device, a new device will be created. The server
             *   will auto-generate a device_id if this is not specified.
             * \param initialDeviceDisplayName
             *   A display name to assign to the newly-created device. Ignored
             *   if ``device_id`` corresponds to a known device.
             * \param user
             *   The fully qualified user ID or just local part of the user ID, to log in.  Deprecated in favour of ``identifier``.
             * \param medium
             *   When logging in using a third party identifier, the medium of the identifier. Must be 'email'.  Deprecated in favour of ``identifier``.
             * \param address
             *   Third party identifier for the user.  Deprecated in favour of ``identifier``.
             */
            explicit LoginJob(const QString& type, const Omittable<UserIdentifier>& identifier = none, const QString& password = {}, const QString& token = {}, const QString& deviceId = {}, const QString& initialDeviceDisplayName = {}, const QString& user = {}, const QString& medium = {}, const QString& address = {});
            ~LoginJob() override;

            // Result properties

            /// The fully-qualified Matrix ID that has been registered.
            const QString& userId() const;
            /// An access token for the account.
            /// This access token can then be used to authorize other requests.
            const QString& accessToken() const;
            /// The server_name of the homeserver on which the account has
            /// been registered.
            /// 
            /// **Deprecated**. Clients should extract the server_name from
            /// ``user_id`` (by splitting at the first colon) if they require
            /// it. Note also that ``homeserver`` is not spelt this way.
            const QString& homeServer() const;
            /// ID of the logged-in device. Will be the same as the
            /// corresponding parameter in the request, if one was specified.
            const QString& deviceId() const;
            /// Optional client configuration provided by the server. If present,
            /// clients SHOULD use the provided object to reconfigure themselves,
            /// optionally validating the URLs within. This object takes the same
            /// form as the one returned from .well-known autodiscovery.
            const Omittable<DiscoveryInformation>& wellKnown() const;

        protected:
            Status parseJson(const QJsonDocument& data) override;

        private:
            class Private;
            QScopedPointer<Private> d;
    };
} // namespace QMatrixClient
