# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_set_algorithm import DataSetAlgorithm


class ExtractParticlesOverTime(DataSetAlgorithm):
    r"""
    ExtractParticlesOverTime - Extract particles that goes through a
    given volumic data set.
    
    Superclass: DataSetAlgorithm
    
    ExtractParticlesOverTime extracts particles (points) from the
    first input that goes through the volume of the second input by
    iterating over time. Both inputs should be DataSet objects. The
    first input should be temporal (i.e contains time steps), and the
    second one should be a volumic dataset (i.e contains 3D cells).
    
    The output is a DataSet that contains points which are subsets of
    the first input. The points move over time the same way the first
    input does.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkExtractParticlesOverTime, obj, update, **traits)
    
    id_channel_array = traits.String('', enter_set=True, auto_set=False, desc=\
        r"""
        Specify the name of a scalar array which will be used to fetch
        the index of each point. This is necessary only if the particles
        change position (Id order) on each time step. The Id can be used
        to identify particles at each step and hence track them properly.
        If this array is nullptr, the global point ids are used.  If an
        Id array cannot otherwise be found, the point index is used as
        the ID.
        """
    )

    def _id_channel_array_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetIdChannelArray,
                        self.id_channel_array)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        Get the input data object. This method is not recommended for
        use, but lots of old style filters use it.
        """
    )

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('id_channel_array', 'GetIdChannelArray'), ('progress_text',
    'GetProgressText'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'id_channel_array', 'object_name',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ExtractParticlesOverTime, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ExtractParticlesOverTime properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['id_channel_array', 'object_name']),
            title='Edit ExtractParticlesOverTime properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ExtractParticlesOverTime properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

