# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.pass_input_type_algorithm import PassInputTypeAlgorithm


class OverlappingCellsDetector(PassInputTypeAlgorithm):
    r"""
    OverlappingCellsDetector - Exposes how many cells each cell of the
    input collide.
    
    Superclass: PassInputTypeAlgorithm
    
    This filter performs a cell collision detection between the cells of
    the input. This detection takes the form of a cell array of double.
    Its name can be reached from the static string attribute
    OverlappingCellsDetector::NumberOfOverlapsPerCell.
    
    To detect collisions, coarse bounding spheres are estimated for each
    cell of the input. The center of those spheres is stored in a point
    cloud which is used to find potential colliding cells candidates,
    querying with twice the bounding sphere radius to ensure we do not
    miss other bouding sphere centers. Duplicate intersections might
    appear during this process, so a sphere id map is stored to avoid
    adding already added overlapping cell ids.
    
    This filter works in a multi-process environment. When so, each cell
    of the input whose bounding sphere and bounding box intersects
    another process is added in a temporary `vtkunstructured_grid` being
    sent to this process. Cell collision is then performed, and the
    collision id map is sent back. This map is then read to look if any
    of those cells were not already counted (local process could have
    spotted the same collision from the cells sent by the other process
    indeed). One cell id collision map is stored per neighbor process to
    avoid cell id collision.
    
    The user can set a `Tolerance` parameter. It is set by default to
    zero. When it is equal to zero or is lower to floating point
    precision, then floating point precision is used to compute cell
    overlaps. If it is not set to zero, then each cells are deflated by
    `0.5 * Tolerance` before the overlaps are computed. The deflation is
    computed using `Cell::Inflate` with a negative parameter.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOverlappingCellsDetector, obj, update, **traits)
    
    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        r"""
        
        """
    )

    number_of_overlaps_per_cell_array_name = traits.String('NumberOfOverlapsPerCell', enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _number_of_overlaps_per_cell_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfOverlapsPerCellArrayName,
                        self.number_of_overlaps_per_cell_array_name)

    tolerance = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTolerance,
                        self.tolerance)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        Get the input data object. This method is not recommended for
        use, but lots of old style filters use it.
        """
    )

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('number_of_overlaps_per_cell_array_name',
    'GetNumberOfOverlapsPerCellArrayName'), ('tolerance', 'GetTolerance'),
    ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'number_of_overlaps_per_cell_array_name',
    'object_name', 'progress_text', 'tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OverlappingCellsDetector, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OverlappingCellsDetector properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['number_of_overlaps_per_cell_array_name',
            'object_name', 'tolerance']),
            title='Edit OverlappingCellsDetector properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OverlappingCellsDetector properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

