{-DHUN| module storing information on image licensing on wikipedia wikimedia commons and so on. DHUN-}
module Licenses where
 
{-DHUN| a map (written as list) to map an url to a license to an abbriviated text of the license. In contrast to the map minlicenses in this module the presence of a leading http: is optional DHUN-}
 
licenses :: [(String, String)]
licenses = minlicenses ++ (map go minlicenses)
  where  
        go :: (String, String) -> (String, String)
        go (x, y) = ((drop 5) x, y)
 
{-DHUN| a map (written as list) to map an url to a license to an abbriviated text of the license DHUN-}
 
minlicenses :: [(String, String)]
minlicenses
  = [("http://en.wikipedia.org/wiki/public_domain", "PD"),
     ("https://en.wikipedia.org/wiki/Public_domain", "PD"),
     ("https://de.wikibooks.org/wiki/GNU_Freie_Dokumentationslizenz", "GFDL"),
     ("https://de.wikipedia.org/wiki/GNU-Lizenz_f%C3%BCr_freie_Dokumentation", "GFDL"),
     ("https://de.wikipedia.org/wiki/GNU-Lizenz_für_freie_Dokumentation", "GFDL"),

     ("http://en.wikipedia.org/wiki/en:GNU_Free_Documentation_License",
      "GFDL"),
     ("http://en.wikipedia.org/wiki/en:GNU_General_Public_License",
      "GPL"),
     ("http://de.wikipedia.org/wiki/GNU_General_Public_License",
      "GPL"),
     ("http://de.wikipedia.org/wiki/Gemeinfreiheit", "PD"),
     ("http://en.wikipedia.org/wiki/de:Gemeinfreiheit", "PD"),
     ("http://de.wikipedia.org/wiki/Gemeinfreiheit", "PD"),
     ("http://en.wikipedia.org/wiki/en:GNU_Lesser_General_Public_License",
      "LGPL"),
     ("http://creativecommons.org/licenses/by/3.0/deed.en",
      "CC-BY-3.0"),
     ("http://creativecommons.org/licenses/by/3.0/au/deed.en",
      "CC-BY-3.0"),
     ("http://creativecommons.org/licenses/by/3.0/de/deed.en",
      "CC-BY-3.0"),
     ("http://creativecommons.org/licenses/by/3.0/it/deed.en",
      "CC-BY-3.0"),
     ("http://creativecommons.org/licenses/by/3.0/nl/deed.en",
      "CC-BY-3.0"),
     ("http://creativecommons.org/licenses/by/3.0/nz/deed.en",
      "CC-BY-3.0"),
     ("http://creativecommons.org/licenses/by/3.0/pt/deed.en",
      "CC-BY-3.0"),
     ("http://creativecommons.org/licenses/by/3.0/ro/deed.en",
      "CC-BY-3.0"),
     ("http://creativecommons.org/licenses/by/3.0/us/deed.en",
      "CC-BY-3.0"),
     ("http://creativecommons.org/licenses/by-sa/3.0/deed.en",
      "CC-BY-SA-3.0"),
     ("http://creativecommons.org/licenses/by-sa/3.0/deed.de",
      "CC-BY-SA-3.0"),
     ("https://creativecommons.org/licenses/by-sa/3.0/deed.de",
      "CC-BY-SA-3.0"),
     ("http://creativecommons.org/licenses/by-sa/3.0/cr/deed.en",
      "CC-BY-SA-3.0"),
     ("http://creativecommons.org/licenses/by-sa/3.0/de/deed.en",
      "CC-BY-SA-3.0"),
     ("http://creativecommons.org/licenses/by-sa/3.0/it/deed.en",
      "CC-BY-SA-3.0"),
     ("http://creativecommons.org/licenses/by-sa/3.0/lu/deed.en",
      "CC-BY-SA-3.0"),
     ("http://creativecommons.org/licenses/by-sa/3.0/nl/deed.en",
      "CC-BY-SA-3.0"),
     ("http://creativecommons.org/licenses/by-sa/3.0/ro/deed.en",
      "CC-BY-SA-3.0"),
     ("http://creativecommons.org/licenses/by-sa/3.0/us/deed.en",
      "CC-BY-SA-3.0"),
     ("http://creativecommons.org/licenses/by/2.5/deed.en",
      "CC-BY-2.5"),
     ("http://creativecommons.org/licenses/by/2.5/au/deed.en",
      "CC-BY-2.5"),
     ("http://creativecommons.org/licenses/by/2.5/br/deed.en",
      "CC-BY-2.5"),
     ("http://creativecommons.org/licenses/by/2.5/ca/deed.en",
      "CC-BY-2.5"),
     ("http://creativecommons.org/licenses/by/2.5/in/deed.en",
      "CC-BY-2.5"),
     ("http://creativecommons.org/licenses/by/2.5/it/deed.en",
      "CC-BY-2.5"),
     ("http://creativecommons.org/licenses/by/2.5/mk/deed.en",
      "CC-BY-2.5"),
     ("http://creativecommons.org/licenses/by/2.5/pl/deed.en",
      "CC-BY-2.5"),
     ("http://creativecommons.org/licenses/by/2.5/pt/deed.en",
      "CC-BY-2.5"),
     ("http://creativecommons.org/licenses/by/2.5/au/deed.en",
      "CC-BY-2.5"),
     ("http://creativecommons.org/licenses/by-sa/2.5/deed.en",
      "CC-BY-SA-2.5"),
     ("http://creativecommons.org/licenses/by-sa/2.5/deed.de",
      "CC-BY-SA-2.5"),
     ("http://creativecommons.org/licenses/by-sa/2.5/au/deed.en",
      "CC-BY-SA-2.5"),
     ("http://creativecommons.org/licenses/by-sa/2.5/br/deed.en",
      "CC-BY-SA-2.5"),
     ("http://creativecommons.org/licenses/by-sa/2.5/ch/deed.en",
      "CC-BY-SA-2.5"),
     ("http://creativecommons.org/licenses/by-sa/2.5/dk/deed.en",
      "CC-BY-SA-2.5"),
     ("http://creativecommons.org/licenses/by-sa/2.5/es/deed.en",
      "CC-BY-SA-2.5"),
     ("http://creativecommons.org/licenses/by-sa/2.5/in/deed.en",
      "CC-BY-SA-2.5"),
     ("http://creativecommons.org/licenses/by-sa/2.5/it/deed.en",
      "CC-BY-SA-2.5"),
     ("http://creativecommons.org/licenses/by-sa/2.5/mk/deed.en",
      "CC-BY-SA-2.5"),
     ("http://creativecommons.org/licenses/by-sa/2.5/mx/deed.en",
      "CC-BY-SA-2.5"),
     ("http://creativecommons.org/licenses/by-sa/2.5/pl/deed.en",
      "CC-BY-SA-2.5"),
     ("http://creativecommons.org/licenses/by-sa/2.5/si/deed.en",
      "CC-BY-SA-2.5"),
     ("http://creativecommons.org/licenses/by-sa/2.5/za/deed.en",
      "CC-BY-SA-2.5"),
     ("http://commons.wikimedia.org/wiki/Template:Cc-by-2.0",
      "CC-BY-2.0"),
     ("http://creativecommons.org/licenses/by/2.0/at/deed.en",
      "CC-BY-2.0"),
     ("http://creativecommons.org/licenses/by/2.0/de/deed.en",
      "CC-BY-2.0"),
     ("http://creativecommons.org/licenses/by/2.0/kr/deed.en",
      "CC-BY-2.0"),
     ("http://creativecommons.org/licenses/by-sa/2.0/deed.en",
      "CC-BY-SA-2.0"),
     ("http://creativecommons.org/licenses/by-sa/2.0/at/deed.en",
      "CC-BY-SA-2.0"),
     ("http://creativecommons.org/licenses/by-sa/2.0/be/deed.en",
      "CC-BY-SA-2.0"),
     ("http://creativecommons.org/licenses/by-sa/2.0/ca/deed.en",
      "CC-BY-SA-2.0"),
     ("http://creativecommons.org/licenses/by-sa/2.0/fr/deed.en",
      "CC-BY-SA-2.0"),
     ("http://creativecommons.org/licenses/by-sa/2.0/jp/deed.en",
      "CC-BY-SA-2.0"),
     ("http://creativecommons.org/licenses/by-sa/2.0/kr/deed.en",
      "CC-BY-SA-2.0"),
     ("http://creativecommons.org/licenses/by-sa/2.0/tw/deed.en",
      "CC-BY-SA-2.0"),
     ("http://creativecommons.org/licenses/by-sa/2.0/uk/deed.en",
      "CC-BY-SA-2.0"),
     ("http://creativecommons.org/licenses/sa/1.0/", "CC-SA-1.0"),
     ("http://creativecommons.org/publicdomain/zero/1.0/deed.en", "PD")]
