/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef QtScmEditor_H
#define QtScmEditor_H

class QtScmEditor;

class ScmEditorObserver : public ReplyObserver {
public:

	ScmEditorObserver (QtScmEditor &editor, string &path);
	virtual ~ScmEditorObserver();

	virtual void start();

	// From ReplyObserver
	virtual void reply(const Request&, int);
	virtual void progress(const Request&);  
	virtual void message(const string&);

protected:

	 void print(ostream&) const; // Change to virtual if base class	

private:
    // No copy allowed
    ScmEditorObserver(const ScmEditorObserver&);
    ScmEditorObserver& operator=(const ScmEditorObserver&);

    QtScmEditor &editor_;
    string         path_;

};



class QtScmEditor :public Editor {
public:

	QtScmEditor(const IconClass&,const string&);
	virtual ~QtScmEditor(); 

private:
	QtScmEditor(const QtScmEditor&);
	QtScmEditor& operator=(const QtScmEditor&);

	virtual void edit(void);

    	ScmEditorObserver *replyObserver_;

};

inline void destroy(QtScmEditor**) {}


#endif
