
; file: e0.scm

(load "~/minlog/init.scm")

(load "~/minlog/src/thiel.scm")


;;; SOME Logic

(load "~/minlog/examples/ordinals/logic.scm")

; classicalBoole    ¬¬p -> p

; ExFalsoBoole      ⊥ -> p



;;;; Basic Definitions ;;;;;;;;;;;

; We define the algebra of ordinals as follows:

; O ,   α,β  ->  ω^α + β

(add-alg "ord" '("Zero" "ord") '("OP" "ord=>ord=>ord"))

(display-constructors "ord")


; with ord-variables a, b, g, d, x, y, z, t

(av "a" "b" "g" "d" "x" "y" "z" "t" (py "ord"))



;     O : Zero
;     1 : OP Zero Zero
;     2 : OP Zero (OP Zero Zero)
;   n+1 : OP Zero n

;    ω  : OP (OP Zero Zero) Zero
;   ω+1 : OP (OP Zero Zero) (OP Zero Zero)
; 1+ω+1 : OP Zero (OP (OP Zero Zero) (OP Zero Zero))
;   1+α : OP Zero α




;The basic properties ar shown in the following file:

(load "~/minlog/examples/ordinals/e0basics.scm")




; Binary relation LESS and LE, < and ≤ :

(display-program-constants "LESS")
(display-program-constants "LE")


(pnt "(OP 1 0) < (OP 0 (OP 1 0))")
; ω<1+ω = False
(pnt "(OP 1 0) ≤ (OP 0 (OP 1 0))")
; ω≤1+ω = True

; classical behaviour:
(display-theorems "ClassicalLESS")
; linear order:
(display "\n LESS is strict linear order: \n")
;(display-program-constants "LESS")
(display-theorems "LESSantisym")
(display-theorems "LESStrans")
(display-theorems"LESSlinear")
; further properties:
(display-theorems "LESSEQUtrans")
(display-theorems "LESStrans")




; Binary relation IC, ~ , for equality:

(display-program-constants "IC")

; which is an equivalence relation:
(display-theorems"ICsym")
(display-theorems"ICtrans")


; And many more

; To summarise and see them all:
(display-constructors)
(display-program-constants)
(display-tokens)
(display-theorems)

;;;; End of Basic Definitions ;;;;



;;;; Successor & Addition ;;;;;;;;;;;

; The Successor function and Addition can be found in the following file:

(load "~/minlog/examples/ordinals/e0sucadd.scm")

; The successor function cS has been extracted from the proof of

(display-theorems "S")
; ∀α ∃β ∀γ  . α<β & (α≤γ<β -> γ~α)

; cS's Computation Rules
(animate "S")
(begin (display"
S(ω²³+99) = ")(ont"cS (OP 23 99)"))
(display"
")
(display-program-constants "cS")
; (Rec ord=>ord)1([a1,a2,a3]OP a1)
(deanimate "S")

; RW-rules:
(display-program-constants "LESS")
; a<cS a	True
; cS a<a	False

; Thm:
(display-theorems "FinSucc")
; n<ω -> cS n = 1+n


; Successor Predicates SORD & LORD

; SORD: successor ordinal
(display-program-constants "SORD")
(pnt "SORD (OP(OP (OP 1 1) (OP 1 1))(OP (OP 1 1) (OP 1 1)))")
; SORD(ω^( ωʷ⁺¹+(ω+1) ) + ωʷ⁺¹+(ω+1)) = True

; LORD: limit ordinal
(display-program-constants "LORD")
(pnt "LORD (OP(OP (OP 1 1) (OP 1 1))(OP (OP 1 1) (OP 1 1)))")
; LORD(ω^( ωʷ⁺¹+(ω+1) ) + ωʷ⁺¹+(ω+1)) = False


; Thm:

(display-theorems "notSORDandLORD")
; SORD α → LORD α → False

(display-theorems "SORDorLORD")
; α≠0 → ¬(SORD α) → LORD α

(display-theorems"onlySORD")
; 0≠α<ω -> SORD(α)



; The predecessor function cP
; has been extracted from the proof of

(display-theorems "P")
; SORD(α) -> (∃β<α) S(β)=α

; thus SORD(α) <-> (∃β<α) S(β)=α

(display-program-constants "SORD")
; SORD(cS a)	True
; SORD((Rec ord=>ord)1([a0,a1,a2]OP a0)a)	True

; Thm:

(display-theorems"PredDown")
; SORD β -> cP(ω^α+β) = ω^α+(cP β)

(display-theorems "SORD1")
; SORD(ω^α+β) -> ¬SORD(β) -> (α=0 & β=0)

(display-theorems "Pbiggestsmaller")
; SORD α -> β<α -> β≤ cP α




;;; Ordinal Addition + : PLUS

(display-program-constants "PLUS")

(animate "S")
(pnt "IC ((OP 8 9)+1) (cS (OP 8 9))")
; (ω⁸+9)+1 ~ cS(ω⁸+9)  =  True
(deanimate "S")


;;; natMINUS: -

(display-program-constants "natMINUS")

(pnt "(OP 1 1)-0")
; (ω+1) -     0 =  ω+1
(pnt "0-(OP 1 1)")
;     0 - (ω+1) =  0
(pnt "42-17")
;    42 -    17 =  25
(pnt "17-42")
;    17 -    42 =  0
(pnt "(OP 1 1)-(OP 1 0)")
; (ω+1) -     ω =  (ω+1)-ω




;;; Partial Multiplication * : natMULT

(display-program-constants "natMULT")

(ont "(OP 2 2)*3")
; (ω^(2)+2)*3  =  ω^(2)+1+1+ω^(2)+1+1+ω^(2)+2


; And many more

; To summarise and see them all:
(display-constructors)
(display-program-constants)
(display-tokens)
(display-theorems)
(display-global-assumptions)
;;;; End of Successor & Addition ;;;;;;;;;;;


(add-pvar-name "A" (make-arity (py "ord")))


; Often used lemma:

; ForallDown: γ<α -> ∀β<α A(β) -> ∀β<γ A(β)

(set-goal(pf"g<a -> (all b. b<a -> A^ b) -> (all b. b<g -> A^ b)"))

(assume "g" "a" "g<a" "Aa" "b" "b<g")
(use "Aa")
(use "LESStrans" (pt"g"))
(auto)

; Proof finished.

; (cdp)

(save "ForallDown")
(display-theorems "ForallDown")




;;;;;; STind: Subterminduction ;;;;;;;;;

(load "~/minlog/examples/ordinals/e0stind.scm")

(display-program-constants "subterm")

(display-theorems "STtrans")
(display-theorems  "STind")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;






;;; Transfinite Induction


; NatInd

; A(0) -> ∀n<ω [ A(n)->A(1+n) ] -> ∀n<ω A(n)

(set-goal
  (pf"A^ 0->(all n. n<(OP 1 0) -> A^ n -> A^ (OP 0 n))->all k.k<(OP 1 0) -> A^ k"))
(assume "A0" "PROG")

(ind)
     (search)
(cases)
(search)
(assume "k1" "k3" "k2")
(prop); INTU

; ok, ?_7 is proved in intuitionistic propositional logic.  Proof finished.

; (cdp)

(save "Natind")
(display-theorems "Natind")



; NatCVind

; A(0) -> ∀n<ω [ (∀k<n)A(k) -> A(n) ] -> ∀n<ω A(n)

(set-goal
  (pf"A^ 0->(all a. a<(OP 1 0) -> (all x.x<a -> A^ x) -> A^ a)->all a.a<(OP 1 0) -> A^ a"))
(assume "A0" "PROG")

(cut(pf"all a.(all x.x«a -> x<OP 1 0 -> A^x) -> a<OP 1 0 -> A^a"))
(cut(pf"0<OP 1 0 -> A^ 0"))
(use-with "STind"
  (make-cterm (pv "a")
  (pf "a<(OP 1 0) -> A^ a"))
)
(search)
(assume "a" "Ax" "a<ω")
(use "PROG")
(use "a<ω")
(assume "x" "x<a")
(use "Ax")
(aga "FiniteLESSsubterm" (pf"all a.a<OP 1 0->all x.x<a->x«a"))
(use "FiniteLESSsubterm")
(auto)
(use "LESStrans" (pt"a"))
(auto)

; Proof finished.

; (cdp)

(save "NatCVind")
(display-theorems "NatCVind")






; Function ℧

(add-program-constant
 "℧"
 (mk-arrow (py "ord") (py "ord"))
 1 'const 1
)

(add-computation-rule (pt "℧ 0")(pt "OP 0 0"))
(add-computation-rule (pt "℧(OP a b)")(pt "OP (℧ b) 0"))

(display-program-constants "℧")


; 0 < ℧α
(set-goal(pf "0< ℧a"))
(cases)
(auto)

; Proof finished.

(add-rewrite-rule (pt"0< ℧a") (pt"T"))



; MHOomegamonotone: k≤l<ω -> ℧k≤℧l

(set-goal (pf"n<OP 1 0 -> all k.k≤n -> ℧k ≤ ℧n"))

(cut(pf"all n.n<OP 1 0 -> (all k.k≤n -> ℧k≤ ℧n) -> all k.k≤OP 0 n -> ℧k≤ ℧(OP 0 n)"))
(cut(pf "all k.k≤0 -> ℧k≤ ℧0"))
(use-with "Natind"
  (make-cterm (pv "n")
  (pf "all k.k≤n -> ℧k ≤ ℧n"))
)

(assume "k" "k≤0")
(cut(pf "k=0"))
(assume "k=0")
(simp "k=0")
(search)
(search)

; ?_3: all n.n<OP 1 0 -> (all k.k≤n -> ℧k≤ ℧n) -> all k.k≤OP 0 n -> ℧k≤ ℧(OP 0 n)

(assume "n" "n<ω" "IHn")
(cases); k
      (search)
(assume "k1" "k2" "k1k2≤1+n")
(cut(pf"k2≤n"))
(use "IHn")
(cut(pf "OP 0 k2≤OP 0 n"))
(search)
(use "LEtrans" (pt"OP k1 k2"))
(auto)

; Proof finished.

; (cdp)

(save "MHOomegamonotone")
(display-theorems "MHOomegamonotone")




; MHOup: α<℧γ -> β<℧(1+γ) -> ω^α+β < ℧(1+γ)

(set-goal(pf"a<(℧g) ->b<(℧(OP 0 g)) -> (OP a b)<(℧(OP 0 g))"))

(assume "a" "g" "b")
(strip)
(ng)
(simp 1)
(search)

; ok, ?_5 is proved by minimal quantifier logic.  Proof finished.

; (cdp)

(save"MHOup")
(display-theorems"MHOup")




; MHO: (∃n<ω) α<℧n

(deanimate "P")
(deanimate "S")

(set-goal (pf"all a.ex n.n<OP 1 0 & a<(℧ n)"))

(ind); a

(ex-intro (pt"0"))
(search)

(assume "a1" "a2" "IHa1" "IHa2")
(ex-elim "IHa1")
(assume "k" "IHa1k")
(ex-elim "IHa2")
(assume "l" "IHa2l")

; ?_9: ex n.n<OP 1 0 & OP a b< ℧n

(casedist(pt"k<l"))
(assume "k<l")
(cut(pf"l≠0"))
(assume  "l≠0")
(cut(pf"SORD l"))
(assume  "SORD l")
(cut(pf"l=cS(cP l)"))
(assume  "l=cS(cP l)")
(cut(pf"cS(cP l)=OP 0(cP l)"))
(assume  "cS(cP l)=OP 0(cP l)")
(cut(pf "l=OP 0(cP l)"))
(assume   "l=OP 0(cP l)")
(cut(pf"OP(℧(cP l))0= ℧l"))
(assume  "OP(℧(cP l))0= ℧l")
(cut(pf "℧l=OP (℧(cP l)) 0"))
(assume "℧l=OP (℧(cP l)) 0")
(ex-intro (pt"l"))
(split)
(prop)

; ?_36: OP a b< ℧l

(simp "℧l=OP (℧(cP l)) 0")
(use "MHOup")
(cut(pf"℧k ≤ ℧(cP l)"))
(use "LESSEQUtrans2")
(search)
(cut(pf"k≤ cP l"))
(use "MHOomegamonotone")
(use "LESStrans" (pt"l"))
(use "PredSmaller")
(auto)

; ?_44: k≤cP l

(use "Pbiggestsmaller")
(auto)
(cut(pf"a2< ℧l"))
(ng)
(simp "OP(℧(cP l))0= ℧l")
(auto)
(simp "OP(℧(cP l))0= ℧l")
(auto)

; ?_29: OP(℧(cP l))0= ℧l

(cut(pf"all t. t=OP(℧(cP l))0 -> t= ℧l"))
(auto)
(assume "t" "tequ")
(simp "l=OP 0(cP l)")
(simp "tequ")
(auto)

; ?_26: l=OP 0(cP l)

(cut(pf"all t. t=OP 0 (cP l) -> l=t"))
(auto)
(assume "t" "tequ")
(simp "l=cS(cP l)")
(simp "cS(cP l)=OP 0(cP l)")
(simp "tequ")
(auto)
(use "FinSucc")
(use "LESStrans" (pt"l"))
(use "PredSmaller")
(auto)
(cut (pf"cS(cP l)=l"))
(strip)
(simp 8)
(auto)
(use "SuccPred")
(auto)
(use "onlySORD")
(auto)
(cut(pf"l=0->F"))
(strip)
(ng)
(simp 6)
(auto)
(strip)
(cut(pf"k<l"))
(simp 6)
(search)
(search)

; ?_11: (k<l -> F) -> ex n.n<OP 1 0 & OP a b< ℧n

(assume "l≤k")

(ex-intro (pt"OP 0 k"))
(ng)
(split)
(search)

; ?_90: [if (a< ℧k) (b<OP(℧k)0) False]

(inst-with-to "IHa1k" 'right "IHa1kR")
(simp "IHa1kR")
(ng)
(use "LESStrans" (pt"℧l"))
(search)
(use "LESSEQUtrans2" (pt"℧k"))
(use "MHOomegamonotone")
(cut(pf"k<l -> F"))
(ng)
(casedist(pt"k<l"))
(auto)
(use "le")
(auto)

; Proof finished.

; (cdp)

(save "MHO")
(display-theorems "MHO")


;;;  PROOF SCETCH FOR TRANSFINITE INDUCTION ;;;

; We first reduce transfinite induction to induction on N:
; (∀n<ω IND(℧n)) -> IND

; So it suffices to show    ∀n IND(℧n)
; which will be done by Natural Induction:

; IND(℧0) is trivial since ℧0=1 .

; Assume IND(℧n)

; And show IND( ℧(n+1) )
; which can be reduced via
; (∀α<℧n) IND(ω^α) -> IND( ℧(n+1) )

; To show (∀α<℧n) IND(ω^α)
; we use our assumption IND(℧n):

; IND(ω⁰) is trivial.
; OmegaTimes: IND(ω^α) -> IND(ω^(Sα))
; Induction is progressive:  (∀γ<α) IND(γ) -> IND(α)

;;; End of Proof Scetch ;;;





; P R O O F

; We first reduce transfinite induction to induction on N

; MHOindImplLESSind :  (∀n<ω IND(A,℧n)) -> IND(A)

(set-goal(pf "(all n.n<OP 1 0
    -> A^ 0  -> (all a.(all x.x<a -> A^ x) -> A^ a)  ->  all a.a<(℧ n) ->A^ a)
    -> A^ 0  -> (all a.(all x.x<a -> A^ x) -> A^ a)  ->  all a.A^ a"))

(assume "MHOind" "A0" "PROG")
(cut(pf"all a,n.n<OP 1 0 ->a< ℧n -> A^a"))
(assume "a<℧nA" "a")
(cut(pf"ex n.n<OP 1 0 & a<(℧ n)"))
(assume "∃n.a<℧n")
(ex-elim "∃n.a<℧n")
(assume "n" "n<ω a<℧n")
(cut(pf"a< ℧n"))
(auto)
(use "MHO")
(search)

; ok, ?_4 is proved by minimal quantifier logic.  Proof finished.

; (cdp)

(save "MHOindImplLESSind")
(display-theorems "MHOindImplLESSind")


; ℧'s end






; Induction is progressive

; IndProg :  (∀γ<α) IND(γ) -> IND(α)

(set-goal
  (pf"(all g. g< a
                  -> A^ 0
                  -> (all b.(all x.x<b -> A^ x) -> A^ b)
                   -> all b.b<g ->A^ b)
        -> A^ 0
        -> (all b.(all x.x<b -> A^ x) -> A^ b)
        -> all b.b<a ->A^ b"))

(search)

; ok, ?_1 is proved by minimal quantifier logic.  Proof finished.

; (cdp)

(save "IndProg")
(display-theorems "IndProg")







; We can lower the induction

; LowerInd: β<α -> Ind(α) -> Ind(β)

(set-goal (pf"b<a ->
     (A^ 0  -> (all x.(all y.y<x -> A^ y) -> A^ x) -> all x.x<a ->A^ x)
   -> A^ 0  -> (all x.(all y.y<x -> A^ y) -> A^ x) -> all x.x<b ->A^ x"))

(assume "b" "a" "b<a" "INDa" "A0" "PROG")
(use "ForallDown" (pt"a"))
(auto)

; Proof finished.

; (cdp)

(save "LowerInd")
(display-theorems "LowerInd")





; Now it remains to proof (∀n IND(A,℧n))
; which we will do by induction on N
; i.e. we will use IND(IND(A,℧n),ω)



; First some auxilary lemmae


; OmegaJump: (∀α<℧n) IND(ω^α) -> IND( ℧(n+1) )

(set-goal
  (pf"all n. n< OP 1 0 ->
      (all a. a< ℧n -> A^ 0 -> (all b.(all y.y<b -> A^y) -> A^b) -> all b.b< (OP a 0) -> A^b)
                    -> A^ 0 -> (all b.(all x.x<b -> A^x) -> A^b) -> all b.b< ℧(OP 0 n) -> A^b"))
(cases); n
(assume "true" "INDω^a" "A0" "prog" )
(drop "true" "INDω^a")
(use "NatCVind")
(search)
(search)

(assume "n1" "n2" "n<ω" "INDω^a" "A0" "prog" "b" "b<℧(1+n)")

; ?_8: A^b

(cut(pf  "ex g.g< ℧(OP n1 n2) & b<OP g 0"))
(assume  "ex g.g< ℧(OP n1 n2) & b<OP g 0")
(ex-elim "ex g.g< ℧(OP n1 n2) & b<OP g 0")
(search)

; ?_10: ex g.g< ℧(OP n1 n2) & b<OP g 

(use "ExpCont")
(ng)
(cas "(℧n2=0->F)" "℧n2≠0")
(search)
(cut(pf "all t.(℧t=0->F)"))
(search)
(cases)
(auto)

; Proof finished.

; (cdp)

(save "OmegaJump")
(display-theorems "OmegaJump")



; A0INDprogTOupPROG:
; A(0) -> (∀δ) [ IND(A(ξ),δ) -> PROG(A(ξ)) -> PROG( ξ<δ ∨ A(ξ)) ]

(set-goal(pf "A^ 0 -> all d.
              (A^ 0 -> (all b.(all x.x<b -> A^x) -> A^b) -> all b.b<d -> A^ b)
           -> (all b.(all x.x<b -> A^x) -> A^b)
           -> (all b.(all x.x<b -> (x<d->F) -> A^ x) -> (b<d->F) -> A^b)"))

(assume "A0" "d" "INDd" "prog" "b" "Aup" "d≤b")
(use "prog")
(assume "x" "x<b")
(casedist(pt"x<d"))
(use "INDd")
(auto)

; Proof finished.

; (cdp)

(save "A0INDprogTOupPROG")
(display-theorems "A0INDprogTOupPROG")





; A0INDdPROGtoPROGdplus:
; A0 -> (∀δ) [ IND(A(ξ),δ) -> PROG(A(ξ)) -> PROG(A(δ+ξ)) ]

(aga "summ" (pf "all a,b.(b<a->F) -> ex g.b=(a+g)"))
; α≤β -> 

(set-goal(pf "A^ 0 -> all d.
              (A^ 0 -> (all b.(all x.x<b -> A^x) -> A^b) -> all b.b<d -> A^ b)
           -> (all b.(all x.x<b -> A^x) -> A^b)
           -> (all b.(all x.x<b -> A^(d+x)) -> A^(d+b))"))

(assume "A0" "d" "INDd" "prog" "b" "Aup")
(ca "all b.(all x.x<b -> (x<d->F) -> A^ x) -> (b<d->F) -> A^b" "upPROG")
(use "upPROG")

; ?_6: all x.x<d+b -> (x<d -> F) -> A^x

(assume "x" "x<d+b" "d≤x")
(ca "ex y.x=(d+y)" "∃y.x=d+y")
(ex-elim "∃y.x=d+y")
(assume "y" "x=d+y")
(simp "x=d+y")
(use "Aup")
(cut(pf "x<(d+b)"))
(simp "x=d+y")
(auto)
(use "summ")
(search)
(search)
(use "A0INDprogTOupPROG")
(search)
(use "INDd")
(use "prog")

; ok, ?_22 is proved.  Proof finished.

; (cdp)

(save "A0INDdPROGtoPROGdplus")
(display-theorems "A0INDdPROGtoPROGdplus")







;;;; CHEATING SECTION ;;;;;

; The following two lemmae hold
; if they are read impredicatively.

; (cdp) complains of the 2nd lemma's proof
; but it seems to like first one's.

(add-pvar-name "B" (make-arity (py "ord")))


; " ( ∀A IND(A) ) -> ( ∀B IND(B) ) "
; nicht so:
; " ∀A ∀B ( IND(A)  ->  IND(B) ) "

(set-goal
  (pf"(A^ 0 -> (all b.(all x.x<b -> A^ x) -> A^ b)
            ->  all b.A^ b)
    -> B^ 0 -> (all b.(all x.x<b -> B^ x) -> B^ b)
            ->  all b.B^ b"))

(assume "INDA")
(cheat-with "INDA" (make-cterm (pv "b") (pf "B^b")))

; ok, ?_2 is proved.  Proof finished.

; (cdp) ; OK

; (save "INDAtoINDB")
; does not work:
; unexpected free assumptions
; u2929: B^ 0 -> (all b.(all x.x<b -> B^x) -> B^b) -> all b B^b

(aga "INDAtoINDB"  (pf"(A^ 0 -> (all b.(all x.x<b -> A^ x) -> A^ b)
            ->  all b.A^ b)
    -> B^ 0 -> (all b.(all x.x<b -> B^ x) -> B^ b)
            ->  all b.B^ b"))
(display-global-assumptions "INDAtoINDB")


; ∀a [ ( ∀A IND(A,a) ) -> ( ∀B IND(B,a) ) ]

(set-goal
  (pf"(A^ 0 -> (all b.(all x.x<b -> A^ x) -> A^ b) ->  all b.b<a ->A^ b)
    -> B^ 0 -> (all b.(all x.x<b -> B^ x) -> B^ b) ->  all b.b<a ->B^ b"))

(assume "a" "INDA")

; CHEATING

(cdp) ; OK
(cheat-with "INDA" (make-cterm (pv "b")(pf "B^b")) )
; (cdp)
; variable condition fails for a

; ok, ?_2 is proved.  Proof finished.

; (save "INDAatoINDBa")
; does not work:
; unexpected free assumptions
; u2932: B^ 0 -> (all b.(all x.x<b -> B^x) -> B^b) -> all b.b<a -> B^b

(aga "INDAatoINDBa"
  (pf"all a.(A^ 0 -> (all b.(all x.x<b -> A^ x) -> A^ b) ->  all b.b<a ->A^ b)
    -> B^ 0 -> (all b.(all x.x<b -> B^ x) -> B^ b) ->  all b.b<a ->B^ b"))
(display-global-assumptions "INDAatoINDBa")

;;;; CHEATING SECTION's End ;;;;;





; INDdouble:
; IND(A(ξ),a) -> IND(A(a+ξ),a)

(set-goal
  (pf"(A^ 0 -> (all b.(all x.x<b -> A^ x) -> A^ b)
            ->  all b.b<a ->A^ b)
    -> A^ 0 -> (all b.(all x.x<b -> A^(x)) -> A^(b))
            ->  all b.b<a ->A^(a+b)"))

(assume "a" "INDa" "A0" "prog")
; "b" "b<a")

(cut(pf "all b.(all x.x<b -> A^(a+x)) -> A^(a+b)"))
(cut(pf "A^(a+0)"))
(cut(pf "A^ 0 -> (all b.(all x.x<b -> A^x) -> A^b) -> all b.b<a -> A^b"))

(use-with-2 "INDAatoINDBa"  ;; CHEAT-thm
  (make-cterm (pv "b")(pf "A^(a+b)"))
  (pt "a")
)

(use "INDa")
(use "prog")
(use "INDa")
(use "A0")
(use "prog")
(use "A0INDdPROGtoPROGdplus")
(use "A0")
(use "INDa")
(use "prog")

; ok, ?_14 is proved.  Proof finished.

(cdp)

(save "INDdouble")
(display-theorems "INDdouble")







; OmegaTimes: IND(ω^α) -> IND(ω^(Sα))

(aga "OmegaTimesExp" (pf"all a,b.b<OP (cS a) 0->(ex n.n<OP 1 0 & b<((OP a 0)*(EXP n)))"))
(aga "EXPAdd"
  (pf"all a,n,g.(a*EXP n)<g -> g<(a*EXP(OP 0 n)) -> ex x.x<(a*EXP n) & g= ((a*EXP n)+x)"))
; (aga "EXPAddLE"
;   (pf"all a,n,g.(g<(a*(EXP n))->F) -> g<(a*(EXP(OP 0 n))) -> ex x.x<(a*(EXP n)) & g= ((a*(EXP n))+x)"))


(set-goal
  (pf"(A^ 0 -> (all b.(all x.x<b -> A^ x) -> A^ b)
            ->  all b.b<(OP a 0) ->A^ b)
    -> A^ 0 -> (all b.(all x.x<b -> A^ x) -> A^ b)
            ->  all b.b<(OP (cS a) 0) ->A^ b"))

(assume "a" "INDa")

(ca "all n.n<OP 1 0 ->
            A^ 0 -> (all b.(all x.x<b -> A^x) -> A^b)
            -> all b.b<((OP a 0)*(EXP n)) -> A^b"
  "(∀n<ω)(INDa2ⁿ)")

(assume  "A0" "prog" "b" "b<Sa")
(ca  "ex n.n< OP 1 0 & b<((OP a 0)*(EXP n))" "(∃n<ω)b<a2ⁿ")
(ex-elim  "(∃n<ω)b<a2ⁿ")
(assume "n" "n<ω b<a*2ⁿ")
(use "(∀n<ω)(INDa2ⁿ)" (pt"n"))
(search)
(use "A0")
(use "prog")
(search)
(use "OmegaTimesExp")
(search)

; ?_4: all n.n<OP 1 0 -> A^ 0 -> (all b.(all x.x<b -> A^x) -> A^b) -> all b.b<(OP a 0)*(EXP n) -> A^b

(cut(pf "all n.n<OP 1 0
     -> (A^ 0 -> (all b.(all x.x<b -> A^x) -> A^b) -> all b.b<(OP a 0*EXP n) -> A^b)
      -> A^ 0 -> (all b.(all x.x<b -> A^x) -> A^b) -> all b.b<(OP a 0*EXP(OP 0 n)) -> A^b"))

(cut(pf "A^ 0 -> (all b.(all x.x<b -> A^x) -> A^b) -> all b.b<(OP a 0*EXP 0) -> A^b"))

(use-with "Natind"
  (make-cterm (pv "n")
  (pf "A^ 0 -> (all b.(all x.x<b -> A^x) -> A^b) -> all b.b<(OP a 0*EXP n) -> A^b"))
)

; ?_20: A^ 0 -> (all b.(all x.x<b -> A^x) -> A^b) -> all b.b<OP a 0*EXP 0 -> A^b

(use "INDa")
(assume "n" "n<ω" "INDa2ⁿ" "A0" "prog" "b" "b<a2ⁿ⁺¹")
(ca "all g. (OP a 0*EXP n)<g -> g<(OP a 0*EXP (OP 0 n))
         -> ex x.x<((OP a 0)*(EXP n)) & g=(((OP a 0)*(EXP n))+x)" "(∀a2ⁿ<g<a2ⁿ⁺¹)(∃x<a2ⁿ)g=a2ⁿ+x")
(drop "INDa" "n<ω")

; ?_25: A^b

(casedist(pt "((OP a 0)*(EXP n))<b"))
(assume "a2ⁿ<b")
(inst-with-to "(∀a2ⁿ<g<a2ⁿ⁺¹)(∃x<a2ⁿ)g=a2ⁿ+x" (pt"b") "(a2ⁿ<b<a2ⁿ⁺¹)->(∃x<a2ⁿ)b=a2ⁿ+x")
(ca "ex x.x<(OP a 0*EXP n) & b=((OP a 0*EXP n)+x)" "(∃x<a2ⁿ)b=a2ⁿ+x")
(ex-elim "(∃x<a2ⁿ)b=a2ⁿ+x")
(assume "x" "x<a2ⁿ b=a2ⁿ+x")
(inst-with-to "x<a2ⁿ b=a2ⁿ+x" 'Right "b=a2ⁿ+x")
(simp "b=a2ⁿ+x")

; ?_38: A^(OP a 0*EXP n+x)

(cut(pf "all y.y<(OP a 0*EXP n) -> A^((OP a 0*EXP n)+y)"))
(search)

; ?_40: all y.y<OP a 0*EXP n -> A^(OP a 0*EXP n+y) from

(use "INDdouble") ; cheating thm

(use "INDa2ⁿ")
(use "A0")
(use "prog")
(search)

; ?_27: (OP a 0*EXP n<b -> F) -> A^b

(assume "b≤a2ⁿ")
(ca "all b.b<((OP a 0)*(EXP n)) -> A^ b" "(∀b<a2ⁿ)A")
(casedist(pt "b<((OP a 0)*(EXP n))"))
    (use "(∀b<a2ⁿ)A")
(assume "a2ⁿ≤b")
(use "prog")
(assume "x" "x<b")
(use "(∀b<a2ⁿ)A")
(cut (pf"(OP a 0*EXP n)<b-> F"))
(use "LESSEQUtrans")
(use "x<b")
(use "b≤a2ⁿ")

; ?_46: all b.b<OP a 0*EXP n -> A^b

(use "INDa2ⁿ")
(use "A0")
(use "prog")
(use "EXPAdd")

; ok, ?_23 is proved.  Proof finished.

; (cdp) ; OK

(save "OmegaTimes")
(display-theorems "OmegaTimes")





; The Theorem

;; LESSind


(set-goal (pf"A^ 0->(all a.(all x.x<a -> A^ x) -> A^ a)->all a.A^ a"))

(use "MHOindImplLESSind")

(cut(pf"all n.n<OP 1 0
        -> (A^ 0 -> (all a.(all x.x<a -> A^x) -> A^a) -> all a.a< ℧n -> A^a)
        ->  A^ 0 -> (all a.(all x.x<a -> A^x) -> A^a) -> all a.a< ℧(OP 0 n) -> A^a"))

(cut(pf"A^ 0 -> (all a.(all x.x<a -> A^x) -> A^a) -> all a.a< ℧0 -> A^a"))

(use-with "Natind"  (make-cterm (pv "n")
  (pf "A^ 0 -> (all a.(all x.x<a -> A^x) -> A^a) -> all a.a< ℧n -> A^a")))

(assume "A0" "PROG" "a")
(ng)
(assume "a=0")
(simp "a=0")
(use "A0")

(assume "n" "n<ω" "Ind℧n")

; ?_11: A^ 0 -> (all a.a< ℧(OP 0 n) -> (all x.x<a -> A^x) -> A^a) -> all a.a< ℧(OP 0 n) -> A^a

(use "OmegaJump")
(search)

; ?_13: all a.a< ℧n -> A^ 0 -> (all b.(all y.y<b -> A^y) -> A^b) -> all b.b<OP a 0 -> A^b

(cut(pf "all a.
  (all x.x<a -> A^ 0 -> (all b.(all y.y<b -> A^y) -> A^b) -> all b.b<OP x 0 -> A^b)
             -> A^ 0 -> (all b.(all y.y<b -> A^y) -> A^b) -> all b.b<OP a 0 -> A^b"))
(cut(pf"A^ 0 -> (all b.(all y.y<b -> A^y) -> A^b) -> all b.b<OP 0 0 -> A^b"))

; Ind℧n:
(cut(pf"A^ 0 -> (all a.(all x.x<a -> A^x) -> A^a) -> all a.a< ℧n -> A^a"))


(use-with-2 "INDAatoINDBa"  ;; CHEAT-thm
  (make-cterm (pv "a")(pf "A^ 0 -> (all b.(all y.y<b -> A^y) -> A^b) -> all b.b<OP a 0 -> A^b")) (pt"℧n")
)

(use "Ind℧n")

; ?_17: A^ 0 -> (all b.(all y.y<b -> A^y) -> A^b) -> all b.b<1 -> A^b

(assume "A0" "PROG" "b")
(ng)
(assume "b=0")
(simp "b=0")
(use "A0")

(assume "a" "∀xINDx0")
(ng)
(casedist (pt"a=0"))
(assume "a=0")
(simp "a=0")
(assume "A0" "PROG" "b")
(ng)
(assume "b=0")
(simp "b=0")
(use "A0")

; ?_32: (a=0 -> F) ->...

(assume "a≠0")

(casedist (pt"SORD a"))
(assume "sorda")
(cut(pf"ex g. g<a & cS g=a"))
(assume "Pa")
(ex-elim "Pa")
(assume "g" "g=Pa")
(cas "a=cS g" "Pa=g")
(use "OmegaTimes")
(use "∀xINDx0")
(auto)
(inst-with-to "g=Pa" 'right "g=PaR")
(simp "g=PaR")
(auto)

; ?_39: ex g.g<a & cS g=a

(use "P")
(use "sorda")

; ?_36: (SORD a -> F) ->

(assume "¬sorda")
(use "IndProg")
(assume "g" "g<a0")
(ca "ex z.z<a & g<(OP z 0)" "∃z<a.g<z0")
(ex-elim "∃z<a.g<z0")
(assume "z" "g<z0")
(use "LowerInd" (pt"OP z 0"))
(use "g<z0")
(use "∀xINDx0")
(use "g<z0")
(use "ExpCont")

; ?_64: LORD a

(use "SORDorLORD")
(auto)

; ok, ?_65 is proved in minimal propositional logic.  Proof finished.

; (cdp) ; OK

(save "LESSind")
(display-theorems "LESSind")




;;;;;; epsinulEff.scm : Efficiencytest ;;;;;;;;;

(load "~/minlog/examples/ordinals/e0eff.scm")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(load "~/minlog/examples/ordinals/e0end.scm")

; EOF