//
// CAEnums.cs: definitions used for CoreAnimation
// 
// Authors:
//   Geoff Norton
//   Miguel de Icaza
//
// Copyright 2009, Novell, Inc.
// Copyright 2010, Novell, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
using System;
using MonoMac.Foundation;
using System.Drawing;
using System.Runtime.InteropServices;
using MonoMac.CoreGraphics;

namespace MonoMac.CoreAnimation {

	[Flags]
	public enum CAEdgeAntialiasingMask {
		LeftEdge      = 1 << 0,
		RightEdge     = 1 << 1,
		BottomEdge    = 1 << 2,
		TopEdge       = 1 << 3,
		All = LeftEdge | RightEdge | BottomEdge | TopEdge,
		LeftRightEdges = LeftEdge | RightEdge,
		TopBottomEdges = TopEdge | BottomEdge
	}

#if MONOMAC
	[Flags]
	public enum CAAutoresizingMask {
		NotSizable   = 0,
		MinXMargin   = 1 << 0,
		WidthSizable = 1 << 1,
		MaxXMargin   = 1 << 2,
		MinYMargin   = 1 << 3,
		HeightSizable = 1 << 4,
		MaxYMargin   = 1 << 5
	}

	public enum CAConstraintAttribute {
		MinX,
		MidX,
		MaxX,
		Width,
		MinY,
		MidY,
		MaxY,
		Height,
	};
#endif
}
