#include <stdio.h>
#include <gtk/gtk.h>

#include "mplinux.h"

static gint ThreadRunning = 0;
static GThreadFunc UserFunc;
static GtkWidget* WaitDialog;
static ProgressFunc progress_func = NULL;


 void wait_dialog_Minimize(GtkButton *button, gpointer user_data) 
{

	if (GTK_WIDGET_REALIZED(GTK_WIDGET(MainWindow))) {
		gtk_window_iconify(GTK_WINDOW(MainWindow));	
	}

	gtk_window_iconify(GTK_WINDOW(WaitDialog));
}

gpointer thread_func(gpointer data) {
     gpointer ret;
     gdk_threads_leave();
     ret = UserFunc(data);     
     ThreadRunning = 0;
     return ret;
}


void wait_dialog_Response  (GtkDialog *dialog,
			    gint arg1,
			    gpointer user_data) {
    
    GtkWidget* label;

    if (arg1 != GTK_RESPONSE_CANCEL)
        return;

    label = (GtkWidget*) user_data;
    gtk_label_set_text(GTK_LABEL(label),"Cancelling... Please Wait");
    while (gtk_events_pending ())
	  gtk_main_iteration ();

}

gboolean wait_dialog_Check(GtkProgressBar* progressbar) {
   
     if (ThreadRunning) {
		 if (progress_func)
             // for some reason the gtk type checking dont work here
			 gtk_progress_bar_set_fraction(progressbar,progress_func());
		 else
			 gtk_progress_bar_pulse(GTK_PROGRESS_BAR(progressbar)); 
	  return TRUE;
     }

     if (WaitDialog)
	  gtk_dialog_response(GTK_DIALOG(WaitDialog),1);
     return FALSE;
}


gpointer CreateWaitDialog(GThreadFunc func,gpointer data,
			  CancelFunc cancel_func,ProgressFunc pfunc, gchar* text) {
     GThread* thread;
     gpointer ret;
     GtkWidget* label;
     GtkWidget* vbox;
     GtkWidget* progressbar;
	 GtkWidget* min_button;

     if (cancel_func)
	  WaitDialog = gtk_dialog_new_with_buttons(text,MainWindow,
				      GTK_DIALOG_MODAL & GTK_DIALOG_DESTROY_WITH_PARENT,
				      GTK_STOCK_CANCEL,GTK_RESPONSE_CANCEL,NULL);
     else
	  WaitDialog = gtk_dialog_new_with_buttons(text,MainWindow,
				      GTK_DIALOG_MODAL & GTK_DIALOG_DESTROY_WITH_PARENT,
				      NULL,NULL);

	gtk_window_set_default_size(GTK_WINDOW(WaitDialog),250,100);
    
	min_button = gtk_button_new_with_label(_("Minimize"));
	gtk_widget_set_size_request(min_button,0,0);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(WaitDialog)->action_area),min_button,FALSE,FALSE,0);
	gtk_box_reorder_child(GTK_BOX(GTK_DIALOG(WaitDialog)->action_area),min_button,0);
	g_signal_connect(min_button,"clicked",G_CALLBACK(wait_dialog_Minimize),NULL);
    
    label = gtk_label_new(text);
    g_signal_connect(GTK_OBJECT(WaitDialog),"response",G_CALLBACK(wait_dialog_Response),(gpointer)label);
	 progressbar =  gtk_progress_bar_new();
     gtk_progress_bar_set_pulse_step (GTK_PROGRESS_BAR(progressbar),0.05);
     //vbox = gtk_vbox_new(FALSE,0);
	 vbox = GTK_DIALOG(WaitDialog)->vbox;
     gtk_box_pack_start(GTK_BOX(vbox),label,TRUE,FALSE,0);
     gtk_box_pack_start(GTK_BOX(vbox),progressbar,TRUE,FALSE,5);
	 gtk_label_set_line_wrap(GTK_LABEL(label),TRUE);     
	  
     //gtk_container_add(GTK_CONTAINER(GTK_DIALOG(WaitDialog)->vbox),vbox);
     gtk_container_set_border_width(GTK_CONTAINER(WaitDialog),5);
//     gtk_window_set_decorated(GTK_WINDOW(WaitDialog),FALSE);
//     g_object_set(WaitDialog,"type",GTK_WINDOW_POPUP,NULL);
//     gtk_window_activate_focus (GTK_WINDOW(WaitDialog));
     if (GTK_WIDGET_REALIZED(GTK_WIDGET(MainWindow)))
	  if (gdk_window_get_state(GTK_WIDGET(MainWindow)->window) & GDK_WINDOW_STATE_ICONIFIED)
	       gtk_window_iconify(GTK_WINDOW(WaitDialog));
     gtk_widget_show_all(WaitDialog);

     UserFunc = func;
     ThreadRunning = 1;
     thread = g_thread_create(thread_func,data,TRUE,NULL);
	 if (pfunc != NULL)  
		 progress_func = pfunc;
	 else
		 progress_func = NULL;		 
     gtk_timeout_add (100,(GtkFunction)wait_dialog_Check,(gpointer)progressbar);
     if (gtk_dialog_run(GTK_DIALOG(WaitDialog)) == GTK_RESPONSE_CANCEL) {
	  gtk_widget_destroy(WaitDialog);
	  WaitDialog = NULL;
	  ThreadRunning = 0;
	  if (cancel_func) cancel_func(TRUE);
     }  
     else
	  gtk_widget_destroy(WaitDialog);
     
     

     ret = g_thread_join(thread);
     if (cancel_func) cancel_func(FALSE);
     return ret;
}
