# opam and other package managers: distributions list

This page tracks the state of binary packaging of opam on upstream
distributions. If you do package up opam for your various OS, please feel free
to add it below, update [this file](https://github.com/ocaml/opam/tree/master/doc/pages/Distribution.md)
and open a [pull request](https://github.com/ocaml/opam/compare).

Opam is in [![Packaging status](https://repology.org/badge/tiny-repos/opam.svg?header=)](https://repology.org/project/opam/versions) repository families.

The pages/files linked are the ones that give the best overview of the available
versions.

Those [_pkgs_](http://pkgs.org/search/opam) and
[_repology_]() pages may be used to
get an up-to-date overview of official packages on most Linux distributions.

## _Official_ packages

OS/distrubtion, their latest opam version and their maintainers:

* Arch Linux
 [![Arch package](https://repology.org/badge/version-for-repo/arch/opam.svg?header=)](https://www.archlinux.org/packages/?q=opam)
  * [Package search](https://www.archlinux.org/packages/community/x86_64/opam/)
  * Alexander F. Rødseth [@xyproto](https://github.com/xyproto)

* Debian Linux (9, oldstable, Stretch)
 [![Debian Oldstable package](https://repology.org/badge/version-for-repo/debian_oldstable/opam.svg?header=)](https://packages.debian.org/oldstable/source/opam)
  * [Package search](https://packages.debian.org/search?keywords=opam&searchon=names&suite=all&section=all)
  * Mehdi Dogguy [@mehdid](https://github.com/mehdid), nicoo [@nbraud](https://www.github.com/nbraud)

* Debian Linux (10, stable, Buster)
 [![Debian Stable package](https://repology.org/badge/version-for-repo/debian_stable/opam.svg?header=)](https://packages.debian.org/stable/source/opam)
  * [Package search](https://packages.debian.org/search?keywords=opam&searchon=names&suite=all&section=all)
  * Mehdi Dogguy [@mehdid](https://github.com/mehdid), nicoo [@nbraud](https://www.github.com/nbraud)

* Debian Linux (11, testing, Bullseye)
 [![Debian Testing package](https://repology.org/badge/version-for-repo/debian_testing/opam.svg?header=)](https://packages.debian.org/testing/source/opam)
  * [Package search](https://packages.debian.org/search?keywords=opam&searchon=names&suite=all&section=all)
  * Mehdi Dogguy [@mehdid](https://github.com/mehdid), nicoo [@nbraud](https://www.github.com/nbraud)

* Debian Linux (unstable, sid)
 [![Debian Unstable package](https://repology.org/badge/version-for-repo/debian_unstable/opam.svg?header=)](https://packages.debian.org/unstable/source/opam)
  * [Package search](https://packages.debian.org/search?keywords=opam&searchon=names&suite=all&section=all)
  * Mehdi Dogguy [@mehdid](https://github.com/mehdid), nicoo [@nbraud](https://www.github.com/nbraud)

* Fedora 32
 [![Fedora 32 package](https://repology.org/badge/version-for-repo/fedora_32/opam.svg?header=)](https://src.fedoraproject.org/rpms/opam)
  * [Package page](https://apps.fedoraproject.org/packages/opam)
  * Ben Rosser [@TC01](https://www.github.com/TC01)

* FreeBSD
 [![FreeBSD port](https://repology.org/badge/version-for-repo/freebsd/opam.svg?header=)](https://www.freshports.org/devel/ocaml-opam)
  * [Package search](http://www.freebsd.org/cgi/ports.cgi?query=opam&stype=all)
  * Hannes Mehnert [@hannesm](https://www.github.com/hannesm)

* Gnu Guix
 [![GNU Guix package](https://repology.org/badge/version-for-repo/gnuguix/opam.svg?header=)](https://guix.gnu.org/packages/opam-2.0.6/)
  * [Package definition](https://git.savannah.gnu.org/cgit/guix.git/tree/gnu/packages/ocaml.scm#n428)
  * Julien Lepiller [@roptat](https://github.com/roptat)

* Homebrew (macOS)
 [![Homebrew package](https://repology.org/badge/version-for-repo/homebrew/opam.svg?header=)](https://formulae.brew.sh/formula/opam)

* Macports (macOS)
 [![MacPorts package](https://repology.org/badge/version-for-repo/macports/opam.svg?header=)](https://ports.macports.org/port/opam/summary)
  * [Package definition](https://github.com/macports/macports-ports/blob/master/sysutils/opam/Portfile)
  * Perry E. Metzger [@pmetzger](https://www.github.com/pmetzger)

* Mageia Linux (Cauldron)
 [![Mageia Cauldron package](https://repology.org/badge/version-for-repo/mageia_cauldron/opam.svg?header=)](https://madb.mageia.org/package/show/source/1/application/0/release/cauldron/name/opam)
  * [Package definition](http://svnweb.mageia.org/packages/cauldron/opam/current/SPECS/opam.spec?view=markup)
  * David Geiger [@david-geiger](https://www.github.com/david-geiger)

* NixOS
 [![nixpkgs stable package](https://repology.org/badge/version-for-repo/nix_stable/opam.svg?header=)](https://github.com/NixOS/nixpkgs/blob/release-20.03/pkgs/development/tools/ocaml/opam/default.nix#L114)
  * [Package definitions](https://github.com/NixOS/nixpkgs/tree/master/pkgs/development/tools/ocaml/opam)
  * Henry Till

* OpenBSD
 [![OpenBSD port](https://repology.org/badge/version-for-repo/openbsd/opam.svg?header=)](http://openports.se/sysutils/opam)
  * [Package page](http://ports.su/sysutils/opam,-main)
  * Christopher Zimmerman [@madroach](https://github.com/madroach)

* OpenSuse (Tumbleweed)
 [![openSUSE Tumbleweed package](https://repology.org/badge/version-for-repo/opensuse_tumbleweed/opam.svg?header=)](https://build.opensuse.org/package/show/openSUSE:Factory/opam)
  * Anil Madhavapeddy [@avsm](https://www.github.com/avsm)

* Ubuntu Linux (16.04, LTS, xenial)
 [![Ubuntu 16.04 package](https://repology.org/badge/version-for-repo/ubuntu_16_04/opam.svg?header=)](https://packages.ubuntu.com/source/xenial/opam)
  * [Package search](http://packages.ubuntu.com/search?keywords=opam&searchon=names&suite=all&section=all) - bwrap unavailable

* Ubuntu Linux (18.04, LTS, bionic)
 [![Ubuntu 18.04 package](https://repology.org/badge/version-for-repo/ubuntu_18_04/opam.svg?header=)](https://packages.ubuntu.com/source/bionic/opam)
  * [Package search](http://packages.ubuntu.com/search?keywords=opam&searchon=names&suite=all&section=all)

* Ubuntu Linux (20.04, LTS, focal)
 [![Ubuntu 20.04 package](https://repology.org/badge/version-for-repo/ubuntu_20_04/opam.svg?header=)](https://packages.ubuntu.com/focal/opam)
  * [Package search](https://packages.ubuntu.com/search?keywords=opam&searchon=names&suite=focal&section=all)

* Ubuntu Linux (22.04, LTS, jammy)
 [![Ubuntu 22.04 package](https://repology.org/badge/version-for-repo/ubuntu_22_04/opam.svg?header=)](https://packages.ubuntu.com/jammy/opam)
  * [Package search](https://packages.ubuntu.com/search?keywords=opam&searchon=names&suite=jammy&section=all)

## Third party packages


* CentOS (6,7)
  * Anil Madhavapeddy [@avsm](https://www.github.com/avsm)

* Exherbo Linux
  * 1.1.1 [Package page](http://git.exherbo.org/summer/packages/dev-ocaml/opam/index.html) (_ocaml-unofficial_)
  * nicoo [@nbraud](https://www.github.com/nbraud)

* Ubuntu Linux PPA
  * 2.0.4 [Anil's official opam PPA](https://launchpad.net/~avsm) and [ppa post](https://discuss.ocaml.org/t/opam-2-0-experimental-ppas/2446)
  * Anil Madhavapeddy [@avsm](https://www.github.com/avsm)

* Windows
  * [MinGW repo](https://github.com/fdopen/opam-repository-mingw) - Andreas Hauptmann [@fdopen](https://www.github.com/fdopen)
  * David Allsopp [@dra27](https://www.github.com/dra27)

If you can't find latest version packages for your distribution here, see [the
opam installation page](Install.html) for binaries or building from source.

[Docker containers](http://hub.docker.com/r/ocaml/opam) for severals
distributions and OCaml compiler versions are also available.
