/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

class TestConvertCenterConversionQuality : public GTLTest::Case {
  public:
    TestConvertCenterConversionQuality() : GTLTest::Case("ConvertCenterConversionQuality")
    {
    }
    virtual void runTest()
    {
      ConvertCenter cc;
      GTLTEST_CHECK_EQUAL( cc.conversionQuality( GTLCore::Type::UnsignedInteger32, GTLCore::Type::UnsignedInteger32 ), GTLCore::ConvertCenter::NONEEDED_CONVERSION );
      GTLTEST_CHECK_EQUAL( cc.conversionQuality( GTLCore::Type::UnsignedInteger32, GTLCore::Type::Float32 ), GTLCore::ConvertCenter::LOSSLESS_CONVERSION );
      GTLTEST_CHECK_EQUAL( cc.conversionQuality( GTLCore::Type::Float16, GTLCore::Type::Float32 ), GTLCore::ConvertCenter::LOSSLESS_CONVERSION );
      GTLTEST_CHECK_EQUAL( cc.conversionQuality( GTLCore::Type::Float32, GTLCore::Type::Float16 ), GTLCore::ConvertCenter::LOSS_CONVERSION );
      GTLTEST_CHECK_EQUAL( cc.conversionQuality( GTLCore::Type::Float32, GTLCore::Type::UnsignedInteger32 ), GTLCore::ConvertCenter::LOSS_CONVERSION );
    }
};

class TestConvertCenterAutoConversion : public GTLTest::Case {
  public:
    TestConvertCenterAutoConversion() : GTLTest::Case("ConvertCenterAutoConversion")
    {
    }
    virtual void runTest()
    {
      ConvertCenter cc;
      cc.addAutoConversion( GTLCore::Type::UnsignedInteger32, GTLCore::Type::Integer32 );
      GTLTEST_CHECK_EQUAL( cc.autoConvertType( GTLCore::Type::UnsignedInteger32 ), GTLCore::Type::Integer32 );
      GTLTEST_CHECK_EQUAL( cc.autoConvertType( GTLCore::Type::Integer32 ), GTLCore::Type::Integer32 );
    }
};


class TestConvertCenter : public GTLTest::Suite {
  public:
    TestConvertCenter() : GTLTest::Suite("ConvertCenter")
    {
      addCase( new TestConvertCenterAutoConversion);
      addCase( new TestConvertCenterConversionQuality);
    }
};


