/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "GTLTest/Thread.h"

#ifdef GTLTEST_HAVE_THREAD

class MyThread1 : public GTLTest::Thread {
  public:
    MyThread1() : m_wasRunning(false)
    {
    }
    bool wasRunning() const
    {
      return m_wasRunning;
    }
  protected:
    virtual void run()
    {
      m_wasRunning = isRunning();
    }
  private:
    bool m_wasRunning;
};

class TestThread : public GTLTest::Case {
  public:
    TestThread() : GTLTest::Case("TestThread") {}
    virtual void runTest()
    {
      MyThread1 thread1;
      GTLTEST_CHECK(not thread1.wasRunning());
      GTLTEST_CHECK(not thread1.isRunning());
      thread1.start();
      thread1.wait();
      GTLTEST_CHECK(thread1.wasRunning());
      GTLTEST_CHECK(not thread1.isRunning());
    }
};

#endif
