/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "Library.h"

#include <llvm/ADT/StringRef.h>
#include <llvm/Support/DynamicLibrary.h>

#include <GTLFragment/LibraryCompilation_p.h>
#include "Wrapper_p.h"

namespace OpenRijn {
  
  struct Library::Private : GTLFragment::LibraryCompilation {
      GTL_NO_COPY(Private)
    public:
      Private() : libraryCompilation(0), m_wrapper(0) {}
      ~Private() { delete m_wrapper; }
      virtual void preCompilation() {
        if(libraryCompilation) libraryCompilation->preCompilation();
      }
      virtual void cleanup() {
        if(libraryCompilation) libraryCompilation->cleanup();
      }
      virtual void postCompilation() {
        if(libraryCompilation) libraryCompilation->postCompilation();
        llvm::sys::DynamicLibrary::LoadLibraryPermanently( _OPENRIJN_LIB_, 0 ); // This needed because when OpenShiva is used in a plugins, OpenShiva symbols aren't loaded globally and then llvm can't find them (FIXME move that somewhere else)
      }
      virtual void createWrapper(GTLCore::ModuleData* _moduleData, llvm::Module* module, int _channels, GTLFragment::WhichStdLibrary _library)
      {
        delete m_wrapper;
        if(libraryCompilation) {
          libraryCompilation->createWrapper(_moduleData, module, _channels, _library);
        } else {
          m_wrapper = new Wrapper(_moduleData, module, _library != GTLFragment::RijnWrappersLibrary );
        }
      }
      virtual void addOperatorOverloads(GTLCore::OperatorOverloadCenter*) {}
      virtual GTLFragment::Wrapper* wrapper() {
        return m_wrapper;
      }
      LibraryCompilation* libraryCompilation;
      Wrapper* m_wrapper;
  };
}
