###############################################################################
# OpenVAS Vulnerability Test
# $Id: aas_detect.nasl 7189 2010-03-31 13:58:50Z chandra $
#
# A A S Application Access Server Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "

 Overview:
  The A A S Application Access Server is running at this port. The A A S
  Application Access Server makes the PC administration possible
  over LAN and WANs. 

 See also:
  http://www.klinzmann.name/a-a-s/index_en.html

 Risk factor : None";

if (description)
{
 script_id(100196);
 script_version ("1.0");
 script_tag(name:"risk_factor", value:"None");

 script_name("A A S Application Access Server  Server Detection");  

 script_description(desc);
 script_summary("Checks for the presence of A A S Application Access Server ");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 6262);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");

port = get_http_port(default:6262);

if(!get_port_state(port))exit(0);

 url = string("/"); 
 req = http_get(item:url, port:port);
 buf = http_send_recv(port:port, data:req, bodyonly:FALSE);  

 if( buf == NULL )exit(0);
 if( egrep(pattern: 'Server: AAS', string: buf, icase: TRUE) )
 { 
   
    vers = string("unknown");

    ### try to get version.
    version = eregmatch(string: buf, pattern: 'Server: AAS/([0-9.]+)',icase:TRUE);
    
    if ( !isnull(version[1]) ) {
       vers=version[1];
    } 

    set_kb_item(name: string("www/", port, "/aas"), value: vers);	

    info = string("None\n\nA A S Application Access Server Version '");
    info += string(vers);
    info += string("' was detected on the remote host\n");

    desc = ereg_replace(
        string:desc,
        pattern:"None$",
        replace:info
    );    
       
       if(report_verbosity > 0) {
         security_note(port:port,data:string(desc));
         exit(0);
       }	 
  
 }

exit(0);
