# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1609-1 (lighttpd)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61357);
 script_cve_id("CVE-2008-0983", "CVE-2007-3948");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 1609-1 (lighttpd)";
 script_name(name);

 desc = "The remote host is missing an update to lighttpd
announced via advisory DSA 1609-1.

Several local/remote vulnerabilities have been discovered in lighttpd,
a fast webserver with minimal memory footprint.

The Common Vulnerabilities and Exposures project identifies the
following problems:

CVE-2008-0983
lighttpd 1.4.18, and possibly other versions before 1.5.0, does not
properly calculate the size of a file descriptor array, which allows
remote attackers to cause a denial of service (crash) via a large number
of connections, which triggers an out-of-bounds access.

CVE-2007-3948
connections.c in lighttpd before 1.4.16 might accept more connections
than the configured maximum, which allows remote attackers to cause a
denial of service (failed assertion) via a large number of connection
attempts.

For the stable distribution (etch), these problems have been fixed in
version 1.4.13-4etch9.

For the unstable distribution (sid), these problems have been fixed in
version 1.4.18-2.

We recommend that you upgrade your lighttpd package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201609-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1609-1 (lighttpd)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"lighttpd-doc", ver:"1.4.13-4etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lighttpd-mod-cml", ver:"1.4.13-4etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lighttpd", ver:"1.4.13-4etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lighttpd-mod-mysql-vhost", ver:"1.4.13-4etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lighttpd-mod-webdav", ver:"1.4.13-4etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lighttpd-mod-trigger-b4-dl", ver:"1.4.13-4etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lighttpd-mod-magnet", ver:"1.4.13-4etch9", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
