# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 457-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53155);
 script_cve_id("CVE-2004-0148", "CVE-2004-0185");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 457-1 (wu-ftpd)";
 script_name(name);

 desc = "The remote host is missing an update to wu-ftpd
announced via advisory DSA 457-1.

Two vulnerabilities were discovered in wu-ftpd:

CVE-2004-0148 - Glenn Stewart discovered that users could bypass the
directory access restrictions imposed by the restricted-gid option by
changing the permissions on their home directory.  On a subsequent
login, when access to the user's home directory was denied, wu-ftpd
would fall back to the root directory.

CVE-2004-0185 - A buffer overflow existed in wu-ftpd's code which
deals with S/key authentication.

For the stable distribution (woody) these problems have been fixed in
version 2.6.2-3woody4.

For the unstable distribution (sid) these problems have been fixed in
version 2.6.2-17.1.

We recommend that you update your wu-ftpd package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20457-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 457-1 (wu-ftpd)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"wu-ftpd-academ", ver:"2.6.2-3woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wu-ftpd", ver:"2.6.2-3woody4", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
