###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for cups FEDORA-2007-1219
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861193);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2007-1219");
  script_cve_id("CAN-2005-0064");
  script_name( "Fedora Update for cups FEDORA-2007-1219");
  desc = "

  Vulnerability Insight:
  The Common UNIX Printing System provides a portable printing layer for
  UNIX operating systems. It has been developed by Easy Software Products
  to promote a standard printing solution for all UNIX vendors and users.
  CUPS provides the System V and Berkeley command-line interfaces.


  Affected Software/OS:
  cups on Fedora Core 5

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-March/msg00042.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of cups");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC5")
{

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.2.8~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/cups-lpd", rpm:"x86_64/cups-lpd~1.2.8~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/cups-devel", rpm:"x86_64/cups-devel~1.2.8~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/cups", rpm:"x86_64/cups~1.2.8~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/cups-libs", rpm:"x86_64/cups-libs~1.2.8~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/cups-debuginfo", rpm:"x86_64/debug/cups-debuginfo~1.2.8~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/cups-devel", rpm:"i386/cups-devel~1.2.8~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/cups-libs", rpm:"i386/cups-libs~1.2.8~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/cups-debuginfo", rpm:"i386/debug/cups-debuginfo~1.2.8~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/cups-lpd", rpm:"i386/cups-lpd~1.2.8~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/cups", rpm:"i386/cups~1.2.8~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}