##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_magic_iso_maker_detect.nasl 1564 2009-04-08 11:40:24Z apr $
#
# Magic ISO Maker Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http//intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800272);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Magic ISO Maker Version Detection");
  desc = "
  Overview : This script finds the installed version of Magic ISO Maker
  and sets the result in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set Version of Magic ISO Maker in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

if(!registry_key_exists(key:key)){
    exit(0);
}

foreach item (registry_enum_keys(key:key))
{
  name = registry_get_sz(key:key + item, item:"DisplayName");
  if("Magic ISO Maker" >< name)
  {
    ver = eregmatch(pattern:"v([0-9.]+) \(build ([0-9]{3,})\)", string:name);
    if((ver[1] != NULL && ver[2] != NULL))
    {
      set_kb_item(name:"MagicISOMaker/Ver", value:ver[1] + "." + ver[2]);
      security_note(data:"Magic ISO Maker version " + ver[1] + "." + ver[2] +
                      " was detected on the host");
    }
    exit(0);
  }
}
