#
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
#  (C) Tenable Network Security
#
#  Ref: ned <nd@felinemenace.org>
#
#  This script is released under the GNU GPL v2
#

if(description)
{
 script_id(15397);
 script_cve_id("CVE-2004-2027");
 script_bugtraq_id(10311);
 script_xref(name:"OSVDB", value:"6075");
 script_version ("$Revision: 8231 $");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 
 name = "ICECast HTTP basic authorization DoS";
 script_name(name);
 
 desc = "
The remote server runs ICECast 2.0.0, an open source streaming audio 
server.

This version is affected by a remote denial of service.

An remote attacker could send specially crafted URL, with a long string
passed in an Authorization header that will result in a loss of availability 
for the service.

*** OpenVAS reports this vulnerability using only
*** information that was gathered.

Solution : Upgrade to a newer version.
Risk factor : High";


 script_description(desc);
 summary = "Check icecast version";
 script_summary(summary);
 script_category(ACT_GATHER_INFO);
 script_copyright("This script is Copyright (C) 2004 David Maciejak");
 script_family("Denial of Service");
 script_dependencie("http_version.nasl");
 script_require_ports("Services/www", 8000);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");

port = get_http_port(default:8000);
if(!port) exit(0);

banner = tolower(get_http_banner(port:port));
if (! banner ) exit(0);
if("icecast/" >< banner && egrep(pattern:"icecast/2\.0\.0[^0-9])", string:banner))
      security_hole(port);
