###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_changetrack_detect.nasl 4842 2009-09-23 13:14:29Z sep $
#
# Changetrack Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900867);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Changetrack Version Detection");
  desc = "
  Overview: This script detects the installed version of Changetrack and
  sets the reuslt in KB.

  Risk Factor: None";

  script_description(desc);
  script_summary("Set KB for the version of Changetrack");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

change_sock = ssh_login_or_reuse_connection();
if(!change_sock){
  exit(0);
}

paths = find_file(file_name:"changetrack",file_path:"/", useregex:TRUE,
                  regexpar:"$", sock:change_sock);

foreach binName (paths)
{
  ctrack_ver = get_bin_version(full_prog_name:chomp(binName), version_argv:"-v",
                               ver_pattern:"([0-9]\.[0-9.]+)",sock:change_sock);
  if(ctrack_ver[1] != NULL){
    set_kb_item(name:"Changetrack/Ver", value:ctrack_ver[1]);
    security_note(data:"Changetrack version " + ctrack_ver[1] +
             " running at location " + binName + " was detected on the host");
  }
}
ssh_close_connection();
