###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_irfanview_int_overflow_vuln.nasl 3004 2009-06-19 15:17:24Z jun $
#
# IrfanView Integer Overflow Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900377);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-2118");
  script_bugtraq_id(35423);
  script_name("IrfanView Integer Overflow Vulnerability");
  desc = "

  Overview: This host has IrfanView installed and is prone to Integer Overflow
  vulnerability.

  Vulnerability Insight:
  This flaw is generated because the application fails to perform proper
  boundary checks while opening a specially crafted TIFF 1 BPP images
  which can exploited to cause a heap based buffer overflow.

  Impact:
  Successful exploitation will let the attacker to cause Integer Overflow when
  screen fitting option is enabled.

  Impact Level: Application

  Affected Software/OS:
  IrfanView version prior to 4.25

  Fix: Upgrade to version 4.25
  http://www.irfanview.com

  References:
  http://secunia.com/advisories/35359
  http://www.irfanview.com/main_history.htm

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.0
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of IrfanView");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_irfanview_detect.nasl");
  script_require_keys("IrfanView/Ver");
  exit(0);
}


include("version_func.inc");

irViewVer = get_kb_item("IrfanView/Ver");
if(!irViewVer){
  exit(0);
}

# Check for IrfanVies version < 4.25
if(version_is_less(version:irViewVer, test_version:"4.25")){
  security_hole(0);
}
