###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-056.nasl 5263 2009-10-14 03:48:09Z oct $
#
# Microsoft Windows CryptoAPI X.509 Spoofing Vulnerabilities (974571)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900876);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-2510", "CVE-2009-2511");
  script_bugtraq_id(36475, 36577);
  script_name("Microsoft Windows CryptoAPI X.509 Spoofing Vulnerabilities (974571)");
  desc = "
  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-056.

  Vulnerability Insight:
  - The issue is caused due to the Windows CryptoAPI incorrectly parsing a null
    terminator as the end of any values identified by an Object Identifier (OID)
    when processing ASN.1 information from X.509 certificates.
  - An integer overflow error in the Windows CryptoAPI when parsing ASN.1 object
    identifiers from X.509 certificates, which could allow an attacker to
    generate a malicious certificate that would be parsed incorrectly by the
    Windows CryptoAPI.

  Impact:
  Successful exploitation will let the attacker to conduct spoofing attacks on
  the affected system.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows 2K  Service Pack 4 and prior.
  Microsoft Windows XP  Service Pack 3 and prior.
  Microsoft Windows 2K3 Service Pack 2 and prior.

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link.
  http://www.microsoft.com/technet/security/bulletin/ms09-056.mspx

  References:
  http://support.microsoft.com/kb/974571
  http://www.vupen.com/english/advisories/2009/2891
  http://www.microsoft.com/technet/security/bulletin/MS09-056.mspx

  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of msasn1.dll file");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:4, win2k:5, win2003:3) <= 0){
  exit(0);
}

# MS09-056 Hotfix check
if(hotfix_missing(name:"974571") == 0){
  exit(0);
}

dllPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!dllPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                    string:dllPath + "\msasn1.dll");

dllVer = GetVer(file:file, share:share);
if(!dllVer){
  exit(0);
}

# Windows 2K
if(hotfix_check_sp(win2k:5) > 0)
{
  # Grep for msasn1.dll version < 5.0.2195.7334
  if(version_is_less(version:dllVer, test_version:"5.0.2195.7334")){
    security_hole(0);
  }
}

#  Windows XP
else if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for msasn1.dll < 5.1.2600.3624
    if(version_is_less(version:dllVer, test_version:"5.1.2600.3624")){
      security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 3" >< SP)
  {
    # Grep for msasn1.dll < 5.1.2600.5875
    if(version_is_less(version:dllVer, test_version:"5.1.2600.5875")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
# Windows 2003
else if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for msasn1.dll version < 5.2.3790.4584
    if(version_is_less(version:dllVer, test_version:"5.2.3790.4584")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
