###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_strongswan_n_openswan_dos_vuln_jun09.nasl 3120 2009-06-30 20:34:33Z jun $
#
# StrongSwan/Openswan Denial Of Service Vulnerability June-09
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900386);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-2185");
  script_bugtraq_id(35452);
  script_name("StrongSwan/Openswan Denial Of Service Vulnerability June-09");
  desc = "

  Overview: The host is installed with strongSwan/Openswan and is prone to Denial of
  Service vulnerability.

  Vulnerability Insight:
  - Error in 'ASN.1' parser in pluto/asn1.c, libstrongswan/asn1/asn1.c, and
    libstrongswan/asn1/asn1_parser.c is caused via an 'X.509' certificate
    with crafted Relative Distinguished Names (RDNs), a crafted UTCTIME string,
    or a crafted GENERALIZEDTIME string.

  Impact:
  Successful exploitation will let the attacker to cause pluto IKE daemon crash.

  Impact Level: Application

  Affected Software/OS:
  OpenSwan version 2.6 before 2.6.22 and 2.4 before 2.4.15
  strongSwan version 2.8 before 2.8.10, 4.2 before 4.2.16, and 4.3 before 4.3.2

  Fix:
  Upgrade to OpenSwan version 2.6.22 or 2.4.15
  http://www.openswan.org/code
  Upgrade to strongSwan version 2.8.10 or 4.2.16 or 4.3.2
  http://www.strongswan.org/

  References:
  http://secunia.com/advisories/35522
  http://www.vupen.com/english/advisories/2009/1639

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of strongSwan/Openswan");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_openswan_detect.nasl",
                      "gb_strongswan_detect.nasl");
  script_require_keys("Openswan/Ver", "StrongSwan/Ver");
  exit(0);
}


include("version_func.inc");

if(!get_udp_port_state(500)){
  exit(0);
}

oswanVer = get_kb_item("Openswan/Ver");
if(oswanVer != NULL)
{
  # Grep for OpenSwan version prior to 2.6 < 2.6.22 and 2.4 < 2.4.15
  if(version_in_range(version:oswanVer, test_version:"2.6", test_version2:"2.6.21")||
     version_in_range(version:oswanVer, test_version:"2.4", test_version2:"2.4.14")){
    security_warning(port:500, proto:"udp");
  }
}

sswanVer = get_kb_item("StrongSwan/Ver");
if(sswanVer != NULL)
{
  # Grep for strongSwan version prior to 2.8 < 2.8.10, 4.2 < 4.2.16, and 4.3 < 4.3.2
  if(version_in_range(version:sswanVer, test_version:"2.8", test_version2:"2.8.9") ||
     version_in_range(version:sswanVer, test_version:"4.2", test_version2:"4.2.15")||
     version_in_range(version:sswanVer, test_version:"4.3", test_version2:"4.3.1")){
    security_warning(port:500, proto:"udp");
  }
}
