###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_systemtap_detect.nasl 5480 2009-10-28 15:21:24Z oct $
#
# SystemTap Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901036);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("SystemTap Version Detection");
  desc = "
  Overview: This script detects the installed version of SystemTap and
  sets the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Sets KB for the version of SystemTap");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

paths = find_bin(prog_name:"stap", sock:sock);
foreach sytemtapbin (paths)
{
  sytemtapVer = get_bin_version(full_prog_name:chomp(sytemtapbin), sock:sock,
                version_argv:"-V",ver_pattern:"version ([0-9.]+)");

  if((sytemtapVer[1] != NULL) && ("SystemTap" >< sytemtapVer)){
    set_kb_item(name:"SystemTap/Ver", value:sytemtapVer[1]);
    security_note(data:"SystemTap version " + sytemtapVer[1] + " running at " +
                       "location " + sytemtapbin + " was detected on the host");
  }
}
ssh_close_connection();
