/***************************************************************************
 *
 *   BSD LICENSE
 * 
 *   Copyright(c) 2007-2022 Intel Corporation. All rights reserved.
 *   All rights reserved.
 * 
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 * 
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in
 *       the documentation and/or other materials provided with the
 *       distribution.
 *     * Neither the name of Intel Corporation nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 * 
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 *
 ***************************************************************************/
#include "cpa.h"
#include "adf_io_cfg.h"
#include "icp_adf_accel_mgr.h"

CpaStatus icp_adf_cfgGetParamValue(icp_accel_dev_t *accel_dev,
                                   const char *pSection,
                                   const char *pParamName,
                                   char *pParamValue)
{
    return adf_io_cfgGetParamValue(
        accel_dev, pSection, pParamName, pParamValue);
}

Cpa32S icp_adf_cfgGetDomainAddress(Cpa16U accelId)
{
    return adf_io_cfgGetDomainAddress(accelId);
}

Cpa16U icp_adf_cfgGetBusAddress(Cpa16U accelId)
{
    return adf_io_cfgGetBusAddress(accelId);
}

/*
 * icp_adf_cfgCheckUserSection
 * check if user process section exists in device cfg
 */
int icp_adf_cfgCheckUserSection(int dev_id, uint8_t *pSectionPresent)
{
    return adf_io_cfgCheckUserSection(dev_id, pSectionPresent);
}

CpaStatus icp_adf_resetDevice(Cpa32U accelId)
{
    if (!icp_adf_isDevIdValid(accelId))
    {
        return CPA_STATUS_FAIL;
    }

    return adf_io_reset_device(accelId);
}

CpaBoolean icp_adf_isDeviceAvailable(void)
{
    return adf_io_isDeviceAvailable();
}
