#include "txwidget.h"
#include "ui_txwidget.h"
#include <QTimer>
#include "configparams.h"
#include "txfunctions.h"
#include "dispatcher.h"
#include "supportfunctions.h"
#include "gallerywidget.h"

#include "ui_freqform.h"
#include "ui_sweepform.h"
#include "cameracontrol.h"
#include "videocapture.h"

txWidget::txWidget(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::txWidget)
{
    ui->setupUi(this);
    readSettings();
    connect(ui->modeComboBox,SIGNAL(activated(int)),SLOT(slotModeChanged(int )));
    connect(ui->templatesComboBox,SIGNAL(currentIndexChanged(int)),SLOT(slotGetParams()));
    connect(ui->templateCheckBox,SIGNAL(toggled(bool)),SLOT(slotGetParams()));
    connect(ui->cwCheckBox,SIGNAL(toggled(bool)),SLOT(slotGetParams()));
    connect(ui->voxCheckBox,SIGNAL(toggled(bool)),SLOT(slotGetParams()));
    connect(ui->toCallLineEdit,SIGNAL(editingFinished ()),SLOT(slotGetParams()));
    connect(ui->operatorLineEdit,SIGNAL(editingFinished ()),SLOT(slotGetParams()));
    connect(ui->rsvLineEdit,SIGNAL(editingFinished ()),SLOT(slotGetParams()));
    connect(ui->comment1LineEdit,SIGNAL(editingFinished ()),SLOT(slotGetParams()));
    connect(ui->comment2LineEdit,SIGNAL(editingFinished ()),SLOT(slotGetParams()));
    connect(ui->comment3LineEdit,SIGNAL(editingFinished ()),SLOT(slotGetParams()));
    connect(ui->startToolButton, SIGNAL(clicked()), this, SLOT(slotStartTX()));
    connect(ui->stopToolButton, SIGNAL(clicked()), this, SLOT(slotStopTX()));
    connect(ui->generateToneToolButton, SIGNAL(clicked()), this, SLOT(slotGenerateSignal()));
    connect(ui->sweepToneToolButton, SIGNAL(clicked()), this, SLOT(slotSweepSignal()));
    connect(ui->repeaterToneToolButton, SIGNAL(clicked()), this, SLOT(slotGenerateRepeaterTone()));
    connect(ui->openToolButton, SIGNAL(clicked()), this, SLOT(slotFileOpen()));
 //   connect(ui->actionAlignement, SIGNAL(activated()), this, SLOT(slotAlignementSignal()));
    connect(ui->editToolButton, SIGNAL(clicked()), this, SLOT(slotEdit()));
 //   connect(ui->actionReplay, SIGNAL(activated()), this, SLOT(slotReplay()));
    connect(ui->snapshotToolButton, SIGNAL(clicked()), this, SLOT(slotSnapshot()));




}

txWidget::~txWidget()
{
    delete ui;
}

void txWidget::init()
{
  origImage=NULL;
  resultImage=NULL;
  ed=NULL;
  repeaterIndex=0;
  txViewer=ui->imageFrame;
  txViewer->setMinimumSize(325,261);
  initView();

  repeaterTimer=new QTimer(this);
  connect(repeaterTimer,SIGNAL(timeout()),SLOT(slotRepeaterTimer()));
  connect(dispatchPtr,SIGNAL(statusMessageTX(QString)),SLOT(slotDisplayStatusMessage(QString)));
  repeaterTimer->start(60000*repeaterImageInterval);


  ui->imageFrame->enablePopup(FALSE);
  slotModeChanged(modeIndexTx);
}

void txWidget::readSettings()
{
  QSettings qSettings;
  qSettings.beginGroup("TX");
  modeIndexTx=((esstvMode)qSettings.value("modeIndexTx",0).toInt());
  templateIndex=qSettings.value("templateIndex",0).toInt();
  useTemplate=qSettings.value("useTemplate",FALSE).toBool();
  useCW=qSettings.value("useCW",FALSE).toBool();
  useVOX=qSettings.value("useVOX",FALSE).toBool();
  qSettings.endGroup();
  setParams();

}

void txWidget::writeSettings()
{
  QSettings qSettings;
  slotGetParams();
  qSettings.beginGroup("TX");
  qSettings.setValue( "modeIndexTx", modeIndexTx);
  qSettings.setValue( "templateIndex", templateIndex);
  qSettings.setValue( "useTemplate", useTemplate);
  qSettings.setValue( "useVOX", useVOX);
  qSettings.setValue( "useCW", useCW);
  qSettings.endGroup();
}

void txWidget::slotGetParams()
{
  int temp=modeIndexTx;
  getIndex(temp,ui->modeComboBox);
  modeIndexTx=esstvMode(temp);
  getIndex(templateIndex,ui->templatesComboBox);
  getValue(useTemplate,ui->templateCheckBox);
  getValue(useVOX,ui->voxCheckBox);
  getValue(useCW,ui->cwCheckBox);

  getValue(toCall,ui->toCallLineEdit);
  getValue(toOperator,ui->operatorLineEdit);
  getValue(rsv,ui->rsvLineEdit);
  getValue(comment1,ui->comment1LineEdit);
  getValue(comment2,ui->comment2LineEdit);
  getValue(comment3,ui->comment3LineEdit);



  if(!dispatchPtr->txBusy()) applyTemplate();

}

void txWidget::setParams()
{
  setIndex(((int)modeIndexTx),ui->modeComboBox);

  setIndex(templateIndex,ui->templatesComboBox);
  setValue(useTemplate,ui->templateCheckBox);
  setValue(useVOX,ui->voxCheckBox);
  setValue(useCW,ui->cwCheckBox);
}

void txWidget::initView()
{

  int i;
  for(i=0;i<NUMSSTVMODES-1;i++) // exclude Calibrate
    {
      ui->modeComboBox->addItem(getSSTVModeNameLong((esstvMode)i));
    }
  ui->modeComboBox->setCurrentIndex((int)modeIndexTx);
  setupTemplatesComboBox();
   ui->progressBar->setRange(0,100);
}

void txWidget::setupTemplatesComboBox()
{
  QStringList sl;
   int i;
  ui->templatesComboBox->clear();
  sl=galMW->getFilenames();
  for(i=0;i<sl.count();i++)
  {
    ui->templatesComboBox->insertItem(i,sl.at(i));
  }
   ui->templatesComboBox->setCurrentIndex(templateIndex);
}

void  txWidget::setPreviewWidget(QString fn)
{
   ui->previewWidget->open(fn,FALSE);
}




void txWidget::slotStartTX()
{

  slotGetParams();
  if(!txViewer->hasValidImage())
  {
    QMessageBox::warning(this,"TX Error","No image loaded");
    return;
  }
  dispatchPtr->sendImage();
  statusBarPtr->showMessage("Starting Transmit");
}


void txWidget::slotStopTX()
{
  addToLog("txWidget: aborting Image",DBTXFUNC);
  dispatchPtr->restartRX();
  statusBarPtr->showMessage("Transmit Stopped");
}

void txWidget::slotDisplayStatusMessage(QString s)
{
    statusBarPtr->showMessage(s);
}


//void txWidget::slotReplay()
//{
//  QString fn;
//  QImage *im=NULL;
//  fn=galMW->getLastRxImage();
//  editorScene scene(0);
//  QFile f(fn);
//  if(!scene.load(f))
//    {
//      QMessageBox::warning(this,"Image Properties","Error while loading\n" + fn);
//      return;
//    }
//  im=scene.renderImage();
//  dispatchPtr->setTXImage(im);
//  slotStartTX();
//}


void txWidget::slotFileOpen()
{
  QImage *im=NULL;
  dirDialog dd(this,0,TRUE);
  QString s=dd.openFileName(txImagesPath,"*");
  if (s.isEmpty()) return;
  editorScene scene(0);
  QFile f(s);
  if(!scene.load(f))
    {
      QMessageBox::warning(this,"Image Properties","Error while loading\n" + s);
      return;
    }
  im=scene.renderImage();
  dispatchPtr->setTXImage(im);
}

void txWidget::slotGenerateSignal()
{
  QDialog qd;
   Ui::freqForm *ff=new Ui::freqForm;

  ff->setupUi(&qd);
  int freq;
  int  duration;
  if(qd.exec())
    {
      getValue(freq,ff->frequencySpinBox);
      getValue(duration,ff->durationSpinBox);
      dispatchPtr->sendTone((double)duration,(double)freq);
    }
}

void txWidget::slotSweepSignal()
{
  QDialog qd;
 Ui::sweepForm *ff=new Ui::sweepForm;
  ff->setupUi(&qd);
  int upperFreq;
  int lowerFreq;
  int  duration;
  if(qd.exec())
    {
      getValue(lowerFreq,ff->lowerFrequencySpinBox);
      getValue(upperFreq,ff->upperFrequencySpinBox);
      getValue(duration,ff->durationSpinBox);
      dispatchPtr->sendSweepTone((double)duration,(double)lowerFreq,(double)upperFreq);
    }
}






void txWidget::slotGenerateRepeaterTone()
{
  dispatchPtr->sendTone(3.,1750);
}



void txWidget::slotEdit()
{
  if (ed!=NULL) delete ed;
  ed=new editor(this);
  if(dispatchPtr->txBusy())
    {
      QMessageBox::warning(this,"Editor","Transmission busy, editor not available");
      return;
    }
  connect(ed,SIGNAL(imageAvailable(QImage *)),SLOT(setImage(QImage *)));
  ed->setImage(txViewer->getOriginalImagePtr());
  ed->show();
}


void txWidget::slotModeChanged(int m)
{
  addToLog("slotModeChange",DBTXMAIN);
  modeIndexTx=(esstvMode)m;
  dispatchPtr->setupTX(modeIndexTx);
  applyTemplate();
}



void txWidget::addConversion(editorScene &tscene,QChar tag,QString value)
{
  sconvert cnv;
  cnv.tag=tag;
  cnv.replacement=value;
  tscene.convertList.append(cnv);
}



/** \todo overlay not correct when using modes that are different from 320,256 */
/** \todo implement repeater */
void txWidget::applyTemplate()
{
  //slotGetParams();
  dispatchPtr->setupTX(modeIndexTx);
  addToLog("apply temlate",DBTXMAIN);
  sconvert cnv;
  //if(txViewer->getImagePtr(txSSTVParam.numberOfPixels,txSSTVParam.numberOfDisplayLines)==NULL) return;
  if (origImage==NULL) return;
  editorScene tscene(0);
  if(resultImage)	delete resultImage;
  QFile fi(galMW->getTemplateFileName(ui->templatesComboBox->currentIndex()));

  if(!fi.fileName().isEmpty())
  {
    tscene.load(fi);
    tscene.convertList.clear();
    addConversion(tscene,'c',toCall);
    addConversion(tscene,'r',rsv);
    addConversion(tscene,'o',toOperator);
    addConversion(tscene,'t',QDateTime::currentDateTime().toUTC().toString("hh:mm"));
    addConversion(tscene,'d',QDateTime::currentDateTime().toUTC().toString("yyyy/MM/dd"));
    addConversion(tscene,'m',myCallsign);
    addConversion(tscene,'q',myQth);
    addConversion(tscene,'l',myLocator);
    addConversion(tscene,'n',myLastname);
    addConversion(tscene,'f',myFirstname);
    addConversion(tscene,'v',qsstv_version);
    addConversion(tscene,'x',comment1);
    addConversion(tscene,'y',comment2);
    addConversion(tscene,'z',comment3);
    addToLog(QString("txfunctions applyTemplate size=%1,%2").arg(tscene.width()).arg(tscene.height()),DBTXMAIN);
    resultImage=new QImage(origImage->scaled(tscene.width(),tscene.height())); // same resolution as template
    /*	if(repeaterEnable)
        {
          resultImage=new QImage(mCanvas.overlay(orgImage,repeaterTemplate)->copy());
       }
      else*/
      if(useTemplate)
        {
          tscene.overlay(resultImage);
          txViewer->open(*tscene.getImagePtr());
        }
      else
        {
          txViewer->open(*resultImage);
        }
      txViewer->adaptImage(txSSTVParam.numberOfPixels,txSSTVParam.numberOfDisplayLines);
    }
  else
    {
      resultImage=new QImage(origImage->scaled(txSSTVParam.numberOfPixels,txSSTVParam.numberOfDisplayLines));
      txViewer->open(*resultImage);
    }
}

void 	txWidget::setImage(QImage *ima)
{
  if (origImage) delete origImage;
  origImage=new QImage(ima->copy());
  addToLog(QString("txfunctions setImage size=%1,%2").arg(origImage->width()).arg(origImage->height()),DBTXMAIN);
  txViewer->open(*origImage);
//  txViewer->fitToWindow(TRUE);
  applyTemplate();
}

void 	txWidget::setImage(QString fn)
{

  if(txViewer->open(fn))
    {
      if (origImage) delete origImage;
      origImage=new QImage(txViewer->getImagePtr()->copy());
      addToLog(QString("txfunctions setImage size=%1,%2").arg(origImage->width()).arg(origImage->height()),DBTXMAIN);
      applyTemplate();
    }
}


void txWidget::setProgress(uint prg)
{
  ui->progressBar->setValue(prg);
}


/** \todo implement repeater */

// void txWidget::repeat(QImage *im,esstvMode sm)
void txWidget::repeat(QImage *,esstvMode )
{
/*	setValue((int)sm,ui->modeComboBox);
  txf->setModeIndex((sstvMode)sm);
//	slotModeChanged(sm);

  txf->setImage(im);
  dsp->setCaptureSource(TRUE,NULL,FALSE);
  txf->process();*/
}

void txWidget::slotRepeaterTimer()
{
  QString fn;
  QFile fi;
  if(dispatchPtr->txBusy()) repeaterTimer->start(60000*repeaterImageInterval);

  else if ((dispatchPtr->rxBusy()) || (!repeaterEnable))
    {
      // wait 10 seconds and check if busy or repeaterEnable has changed
      repeaterTimer->start(10000);
    }
  else
    {
      switch(repeaterIndex)
        {
          case 0:
            fn=repeaterImage1;
          break;
          case 1:
            fn=repeaterImage2;
          break;
          case 2:
            fn=repeaterImage3;
          break;
          case 3:
            fn=repeaterImage4;
          break;
          default:
            fn=repeaterImage1;
          break;
        }
      fi.setFileName(fn);
      if (fi.exists())
        {
          slotModeChanged(repeaterTxMode);
          setImage(fn);
        }
      repeaterIndex++;
      if(repeaterIndex>3) repeaterIndex=0;
      repeaterTimer->start(60000*repeaterImageInterval);
      //QApplication::processEvents();
      startAutoRepeaterEvent* ce = new startAutoRepeaterEvent();
      QApplication::postEvent(dispatchPtr, ce );
    }
}



void txWidget::slotSnapshot()
{
  cameraControl cc(this);
  if(cc.exec())
    {
      setImage(cc.getImage());
    }
}
