#define XERR
#include "loop.ih"

void Loop::preScreen()
{
    // see prescreen.txt

    if (d_nRounds == 0)         // no scenario rounds, no pre-screening
        return;

    g_log << "\nLoop::preScreen\n";

    double age0 = d_screening.roundAge(0);  // using the complement of the
    if (                                    // prescreen in the original code
        d_naturalDeathAge >= age0
        and
        (
            not d_tumor.selfDetectable()
            or
            d_tumor.selfDetectAge() >= age0
        )
    )
    {
        g_log << "   case alive and no (detectable) tumor before age " <<
                 age0 << ": no preScreen\n";
        return;
    }

    if (                        // pre-screening is performed:
        not d_tumor.selfDetectable() or
        (
            d_tumor.selfDetectable()
            and
            d_naturalDeathAge < d_tumor.selfDetectAge()
        )
    )
    {
        g_log << "  *** preTumorDeath: case died naturally\n";
        preTumorDeath();    // natural death: no tumor or not self-detected
    }
    else
    {
        g_log <<
            "  *** self detected: case self-detected a tumor and leaves\n";
        selfDetected(); // self detected the tumor before the screening   .ih
    }
}
