-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (SP_Parser_Goto)
function SP_Goto (CST : SP_Productions.Valid_States;
                  CSY : SP_Symbols.SP_Non_Terminal) return SP_Productions.SP_State is
   Index_Pair                   : Packed_GOT_Index_Pair;
   Index, Max_Index             : GOT_Index;
   Feasible_State, Return_State : SP_Productions.SP_State;
begin
   Index_Pair     := Non_Term_Table (CSY);
   Index          := GOT_Index (Index_Pair mod GOT_Index_Size);
   Max_Index      := GOT_Index (Index_Pair / GOT_Index_Size);
   Feasible_State := SP_Productions.SP_State (Goto_Table (Index) mod State_Size);
   while Feasible_State /= CST and then Index < Max_Index loop
      Index          := Index + 1;
      Feasible_State := SP_Productions.SP_State (Goto_Table (Index) mod State_Size);
   end loop;
   if Feasible_State /= CST then
      Return_State := 0;
   else
      Return_State := SP_Productions.SP_State ((Goto_Table (Index) / State_Size) mod State_Size);
   end if;
   return Return_State;
end SP_Goto;
