/* ====================================================================
 * Copyright (c) 2006-2009  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "WcView.h"
#include "WcViewModel.h"
#include "WcViewWhatsThis.h"
#include "WcViewTreeWidget.h"
#include "WcViewTreeItemModel.h"
#include "WcViewStatus.h"
#include "TabWidget.h"

// qt
#include <QtGui/QLayout>
#include <QtGui/QTabBar>
#include <QtGui/QTabWidget>
#include <QtGui/QComboBox>
#include <QtGui/QLabel>
#include <QtGui/QToolButton>
#include <QtGui/QStatusBar>
#include <QtGui/QCheckBox>
#include <QtGui/QWhatsThis>


WcView::WcView( ID id, WcViewModel* model, ActionStorage* actions,
  QWidget* parent )
: super(parent), _id(id), _model(model)
{
  QGridLayout* gl = new QGridLayout( this, 1, 1 );
  gl->setContentsMargins(0,0,0,2);
  gl->setVerticalSpacing(4);

  _tabs = new TabWidget(this);
  gl->addWidget( _tabs, 0, 0 );
  gl->setRowStretch( 0, 3 );

  _itemModel  = new WcViewTreeItemModel( _model->getRootPath(),
    new WcViewStatusData() /*todo take ownership*/ );


  WcViewTreeWidget* w1 = new WcViewTreeWidget(_model,_itemModel,
    actions,_tabs);
  w1->setWcViewType(true);
  _tabs->addTab( w1, "--" );

#if 0
  WcViewTreeWidget* w2 = new WcViewTreeWidget(model,actions,_tabs);
  w2->setWcViewType(false);
  _tabs->addTab( w2, "--" );
#endif

  connect(
    w1,   SIGNAL(rootChanged(QString,QString)),
    this, SLOT(rootChange(QString,QString)) );
#if 0
  connect(
    w2,   SIGNAL(rootChanged(QString,QString)),
    this, SLOT(rootChange(QString,QString)) );
#endif
  setTitle( w1,
    QString::fromUtf8(model->getRootPath()),
    QString::fromUtf8(model->getRootUrl()) );
#if 0
  setTitle( w2,
    QString::fromUtf8(model->getRootPath()),
    QString::fromUtf8(model->getRootUrl()) );
#endif

  //_tabs->addTab( new QWidget(_tabs), "ChangeSets" );
  QWhatsThis::add( this, WcViewWhatsThis::get() );
}

ID WcView::getId() const
{
  return _id;
}

void WcView::rootChange( QString path, QString url )
{
  QWidget* w = dynamic_cast<QWidget*>(QObject::sender());
  setTitle(w,path,url);
}

void WcView::setTitle( QWidget* w, QString path, QString url )
{
  static QString TipFormat("%1 (%2)");

  _tabs->setTabTitle(w, path);
  _tabs->setTabTooltip(w, TipFormat.arg(path).arg(url));
}
